/*
 * Kernel header file for Linux crash dumps.
 *
 * Created by: Matt Robinson (yakker@sgi.com)
 *
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 * 
 */

/* This header file holds the architecture specific crash dump header */
#ifndef _ASM_VMDUMP_H
#define _ASM_VMDUMP_H

/* necessary header files */
#include <asm/ptrace.h>                          /* for pt_regs             */

/* definitions */
#define DUMP_ASM_MAGIC_NUMBER     0xdeaddeadULL  /* magic number            */
#define DUMP_ASM_VERSION_NUMBER   0x3            /* version number          */


/*
 * Structure: dump_header_asm_t
 *  Function: This is the header for architecture-specific stuff.  It
 *            follows right after the dump header.
 */
typedef struct _dump_header_asm_s {

        /* the dump magic number -- unique to verify dump is valid */
        uint64_t             dha_magic_number;

        /* the version number of this dump */
        uint32_t             dha_version;

        /* the size of this header (in case we can't read it) */
        uint32_t             dha_header_size;

        /* pointer to pt_regs */
	struct pt_regs      *dha_pt_regs;

	/* the dump registers */
	struct pt_regs       dha_regs;

        /* the rnat register saved after flushrs */
        uint64_t             dha_rnat;

	/* the pfs register saved after flushrs */
	uint64_t             dha_pfs;

	/* the bspstore register saved after flushrs */
	uint64_t             dha_bspstore;

} dump_header_asm_t;

#ifdef __KERNEL__
extern void __dump_open(struct file *, uint64_t);
extern void __dump_init(uint64_t);
extern int __dump_configure_header(dump_header_asm_t *, struct pt_regs *);
#endif

#endif /* _ASM_VMDUMP_H */
