/* 
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <klib.h>
#define __KERNEL__
#include <asm/page.h>
#undef __KERNEL__

/* define architecture dependent global variables
 */
lkcdinfo_t lkcdinfo = { ARCH_PARISC, 32, BIG_ENDIAN, 0, PAGE_SHIFT,
                PAGE_SIZE, PAGE_MASK, PAGE_OFFSET, 0 };
unsigned long NUM_PHYSPAGES;
kaddr_t KL_LOCORE_ADDR;
#ifdef LOCORE_START
kaddr_t KL_LOCORE_START = LOCORE_START;
#else
kaddr_t KL_LOCORE_START = 0xffffffffffffffff;
#endif
kaddr_t MEM_MAP;

/** Function prototypes
 **/

int kl_init_kern_info(void);

int kl_get_struct(
	kaddr_t 	/* address */, 
	int 		/* size of struct */, 
	void *		/* ptr to buffer */, 
	char *		/* name of struct */);

void *kl_get_ra(void);
