/*
 * savecrash.c -- dump save utility
 * Copyright 2002 Bruno Vidal (bruno_vidal@hp.com), all rights reserved.
 * This source code is released under the terms of version 2 of the GNU GPL.
 */

static char *SccsId = "@(#)savecrash $Revision: 2.1$  $Date: 2003/04/07 bruno_vidal@hp.com\n";

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <crashtool.h>
#include <linux/module.h>
#include <linux/dump.h>

#define DUMP_DEVICE	"/dev/dump"
#define DUMP_TRUE	1
#define DUMP_FALSE	0

char *device_name, *crash_dir;
int verbose_set=0,resave_set=0, chunk_max=8, compression_flag=0, old_fashion_flag=0;

extern
size_t
bzip_uncompressBlock ( unsigned char *in_buf,
                       unsigned char *out_buf,
                       size_t num_in_buf,
                       size_t num_out_buf,
                       int param );

void usage(char *cmd)
{
	char *base;

	base=basename(cmd);
        printf("Usage: %s [-d device_name] [-D crash directory] {-c nb} {-z} {-f} {-r} {-o} {-v} {-V} {-h}\n", base);
	printf("\t-d : device where dump is.\n");
	printf("\t-D : where to put the dump.\n");
	printf("\t-c : number of image/core files (1<nb<16).\n");
	printf("\t-z : use gzip compression.\n");
	printf("\t-f : flag the dump as saved but do nothing.(not yet available)\n");
	printf("\t-r : resave a flagged dump.\n");
	printf("\t-o : old dump fashion (ie: core file)\n");
	printf("\t-v : verbose mode\n");
	printf("\t-V : print version.\n");
	printf("\t-h : print this help.\n");
	/* -T is debug mode, but is is an hide option */
} 

/*
 * Name: main()
 */
int
main(int argc, char **argv)
{
	dev_t dnum;
	int flag_dump_set = DUMP_FALSE, device_name_set = DUMP_FALSE;
	int crash_dir_set = DUMP_FALSE, crash_chunk_set = DUMP_FALSE;
	int compression_set = DUMP_FALSE, version_set = DUMP_FALSE;
	int old_fashion_set = DUMP_FALSE, debug_set = DUMP_FALSE, fd, err, c, ret=0;
	struct stat stbuf;
	
	/* check for root */
	if (getuid() != 0) {
		fprintf(stderr, "Error: You must run this program as root!\n");
		return (1);
	}

	/* walk through the options */
	while ((c = getopt(argc, argv, "d:D:rfc:zovVhT")) > 0) {
		switch (c) {
			case 'T':
				if (debug_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				debug_set = DUMP_TRUE;
				break;

			case 'f':
				if (flag_dump_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				flag_dump_set = DUMP_TRUE;
				break;

			case 'd':
				if (device_name_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				device_name_set = DUMP_TRUE;
				device_name = optarg;
				break;

			case 'D':
				if (crash_dir_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				crash_dir_set = DUMP_TRUE;
				crash_dir = optarg;
				break;

			case 'c':
				if (crash_chunk_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				crash_chunk_set = DUMP_TRUE;
				chunk_max=atoi(optarg);
				if ( chunk_max < 1 || chunk_max > 16 ) {
					usage(argv[0]);
					exit(1);
				}
				break;

			case 'o':
				if (old_fashion_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				old_fashion_set = DUMP_TRUE;
				old_fashion_flag = DUMP_TRUE;
				break;

			case 'V':
                                if (version_set == DUMP_TRUE) {
                                       	usage(argv[0]);
					exit(1); 
                                }
                                version_set = DUMP_TRUE;
                                break;
			
			case 'r':
				if (resave_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				resave_set = DUMP_TRUE;
				break;

			case 'z':
				if (compression_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				compression_set = DUMP_TRUE;
				compression_flag = 1;
				break;

			case 'v':
				if (verbose_set == DUMP_TRUE) {
					usage(argv[0]);
					exit(1);
				}
				verbose_set = DUMP_TRUE;
				break;
		
			case 'h':
				usage(argv[0]);
				exit(0);

			default:
				usage(argv[0]);
				exit(1);	
		}
	}

	/* first, write version if needed */
	if (version_set == DUMP_TRUE) {
		printf("Version: %s",SccsId);
	}

	/* make sure there -d and -D */
	if (crash_dir_set == DUMP_TRUE) {
		if (device_name_set == DUMP_FALSE) {
			fprintf(stderr,"Error: need at leat a dump device\n");
			usage(argv[0]);
			return(1);
		}
	} else {
		fprintf(stderr,"Error: need a crash directory\n");
		usage(argv[0]);
		return(1);
	}

	/* retrive the dnum */ 
	if (device_name_set == DUMP_TRUE) {
		if ((fd = open(device_name, O_RDONLY)) < 0) {
			perror("open of device name");
			return (fd);
		}
		if ((err = fstat(fd, &stbuf)) < 0) {
			perror("fstat of device name");
			close(fd);
			return (err);
		}
		dnum = stbuf.st_rdev;
		close(fd);
		ret=kl_dump_retrieve(device_name,crash_dir, debug_set);
	}
	return(ret);
}

void savecrash_gentitle(line,total)
char    *line;
int     total;
{
  int   i,y;

  printf("%s",line);
  i=total-strlen(line);
  if (i > 0 ) {
    for(y=0;y<i;y++) {
        printf(".");
    }
  }
}
