/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Linker information definitions in support of CONVEX development tools
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef CNX_TOOLS

#include <stdio.h>
#include <unistd.h>
#include <limits.h>

#ifndef PATH_MAX
#define PATH_MAX 1023
#endif

#include "spacehdr.h"
#include "scnhdr.h"

#include "std.h"
#include "ldlimits.h"
#include "spaces.h"
#include "subspaces.h"
#include "compunit.h"
#include "cnx_link_info.h"
#include "libraries.h"
#include "driver.h"
#include "linker.h"
#include "ld_strings.h"

int CNX_SUBSPACE_MAP_subsp_index = BAD_SUBSP;
struct cnx_object_dictionary_record *cnx_subspace_map = 0;
struct cnx_object_dictionary_header _cnx_subspace_map_header;
struct cnx_object_dictionary_header* cnx_subspace_map_header = &_cnx_subspace_map_header;

int CNX_COMPILE_MAP_subsp_index = BAD_SUBSP;
struct cnx_compile_dictionary_record *cnx_compile_map = 0;
struct cnx_compile_dictionary_header _cnx_compile_map_header;
struct cnx_compile_dictionary_header* cnx_compile_map_header = &_cnx_compile_map_header;

/* ================================================================================
   Note: only make this call if an executable is being created (i.e. not a shared 
         library, relocatable...)    
   -------------------------------------------------------------------------------- */
void cnx_build_link_info_subspaces() 
{ 
   struct space_dictionary_record *space;
   struct subspace_dictionary_record *subsp;
   struct subsp_misc_record *misc;

   CNX_SUBSPACE_MAP_subsp_index = build_subspace("$TOOLS_SUBSPACE_MAP$", "$TOOLS$", 78, 
                                                  WILDCARD_ACCESS, 0, 16, 4, 0, 
                                                  sizeof(struct cnx_object_dictionary_header));
            
   subsp = &Subsp_Dict(CNX_SUBSPACE_MAP_subsp_index);
   misc = &Subsp_Misc(CNX_SUBSPACE_MAP_subsp_index);
   space = &space_array[subsp->space_index];
   space->is_loadable = FALSE;   
   space->is_private  =  1;   
   subsp->is_loadable = FALSE;
   subsp->fixup_request_quantity = 0; 
   misc->subsp_data = (char *)cnx_subspace_map_header;  
   misc->data_file_offset = IN_MEMORY;  

   CNX_COMPILE_MAP_subsp_index = build_subspace("$TOOLS_COMPILE_MAP$", "$TOOLS$", 78, 
                                                  WILDCARD_ACCESS, 0, 24, 4, 0, 
                                                  sizeof(struct cnx_compile_dictionary_header));
            
   subsp = &Subsp_Dict(CNX_COMPILE_MAP_subsp_index);
   misc = &Subsp_Misc(CNX_COMPILE_MAP_subsp_index);
   space = &space_array[subsp->space_index];
   space->is_loadable = FALSE;   
   space->is_private  =  1;   
   subsp->is_loadable = FALSE;
   subsp->fixup_request_quantity = 0; 
   misc->subsp_data = (char *)cnx_compile_map_header;  
   misc->data_file_offset = IN_MEMORY;  
}
/* ================================================================================ */

/* ================================================================================ */
void cnx_subspace_map_create() 
{ 
    int num_entries = 0; 
    int total_size = 0; 
    struct space_dictionary_record *space;
    void *m = 0;   
    int new_sp_index, sp_index;
    char *path;

    if (CNX_SUBSPACE_MAP_subsp_index == BAD_SUBSP) return;

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
        sp_index = sp_remap[new_sp_index];   
        if (((space_array[sp_index].subspace_quantity == 0) &&
             (space_array[sp_index].loader_fix_quantity == 0) &&
             (space_array[sp_index].init_pointer_quantity == 0)))
             continue;

           num_entries += space_array[sp_index].subspace_quantity;       
           }

    total_size = sizeof(struct cnx_object_dictionary_header) + 
                 num_entries * sizeof(struct cnx_object_dictionary_record);

    if (verbose & V_DEBUG) 
       printf("subspace map maximum entries = %d (%d bytes)\n ", num_entries, total_size); 
 
    m = (void *)ecalloc(1, total_size);
    if (m) {
       struct subspace_dictionary_record *subsp;
       struct subsp_misc_record *misc;

       cnx_subspace_map_header = (struct cnx_object_dictionary_header *) m; 
       cnx_subspace_map_header->version = CNX_OBJECT_DICTIONARY_REVNO;   

       cnx_subspace_map = (struct cnx_object_dictionary_record*) (cnx_subspace_map_header + 1);

       subsp = &Subsp_Dict(CNX_SUBSPACE_MAP_subsp_index);
       misc = &Subsp_Misc(CNX_SUBSPACE_MAP_subsp_index);

       subsp->subspace_length = total_size; 
       subsp->initialization_length = total_size; 
       misc->subsp_data = (char*) m; 
       }
}
/* ================================================================================ */

/* ================================================================================ */
void cnx_subspace_map_add(space_index, subsp_index, subsp, misc) 
unsigned int space_index;
unsigned int subsp_index;
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
{ 
    static char* obj_fname = 0; 
    static unsigned int obj_index = 0;
    unsigned int start; 
    unsigned int length = subsp->subspace_length; 

    if (CNX_SUBSPACE_MAP_subsp_index == BAD_SUBSP) return;
    if (!length) return; 

    cnx_subspace_map[cnx_subspace_map_header->entries].space     = space_index;
    cnx_subspace_map[cnx_subspace_map_header->entries].subspace  = subsp_index;

    if (misc) {
       if (obj_fname != misc->obj_fname) { 
          obj_fname = misc->obj_fname; 
          obj_index = (obj_fname) ? string_offset_linear(obj_fname, &space_strings) : 0;
          }
       cnx_subspace_map[cnx_subspace_map_header->entries].object = obj_index;
       } 
    else  
       cnx_subspace_map[cnx_subspace_map_header->entries].object = 0;

    start = (misc) ? misc->new_subspace_start : subsp->subspace_start;
    cnx_subspace_map[cnx_subspace_map_header->entries].start     = start;
    cnx_subspace_map[cnx_subspace_map_header->entries].length    = length;

    (cnx_subspace_map_header->entries)++;
}
/* ================================================================================ */

/* ================================================================================ */
void cnx_compile_map_create() 
{ 
    int num_entries = compiler_dict_total; 
    int total_size = 0; 
    void *m = 0;   

    if (CNX_COMPILE_MAP_subsp_index == BAD_SUBSP) return;

    total_size = sizeof(struct cnx_compile_dictionary_header) + 
                 num_entries * sizeof(struct cnx_compile_dictionary_record);

    if (verbose & V_DEBUG)
       printf("compile map maximum entries = %d (%d bytes)\n ", num_entries, total_size); 
 
    m = (void *)ecalloc(1, total_size);
    if (m) {
       int i, unit_index; 
       struct subspace_dictionary_record *subsp;
       struct subsp_misc_record *misc;
       struct header_node *comp_area, *next;
       unsigned int obj_index = 0;
       char *path;
       char buf[PATH_MAX+1];

       cnx_compile_map_header = (struct cnx_compile_dictionary_header *) m; 
       cnx_compile_map_header->version = CNX_COMPILE_DICTIONARY_REVNO;   

       cnx_compile_map = (struct cnx_compile_dictionary_record*) (cnx_compile_map_header + 1);

       subsp = &Subsp_Dict(CNX_COMPILE_MAP_subsp_index);
       misc = &Subsp_Misc(CNX_COMPILE_MAP_subsp_index);

       subsp->subspace_length = total_size; 
       subsp->initialization_length = total_size; 
       misc->subsp_data = (char*) m; 

       if (getcwd(buf, PATH_MAX+1)) {
          char* pathname;
          int path_index; 
          pathname = add_string(&space_strings, buf, 0, FALSE, FALSE);
          path_index = (pathname) ? string_offset_linear(pathname, &space_strings) : 0;
          cnx_compile_map_header->path = path_index;
          }
 
       unit_index = 0; 
       for (i = 0, comp_area = compiler_head; i < num_entries, comp_area; i++, comp_area = next) {
          cnx_compile_map[i].unit = unit_index;
          obj_index = (comp_area->obj_fname) ? string_offset_linear(comp_area->obj_fname, &space_strings) : 0;
          cnx_compile_map[i].object = obj_index;
          unit_index += comp_area->size / sizeof(struct compilation_unit);
          next = comp_area->next;
	  }
       cnx_compile_map_header->entries = i;
       }
}
/* ================================================================================ */

#endif /*CNX_TOOLS */

