/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
***************************************************************************
**
** File:         debug_opt.h
**
** Description:  Debug line table interface file. 
**
**
***************************************************************************
*/

#define _DOC_DISABLED  -2 
#define _DOC_ERROR     -1
#define _DOC_INIT	0
#define _DOC_NEW	1
#define _DOC_BUILD	2
#define _DOC_SEEN	3
#define _DOC_ESC	4


extern int	doc_state;	/* state of debug line tables mechanism */
extern int	doc_lines_subsp;/* subspace index of $LINES$ subspace   */
extern size_t	doc_table_size;	/* size of the all the line tables      */


#define doc_enabled	(doc_state > _DOC_INIT)
#define doc_disabled	(doc_state == _DOC_DISABLED)
#define doc_initialized	(doc_state == _DOC_INIT)


extern void doc_init_pass1(void);
extern void doc_post_pass1(void);
extern void doc_init_pass2(void);
extern void doc_finish(void);

extern void doc_count_escape(unsigned int);
extern void doc_count_new(void);
extern void doc_count_end(void);
extern void doc_count_entry(unsigned int, unsigned int);

extern void doc_gen_escape(unsigned char, unsigned int);
extern void doc_gen_new(unsigned char, unsigned int, int);
extern void doc_gen_end(void);
extern void doc_gen_entry(unsigned int, unsigned int);
