
/*  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#ifndef DEBUG
#define NDEBUG
#endif 

#ifdef FDP_CODE
#include <assert.h>

#include "filehdr.h"
#include "aouthdr.h"
#include "scnhdr.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "ldnls.h"
#include "ldlimits.h"
#include "linker.h"
#include "stdlib.h"
#include "ld_strings.h"
#include "string.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "libraries.h"


#define HASHTABSIZ  529 /* a prime number */

extern char *fdp_counter_file_name; 

extern Boolean do_dbg_fdp;

struct fdpnode {
  struct fdpnode * next;
  char  *name;
  unsigned int hashval;
  int index;
  char * file;
  unsigned int som_index_this_file;  /* how many SOMs preceed this in "file"? */
  unsigned char type;
  Boolean mq;
};

typedef struct fdpnode *fdpnode_ptr;

/*
typedef struct fdp_node  HASH_CELL, * HASH_CELL_PTR;
typedef HASH_CELL_PTR     * HASH_TABLE;
*/

fdpnode_ptr * FDP_hash_table;

extern fdpnode_ptr * create_hash_table();
extern fdpnode_ptr   find_hash_key();
extern fdpnode_ptr   insert_hash_key();
extern void          clear_hash_table();

void spawn_call_graph_tool ()
/* This procedure execs the fdp call graph analysis tool with a line like:
 *   /bin/fdp flow.data a.out > link_order_file
 */
{
    char *fdp_call_graph_tool_path;
    char *exec_string;
    int err;

    fdp_call_graph_tool_path = getenv("ST_FDP");
    if (!fdp_call_graph_tool_path)
        fdp_call_graph_tool_path = FDP_CALL_GRAPH_TOOL_PATH;
#ifdef PBO_IPO
    if (verbose & (V_WHY | V_PBO))
#else
    if (verbose & V_WHY)
#endif
        info_message(INVOKE_FDP_TOOL, fdp_call_graph_tool_path, 0);
    if (access(fdp_call_graph_tool_path, 1) != 0) {
        warning(CANT_EXEC_FDP_TOOL, fdp_call_graph_tool_path, 0);
      }
    else {
        exec_string = emalloc(strlen(fdp_call_graph_tool_path) + 
			      strlen(fdp_counter_file_name) + 
			      strlen(fdp_output_name) +
			      strlen(fdp_link_order_file_name) + 10);
        strcpy(exec_string, fdp_call_graph_tool_path);
        strcat(exec_string, " ");
        strcat(exec_string, fdp_counter_file_name);
        strcat(exec_string, " ");
        strcat(exec_string, fdp_output_name);
        strcat(exec_string, " > ");
        strcat(exec_string, fdp_link_order_file_name);
	if (fdp_verbose)
           info_message(INVOKE_FDP_TOOL, exec_string, 0);

        err = system(exec_string);
        if (err < 0) {
            warning(CANT_EXEC_FDP_TOOL, fdp_call_graph_tool_path, 0);
	} else if (err > 0) {
	    warning(ERROR_EXEC_FDP_TOOL, fdp_call_graph_tool_path, 0);
	}
        efree(exec_string);
      }
  }

static void fdp_dup_sym_found();
static void fdp_sym_not_found();


/* read the FDP link order file and check the symbols */
get_FDP_list() {
    char buf[128]; 
    char pbuf[256];
    char *func_name, *file_name;
    int ind;
    unsigned int hashval;
    struct subsp_misc_record *misc;
    unsigned int som_index_this_file;  /* how many SOMs preceeded this? */

    Boolean mq;
    int knt = 0;
    char *c, *delimiter;

    if (fdp_link_order_file == NULL) {
      spawn_call_graph_tool();
      fdp_link_order_file = efopen(fdp_link_order_file_name,"r",CANT_OPEN);
    }

    /* parse each line of the link order file */
    while ( fscanf(fdp_link_order_file, "%s\n", buf) != EOF ) {	
        /* The string (buf) is of the form "foo,123",
					or "foo:main.o,123",
					or "foo:main.o[2],123" */
	som_index_this_file = 0;
	delimiter = ":";

        if (   (func_name = (MB_CUR_MAX == 1 
			         ? strtok(buf, delimiter)
			         : mb_strtok(buf, delimiter))) 
	    != NULL) 
	    {
	    delimiter = "[";  /* catch name only, not the subspace number */
            file_name = (MB_CUR_MAX == 1 
				? strtok(NULL, delimiter) 
				: mb_strtok(NULL, delimiter));
	    /* file_name == NULL if the string is of the form "foo,123" */
	    delimiter = "]";
	    /* parse the SOM index within "file_name" */
	    c = (MB_CUR_MAX == 1 
		     ? strtok(NULL, delimiter)
	             : mb_strtok(NULL, delimiter));
	    /* c == NULL if the string is of the form "foo:main.o,123" */
	    som_index_this_file = (c == NULL) ? 0 : atoi(c);
	    delimiter = ":";  /* reset to issue error msgs with good syntax */
            }
        else 
	    continue;  /* scans any blank lines erroneously inserted */

	mq = (file_name != NULL);

	hashval = hash_string(func_name);

	ind = FDP_find(func_name,mq,file_name,hashval,
					som_index_this_file,ST_ENTRY);

	if (ind == BAD_SYM) {
	    if (file_name == NULL) {
		c = func_name;
		}
	    else { 
		if (MB_CUR_MAX == 1)
		    sprintf(pbuf, 
			    "%.39s%s%.39s", 
			    file_name, 
			    delimiter, 
			    func_name);
		else
		    sprintf(pbuf, 
			    "%s%s%.39s", 
			    pad_string(0, 0, 39, file_name), 
			    delimiter, 
			    func_name);

		c = pbuf;
		}
	    fdp_sym_not_found(c,file_name);
	  }
	else {
	    misc = &Subsp_Misc(Sym_Subsp(ind));

	    if (!do_dbg_fdp && misc->obj_has_dbg) {
		/* if the subspace comes from an object file that contains
		 * debug information, we do not reorder using FDP unless 
		 * the user specifically specifies the -Pd option
		 */

		misc->FDP_order_specified = 0;
	    } else {
		if (misc->FDP_order_specified != 0) {
		    if (file_name == NULL) {
			file_name = misc->file_name;
		    }
		    fdp_dup_sym_found(func_name, file_name);
	        }
		else {
		    /* make FDP_order_specifed to be very negative to */
		    /* force ordered subspaces with the same key to   */
		    /* appear before non-ordered ones 		  */
		    misc->FDP_order_specified = (-0x0fffffff) + ++knt; 
		}
	    }
	}
    }
    clear_hash_table(FDP_hash_table);
}


/******************************************************************************
* FUNCTION :            FDP_find_som_index_this_file   
*
* ARGUMENTS:
*       sym_index - the symbol table index of the symbol to be looked up.
*
* RETURN VALUE:
*       som_index_this_file - the number of SOMs seen in this .o file before
*       		      the current SOM.  Used to differentiate local
*			      symbols in separate SOMs within the same .o file.
*
* PURPOSE:
*       This routine finds the index of this symbol's source SOM within a .o
*       file containing (possibly) many SOMs.  It looks up the symbol by name
*       in the "FDP_hash_table", then returns the value stored in that
*	struct by FDP_add (called from symbol_add, where a global of the same
*	name "som_index_this_file" is maintained by "som_file_add".
*
* ALGORITHM:
*       Find correct hash bucket by name, then linear search for fdpnode
*	with "index" field matching "sym_index".
*
******************************************************************************/

int FDP_find_som_index_this_file(sym_index)
register int sym_index;
{
    register struct symbol_dictionary_record *sym;
    register fdpnode_ptr n;

    sym = &Sym_Dict(sym_index);

    n = find_hash_key(FDP_hash_table, sym->NAME_PT);

    /* Search the hash bucket for the right match */
    while ((n != NULL) && (n->index!=sym_index)) {
        n = n->next;
	}
    assert ((n != NULL) && (n->index==sym_index));  /* must be found, we just
							put it there. */

    return(n->som_index_this_file);
}


int FDP_find(name,mq,file_name,hashval,som_index_this_file,type)
char *name, *file_name;
register unsigned int hashval;
unsigned int som_index_this_file;  /* how many SOMs preceeded this? */
register int type;
register Boolean mq;
{
  register fdpnode_ptr n;
  fdpnode_ptr first_found = NULL;

/* We want the first UNIVERSAL symbol that matches, 
   or first local symbol read in if no UNIVERSAL matches */

  if ( verbose & V_PBO)	
    printf("FDP_find: %s %s ", name, file_name);
  n = find_hash_key(FDP_hash_table, name);
  
  /* Search the hash bucket for the right match */
  while (n != NULL) {
    if (n->hashval==hashval && 
	fdpnode_match(n,name,mq,file_name,som_index_this_file,type)) {
      if (Sym_Dict(n->index).symbol_scope == SS_UNIVERSAL) {
	if ( verbose & V_PBO)	
	  printf ("found. (Universal)\n");
	return (n->index);
      }
      else
	first_found = n;
    }
    n = n->next;
  }

  if (first_found != NULL) {
    if (verbose & V_PBO)	
      printf ("found. (Local) \n");
    return (first_found->index);
  }
  else {
    if (verbose & V_PBO)	
      printf ("not found \n");
    return (BAD_SYM);
  }
}


FDP_add(name,mq,file_name,hashval,index,type)
char *name, *file_name;
register unsigned int hashval;
int index;
Boolean mq;
unsigned char type;
{
  unsigned int hashkey;
  register fdpnode_ptr n;
  Boolean newmq;

  if (FDP_hash_table == NULL) {
    FDP_hash_table = create_hash_table(HASHTABSIZ, sizeof(struct fdpnode));
  }

  if (verbose & V_PBO)	
    printf("FDP_add: %s %s ", name, file_name); 

  newmq = mq;

  /* Look up name.  If found, return found symbol index. */
  n = find_hash_key(FDP_hash_table, name);
  while (n != NULL) {
    /*
     * Always adding to the hash table. Because we need the right  
     * index for FDP_find_som_index_this_file().
     * The old test for matching name will not add a local sym entry
     * to the FDP_hash_table if there exists one with the same name
     * (even if the one in the hash table is an universal),
     * yet when we search to find the som_index_this_file, we would
     * look for the matching index of the symbol in the hash table.
     */

    if (n->hashval == hashval) {
      if (!mq && !n->mq && 
	  fdpnode_match(n, name, 0, NULL, som_index_this_file, type)) {
	if (n->file != NULL )
	  n->mq = TRUE;
	if (file_name != NULL)
	  newmq = TRUE;
      }
    }
    n = n->next;
  }

 /* Entry not found. Let us add a new one. */
  n = insert_hash_key(FDP_hash_table, name);

  n->type = type;
  n->hashval = hashval;
  n->index = index;
  n->file = file_name;
  /* Entry Universal symbols do not need the various SOMs in a concatenated */
  /* file disambiguated, and this field is forced to zero in get_FDP_list() */
  /* if no number in brackets is found.  Entry Locals are left with it set, */
  /* but it will be zero for non-concatenated SOMs anyway.                  */
  n->som_index_this_file =
    (Sym_Scope(index) == SS_LOCAL) ? som_index_this_file : 0;
  n->mq   = newmq;

  if (verbose & V_PBO)	
    printf ("added \n");

} /* End FDP_add() */

fdpnode_match(n,name,mq,qname,som_index_this_file,type)
fdpnode_ptr n;
Boolean mq;
char * name, * qname;
unsigned int som_index_this_file;  /* how many SOMs preceeded this? */
unsigned char type;
{

  if (strcmp(n->name, name))
    return FALSE;
  if (n->type != type)
    return FALSE;
  if (mq && n->file == NULL)
    return FALSE;
  if (n->mq && qname == NULL)
    return FALSE;
  if (qname != NULL && 
      n->file != NULL && 
      strcmp(n->file, qname) != 0)
    return FALSE;
  if (n->som_index_this_file != som_index_this_file)
    return FALSE;
  return TRUE;
}

/******************************************************************************
******************************************************************************
 This routine is no longer used. We need to add to the table if symbols
 have the same names because 1 could be an Univ. and others could be
 locals.
******************************************************************************

fdpnode_same(n,name,qname,som_index_this_file,type)
fdpnode_ptr n;
char * name, * qname;
unsigned int som_index_this_file;  
unsigned char type;
{

  if (strcmp(n->name, name))
    return FALSE;
  if (n->type != type)
    return FALSE;
  if (qname != NULL && n->file == NULL)
    return FALSE;
  if (qname != NULL && strcmp(n->file, qname) != 0)
    return FALSE;
  if (n->som_index_this_file != som_index_this_file)
    return FALSE;
  return TRUE;
}

******************************************************************************
*****************************************************************************/
static void fdp_sym_not_found(c,file_name)
char *c, *file_name;
{

  /* There are some procedures that are used in the -I phase
   * and appear in the flow.data but are not used during the -P
   * phase. This is because the counter printing routines are
   * added during -I (/lib/icrt0.o) but at the -P we link with 
   * the executable with /lib/crt0.o.
   * Remember that these warning will not be issued if any of 
   * these routines are also called by the user code which should
   * be the case most of the time. This routine will not even
   * called in those cases.
   */
  
  /* The list looks long and formidable but only in rare cases
     long sequences of the following if condition will get 
     executed. 
  */
#ifdef V4FS
  char * syms = "/usr/lib/libc.a(getenv.o):nvmatch \
  /usr/lib/libc.a(fopen.o):do_open  /usr/lib/libc.a(malloc.o):grow_arena \
  /usr/lib/libc.a(malloc.o):tree_delete  /usr/lib/libc.a(malloc.o):tree_insert \
  /usr/lib/libc.a(malloc.o):node_alloc \
  __fflush _atexit  _brk  _clear_counters  _close  _doprnt  _exit \
  _findiop  _filbuf  _fopen  _ioctl  _lseek  _mcount  _memcpy \
  _open  _read  _sigsetreturn  _start  _stat  _write  _wrtchk \
  _xflsbuf  atexit  brk  db_allocate_subentry  exit  fclose \
  fflush  fopen  fread  free  fseek  ftell  fwrite  getenv \
  isatty  malloc  mmap  printf  realloc  sbrk  $cerror  $$mulI \
  $$mulU  _fclose  _fflush  _fprintf  _fread  _fseek  _ftell \
  _fwrite  _getenv  _memset  _perror  _sleep  _strcat  _strcmp \
  _strcpy  _strlen  _strrchr  _tempnam _unlink  stat";
#else /* V4FS */
  char * syms = "/lib/libc.a(getenv.o):nvmatch \
  /lib/libc.a(fopen.o):do_open  /lib/libc.a(malloc.o):grow_arena \
  /lib/libc.a(malloc.o):tree_delete  /lib/libc.a(malloc.o):tree_insert \
  /lib/libc.a(malloc.o):node_alloc \
  __fflush _atexit  _brk  _clear_counters  _close  _doprnt  _exit \
  _findiop  _filbuf  _fopen  _ioctl  _lseek  _mcount  _memcpy \
  _open  _read  _sigsetreturn  _start  _stat  _write  _wrtchk \
  _xflsbuf  atexit  brk  db_allocate_subentry  exit  fclose \
  fflush  fopen  fread  free  fseek  ftell  fwrite  getenv \
  isatty  malloc  mmap  printf  realloc  sbrk  $cerror  $$mulI \
  $$mulU  _fclose  _fflush  _fprintf  _fread  _fseek  _ftell \
  _fwrite  _getenv  _memset  _perror  _sleep  _strcat  _strcmp \
  _strcpy  _strlen  _strrchr  _tempnam _unlink  stat";
#endif /* V4FS */

  /* forget printing the message if verbose isn't on since :
	1) There isn't anything the user can do.
	2) It isn't really wrong, only poor bookkeeping. */
  if (!(verbose & V_PBO))	
    return;

  /* if the symbol is from icrt0.o then we don't emit the warning */
  /* This should catch a large number of cases */
  if (strrstr(file_name, "icrt0.o"))
    return;

 if (strstr(syms,c) == NULL)
 {
 warning(FDP_CANT_FIND_SYM, c, 0);  
 }

}

static void fdp_dup_sym_found(func_name, file_name)
char * func_name, *file_name;
{
  char *delimiter = ":";
  char buf[256];

  /* forget printing the message if verbose isn't on since :
	1) There isn't anything the user can do.
	2) It isn't really wrong, only suboptimal. */
  if (!(verbose & V_PBO))	
    return;

  /* we know that crt0.o does not abide by the proc_per_subspace
     rule. So we do not want to emit this message for crt0.o.*/
  if (strrstr(file_name, "crt0.o"))
    return;

  /* for any other case, we emit the warning */
  if (MB_CUR_MAX == 1)
      sprintf(buf, "%.39s%s%.39s", file_name, delimiter, func_name);
  else
      sprintf(buf, 
	      "%s%s%.39s", 
	      pad_string(0, 0, 39, file_name), 
	      delimiter, 
	      func_name);

  warning(FDP_DUP_USER_SYM, buf, 0);
}

  
  
#endif /* FDP_CODE */
