/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  
 *  Linkmap-related operations
 *
 */

/*
 * Externally visible interfaces to the linkmap functionality
 */

/* options processing 		*/
void 	lm_options_noobjdebug			(void);
void	lm_options_nocopyobjdebug		(void);	
void 	lm_options_copyobjdebug			(void);
void	lm_options_nolinkmap			(void);
void 	lm_options_linkmap			(void);
void 	lm_options_tools			(void);
void	lm_options_strip_s			(void);
void 	lm_options_strip_G			(void);

/* linker processing 		*/
void	lm_finish_options			(void);
void	lm_som_add				(void);
void	lm_compunit_read			(unsigned int compsize);
void	lm_spaces_add				(unsigned int debug_sp_index,
						 unsigned int objdebug_sp_index,
						 unsigned int linkmap_sp_index,
						 unsigned int igndbg_sp_index);

/* bss processing		*/
void	lm_bss_subspace_add			(unsigned int subsp_index,
						 unsigned int start);
void	lm_bss_symbol_add			(unsigned int sym_index,
						 unsigned int length);
void	lm_process_stor_unsats			(void);


/* decision making		*/
int	lm_should_invoke_pxdb			(void);
int	lm_should_disable_linetables		(void);

/* linkmap operation		*/
void	lm_linkmap_read				(void);
void	lm_linkmap_build_subspaces		(void);
void 	lm_linkmap_create			(void);

/* macros, used to be functions, needed to speed up the linker */
extern  unsigned int cur_objfile_index;
extern  unsigned int strip_debug_sp_idx;
extern  unsigned int *bss_remap;
#define lm_subspace_add(idx) {\
  if (idx == strip_debug_sp_idx) {\
    Subsp_Misc(idx).is_doom_stripped 	= TRUE;\
  }\
  if (Sub_Space_Misc(idx).is_doom_stripped) {\
    Subsp_Misc(idx).is_doom_stripped 	= TRUE;\
  }\
  if (strstr(Subsp_Dict(idx).NAME_PT, "BSS$") != NULL) {\
    Subsp_Misc(idx).is_bss_subspace 	= TRUE;\
  }\
  Subsp_Misc(idx).objfile_index  = cur_objfile_index;\
}
#define lm_symbol_add(idx) {\
  unsigned int new_idx = idx-cur_sym_index_bias;\
  Sym_Misc(idx).objfile_index = (bss_remap[new_idx])?\
    bss_remap[new_idx]:cur_objfile_index;\
}
#define lm_linker_gened_subspace(idx) {\
  Subsp_Misc(idx).is_linker_generated = TRUE;\
  if (strstr(Subsp_Dict(idx).NAME_PT, "BSS$") != NULL) {\
    Subsp_Misc(idx).is_linker_generated = FALSE;\
    Subsp_Misc(idx).is_bss_subspace 	= TRUE;\
  }\
}
#define lm_should_skip_subspace(idx) (Subsp_Misc(idx).is_doom_stripped)
#define lm_should_skip_space(idx) (space_misc[idx].is_doom_stripped)
