/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Library manipulation routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/libraries.c,v 1.2 1999/10/18 22:29:44 pschwan Exp $
 */

#define _SVID_SOURCE /* strdup --pschwan@thepuffingroup.com */
#include <stdio.h>
#include <string.h>

#include <ar.h>
#include <memory.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

/* CPU_PA_RISC* --pschwan@thepuffingroup.com */
#include "sys/magic.h"
#define _INCLUDE_HPUX_SOURCE
#include "sys/unistd.h"
#undef _INCLUDE_HPUX_SOURCE

#include <sys/mman.h> /* MAP_FILE --pschwan@thepuffingroup.com */
#include <unistd.h>

#ifndef DEBUG
#define NDEBUG
#endif  /* !DEBUG */
#include <assert.h>

#include "lst.h"
#include "filehdr.h"
#include "aouthdr.h"
#include "scnhdr.h"
#include "syms.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "get_text_off.h"
#include "dl.h"
#include "shl.h"
#include "ldnls.h"
#include "ldlimits.h"
#include "linker.h"
#include "ld_strings.h"
#include "spacehdr.h"
#include "spaces.h"
#include "subspaces.h"
#include "symbols.h"
#include "libraries.h"
#include "util.h"
#include "fixups.h"

/* doom support */
#include "ld_linkmap.h"

/* Globals */

/* global so that "collect_soms" can reclaim after all libraries searched */
int		lib_area_max = LIB_AREA_MAX;
char		*lib_area = NULL;
int		som_area_max = SOM_AREA_MAX;
char		*som_area = NULL;
int		som_str_area_max = SOM_STR_AREA_MAX;
char		*som_str_area = NULL;

extern int      gh_hash_table_size;
extern int      gh_hash_buckets_per_entry;
extern int      no_dlheader_ext;
extern int      dl_header_ext_offset;

/*
** Long file name support for archives. 
*/
char		*cur_ntbl = NULL;

int *out_DLT_list = NULL;  /* allocated DLT in memory */

int shlib_info_subsp_index = BAD_SUBSP;   /* $SHLIB_INFO$ subspace index */
int DLT_subsp_index = BAD_SUBSP;          /* $DLT$ subspace index */
int PLT_subsp_index = BAD_SUBSP;          /* $PLT$ subspace index */
int SHLIB_DATA_subsp_index = BAD_SUBSP;   /* $SHLIB_DATA$ subspace index */
#ifdef TSD 
int TBSS_subsp_index = BAD_SUBSP;	  /* $TBSS$ subspace index */
#endif /* TSD */

struct shlib_list_entry *out_shlib_list = NULL;	/* ptr to output shlib list */
int next_shlib_list_indx = 0;	/* index of next entry in output shlib list */

struct export_entry *out_export_list = NULL;    /* ptr to output export list */
int next_export_list_indx = 0;/* index of next entry in output export list */
int *out_explist_subsp = NULL;		/* ptr to export subspace list */

struct export_entry_ext *out_export_ext = NULL; /* export list extension */

struct import_entry *out_import_list = NULL;	/* ptr to output import list */
int next_import_list_indx = 0;	/* index of next entry in output import list */

char *out_shlstr_table = NULL; 	/* ptr to output string table */
int next_shlstr_table_indx = 0;	/* index of next entry in output string tbl */

int ltptr_DLT_entry_index;  /* index of lt-pointer (unwind) entry in DLT */

int PLT_entry_count	= 0, 
    export_entry_count	= 0, 
    import_entry_count	= 0, 
    DLT_entry_count	= 0;  /* table sizes in items */

struct PLT_entry *out_PLT_list = NULL;  /* allocated PLT in memory */

#if 0 /*  */
int out_hash_tbl[UNIVHASHSIZE];  /* export hash table in memory */
unsigned int out_hash_tbl_len = UNIVHASHSIZE; /* actual length (in elts) */
#endif
/* large shared library hash table */
#define MAX_SHLIB_HASH_LEN 100003
int out_hash_tbl[MAX_SHLIB_HASH_LEN];  /* export hash table in memory */
unsigned int out_hash_tbl_len = MAX_SHLIB_HASH_LEN; /*actual length (in elts)*/

/* globals for accumulating Linkage Table entries in other modules */

int local_data_sym_count = 0; /* count of all local data syms for import tbl */
struct symnode *data_locals_list = NULL; /* linked list for later processing */

struct symnode *minimum_export_list = NULL; 
	/* linked list of shlib unsats resolved to a.out sym to be exported */

int DR_PROPAGATE_count = 0; 	/* number of DR_PROPAGATE drelocs generated
				   while building an incomp a.out */

#ifndef NO_MULTIPLE_INITIALIZERS
static int *out_initializer_list = NULL;
#endif /* !NO_MULTIPLE_INITIALIZERS */

/* Locals */

static struct lst_header cur_lib_header;
static struct som_entry *som_dir;
static struct lst_symbol_record *export_list, *export_end;

static char		*lib_strings, *select_som, *added_som, *lib_cr_stor_flag;
static char		*lib_name;
static char		*sym_oflo_buf = NULL;
static int		sym_oflo_warned;
static int		str_oflo_warned;
static int		oflo_buf_size = -1;
static int		lib_ofs;
static int		*lib_hash;

static int lib_match();
static void lib_som_add();
static char *lib_cmpnt_name_build();

/* statics for accumulating the Linkage Tables */
static struct symnode *data_satisfied_unsats = NULL; 
	/* linked list of unsats resolved to shlib appearing on cmd 
	   line for later processing */

static struct dreloc_record *out_dreloc_list = NULL;  
			/* accumulated dreloc_records in memory */

static int code_unsats_left = 0; /* number of code unsats left unresolved */

/* number of code unsats resolved by shlib */
static int code_matches_found = 0; 

static struct symnode *code_satisfied_unsats = NULL; 
					/* linked list for later processing */

static struct dl_header out_dl_hdr;  /* output copy of dl_header record */

/*  
** Global hash table changes
*/
static unsigned int *import_hashvals;
static unsigned int *export_hashvals;
static unsigned int *plabel_hashvals;

/* module table for shared libraries */
struct module_entry *shlib_module = NULL;      /*module table written to file*/
struct module_misc  *shlib_module_misc = NULL; /*module misc array*/
int shlib_module_count = 0;

int module_import_offset  = 0;    /* offset off SHLIB_INFO for module impts */
int *module_dreloc_buffer = NULL; /* table that holds drelocs for each module*/
int module_dreloc_count   = 0;	  /* # of entries in module dreloc table */
int module_dreloc_offset  = 0;	  /* offset off SHLIB_INFO for module drelocs*/

/*
** 
**
** Goals: search shared libraries only when they might change something,
** add a shlib to shlib list only once, and remember shlib exports only once.
**
** Static Globals:
** shlib_uniq_info :	Start of array. There is one entry per unique
** 			shared library seen so far.
** 
** shlib_uniq_info_count :	Number of entries in the array.
**
** Fields of shlib_uniq_info entries:
** dev_no, inode_no :	device and inode number of shlib file.
**
** seen_lately :	has this library been searched since the last .o or
** 			.a was loaded? If not, the .o or .a could have
** 			added new unsats that may be resolved by this
** 			library, so we should search it again.
** 
** on_shlib_list :	has this library been added to the shlib list? If
**	 		so, we never want to add it again, even if a
** 			different path string refers to the library.
** 
** exports_saved :	have the exports of this library been saved in the
** 			shlib export hash table ? If so, we
** 			never want to add them again.
** 
** The only functions touching this data are, all appearing below, are:
**	free_shlib_uniq_info()
**	clear_shlib_seen_lately()
**	shlib_seen_lately()
*/

struct uniq_shlib_info {
	dev_t dev_no;   /* device number (unique id for this file system) */
	ino_t inode_no; /* inode number (unique to this file system)      */
	unsigned int seen_lately : 1;   /* searched since last .o/.a ?    */
	unsigned int on_shlib_list : 1; /* added to shlib list already ?  */
	unsigned int exports_saved : 1; /* saved shlib exports ?          */
	unsigned int reserved0 : 29;    /* pad out to a word boundry      */
};

static struct uniq_shlib_info *uniq_shlib_info = NULL;
static int uniq_shlib_info_count = 0;

/* 
** This function should be identical to the one defined
** in the dynamic loader.  If they are not, then, this will
** cause some serious problems at runtime.  
*/
static unsigned int symtab_hash(char *name, int type)
{
   unsigned int rv = (type == ST_STORAGE ? ST_DATA : type);

   while (*name) {
      rv = ((rv << 5) | (rv >> 27)) ^ *name++;
   }

   return rv;
}

/* 
** The following function will go through and calculate the hash
** values of the import and export symbols.  It is designed to be 
** used by the global hash table mechanism in the dynamic loader.
** Memory is allocated here, so don't forget to free it.
** *************************************************************
** NOTE: hash function must match the one in the dynamic loader. **
** *************************************************************
*/
void calculate_hash_values() 
{
   int i;

   /* first we do the exports */
   export_hashvals = (unsigned int *)emalloc(export_entry_count*sizeof(int));
   for (i=0; i<export_entry_count; i++) {
      export_hashvals[i] = symtab_hash(
                &out_shlstr_table[out_export_list[i].name],
                out_export_list[i].type);
   }

   /* now we do the imports */
   import_hashvals = (unsigned int *)emalloc(import_entry_count*sizeof(int));
   for (i=0; i<import_entry_count; i++) {
      if (out_import_list[i].name == EMPTY) {
      	import_hashvals[i] = symtab_hash ("", out_import_list[i].type);
      } else {
      	import_hashvals[i] = symtab_hash(
                	&out_shlstr_table[out_import_list[i].name],
                	out_import_list[i].type);
      }
   }

   /* finally, the plabels - import_entries with the type ST_PLABEL */
   plabel_hashvals = (unsigned int *)emalloc(import_entry_count*sizeof(int));
   for (i=0; i<import_entry_count; i++) {
      if (out_import_list[i].type == ST_CODE) {
         plabel_hashvals[i] = symtab_hash(
                &out_shlstr_table[out_import_list[i].name],
                ST_PLABEL);
      } else {
         /* This value must match INVALID_SYM_HASHVAL in dld */
         plabel_hashvals[i] = (unsigned int)(-1);
      }
   }
}

/*
** Free up all storage for the shlib_uniq_info array.
*/

void free_uniq_shlib_info()
{
    if (uniq_shlib_info) {
	efree(uniq_shlib_info);
	uniq_shlib_info = NULL;
	uniq_shlib_info_count = 0;
    }
}

/*
** Set seen_lately bit to FALSE for all entries in shlib_uniq_info array.
*/

void clear_shlib_seen_lately(void)
{
    int i;

    for (i = 0; i < uniq_shlib_info_count; i++)
        uniq_shlib_info[i].seen_lately = 0;
}

/*
**
**
** file is the file descriptor number for the open shared library file.
** filename is the library's name, which is passed only for error messages.
** This function operates on the malloced array uniq_shlib_info, of type
** struct uniq_shlib_info, defined earlier in this file. The comment near
** those definitions might also be helpful.
**
** Return TRUE if we have seen the shlib since the last .o or .a, and
** therefore do not need to search it again. This state is stored by the 
** seen_lately bit. If we haven't seen it lately, we should set this bit
** since we will search it now.
**
** The on_shlib_list bit should be set if *add_to_shlib_list is TRUE.
** In either case, if on_shlib_list was already set, we want to tell
** the caller that this library should not be added to the shlib list
** again; we do this by setting *add_to_shlib_list to FALSE.
**
** The exports_saved bit should be set if *save_exports is TRUE.
** In either case, if exports_saved was already set, we want to tell
** the caller that exports from this library should not be saved (remembered)
** again; we do this by setting *save_exports to FALSE.
**
** Note that one could think of search_now as an implicit Boolean * argument,
** which is always true when this routine is called, and is modified to be
** whatever this routine returns.
*/

static Boolean shlib_seen_lately(int filedes,
				 const char *filename,
				 Boolean *add_to_shlib_list,
				 Boolean *save_exports)
{
    struct stat stat_buf;	   /* returned values from "fstat" */
    struct uniq_shlib_info *info;  /* working pointer */
    int new_dev_no, new_inode_no;  /* device and inode nbrs of the new lib */
    int i; 			   /* loop counter */

    i = fstat(filedes, &stat_buf); /* get file information from file system */
#ifndef PFA
    /* check for error, which should be very rare. approximate error message */
    if (i) system_error(FF_CANT_READ, filename);
#endif /* PFA */

    new_dev_no = stat_buf.st_dev;
    new_inode_no = stat_buf.st_ino;

    for (i = 0; i < uniq_shlib_info_count; i++) {
	if ((uniq_shlib_info[i].dev_no == new_dev_no) &&
	    (uniq_shlib_info[i].inode_no == new_inode_no)) {
	    /*
	    ** if it is on the list, make sure it doesn't go on the list again,
	    ** otherwise mark it as on the list if we are going to add it now.
	    */
	    if (uniq_shlib_info[i].on_shlib_list)
	        *add_to_shlib_list = FALSE;
	    else
	        uniq_shlib_info[i].on_shlib_list = 
		  (*add_to_shlib_list ? 1 : 0);
	    /*
	    ** if its shlib exports have been remembered, make sure we don't
	    ** remember them again, otherwise mark exports as saved if we are
	    ** going to do it now.
	    */
	    if (uniq_shlib_info[i].exports_saved)
	        *save_exports = FALSE;
	    else
	        uniq_shlib_info[i].exports_saved = (*save_exports ? 1 : 0);
	    /*
	    ** if it has been seen lately, make sure we don't search it 
	    ** again by returning true, otherwise mark library as seen
	    ** and return FALSE so that it is searched now.
	    */

	    /* If we really need to add this lib
	    ** to the shlib_list of the output file, do so.  We'll re-search
	    ** the shared lib, but what the hell. */

	    if (uniq_shlib_info[i].seen_lately && ! (*add_to_shlib_list))
	        return TRUE;
	    else {
	        uniq_shlib_info[i].seen_lately = 1;
		return FALSE;
	    }
	}
    }

    /* no match found : add to local list for future searches and return */
    /* create entry */
    uniq_shlib_info = (struct uniq_shlib_info *)
      erealloc((char *)uniq_shlib_info,
	       (uniq_shlib_info_count+1) * sizeof(struct uniq_shlib_info));
    info = &uniq_shlib_info[uniq_shlib_info_count++];
    /* record unique information about library file */
    info->dev_no = new_dev_no;
    info->inode_no = new_inode_no;
    /* yes, we have just seen it */
    info->seen_lately = 1;
    /*
    ** mark entry as added to shlib list if and only if we are going
    ** to do it now. Don't override what we were going to do.
    */
    info->on_shlib_list = (*add_to_shlib_list ? 1 : 0);
    /*
    ** mark entry as having saved exports if and only if we are going
    ** to do it now. Don't override what we were going to do.
    */
    info->exports_saved = (*save_exports ? 1 : 0);
    info->reserved0 = 0; /* initialize in case we ever want to use it */
    return FALSE;
}  /* shlib_seen_lately */

static char *get_shlib_name(dash_l_reference, cur_shlib_name, path_name)
Boolean dash_l_reference;	/* Was this shlib referenced by -l? */
char    *cur_shlib_name;	/* Input filename of the current shlib */
char 	path_name[];            /* assembled pathname */
{

    if (!dash_l_reference && (cur_shlib_name[0] != '/')) {
        /* prepend current working directory to relative pathname */
	errno = 0;
	getcwd(path_name, (MAXPATHLEN+2));
	if (errno != 0)
	    system_error(CANT_GET_CWD, 0);
	if (1 + strlen(path_name) + strlen(cur_shlib_name) > MAXPATHLEN)
	    system_error(PATH_NAME_TOO_LONG, path_name, cur_shlib_name, 0);
	strcat(path_name, "/");
	strcat(path_name, cur_shlib_name);
	return(path_name);
    } else {
        return(cur_shlib_name); 
    }
}  /* end "get_shlib_name" */


/*============================================================================
			OPEN_DASH_L_DEP
    DESCRIPTION: Open a library which was listed as a dependency and for
	which dash_l_reference was true.  If the library is not found at
	the path, cur_shlib_name, we look for the library in all of the
	places we would look for a -l library.
	
	On failure, the routine does not return and system_error
	is called.  On success, it returns a FILE * pointer to the opened
	file.  On success, *new_shlib_path_p is set to cur_shlib_name if
	the original path worked, otherwise, it is set to a malloc'd string
	containing the path used on the open.
-----------------------------------------------------------------------------*/
FILE *open_dash_l_dep(cur_shlib_name, new_shlib_path_p)
char	*cur_shlib_name;
char	**new_shlib_path_p;
{
    FILE *return_stream_p;
    char *lib_basename;

    /* First, try opening the file using the recorded path. */

    return_stream_p = fopen(cur_shlib_name, "r");
    if (return_stream_p != NULL) {
	/* We found it. */
	*new_shlib_path_p = cur_shlib_name;
	return(return_stream_p);
    }
    else {
       ANALYZE_LARGE_FILE_ERROR(cur_shlib_name);
    }

    /*
     * 
     * Isolate the basename for the library. By using EXACT_LIB_MATCH below
     * we can keep the lib prefix and the .sl or .[0-9] suffix.
     */
    if (MB_CUR_MAX == 1) {
	lib_basename = strrchr(cur_shlib_name, '/');
    } else {
	lib_basename = mb_strrchr(cur_shlib_name, '/');
    }
    lib_basename++;

    /* Search for library basename as is with lib_name_build */
    *new_shlib_path_p = lib_name_build(lib_basename, EXACT_LIB_MATCH);
    if (*new_shlib_path_p == NULL) {
       /* Search failed.  Unable to open file. */
	system_error(CANT_OPEN, cur_shlib_name, 0);
    }

    /* Try to open the library we found. */

    return_stream_p = fopen(*new_shlib_path_p, "r");
    if (return_stream_p == NULL) {
	/* Unable to open the library. */
	system_error(CANT_OPEN, cur_shlib_name, 0);
    }

    /* We found it. */

    return(return_stream_p);
} /* end open_dash_l_dep */

static void recursive_shlib_search (dash_l_reference, 
		  	     cur_shlib_name, 
		  	     do_full_sym_resolution)
Boolean dash_l_reference;	/* Was this shlib referenced by -l? */
char    *cur_shlib_name;	/* Filename of the current shlib */
Boolean do_full_sym_resolution;	/* if true, do full sym resolution, else 
					only shlib "soft" unsats. */
{

    int cur_shlib_fildes;	/* File descriptor of the current shlib */
    FILE *f;
    struct header cur_header;	/* SOM header, for magic number check */
    struct stat stat_buf;       /* Is file same as output file? */
    char *shlib_path_used;	/* Path used may change if dash_l_reference
				** is true
				*/

    if (! dash_l_reference) {
	f = efopen(cur_shlib_name,"r",CANT_OPEN);
	shlib_path_used = cur_shlib_name;
    } else {
	f = open_dash_l_dep(cur_shlib_name, &shlib_path_used);
    }

    if (! stat(shlib_path_used,&stat_buf)) { /*Make sure stat succeeds*/
	if ((stat_buf.st_dev == out_file_stat.st_dev) &&
	    (stat_buf.st_ino == out_file_stat.st_ino)) {
	    user_error(SAME_FILE_INPUT_OUTPUT,shlib_path_used,0);
        }
    }
    cur_shlib_fildes = fileno(f);

    /* read the SOM header */
    ffetch(cur_shlib_fildes, 0, (void *) &cur_header, sizeof(cur_header), 1);

    /* make sure the file has shared library magic number */
    if (cur_header.a_magic != SHL_MAGIC)
        external_error(BAD_LIB_HEADER, shlib_path_used, 0);

    /* all other verification on the SOM is done in shlib_search */

    shlib_search( dash_l_reference, 
		  shlib_path_used, 
		  cur_shlib_fildes, 
		  & cur_header,
		  FALSE,
		  do_full_sym_resolution);
    fclose(f); /*  */
    if (shlib_path_used != cur_shlib_name)
	efree(shlib_path_used);
}  /* end "recursive_shlib_search" */
    
/*
**	Data structures and routines for elimination of data copying.
**
**	What data copy elimination means is to __not__ copy data,
**	exported from a shared library and imported by the program file,
**	into the program file itself.  Instead, keep the data residing
**	in the library, and force references to it from the a.out to
**	go through the DLT.
**
**	In order to do this, we need several things:
**	   1. Identify global data imported by the program file
**	   2. Create a DLT slot for this object in the a.out
**	   3. Re-write the instruction(s) that access these data to
**	      get the address via the DLT, which is off of DP
**	   4. Create dreloc records for any static initializations in
**	      the a.out that refer to the address of the imported data
**
**	For my purposes, a "shared global" is one that is exported from
**	a library, imported by the program file: i.e., data that is no
**	longer copied.  It does __not__ refer to data exported from the
**	program file (or another shlib) and imported by a shlib.
**	Hence, all changes for data copy elimination only affect the
**	building of an incomplete executable -- not the building of a
**	shared lib.
**
**	To make this work, we need to keep a list of all shared globals
**	found while building the program file; it's static to this file,
**	and it's a simple list called "shared_global_list".  It keeps
**	info about the shared globals, such as the symbol index and
**	any "multiple slot" information.
**
**	"Multiple slots" are here because now we may need to create
**	multiple DLT entries for the same symbol.  The reason for this
**	is that a 2-instruction DLT-relative data access can only get
**	to 8192 bytes away from the address loaded up from the DLT.
**	I.e.,
**		char array[10000], c = array[8193];
**	needs 3 DLT-relative instructions if the first just loads up
**	the base address of "array" (because the following LDB can only
**	reach 14 bits away from the base address).
**
**	If, however, we load up the address of "array[8192]" in the
**	first instruction, then the following LDB can easily reach to
**	this base address + 1 byte.
**
**	Hence, we create two DLT entries for "array": one for the base
**	address itself, and one for the address of "array[8192]".  The
**	"multiple_slots" list for each shared global list item contains
**	all the unique R_DATA_OVERRIDE values needed to reach, in two
**	instructions, any reference to any shared global in the code.
**
**	Now also have a separate list of storage requests that
**	are exported from a shlib that satisfy an unsat from the program
**	file.  
**
*/

#define LIST_SIZE 16

static struct {
   struct shared_list {
      unsigned int sym;
      unsigned char type;  /* Is it ST_DATA or ST_STORAGE? */
      unsigned char reserved1;
      unsigned short reserved2;
      struct mult_list {
	 struct mult_list *next;
	 int override_value;   /* value from R_DATA_OVERRIDE */
	 int DLT_index;        /* DLT slot index used */
      } *multiple_slots;
   } *list;
   int len;
   int end;
} shared_global_list = { 0, 0, 0 };

static struct {
   struct stor_shared_list {
      struct symnode *node;
      int sym;
   } *list;
   int len;
   int end;
} stor_req_list = { 0, 0, 0 };


static int num_mult_slots = 0;   /* Need to realloc by this much */
static int num_2_inst_slots = 0; /* Don't have LDO N0'; for sorting */


/*
**	add_to_shared_global_list().  Adds the symbol index for the input
**	symnode to a list of "shared global symbols".
**	Assumption: the symbol has not already been added to the list.
**
**	Added 'stor_req' parameter to distinguish the
**	type of the shared global.
*/

static void add_to_shared_global_list (struct symnode *n, Boolean stor_req)
{
   int sym = n->index;

   /*
   ** If this symbol has already been added to the shared global list
   ** then do not add it again since only one DLT entry will be 
   ** generated for it.  
   */
   if (Sym_SharedGlobal ((Sym_Back_Ptr (sym))->index))
       return;

   if (shared_global_list.len >= (shared_global_list.end - 1)) {
      shared_global_list.list = (struct shared_list *)
				    erealloc ((char *) shared_global_list.list,
		         (shared_global_list.end += LIST_SIZE) *
					   sizeof (struct shared_list));
      if (NULL == shared_global_list.list)
	 external_error (OUT_OF_MEM, 0);
   }

   /*********************************************************************
   ** ---------------------
   ** Instead of setting shared_global_list.list[] to sym:
   **   shared_global_list.list [shared_global_list.len].sym  =  sym
   ** setting it to the head of the chain.
   *********************************************************************/
   
   shared_global_list.list [shared_global_list.len].sym  = 
			                     (Sym_Back_Ptr (sym))->index;
   shared_global_list.list [shared_global_list.len].type =
				      stor_req ? ST_STORAGE : ST_DATA;
   shared_global_list.list [shared_global_list.len++].multiple_slots = 0;

	/* Now, make sure the head of the sym chain has
	** its shared_global bit set; this is easier than searching through
	** the entire same list to see if maybe one of the nodes' symbols
	** has its bit set. */
   Sym_SharedGlobal ((Sym_Back_Ptr (sym))->index) = 1;
   /* Sym_SharedGlobal (sym) = 1; */
}


/*
**	shared_global_index().  Given a data symbol index (already
**	remapped if necessary), see if this is in the shared global list,
**	and return the index if found; else return -1.
**	Since when the symbols are put into the shared_global_list they
**	aren't remapped, we need to do this now.
*/

static int shared_global_index (int sym)
{
      int i;
      void *sym_addr;

   sym_addr=&Sym_Dict(sym);
   for (i = 0; i < shared_global_list.len; i++) { 
      if (&Sym_Dict(shared_global_list.list[i].sym) == sym_addr) {
	 return i;
      }
   }
   return -1;
}


/*
**	add_shared_global_multiple_slot().  This takes in a sym for
**	a shared global (which must already be in the shared global
**	list) and adds the 'value' info if needed to the 'multiple_slots'
**	field.  This will be used to build multiple DLT slots for the
**	same symbol, in the case that the address needed is > 8K bytes
**	from the base address in the primary DLT slot.
*/

extern void add_shared_global_multiple_slot (int sym, int value)
{
      int i, index;
      struct mult_list *p, *q;

	/* We need only this value to determine which DLT slot to use */
   value = FIXUP_ROUND (value) / 8192;

   assert (value >= 1 || value <= -1);

   index = shared_global_index (sym);

   assert (-1 != index);   /* Better have found it... */

   p = shared_global_list.list [index].multiple_slots;

   if (!p) {  /* first time in */
      num_mult_slots++;
      p = (struct mult_list *) emalloc (sizeof (struct mult_list));
#ifdef DEBUG
      if (verbose & V_NO_DATA_COPY) {
	 printf ("multiple_slot: adding multiple slot for symbol \"%s\" ",
	         Sym_Name (sym));
	 printf ("slot value %d\n", value);
      }
#endif  /* DEBUG */
      p->next = NULL;
      p->override_value = value;
      p->DLT_index = 0;
      shared_global_list.list [index].multiple_slots = p;  /* Assign it! */
      return;
   }
   while (1) {
      if (p->override_value == value)
	 return;
      q = p->next;
      if (NULL == q) {
      	 num_mult_slots++;
   	 q = (struct mult_list *) emalloc (sizeof (struct mult_list));
#ifdef DEBUG
      	 if (verbose & V_NO_DATA_COPY) {
	    printf ("multiple_slot: adding multiple slot for symbol \"%s\" ",
	            Sym_Name (sym));
	    printf ("slot value %d\n", value);
      	 }
#endif /* DEBUG */
	 q->next = NULL;
   	 q->override_value = value;
      	 q->DLT_index = 0;
   	 p->next = q;
	 return;
      }
      p = q;
   }
}


/*
**	expand_DLT_list().  expands the DLT list as needed by the number
**	of multiple slots used in the shared global list.  Also fills in
**	these new DLT slots with the (repeated) syms that have multiple slots.
**	Also now calculates the number of 2-inst DLT slots, so we can sort
**	the DLT better.
*/

static void expand_DLT_list (void)
{
      int total, i;
      struct mult_list *p;
      int sort_short;

   if (num_mult_slots) {
      total = DLT_entry_count + num_mult_slots;
      out_DLT_list = (DLT_ENTRY *) erealloc ((char *) out_DLT_list,
					     total * sizeof (DLT_ENTRY));
   }

   for (i = 0; i < shared_global_list.len; i++) {
	/* Don't bother if it's not really a shared global */
      if (Sym_SharedGlobal (Sym_Remap (shared_global_list.list[i].sym)) == 0)
	 continue;
      sort_short = Sym_Sort_Short (shared_global_list.list[i].sym) == 1;

      if (sort_short)
	 num_2_inst_slots++;     /* Bump for main DLT slot */

      p = shared_global_list.list[i].multiple_slots;
      while (p) {
	 out_DLT_list [DLT_entry_count++] = shared_global_list.list[i].sym;
	 p = p->next;
      	 if (sort_short)
	    num_2_inst_slots++;  /* Bump again for mult. DLT slots */
      }
   }
	/* If we have mult. slots, better have accounted for all of them */
   assert (!num_mult_slots || DLT_entry_count == total);
}

/* HP-UX Shared Libraries */
/*
**	set_DLT_import_lists().  Takes in a pointer to the NULL_IMPORT_REC.
**
**	The DLT for an incomplete executable has two kinds of symbols in
**	it:  entries for shared globals, and entries symbols that _aren't_
**	shared globals:  the former (shared globals) MAY be compiled with
**	PIC; the latter are always from standalone PIC symbols.
**	For non-shared globals, we want to make the associated
**	import entry a null one, with type ST_NULL.  For shared globals,
**	we want to set the type to ST_DATA and set the name field correctly.
**
**	By now, the DLT has been sorted to have all non-shared globals
**	at low indices, and all shared globals at high indices (close to
**	DP).  Also, all DLT entries for "multiple slots" are adjacent to
**	the "original" slot for the symbol.
**
**	This routine does these things:
**	1) Set the Sym_ShlImp_Indx properly for symbols in the DLT.
**	2) Set the DLT_index field for multiple slots in the shared
**	   global list correctly.
**	3) Set the import list entries correctly for both types of symbols
**	   above.
*/

static void set_DLT_import_lists (struct import_entry *null_rec, 
				  int num_shared)
{
      int i, index;
      int PIC_length;
      int sym;
      struct mult_list *p;

	/* any DLT slot with a lower index than PIC_length must
	** not be a shared global */
   PIC_length = DLT_entry_count - num_shared;

   for (i = 0; i < DLT_entry_count; i++) {
      out_import_list [i] = *null_rec;   /* Initialize import entry */
      sym = out_DLT_list[i];

      Sym_ShlImp_Indx (sym) = i;
                                                 /* Not shared global */
      if (i < PIC_length || (index = shared_global_index (sym)) < 0) {
	 out_import_list [i].type = ST_NULL;

      } else {                                   /* Shared global */
	 out_import_list [i].type = shared_global_list.list [index].type;
	 out_import_list [i].name = shlib_string_add (Sym_Name (sym));
	 p = shared_global_list.list [index].multiple_slots;
	 while (p) {
	    ++i;
	    out_import_list [i] = *null_rec;
	    out_import_list [i].type = ST_DATA;
	    out_import_list [i].name = shlib_string_add (Sym_Name (sym));
	    p->DLT_index = i;
	    p = p->next;
	 }
      }
   }
}

/*
**	get_sym_multiple_slot().  Take in a sym, an override value, an
**	indicator of which instruction we're fixing up (1st, 2nd, or 3rd),
**	and the "primary" DLT slot index of the shared global.
**	Look up the sym/multiple slot pair and return the correct byte offset
**	for this combination.  Called from apply_fixups() to find the LT_offset
**	to use when rewriting a symbol.
**	We might get in a strange situation: with the pre-9.0 C compiler,
**	e.g., an access for foo[8191] is like this:
**		ADDIL LR'foo-$global$+8192 ...
**		LDB   RR'foo-$global$+8191 ...
**
**	The 9.0 C (Ucode) compiler puts out this:
**		ADDIL LR'foo-$global$+8191 ...
**		LDB   RR'foo-$global$+8191 ...
**
**	We don't know a priori when we get the ADDIL (1st inst in the
**	sequence) whether we want to use the slot for T'foo[8192] or the
**	slot for T'foo[0].  So we try both: first the former, then the
**	latter.
*/

extern int get_sym_multiple_slot (int sym, int value,
				  int inst_order, int import_index)
{
      int round, div, index, slot;
      struct mult_list *p;

   round = FIXUP_ROUND (value);
   div   = round / 8192;
   index = shared_global_index (sym);
   assert (-1 != index);

   p = shared_global_list.list [index].multiple_slots;

	/* If no multiple slots, use slot for T'sym[0] */
	/* Also check for degenerate case of div being 0 */
   if (div == 0 || !p) {
      slot = import_index;
      div  = 0;          /* Use "value" alone for 3rd inst offset */
      goto RETURN;
   }

   while (p) {
      if (p->override_value == div) {
	 slot = p->DLT_index;
	 goto RETURN;
      }
      p = p->next;
   }
	/* No slot for input value exists; see if we can use the next
	** lower address multiple slot: */

   div += (div < 0) ? 1 : -1;  /* Use next slot closest to 0 */

	/* If div is now 0, we don't want a
	** multiple slot with this value: we want to use the original
	** import_index slot, for T'sym[0]! */
   if (div == 0) {
      slot = import_index;
      goto RETURN;
   }

	/* We are in trouble in this case: the 3rd inst comes in like
	** "LDB RR'foo-$global$+16385", but we have no slot for
	** T'foo[16384].  I.e., if we rounded down but find no slot,
	** oops. */
   if (3 == inst_order && round <= value)
      internal_error (-1, "get_sym_mult:1");

   p = shared_global_list.list [index].multiple_slots;
   while (p) {
      if (p->override_value == div)
      	 break;
      p = p->next;
   }
   if (!p || p->override_value != div)
      internal_error (-1, "get_sym_mult:2");
   slot = p->DLT_index;

RETURN:
   if (3 == inst_order)
	/* Difference between value and address of slot that was used */
      return value - (div * 8192);
   else {                   /* 1st, 2nd inst */
      return slot * sizeof (DLT_ENTRY);  /* Byte offset of slot from DP */
   }
}

/* HP-UX Shared Libraries */
/*
**	add_to_stor_req_list().  Adds input symnode to list, if not already
**	in.  If in, updates length field, if necessary.
**	  Don't use length any more.
*/

static void add_to_stor_req_list (struct symnode *node)
{
      int i;

   for (i = 0; i < stor_req_list.len; i++)
      if (stor_req_list.list [i].node == node)
	 break;

   if (i == stor_req_list.len) {   /* Not yet in list; add it */
      if (stor_req_list.len >= (stor_req_list.end - 1)) {
      	 stor_req_list.list =
	       (struct stor_shared_list *) 
		       erealloc ((char *) stor_req_list.list,
		                 (stor_req_list.end += LIST_SIZE) *
					   sizeof (struct stor_shared_list));
      if (NULL == stor_req_list.list)
	 external_error (OUT_OF_MEM, 0);
      }
      stor_req_list.list [stor_req_list.len  ].node   = node;
      stor_req_list.list [stor_req_list.len++].sym    = node->index;
   }
}


/*
**	resolve_shlib_storage_requests().  Called from select_shlib_exports()
**	just before storage_create() is called, to go through the
**	stor_req_list() and create shared globals from them if necessary.
**
**	If the Stor Unsat from a library is _not_ to be a shared global,
**	then we must put it on the "same" list for the symbol in the
**	unsat table, else it won't be exported by the program file.
*/

extern void resolve_shlib_storage_requests (void)
{
      struct symnode *node, *unsat_node;
      int i, /* length, */ sym;

   for (i = 0; i  < stor_req_list.len; i++) {
      node = stor_req_list.list [i].node;
      sym  = stor_req_list.list [i].sym;

	/* If the symbol is already a shared global (e.g., data export 
	** in trailing shlib after stor export in first shlib), continue */

      if (Sym_SharedGlobal (sym))
	 continue;

	/* If the symnode has been remapped (unsat resolved), continue */
      if (sym != node->index)
	 continue;

	/* If the symbol is no longer unsat, continue */
      unsat_node = unsat_hash_table [node->hashval % UNSATHASHSIZE];
      if (!unsat_node)
	 continue;

	/* Find correct unsat table chain member */
      for ( ; unsat_node != NULL; unsat_node = unsat_node->next) {
	 if (unsat_node == node)
	    break;
      }

	/* If the symbol is no longer unsat, continue */
      if (!unsat_node)
	 continue;

	/* Now better have unsat_node == node */
      assert (unsat_node == node);

#ifdef DEBUG
      if (verbose & V_NO_DATA_COPY) {
	 printf ("resolve_shlib_storage_requests: adding shared global ");
	 printf ("for Stor Unsat \"%s\"\n", node->name);
      }
#endif /* DEBUG */
      add_to_shared_global_list (node, TRUE);
   }
}

/*
**	emit_shared_drelocs().  Called from out_subsp_data(), to emit
**	any DR_DATA_EXT drelocs necessary for "multiple" DLT slots.
*/

extern void emit_shared_drelocs (void)
{
      int i, sym;
      struct mult_list *p;

   for (i = 0; i < shared_global_list.len; i++) {
      sym = shared_global_list.list[i].sym;
      p = shared_global_list.list [i].multiple_slots;
      while (p) {
	 bld_shlib_dreloc_rec (sym, p->DLT_index * sizeof (DLT_ENTRY),
			       p->override_value * 8192, DR_DATA_EXT,
			       DLT_subsp_index);
	 p = p->next;
      }
   }
}

/* HP-UX Shared Library Processing */
/*
**	sort_shared_DLT().  qsort() routine, used to sort the DLT to
**	place shared global syms in HIGH value DLT slots, non-shared
**	global syms (w/ standalone PIC) in LOW value DLT slots.
**	So, return
**		-1: if sym1 is not shared, sym2 is shared
**		1 : if sym1 is shared, sym2 is not shared
**		0 : otherwise (both shared or not shared).
*/

static int sort_shared_DLT (const void *sym1, const void *sym2)
{
	Boolean first_shared  = Sym_SharedGlobal (* (int *) sym1);
	Boolean second_shared = Sym_SharedGlobal (* (int *) sym2);

    if (first_shared == second_shared)
	return 0;
    if (first_shared)
	return 1;
    return -1;
}

/*
**	sort_2_inst_DLT().  qsort() routine, used to sort the DLT to
**	place shared globals that are accessed using 2-instruction
**	sequences in HIGH value DLT slots, shared globals with only
**	3-inst accesses in LOW value DLT slots.
**	So, return
**		-1: if sym1 doesn't have its 2-inst bit set, sym2 does
**		1 : if sym1 has its bit set, sym2 does not
**		0 : otherwise (both set or not set).
*/

static int sort_2_inst_DLT (const void *sym1, const void *sym2)
{
	Boolean first_set  = Sym_Sort_Short (* (int *) sym1);
	Boolean second_set = Sym_Sort_Short (* (int *) sym2);

    if (first_set == second_set)
	return 0;
    if (first_set)
	return 1;
    return -1;
}


/*
**	sort_mult_DLT().  qsort() routine, used to sort the shared DLT
**	slots in numeric order; this is to make sure that multiple DLT
**	slots for the same symbol are adjacent.
**	So, return
**		-1: if sym1 < sym2
**		1 : if sym1 > sym2
**		0 : sym1 == sym2
*/

static int sort_mult_DLT (const void *sym1, const void *sym2)
{
	int value1 = * (int *) sym1;
	int value2 = * (int *) sym2;

    if (value1 == value2)
	return 0;
    if (value1 < value2)
	return -1;
    return 1;
}


/*
**	do_shared_globals().  Called from near the end of count_unwind()
**	to get the DLT and import lists correct for incomplete execs,
**	w/o data copying.
**	First we want to calculate the _real_ number of shared globals:
**	some of those in the shared_global_list have been redefined with
**	data univs in the program file.
**	Here is the sort algorithm used to make the DLT more efficient:
**	a) First, sort the entire DLT to get shared globals close to DP
**	   (at the expense of non-shared PIC symbols)
**	b) Next, sort the shared globals alone to get those only accessed
**	   with a 3-inst code sequence far from DP, those not close
**	c) Finally, sort _both_ the 2-inst and 3-inst partitions to group
**	   the multiple slots near the "parent" sym slot.
*/

extern void do_shared_globals (struct import_entry *null_rec)
{
	int i; 
	int num_shared = 0;
	int sym;

    for (i = 0; i < shared_global_list.len; i++) {
	sym = shared_global_list.list[i].sym;
		/* .  Make sure we don't count unused "shared"
		** Stor Unsats as shared globals.  They will be put on the
		** shared_global_list by shlib_search(), but if there is not
		** a fixup applied to it, no DLT slot will be built for it.
		** We will not promote these to shared globals. */
	if (Sym_SharedGlobal (sym)) {
	    if (Sym_ShlImp_Indx (sym) == -1)   /* No fixup applied to it */
		Sym_SharedGlobal (sym) = 0;
	    else
		num_shared++;
		
	}
    }

        /* If num_shared > DLT_entry_count, we will be hosed below */
	/* The extra ones must be from stand-alone PIC */
    assert (DLT_entry_count >= num_shared);

	/* Reallocs the out_DLT_list and bumps the DLT_entry_count */
    expand_DLT_list ();
    num_shared += num_mult_slots;

	/* For each "multiple slot", we'll emit a DR_DATA_EXT to get
	** the loader to properly fill in the DLT address: 
        **
        ** For MPE, we'll be building LD_DATA_EXT2 loader
        ** fixups 
        */

    loader_fixup_size += num_mult_slots;

	/* expand the Import List to match DLT entries for syms */
    out_import_list = 
	    (struct import_entry *) erealloc ((char *) out_import_list, 
				    (import_entry_count + DLT_entry_count) *
					 sizeof(struct import_entry) );

        /* move down existing PLT entries */
    for (i = import_entry_count - 1; i >= 0; i--) {
	out_import_list [i + DLT_entry_count] = out_import_list [i];
    }

    if (num_shared > 0) {
	/* First, sort it to make shared global DLT entries close to DP: */
	qsort ((void *) out_DLT_list, DLT_entry_count,
	       sizeof (DLT_ENTRY), sort_shared_DLT);

	/* Next, sort for 2-inst / 3-inst accesses: */
    	qsort ((void *) (out_DLT_list + (DLT_entry_count - num_shared)),
               num_shared, sizeof (DLT_ENTRY), sort_2_inst_DLT);

	if (num_mult_slots > 0) {
		/* Next, sort for mult. slots in the 3-inst partition: */
	    qsort ((void *) (out_DLT_list + (DLT_entry_count - num_shared)),
		   num_shared - num_2_inst_slots,
		   sizeof (DLT_ENTRY), sort_mult_DLT);

		/* Finally, sort for mult. slots in the 2-inst partition: */
	    qsort ((void *)(out_DLT_list+ (DLT_entry_count - num_2_inst_slots)),
		   num_2_inst_slots,
		   sizeof (DLT_ENTRY), sort_mult_DLT);
	}
    }

    set_DLT_import_lists (null_rec, num_shared);

#ifdef DEBUG
    if (verbose & V_NO_DATA_COPY) {
	    int i;
	printf ("count_unwind_recover:\n\tDLT has %d slots, "
		"%d shared globals, %d mult. slots, %d 2-inst slots\n",
		DLT_entry_count, num_shared, num_mult_slots, num_2_inst_slots);
	for (i = 0; i < DLT_entry_count; i++) {
	    printf ("\t%d: %s\n", i, Sym_Name (out_DLT_list[i]));
	}
    }
#endif /* DEBUG */

    import_entry_count += DLT_entry_count;
}

#undef LIST_SIZE


		/* The following data structure and two functions are
		**  They implement the
		** "+cdp" option, to change the shlib_list pathname.  */
static struct _name_pair {
    char *path1;
    char *path2;
} *name_pair_list = 0;
static int name_pair_len = 0;

/*
**	add_shlib_name_pair().  Input string must be in the form
**	"path1:path2".  Add the two paths to the name_pair_list;
**	we'll just realloc the list every time (shouldn't be too
**	many of them!).
**	Emit a warning if the colon is not found.
*/

extern void add_shlib_name_pair (char *string)
{
    char *p;

    p = mb_strchr (string, ':');
    if (!p) {
	warning (BAD_CDP_INPUT, string, 0);
	return;
    }
    *p++ = '\0';

    name_pair_list = (struct _name_pair *)
		     erealloc ((char *) name_pair_list,
			        (name_pair_len + 1) *
					   sizeof (struct _name_pair));

    name_pair_list [name_pair_len].path1 = strdup (string);
    name_pair_list [name_pair_len].path2 = strdup (p);
    name_pair_len++;
}


/*
**	lookup_shlib_name_pair().  Search the name_pair_list above for
**	the initial part of the input shlib name.  If found, replace
**	with the path2 part of the list entry.  Use the longest match
**	found in the name_pair_list -- so search the entire list.
**	If not found, just return the input data.
*/

static char *lookup_shlib_name_pair (char *name)
{
    int position = -1;
    int max_len = 0;
    int i, len;
    char *p, *RV;

    if (!name_pair_len)
	return name;

    for (i = 0; i < name_pair_len; i++) {
	if ((len = strlen (name_pair_list[i].path1)) > max_len) {
	    if (strncmp (name_pair_list[i].path1, name, len) == 0) {
		max_len = len;
		position = i;
	    }
	}
    }
    if (position != -1) {
	p = name + max_len;   /* Get past initial dir string */
		              /* Add one byte for '\0' */
	RV = emalloc (strlen (name_pair_list [position].path2) +
		      strlen (p) + 1);

	strcpy (RV, name_pair_list [position].path2);
	strcat (RV, p);
    } else {
	RV = name;
    }
    return RV;
}


/*
**	free_name_pair_list()
*/

extern void free_name_pair_list (void)
{
    int i;

    if (name_pair_len == 0)
	return;

    for (i = 0; i < name_pair_len; i++) {
	free (name_pair_list[i].path1);
	free (name_pair_list[i].path2);
    }
    efree( name_pair_list);
}


/*
**	mmap_shlib_and_get_info().  This takes in a file descriptor and
**	and filename, and mmap's the shared library and reads sets all
**	the pointers to various SHLIB_INFO sections.  It returns the
**	mapped address.
*/

static char *mmap_shlib_and_get_info (int fd,
			              char *shlib_name,
				      struct header	      *somheader,
			              struct som_exec_auxhdr *aux,
			              struct shlib_list_entry **shlib_list,
			              struct import_entry     **import_list,
			              int                     **hash_table,
			              int                     *hash_table_size,
			              struct export_entry     **export_list,
			              struct export_entry_ext **export_list_ext,
			              char                    **string_table,
			              struct dreloc_record    **dreloc_list,
			              struct module_entry     **mod_list)
{
    char *shlib_text;
    struct dl_header *dl_hdr;

    int needed_length;		/* for use in constructing madvise call */
    int unneeded_length;
    long system_page_size;
    long dl_header_offset;

#ifdef UNPAD_SL
    /* 
    ** the dl_header may now be at an offset from the start of text mapping.
    */
    if ((dl_header_offset = get_text_offset(fd, somheader, aux)) == -1){
       /*
       ** Error.  Give up.
       */
       switch (errno) {
       case ENOMEM:
	   system_error(OUT_OF_MEM, shlib_name, 0);
	   break;
       default:
	   system_error(FF_CANT_READ, shlib_name, 0);
	   break;
       }
    }
#else
   dl_header_offset = 0;
#endif

    /*
    ** The shared library tables may legally be anywhere in TEXT so long
    ** as the dl_header is at the beginning, so let's mmap all of the
    ** shlib's text for reading. We may even get to share it!
    */
    /*
    ** We will now mmap PROT_READ | PROT_EXEC because of a kernel bug,
    ** escpecially visible in the 9.0 kernel used by the build environment.
    */

    shlib_text = mmap(0,
		      (size_t) aux->exec_tsize,
		      PROT_READ | PROT_EXEC,
#if 0
		      MAP_FILE | MAP_VARIABLE | MAP_SHARED,
#else
		      /* we don't have MAP_VARIABLE, and I don't _think_ it
		       * matters --pschwan */
		      MAP_FILE | MAP_SHARED,
#endif
		      fd,
		      (off_t) aux->exec_tfile);

    if ((int)shlib_text == -1) {
	/*
	** If the region is already mmapped SHARED by this process,
	** we can't do it again so we'll try to mmap PRIVATE. For
	** a shared-bound linker, libc.sl is an example of this.
	*/
	shlib_text = mmap(0,
			  (size_t) aux->exec_tsize,
			  PROT_READ | PROT_EXEC,
#if 0
			  MAP_FILE | MAP_VARIABLE | MAP_PRIVATE,
#else
			  /* we don't have MAP_VARIABLE, and I don't _think_ it
			   * matters --pschwan */
			  MAP_FILE | MAP_PRIVATE,
#endif
			  fd,
			  (off_t) aux->exec_tfile);
#ifndef PFA
	if ((int)shlib_text == -1) {
	    /*
	    ** It must be a real problem. Give up.
	    */
	    switch (errno) {
	    case ENOMEM:
		system_error(OUT_OF_MEM, shlib_name, 0);
		break;
	    default:
		system_error(FF_CANT_READ, shlib_name, 0);
		break;
	    }
	}
#endif /* PFA */
    }

    /*
    ** Change shlib_text to point to the dl_header as it used to do.
    ** We need to unadjust this when we unmap the library.
    */

    shlib_text += dl_header_offset;

    /* set up pointer to the dl_hdr, which is always at the start of $TEXT$ */
    dl_hdr          = (struct dl_header *) (shlib_text);

    /* Check shlib dl_header for consistency */
    if (dl_hdr->hdr_version != DL_HDR_VERSION_ID2 &&
	dl_hdr->hdr_version != DL_HDR_VERSION_ID)
	external_error(BAD_DL_HDR_VERS, shlib_name , 0);

#ifndef NO_MADVISE /* madvise not supported on 9.0 series 800 kernel */
    /*
    ** madvise that we usually won't need anything past the end of the
    ** shlib string table, which is the last thing in SHLIB_INFO for
    ** libraries that were built with the HP-UX linker.
    ** For those times when this is a faulty assumption, we incur a
    ** performance penalty but no correctness problems. For the same
    ** reason, we will generally ignore errors from madvise.
    ** The region we advise must have been mapped with mmap, and the
    ** start and length must be page aligned.
    */

    system_page_size = sysconf(_SC_PAGE_SIZE);
    assert(system_page_size > 0);

    needed_length = dl_hdr->string_table_loc + dl_hdr->string_table_size;
    needed_length = round(needed_length + dl_header_offset, system_page_size);
    unneeded_length = aux->exec_tsize - needed_length;

    if (unneeded_length > 0) {
	int i = madvise(shlib_text - dl_header_offset + needed_length,
			unneeded_length,
			MADV_RANDOM);
	assert(i == 0);
    }
#endif /* NO_MADVISE */

    if (dl_hdr->export_ext_loc == 0) { /* PRE DR_PROPAGATE shared library */
        fprintf(stderr, 
	 "ld : Shared Library %s does not have proper static data support. \n", 
	        shlib_name);
        fprintf(stderr, 
	 "     Rebuild with linker version A.08.30 or later. \n"); 

        exit(-1);
    }

    /* all of these point into text, and are therefore mapped */
    *shlib_list      = (struct shlib_list_entry *)
	(shlib_text + dl_hdr->shlib_list_loc);
    *import_list     = (struct import_entry *)
	(shlib_text + dl_hdr->import_list_loc);
    *hash_table      = (int *)
	(shlib_text + dl_hdr->hash_table_loc);
    *hash_table_size = (int) (dl_hdr->hash_table_size);
    *export_list     = (struct export_entry *)
	(shlib_text + dl_hdr->export_list_loc);
    *string_table    = (char *)
	(shlib_text + dl_hdr->string_table_loc);
    *dreloc_list     = (struct dreloc_record *)
	(shlib_text + dl_hdr->dreloc_loc);
    *export_list_ext = (struct export_entry_ext *)
	(shlib_text + dl_hdr->export_ext_loc);
    *mod_list        = (struct module_entry *)
	(shlib_text + dl_hdr->module_loc);

    return shlib_text;
}


/*
**	get_shlib_hpux_aux_header().  Broke this out too.
*/

static void get_shlib_hpux_aux_header (int fd,
				       struct header *header,
				       struct som_exec_auxhdr *aux,
				       char *filename)
{

    if (header->version_id != VERSION_ID)
	external_error(BAD_SOM_VERS, filename , 0);

    /* verify SOM header checksum */
    if (header->checksum != checksum(header, sizeof(struct header)))
	external_error(BAD_HEADER_CHECKSUM, filename, 0);

    /*
    ** read in the first (HP-UX) aux header to:
    ** get file offset and size of text, and
    ** get file offset and virtual start of data
    */
    ffetch(fd,
	   header->aux_header_location,
           aux,
	   sizeof (struct som_exec_auxhdr),
	   1); 

    /* verify that the first aux hdr is the HP-UX aux hdr */
    if (aux->som_auxhdr.type != HPUX_AUX_ID) {
	external_error(BAD_AUX_RECORDS, filename, 0);
    }
}


/*
 * shlib_search
 * This routine makes sure we need to search the given shlib, performs
 * some verification on the shlib, maps the shlib's text (for access to
 * the shared library tables), adds the library to the shlib list, 
 * resolves unsats, and adds soft unsats.
 *
 * This routine mmaps the shared library's text in case some of the shared
 * library tables are not in the first subspace in text. It is important
 * that these mmapped regions get unmapped before this routine returns.
 * This is done at the very end of the routine. To insure that the munmap
 * call is executed, DO NOT RETURN FROM THE BODY OF THIS FUNCTION after
 * the call to mmap.
 */

void shlib_search(dash_l_reference, 
		  cur_shlib_name, 
		  cur_shlib_fildes, 
		  cur_shlib_som_hdr,
		  add_lib_to_shlib_list,
		  do_full_sym_resolution)
Boolean dash_l_reference;	/* Was this shlib referenced by -l? */
char    *cur_shlib_name;	/* Filename of the current shlib */
int     cur_shlib_fildes;	/* File descriptor of the current shlib */
struct header  *cur_shlib_som_hdr;	/* Ptr to SOM header of current shlib */
Boolean add_lib_to_shlib_list;	/* Was this shlib seen on the command line? */
Boolean do_full_sym_resolution;	/* if true, do full sym resolution, else 
					only shlib "soft" unsats. */
{
    /* pointer to mapped text of shared library */
    char *shlib_text;
    
    /* pointers to shared library tables in $TEXT$ usually in $SHLIB_INFO$ */
    struct dl_header        *dl_hdr;          /* ptr to header record      */
    struct shlib_list_entry *shlib_list;      /* ptr to shlib list         */
    struct import_entry     *in_impt_list;    /* ptr to import list        */
    int                     *hash_table;      /* ptr to hash table         */
    int                      hash_table_size; /* hash table size           */
    struct export_entry     *expt_list;       /* ptr to export list        */
    char                    *string_table;    /* ptr to string table       */
    struct dreloc_record    *dreloc_rec_list; /* ptr to dynamic reloc recs */
    struct export_entry_ext *expt_list_ext;   /* ptr to export list ext.   */
    struct module_entry     *mod_list;        /* ptr to module list        */

    struct subspace_dictionary_record subsp;

    int univ_index;  	    /* index of univ sym */
    unsigned int hash_val;  /* hash value of symbol */ 
    struct som_exec_auxhdr HPUX_aux_record;

    int i;  /* loop counter */

    char *new_internal_name = NULL;     /* internal name of shlib we will
                                           search                       */
    char *base_internal_name = NULL;    /* base internal name (no path) */
    char *base_path = NULL;             /* path we found shlib in       */
    char *path_slash = NULL;            /* temp var for pointing to pos *
                                           of slash in shlib_name       */
    Boolean shlib_has_internal = FALSE; /* true if shlib has internal
					   name                         */
    int shlib_start = 0;                /* shlib list starting position */
    int path_size = 0;                  /* shlib path size              */

    /* working pointers for unsat symbol table searches */
    register struct symnode *n, *m;
    struct symnode *prevn, *nextn;

    struct shlib_list_entry *cur_shlib_node;  /*current shlib entry being set*/

    struct export_entry *exp_sym;  /* current exported symbol from shlib */
    int exp_index;

    char *shlib_name;		   /* name of the current shlib */
    char path_name[MAXPATHLEN+2];  /* assembled pathname */

    Boolean save_exports = TRUE;
       /** if doing +h -b, and make sure we only do it once */
    static Boolean embed_path_not_added = TRUE;        
    long dl_header_offset;

    /* verify that we need to search shared library now */

    /*
    ** 
    ** We want to search this shared library if we have not searched it
    ** at all or since the last .o or .a, since either of those could 
    ** have introduced unsats that we want to satisfy with this library,
    ** if possible. However, if we have searched the library before, we
    ** do not, even if TRUE is passed in add_lib_to_shlib_list, add this
    ** library to the shlib list, since it is already in the list. Also,
    ** if we have already saved the exports for this library, we do not
    ** want to do it again. See comments by shlib_seen_lately and 
    ** uniq_shlib_info for more details.
    */
    if (shlib_seen_lately(cur_shlib_fildes,
			  cur_shlib_name,
			  &add_lib_to_shlib_list,
			  &save_exports))
        return; /* don't search again */

    /*
    ** All we know here is that the file has SHL_MAGIC magic number,
    ** so verify the rest of the header.
    */
    /* verify SOM header version */

    /* Now do this in a routine for use by others. */
    get_shlib_hpux_aux_header (cur_shlib_fildes,
			       cur_shlib_som_hdr,
			       &HPUX_aux_record,
			       cur_shlib_name);

    /* Now call a routine to do this. */

    shlib_text = mmap_shlib_and_get_info (cur_shlib_fildes,
			                  cur_shlib_name,
					  cur_shlib_som_hdr,
			                  &HPUX_aux_record,
                                          &shlib_list,
                                          &in_impt_list,
                                          &hash_table,
                                          &hash_table_size,
                                          &expt_list,
                                          &expt_list_ext,
                                          &string_table,
                                          &dreloc_rec_list,
                                          &mod_list);

    dl_hdr = (struct dl_header *) shlib_text;

    /*
    **  Check for an internal name in a library. 
    ** 9.0 shlibs and 10.0 libraries that weren't built with +h 
    ** internal_name won't have one
    */
    if (dl_hdr->flags & SHLIB_INTERNAL_NAME)
        shlib_has_internal = TRUE;

    /* search all the libraries this shlib depends on first, if any */
    cur_shlib_node = shlib_list;

    /* make first pass over all the child libs, resolving all syms found */

    /*
    ** 9.0 shlibs and 10.0 shlibs that aren't built with +h internal name 
    ** will not have internal names stored at index 0 of the library list so
    ** we can start at 0 to look for dependent libraries.  For those shlibs
    ** with an internal name, we start at 1 because we always put the internal
    ** name at index 0 in the library list.  We'll go to the next node so
    ** if we call recursive_shlib_search(), we'll be on the correct node.
    */

    if (shlib_has_internal) {
        shlib_start = 1;
	cur_shlib_node++;
    } else
        shlib_start = 0;

    for (i = shlib_start; i < dl_hdr->shlib_list_count; i++) {
	recursive_shlib_search (
		  cur_shlib_node->dash_l_reference, 
		  & string_table[ cur_shlib_node->shlib_name ], 
		  TRUE);  /* do full sym resolution */
	cur_shlib_node++;
    }

    /* 
    ** make second pass over all the child libs, resolving "soft" unsats only 
    ** necessary to resolve backwards dependencies between shlibs without 
    ** dragging in the same sym from trailing archives. 
    */
    cur_shlib_node = shlib_list;

    /*
    ** If shared library has an internal name, 
    ** skip it in recursive_shlib_search().
    */
    if (shlib_has_internal) 
            cur_shlib_node++;

    for (i = shlib_start; i < dl_hdr->shlib_list_count; i++) {
	recursive_shlib_search (
		  cur_shlib_node->dash_l_reference, 
		  & string_table[ cur_shlib_node->shlib_name ], 
		  FALSE); /* do not do full sym resolution, only soft unsats */
	cur_shlib_node++;
    }

    shlib_name = get_shlib_name (dash_l_reference, cur_shlib_name, path_name);

    /* 
    ** We know the shared library filename by now; 
    ** get its internal name so we can insert it *later* into the library
    ** list of the target executable.  The internal name is *always* at 
    ** index 0 in the library list if present.
    **  If internal name starts with "/", we don't
    ** care where we found the shared library; stuff the fully qualified
    ** internal name into the library list of the executable; otherwise,
    ** append the internal name, even if it has a relative path, to the
    ** directory we found the shared library in.  The 10.0 BE linker will
    ** always produce shared libs (if +h specified) with NO path in the
    ** internal name.  The 10.0 GS linker allows users to specify a path.
    */
    if (shlib_has_internal) {
        /* 
        ** reset cur_shlib_node, then get internal name
        */
        cur_shlib_node = shlib_list;
  
        base_internal_name = & string_table[cur_shlib_node->shlib_name];
        /*
        ** if internal name starts with '/', use the fully qualified
        ** path as the name to put in the library list
        */
        if (base_internal_name[0] == '/') {
	    /**
	     ** strlen() doenot contain \0 character
	     ** at the end. Need to add 1 for the length. 
	     **/
            new_internal_name = (char *)emalloc(1+ strlen (base_internal_name));
            strcpy (new_internal_name, base_internal_name);
        } else {  /* relative path or no path included in internal name */
            /* get path from shlib_name */
            if (MB_CUR_MAX == 1) 
                path_slash = strrchr (shlib_name, '/');
            else
                path_slash = mb_strrchr (shlib_name, '/');

            /* bump one past the slash */
            path_slash++;

            path_size = path_slash - shlib_name;
            base_path = (char *) emalloc (path_size+1);
            base_path[path_size] = '\0';
 
            if (MB_CUR_MAX == 1)
                (void) strncpy (base_path, shlib_name, path_size);
            else
                (void) mb_strncpy (base_path, shlib_name, path_size);

            /* now append internal name */
            new_internal_name = (char *) emalloc (path_size + 2 +
                                 strlen (base_internal_name));
            strcpy (new_internal_name, base_path);
            strcat (new_internal_name, base_internal_name); 
            efree (base_path);
        }    
        if (verbose & V_ALLSTATS) 
            printf ("shlib internal_name = %s\n", new_internal_name);
    } /* shlib has internal name */

    /* start searching to resolve unsats */
    if (verbose & V_WHY)
	info_message(VERBOSE_SEARCHING, shlib_name, 0);
    if (trace_som)
	printf("%s:\n",shlib_name);
    /* 
    ** Removed #ifdef PBO for resolve_sym_only 
    ** since we can use these in non PBO environments.
    */

    if (trace_syms_only) {
	if (trace_sym_files [FS_TRACE_ALL])
            fprintf (trace_sym_files [FS_TRACE_ALL], "%s:\n", shlib_name);
        print_sl_export_list (expt_list, 
			      dl_hdr->export_list_count,
                              string_table);
    }

    /* If not just looking for "soft" unsats on second pass over "child" */
    /*     libs, make a pass over the unsat hash table trying to resolve */
    /*     unsats to this shlib. */

    if (do_full_sym_resolution) {


	resolve_unsats_with_exports (TRUE,   /* called during pass 1 */
				     cur_shlib_name,
				     cur_shlib_fildes,
				     shlib_text,
				     &HPUX_aux_record);
    }

    /* add library to searched shlib list */
    if (add_lib_to_shlib_list) {
	    char *new_name;

	if (out_shlib_list != NULL) {
	    out_shlib_list = (struct shlib_list_entry *) 
			erealloc((char *) out_shlib_list, 
				 (next_shlib_list_indx+1) * 
					sizeof(struct shlib_list_entry));
        } else { /* initial allocation */
	    assert( next_shlib_list_indx == 0 );
	    out_shlib_list = (struct shlib_list_entry *) 
			 emalloc( (building_incomp_exec ? 2 : 1) * 
			 	  sizeof(struct shlib_list_entry));

	    if (building_incomp_exec) {
		/* initialize first slot to point at a.out */
		cur_shlib_node = &out_shlib_list[next_shlib_list_indx++];
		/* set bind mode of a.out to value of last -B flag */
		cur_shlib_node->bind = bind_mode;
		cur_shlib_node->dash_l_reference = FALSE;
		cur_shlib_node->internal_name = FALSE;
		cur_shlib_node->reserved1 = 0;
		cur_shlib_node->highwater_mark = 0;  /* NULL in a.out */
		cur_shlib_node->shlib_name = shlib_string_add(output_name); 
	    }   /* end of a.out-only init */
	}	/* end of initial allocation */

        /*
        **  make sure we add embedded_path to the
        ** string table for +h -b combos.  We would already have added the
        ** internal name to out_shlib_list before we get here, so it's never
        ** NULL in this routine.  We also need to add the path for incomp
        ** executables.  And we only want to do this whole thing once 
        ** so set the global flag when we're done.
        */
        if (embed_path_not_added) {
            /*   Now we need to set the
	    ** embedded path for shared libs, too. */
	    if (embedded_path) { /* __NOT__ only for program files */
    	        /* must have added at least one string before      */
		/* embedded path so string index will not be 0.    */
		if (!strcmp (embedded_path, ":")) 
		    /* user has asked that linker form embedded path   */
		    /* from all the -L directories 	               */
		    build_embedded_path();

		if (embedded_path) { /* see if still have a path list */
		    embedded_path_index = shlib_string_add (embedded_path);
		    assert (embedded_path_index > 0);
		}
	    }
            embed_path_not_added = FALSE;
        }

 	cur_shlib_node = &out_shlib_list[next_shlib_list_indx++];
	cur_shlib_node->bind = bind_mode;
	cur_shlib_node->dash_l_reference = dash_l_reference;
	cur_shlib_node->highwater_mark = dl_hdr->highwater_mark;
	if (building_shlib)
	    max_shlib_version = max(dl_hdr->highwater_mark, max_shlib_version);

		/*   Now we need to look up the
		** shlib name in the "name pair list"; we may need to
		** rewrite the dirname path. */
	/* 
	** Here we add the internal name to the 
        ** library list
        ** And set the internal_name bit to true
	*/
        if (new_internal_name != NULL) {
            new_name = lookup_shlib_name_pair (new_internal_name);
            cur_shlib_node->shlib_name = shlib_string_add (new_name); 
            cur_shlib_node->internal_name = TRUE;

            efree (new_internal_name);
	    if (new_name != new_internal_name)
	        efree (new_name);
	} else {
 	    cur_shlib_node->shlib_name =
	               shlib_string_add (new_name =
				         lookup_shlib_name_pair (shlib_name));
            cur_shlib_node->internal_name = FALSE;

	    if (new_name != shlib_name)
	        efree( new_name);
        } /* else */
    } /* end of code to enter this shlib in shlib list */

    if (building_incomp_exec) { 

	/* Remember all exports from all shared libraries if we haven't
	** done it already. This is determined by save_exports after the
	** call to shlib_seen_lately above.
	*/
	/* remember shlib exports */

	if (save_exports) {
	    int export_idx;

	    for (export_idx = 0;  
		 export_idx < dl_hdr->export_list_count;
		 export_idx++) 
	    {
		saved_export_add(&string_table[expt_list[export_idx].name],
				 expt_list[export_idx].type,
#ifdef TSD 
				 (expt_list[export_idx].type != ST_DATA ?
				     expt_list[export_idx].info.size :
				     expt_list_ext[export_idx].size), 
#else
				 expt_list[export_idx].info.size,
#endif /* TSD */
				 expt_list[export_idx].is_tp_relative,
				 cur_shlib_name);
	    }
	}

	/* try to match all current soft unsats to the export table
           of this shlib. This will prevent the bringing in of archive
	   soms when a definition has already been seen. */
 	for (i = 0; i < UNSATHASHSIZE; i++) {
            for (n = shlib_unsat_hash_table[i]; n != NULL; ) {
		if (!n->exported_by_shlib) {
		    exp_index = shlib_match(hash_table, 
					    hash_table_size, 
				            expt_list, string_table, 
					    n->name, 
					    n->type);
		    if (exp_index != BAD_SYM) {
			exp_sym = &expt_list[exp_index];
			/* if we have a soft data unsat resolved to a 
			   soft storage request, promote the data unsat
			   to storage */
			if (exp_sym->type == ST_STORAGE && n->type == ST_DATA){
			    n->type = ST_STORAGE;
			    n->shlib_storage = TRUE;
			    n->len = exp_sym->info.size;
  		        }
#ifdef TSD
			/*  Need to do the same for tstor */
			if (exp_sym->type == ST_TSTORAGE && 
			    n->type == ST_DATA) {
                            n->type = ST_TSTORAGE;
			    n->shlib_storage = TRUE;
			    n->len = exp_sym->info.size;
			}
#endif /* TSD */
			n->exported_by_shlib = TRUE;
		    }
		}
		n = n->next;	
	    }
	}

    	/* 
	** add all this shlib's nonlocal imports to the "soft" unsat table so 
	** they will bring in archive SOMs to resolve the unsats if seen, but 
	** not cause errors if not seen (as they would in the main unsat 
	** table).  We are careful not to add in symbols from the import 
	** list that are also on the export list ("imports for exports"), 
	** as they are not needed to cause loading from later archive 
        ** libraries. 
	*/

        for (i=0; i < dl_hdr->import_list_count; i++) 
	    if (in_impt_list[i].type != ST_NULL) { /* if not a local */

	        char *name; /* temp for name strings */
		int type;
	        int new_sym_index;  /* index of new sym dict entry */
	        int len = 0;  /* length of storage requests */
		int exp_index;
		
		type = in_impt_list[i].type;
	        name = &string_table[in_impt_list[i].name];
		hash_val = hash_string(name);

		if (trace_list) {             /* trace import symbols */
		    check_trace_list(name, type, SS_UNSAT, cur_shlib_name);
		}
		new_sym_index = shlib_unsat_find(name,hash_val,type);

		if (new_sym_index == BAD_SYM) { /* add to "soft" unsat table */

		    univ_index = univ_find(name,FALSE,NULL,hash_val,type);
		    exp_index = shlib_match(hash_table,
					    hash_table_size,
					    expt_list,
					    string_table,
					    name,
					    type);

	            name = add_string(&tmp_strings, 
				      name, 
				      hash_string(name),
				      FALSE, 
				      TRUE);
	            new_sym_index = symbol_allocate(BAD_SUBSP);
	            Sym_Dict(new_sym_index).NAME_PT = name;
	            Sym_Dict(new_sym_index).q_nptr = NULL;
	            Sym_Scope(new_sym_index) = SS_UNSAT;
	            Sym_Dict(new_sym_index).symbol_type = type;
		    if (type==ST_STORAGE&&(exp_index != BAD_SYM))
		        len = expt_list[exp_index].info.size;

		    /*
		    ** Last arg to shlib_unsat_add is for exported_by_shlib 
		    ** flag. If this flag is set, soft unsat will not pull 
		    ** archive .o's in. univ_find will find data symbols 
		    ** copied into a.out, but must search shlib export table 
		    ** for code symbols 
		    */
	            shlib_unsat_add(name,
				    hash_val,
				    new_sym_index,
				    type,
				    len, 
				    (univ_index != BAD_SYM || 
				     exp_index != BAD_SYM));
		    /* 
		    ** If we are adding a soft unsat storage request, and
		    ** there is already a data universal that satisfies this
		    ** storage request, set the shlib_storage bit to false
		    ** so we don't try to bring in other data universals in
		    ** search_linear() or search_non_linear() 
		    */
		    if (type==ST_STORAGE && univ_index!=BAD_SYM) {
		        int tmp;

		        tmp = shlib_unsat_find(name,hash_val,type);
			Sym_Back_Ptr(tmp)->shlib_storage=FALSE;
		    }
		}
	    }

	} /* if building_incomp_exec */
    /*
    ** It is very important that we do not return from this routine
    ** in the body above after the mmap call near the beginning, or
    ** we will have a lot of mmapped baggage around. We ignore errors
    ** from munmap because they are not significant unless we called
    ** munmap wrong.
    */
    /* 
    ** the dl_header may now be at an offset from the start of text mapping.
    ** slib_text has already been adjusted by this offset.  We need to
    ** reverse the adjustment for the munmap call.
    */

#ifdef UNPAD_SL
    if (   (dl_header_offset = get_text_offset(cur_shlib_fildes, 
					       cur_shlib_som_hdr, 
					       &HPUX_aux_record))
	== -1){
       /*
       ** Error.  Give up.
       */
       switch (errno) {
       case ENOMEM:
	   system_error(OUT_OF_MEM, shlib_name, 0);
	   break;
       default:
	   system_error(FF_CANT_READ, shlib_name, 0);
	   break;
       }
    }
#else
   dl_header_offset = 0;
#endif
    i = munmap(shlib_text - dl_header_offset, 
	       (size_t)HPUX_aux_record.exec_tsize);
    assert(i == 0);
} /* end shlib_search() */

static int add_SHLIB_DATA_syms();
static int add_to_SHLIB_DATA();

#ifdef TSD 
/*****************************************************************************
** Adds symbol to univ table in a.out (causing an export table entry 
** in the a.out) for an imported data symbol and allocates space in the TSD
** for the symbol (sets "address").  Caller has already verified that no 
** Univ exists for the symbol (which is why we have the assert).
** Somewhat modelled after add_SHLIB_DATA_sym().  Called by 
** resolve_unsats_with_exports().
** 
** Parameters:
**     size: export symbol size (so we know how much TSD space to allocate)
**     name: symbol name
*****************************************************************************/
void create_tsd_export(int size,
		       char* name)
{
   int sym_index, univ_sym, i, new_len;
   unsigned int hashval;
   struct symbol_dictionary_record *sym;
   struct subspace_dictionary_record *subsp = NULL;

   /* Get the index of a $TBSS$ subspace and do data copying
    * for this TLS shlib export symbol and add it into this $TBSS$ subspace.
    * 
    * Since $TBSS$ might not exist in the object modules that we have read,
    * we might need to build one on the fly. 
    */
   if (TBSS_subsp_index == BAD_SUBSP) {
      TBSS_subsp_index = get_tbss_subsp_index();
   }
   
   assert(TBSS_subsp_index != BAD_SUBSP);

   sym_index = symbol_allocate(TBSS_subsp_index);
   hashval = hash_string(name);
   add_string(&sym_strings, name, hashval, FALSE, TRUE);
   univ_sym = univ_add(name, 
		       0, 
		       NULL, 
		       hashval, 
		       sym_index, 
		       ST_DATA);

   assert(univ_sym == sym_index);  /* symbol better be unique... */

   Sym_TLS(sym_index) = TRUE;
   sym = &Sym_Dict(sym_index);
   sym->symbol_type = ST_DATA;
   sym->symbol_scope = SS_UNIVERSAL;
   sym->NAME_PT = name;

   /* 
   ** Since we are creating a new symbol for a shlib export here, the value
   ** will be the current total TLS size.  Then we bump up the TLS size for
   ** the next symbol we create (if we create one).
   ** We have to properly align tbss_size before allocating
   **               the symbol
   */

   sym->symbol_info = TBSS_subsp_index;

#if 0 /* OLD CODE */
   sym->symbol_value = tbss_size;  

   new_len = tbss_size + size;

   if (size >= 2) {
      if (size == 2)
         new_len = round(new_len, 2);
      else if (size <= 4)
         new_len = round(new_len, 4);
      else if (size >= page_size) 
         Subsp_Dict(TBSS_subsp_index).alignment = 32;
      else 
	 new_len = round(new_len, 8);
   }

   tbss_size = new_len;  /* new TLS size */
#endif /* OLD CODE */

   if (size >= 2) {
      if (size == 2)
         tbss_size = round(tbss_size, 2);
      else if (size <= 4)
         tbss_size = round(tbss_size, 4);
      else if (size >= page_size) 
         Subsp_Dict(TBSS_subsp_index).alignment = 32;
      else 
	 tbss_size = round(tbss_size, 8);
   }

   sym->symbol_value = tbss_size;  
   tbss_size += size;  /* new TLS size */

   sym->q_nptr = NULL;	 /* checked in "count_symbols" */

   Subsp_Misc(TBSS_subsp_index).symbol_count++;
}
#endif /* TSD */

/*
**	Used to be sent the first 5 parameters + the shared lib file offset
**	where the data should be copied from, along with the mod_entry
**	of the export in the shared lib.
**	I got rid of the mod_entry parm (it was never used), and now send
**	the SOM aux header of the shlib; this along with the export index
**	allows us to get the file offset of the export.  The "adjustment"
**	calculation is now done here rather than by the caller.
*/

static void copy_export_sym_data (int export_indx, 
				  struct export_entry *expt_list,
				  struct export_entry_ext *expt_list_ext,
				  char *expt_strings, 
				  int cur_shlib_fildes,
				  struct som_exec_auxhdr *aux)

    /* adds symbol to univ table in a.out (causing an export table entry 
       in the a.out) for an imported data symbol and copies the data for 
       the symbol from the shared library to the a.out.

       Also copies symbols from shlib that have the same value to resolve 
       any primary defs a library may use that are associated with a 
       secondary symbol.

       Also generates a DR_PROPAGATE dreloc record if it is needed which
       will reference the a.out export symbol. 			        */


{
    static int buffer_size = 0;
    static int buffer_offset = 0;
    struct dreloc_record *dreloc_rec;
    int sym_index;
    int aout_symbol_value;
    int adjustment;
    int value;

    value = expt_list [export_indx].value;

    if (value >= aux->exec_tmem &&
		     (value < (aux->exec_tmem + aux->exec_tsize))) {
	adjustment = aux->exec_tfile - aux->exec_tmem;
    } else {
	adjustment = aux->exec_dfile - aux->exec_dmem;
    }

    aout_symbol_value = add_to_SHLIB_DATA(cur_shlib_fildes,
					  value + adjustment, 
 				          expt_list_ext[export_indx].size);

    sym_index = add_SHLIB_DATA_syms(aout_symbol_value,
				    export_indx, 
				    expt_list,
				    expt_list_ext, 
				    expt_strings); 

    /* generate DR_PROPAGATE dreloc */
    if (sym_index != BAD_SYM ) {

	if (buffer_offset + sizeof(struct dreloc_record) >= buffer_size) {
	    buffer_size += (100 * sizeof(struct dreloc_record));
                out_dreloc_list =
		     (struct dreloc_record *) 
			 erealloc ((char *) out_dreloc_list,
				   buffer_size);
        }
	buffer_offset += sizeof(struct dreloc_record);	

        dreloc_rec = &out_dreloc_list[DR_PROPAGATE_count++];

        dreloc_rec->value = expt_list_ext[export_indx].size;
        dreloc_rec->location = aout_symbol_value;  
        dreloc_rec->type = DR_PROPAGATE;
        dreloc_rec->symbol = sym_index;  /* will be matched with export sym
					    in relocate_shlib_info() */
                /* NO_DATA_COPY */
		/*   Now use "shlib" instead of "module_index"
		** to hold fixup_subsp. */
        dreloc_rec->shlib  = SHLIB_DATA_subsp_index;
        dreloc_rec->reserved = 0;
    }

} /* end copy_export_sym_data() */

static int add_to_SHLIB_DATA(cur_shlib_fildes, file_offset, size)
int cur_shlib_fildes;
int file_offset;
int size;
    /* copies data of given size from a shared library to the SHLIB_DATA
       subspace of an a.out */
{
    static int buffer_size = 0;
    static int buffer_offset = 0;
    char *buffer;
    int location;

    buffer = Subsp_Misc(SHLIB_DATA_subsp_index).subsp_data;
 
    /* round offset to natural alignment */
    if (size >= 2) {
    	if (size == 2)
            buffer_offset = round(buffer_offset, 2);
        else if (size <= 4)
            buffer_offset = round(buffer_offset, 4);
        else
            buffer_offset = round(buffer_offset, 8);
    }
    location = buffer_offset;

    if (buffer_offset + size >= buffer_size) {
        buffer_size += (TWO_KB + size);
	    buffer = erealloc(buffer, buffer_size);
        Subsp_Misc(SHLIB_DATA_subsp_index).subsp_data = buffer;
    }

    ffetch(cur_shlib_fildes, file_offset, buffer + buffer_offset, size, 1); 
    buffer_offset += size;
    Subsp_Dict(SHLIB_DATA_subsp_index).subspace_length = 
    Subsp_Dict(SHLIB_DATA_subsp_index).initialization_length = buffer_offset;
    
    return(location);

} /* end add_to_SHLIB_DATA() */

static int add_SHLIB_DATA_syms(aout_symbol_value, export_indx, 
			       export_list, export_ext, export_strings)
int aout_symbol_value;
int export_indx;
struct export_entry     *export_list;
struct export_entry_ext *export_ext;
char *export_strings;
{
    /* adds all exports from the shared library to the a.out symbol table 
       (which will force them to be exported by the a.out) that have the 
       same value as the export entry at "export_indx". Returns the symbol
       index of the symbol record associated with the export entry at 
       "export_indx", or BAD_SYM if all the symbols have already been added */ 
    int i;
    char *symbol_name;
    int univ_sym, sym_index;
    int symbols_added;
    struct symbol_dictionary_record *sym;
    unsigned int hashval;

    symbols_added = FALSE;

    /* make sure symbol record for "export_index" is added last so we know 
       what to return */
    i = export_ext[export_indx].same_list;  
    export_indx = i;

    do { 
        sym_index   = symbol_allocate(SHLIB_DATA_subsp_index);
  	symbol_name = &export_strings[export_list[i].name];
	hashval     = hash_string(symbol_name); 
  	symbol_name = add_string(&sym_strings, symbol_name, 
				 hashval, FALSE, TRUE);
        univ_sym = univ_add(symbol_name, 0, NULL, hashval, sym_index, ST_DATA);

        if (univ_sym == sym_index) {
	    symbols_added = TRUE;
            sym = &Sym_Dict(sym_index);
            sym->symbol_type = ST_DATA;
            sym->symbol_scope = SS_UNIVERSAL;
            sym->NAME_PT = symbol_name;
            sym->q_nptr = NULL;	 /* checked in "count_symbols" */
	    Sym_Subsp(sym_index) = SHLIB_DATA_subsp_index;
            Subsp_Misc(SHLIB_DATA_subsp_index).symbol_count++;
            sym->symbol_value = aout_symbol_value;
	}
        i = export_ext[i].same_list;
    } while (i != export_indx);

    if (symbols_added)
        return(sym_index);
    else
	return(BAD_SYM);

} /* end add_SHLIB_DATA_syms() */

add_module_rec(start_sym_bias)
int start_sym_bias;
    /* adds an entry to the shared library module table and initializes it */
{
    static max_index = 0;
    int start;

    if (shlib_module_count >= max_index) {
	start = max_index;
        max_index += 100;
	    shlib_module = 
		(struct module_entry *) 
		    erealloc ((char *) shlib_module, 
			      max_index * sizeof(struct module_entry));
	    shlib_module_misc =
	       (struct module_misc *) 
		   erealloc ((char *) shlib_module_misc, 
			     max_index * sizeof(struct module_misc));
	memset((char *)&shlib_module[start], '\377', 
	       (max_index - start) * sizeof(struct module_entry));
    }

    shlib_module[shlib_module_count].flags = 0;
    shlib_module_misc[shlib_module_count].start_subsp_indx =
      cur_subsp_index_bias;
    shlib_module_misc[shlib_module_count].end_subsp_indx = subsp_dict_size -1;
    shlib_module_misc[shlib_module_count].dreloc_list_index = 0;
    shlib_module_misc[shlib_module_count++].symbols = 
					    sym_dict_size - start_sym_bias;

} /* end add_module_rec() */

/* 
 *
 * add_singleton_module_rec()   Routine to add a single module record when
 *                              building shared libraries that do not use
 *                              smart bind. This function must never be used
 *                              in the same link as add_module_rec().
 */

add_singleton_module_rec(int subsp_dict_size, int sym_dict_size) {
   assert(shlib_module_count == 0);

   /* First allocate the module entry */

   shlib_module = 
     (struct module_entry *) malloc(sizeof(struct module_entry));

   shlib_module_misc = 
     (struct module_misc *)malloc(sizeof(struct module_misc));

   memset((void *)shlib_module, 0xff, sizeof(struct module_entry));


   /* Now, fill in the fields to accomodate all the subspaces in the link */

   shlib_module[0].flags = 0;
   shlib_module_misc[0].start_subsp_indx = 0;
   shlib_module_misc[0].end_subsp_indx = subsp_dict_size - 1;
   shlib_module_misc[0].dreloc_list_index = 0;
   shlib_module_misc[0].symbols = sym_dict_size;

   shlib_module_count = 1;
}

#ifdef DEBUG
void dump_sym_list(n,printstr)
struct symnode *n;
char *printstr;
{
	int count = 0;
	printf ("\n%s\n", printstr);
	while (n != NULL) {
	    if (n->name == NULL) {
		printf ("NULL name found at chain location %d.\n", count);
		return;
    	    }
	    if (count < 45)
		printf ("%d : index %d, symbol %s\n", 
			count, 
			n->index,
			n->name);
	    count++;
	    n = n->next;
	}
    printf ("Chain End found at location %d.\n", count);
}
#endif /* DEBUG */

void allocate_export_list(new_elt_count)
int new_elt_count;  /* new length of the table(s) in elements */

/* 
** allocates (or reallocates) the output Export List and (if building a shlib)
** the Export List Extension in memory. No other routine should change the
** size of these data structures until finally deallocated.  
**
** assumes "erealloc" code that switches to use "malloc" if the arg is NULL 
**
*/

#define MIN_NEW_ALLOC	10	/* minimum number of elements to extend by,
				   keeps pad from building up very slowly */

#define EXPORT_ALLOC_PAD	1.1	/* pad length factor to build into the 
					   table(s) to cut down realloc freq */
{

    static int alloc_elt_count = 0;  /* length actually allocated */

    assert (new_elt_count > 0);  /* must be positive */
    assert (new_elt_count >= export_entry_count);  /* no decreases in size */

    if (new_elt_count > alloc_elt_count) {

	/* Expand the Export List */
	alloc_elt_count = 
	    (int) ((MIN_NEW_ALLOC + new_elt_count) * EXPORT_ALLOC_PAD);
        out_export_list = (struct export_entry *)
	    erealloc((char *) out_export_list,
		     alloc_elt_count * sizeof(struct export_entry));
	out_explist_subsp = (int *) erealloc((char *) out_explist_subsp,
					     alloc_elt_count * sizeof(int));

	if (building_shlib) {
            /* Expand the Export List Extension */
            out_export_ext = (struct export_entry_ext *)
		erealloc((char *) out_export_ext, 
			 alloc_elt_count * sizeof(struct export_entry_ext));
	}
    }
    /* else just return, tables were previously allocated long enough to 
       cover this expansion */

#undef EXPORT_ALLOC_PAD /* local definition only */
#undef MIN_NEW_ALLOC /* local definition only */
}  /* end allocate_export_list */


void allocate_PLT()
/* 
** allocates (or reallocates) the Procedure Linkage Table in memory 
** for initial or reallocation, the input value "PLT_entry_count" is pre-set 
*/

/* uses "erealloc" code that switches to use "malloc" if the arg is NULL */
{
    /* allocate PLT */
    int PLT_area_size = PLT_entry_count * sizeof(struct PLT_entry);

    if (PLT_area_size > 0) {
            out_PLT_list = (struct PLT_entry *)erealloc((char *) out_PLT_list,
							PLT_area_size);
    }
}  /* end allocate_PLT */


/* copy_orig_sym_for_imp_stub is made from save_orig_sym_for_exp_stub
	It is used when we don't want to overwrite the original symbol
	with the import stub.  Instead we overwrite a copy of the 
	original symbol with the import stub.  The index of the new
	copy is returned.
*/

int copy_orig_sym_for_imp_stub(orig_sym_index)
int orig_sym_index;  /* index of original symbol to be copied */
{
    int new_sym_index;  /* index of copied symbol */
    int exp_stub_index = Sym_Related_Stub(orig_sym_index);

    /* 
    ** make a copy of the original sym which will be overwritten with
    ** the import stub.
    */
    new_sym_index = symbol_allocate(Sym_Subsp(orig_sym_index));
    Sym_Dict(new_sym_index) = Sym_Dict(orig_sym_index);
    Sym_Misc(new_sym_index) = Sym_Misc(orig_sym_index);

    /* 
    **            the problem here is that the above copy performs a
    **      shallow copy on the misc parts of the symbol records
    **      which effectively makes mapped_to_a pointers for both
    **      symbols point to the same place, causing a lot of 
    **      problems later on in remapping one symbol to another
    **      (remap_sym_records()).  the "solution" here is to 
    **      "forget" about one of the mapped_to_a pointers (by
    **      resetting it).  this avoids the problem with the 
    **      remapping of the symbols.  the question is which symbol
    **      should we forget about:  while limited testing appears
    **      to show that it does not really matter what symbol you
    **      forget, i am choosing to NOT forget the symbol which 
    **      will become an import stub.  thus, all remappings will
    **      go the import stub (which makes sense to me).
    **
    **      by similar logic, the save_orig_sym_for_exp_stub function
    **      is modified, but in their case, we take the new_sym_index,
    **      which (if you look at the callers of that function) will
    **      become an import stub.
    */

    /*  Since we are not doing a remap, the remap
     *              array should stay with the *original* symbol
     *  	    not the copy. Otherwise, we leave the remap
     *              information in a very inconsistent state.
     *              The mapped_to_a array says that several symbols
     *              are mapped to copy, when in reality, they are
     *              mapped to the original. If we remap the copy
     *              to another symbol, we drag along all of the
     *              symbols in the mapped to array, even though
     *              we never actually mapped the original to the
     *              copy.
     */

    Sym_Misc(new_sym_index).mapped_to_a = NULL;
    Sym_Misc(new_sym_index).mapped_to_sz = 0;
    Sym_Misc(new_sym_index).mapped_to_cnt = 0;

    /* 
    ** may not be an actual export stub, may be an unsat that we must save
    ** for setting the module_index field when we build the export entry 
    */

    if (exp_stub_index != BAD_SYM) 
        Sym_Related_Stub(exp_stub_index) = orig_sym_index;
    else
        Sym_Related_Stub(new_sym_index) = orig_sym_index;
    Sym_Related_Stub(orig_sym_index) = BAD_SYM;
    return new_sym_index;
} /* end copy_orig_sym_for_imp_stub */

/* If save_orig_sym_for_exp_stub is updated, copy_orig_sym_for_imp_stub 
** should probably be updated in the same way. 
*/

void save_orig_sym_for_exp_stub(orig_sym_index)
int orig_sym_index;  /* index of original symbol to be copied */
{
    int copied_sym_index;  /* index of copied symbol */
    int exp_stub_index = Sym_Related_Stub(orig_sym_index);

    /* 
    ** make a copy of the original sym for the address of the actual routine
    ** to use in building the export stub, since the original symbol is
    ** overwritten by "add_import_stub" below.  Copy hangs off the 
    ** "misc->related_stub" field of the export stub.
    */
    copied_sym_index = symbol_allocate(Sym_Subsp(orig_sym_index));
    Sym_Dict(copied_sym_index) = Sym_Dict(orig_sym_index);
    Sym_Misc(copied_sym_index) = Sym_Misc(orig_sym_index);

    /* 
    **      for the explanation of why the next 3 lines of code
    **      have been put here, see description in the function
    **      copy_orig_sym_for_imp_stub().
    */

    /*  Since we are not doing a remap, the remap
     *              array should move to the copied symbol
     *  	    not the original, since the copy will be used
     *              in place of the original and the original will
     *              be overwritten. Otherwise, we leave the remap
     *              information in a very inconsistent state.
     *              The mapped_to_a array says that several symbols
     *              are mapped to copy, when in reality, they are
     *              mapped to the original. If we remap the copy
     *              to another symbol, we drag along all of the
     *              symbols in the mapped to array, even though
     *              we never actually mapped the original to the
     *              copy.
     */

    Sym_Misc(orig_sym_index).mapped_to_a = NULL;
    Sym_Misc(orig_sym_index).mapped_to_sz = 0;
    Sym_Misc(orig_sym_index).mapped_to_cnt = 0;

    /* 
    ** may not be an actual export stub, may be an unsat that we must save
    ** for setting the module_index field when we build the export entry 
    */

    if (exp_stub_index != BAD_SYM) 
        Sym_Related_Stub(exp_stub_index) = copied_sym_index;
    else
        Sym_Related_Stub(orig_sym_index) = copied_sym_index;
    Sym_Related_Stub(copied_sym_index) = BAD_SYM;
} /* end save_orig_sym_for_exp_stub */

static Boolean has_shlib_refs(n)
register struct symnode *n;

/* 
** Use the fact that only symbols built on the fly will have -1 in 
** the index or subspace fields.  Will export -u symbols as well, but
** they are rare and will still be correct. 
*/
{
	do {
	    if (n->index == BAD_SYM)
		return(TRUE);
	    if (Sym_Subsp(n->index) == BAD_SUBSP)
		return(TRUE);
	    n = n->same;
	} while (n != NULL);
	return (FALSE);
}  /* end "has_no_shlib_refs" */

int hash_tbl_size (init_len)
int init_len; /* initial length of table in elements to be hashed into tbl */
{
#define LOAD_FACTOR_CONST	(1.3)	/* give tbl average loading of ~70% */

#if 0 /* */
    static int primes[] = { 1, 19, 47, 79, 109, 151, 191, 229, 271, 317, 373,
                            421, 463, 521, 577, 619, 673, 733, 787, 839, 887,
                            953, 1051, 1103 };
#endif
    /*large shared library hash table */
    static int primes[] = { 1, 19, 47, 79, 109, 151, 191, 229, 271, 317, 373,
                            421, 463, 521, 577, 619, 673, 733, 787, 839, 887,
                            953, 1051, 1103, 1511, 2003, 2503, 3001, 3511,
                            4001, 4507, 5003, 6007, 7001, 8009, 9001, 10007,
                            12007, 14009, 16001, 18013, 20011, 22003, 24001,
                            26003, 28001, 30011, 32003, 34019, 36007, 38011,
                            40009, 43003, 46021, 49003, 52009, 55001, 58013,
                            61001, 64007, 67003, 70001, 73517, 77003, 80513,
                            84011, 87509, 91009, 94513, 98009, 100003 };
				 /*table of primes for hash table size*/
    int ret_val;  /* temp for return value */
    int i;  /* loop counter */

    /* large shared library hash table */
    /* The last entry in primes[] should be equal to MAX_SHLIB_HASH_LEN */
    assert(MAX_SHLIB_HASH_LEN == primes[ (sizeof(primes) / sizeof(int)) - 1 ]);

    for (i = 0; i < (sizeof(primes) / sizeof(int)); i++) {
	ret_val = primes[i];
	if (ret_val > (int) (LOAD_FACTOR_CONST * init_len) )
	    break;  /* give hash table an average loading of ~ 70% */
    }
    return(ret_val);

#undef LOAD_FACTOR_CONST
}	/* END "hash_tbl_size" */

int sec_shl_str_add(name, type)
char *name;
int type;
{
	char buf[MAXPATHLEN+1];   /* temp buffer for primary symbol name */
	int exp_index;   /* export table index for primary symbol */

	/* build primary symbol name from secondary def symbol */
	buf[0] = '_';  /* leading underscore for primary symbol */
        strcpy (&buf[1], name);

	exp_index = shlib_match(out_hash_tbl, out_hash_tbl_len, 
				out_export_list, out_shlstr_table, buf, type);
	if (exp_index == BAD_SYM) 
	    return(shlib_string_add(name));
	return(out_export_list[exp_index].name + 1);  /* elide leading '_' */
}	/* END "sec_shl_str_add" */


/*
**	get_saved_shared_lib_header().  This is called at the end of
**	shared lib processing from resolve_unsats_with_exports().  It
**	returns the open file descriptor.
*/

static int get_saved_shared_lib_header (char *filename,
					struct header *header)
{
    FILE *fp;
    int fd;

    fp = efopen (filename, "r", CANT_OPEN);
    fd = fileno (fp);

    ffetch(fd, 0, (void *) header, sizeof (struct header), 1);

    /* make sure the file has shared library magic number */
    if (header->a_magic != SHL_MAGIC)
        external_error(BAD_LIB_HEADER, filename, 0);

    return fd;
}


/*
**	resolve_unsats_with_exports().  This breaks out the functionalty
**	in shlib_search() where we resolve any current unsats to exports
**	in the current shared lib.  We also use this at the end of pass 1,
**	to resolve any unsats to the "saved export list", new for 10.0.
**
**	"during_pass1" is TRUE if this was sent from shlib_search();
**	FALSE if sent from collect_soms().  If it's FALSE, the last
**	5 parameters are don't care's.
*/

void resolve_unsats_with_exports (Boolean during_pass1,
				  char *shlib_name,
				  int filedesc,
				  char *text_addr,
				  struct som_exec_auxhdr *aux)
{
    int i;
    int export_type;
    int export_size;
    int export_index;
    char *export_name;
    int univ_index;
    unsigned int type;	 /* TSD */
    struct symnode *m, *n, *prevn, *nextn;
    Boolean found_export;

    struct dl_header *dl_hdr;
    struct som_exec_auxhdr aux_record;
    struct header header;

    int *hash_table;
    int hash_table_size;
    struct export_entry *export_list, *export_sym;
    struct export_entry_ext *export_list_ext;
    char *string_table;

	/* Unused dummys, for use with mmap_shlib_and_get_info() */
    struct shlib_list_entry *shlib_list;
    struct import_entry *import_list;
    struct dreloc_record *dreloc_list;
    struct module_entry *mod_list;
    long dl_header_offset;
#ifdef TSD 
    unsigned int is_TLS;
    int sym_ind;
#endif /* TSD */
    Boolean remove_unsat_hash_node;

    dl_hdr = (struct dl_header *) text_addr;

    if (during_pass1) {
	hash_table      = (int *)
		                      (text_addr + dl_hdr->hash_table_loc);
	hash_table_size = (int)                    dl_hdr->hash_table_size;
	export_list     = (struct export_entry *)
	                              (text_addr + dl_hdr->export_list_loc);
	export_list_ext = (struct export_entry_ext *)
	                              (text_addr + dl_hdr->export_ext_loc);
	string_table    = (char *)
	                              (text_addr + dl_hdr->string_table_loc);
    }

    for (i = 0; i < UNSATHASHSIZE; i++) {
	prevn = NULL;
	for (n = unsat_hash_table[i]; n != NULL; n = nextn) {
	    nextn = n->next;
	    found_export = FALSE;
	    remove_unsat_hash_node = TRUE;
#ifdef TSD 
	    is_TLS = 0;
#endif /* TSD */

	    if (during_pass1) {
		export_index = shlib_match(hash_table,
                                           hash_table_size,
					   export_list,
					   string_table,
					   n->name,
					   n->type);
		found_export = (export_index != BAD_SYM);
	    } else {
		found_export = saved_export_match (n,
						   &export_type,
						   &export_size,
#ifdef TSD 
						   &is_TLS,
#endif /* TSD */
						   &shlib_name);
	    }
	    if (found_export) {

		if (during_pass1) {
		    export_sym = &export_list [export_index];
		    export_type = export_sym->type;

#ifdef TSD 
/*  Get the size from export_list_ext for ST_DATA;
 * Now export_size is not just used for ST_STORAGE.
 */
		    export_size = (export_type != ST_DATA ? 
				      export_sym->info.size :
				      export_list_ext[export_index].size); 
		    is_TLS = export_sym->is_tp_relative;
#else 
		    export_size = export_sym->info.size;
#endif /* TSD */
		}

		if (trace_list)
		    check_trace_list(n->name,
				     export_type,
				     SS_UNIVERSAL,
				     shlib_name);

	        if (n->type == ST_NULL) {
		    /* user defined unsat, ignore and remove from unsats 
		       since we will be bringing in the shared lib anyway */
		    if (prevn == NULL) 
		        unsat_hash_table[i] = nextn;
		    else 
		        prevn->next = nextn;
		    continue;
		}

		/* if match found */ 
		switch (export_type) {
		    case ST_DATA:  /* Shlib Data Univ matched to 
				      a.out Storage Request or Data UNSAT */
#ifdef TSD 
			/*
			** If the export is TLS, assume the
			** the Data Unsat is TLS because we don't catch symbol
			** mismatches until we process the fixups.
			** 
			** If an unsat in an a.out is resolved by a TLS
			** shared lib export, we MUST do data copying for
			** it (can't rewrite instructions to do import).
			*/
			remove_unsat_hash_node = FALSE;
		        if (is_TLS == 1) {
		           if (building_incomp_exec || building_shlib) {
 		              n->next = data_satisfied_unsats;
		              data_satisfied_unsats = n;
			      remove_unsat_hash_node = TRUE;
		           }
                        } else
#endif /* TSD */
			if (! (building_incomp_exec && !do_data_copy)) {
			    n->next = data_satisfied_unsats;
			    data_satisfied_unsats = n;
			    remove_unsat_hash_node = TRUE;
			}

			if (building_incomp_exec &&
                            univ_find(n->name,
				      0,
			 	      NULL,
			  	      n->hashval,
			 	      ST_DATA) == BAD_SYM) {
#ifdef TSD 
			    if (is_TLS == 1) {

/*   Now pass export_size to create_tsd_export()
 * and export_size is export_list_ext[export_index].size for ST_DATA;
 * is export_list[export_index].info.size for other types.
 */
			       create_tsd_export(export_size, n->name);
			       break;
			    } 
#endif /* TSD */
			    if (do_data_copy) {

				if (during_pass1) {
                                    copy_export_sym_data (export_index,
                                                          export_list,
                                                          export_list_ext,
                                                          string_table,
                                                          filedesc,
                                                          aux);

				/* Here comes a ...
				** We need to open/read the shared library
				** (again) to get the info we need to call
				** copy_export_sym_data() */
				} else {

				    filedesc = get_saved_shared_lib_header (
								 shlib_name,
							         &header);
				    get_shlib_hpux_aux_header (filedesc,
							       &header,
							       &aux_record,
							       shlib_name);
				    text_addr = mmap_shlib_and_get_info (
							      filedesc,
							      shlib_name,
							      &header,
							      &aux_record,
							      &shlib_list,
							      &import_list,
							      &hash_table,
							      &hash_table_size,
						              &export_list,
						              &export_list_ext,
						              &string_table,
							      &dreloc_list,
							      &mod_list);

				    export_index = shlib_match(hash_table,
							       hash_table_size,
							       export_list, 
			                                       string_table,
							       n->name,
							       n->type);
					/* If it's BAD_SYM, 
					**  */
				    assert (export_index != BAD_SYM);

			    	    copy_export_sym_data (export_index,
						          export_list,
                                                          export_list_ext,
                                                          string_table,
					                  filedesc,
						          &aux_record);
                                    munmap(text_addr,
				           (size_t) (aux_record.exec_tsize));
				    close (filedesc);
				}

			    } else {
#ifdef DEBUG
				if (verbose & V_NO_DATA_COPY) {
				    printf ("process_remaining"
					    "_shlib_exports: "
				            "adding ");
				    printf ("\"%s\" (ST_DATA) to ", n->name);
				    printf ("shared global list\n");
				}
#endif /* DEBUG */
			    	add_to_shared_global_list (n, FALSE);
			    }
			}
               		break;
#ifdef TSD 
		    case ST_TSTORAGE:
			/* 
			**  Need to set the TLS bit for the imports
			** to this shlib export so we don't get the mismatched
			** symbol error later.
                        */
                        if (building_incomp_exec) {
                           Sym_TLS(n->index) = TRUE;
                        }
			break;
#endif /* TSD */
		    case ST_STORAGE:
		    	if (building_incomp_exec) {
			    if (do_data_copy) {

                    /* 
		       We don't want a data unsat in a shlib to be resolved
		       by an exported storage request in another shlib when
		       building a shlib, since that means down the road in
		       shlib_build_tables() we will promote the data unsat to
		       a storage request and then we will have TWO copies of
		       the storage request, one in each library.  Normally,
		       dld will pick the right one for everyone, but if
		       symbols are hidden in the shlib being built, it may
		       use one copy and the dependent shlib would use
		       another.  BOGUS!  */
                        /* just add this sym to "same" list and
                           wait for "shlib_build_tables" pass */
                        /* call to "unsat_add" here didn't work for qualified
                           syms as would not merge with unqualified syms onto
                           "same" list  */
                        	m = get_node(
				         add_string(&sym_strings, 
				                    n->name,
				                    hash_string(n->name),
				                    FALSE, TRUE),
                                         FALSE,
					 NULL,
					 n->hashval,
					 BAD_SYM,
					 ST_STORAGE,
                                         export_size);
                        	m->same = n->same;
   				n->same = m;

                        	if (n->type == ST_STORAGE &&
					       n->len < export_size) {
				    n->len = export_size;
				}
			    } else {
			    	add_to_stor_req_list (n);
			    }
		    	}
                        break;

		    case ST_STUB:
		    case ST_CODE:
		    case ST_PRI_PROG:
		    case ST_SEC_PROG:
		    case ST_ENTRY:
		    case ST_MILLICODE:
			code_matches_found++;	

			/* link into list to be processed */
			n->next = code_satisfied_unsats;
			code_satisfied_unsats = n;
               		break;

		    default:
                        external_error_sn(BAD_SYM_TYP_SS_UNSAT,
					  shlib_name,
                                          export_type);
               		break;
                    }  /* end switch */
		
		/* unlink from unsat_hash_table */
                /* Don't unlink ANY shared global from
                ** the unsat_hash_table; we'll take care of it in
                ** storage_create(). */
                /* NO_DATA_COPY */
		if (export_type != ST_STORAGE &&
#ifdef TSD 
                    export_type != ST_TSTORAGE &&
#endif /* TSD */
		    remove_unsat_hash_node) {

	    	    if (prevn == NULL)
	                unsat_hash_table[i] = nextn;
	    	    else
		        prevn->next = nextn;
		} else {
                        /* need to set prevn here since the node is not
                           removed from the hash list if type storage
                            */
                    prevn = n;
                }

	    } else {     /* Didn't find export to match this unsat */
		prevn = n;
	    }
    	}	/* for each element in the hash chain */ 
    }    /* for each hash chain */


        /* resolve all unsats found in the a.out that were resolved by
           the shlib. All exports copied over from shared lib will have
           been added to symbol table through copy_export_sym_data() */
    if (building_incomp_exec) {
    	for (n = data_satisfied_unsats; n != NULL; n = nextn) {
	    nextn = n->next;
	    type = ST_DATA;

           if ((univ_index = univ_find(n->name,
					0,
					NULL,
					n->hashval,
					type)) != BAD_SYM) {
		unsat_resolve(n->name,
			      0,
			      NULL,
			      n->hashval,
			      univ_index,
                              type,
			      NULL);

                /* now resolve all the symbols on the same list for the
                   "data_satisfied_unsats" symbol */
	    	for (m = n; m != NULL; m = m->same) {
                    /* careful of user and library-created symbols */
	    	    if (m->index != BAD_SYM) {
		        symbol_resolve(m->index,univ_index);
	    	    }
	    	}
	    } /* univ_find */
    	} /* for */
    }  /* building_incomp_exec */
} /* end resolve_unsats_with_exports */

#define  DEFAULT_ARG_RELOC      0x155   /* default value to say "don't know" */

#define  DOING_SATS		0
#define  DOING_STOR_REQS	1
#define  DOING_UNIVS		2
#define  DOING_SECS		3
#define  DOING_LOCALS		4
#define  DOING_UNSATS		5
#define  DOING_EXEC_EXPS	6

#ifdef TSD 
void shlib_build_tables (bss_subsp, tbss_subsp)
int bss_subsp; /* subspace to put storage requests into */
int tbss_subsp;
#else
void shlib_build_tables (bss_subsp)
int bss_subsp; /* subspace to put storage requests into */
#endif /* TSD */
{
    struct subspace_dictionary_record *subsp = NULL; /*pointer to $BSS$ rec*/
    struct symbol_dictionary_record *sym;       /* $BSS$ symbol to be updated*/
    int new_len;  				/*new length of $BSS subspace*/

#ifdef TSD 
    struct subspace_dictionary_record *tsubsp = NULL; /* ptr to $TBSS$ rec */
    struct symbol_dictionary_record *tsym;       /* $TBSS$ sym to be updated*/
    int new_len_tbss;  				/*new length of TBSS subsp */
#endif /* TSD */

    int cur_Import_Indx = 0;  /* Current index into import table */ 

    int *cur_DLT_node;  		/* current DLT entry being processed */
    int cur_PLT_count;  		/* index of current PLT entry */

    int storage_reqs_found = 0;   /* number of storage reqs left unresolved */
    struct symnode *storage_reqs_list = NULL;    /* linked list for later 
						    processing */

    int univ_code_sym_count;   /* count of all univ code syms for export tbl */
    int univ_data_sym_count;   /* count of all univ data syms for export tbl */
    int hidden_data_sym_count; /* count of all univ data syms hidden         */

    int data_unsats_left;       /* num data unsats left unresolved in shlib */
    unsigned int hashkey;       /* temp bucket number for hash table access */
    int type;                   /* copy of original dictionary symbol type */

    struct export_entry *cur_export_node;   /* ptr to curr output export list 
					       item */
    int *cur_export_subsp;		    /* ptr to curr export subspace */

    struct import_entry *cur_import_node;   /* ptr to curr output import list 
					       item */

    int last_stub;                      /* index of last import stub seen */

    int i, j;  /* loop counters */

    /* working pointers for symbol table searches */
    register struct symnode *n, *m, *last;

    int shlib_sym;     /* offset into shlib string table */
    int sym_index;

    int millicode_unsats;

#if 0 /*  */
    for (i = 0; i != UNIVHASHSIZE; i++)
        out_hash_tbl[i] = EMPTY;  /* initialize hash table in memory */
#endif
    /* large shared library hash table */
    for (i = 0; i != MAX_SHLIB_HASH_LEN; i++)
        out_hash_tbl[i] = EMPTY;  /* initialize hash table in memory */

    /* remove all "soft" unsats that were created by a shared library */
    cleanup_shlib_unsat_tbl();
        /* 
	** must be before next section of code to keep "unsat_resolve" from
        ** resolving syms from one shlib's "soft" unsats to another shlib.
	** I.e., if an unsat for printf comes after libc.sl, it would become
	** an export because the later "soft" unsat would be "resolved" by
	** the code below, causing it erroneously to be put on the 
	** "minimum_export_list". 
	*/

    /* resolve all code unsats that were resolved by a shared library */
    for (n = code_satisfied_unsats; n != NULL; n = n->next) {
	int hash_val = hash_string(n->name);
	j = univ_find(n->name,0,NULL,hash_val,ST_CODE);
	unsat_resolve(n->name,
		      0,
		      NULL, 
		      hash_val,
		      (j == BAD_SYM ? n->index : j),
		      ST_CODE,
		      NULL);
    }

    /* count all unsat symbols to be imported for the import list */
    code_unsats_left = 0;
    data_unsats_left = 0;
    millicode_unsats = 0;
    for (i = 0; i != UNSATHASHSIZE; i++) {

		/* 
		** The problem here is that when we hit a qualified storage
		** request during this traversal (see below), we will call
		** unsat_resolve() to attempt to resolve any __unqualified__
		** data unsats to the same symbol: unsat_add() would have
		** added them to different hash nodes (not to the same list).
		** After we call unsat_resolve(), the hash chain may, indeed,
		** be in an inconsistent state.  So the existing code sets
		** "n" to be the head of the hash chain (unsat_hash_table[i]),
		** and starts the hash chain traversal afresh.
		** The problem with this is that hash chain nodes that have
		** already been visited, and data added for them, will now
		** be recorded __twice__.  This is bad.
		** hash bucket chain, set each node's checked bit to 0;
		** set it to 1 if we visit a non-Stor symbol.  Then if during
		** our traversal of the hash chain on a potentially second
		** trip, we'll bypass any node whose checked bit is set.
		** We don't need to set the checked bit to 1 for a Stor
		** symbol, 'cause every Stor node is going to be unlinked
		** from the chain anyway.
		*/
    	for (n = unsat_hash_table[i]; n; n = n->next)
	    n->checked = FALSE;

		/* This is the __real__ hash chain traversal */
        for (n = unsat_hash_table[i]; n != NULL; ) {

		/* See verbose "checked" comment above */
	    if (n->checked) {
    		last = n;
    		n = n->next;
    		continue;
	    }
#ifdef TSD 
	    if (n->type == ST_DATA || n->type == ST_STORAGE ||
                n->type == ST_TSTORAGE) {
#else
	    if ((n->type == ST_DATA) || (n->type == ST_STORAGE)) {
#endif /* TSD */
#ifndef ESOM
		for (m = n->same; m != NULL; m = m->same) {
		    if (m->type == ST_STORAGE) {  /* resolve to largest req */
			n->type = ST_STORAGE;  /* for import list, etc. */
			if (m->len > n->len) {
			   n->len = m->len;
			   /* doom support */
			   if (n->index != BAD_SYM && m->index != BAD_SYM)
			      Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		        }
#if 0
			n->len = max(n->len,m->len);
#endif
		    }
#ifdef TSD 
		    else if (m->type == ST_TSTORAGE) {
		        n->type = ST_TSTORAGE;
			if (m->len > n->len) {
			   n->len = m->len;
			   /* doom support */
			   if (n->index != BAD_SYM && m->index != BAD_SYM)
			      Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		        }
#if 0
			n->len = max(n->len,m->len);
#endif
			Sym_TLS(n->index) = TRUE;
		    } 
#endif /* TSD */
		    if (m->index != BAD_SYM) { /* don't blow up on -1 */
			/* Don't remap this sym if it is a bad subsp,
			   because shlib_build_tables relies on this field
			   being BAD_SUBSP if the unsat came from a shlib. */
			if (Sym_Subsp(m->index) != BAD_SUBSP)
			  Remap_Sym_Records(m->index,n->index);
		    }
	        }  /* for m */
#else
		if ( n->type == ST_DATA ) {
		    struct symnode sav;

		    sav = *n;
		    for (m = n->same; m != NULL; m = m->same) {
		        if (m->type == ST_STORAGE) {  /* resolve to largest req
						       */
			    n->type = ST_STORAGE;  /* for import list, etc. */
			    if (m->len > n->len) {
			       n->len = m->len;
			       /* doom support */
			       if (n->index != BAD_SYM && m->index != BAD_SYM)
			          Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		            }
#if 0
			    n->len = max(n->len,m->len);
#endif
			    /*
			     * if the symbol is defined in a esom subspace,
			     * then don't do anything here with the symbol
			     * (we will let storage_create handle esom subspace
			     * symbols that are of type storage (common)).
			     */
			    if ( m->index != BAD_SYM && 
				is_esom_index(Sym_Subsp(m->index)) ) {
			        *n = sav;
			        break;
			    }
			}
			else if (m->type == ST_TSTORAGE) {
			    n->type = ST_TSTORAGE;
			    if (m->len > n->len) {
			       n->len = m->len;
			       /* doom support */
			       if (n->index != BAD_SYM && m->index != BAD_SYM)
			          Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		            }
#if 0
			    n->len = max(n->len,m->len);
#endif
			    Sym_TLS(n->index) = TRUE;
			} 
		        if (m->index != BAD_SYM) { /* don't blow up on -1 */
			    /* Don't remap this sym if it is a bad subsp,
			     * because shlib_build_tables relies on this field
			     * being BAD_SUBSP if the unsat came from a shlib.
			     */
			    if (Sym_Subsp(m->index) != BAD_SUBSP)
				Remap_Sym_Records(m->index,n->index);
			}
		    }
		}
		else {
		    for (m = n->same; m != NULL; m = m->same) {
		        if (m->type == ST_STORAGE) {  /* resolve to largest req
						       */
			    n->type = ST_STORAGE;  /* for import list, etc. */
			    if (m->len > n->len) {
			       n->len = m->len;
			       /* doom support */
			       if (n->index != BAD_SYM && m->index != BAD_SYM)
			          Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		            }
#if 0
			    n->len = max(n->len,m->len);
#endif
			}
			else if (m->type == ST_TSTORAGE) {
			    n->type = ST_TSTORAGE;
			    if (m->len > n->len) {
			       n->len = m->len;
			       /* doom support */
			       if (n->index != BAD_SYM && m->index != BAD_SYM)
			          Sym_Misc(n->index).objfile_index = Sym_Misc(m->index).objfile_index;
		            }
#if 0
			    n->len = max(n->len,m->len);
#endif
			    Sym_TLS(n->index) = TRUE;
			} 
		        if (m->index != BAD_SYM) { /* don't blow up on -1 */
			    /* Don't remap this sym if it is a bad subsp,
			     * because shlib_build_tables relies on this field
			     * being BAD_SUBSP if the unsat came from a shlib.
			     */
			    if (Sym_Subsp(m->index) != BAD_SUBSP)
			      Remap_Sym_Records(m->index,n->index);
			}
		    }  /* for m */
		}
#endif /* ESOM */

#ifdef TSD 
		if (n->type == ST_TSTORAGE || n->type == ST_STORAGE) {
#else
		if (n->type == ST_STORAGE) {
#endif /* TSD */
#ifdef TSD 
		    /* get pointer to the $TBSS$ subspace */
		    if (tsubsp == NULL) {
		        if (n->type == ST_TSTORAGE) {
			   if (tbss_subsp == BAD_SUBSP) {
			       external_error(CANT_FIND_TBSS, 0);
			   }
                           tsubsp = &Subsp_Dict(tbss_subsp);
			}
		    }
#endif /* TSD */
		    /* get pointer to $BSS$ subspace */
		    if (subsp == NULL) {
		        if (n->type == ST_STORAGE) {
		           if (bss_subsp == BAD_SUBSP)
			      external_error(CANT_FIND_BSS , 0);
			   subsp = &Subsp_Dict(bss_subsp);
			}
		    }
					  
  		    /* 
		    ** check whether storage unsat added by shlib_search()
                    ** is at the head of the chain. 
		    */ 
	            if (n->index == BAD_SYM) {
		        /* storage was library-created; go get the
			   data item that caused it */
			n->index = unsat_find(n->name, 
					      Sym_Qual_Name(n->index),
					      n->hashval, 
					      ST_DATA);
			if (n->index == BAD_SYM)
			    internal_error(BAD_LIB_STOR_LOOKP, 0);
  	            }  /* end if n->index == BAD_SYM */

			/* Want to export ST_STORAGE if it's
			** a shared global! */
		    if (building_incomp_exec &&
			(!search_alldefs) && (!has_shlib_refs(n)
                         && !Sym_SharedGlobal (n->index))) {
  			last = n;
                        n = n->next;
                        continue;
                    }
#ifdef TSD 
		    if (n->type == ST_STORAGE || n->type == ST_TSTORAGE) {
		       if (n->type == ST_TSTORAGE) {
		          /* Associate the symbol with the TBSS subspace */
		          tsym = & Sym_Dict(n->index);
		          tsym->symbol_info = tbss_subsp;
			  Sym_Type(n->index) = ST_TSTORAGE;
		          Sym_Subsp(n->index) = tbss_subsp;
			  tsym->is_common = TRUE;

		          /* 
			  ** Set offset to tbss_size (size of all TLS so far)
			  */
			  new_len_tbss = tbss_size;

		          if (n->len >= 2) {
		             if (n->len == 2)
                	        new_len_tbss = round(new_len_tbss, 2);
		   	     else if (n->len <= 4)
                	        new_len_tbss = round(new_len_tbss, 4);
			     else
                	        new_len_tbss = round(new_len_tbss, 8);
		          }
		          /* set TLS offset */
			  tsym->symbol_value = new_len_tbss;

			  /*
			  ** Since the assembler doesn't include commons in
                          ** the length of $TBSS$, we have to extend the
			  ** length of tbss_size here.  Yes this can waste
			  ** space in TLS (gaps between TLS common symbols)
			  ** but for now, I don't see any other way around
                          ** this problem.
			  */
			  tbss_size += (new_len_tbss - tbss_size) + n->len;
		       } else {
#else
	    if (n->type == ST_STORAGE) {
#endif /* TSD */	
		       /* Associate the symbol with the BSS subspace */
		       sym = & Sym_Dict(n->index);
		       sym->symbol_info = bss_subsp;
		       Sym_Subsp(n->index) = bss_subsp;

		       /* set offset to end of subspace and update
		       ** the subspace length */
		       new_len = subsp->subspace_length;
		       if (n->len >= 2) {
		          if (n->len == 2)
                	     new_len = round(new_len, 2);
			  else if (n->len <= 4)
                	     new_len = round(new_len, 4);
			  else
                	     new_len = round(new_len, 8);
		       }
		       sym->symbol_value = new_len + 
					Subspace_Virtual_Offset(bss_subsp);
		       subsp->subspace_length = new_len + n->len;
#ifdef TSD 
		       } /* else not tstorage */
#endif /* TSD */
		    } /* tsd: if type = stor or tstor, else if storage */

		    /* unlink from unsat hash table */
		    m = n->next;
		    if (n == unsat_hash_table[i])
			unsat_hash_table[i] = n->next;
		    else
			last->next = n->next;  /* leave "last" unchanged */

		    /* doom support */
		    lm_bss_symbol_add(n->index, n->len);

		    if (!on_shlib_export_list(n->name) || 
			 on_hide_list(n->name)) {
		        if (building_incomp_exec && has_shlib_refs(n)) {
 		            /* 
			    ** if a data symbol is copied from a shlib into
			    ** the a.out, it is still needed by the shlib and 
			    ** if it is not exported from the a.out, the a.out 
			    ** will use one copy and the shared lib will use 
			    ** another. This may be intended but a warning
			    ** is given. If the main program originally 
			    ** defined the symbol and the user has not exported
			    ** it, no warning is given. Reason: data copying
			    ** is a transparent (possibly unwelcome) act 
			    ** whereas a user definition is detectable and 
			    ** the user has made the choice not to export the 
			    ** symbol. 
			    */
                            warning(SHOULD_EXPORT_SYM, n->name, 0);
			}
			/*
			** remove from hide list since we are making it local 
			*/
			remove_from_hide_list(n->name);
			local_data_sym_count++;
			n->next = data_locals_list;
			data_locals_list = n;
		    } else {
		        /* add to storage requests list for processing later */
		        storage_reqs_found++;  
		        n->next = storage_reqs_list;
		        storage_reqs_list = n;
  		    }

                    /* resolve unsats for any qualified storage requests */
                    if (Sym_Qual_Name(n->index) != NULL) {
#ifdef TSD
		        unsat_resolve(n->name, 
				      FALSE, 
				      Sym_Qual_Name(n->index), 
				      n->hashval, 
				      n->index, 
				      ST_TSTORAGE, 
				      &(n->len));
#endif /* TSD */
                        unsat_resolve(n->name, 
				      FALSE, 
				      Sym_Qual_Name(n->index), 
				      n->hashval, 
				      n->index, 
				      ST_STORAGE, 
				      &(n->len));

                        n = unsat_hash_table[i];  /* restart hash chain search,
                                                     chain likely corrupted */
                        continue;
                    }

		    n = m;  /* advance to next sym on unsat hash string */
		    continue;

		} else { /* !ST_STORAGE but ST_DATA */
		    n->checked = TRUE;
		    data_unsats_left++;
	            last = n;
		    n = n->next;
		}
	    } else {  /* else !ST_DATA || !ST_STORAGE */

		n->checked = TRUE;

		/*
		** If we stumble across an unsatisfied symbol for a millicode
		** routine, flag it as an error.  Millicode should never be
		** unsatisified.  Imports records are not created for
		** a millicode call.  This error is fatal since we cant
		** build consistent shlib tables at this point anymore.
		*/
		if (n->index != BAD_SYM &&
		    Sym_Type(n->index) == ST_MILLICODE) {
		    if (!millicode_unsats)
		        warning (UNSATS, 0);	
		    warning_continue (UNSAT_MILLICODE, n->name, 0);
		    millicode_unsats++;
		}

		/* 
		** If this is not a user defined unsat and not and absolute 
		** unsat then count it.  Also, don't count optional call 
		** symbols! 
		*/
		if ((n->type != ST_NULL) && (n->type !=ST_ABSOLUTE) &&
		     !OPTIONAL_PROC(n->index))
		    code_unsats_left++;
	        last = n;
		n = n->next;
	    }
	}  /* for n */
    } /* for each bucket in the hash table */ 

    /*
    ** Exit the linker if any unsatisfied millicode symbols have been 
    ** found. 
    */
    if (millicode_unsats) {
	longjmp (drive, 1);
    }

    /* count all univ symbols to be exported for the export list */
    univ_code_sym_count = 0;
    univ_data_sym_count = 0;
    hidden_data_sym_count = 0;

    if (search_alldefs) {
        for (i = 0; i != UNIVHASHSIZE; i++) {
            for (n = univ_hash_table[i]; n != NULL; n = n->next) {
		sym_index = Sym_Remap(n->index);
	        switch (Sym_Type(sym_index)) {
	            case ST_DATA:
			if (Sym_ShlHideExp(sym_index)) 
			    hidden_data_sym_count++;
			else
		            univ_data_sym_count++;
		        break;
  		    case ST_PRI_PROG:
                    case ST_SEC_PROG:
                    case ST_ENTRY:
			if (!Sym_ShlHideExp(sym_index)) 
                            univ_code_sym_count++;
                        break;
		    default:
		        break;	/* never export Millicode syms (always local),
				       or CODE (not entry points for export) */
	            } /* end switch n->type, for loop down hash chain */
   		}
	    }

        for (i = 0; i != SECHASHSIZE; i++)  {
            for (n = sec_hash_table[i]; n != NULL; n = n->next) {
		sym_index = Sym_Remap(n->index);
	        switch (Sym_Type(sym_index)) {
	            case ST_DATA:
			if (Sym_ShlHideExp(sym_index)) 
			    hidden_data_sym_count++;
			else 
		            univ_data_sym_count++;
		        break;
  		    case ST_PRI_PROG:
                    case ST_SEC_PROG:
                    case ST_ENTRY:
			if (!Sym_ShlHideExp(sym_index)) 
                            univ_code_sym_count++;
                        break;
		    default:
		        break;	/* never export Millicode syms (always local),
				       or CODE (not entry points for export) */
	            } /* end switch n->type, for loop down hash chain */
	    	}
	    }
	}

    if (building_shlib && data_satisfied_unsats != NULL) {  
	/* for shlib, count also those syms imported by a dependent shlib */
        for (n = data_satisfied_unsats; n != NULL; n = n->next)
	    switch (Sym_Dict(Sym_Remap(n->index)).symbol_type) {
#ifdef TSD 
	        case ST_TSTORAGE:
#endif /* TSD */
	        case ST_DATA:
		case ST_STORAGE:
		    data_unsats_left++;
		    break;
		default:
		    break; 
	    } /* end switch n->type, for loop down linked list */
    }

    if (minimum_export_list != NULL) {  
	/* for a.out, only export those syms actually imported by a shlib */
        for (n = minimum_export_list; n != NULL; n = n->next)
	    switch (Sym_Dict(Sym_Remap(n->index)).symbol_type) {
	        case ST_DATA:
		    univ_data_sym_count++;
		    break;
  		case ST_PRI_PROG:
                case ST_SEC_PROG:
                case ST_ENTRY:
                    univ_code_sym_count++;
		    break;
		default:
		    break;    /* never export Millicode syms (always local),
				     or CODE (not entry points for export) */
	    } /* end switch n->type, for loop down linked list */
    }

    /* compute table sizes in items */
    DLT_entry_count = (building_shlib) ? 
		      (storage_reqs_found + 
		       data_unsats_left +
		       univ_data_sym_count +
		       hidden_data_sym_count +
		       local_data_sym_count) : 0;  
			/* usually, DLT only in shlib, may be in a.out if 
			   standalone PIC */

    /* explicitly add slot used for pointer to unwind table 
       in shared libraries to the DLT count. */
    DLT_entry_count += DLT_UNWIND_SLOT; 

    PLT_entry_count = code_unsats_left + 
		      code_matches_found;

    import_entry_count	= DLT_entry_count +
			  PLT_entry_count;

    export_entry_count	= storage_reqs_found +
			  univ_code_sym_count + 
			  univ_data_sym_count; 

    /* allocate export table */
    if (export_entry_count > 0) {
        assert (out_export_list == NULL);  /* first allocation */
	allocate_export_list(export_entry_count);
	if (building_shlib) {
            assert (out_export_ext != NULL);  /* first allocation just done */
	    memset((char *)out_export_ext, 
		   '\377',  
	           export_entry_count * sizeof(struct export_entry_ext)); 
	}
    }

    cur_export_node = out_export_list;
    cur_export_subsp = out_explist_subsp;

    /* set actual length of hash table to be used */
    out_hash_tbl_len = building_incomp_exec ? UNIVHASHSIZE :
					hash_tbl_size (export_entry_count);

#if 0 /*  */
    assert (out_hash_tbl_len > 0 && out_hash_tbl_len <= UNIVHASHSIZE);
#endif
    /* large shared library hash table */
    assert (out_hash_tbl_len > 0 && out_hash_tbl_len <= MAX_SHLIB_HASH_LEN);

    /* allocate import list */
    if (import_entry_count > 0) {
        out_import_list = (struct import_entry *)
	         emalloc(import_entry_count * sizeof(struct import_entry));
    }

    cur_import_node = out_import_list;

    /* allocate DLT */
    if (DLT_entry_count > 0) {
        int DLT_area_size = DLT_entry_count * sizeof(DLT_ENTRY);
        out_DLT_list = (DLT_ENTRY *)emalloc(DLT_area_size);
        cur_DLT_node = out_DLT_list;
    }
    if (building_shlib) {
	/* set up lt ptr and unwind slot */
	ltptr_DLT_entry_index = (DLT_entry_count-1) / 2;

	/* initalize import list entry corresponding to unwind entry 
	** lib_index 
	*/
        out_import_list[ltptr_DLT_entry_index].reserved2 = EMPTY;
        out_import_list[ltptr_DLT_entry_index].reserved1 = 0; 
	out_import_list[ltptr_DLT_entry_index].bypassable = 0;
#ifdef TSD 
	out_import_list[ltptr_DLT_entry_index].is_tp_relative = 0;
#endif /* TSD */      
        out_import_list[ltptr_DLT_entry_index].name = EMPTY;
        out_import_list[ltptr_DLT_entry_index].type = 0;

	if (DLT_entry_count - DLT_UNWIND_SLOT == 0) {  
	    /* if the only DLT entry we have is for the unwind ptr, we
	       need to increment our pointers since the following loop
	       over the DLT will not */
	    cur_DLT_node++;  
	    cur_Import_Indx++;
            cur_import_node++;
        }
    } /* allocate DLT */

    /* allocate PLT */
    allocate_PLT();
    cur_PLT_count=0;

    /* process all satisfied unsats into SHLIB_INFO tables */

    /* fill in DLT, import and export lists with data items */
    for (i = DOING_SATS, j = 0; i <= DOING_EXEC_EXPS;) {  
    	/* loop over all lists of DLT entries */
	switch (i) {
	    case DOING_SATS:
            	n = data_satisfied_unsats;
		break;
	    case DOING_STOR_REQS:
            	n = storage_reqs_list;
		break;
	    case DOING_SECS:	/* search the secondary def hash table */
		if (!search_alldefs || j == SECHASHSIZE) {
		    i++;
		    j=0; /* reinit for DOING_UNIVS below */
		    continue;
		} else {
		    n = sec_hash_table[j++];
		    break;
     	        }
	    case DOING_UNIVS:	/* search the universal hash table */
		if (!search_alldefs || j == UNIVHASHSIZE) {
		    i++;
		    j=0; /* reinit for DOING_UNSATS below */
		    continue;
		} else {
		    n = univ_hash_table[j++];
		    break;
     	        }
	    case DOING_LOCALS:
        	n = data_locals_list;
		break;
	    case DOING_UNSATS:
		if (j == UNSATHASHSIZE) {
		    i++;
		    continue;  /* outer loop finished */
		} else {
		    n = unsat_hash_table[j++];
		    break;
		}
	    case DOING_EXEC_EXPS:
		if (search_alldefs) {
		    assert (minimum_export_list == NULL);
		    i++;
		    continue;
		} else {
        	    n = minimum_export_list;
		    break;
		}
	    }

            for (; n != NULL; n = n->next) { /* traverse curr data item list */

		if ((i == DOING_UNIVS     || 
		     i == DOING_SECS      || 
		     i == DOING_EXEC_EXPS || 
		     i == DOING_UNSATS) && 

		    (n->index == BAD_SYM  || 
		      Sym_Type(Sym_Remap(n->index)) != ST_DATA))
		    /* this loop for data syms only */
		    continue;

		shlib_sym = BAD_SYM;

                if (building_shlib) { /* data import tables only in shlibs */
		    /* skip unwind ptr slot */
	            if (cur_Import_Indx == ltptr_DLT_entry_index) { 
			assert(cur_DLT_node <= 
			       (out_DLT_list+DLT_entry_count-DLT_UNWIND_SLOT));
	            	cur_DLT_node++;  
			    /* leave alone, already set with unwind offset */
		        cur_Import_Indx++;
		    	assert( cur_import_node <=
			       (out_import_list + import_entry_count) );
            	        cur_import_node++;
	            }

                    /* add to import list, string table */
                    if ((inter_binding && (Sym_Scope(Sym_Remap(n->index)) != SS_UNSAT)) ||
                        i==DOING_LOCALS || Sym_ShlHideExp(n->index)) {
                        cur_import_node->name = EMPTY;
                    	cur_import_node->type = 0;
		    } else {
                    	cur_import_node->type = n->type;
               	        /* needed by "sec_shl_str_add" */
			assert(DOING_UNIVS < DOING_SECS);
               	        shlib_sym = (i==DOING_SECS) ? sec_shl_str_add(n->name, 
								      n->type)
						   : shlib_string_add(n->name);
                        cur_import_node->name = shlib_sym;
 		    }
		    cur_import_node->reserved1 = 0; /* init for future */
#ifdef TSD 
		    /*
		    ** set bit for non true TSD imports (i.e. Unsat with
		    ** a corresponding export).
		    ** Now set the bit if TLS symbol, not just
                    ** for non TRUE imports.  For Data Unsats, we won't know
		    ** if it's TLS until we do apply_fixups() so we'll have
		    ** to revisit the import list in relocate_DLT().
		    */
		    cur_import_node->is_tp_relative = FALSE;
		    if (Sym_TLS(n->index)) {
		       cur_import_node->is_tp_relative = TRUE;
		    }
#endif /* TSD */
		    cur_import_node->bypassable = 0;
                    cur_import_node->reserved2 = EMPTY; /* lib_index */

		    assert ( cur_import_node <=
			     (out_import_list + import_entry_count) );
                    cur_import_node++;  

	            /* add to DLT */
		    assert(cur_DLT_node <= 
			(out_DLT_list+DLT_entry_count-DLT_UNWIND_SLOT));
                    /* will be reset in output.c */
#ifdef TSD 
		    /* 
		    **  For true TSD unsats, put -1 in
		    ** DLT slot.  Stick symbol dictionary index of TSD
		    ** in slot otherwise.  relocate_DLT() will put the
		    ** TSD offset of the symbol in the DLT.
		    */
	            if (Sym_TLS(n->index)) {
		        if (i == DOING_UNSATS) {
			    *cur_DLT_node++ = BAD_SYM;
			} else {
			    *cur_DLT_node++ = n->index;
			}
		   } else
#endif /* TSD */		    
	            *cur_DLT_node++ = n->index;  

	            Sym_ShlImp_Indx(n->index) = cur_Import_Indx++;  
						 /* record index for fixups */
		    for (m = n->same; m != NULL; m = m->same)
			/*copy import indx into all equiv syms for other refs*/
		 	if (m->index != BAD_SYM) 			  
		            Sym_ShlImp_Indx(m->index) =
			       Sym_ShlImp_Indx(n->index);

	        } /* data import tables only in shlibs */

                if (Sym_ShlHideExp(n->index))
		    continue; 

		/* Build export table entry if needed */
		switch(i) {
	       	    case DOING_SATS:
   			 /* Export for data unsat satisfied by shlib will be
                            built by the universal symbol added to the a.out
                            by copy_export_sym_data() */
                         break;
	       	    case DOING_UNIVS:
	       	    case DOING_SECS:
	       	    case DOING_EXEC_EXPS:
                    case DOING_STOR_REQS :  
		        /* add all universals and stor reqs to export list */
		    	cur_export_node->info.size = 0;  /* zero entire word */
                	if (i != DOING_STOR_REQS) {
			    if (!building_incomp_exec) {
		    	    	cur_export_node->EXPORT_VERSION = 
			        Subsp_Misc(Sym_Subsp(n->index)).shlib_version;
			    }
			    cur_export_node->EXPORT_ARG_RELOC =
                                                        DEFAULT_ARG_RELOC;
			} else
		    	    cur_export_node->info.size = n->len; /* BSS size */
                        cur_export_node->type = n->type;
			*cur_export_subsp = Sym_Subsp(n->index);
			cur_export_node->reserved1 = 0; /*init for future use*/
	        	if (shlib_sym == BAD_SYM) 
                            shlib_sym = shlib_string_add(n->name);
                        cur_export_node->name = shlib_sym;
#ifdef TSD 
			/*
			**  Put the TSD offset in
			** export_entry->value.  However, we also need to
			** keep around the symbol dictionary index.  We'll do
			** so in info.size since this field isn't used for
			** TSD.  We'll need the symbol dictionary index in
			** compute_export_sizes().
			*/
			cur_export_node->is_tp_relative = FALSE;
			if (Sym_TLS(n->index)) {
	                   cur_export_node->value = Sym_Value(n->index);
			   cur_export_node->info.size = n->index;
			   cur_export_node->is_tp_relative = TRUE;
			} else
#endif /* TSD */
                        cur_export_node->value = n->index;  

			    /* save for "relocate_shlib_info" */
	    	        hashkey = hash_string(n->name) % out_hash_tbl_len;
            	        cur_export_node->next = out_hash_tbl[hashkey];
            	        out_hash_tbl[hashkey] = next_export_list_indx;
			assert ( next_export_list_indx < export_entry_count );
	    	        next_export_list_indx++;
			assert ( cur_export_node < 
			 	(out_export_list + export_entry_count) );
                        cur_export_node++;
			cur_export_subsp++;
		        break;
		    default:
		        break;
			/* Do Nothing */
		    }
                } /* for this DLT list */

	    if ((i != DOING_UNIVS) && (i != DOING_UNSATS) && 
                (i != DOING_SECS))
		i++;  /* Hash table traversals run their own loop */

    } /* for each DLT list */

    assert ((export_entry_count - univ_code_sym_count) == 
  		next_export_list_indx);

    /* process code symbol lists into import list and PLT */
    for (i=DOING_SATS, j=0; i <= DOING_EXEC_EXPS; ) {  
	/* loop over lists of PLT entries */
	switch (i) {
	    case DOING_SATS:
    	        n = code_satisfied_unsats;
	        break;
	    case DOING_SECS:	/* search the secondary def hash table */
		if (!search_alldefs || j == SECHASHSIZE) {
		    i++;
		    j=0; /* reinit for DOING_UNIVS below */
		    continue;
	        } else {
		    n = sec_hash_table[j++];
		    break;
   	        }
	    case DOING_UNIVS: /* search the universal hash table */
		if (!search_alldefs || j == UNIVHASHSIZE) {
		    i++; 
		    j=0; /* reinit for DOING_UNSATS below */
		    continue;
		} else {
		    n = univ_hash_table[j++];
		    break;
 	        }
	    case DOING_UNSATS:
		if (j == UNSATHASHSIZE) {
		    i++;
		    continue;  /* outer loop finished */
		} else {
		    n = unsat_hash_table[j++];
		    break;
 	        }
	    case DOING_EXEC_EXPS:
		if (search_alldefs) {
		    assert (minimum_export_list == NULL);
		    i++;
		    continue;
		} else {
        	    n = minimum_export_list;
		    break;
		}
	    default:
	        i++;
    	        continue;  /* not applicable to code */
	}

   	for (; n != NULL; n = n->next) {
            /* add to import list, string table, PLT */

	    if (n->type == ST_NULL)  /* user defined unsat */
		continue;

	    type = Sym_Type(Sym_Remap(n->index));

	    assert( Sym_Dict(n->index).symbol_type == 
		    Sym_Type(Sym_Remap(n->index)) );

	    /* skip if not an external entry symbol */
  	    if (( i != DOING_SATS )  &&
                 ((type != ST_ENTRY &&
                    type != ST_CODE &&
                    type != ST_PRI_PROG &&
                    type != ST_SEC_PROG) ||
                   (type == ST_CODE && i != DOING_UNSATS)))
                        /* ST_CODE syms not callable like ST_ENTRY */
		continue;	 /* this loop for external entry syms only */

	    shlib_sym = BAD_SYM;

	    /* Build export list entry, export stubs */
	    if ((i == DOING_EXEC_EXPS)||(i == DOING_UNIVS)||(i == DOING_SECS)){
		/* add all entry-type universals not on the hide list
		   to the export list */

		if (!Sym_ShlHideExp(n->index)) {

                    cur_export_node->type = n->type;
		    cur_export_node->info.size = 0;  /* zero entire word */
#ifdef TSD 
		    cur_export_node->is_tp_relative = 0;
#endif /* TSD */
		    if (!building_incomp_exec) {
		    	cur_export_node->EXPORT_VERSION = 
			    Subsp_Misc(Sym_Subsp(n->index)).shlib_version;
		    }
		    cur_export_node->EXPORT_ARG_RELOC = DEFAULT_ARG_RELOC;
               	    shlib_sym = (i==DOING_SECS) ? sec_shl_str_add(n->name, 
								  n->type)
						: shlib_string_add(n->name);
                    cur_export_node->name = shlib_sym;
                    cur_export_node->value = n->index;  /* addr */
                    *cur_export_subsp = Sym_Subsp(n->index); 
		    cur_export_node->reserved1 = 0; /*init for future use*/
	    	    hashkey = hash_string(n->name) % out_hash_tbl_len;
            	    cur_export_node->next = out_hash_tbl[hashkey];
            	    out_hash_tbl[hashkey] = next_export_list_indx;
		    assert ( next_export_list_indx < export_entry_count );
	    	    next_export_list_indx++;
		    assert ( cur_export_node < 
			     (out_export_list + export_entry_count) );
                    cur_export_node++;
		    cur_export_subsp++;

		    /* add to export stub list */
		    if (type == ST_ENTRY || 
		        type == ST_PRI_PROG ||
		        type == ST_SEC_PROG) {
                       sym = & Sym_Dict(n->index);
		       /**************************************************/
		       /* --------------------------                     */
                       /* if both has_long_return and no parms reloc     */
		       /* then no need to build export stub.             */
		       /* A parameter relocation stub may be added later */
		       /* unless has_long_return and no_relocation are   */
		       /* both set, if not set, we must create an export */
		       /* stub.                                          */
		       /**************************************************/

    /* 
     * 
     * Made a slight change to the way symbols with the no relocation
     * and long return bits set are handled. We now allocate a dummy
     * export stub (really just a new symbol that points back to the
     * original code) and treat it just like normal.
     */

                       if(sym->has_long_return && sym->no_relocation) {
                            if (verbose & V_STUBS)
                             fprintf(stderr,
                                "Export stub not built for %s\n", sym->name);
			    
			    add_null_export_stub(n->index);
		       }
		       else{
                            if (verbose & V_STUBS)
		    	        printf("HP-UX Shlib Export stub to %s\n", 
				   n->name);
		            add_export_stub(n->index);
		       }
		    }
		 }
	    }

 	    if (building_shlib)
               /* need Sym_Back_Ptr() to be set in "unwind_and_recover_fixups"-
		   also set by "*_add" routines, this is extra insurance */
                Sym_Back_Ptr(n->index) = n;

 	    /* 
	    ** build import list and PLT entry. if (building_shlib)
            ** the import and PLT list will be filled in during
            ** the first pass over the fixups. This will reduce the
            ** number of PLT and import entries needed in a shared library. 
	    */

            if (((i != DOING_EXEC_EXPS) && 
		 (i != DOING_UNIVS) && 
		 (i != DOING_SECS))) {
	    	/* no code univ in exec import/PLT tables - 
		   shlib's are built on demand in fixups.c */

    		cur_import_node->reserved1 = 0;  /* init for future */
		cur_import_node->bypassable = 0;
#ifdef TSD 
		cur_import_node->is_tp_relative = 0;
#endif /* TSD */

                cur_import_node->reserved2 =  EMPTY; /* lib_index */
	       	if (shlib_sym == BAD_SYM) 
                    shlib_sym = shlib_string_add(n->name);
                cur_import_node->name = shlib_sym;
                cur_import_node->type = n->type;

		/* build import stubs - Note : overwrites _sym_dict entry */

		if (extern_plabels || 
		    ((i == DOING_SATS) || (i == DOING_UNSATS)))
			/* if -Hp on, then do not do imports for exports */
		if ((type == ST_ENTRY) ||
		    (type == ST_PRI_PROG) ||
		    (type == ST_SEC_PROG) ||
		    (i == DOING_SATS) ||
		    (i == DOING_UNSATS)) { /*import stubs for all code unsat */
		  
		    /* add import stubs */

		    /* 
		    ** need to save the original symbol for building the 
		    ** export stub. Need to do this even if original 
		    ** symbol is an unsat since we may need to add a plabel
		    ** export. 
		    */
		    save_orig_sym_for_exp_stub(n->index);

		    add_import_stub(n->index);
		    Sym_Subsp(n->index) = BAD_SUBSP;
		    Sym_Back_Ptr(n->index) = n;
		    last_stub = n->index;
		    for (m = n->same; m != NULL; m = m->same) {
		        /* share import stubs in each subspace */
			assert(m->index != BAD_SYM);

			/* MAYBE THIS IS SHOULD BE FIXED IN 
			   SAVE_ORIG_SYM_FOR_EXP_STUB()?! */
			/* If these are already mapped to each other, they
			   are already sharing imports! */
			if (&Sym_Dict(m->index) != &Sym_Dict(last_stub)) {
		            add_import_stub(m->index);
		            Sym_Subsp(m->index) = BAD_SUBSP;
		            Sym_Back_Ptr(m->index) = n;
			    Sym_Related_Stub(m->index)=
						  Sym_Related_Stub(last_stub);
			    Sym_Related_Stub(last_stub) = m->index;
			    last_stub = m->index;
		        }
		    } /* END for */
		}  /* end of adding export stubs */

		assert ( cur_import_node <=
			 (out_import_list + import_entry_count) );
                cur_import_node++;

	        /* set PLT symbol index so output can fill in final address 
	           from symbol_value field */
	        out_PLT_list[cur_PLT_count].proc_addr = n->index;
	        out_PLT_list[cur_PLT_count].ltptr_value = 0;  
					/* keep garbage out of file */
		assert ( cur_PLT_count < PLT_entry_count );
		cur_PLT_count++; /* advance to next PLT entry */
		cur_Import_Indx++; /* advance to next Import entry */
	    }

    	}  /* for n : add to import list, string table, PLT */

	if ( (i != DOING_SECS) && (i != DOING_UNIVS) && (i != DOING_UNSATS))
	    i++;  /* Hash table traversals run their own */

    }  /* for n : for each PLT list */

    assert ( next_export_list_indx == export_entry_count );
    assert ( (cur_import_node - out_import_list) == import_entry_count );

} /* END shlib_build_tables */

assign_PLT_indices()
{
    /* assigns the import index fields for symbols referenced in the PLT. */ 

    register int count;
    register int sym_index;
    int Import_Indx; 
    struct symnode *n;

    Import_Indx = DLT_entry_count; 

    for (count=0; count<PLT_entry_count; count++) {
        sym_index = out_PLT_list[count].proc_addr;

	Sym_ShlImp_Indx(sym_index) = Import_Indx;
	for (n = Sym_Back_Ptr(sym_index); n != NULL; n = n->same) {
	    assert(n->index != BAD_SYM);
	    Sym_ShlImp_Indx(n->index) = Import_Indx;
	}
        
 	while ( (sym_index = Sym_Related_Stub(sym_index)) != BAD_SYM) {
            Sym_ShlImp_Indx(sym_index) = Import_Indx; 
        }

	Import_Indx++;
    }

} /* end assign_PLT_indices() */

assign_PLT_offsets()
{
    /* assigns the symbol_info fields for symbols referenced in the PLT. 
       This can only be done after virtual addresses have been assigned */ 

    register int count;
    register int sym_index;
    int ltptr_byte_adjustment;
    int new_symbol_info; 
    struct symnode *n;

    ltptr_byte_adjustment = Subspace_Virtual_Offset(PLT_subsp_index) -
                            Subspace_Virtual_Offset(DLT_subsp_index) -
                            (ltptr_DLT_entry_index * sizeof(DLT_ENTRY));

    for (count=0; count<PLT_entry_count; count++) {
        sym_index = out_PLT_list[count].proc_addr;

	new_symbol_info = count * sizeof(struct PLT_entry);

	/* offsets are ltptr relative in a shared library */
	if (building_shlib) 
	    new_symbol_info += ltptr_byte_adjustment;

	for (n = Sym_Back_Ptr(sym_index); n != NULL; n = n->same) {
            assert(n->index != BAD_SYM);
	    if (Sym_Type(n->index) == ST_STUB_IMPORT)
                Sym_Dict(n->index).symbol_info = new_symbol_info;
	}
        
 	while ( (sym_index = Sym_Related_Stub(sym_index)) != BAD_SYM) {
            if (Sym_Type(sym_index) == ST_STUB_IMPORT)
            	Sym_Dict(sym_index).symbol_info = new_symbol_info;
        }
    }
} /* end assign_PLT_offsets() */

struct module_import_buffer {
    int *buffer;
    int length;
    int cur_offset;
};

imported_by_module(imports, import_index) 
struct module_import_buffer imports;
int import_index;
{
    /* returns true if the import list for the module stored in "buffer" 
       contains the import index */
    int j;

    for (j=0; j<imports.cur_offset; j++) {
        if (imports.buffer[j] == import_index)
	   return(TRUE);
    }
    return(FALSE);
}

#define IMPORT_LIST_INC 500

static void alloc_import(import_buffer, request)
struct module_import_buffer *import_buffer;
int request;
{
    if (import_buffer->cur_offset + request < import_buffer->length)
	return;

    if (import_buffer->length) {
        import_buffer->length += (request + IMPORT_LIST_INC);
        import_buffer->buffer = 
	    (int *) erealloc ((char *) import_buffer->buffer, 
			      import_buffer->length * sizeof(int));
    } else {	
        import_buffer->length += (request + IMPORT_LIST_INC);
        import_buffer->buffer =
		       (int *) emalloc (import_buffer->length * sizeof(int));
    }
}

copy_imports(dest, src)
struct module_import_buffer *dest;
struct module_import_buffer src;
{
    memcpy(&(dest->buffer[dest->cur_offset]), src.buffer, 
	   src.cur_offset * sizeof(int));
    dest->cur_offset += src.cur_offset;
} 

struct module_import_buffer module_imports;

build_module_imports()
{
    int next_dreloc; 
    int module_symbols, sym_index, sym_end;
    int i, j, tbl_index, subsp;
    int drelocs_for_module;
    int subsp_start, subsp_end;
    int remap_sym;
    int imports_for_module;
    int module_index;
    struct module_import_buffer module, dlt, plt;

    next_dreloc = 0;

    module_imports.length = 0;
    module.length = 0;
    dlt.length = 0;
    plt.length = 0;

    for (i=0; i<shlib_module_count; i++) {
	drelocs_for_module = 0;
	module.cur_offset = 0;
        dlt.cur_offset = 0;
        plt.cur_offset = 0;

	subsp_start = shlib_module_misc[i].start_subsp_indx;
	subsp_end   = shlib_module_misc[i].end_subsp_indx;

	for (subsp = subsp_start; subsp <= subsp_end; subsp++) {
	    if (Subsp_Misc(subsp).subsp_has_dreloc) 
		drelocs_for_module++;
	}

	module_symbols = shlib_module_misc[i].symbols;
	sym_index = Subsp_Misc(subsp_start).symbol_index_bias;
	sym_end   = sym_index + module_symbols;

	for ( ; sym_index < sym_end; sym_index++) {
	    remap_sym = Sym_Remap(sym_index);
	    if (Sym_Misc(remap_sym).code_plabel) {
		for(j=0; j<code_plab_DLT_entry_count; j++) 
		    if (remap_sym == code_plab_DLT_entry_list[j].sym_index)
			break;
		if (j == code_plab_DLT_entry_count) {
		    for(j=0; j<code_plab_DLT_entry_count; j++) 
		        if (strcmp(Sym_Dict(remap_sym).NAME_PT, 
			           Sym_Dict(code_plab_DLT_entry_list[j].
			                    sym_index).NAME_PT) == 0)
			    break;
		} 

		assert(j<code_plab_DLT_entry_count);

		tbl_index = code_plab_DLT_entry_list[j].dlt_index;
		if ( !imported_by_module(dlt, tbl_index) ) {
		    alloc_import(&dlt, 1);
		    dlt.buffer[dlt.cur_offset++] = tbl_index;
		}

		tbl_index = PLT_index_of_sym(remap_sym) + DLT_entry_count;
		if ( !imported_by_module(plt, tbl_index) ) {
		    alloc_import(&plt, 1);
		    plt.buffer[plt.cur_offset++] = tbl_index;
		}

		continue;
		}

	    /* if referenced through data plabel, will have export stub 
	       that is being used for PLT entry */
            if (Sym_Scope(remap_sym) == SS_LOCAL &&
		Sym_Type(remap_sym) == ST_ENTRY && 
		(j = find_export_stub_sym(remap_sym)) != BAD_SYM) 
		remap_sym = j;

	    /* check for hidden module dependencies. */
	    if ( (tbl_index = Sym_ShlImp_Indx(remap_sym)) == -1 ||
		out_import_list[tbl_index].type == ST_NULL) {
	        module_index=find_module_by_subspace(Sym_Subsp(remap_sym));
	        if (module_index != BAD_SYM && module_index != i && 
		    !imported_by_module(module, module_index)) {
		    alloc_import(&module, 1);
		    module.buffer[module.cur_offset++] = module_index;
		}
	     }

	    /* Possible optimization here. Currently we place all Null
	       imports on module import lists. The intent is to allow 
	       dld to avoid relocating all Null imports and only relocate
	       those that are imported by a module. Currently, dld just
	       relocates all Null entries and ignores Null imports on 
	       module import lists. If dld plans to continue to ignore
	       these imports they can be removed. 
	    */

	    if (tbl_index != -1) {
	        if (tbl_index < DLT_entry_count) {
		    /* check for multiple imports, possible with multiple 
		       unsats in pascal with diff ext records. */ 
		    if (imported_by_module(dlt, tbl_index)) {
			continue;
		    }
		    alloc_import(&dlt, 1);
		    dlt.buffer[dlt.cur_offset++] = tbl_index; 
		} else {
		    /* check for multiple imports, possible with multiple 
		       unsats in pascal with diff ext records. */ 
		    if (imported_by_module(plt, tbl_index)) {
			continue;
		    }
		    alloc_import(&plt, 1);
		    plt.buffer[plt.cur_offset++] = tbl_index;
		}
	    } 

	} /* for each symbol in the module */

	/* 
	** now copy the individual module, dlt and plt import buffers to the
	** one module import buffer 
	*/

	imports_for_module = module.cur_offset +dlt.cur_offset +plt.cur_offset;
	if (imports_for_module) {
	    shlib_module[i].imports = module_imports.cur_offset * sizeof(int);

	    alloc_import(&module_imports, imports_for_module);

	    if (module.cur_offset > 0) 
	        copy_imports(&module_imports, module);

	    if (dlt.cur_offset > 0)
	        copy_imports(&module_imports, dlt);

	    if (plt.cur_offset > 0)
	        copy_imports(&module_imports, plt);
	}

	shlib_module[i].import_count = dlt.cur_offset + plt.cur_offset; 
	shlib_module[i].module_dependencies = module.cur_offset;
	     
	if (drelocs_for_module > 0) {
	    shlib_module[i].drelocs = next_dreloc * sizeof(int);
	    shlib_module_misc[i].dreloc_list_index = next_dreloc; 
	    next_dreloc += (drelocs_for_module +1);
	    module_dreloc_count += (drelocs_for_module +1);
	}
    } /* for each module */

    if (module.length) {
        efree(module.buffer);
    }
    if (dlt.length) {
	efree(dlt.buffer);
    }
    if (plt.length) {
	efree(plt.buffer);
    }

} /* end build_module_imports() */		

#ifndef NO_MULTIPLE_INITIALIZERS
int build_initializer_list(void)
{
    char *initializer_name;
    int  symbol_index;
    int  index = 0;
    int  initializer_count = 0;
    char **list = initializer_list;

    /*
    ** check to see if any initializers have been specified.
    */
    if (!list) {
	return 0;
    } else {
	/*
	** count the initializers and allocate the storage to contain
	** the output table.
	*/
	while (*list++ != NULL) 
	    initializer_count++;

	/*
	** allocate memory for the initializer import index table.
	*/
	out_initializer_list = 
	    (int *) emalloc(initializer_count * sizeof(int));

	/*
	** go through the initializer list and build the initializer import
	** index table.  If a bad symbol is encountered or a symbol cannot
	** be found then insert a -1 into the initializer import index table.
	*/
	for (list = initializer_list; initializer_name = *list++; index++) {
	    symbol_index = BAD_SYM;
	    if(initializer_name != NULL) {
	        symbol_index = unsat_find(initializer_name, 
				          NULL,
				          hash_string(initializer_name),
			                  ST_CODE);
	    } 
	    out_initializer_list[index] = (symbol_index != BAD_SYM) ? 
	        Sym_Misc(symbol_index).shlib_import_indx : BAD_SYM;
	}
	return initializer_count;
    }
}
#endif /* !NO_MULTIPLE_INITIALIZERS */

void build_shlib_subspace(index)
/* initialize subspace record for $SHLIB_INFO$ subspace in text space */
int index;
{
    struct dl_header_ext out_dl_hdr_ext;
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record *misc;
    int len;
    char *subspace_data;  /* working pointer to copy $SHLIB_INFO$ tables to
			     subspace data area */

    int shlib_area_size;        /* length of shlib list in bytes  */
    int	import_area_size;       /* length of import list in bytes */
    int	export_area_size;       /* length of export list in bytes */
    int	export_ext_area_size;   /* length of export ext list in bytes */
    int curr_dreloc_area_size;  /* length of current dreloc records */
    int added_dreloc_area_size; /* length of dreloc records to be added */
    int module_table_size;	/* length of module table in bytes */
    int module_import_size;	/* length of module import table in bytes */
    int module_dreloc_size;	/* length of module dreloc table in bytes */
#ifndef NO_MULTIPLE_INITIALIZERS
    int initializer_area_size;
    int initializer_count;
#endif /* !NO_MULTIPLE_INITIALIZERS */

    assign_PLT_indices();
    build_module_imports(); 

    /* save time in calculating values if they are not going to be put out */
    if (!no_dlheader_ext) {
       calculate_hash_values();
    } 

#ifndef NO_MULTIPLE_INITIALIZERS
    initializer_count = (initializer_list) ? build_initializer_list() : 0;
#endif /* !NO_MULTIPLE_INITIALIZERS */


    subsp = & Subsp_Dict(index);
    misc = & Subsp_Misc(index);

    shlib_area_size = next_shlib_list_indx * sizeof(struct shlib_list_entry);
    import_area_size = import_entry_count * sizeof(struct import_entry);
    export_area_size = export_entry_count * sizeof(struct export_entry);
    export_ext_area_size = export_entry_count * 
      sizeof(struct export_entry_ext);
    curr_dreloc_area_size = DR_PROPAGATE_count * sizeof(struct dreloc_record);
    added_dreloc_area_size = loader_fixup_size * sizeof(struct dreloc_record);
    module_table_size = shlib_module_count * sizeof(struct module_entry);
    module_import_size = module_imports.cur_offset * sizeof(int);
    module_dreloc_size = module_dreloc_count * sizeof(int);
#ifndef NO_MULTIPLE_INITIALIZERS
    initializer_area_size = initializer_count * sizeof(int); 
#endif /* !NO_MULTIPLE_INITIALIZERS */

    subsp->is_first = TRUE;  /* must be first subspace */

        subsp->initialization_length =    /* length of all tables          */
        subsp->subspace_length =          /* length of all tables - same   */
	sizeof(struct dl_header) +        /* length of DL header record    */
	shlib_area_size + 	          /* length of shlib list array    */
	out_hash_tbl_len * sizeof(int) +  /* length of export hash table   */
	export_area_size +  		  /* length of export list         */
	(building_shlib ? export_ext_area_size : 0) + 
	import_area_size + 		  /* length of import list         */
        curr_dreloc_area_size + 	  /* drelocs already generated     */
	added_dreloc_area_size +	  /* drelocs to be added           */
	module_table_size +		  /* module table size             */
	module_import_size +	          /* module import table	   */
	module_dreloc_size +		  /* module dreloc table           */
#ifndef NO_MULTIPLE_INITIALIZERS
	initializer_area_size +
#endif /* !NO_MULTIPLE_INITIALIZERS */
	next_shlstr_table_indx;           /* length of string table        */

        /* add the length of hash tables if we are outputting them to file */
        if (!no_dlheader_ext) {
           subsp->initialization_length +=   /* length of all tables          */
           sizeof(struct dl_header_ext) +    /* length of DL header extension */
           import_entry_count*sizeof(int) +  /* length of hashed import vals  */
           export_entry_count*sizeof(int) +  /* length of hashed export vals  */
           import_entry_count*sizeof(int);   /* length of hashed plabel vals  */ 
           subsp->subspace_length = subsp->initialization_length;
        }

#ifdef DEBUG
    if (verbose & V_ALLDEBUG) {
	printf("build_shlib_subspace: $SHLIB_INFO$ Subspace Header :\n");
	printf(" %-20s %02x %c%c%c %08x %08x:  ",
		subsp->NAME_PT,
		subsp->access_control_bits,
		subsp->initialization_length? 'H':'.',
		subsp->memory_resident? 'R':'.',
		subsp->initially_frozen? 'F':'.',
		subsp->subspace_start,
		subsp->subspace_length);
    }
#endif /* DEBUG */

    /* fill in dl_header record */
    out_dl_hdr.hdr_version = DL_HDR_VERSION_ID2;
    out_dl_hdr.ltptr_value = 0;	
	/* set after allocation to dp-rel offset of $DLT$ 
	   subspace + (ltptr_DLT_entry_index * sizeof(DLT_ENTRY)) */

    len = sizeof(struct dl_header);

    /* 
    ** elaborator field of the dl_header structure is now
    ** overloaded to point to the dl_header_ext structure
    */
    if (!no_dlheader_ext) {
#ifdef DEBUG
	if (verbose & V_ALLDEBUG) {
	    printf("Dumping dl_header_ext structure at %d\n", len);
	}
#endif
	dl_header_ext_offset = len;
	/* this field gets clabbored (sp?) afterwards, but just in case */
	out_dl_hdr.elaborator = len;
	len += sizeof(struct dl_header_ext);
	
	/* 
	** now we build our dl_header_ext structure and fill in the entries
	*/
	out_dl_hdr_ext.size = sizeof(struct dl_header_ext);
	out_dl_hdr_ext.hash_array_size = gh_hash_table_size;
	out_dl_hdr_ext.hash_buckets_per_entry = gh_hash_buckets_per_entry;
	out_dl_hdr_ext.hash_function_ver = HASH_FUNCTION_VERSION;
	out_dl_hdr_ext.import_hashvals = len;
	len += import_entry_count*sizeof(int);
	out_dl_hdr_ext.export_hashvals = len;
	len += export_entry_count*sizeof(int);
	out_dl_hdr_ext.plabel_hashvals = len;
	len += import_entry_count*sizeof(int);

#ifdef DEBUG
	if (verbose & V_ALLDEBUG) {
	    printf("dl_header_ext.size                %d\n", out_dl_hdr_ext.size);
	    printf("dl_header_ext.hash_array_size     %d\n", out_dl_hdr_ext.hash_array_size);
	    printf("dl_header_ext.hash_buckets/entry  %d\n", out_dl_hdr_ext.hash_buckets_per_entry);
	    printf("dl_header_ext.hash_function_ver   %d\n", out_dl_hdr_ext.hash_function_ver);
	    printf("dl_header_ext.import_hashvals     %d\n", out_dl_hdr_ext.import_hashvals);
	    printf("dl_header_ext.export_hashvals     %d\n", out_dl_hdr_ext.export_hashvals);
	    printf("dl_header_ext.plabel_hashvals     %d\n", out_dl_hdr_ext.plabel_hashvals);
	}
#endif

    } /* if !no_dlheader_ext */

    out_dl_hdr.shlib_list_count = next_shlib_list_indx;	
    out_dl_hdr.shlib_list_loc = (shlib_area_size != 0) ? len:EMPTY;
    len += shlib_area_size; 

    out_dl_hdr.hash_table_loc = len;
    out_dl_hdr.hash_table_size = out_hash_tbl_len;  /* count in slots */
    len += out_hash_tbl_len * sizeof(int);

    out_dl_hdr.export_list_count = export_entry_count;
    out_dl_hdr.export_list_loc = (export_area_size != 0) ? len:EMPTY;
    len += export_area_size;

    if (building_shlib) {
        out_dl_hdr.export_ext_loc = (export_ext_area_size != 0) ? len:EMPTY;
        len += export_ext_area_size;
    }

    out_dl_hdr.import_list_count = import_entry_count;
    out_dl_hdr.import_list_loc = (import_area_size != 0) ? len:EMPTY;
    len += import_area_size;

    out_dl_hdr.dreloc_count = DR_PROPAGATE_count + loader_fixup_size;
    out_dl_hdr.dreloc_loc = (out_dl_hdr.dreloc_count != 0) ? len:EMPTY;
    len += (curr_dreloc_area_size + added_dreloc_area_size);

    out_dl_hdr.module_count = shlib_module_count; 
    out_dl_hdr.module_loc = (shlib_module_count != 0) ? len:EMPTY;
    len += module_table_size;

    /* the module import list and module dreloc list are not visible 
       through the header. They are accessed through text relative offsets
       in the module table */
    module_import_offset = len;
    len += module_import_size;
    module_dreloc_offset = len; 
    len += module_dreloc_size; 

#ifndef NO_MULTIPLE_INITIALIZERS
    /*
    ** place initializer list before the shared library string table so
    ** that the table is word aligned.
    */
    out_dl_hdr.initializer_count = initializer_count;
    out_dl_hdr.initializer = initializer_count ? len: BAD_SYM;
    len += initializer_area_size;
#endif /* !NO_MULTIPLE_INITIALIZERS */

    out_dl_hdr.string_table_size = next_shlstr_table_indx;
    out_dl_hdr.string_table_loc = (next_shlstr_table_indx != 0) ? len:EMPTY;
    len += next_shlstr_table_indx;

    /* set after allocation/offset of $PLT$, $DLT$ subspaces */
    out_dl_hdr.dlt_loc =  0;
    out_dl_hdr.plt_loc =  0;

    out_dl_hdr.dlt_count = DLT_entry_count;
    out_dl_hdr.plt_count = PLT_entry_count;
    out_dl_hdr.highwater_mark = (building_shlib ? max_shlib_version : 0);
    out_dl_hdr.embedded_path = embedded_path_index;
    out_dl_hdr.flags   = 0; 	/* init for future use                      */

				/* the following reserved fields were added */
				/* with smart bind support. If the          */ 
       			        /* module_count field is non-zero, these    */
                                /* reserved fields are present, else they   */
    				/* extend beyond the original dl header     */
#ifdef NO_MULTIPLE_INITIALIZERS
    out_dl_hdr.reserved2  = 0;
#endif /* NO_MULTIPLE_INITIALIZERS */
#ifdef TSD 
    if (tbss_size > 0) {
        out_dl_hdr.tdsize = tbss_size;
    } else {
        out_dl_hdr.tdsize = 0;
    }
#else
    out_dl_hdr.reserved3 = 0;
#endif /* TSD */
    out_dl_hdr.fastbind_list_loc = 0;

    /* get subspace data */
    misc->subsp_data = (char *) emalloc (subsp->initialization_length);
    subspace_data = misc->subsp_data;
    misc->data_file_offset = IN_MEMORY; /* subsp data will be left in memory */

    /* copy the DL header record */
    memcpy (subspace_data, &out_dl_hdr, sizeof(struct dl_header)); 
    subspace_data += sizeof(struct dl_header);

    /*
    ** copy out the dl_header_ext structure - will set the DL_HEADER_EXT 
    ** flag in dl_header in the output.c, before writing it out. Following
    ** it will be the import and export hash values.
    */
    if (!no_dlheader_ext) {
	memcpy (subspace_data, &out_dl_hdr_ext, sizeof(struct dl_header_ext));
	subspace_data += sizeof(struct dl_header_ext);

	memcpy (subspace_data, (char *)import_hashvals, import_entry_count*sizeof(int));
	subspace_data += import_entry_count*sizeof(int);
	efree(import_hashvals);

	memcpy (subspace_data, (char *)export_hashvals, export_entry_count*sizeof(int));
	subspace_data += export_entry_count*sizeof(int);
	efree(export_hashvals);

	memcpy (subspace_data, (char *)plabel_hashvals, import_entry_count*sizeof(int));
	subspace_data += import_entry_count*sizeof(int);
	efree(plabel_hashvals);
    }

#ifdef DEBUG
    assert(out_dl_hdr.flags == 0);  /* init for future use */
    if (verbose & V_ALLDEBUG) {
	printf("\nDL_Header :\n");
	printf(" %s%d\t%s%d\n",
		"hdr_version : ", out_dl_hdr.hdr_version, 
		"ltptr_value : ", out_dl_hdr.ltptr_value);
	printf(	" %s%d\t%s%d\n",
		"shlib_list_loc : ", out_dl_hdr.shlib_list_loc, 
		"shlib_list_count : ", out_dl_hdr.shlib_list_count);
	printf(	" %s%d\t%s%d\n",
		"import_list_loc : ", out_dl_hdr.import_list_loc, 
		"import_list_count : ", out_dl_hdr.import_list_count);
	printf(	" %s%d\t%s%d\n",
		"hash_table_loc : ", out_dl_hdr.hash_table_loc, 
		"hash_table_size : ", out_dl_hdr.hash_table_size);
	printf(	" %s%d\t%s%d\n",
		"export_list_loc : ", out_dl_hdr.export_list_loc, 
		"export_list_count : ", out_dl_hdr.export_list_count);
	printf(	" %s%d\n",
		"export_ext_loc : ", out_dl_hdr.export_ext_loc);
	printf(	" %s%d\t%s%d\n",
		"string_table_loc : ", out_dl_hdr.string_table_loc, 
		"string_table_size : ", out_dl_hdr.string_table_size);
	printf(	" %s%d\t%s%d\n",
		"dreloc_loc : ", out_dl_hdr.dreloc_loc, 
		"dreloc_count : ", out_dl_hdr.dreloc_count);
	printf(	" %s%d\n", "dlt_loc : ", out_dl_hdr.dlt_loc);
	printf(	" %s%d\n", "plt_loc : ", out_dl_hdr.plt_loc);
	printf(	" %s%d\t%s%d\n",
		"dlt_count : ", out_dl_hdr.dlt_count, 
		"plt_count : ", out_dl_hdr.plt_count);
#ifndef NO_MULTIPLE_INITIALIZERS
	printf(	" %s%d\t%s%d\n",
		"initializer : ", out_dl_hdr.initializer, 
		"initializer_count : ", out_dl_hdr.initializer_count);
#endif /* !NO_MULTIPLE_INITIALIZERS */
	printf(	" %s%d\n",
		"highwater_mark : ", out_dl_hdr.highwater_mark);
        }
#endif /* DEBUG */

    /* copy the list of shared libraries */
    if (shlib_area_size > 0) {
        memcpy (subspace_data, out_shlib_list, shlib_area_size);
	efree( out_shlib_list);
    	out_shlib_list = (struct shlib_list_entry *) subspace_data;   
					/* restore pointer after free() */
        subspace_data += shlib_area_size;
        /*
        ** If building a shlib and there are no 
        ** dependent libs, unconditionally disable the embedded path and
        ** SHLIB_PATH flags.  They are useless unless the shlib has dependents.
        */
        if (building_shlib && next_shlib_list_indx == 1 && 
            dl_header_flags & SHLIB_INTERNAL_NAME) {
            dl_header_flags &= ~SHLIB_PATH_ENABLE;
            dl_header_flags &= ~EMBED_PATH_ENABLE;
        }    

#ifdef DEBUG
	if (verbose & V_ALLDEBUG) {
	    int i;
	    printf("\nReferenced Shared Libraries List :\n");
	    for (i = 0; i < next_shlib_list_indx; i++) {
	    	printf(" %s%d\n%s%s\n%s%s\n%s%s\n%s%s%d\n",
		" Shlib_name string tbl indx : ", out_shlib_list[i].shlib_name, 
		" Shlib_name : ", & out_shlstr_table[
						out_shlib_list[i].shlib_name], 
		" Was -l used to specify library? : ", 
			out_shlib_list[i].dash_l_reference ? "Yes." : "No.", 
		" Binding mode : ", 
		(out_shlib_list[i].bind & BIND_DEFERRED) ? 
						"Deferred." : "Immediate.",
		(out_shlib_list[i].bind & BIND_NONFATAL) ? 
						"(Nonfatal)" : "",
		" Version Control Highwater Mark : ", 
			out_shlib_list[i].highwater_mark 
		);
    	    }
	}
#endif /* DEBUG */
        } else if (building_shlib) {
                   /* 
                   ** unconditionally disable these flags
                   ** because there are no libs in the lib list
                   */
                   dl_header_flags &= ~SHLIB_PATH_ENABLE;
                   dl_header_flags &= ~EMBED_PATH_ENABLE;
	}
    /* copy the export hash table */
    memcpy (subspace_data, out_hash_tbl, out_hash_tbl_len * sizeof(int));
    subspace_data += out_hash_tbl_len * sizeof(int);
#ifdef DEBUG
    if (verbose & V_ALLDEBUG) {
	int i;
	printf("\nExport Hash Table (non-empty, indices into Export List) :\n");
	for (i = 0; i < out_hash_tbl_len; i++) {
	    if (out_hash_tbl[i] != EMPTY) { /* current slot not empty */
		printf(" Slot %d : %d (dec).\n", i, out_hash_tbl[i]);
	        }  /* curr not empty */
	    }
        }
#endif /* DEBUG */

    /* copy the export list */
    if (out_export_list != NULL) {
    	memcpy (subspace_data, out_export_list, export_area_size);
    	efree( out_export_list);  
    	out_export_list = (struct export_entry *) subspace_data;   
					/* restore pointer after free() */
        subspace_data += export_area_size;
    }
#ifdef DEBUG
	else 
	    assert (export_area_size == 0);

    if (verbose & V_ALLDEBUG) {
	int i;
	printf("\nExport List :\n\n");
	printf(" NextIndex SymValueIndex Type Size/Ver Name\n\n");
	for (i = 0; i < export_entry_count; i++){
	    printf(" %9d %13d %4d ",
		   out_export_list[i].next, 
		   out_export_list[i].value,
		   (int) out_export_list[i].type);
#ifdef TSD
	    if (out_export_list[i].type == ST_TSTORAGE ||
		out_export_list[i].type == ST_STORAGE)
#else
	    if (out_export_list[i].type == ST_STORAGE)
#endif /* TSD */
	    	printf("%8d ", out_export_list[i].info.size);
	    else
	    	printf("%8d", out_export_list[i].EXPORT_VERSION);
	    printf(" %s\n", & out_shlstr_table[out_export_list[i].name]);
	}
    }
#endif /* DEBUG */

    /* copy the export extension list */
    if (out_export_ext != NULL) {
    	memcpy (subspace_data, out_export_ext, export_ext_area_size);
    	efree( out_export_ext);  
    	out_export_ext = (struct export_entry_ext *) subspace_data;   
					/* restore pointer after free() */
        subspace_data += export_ext_area_size;
    }

    /* copy the import list */
    if (import_area_size > 0) {
    	memcpy (subspace_data, out_import_list, import_area_size);
    	efree( out_import_list);
    	out_import_list = (struct import_entry *) subspace_data;   
					/* restore pointer after free() */
    	subspace_data += import_area_size;

#ifdef DEBUG
    	if (verbose & V_ALLDEBUG) {
	    int i;
	    printf("\nImport List :\n");
	    for (i = 0; i < import_entry_count; i++){
	        /* init for future use */
        	assert(out_import_list[i].reserved1 == 0); 
		if (i == ltptr_DLT_entry_index)
		    printf(" Unwind-Pointer (r19) Entry\n");
		else
	    	    printf(" %s%d\n%s%s\n%s%d\n%s%d\n",
			   " Symbol name string tbl indx : ", 
			   out_import_list[i].name, 
			   " Symbol name : ", 
			   (out_import_list[i].name == EMPTY ? " " : 
			    & out_shlstr_table[ out_import_list[i].name]),
		    /*
		    ** reserved2 used to be called lib_index but is no 
		    ** longer used 
		    */
			   " Library Index (reserved2): ", 
			   out_import_list[i].reserved2, 
			   " Symbol type (decimal) : ", 
			   (int) out_import_list[i].type);
	        }
            }
#endif /* DEBUG */
  	}

    /* Copy the dynamic relocation record table. In an incomp a.out the 
       dreloc records are all a result of copying data syms to the a.out
       and are of the type DR_PROPAGATE. In a shared library we still 
       need to generate dreloc records by calling bld_shlib_dreloc_rec() 
       after this routine is called. */

    if (DR_PROPAGATE_count > 0) {
    	memcpy(subspace_data, out_dreloc_list, curr_dreloc_area_size); 
    	efree( out_dreloc_list);
	out_dreloc_list = (struct dreloc_record *) subspace_data; /* restore */
    }
    subspace_data += (curr_dreloc_area_size + added_dreloc_area_size);

    if (shlib_module_count > 0) {
    	memcpy(subspace_data, shlib_module, module_table_size); 
    	efree( shlib_module);
	shlib_module = (struct module_entry *) subspace_data; /* restore */
    }
    subspace_data += module_table_size;

    if (module_imports.cur_offset > 0) {
	memcpy(subspace_data, module_imports.buffer, module_import_size);
	efree(module_imports.buffer);
    }
    subspace_data += module_import_size;

    if (module_dreloc_count > 0) {
	/* table has not been build yet */
	module_dreloc_buffer = (int *) subspace_data; 
    }
    subspace_data += module_dreloc_size;

#ifndef NO_MULTIPLE_INITIALIZERS
    /* copy the declared initializer import list */
    if (initializer_count) {
        memcpy (subspace_data, out_initializer_list, initializer_area_size);
        efree( out_initializer_list);
        out_initializer_list = (int *) subspace_data;
        subspace_data += initializer_area_size;
    }
#endif /* !NO_MULTIPLE_INITIALIZERS */

    /* copy the string table */
    memcpy (subspace_data, out_shlstr_table, next_shlstr_table_indx);

    efree (out_shlstr_table);
    out_shlstr_table = subspace_data;
    subspace_data += next_shlstr_table_indx;

}  /* END build_shlib_subspace */

void build_PLT_subspace(index)
/* initialize subspace record for $PLT$ subspace in data space */
int index;
{
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record *misc;

    subsp = & Subsp_Dict(index);
    misc = & Subsp_Misc(index);

    subsp->initialization_length = sizeof(struct PLT_entry) * PLT_entry_count;
					   /* length of Proc Linkage Table */

    subsp->subspace_length = subsp->initialization_length;

    misc->subsp_data = (char *) out_PLT_list; 

}  /* END build_PLT_subspace */

void build_DLT_subspace(index)
/* initialize subspace record for $DLT$ subspace in data space */
int index;
{
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record *misc;
    int DLT_len;

    subsp = & Subsp_Dict(index);
    misc = & Subsp_Misc(index);
    DLT_len = DLT_entry_count * sizeof(DLT_ENTRY); 

    subsp->initialization_length = DLT_len; 

    /* shlib unwind record only found in shared library, at end of DLT */
    if (building_shlib) {
	struct shlib_unwind_info *unw_ptr;
        
        subsp->initialization_length += sizeof(struct shlib_unwind_info);
        misc->subsp_data = (char *) erealloc((char *) out_DLT_list, 
					     subsp->initialization_length);
        /* must reassign to out_DLT_list in case erealloc call moves
	   original block of memory */
        out_DLT_list = (DLT_ENTRY *) misc->subsp_data;
    
        /* initialize the unwind record found at the end of the DLT */

	unw_ptr = (struct shlib_unwind_info *) (misc->subsp_data + DLT_len); 
	unw_ptr->magic = SHLIB_UNW_VERS_ID;
	unw_ptr->shlib_name = 0;
	/* zero as shlib name inserted in string table first in linker.c so
	   that scrt0.o can use it for the database key in the flow.data. */
    } else {
	/* either building and incomplete a.out or a stand alone program 
	   that has PIC code in it. Programs with stand alone PIC will 
	   have DLT entries for data references */
        misc->subsp_data = (char *) out_DLT_list; 
    }

    subsp->subspace_length = subsp->initialization_length;

#ifdef DEBUG
    if (verbose & V_ALLDEBUG) {
    	int i; /* loop counter */
	printf("\nData Linkage Table (offset,value) :\n");
	for (i = 0; i < DLT_entry_count; i++) 
	    if (i != ltptr_DLT_entry_index)
 		printf(" %d\t%d\n", i-ltptr_DLT_entry_index, out_DLT_list[i]);
	    else
		printf(" Unwind-Pointer (r19) Entry\n");
    }
#endif /* DEBUG */

}  /* END build_DLT_subspace */

/****************************************************************************
** Procedure:    shlib_internal_name_add
** Arguments:    shlib_name_index - index into the string table
** Description
**  This function is called by add_shlib_name() in linker.c.  The purpose
**  is to set index 0 of out_shlib_list[] to the internal name of the
**  shared library being built.  We initialize the other fields even though
**  we really don't need them.
**   Set internal_name bit to 1 to denote the library is an
**  an internal name.  Set the reserved bits to 0.
*****************************************************************************/
void shlib_internal_name_add (int shlib_name_index)
{
  assert( next_shlib_list_indx == 0 );
  out_shlib_list = (struct shlib_list_entry *) 
		   emalloc (sizeof(struct shlib_list_entry));
  out_shlib_list[next_shlib_list_indx].shlib_name = shlib_name_index;
  out_shlib_list[next_shlib_list_indx].dash_l_reference = 0;
  out_shlib_list[next_shlib_list_indx].internal_name = 1;
  out_shlib_list[next_shlib_list_indx].reserved1 = 0;
  out_shlib_list[next_shlib_list_indx].bind = BIND_IMMEDIATE;
  out_shlib_list[next_shlib_list_indx++].highwater_mark = 0;
}

int shlib_string_add (s)
char *s;
{
static int alloc_len = 0;  /* length actually allocated */
int prev_indx;  /* previous "next" index - place to start current section */
int string_len;  /* length of "s", counting end null */

#define MIN_NEW_ALLOC	256	/* minimum number of chars to extend by,
				   keeps pad from building up very slowly */

#define STRING_ALLOC_PAD	1.1	/* pad length factor to build into the 
					   table(s) to cut down realloc freq */

    string_len = (strlen(s)+1); /* len counting null */

#if 0 /* comment out until n-squared search killing libc.sl build fixed */
    if (alloc_len > 0) {
	/* search for previous match */
	char *cp = out_shlstr_table;  /* working pointer into string table */
	while ((cp = 
		memchr(cp,s[0],(next_shlstr_table_indx-(cp-out_shlstr_table)))
	       ) != NULL) {
	    if ((next_shlstr_table_indx-(cp-out_shlstr_table)) < string_len)
		break;  /* too near end of string table to fit */
	    if (memcmp(cp,s,string_len) == 0)  /* if match found */
		return(cp-out_shlstr_table);
	    cp++;  /* skip over matching char to remaining string tbl */
	    }
	}
#else
    if ((next_shlstr_table_indx-string_len) >= 0) {
	/* search for match at the end of table (e.g., back-to-back calls) */
	char *cp = &out_shlstr_table[next_shlstr_table_indx-string_len];  
	    /* working pointer into string table */
	if (memcmp(cp,s,string_len) == 0)  /* if match found */
	    return(cp-out_shlstr_table);
	}
#endif

    if (building_shlib) {
	/* look in export table to find dup string quickly */
	/* only do if building shlib to keep a.out link time down */
	int exp_index;  /* temp for export index */

	exp_index = shlib_match(out_hash_tbl, 
				out_hash_tbl_len, 
				out_export_list, 
				out_shlstr_table, 
				s, 
				ST_NULL);
	if (exp_index != BAD_SYM) 
	    return(out_export_list[exp_index].name);  /* match! */
    }

    prev_indx = next_shlstr_table_indx;  
    next_shlstr_table_indx += string_len; /* len counting null */

    if (next_shlstr_table_indx > alloc_len) {
	alloc_len = (int) ((MIN_NEW_ALLOC + next_shlstr_table_indx) * 
							STRING_ALLOC_PAD);
            out_shlstr_table = erealloc(out_shlstr_table, alloc_len);
    }
    strcpy (&out_shlstr_table[prev_indx], s);
    return(prev_indx);  
#undef STRING_ALLOC_PAD /* local definition only */
#undef MIN_NEW_ALLOC /* local definition only */
} /* END shlib_string_add */

int shlib_match(exp_hash_tbl, exp_hash_tbl_len, export_list, 
		str_tbl, name, type)
int *exp_hash_tbl;     			/* ptr to hash table */
int exp_hash_tbl_len;  			/* count of hash table entries */
struct export_entry *export_list;	/* ptr to export list */
char *str_tbl;       			/* ptr to string table */
char *name;
int type;
{

    /*  match symbol against the shlib's export list.  Return index for  */
    /*	match, otherwise BAD_SYM 	    */
    /*  match to "latest" version of symbol */

    unsigned int hashkey;

    register struct export_entry *exp_sym;
    int ret_val;
    register int i;  /* current index into export table */
    int latest_version;  /* latest (highest) version number seen yet */

    extern unsigned int hash_string();

    if (export_list == NULL)
	return (BAD_SYM);  /* if no export list, can't match */

    hashkey = hash_string(name) % exp_hash_tbl_len;

    latest_version = -1;  /* all version nums positive, so first will be > */
    ret_val = BAD_SYM;

    for (i = exp_hash_tbl[hashkey]; i != EMPTY ; i = exp_sym->next) {
        exp_sym = (struct export_entry *) &export_list[i];

        if (symbol_type_match(type, exp_sym->type)) {

           if ((strcmp(&str_tbl[exp_sym->name], name) == 0) && 
	       /* "version" undef for stor_reqs */
#ifdef TSD 
	       ((exp_sym->type == ST_TSTORAGE || exp_sym->type == ST_STORAGE)||
#else
	       (exp_sym->type==ST_STORAGE ||  
#endif /* TSD */
	        (exp_sym->EXPORT_VERSION > latest_version))) {

                  /*
	          ** if name matches and version is the latest seen yet
                  **   (or N/A)
                  **
                  ** ignored if stor_req
                  */

  	          latest_version = exp_sym->EXPORT_VERSION;
	          ret_val = i;
	   }
        } else {

#ifdef OBS_FEATURES_WARN

           /*
           ** The types don't match.  If one of the types is a DATA/STORAGE,
           ** and the names match, then give a warning message.  All of them,
           ** however, can't be detected here.  dld can detect others as
           ** they are dynamically bound.
           */

	    if (verbose & V_CHANGE_WARN) {

	         if ((type == ST_DATA) || (type == ST_STORAGE) ||
                    (exp_sym->type == ST_DATA) ||
                    (exp_sym->type == ST_STORAGE))

		    if (strcmp(&str_tbl[exp_sym->name], name) == 0) {

                       found_change_warn = TRUE;

	               if (verbose & V_DETAIL_CHANGE_WARN)

                          warning(MULT_INCOMPAT_SYM_2_NUKED,
                                  name,
                                  cur_file_name, 0);
		    }
	    }
#endif

        }
    } 
    return(ret_val);  /* "ret_val" is BAD_SYM if not found in export list */
} /* END shlib_match */

/* Static global so it is also visible to search_linear() */
static struct header lib_som_header;

int read_som_symbols(ind)
  int ind;
{
    int size;

    /* Get SOM header */
    ffetch(cur_fildes,cur_ofs,&lib_som_header,sizeof(lib_som_header),1);
    if ( !_PA_RISC_ID(lib_som_header.system_id) ) {
        external_error(BAD_SYS_ID, cur_name , 0);
    }

    /* Read in symbol records */
    size = lib_som_header.symbol_total *
	   sizeof(struct symbol_dictionary_record);
    if (size > som_area_max) {
	som_area_max = size + size / 4;	   /* Get some extra room */
	if (som_area != NULL) {
	    /*Free area, and get some more.  realloc's copy is to expensive*/
	    efree(som_area);
	    som_area = NULL;
        }
    }
    if (som_area == NULL) {
	som_area = (char *) emalloc(som_area_max);
    }
    ffetch(cur_fildes,lib_som_header.symbol_location + cur_ofs, som_area,
	   sizeof(struct symbol_dictionary_record),
	   lib_som_header.symbol_total);

    /* Read in symbol strings */
    size = lib_som_header.symbol_strings_size;
    if (size > som_str_area_max) {
	som_str_area_max = size + size / 4;	   /* Get some extra room */
	if (som_str_area != NULL) {
	    /*Free area, and get some more.  realloc's copy is to expensive*/
	    efree(som_str_area);
	    som_str_area = NULL;
        }
    }
    if (som_str_area == NULL) {
	som_str_area = (char *) emalloc(som_str_area_max);
    }
    ffetch(cur_fildes,lib_som_header.symbol_strings_location + cur_ofs,
	   som_str_area, 1, lib_som_header.symbol_strings_size);

    return(lib_som_header.symbol_total);
}

/*
   main loop to linearly search the symbol_dictionary of a SOM, not follow
   the LST hash chain.  I also had to put in a check to ignore symbols not
   of scope SS_UNIVERSAL.  Finally, I removed the overflow symbols and strings
   checks which are in lib_match().
   Also, the routine returns a Boolean status, since we already know which
   SOM in the library we are looking at.
*/
int som_match(n, symbol_total, have_secondary_def, som_index, lib_cr_stor_flag)
    struct symnode *n;
    int symbol_total;
    Boolean have_secondary_def;
    int som_index;
    char *lib_cr_stor_flag;
{
    int i, sym_len;
    char *cur_sym_name, *cur_qual_name;
    struct symbol_dictionary_record *cur_lib_sym;

    /* Loop through the symbol table for this SOM */
    for (i = 0; i < symbol_total; i++) {
	cur_lib_sym = ((struct symbol_dictionary_record *) som_area) + i;
	cur_sym_name = cur_lib_sym->name.n_strx + som_str_area;

	if (strcmp(n->name, cur_sym_name) != 0)
            continue;
	/* If it ain't SS_UNIVERSAL, bag it. */
	if (cur_lib_sym->symbol_scope != SS_UNIVERSAL)
	    continue;
	if (cur_lib_sym->must_qualify || n->mq ||
	   (cur_lib_sym->qualifier_name.n_strx != 0 &&
	                                     Sym_Qual_Name(n->index) != 0)) {
	    if (cur_lib_sym->qualifier_name.n_strx == 0 ||
		    Sym_Qual_Name(n->index) == 0)
		continue;
	    if (cur_lib_sym->qualifier_name.n_strx < cur_lib_header.string_size)
		/* get from string table */
	        cur_qual_name = lib_strings + 
				     cur_lib_sym->qualifier_name.n_strx;

	    /* check for match */
	    if (strcmp(Sym_Qual_Name(n->index), cur_qual_name) != 0)
		continue;
	    }
	switch (cur_lib_sym->symbol_type) {
	    /* ST_NULL matches any type (user defined unsat) */
    	    case ST_CODE:
	    case ST_ENTRY:
	    case ST_PRI_PROG:
		if (n->type != ST_CODE && n->type != ST_NULL && !compat)
                    continue;
		break;
	    case ST_DATA:
		if (n->type != ST_DATA && n->type != ST_NULL &&
#ifdef TSD 
		    n->type != ST_TSTORAGE &&
#endif /* TSD */
		        n->type != ST_STORAGE && !compat)
                    continue;
		/*
                ** an sdef library data symbol should NOT resolve a sec. comm
		*/
                if (cur_lib_sym->secondary_def && n->secondary_def &&
#ifdef TSD 
		    n->type == ST_TSTORAGE &&
#endif /* TSD */
		    n->type == ST_STORAGE)
                    continue;
		break;
#ifdef TSD 
            case ST_TSTORAGE:
#endif /* TSD */
	    case ST_STORAGE:
	        /* Don't promote user unsat (type == ST_NULL) to ST_STORAGE. */
    		if (n->type != ST_DATA && !compat)
                    continue;
		/* 
		** Library-created storage - add to storage list with index
		** of -1 and proper length 
		*/

#ifdef OBS_FEATURES_WARN

                /*
                ** Emit the message if verbose and set the flag.
                */

                if (verbose & V_WHY) {
                   char *full_name = lib_cmpnt_name_build(
                                       som_dir[som_index].location -
                                       sizeof(struct ar_hdr));

                   info_message(LIB_CREATED_STOR_USED, full_name, n->name, 0);
                   free(full_name);
                }
                *lib_cr_stor_flag = TRUE;

#endif

#if 0
		unsat_add(n->name, n->mq, n->qname, n->hashval,
				    BAD_SYM, ST_STORAGE,
				    cur_lib_sym->symbol_value,
                                    n->secondary_def);
#endif /* 0 */
		/* change existing symbol and node to storage request */
#ifdef TSD 
		if (cur_lib_sym->symbol_type == ST_TSTORAGE) 
		   n->type = ST_TSTORAGE;
                else
#endif /* TSD */
		n->type = ST_STORAGE;
		n->len = cur_lib_sym->symbol_value;
		if (n->index != BAD_SYM) {
#ifdef TSD 
		    if (cur_lib_sym->symbol_type == ST_TSTORAGE)
		       Sym_Dict(n->index).symbol_type = ST_TSTORAGE;
                    else
#endif /* TSD */
		    Sym_Dict(n->index).symbol_type = ST_STORAGE;
		    Sym_Dict(n->index).symbol_value = n->len;
		}
		num_storage_requests++;  /* used for stor req sorting */
                /* 
		** we continue here because we don't want to bring in the
                ** library module if it only contains a storage request -
                ** instead we upgrade the existing symbol to a storage request.
                */
		continue;
	    }
	/* may have to check other things here later */

	/* 
	** a match! Don't count a secondary def if we already have one. 
	*/

	if (cur_lib_sym->secondary_def && have_secondary_def)
	    continue;
	else
	    return (TRUE);
	}
    return (-1);
} /* end som_match */

Boolean search_linear(noloop)
  Boolean noloop;
{
    struct symnode *n;
    Boolean more_soms_added,mult_itr_soms_added=FALSE;
    int i,symbol_total,end_ofs;
    Boolean have_secondary_def;

    struct symnode **table_to_search; /* pointer to the table being searched */

    /* start searching to resolve unsats */
    /* This loops over the library SOMs multiple times if noloop is FALSE */
    repeat {
	int j;  /* loop counter - search each list once only per pass */
	int som_index; /* loop counter - currently selected som */

	if (verbose & V_WHY)
	    info_message(VERBOSE_SEARCHING, lib_name, 0);

      more_soms_added = FALSE;

      /* Here we loop throught the SOMs in a library */
      for (som_index=0; som_index < cur_lib_header.module_count; som_index++) {

       cur_ofs=som_dir[som_index].location;
       end_ofs=cur_ofs+som_dir[som_index].length;

       /* Here we deal with multipart SOMs.  i.e., "cat f1.o f2.o >f3.o" */
       while (cur_ofs < end_ofs) {
           symbol_total = read_som_symbols(som_index);

	if (building_incomp_exec)
            /* mark all shlib unsats as unchecked */
            for (i = 0; i < UNSATHASHSIZE; i++)
                for (n = shlib_unsat_hash_table[i]; n; n = n->next)
                   n->checked = FALSE;

        /* mark all unsats as unchecked */
        for (i = 0; i < UNSATHASHSIZE; i++)
    	    for (n = unsat_hash_table[i]; n; n = n->next)
                n->checked = FALSE;

	/* optimize this later by marking unsats not in lib */

	if (building_incomp_exec) {
	    j=0; 
	    table_to_search = shlib_unsat_hash_table;
	} else {
	    j=1; 
	    table_to_search = unsat_hash_table;
        }
        for (;j < 2; j++, table_to_search = unsat_hash_table)

	for (i = 0; i < UNSATHASHSIZE; i++) {
	    for (n = table_to_search[i]; n; n = n->next) {
		if (n->checked)
                    continue;

		/* if "soft" storage request, allow it to 
		   bring in data univ */
		if (n->exported_by_shlib && !n->shlib_storage)
                    continue;

                have_secondary_def = 
		       sec_find(n->name, 
				n->mq, 
				Sym_Qual_Name(n->index),
			        n->hashval, 
				n->type)
		    != BAD_SYM;
		if ((som_match(n,
                               symbol_total,
                               have_secondary_def,
                               som_index,
                               &lib_cr_stor_flag[som_index]) != -1) &&
		     !added_som[som_index]) {
		    more_soms_added = TRUE;
		    mult_itr_soms_added = TRUE;
		    if (verbose & V_WHY)
			print_why(som_index, n);
		    lib_som_add(som_index);
		    added_som[som_index] = TRUE;
		    n->checked = TRUE;
		    goto NEXT_SOM; /* Ugly, but I gotta break outta 4 loops */
                }

		n->checked = TRUE;
		}
	    }
	    cur_ofs += lib_som_header.som_length;
	   }
	NEXT_SOM:;	/* Notice ';'.  It marks the end of the loop */

#ifdef OBS_FEATURES_WARN

        /*
        ** If the som was not added but library created storage was used,
        ** emit a warning if verbose says to.  Also clear the flag.
        */

        if ((verbose & V_CHANGE_WARN) && (verbose & V_WHY)) {

           if (!added_som[som_index] && lib_cr_stor_flag[som_index]) {

              found_change_warn = TRUE;

              if (verbose & V_DETAIL_CHANGE_WARN) {

                 char *full_name = lib_cmpnt_name_build(
                                      som_dir[som_index].location -
                                      sizeof(struct ar_hdr));

                 warning(LIB_CREATED_STOR_NUKED, full_name, 0);
                 free(full_name);
              }
              lib_cr_stor_flag[som_index] = FALSE;
           }
	}

#endif

     }
    } until (!more_soms_added || noloop);
    return (mult_itr_soms_added);
} /* END search_linear */

Boolean search_non_linear(noloop)
    Boolean noloop;
{
    struct symnode *n;
    Boolean more_soms_added,mult_itr_soms_added=FALSE;
    int som,i;
    Boolean have_secondary_def;

    struct symnode **table_to_search; /* pointer to the table being searched */

    if (building_incomp_exec)
    	/* mark all shlib unsats as unchecked */
    	for (i = 0; i < UNSATHASHSIZE; i++)
	   for (n = shlib_unsat_hash_table[i]; n; n = n->next)
               n->checked = FALSE;

    /* mark all unsats as unchecked */
    for (i = 0; i < UNSATHASHSIZE; i++)
	for (n = unsat_hash_table[i]; n; n = n->next)
            n->checked = FALSE;

    /* start searching to resolve unsats */
    repeat {

	int j;  /* loop counter - search each list once only per pass */

	if (verbose & V_WHY)
	    info_message(VERBOSE_SEARCHING, lib_name, 0);

	/* optimize this later by marking unsats not in lib */

	if (building_incomp_exec) {
	    j=0; 
	    table_to_search = shlib_unsat_hash_table;
        } else {
	    j=1; 
	    table_to_search = unsat_hash_table;
	}
        for (;j < 2; j++, table_to_search = unsat_hash_table)
	for (i = 0; i < UNSATHASHSIZE; i++) {
	    for (n = table_to_search[i]; n; n = n->next) {
		if (n->checked)
                    continue;

		/* if "soft" storage request, allow it to 
		   bring in data univ */
		if (n->exported_by_shlib && !n->shlib_storage)
                    continue;

		have_secondary_def = 
                       sec_find(n->name, 
				n->mq, 
				Sym_Qual_Name(n->index),
			        n->hashval, 
				n->type)
		    != BAD_SYM;
		if ((som = lib_match(n, have_secondary_def, lib_cr_stor_flag))
                       != -1) {
		    select_som[som] = TRUE;
		    if (verbose & V_WHY)
			print_why(som, n);
                }

		n->checked = TRUE;
	    }
	}
	more_soms_added = FALSE;
	for (i = 0; i < cur_lib_header.module_limit; i++)
            if (!added_som[i]) {
                if (select_som[i]) {
		    lib_som_add(i);
                    more_soms_added = TRUE;
		    mult_itr_soms_added = TRUE;
		    added_som[i] = TRUE;

#ifdef OBS_FEATURES_WARN

                } else {

                    /*
                    ** If the som was not added but library created storage
                    ** was used, emit a warning if verbose says to.  Also,
                    ** clear the flag.
                    */

                    if ((verbose & V_CHANGE_WARN) && (verbose & V_WHY)) {

                       if (lib_cr_stor_flag[i]) {

		          found_change_warn = TRUE;

		          if (verbose & V_DETAIL_CHANGE_WARN) {

                              char *full_name = lib_cmpnt_name_build(
                                                  som_dir[i].location -
                                                  sizeof(struct ar_hdr));

                              warning(LIB_CREATED_STOR_NUKED, full_name, 0);
                              free(full_name);
			  }
                          lib_cr_stor_flag[i] = FALSE;
		       }
		    }

#endif
		}
	    }
	}
    until (!more_soms_added || noloop);

    return (mult_itr_soms_added);
} /* END search_non_linear */

Boolean lib_search(arhead,force_flag,linear,noloop)
struct ar_hdr *arhead;
int force_flag;
Boolean linear, noloop;
{
    int i,size;

    lib_ofs = cur_ofs;
    sym_oflo_warned = 0;
    str_oflo_warned = 0;
    /* library file offsets that point into the LST are relative to
     * the LST header, while the offsets in the SOM directory that
     * point to other SOMs in the file are absolute offsets within
     * the file. */
    lib_name = cur_name;
    ffetch(cur_fildes,lib_ofs,&cur_lib_header,sizeof(cur_lib_header),1);
    if (cur_lib_header.a_magic != LIBMAGIC) {
	if (elfd_is_elf_archive(cur_fildes)) {
	    external_error(PA64_ARCHIVE_FILE_32BIT_LINK, cur_name, 0);
	} else {
	    external_error(BAD_LIB_HEADER, cur_name, 0);
	}
    }
    if (cur_lib_header.checksum !=
			checksum(&cur_lib_header,sizeof(cur_lib_header))) {
	external_error(BAD_HEADER_CHECKSUM, cur_name, 0);
    }

    /* this check sidesteps a bug in an old Link Editor that was storing */
    /* the number of bytes instead of the number of symbol records */
    if (cur_lib_header.export_count * sizeof(struct lst_symbol_record) +
	    cur_lib_header.export_loc > cur_lib_header.file_end &&
	    cur_lib_header.file_end != 0)
        cur_lib_header.export_count /= sizeof(struct lst_symbol_record);

    /* allocate block of memory for LST */
    size = cur_lib_header.module_limit * sizeof(struct som_entry);
    if (force_flag != FORCE_LOAD && force_flag != FORCE_LOAD_WITH_FEQ)
        size += cur_lib_header.hash_size * sizeof(unsigned int) +
		    cur_lib_header.module_limit +
		    cur_lib_header.module_limit +
		    cur_lib_header.module_limit +
		    cur_lib_header.string_size +
		    cur_lib_header.export_count *
			sizeof(struct lst_symbol_record);
    if (size > lib_area_max) {
	lib_area_max = size + size / 4;
	if (lib_area != NULL) {
	    lib_area = erealloc(lib_area, lib_area_max);
	}
    }
    if (lib_area == NULL) {
	lib_area = (char *)emalloc(lib_area_max);
    }

    /* carve out areas in lib_area */
    som_dir = (struct som_entry *)lib_area;
    if (force_flag != FORCE_LOAD && force_flag != FORCE_LOAD_WITH_FEQ) {
        lib_hash = (int *)&som_dir[cur_lib_header.module_limit];
        export_list = (struct lst_symbol_record *)
				&lib_hash[cur_lib_header.hash_size];
        export_end = &export_list[cur_lib_header.export_count];
        select_som = (char *) export_end;
        added_som = (char *) &select_som[cur_lib_header.module_limit];
        lib_cr_stor_flag = (char *) &added_som[cur_lib_header.module_limit];
        lib_strings = (char *) &lib_cr_stor_flag[cur_lib_header.module_limit];
    }

    /* get SOM directory */
    ffetch(cur_fildes,lib_ofs+cur_lib_header.dir_loc,som_dir,
		sizeof(struct som_entry),cur_lib_header.module_limit);

    /* 
     * Moved the code to setting cur_ntbl[] from the end of
     * this routine here since lib_som_add() will need it
     * for ar file member which has long file name.
     */

    /*
    ** Get long member name table if it exists.  This special member follows
    ** the symbol table if long file names exist within the archive.
    */
    {
	int	clen;
        size_t ntbl_size;
        size_t stbl_size;
        struct ar_hdr ar_hdr;
        char *ptr;
	static size_t cur_ntbl_size = 0;

        stbl_size = atol((const char *) &arhead->ar_size);
        ffetch(cur_fildes,lib_ofs+stbl_size,&ar_hdr,sizeof(struct ar_hdr), 1);
        if (ar_hdr.ar_name[0] == '/' && ar_hdr.ar_name[1] == '/') {
            ntbl_size = atol((const char *) &ar_hdr.ar_size);
            if (ntbl_size > cur_ntbl_size) {
                if (cur_ntbl != NULL) {
		    efree(cur_ntbl);
                    cur_ntbl=emalloc(ntbl_size);
                    cur_ntbl_size = ntbl_size;
                }
            }
            if (cur_ntbl == NULL) {
                cur_ntbl=(char *)emalloc(ntbl_size);
                cur_ntbl_size = ntbl_size;
            }

            ffetch(cur_fildes,lib_ofs + stbl_size + sizeof(struct ar_hdr), 
                cur_ntbl, sizeof(char), ntbl_size);

            ptr = cur_ntbl;

	    /* Change every '/' to '\0' in the name table */
	    if (MB_CUR_MAX == 1) {
		for( ;ptr < cur_ntbl + ntbl_size; ptr++) {
		    if (*ptr == '/')
			*ptr = '\0';
		}
	    } else {
		while (ptr < cur_ntbl + ntbl_size) {
		    clen=mblen(ptr, MB_CUR_MAX);
		    if (clen == 1 && *ptr == '/')
			*ptr = '\0';
		    if (clen > 0)
			ptr += clen;
		    else
			ptr++;  /* mblen returned -1 - error */
		}
	    }
	}
    }


    /* if force_flag is FORCE_LOAD or FORCE_LOAD_WITH_FEQ, the library
       must be loaded unconditionally */
    if (force_flag == FORCE_LOAD || force_flag == FORCE_LOAD_WITH_FEQ) {
	for (i = 0; i < cur_lib_header.module_count; i++) {
	    if (som_dir[i].location != (unsigned int)-1 &&
		    som_dir[i].length != 0)
		lib_som_add(i);
	}
	return(TRUE);
    }

    /* initialize som selection arrays to zero */
    for (i = 0; i < cur_lib_header.module_limit; i++) {
	select_som[i] = added_som[i] = lib_cr_stor_flag[i] = FALSE;
    }

    /* get library symbol table strings */
    ffetch(cur_fildes,lib_ofs+cur_lib_header.string_loc,lib_strings,
		sizeof(char),cur_lib_header.string_size);

    /* get library symbol table hash table */
    ffetch(cur_fildes,lib_ofs+cur_lib_header.hash_loc,lib_hash,
		sizeof(unsigned int),cur_lib_header.hash_size);

    /* get export list */
    if (cur_lib_header.export_count != 0)
        ffetch(cur_fildes,lib_ofs+cur_lib_header.export_loc,export_list,
		sizeof(struct lst_symbol_record),cur_lib_header.export_count);

    if (linear)
	return(search_linear(noloop));
    else
	return(search_non_linear(noloop));

} /* END lib_search */


void mb_trim_ar_name(char *ar_name)
{
    char	mb_buf[AR_NAME_LEN + 1];
    wchar_t	wc_buf[AR_NAME_LEN + 1];
    int		wc_idx;
    int		wc_len;

    (void) mb_strncpy(mb_buf, ar_name, AR_NAME_LEN);
    mb_buf[AR_NAME_LEN] = 0;
    wc_len = mbstowcs(wc_buf, ar_name, AR_NAME_LEN);
    for (wc_idx = wc_len -1;  
	 wc_idx > 0 && wc_buf[wc_idx] == L' ';  
	 wc_idx--)
	;
    if (wc_buf[wc_idx] != L' ' && wc_buf[wc_idx] != L'/')
	wc_idx++;
    wc_buf[wc_idx] = L'\0';
    (void) wcstombs(ar_name, wc_buf, AR_NAME_LEN - 1);
    ar_name[AR_NAME_LEN - 1] = 0;  /* ensure proper null termination */
}

print_why(som, n)
int som;
struct symnode *n;
    {
    int ofs;
    char *q;
    struct ar_hdr ar_hdr;


    /* get the archive header */
    ofs = som_dir[som].location - sizeof(struct ar_hdr);
    ffetch(cur_fildes, ofs, &ar_hdr, sizeof(struct ar_hdr), 1);

    /* trim archive member name */
    if (MB_CUR_MAX == 1) {
	for (q = &ar_hdr.ar_name[AR_NAME_LEN-1]; *q == ' '; q--)
	    /* EMPTY STATEMENT */ ;
	if (*q != '/')
	    q++;
	*q = '\0';
    } else {
	mb_trim_ar_name(ar_hdr.ar_name);
	q = ar_hdr.ar_name + strlen(ar_hdr.ar_name);
    }

    /* print the why message */
    /*
    ** Added long file name support for archives.  Check first to see if
    ** this is a long name.  A '/' followed by an decimal digit in ASCII
    ** indicated this member has a long file name and the ar_name field
    ** contains the index into the long name table.
    */
    if (ar_hdr.ar_name[0] == '/' && isdigit(ar_hdr.ar_name[1])) {
        info_message(VERBOSE_SELECTING, cur_ntbl + atol(&ar_hdr.ar_name[1]),
            n->name, 0);
    } else {
        info_message(VERBOSE_SELECTING, ar_hdr.ar_name, n->name, 0);
    }

    for ( ; n != NULL; n = n->same) {
	if (n->index != -1)
	    if (Sym_Subsp(n->index) != BAD_SUBSP)
	        info_message(VERBOSE_REFERENCE,
		    Subsp_Misc(Sym_Subsp(n->index)).file_name, 0);
	    else  /* BAD_SUBSP in unsat only happens for shlib "soft" unsats */
	        info_message(VERBOSE_REFERENCE, "Shared Library", 0);
    }

} /* END print_why */

static int lib_match(n, have_secondary_def, lib_cr_stor_flag)
struct symnode *n;
Boolean have_secondary_def;
char *lib_cr_stor_flag;
{
    int hashval, hashkey;
    int ofs, rel_ofs;
    int sym_len;
    char *cur_sym_name, *cur_qual_name;
    struct lst_symbol_record *cur_lib_sym;
    static struct lst_symbol_record temp_sym;

    hashval = lib_hash_string(n->name);
    hashkey = hashval % cur_lib_header.hash_size;

    for (ofs = lib_hash[hashkey]; ofs; ofs = cur_lib_sym->next_entry) {
	rel_ofs = ofs - cur_lib_header.export_loc;
	if (ofs >= cur_lib_header.export_loc &&
	    rel_ofs < cur_lib_header.export_count *
				sizeof(struct lst_symbol_record)) {
	    cur_lib_sym = (struct lst_symbol_record *)
				((char *)export_list + rel_ofs);
    	} else {
	    if ((verbose & V_WHY) && !sym_oflo_warned++)
		printf(
		   "WARNING:  LIBRARY %s HAS OVERFLOW SYMBOLS; USE CLEANRL\n",
					lib_name);
	    ffetch(cur_fildes,
		   lib_ofs+ofs,
		   &temp_sym,
		   sizeof(struct lst_symbol_record),
		   1);
	    cur_lib_sym = &temp_sym;
	}

	if (cur_lib_sym->symbol_key != hashval)
            continue;
	if (cur_lib_sym->name.n_strx < cur_lib_header.string_size)
	    cur_sym_name = lib_strings + cur_lib_sym->name.n_strx;
	else {
	    /* fetch symbol name from overflow area */

	    /* LEAVE in on HP-UX, as is common practice to bring RL's from
	       MPE XL to HP-UX and they may have overflow strings.  The test
	       suite expects it, too. */

	    if ((verbose & V_WHY) && !str_oflo_warned++)
		printf(
		  "WARNING:  LIBRARY %s HAS OVERFLOW STRINGS; USE CLEANRL\n",
					lib_name);
	    ffetch(cur_fildes,
		   lib_ofs + cur_lib_header.string_loc +
		   cur_lib_sym->name.n_strx - sizeof(int),
		   &sym_len, 
		   sizeof(int), 
		   1);
	    if (sym_len > oflo_buf_size) {
		if (sym_oflo_buf != NULL) {
		    efree(sym_oflo_buf);
		}
		sym_oflo_buf = emalloc(sym_len + 1);
		oflo_buf_size = sym_len;
	    }
	    cur_sym_name = sym_oflo_buf;
	    ffetch(cur_fildes,
		   lib_ofs + cur_lib_header.string_loc +
		   cur_lib_sym->name.n_strx,
		   cur_sym_name, 
		   1, 
		   sym_len+1);
	}

	if (strcmp(n->name, cur_sym_name) != 0)
            continue;
	if (cur_lib_sym->must_qualify || n->mq ||
	   (cur_lib_sym->qualifier_name.n_strx != 0 &&
	                                     Sym_Qual_Name(n->index) != 0)) {
	    if (cur_lib_sym->qualifier_name.n_strx == 0 ||
		    Sym_Qual_Name(n->index) == 0)
		continue;
	    if (cur_lib_sym->qualifier_name.n_strx < 
		cur_lib_header.string_size)
		/* get from string table */
	        cur_qual_name = lib_strings + 
				     cur_lib_sym->qualifier_name.n_strx;
	    else {
	        /* fetch qualified name string from string overflow area */
	        if ((verbose & V_WHY) && !str_oflo_warned++)
		    printf(
		      "WARNING:  LIBRARY %s HAS OVERFLOW STRINGS; USE CLEANRL\n",
					    lib_name);
	        ffetch(cur_fildes,
		       lib_ofs + cur_lib_header.string_loc +
		       cur_lib_sym->qualifier_name.n_strx - sizeof(int),
		       &sym_len, 
		       sizeof(int), 
		       1);
	        if (sym_len > oflo_buf_size) {
		    if (sym_oflo_buf != NULL) {
		        efree(sym_oflo_buf);
		    }
		    sym_oflo_buf = emalloc(sym_len + 1);
		    oflo_buf_size = sym_len;
		}
	        cur_qual_name = sym_oflo_buf;
	        ffetch(cur_fildes,
		       lib_ofs + cur_lib_header.string_loc +
		       cur_lib_sym->qualifier_name.n_strx,
		       cur_qual_name, 
		       1, 
		       sym_len+1);
	    }

	    /* check for match */
	    if (strcmp(Sym_Qual_Name(n->index), cur_qual_name) != 0)
		continue;
	    }
	switch (cur_lib_sym->symbol_type) {
	    /* ST_NULL matches any type (user defined unsat) */
    	    case ST_CODE:
	    case ST_ENTRY:
	    case ST_PRI_PROG:
		if (n->type != ST_CODE && n->type != ST_NULL && !compat)
                    continue;
		break;
	    case ST_DATA:
		if (n->type != ST_DATA && n->type != ST_NULL &&
#ifdef TSD 
		    n->type != ST_TSTORAGE &&
#endif /* TSD */
		        n->type != ST_STORAGE && !compat)
                    continue;
                /* 
		** an sdef library data symbol should NOT resolve a sec. comm 
		*/
                if (cur_lib_sym->secondary_def && n->secondary_def &&
#ifdef TSD 
		    n->type == ST_TSTORAGE &&
#endif /* TSD */
		    n->type == ST_STORAGE)
                    continue;
		break;
#ifdef TSD 
            case ST_TSTORAGE:
#endif /* TSD */
	    case ST_STORAGE:
	        /* Don't promote user unsat (type == ST_NULL) to ST_STORAGE. */
    		if (n->type != ST_DATA && !compat)
                    continue;

#ifdef OBS_FEATURES_WARN

                /*
                ** Emit the message if verbose and set the flag.
                */

                if (verbose & V_WHY) {
                   char *full_name = lib_cmpnt_name_build(
                                        som_dir[cur_lib_sym->som_index].
                                           location -
                                        sizeof(struct ar_hdr));

                   info_message(LIB_CREATED_STOR_USED, full_name, n->name, 0);
                   free(full_name);
                }
                lib_cr_stor_flag[cur_lib_sym->som_index] = TRUE;

#endif

		/* Library-created storage - add to storage
		 * list with index of -1 and proper length */
#if 0
		unsat_add(n->name, 
		          n->mq, 
			  n->qname, 
			  n->hashval,
			  BAD_SYM, 
			  ST_STORAGE,
			  cur_lib_sym->symbol_value,
                          n->secondary_def);
#endif /* 0 */
		/* change existing symbol and node to storage request */
#ifdef TSD 
		if (cur_lib_sym->symbol_type == ST_TSTORAGE) {
                   n->type = ST_TSTORAGE;
		} else
#endif /* TSD */
		n->type = ST_STORAGE;
		n->len = cur_lib_sym->symbol_value;
		if (n->index != BAD_SYM) {
#ifdef TSD 
		    if (cur_lib_sym->symbol_type == ST_TSTORAGE) {
		       Sym_Dict(n->index).symbol_type = ST_TSTORAGE;
		    } else
#endif /* TSD */
		    Sym_Dict(n->index).symbol_type = ST_STORAGE;
		    Sym_Dict(n->index).symbol_value = n->len;
		}
		num_storage_requests++;  /* used for stor req sorting */
                /* we continue here because we don't want to bring in the
                   library module if it only contains a storage request -
                   instead we upgrade the existing symbol to a storage
                   request.
                */
		continue;
	}
	/* may have to check other things here later */

	/* 
	** a match!  Don't count a secondary def if we already have one. 
	*/

	if (cur_lib_sym->secondary_def && have_secondary_def)
	    continue;
	else
	    return (cur_lib_sym->som_index);
    }
    return (-1);
} /* END lib_match */

static void lib_som_add(ind)
int ind;
{
    int ar_hdr_ofs, end_ofs;

    cur_ofs = som_dir[ind].location;
    end_ofs = cur_ofs + som_dir[ind].length;
    ar_hdr_ofs = cur_ofs - sizeof(struct ar_hdr);
    /* note module_name is set within */
    cur_name = lib_cmpnt_name_build(ar_hdr_ofs);
    repeat {
	som_add();
	cur_ofs += cur_header.som_length;
	}
    until (cur_ofs >= end_ofs);
} /* END lib_som_add */


static char *lib_cmpnt_name_build(ofs)
int ofs;
{
    struct ar_hdr ar_hdr;
    char *name, *p, *q, *r;

    /* get the archive header */
    ffetch(cur_fildes,ofs,&ar_hdr,sizeof(struct ar_hdr),1);

    /* trim archive member name to length allowed in ar.h */
    /* Note : this is at some variance from the goal of fully supporting
       long file names, but even BSD doesn't in archives. - */

    if (MB_CUR_MAX == 1) {
	for (q = &ar_hdr.ar_name[AR_NAME_LEN-1]; *q == ' '; q--)
	    /* EMPTY STATEMENT */ ;
	if (*q != '/')
	    q++;
	*q = 0;
    } else {
	mb_trim_ar_name(ar_hdr.ar_name); 
	q = ar_hdr.ar_name + strlen(ar_hdr.ar_name);
    }

    /* allocate space for the file and archive member name */
    /*
    ** Added support for long file names in archives.  Check for a long
    ** file name in the member header.
    */
    if (ar_hdr.ar_name[0] == '/' && isdigit(ar_hdr.ar_name[1])) {
        name = emalloc(strlen(lib_name)+strlen(cur_ntbl)+
            atol(&ar_hdr.ar_name[1])+3);
        module_name = emalloc(strlen(cur_ntbl + atol(&ar_hdr.ar_name[1]))+1);
        }
    else {
        name = emalloc(strlen(lib_name)+(q-ar_hdr.ar_name)+3);
        module_name = emalloc((q-ar_hdr.ar_name)+1);
        }

    /* copy "file_name(member_name)" */
    for (p = name, q = lib_name; *q; )
        *p++ = *q++;
    *p++ = '(';
    r = module_name;
    /*
    ** Added support for long file names in archives.
    */
    for (q = (ar_hdr.ar_name[0] == '/' && isdigit(ar_hdr.ar_name[1])) ?
        cur_ntbl + atol(&ar_hdr.ar_name[1]) : ar_hdr.ar_name; *q; ) {
        *r++ = *q;
        *p++ = *q++;
	}
    *p++ = ')';
    *p = 0;
    *r = 0;
    return (name);
} /* END lib_cmpnt_name_build */


/* 
**  Remove #ifdef PBO for the -Fu, -Fs code since
** we can use this in a non PBO environment.
*/
/******************************************************************************
* FUNCTION :            print_syms_in_som 
*
* ARGUMENTS:
*       sym_index - the starting index in the symbol dictionary record.
*       count     - number of symbols to print. 
*
* RETURN VALUE:
*       none.                                                             
*
* PURPOSE:
*       Print all the symbol table entries for a som in an archived library or
*       a relocatable object file in the following format (similar to nm -p):  
*           - the symbol value (decimal), symbol type (2 chars), and name
*                where symbol type is:
*                U (undefined), A (absolute), T (text symbol), K (TLS common),
*                D (data symbol), B (bss symbol), c (data storage),
*                M (TLS data symbol).
*                If the symbol is local (non-external), the type letter 
*                is in lower case. If the symbol is a secondary definition,
*                the type letter is followed by the letter S.
*
*
* NOTES:
*       Now have an array of FILE pointers, so we can emit multiple files
*       at once for -Fs*, as we can for -Fu*.
*       denote TLS Commons.
*
* ALGORITHM:
*
******************************************************************************/

print_syms_in_som (int sym_index, int count)
{
    register struct symbol_dictionary_record *symbol;
    int sym_ind, last;
    int cur_symbol_value;
    char   class, secdef;
    char   *cur_sym_name; 
    static const char format_string1[] = "%.10ld %c%c %s\n";
    static const char format_string2[] = "0000000000 U  %s\n";
    FILE *fp;

    last = sym_index + count;
    for (sym_ind = sym_index; sym_ind < last; sym_ind++) {

	symbol = &Sym_Dict(sym_ind);

	if (symbol->symbol_type == ST_NULL ||
	    symbol->symbol_type == ST_SYM_EXT ||
	    symbol->symbol_type == ST_ARG_EXT)
	    continue;

        cur_sym_name = symbol->name.n_name;

		/* Undefined symbols: meaningless value field */
	if (symbol->symbol_scope == SS_UNSAT && 
#ifdef TSD 
	    symbol->symbol_type != ST_TSTORAGE &&
#endif /* TSD */
	    symbol->symbol_type != ST_STORAGE) {
	    if (fp = trace_sym_files [FS_TRACE_ALL])
	        fprintf (fp, format_string2, cur_sym_name);

	    if (fp = trace_sym_files [FS_TRACE_NO_FNAME])
	        fprintf (fp, format_string2, cur_sym_name);

        } else {                  /* "defined" symbol */
            cur_symbol_value = symbol->symbol_value;
	    switch (symbol->symbol_type) {
	        case ST_ABSOLUTE:	
		    class = 'a'; 
		    break;
		case ST_DATA:	
#ifdef TSD 
		    if (Sym_TLS(sym_ind)) {
                       class = 'm';
                    } else 
#endif /* TSD */
		    class = 'd'; 
		    break;
#ifdef TSD 
		case ST_TSTORAGE:
		    class = 'k';
		    break;
#endif /* TSD */
		case ST_STORAGE:	
		    class = 'c'; 
		    break;
		case ST_CODE:	
		case ST_PRI_PROG:	
		case ST_SEC_PROG:	
		case ST_ENTRY:	
		case ST_STUB:	
		case ST_MILLICODE:	
		case ST_PLABEL:	
		    class = 't'; 
		    cur_symbol_value &= ~CLEAR_SYM_XL;
		    break;
		default:		
		    class = '?'; 
		    break;
	    }
	    if (class == 'd') {
                if (strcmp ("$BSS$", 
                            Subsp_Dict (symbol->symbol_info).NAME_PT) == 0)
		    class = 'b';

            }
	    if (symbol->secondary_def)
	        secdef = 'S';
	    else
	        secdef = ' ';
	    if (symbol->symbol_scope == SS_UNIVERSAL)  
		class = class - 'a' + 'A';

	    if (fp = trace_sym_files [FS_TRACE_ALL])
		fprintf (fp, format_string1,
			 cur_symbol_value, class, secdef, cur_sym_name);

	    if (fp = trace_sym_files [FS_TRACE_NO_FNAME])
		fprintf (fp, format_string1,
		         cur_symbol_value, class, secdef, cur_sym_name);

	    if (symbol->symbol_scope != SS_LOCAL &&
			 (fp = trace_sym_files [FS_TRACE_EXPORTS]))
		fprintf (fp, format_string1,
		         cur_symbol_value, class, secdef, cur_sym_name);

	    if (symbol->symbol_scope != SS_LOCAL &&
		         (fp = trace_sym_files [FS_TRACE_EXPORTS_STOR]))
		fprintf (fp, format_string1,
		         cur_symbol_value, class, secdef, cur_sym_name);

	    if (fp = trace_sym_files [FS_TRACE_RESOLVES])
		fprintf (fp, format_string1,
		         cur_symbol_value, class, secdef, cur_sym_name);
	    
        } /* "defined" symbol */
    }	  /* end for */
}

/******************************************************************************
* FUNCTION :            print_sl_export_list
*
* ARGUMENTS:
*       export_list  -  pointer to the export list in the shared library. 
*       total_export -  total number of export symbols. 
*       str_table    -  pointer to the symbol string table. 
*
* RETURN VALUE:
*       none.                                                             
*
* PURPOSE:
*       Print the export symbol table entry list in a shared library in the 
*       following format (similar to nm -p):
*           - the symbol value (decimal), symbol type (2 chars), and name
*                where symbol type is:
*                T (text symbol), 
*                D (data symbol), 
*                K (TLS common),
*                M (TLS Data symbol),
*                c (data storage).
*
* NOTES:
*       Please notify the COBOL/UX and C++ team if you made any changes
*       to the characters for symbol type. 
*
* ALGORITHM:
*
******************************************************************************/

print_sl_export_list(export_list,total_export,str_table)
struct export_entry *export_list;		/* ptr to export list 	     */
char *str_table;
int total_export;
{
    int i;
    char class;
    FILE *fp;
    static const char *format = "%.10ld %c  %s\n";
 
    for (i=0; i<total_export; i++) {
	 switch (export_list[i].type) {
	     case ST_DATA:	
#ifdef TSD 
	             if (export_list[i].is_tp_relative == 1) {
		        class = 'M';
		     } else 
#endif /* TSD */
		     class = 'D'; 
		     break;
#ifdef TSD 
 	     case ST_TSTORAGE:
                     class = 'K';
		     break;
#endif /* TSD */
	     case ST_STORAGE:	
                     /* This data storage would have been allocated
                        by a data declaration or by the linker. 
                        The linker will satisfy this unsats by allocating a 
                        storage for it ('c') if there is no other declaration,
                        otherwise this will become 'D' for data symbol by
                        the time it appears in an incomplete a.out for
                        uninitialized data.*/ 
		     class = 'c'; 
		     break;
	     case ST_CODE:	
	     case ST_PRI_PROG:	
	     case ST_SEC_PROG:	
	     case ST_ENTRY:	
	     case ST_STUB:	
	     case ST_MILLICODE:	
                     class = 'T';
                     break;
	     case ST_PLABEL:	
				/* Plabel exports
				** really aren't symbol definitions. */
		     continue;  /* to next 'for' iteration */
	     default:		
		     class = '?'; 
		     break;
	 }

         /*
         ** Dump size out instead of value for
         ** storage requests if -Fss specified on a shlib.
         */
	/* Revamped the implementation */

	if (fp = trace_sym_files [FS_TRACE_ALL])
	    fprintf (fp, format, export_list[i].value, class, 
                     &str_table[export_list[i].name]);

	if (fp = trace_sym_files [FS_TRACE_NO_FNAME])
	    fprintf (fp, format, export_list[i].value, class, 
                     &str_table[export_list[i].name]);

	if (fp = trace_sym_files [FS_TRACE_EXPORTS])
	    fprintf (fp, format, export_list[i].value, class, 
                     &str_table[export_list[i].name]);

	if (fp = trace_sym_files [FS_TRACE_EXPORTS_STOR])
	    fprintf (fp, format,
                     class == 'c' ? export_list[i].info.size :
				    export_list[i].value,
		     class, 
                     &str_table[export_list[i].name]);

	if (fp = trace_sym_files [FS_TRACE_RESOLVES])
	    fprintf (fp, format, export_list[i].value, class, 
                     &str_table[export_list[i].name]);
    }
}

