/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  External Definitions for Library manipulation routines
 *
 */

#ifndef __LINKER_LIBRARIES_H
#define __LINKER_LIBRARIES_H

#include "som/aouthdr.h"

extern int             lib_area_max;
extern char            *lib_area;
extern int             som_area_max;
extern char            *som_area;
extern int             som_str_area_max;
extern char            *som_str_area;

/*
** Long file name support in archives.  External declaration for the 
** long name table.
*/
extern char            *cur_ntbl;

#define IN_MEMORY (-1)	/* for misc->data_file_offset, when not on file */
#define DLT_UNWIND_SLOT	(building_shlib ? 1 : 0) 
	/* DLT has a reserved slot for unwind info only in shlibs */
#define EMPTY     (-1)      /* empty buckets in shlib export hash tables */

extern int *out_DLT_list;  /* allocated DLT in memory */

#define BAD_SHLIB_MODULE 	-1

extern int loader_fixup_size;       /* from fixups.c */

/* LIBC_COMPAT */
extern void shlib_internal_name_add(); /* add internal name to library list */

extern int shlib_info_subsp_index;  /* $SHLIB_INFO$ subspace index */
extern int DLT_subsp_index;   	    /* $DLT$ subspace index */
extern int PLT_subsp_index;  	    /* $PLT$ subspace index */
extern int SHLIB_DATA_subsp_index;  /* $SHLIB_DATA$ subspace index */
#ifdef TSD /* TSD */
extern int TBSS_subsp_index;	    /* $TBSS$ subspace index */
#endif /* TSD */

extern struct shlib_list_entry *out_shlib_list;	/* ptr to output shlib list */
extern int next_shlib_list_indx;/* index of next entry in output shlib list */

extern struct export_entry *out_export_list;	/* ptr to output export list */

/* index of next entry in output export list */
extern int next_export_list_indx;

extern int *out_explist_subsp;		/* ptr to export list subspace */

extern struct export_entry_ext *out_export_ext; /* export list extension */

extern struct import_entry *out_import_list;	/* ptr to output import list */

/* index of next entry in output import list */
extern int next_import_list_indx;

extern char *out_shlstr_table;   	/* ptr to output string table */

/* index of next output string table entry */
extern int next_shlstr_table_indx; 

/* index of lt-pointer (unwind) entry in DLT */
extern int ltptr_DLT_entry_index; 

extern int PLT_entry_count, DLT_entry_count;  /* table sizes in items */
extern int export_entry_count, import_entry_count;  /* table sizes in items */

extern struct PLT_entry *out_PLT_list;  /* allocated PLT in memory */

extern int out_hash_tbl[];   /* export hash table in memory */
extern unsigned int out_hash_tbl_len; /* actual length (in elements) */

/* globals for accumulating Linkage Table entries in other modules */

extern int local_data_sym_count; /* count of local data syms for import tbl */
extern struct symnode *data_locals_list; /* linked list for later processing */

extern struct symnode *minimum_export_list;
	/* 
	** minimum export list for shared library export tables.             
	** If we are building an incomplete a.out without -E, this list will 
	** consist of shlib unsats resolved to a.out sym to be exported      
	*/

/* dreloc records copied from shlibs into a.out */
extern int DR_PROPAGATE_count; 

/* module misc record that is in parallel to module record */
struct module_misc {
    int start_subsp_indx;	/* starting subsp index for this module */
    int end_subsp_indx;		/* ending   subsp index for this module */
    int dreloc_list_index;	/* current index into the module dreloc 
				   list for this module */
    int symbols;	        /* # number of symbols for this module  */
};

struct c_plabel {
    int sym_index;	/* index of symbol that was ref. through code plabel */
    int dlt_index;	/* dlt index of code plabel import entry             */
};

/* structure holding code plabel information */
extern struct c_plabel *code_plab_DLT_entry_list;

/* number of symbols seen in R_CODE_PLABEL fixups */
extern int code_plab_DLT_entry_count;        

extern int PLT_index_of_sym();
extern int shlib_module_count;
extern struct module_entry *shlib_module;
extern struct module_misc  *shlib_module_misc;

/* offset off SHLIB_INFO for module impts */
extern int module_import_offset;  

/* table that holds drelocs for each module */
extern int *module_dreloc_buffer; 

/* # of entries in module dreloc table */
extern int module_dreloc_count;   

/* offset off SHLIB_INFO for module drelocs */
extern int module_dreloc_offset;  

extern Boolean	lib_search();
extern void	shlib_search();
extern void 	build_shlib_subspace();
extern void 	build_DLT_subspace();
extern void 	build_PLT_subspace();
extern void	allocate_export_list();
extern void 	allocate_PLT();
extern void 	save_orig_sym_for_exp_stub();
extern int	shlib_match();
extern int 	shlib_string_add();
extern int	hash_tbl_size();

#  define DLT_ENTRY  int

extern void add_shared_global_multiple_slot (int sym, int value);
extern int get_sym_multiple_slot (int sym, 
				  int value,
				  int inst_order, 
				  int import_index);

extern void resolve_shlib_storage_requests (void);

extern void emit_shared_drelocs (void);

/******************************** Function Prototypes ***********************/

extern FILE *open_dash_l_dep(char *cur_shlib_name, char **new_shlib_path_p);

extern void clear_shlib_seen_lately(void);
extern void free_uniq_shlib_info(void);

extern void resolve_unsats_with_exports (Boolean during_pass1,
				         char *shlib_name,
				         int filedesc,
				         char *text_addr,
				         struct som_exec_auxhdr *aux);

#ifdef TSD /* TSD */
extern void create_tsd_export(int size, char* name);
#endif /* TSD */

#endif /* __LINKER_LIBRARIES_H */
