/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Main Program
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/linker.c,v 1.2 1999/10/18 22:29:44 pschwan Exp $
 */

#include "linuxutil.h"

#include <stdio.h>
#include <errno.h>
#include <ar.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>

/* CPU_PA_RISC* --pschwan@thepuffingroup.com */
#include "sys/magic.h"
#define _INCLUDE_HPUX_SOURCE
#include "sys/unistd.h"
#undef _INCLUDE_HPUX_SOURCE

#ifndef DEBUG
#define NDEBUG
#endif  /* !DEBUG */

#include <assert.h>

#include "aouthdr.h"
#include "filehdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "compunit.h"
#include "reloc.h"
#include "syms.h"
#include "shl.h"

#include "std.h"
#include "ldlimits.h"
#include "allocate.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "ldnls.h"
#include "libraries.h"
#include "linker.h"
#include "output.h"
#include "spaces.h"
#include "ld_strings.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "elf_detector.h"

#ifdef WW_ANNOTATIONS
#include "annotate.h"
#endif /* WW_ANNOTATIONS */

#ifdef ESOM
#include "cnx_aout.h"
#endif /* ESOM */

#include "debug_opt.h"

#ifdef CNX_TOOLS
#include "cnx_link_info.h"
#endif

/* doom support */
#include "ld_linkmap.h"

#define OLD_SPECMAGIC	0401	/* for compatibility */
#define OLD_VERSION_ID	85042212

#define PCX_U_SYSTEM_ID 0x214   /* XXX- temporary for testing. Should be   */
				/* XXX- deleted and use the one in sys hdr */
/* MPE Filecodes */

#define	NMOBJ	1461
#define NMRL	1033
#define NMPRG	1030

#define READ_PERM	"r"

/* Globals */

char     	*base_file_name = NULL;
char		*cur_name = NULL;
char		*f_name = NULL;
char		*module_name = NULL;
char     	*cur_file_name = NULL;
int		cur_fildes = 0;
int             cur_ofs = 0;
unsigned int	som_index_this_file = 0;  /* how many SOMs preceeded this
					     one in the current file? */
int             aux_area_count = 0;
int             aux_area_size = 0;
int             compiler_dict_total = 0;
struct		header cur_header = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
				     0,0,0,0,0,0,0,0,0,0,0,0,0};
struct		header_node *aux_header_head = NULL, *aux_header_tail = NULL;
struct		header_node *compiler_head = NULL, *compiler_tail = NULL;
int             dynamic_load_subsp_count = 0;
int             fru_subsp_count = 0;
extern Boolean  posix_passed; /* POSIX */
extern Boolean  generate_tools_spaces;
struct 		stat out_file_stat;

int             module_seq_num = 0;

static int    fdp_branch_string_names_subsp_index;

int             shlib_version = 0;
int             max_shlib_version = 0;
void	set_spec_sym_addr();
int elaborator_index = BAD_SYM;

#ifdef NO_MULTIPLE_INITIALIZERS
int initializer_index = BAD_SYM;
#endif /* NO_MULTIPLE_INITIALIZERS */

#ifdef TSD /* TSD */
int num_tbss;
int max_tbss;
int tls_addr = 0;
Boolean bad_tls = FALSE;
int previous_tls_addr = 0;
int prev_tls = 0;
#endif /* TSD */

#ifdef ESOM
struct cnx_option_header *opt_hdr = NULL;
#endif /* ESOM */

Boolean    isom_exist = FALSE;
char       *backend_command_fname;
static     char     *temp_compiled_fname;
static     char     *temp_compiled_dir;
           /* flag to indicate if the previous isom file name can be used. If
              FALSE, the output file name will be '/' to indicate that the
              previous file name should be used. */
static     Boolean  use_previous_isom_fname = FALSE; 
char       *get_temp_compiled_fname();
Boolean    optr_data_exists();
Boolean    read_space_to_check_isom();
void       cleanup_compiled_isom_files();
           /* flag to indicate whether the temporary compiled soms have been
              read in by the linker already. */
static     Boolean compiled_som_read_already = FALSE; 
           /* this index is used to create a unique temporary compiled name
              using the base name. Since the base name can be the same with
              a different path directory, including the som_list_index will
              guarantee that the file name will be unique. */
static     int som_list_index = 0;
#define	SPACE_HAS_IL(sp)	((sp).has_intermediate_code)

static     struct som_info_type *som_info_ptr;

int	    	last_subsp, bss_subsp, text_subsp, data_subsp;
/* Locals */

static Boolean		base_file_flag;

#ifdef ESOM
extern Boolean	 esom_no_parallel;
extern Boolean	 esom_is_parallel;
extern Boolean   esom_is_oversubscribe;
extern Boolean   esom_object;
extern int       esom_min_cpus;
extern int       esom_max_cpus;

extern Boolean	 Dflag;
extern Boolean	 Rflag;
#endif /* ESOM */

extern Boolean   smartbind_enabled;

int linker(fru_file_offset)
/* fru_file_offset is only valid if we are, in fact, doing a FRU relink */
int fru_file_offset;
{
    extern void initialize();
    extern void initialize_after_driver();
    extern void collect_soms();
    FILE   *f;
    struct tms pstart, pstop;
    long clk_tck;
    clock_t rstart,rstop;

    /* initialize(); */
    /* inits based on user input */
    initialize_after_driver();

    out_file_stat.st_dev = -1;  /* Set relevant fields to initial value */
    out_file_stat.st_ino = -1;
    /* Open HP-UX output SOM to see if it's busy, give early error. */
    if (((f = fopen(output_name, "r+")) == NULL) && (errno != ENOENT))
	system_error(CANT_OP_OUTP_FL, output_name , 0);
    else if (f != NULL) {
	/* It exists, so get its inode and device to
	   compare against input files. */
	stat(output_name,&out_file_stat);
	fclose(f); /* will reopen in output.c for real. */
    }

    if (verbose & V_TIMES)
	clk_tck=sysconf(_SC_CLK_TCK);
    TIME_START(rstart,pstart);

    collect_soms(fru_file_offset);

    TIME_STOP(rstart,
	      rstop,
	      pstart,
	      pstop,
	      ld_gets(1, 1127, "Collect_soms:"),
	      clk_tck);

    /* if isom_exist, we do not want to print the warnings twice. The
     * pre-link (stop after symbol resolution when isom_exist) phase will
     * suppress the warning. */
    if (dup_symbols > 0 && !isom_exist) {
	warning_n(DUP_SYMBOLS, dup_symbols);
	bad_obj = TRUE;
    }

#ifdef TSD /* TSD */
    if (bad_tls) {
       longjmp(drive, 1);
    }
#endif /* TSD */
   
    /* Stop the link at this point (pre-link) if any of the following is true:
     *    - isoms exist in any of the object file.
     *    - user wants a list of soms that are pulled in for the link only
     *      (-Fs option).
     *    - user wants a list of unsats only (-Fu option).
     */
     if (isom_exist ||
       trace_syms_only ||
       list_unsats_only)
       return 0;

    TIME_START(rstart,pstart);

#ifdef CNX_TOOLS
    if (CNX_SUBSPACE_MAP_subsp_index != BAD_SUBSP)
       cnx_subspace_map_create();
    if (CNX_COMPILE_MAP_subsp_index != BAD_SUBSP)
       cnx_compile_map_create();
#endif /* CNX_TOOLS */

    relocate_subspaces();

    TIME_STOP(rstart,
	      rstop,
	      pstart,
	      pstop,
	      ld_gets(1, 1128, "Relocate_subspaces:"),
	      clk_tck);
    TIME_START(rstart,pstart);

    if ((keep_aout) || (!bad_obj)) 
      build_output_som();

    TIME_STOP(rstart,
	      rstop,
	      pstart,
	      pstop,
	      ld_gets(1, 1129, "Build_output_som:"),
	      clk_tck);

    if (!relocatable && !bad_obj)
	chmod(output_name, output_mode);
    if (ld_after_be_process && !keep_compiled_isoms)
        cleanup_compiled_isom_files();

    if (verbose & V_STATS)
        print_total_sizes();
    if (!bad_obj)
	return (0);
    else
	return (1);
} /* linker */

void initialize()
{
    extern void free_aux_headers();
    extern void free_compunits();

    strings_initialize();
    sym_initialize();
    spaces_initialize();
    subsp_initialize();
}


/* HP-UX shared libraries */
/*
** put base name of the shared library being built into the string table 
** done here so that we can be sure the shlib name occurs first in the
** string table, for scrt0.o to use as a database lookup key in the flow.data 
*/
static void add_shlib_name()
{
	char *basename;
	int shlib_name_index;

	assert (building_shlib);

	/* 
	** Add internal name to the library list 
        ** after we add the string to the string table if there is an 
        ** internal name to add.
        */
	if (shlib_internal_name != NULL) {
            shlib_name_index = shlib_string_add (shlib_internal_name);
            shlib_internal_name_add (shlib_name_index);
	} else {
	    if (MB_CUR_MAX == 1)
	        basename = strrchr(output_name, '/');  /* get base name */
    	    else
	        basename = mb_strrchr(output_name, '/');  /* get base name */
	    if (basename == NULL)
	        basename = output_name;
	    else
	        basename++;  /* skip over '/' */
	    shlib_name_index = shlib_string_add (basename); 
 	    /* if it is first, it will be index zero */
	    assert (shlib_name_index == 0);
	}
}

void initialize_after_driver()
{
    extern void add_undef_list_to_unsat_table();
    extern void add_entry_name();
    extern void subspace_init_after_driver();

    extern void free_aux_headers();
    extern void free_compunits();

    bad_obj = FALSE;
    bad_fixups = FALSE;
    aux_area_count = 0;
    aux_area_size = 0;
    compiler_dict_total = 0;
    new_som_header.system_id = 0;
    /* strings_initialize();
    sym_initialize(); */
    fixups_initialize();
    /* spaces_initialize();
    subsp_initialize(); */
    stubs_initialize();
    
    add_undef_list_to_unsat_table();
    add_entry_name();
    if (building_shlib)
       add_shlib_name();
    subspace_init_after_driver();
}

/* HP-UX shared libraries, only used when making incomp exec */
void add_predef_sym(name, subsp_ind, symbol_type, symbol_value, warn_redef)
char *name;          /* symbol string to be added */
int subsp_ind;       /* index of subspace symbol is to be added in */
int symbol_type;     /* type of symbol to add */
int symbol_value;    /* initial symbol value  */
Boolean warn_redef;  /* should we issue a warning if the user redefines sym? */

   /* add symbol for a predefined universal symbol */
   /* depends on univ_add to no-op if already present and "warn_redef" FALSE */

{
    int sym_ind;  /* new symbol's index */
    int hash_val = hash_string(name);  /* hash value for string */

    assert(subsp_ind != BAD_SUBSP);
    sym_ind = univ_find(name, 0, NULL, hash_val, symbol_type);

    if (sym_ind == BAD_SYM) {
    	sym_ind = symbol_allocate(subsp_ind);
	Subsp_Misc(subsp_ind).symbol_count++;
    	Sym_Type(sym_ind) = symbol_type;
      	Sym_Scope(sym_ind) = SS_UNIVERSAL;
    	Sym_Value(sym_ind) = symbol_value;
    	Sym_Dict(sym_ind).NAME_PT = add_string(&sym_strings, name, hash_val, 
					       FALSE, TRUE);
        sym_ind = univ_add(name, 0, NULL, hash_val, sym_ind, symbol_type);
    } else if (warn_redef) { 	/* warn if user redefines */
	dup_sym_add(name, NULL, BAD_SYM, sym_ind);
	return;
    }

    if (symbol_type == ST_ABSOLUTE) {
        unsat_resolve(name, 0, NULL, hash_val, sym_ind, ST_DATA, NULL);
        unsat_resolve(name, 0, NULL, hash_val, sym_ind, ST_CODE, NULL);
    }
    unsat_resolve(name, 0, NULL, hash_val, sym_ind, symbol_type, NULL);

}  /* END add_predef_sym */

unsigned int special_syms_added = 0;  /* To record if syms were added */

/*
**	spec_sym_found.  Returns TRUE (symbol found) if either:
**	   a) Univ found for it; or
**	   b) Stor Unsat found for it.
*/

static Boolean spec_sym_found (char *name)
{
    int hash_val = hash_string (name);
    int sym_ind;

    if (univ_find (name, 0, NULL, hash_val, ST_DATA) != BAD_SYM)
	return TRUE;

    sym_ind = unsat_find (name, 0, hash_val, ST_DATA);
    if (sym_ind == BAD_SYM)
	return FALSE;

    if (Sym_Type (sym_ind) == ST_STORAGE && Sym_Scope (sym_ind) == SS_UNSAT)
	return TRUE;

    return FALSE;
}

void add_predef_syms()
{
    /* add symbols for all predefined symbols */

    if (absolute_list) {   /* list of absolute symbols */
 	char **list, *symbol, *val_ptr; 	
	int value;
 
	/* format is "symbol=number" */
	list = absolute_list;
	while ( (val_ptr = symbol = *list++) != NULL ) { 
	    while (*val_ptr && *val_ptr != '=') 
		++val_ptr;
	    if (*val_ptr) 
		*val_ptr++ = '\0';
	    if (sscanf(val_ptr, "%x", &value) != 1) {
		warning(BAD_NUM_ARG, "-Fas", 0);
		usage();
	    }	
	    add_predef_sym(symbol, data_subsp, ST_ABSOLUTE, value, FALSE);
        }

	efree(absolute_list);
    }

    if (building_incomp_exec) {
		/*  We can't add these symbols
		** unconditionally; we can't override user syms */
	if (! spec_sym_found ("etext")) {
	    add_predef_sym("etext", text_subsp, ST_DATA, 0, FALSE);
	    special_syms_added |= S_S_ETEXT;
	}
	if (! spec_sym_found ("edata")) {
            add_predef_sym("edata", data_subsp, ST_DATA, 0, FALSE);
	    special_syms_added |= S_S_EDATA;
	}
	if (! spec_sym_found ("end")) {
            add_predef_sym("end", last_subsp,  ST_DATA, 0, FALSE);
	    special_syms_added |= S_S_END;
	}
		/* These symbols are in our namespace: they're fair game */
        add_predef_sym("_etext", text_subsp, ST_DATA, 0, TRUE);
        add_predef_sym("_edata", data_subsp, ST_DATA, 0, TRUE);
        add_predef_sym("_end",   last_subsp,  ST_DATA, 0, TRUE);
    }

    if (base_file_name != NULL && base_file_name != cur_file_name) { /* ld -A */
	int sym_ind;

	/* try to ensure that the proper SYSTEM_ID is placed in the dynamic
	   module, even though the loader will not check it. */
	sym_ind = univ_find(SYSTEM_ID, 
			    0, 
			    0, 
		            hash_string(SYSTEM_ID), 
			    ST_ABSOLUTE); 

        if (sym_ind == BAD_SYM) {
            add_predef_sym(SYSTEM_ID, 
			   data_subsp, 
			   ST_ABSOLUTE, 
		           new_som_header.system_id, 
			   TRUE);
	} else {
	    Sym_Value(sym_ind) = new_som_header.system_id;
        }
    } else if (!building_shlib &&		/* not building shlib */ 
             !relocatable    && 	        /* not -r */
	     !(relinkable && base_file_name == cur_file_name) /* not FRU */ ) {
        add_predef_sym(SYSTEM_ID, 
		       data_subsp, 
		       ST_ABSOLUTE, 
		       new_som_header.system_id, 
		       TRUE);
        add_predef_sym(FP_STATUS, 
		       data_subsp, 
		       ST_ABSOLUTE, 
		       fp_status, 
		       FALSE);
    }
}  /* END add_predef_syms */

void set_elaborator()
{ 
    extern char *elaborator_name;
    extern char *initializer_name;
    int e_index, i_index;

    e_index = unsat_find(elaborator_name, 
			 NULL, 
			 hash_string(elaborator_name),
			 ST_CODE);
    if(e_index == BAD_SYM) 
        e_index = univ_find(elaborator_name, 0, NULL, 
                            hash_string(elaborator_name), ST_CODE);
    if(e_index != BAD_SYM)
        elaborator_index = Sym_Misc(e_index).shlib_import_indx;
#ifdef NO_MULTIPLE_INITIALIZERS
    if(initializer_name != NULL) {
        i_index = unsat_find(initializer_name, 
			     NULL, 
                             hash_string(initializer_name),
                             ST_CODE);
        if(i_index != BAD_SYM)
            initializer_index = Sym_Misc(i_index).shlib_import_indx;
        }
#endif /* NO_MULTIPLE_INITIALIZERS */
}

int change_sort_keys()
{
    /* change the sort keys for the $DLT$ and $PLT$ based on the value
       of $GLOBAL$ for and incomplete a.out. This is needed since dp
       is used as a kind of ltptr in an incomplete a.out and we must place
       the $DLT$ and $PLT$ next to dp. 
       The $PLT$ must be close to dp to handle long branches from 
       switch tables in PIC code that go through the PLT 
    */
    int GLOBAL_subsp_index;
    int DATA_subsp_index;

    GLOBAL_subsp_index = find_subspace_by_name("$GLOBAL$");

    if (GLOBAL_subsp_index != BAD_SUBSP) {
	assert(DLT_subsp_index != BAD_SUBSP);
	assert(PLT_subsp_index != BAD_SUBSP);
    	Subsp_Dict(DLT_subsp_index).sort_key = 
	    Subsp_Dict(GLOBAL_subsp_index).sort_key -1;
    	Subsp_Dict(PLT_subsp_index).sort_key = 
	    Subsp_Dict(GLOBAL_subsp_index).sort_key -2;
    }

    DATA_subsp_index = find_subspace_by_name("$DATA$");

    if (DATA_subsp_index != BAD_SUBSP) {
	assert(SHLIB_DATA_subsp_index != BAD_SUBSP);

	Subsp_Dict(SHLIB_DATA_subsp_index).sort_key =
		Subsp_Dict(DATA_subsp_index).sort_key;
    }
} /* change_sort_keys */

static void build_predefined_subspaces()
{
    int data_start_subsp;

    if (!relocatable && 
	!(base_file_name != NULL && base_file_name != cur_file_name) &&
						/* not ld -A */
	!(base_file_name == cur_file_name && relinkable)) {  /* not FRU */
	/* build predefined subspaces */
        if(building_shlib) {
	    if (suppress_unwind) {
	    	unwind_subsp = unwind_end_subsp =
			       recover_subsp =
			       recover_end_subsp = BAD_SUBSP;
	    } else {
	    	unwind_subsp = build_subspace("$UNWIND_START$", 
					      "$TEXT$", 
					      TEXT_SORTKEY, 
					      0x2c, 
					      CODE_QUADRANT, 
					      56, 
					      8, 
					      0, 
					      0);
	    	unwind_end_subsp = build_subspace("$UNWIND_END$", 
						  "$TEXT$", 
						  TEXT_SORTKEY, 
						  0x2c, 
						  CODE_QUADRANT, 
						  72, 
						  8, 
						  0, 
						  0);
	    	recover_subsp = build_subspace("$RECOVER_START$", 
					       "$TEXT$", 
					       TEXT_SORTKEY, 
					       0x2c, 
					       CODE_QUADRANT, 
					       73, 
					       4, 
					       0, 
					       0);
	    	recover_end_subsp = build_subspace("$RECOVER_END$", 
						   "$TEXT$", 
						   TEXT_SORTKEY, 
						   0x2c, 
						   CODE_QUADRANT, 
						   88, 
						   4, 
						   0, 
						   0);
	    }
	    /* Since crt0.o is not used when building a shared library,    */ 
	    /* it is up to the compiler to supply the linker with the      */
	    /* BSS subspace. So far, both C++ and Fortan have failed to    */
	    /* do this resulting in BSS being expanded in the file.        */
	    /* Here we generate a BSS subspace to avoid future problems    */
	    build_subspace("$BSS$", "$PRIVATE$", PRIVATE_SORTKEY, 0x1f,
		           DATA_QUADRANT, SORT_BSS, 8, 0, 0);

	}
#ifdef ESOM
	else {
	    /* Predefined the ESOM subspaces so that they are on page	   */
	    /* boundaries.						   */
	    build_subspace("$SEMA_DATA$", 
			   "$PRIVATE$", 
			   PRIVATE_SORTKEY, 
			   0x1f,
		           DATA_QUADRANT,
			   1,
			   4096,
			   0,
			   0);
	    build_subspace("$NPDATA$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   2,
			   4096,
			   0,
			   0);
	    build_subspace("$NSDATA$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   3,
			   4096,
			   0,
			   0);
	    build_subspace("$FSDATA$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   4,
			   4096,
			   0,
			   0);
	    build_subspace("$ESOM_DATA_END$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
			   DATA_QUADRANT,
			   6,
			   4096,
			   0,
			   0);
	    build_subspace("$SEMA_BSS$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   91,
			   4096,
			   0,
			   0);
	    build_subspace("$NPBSS$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   92,
			   4096,
			   0,
			   0);
	    build_subspace("$NSBSS$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   93,
			   4096,
			   0,
			   0);
	    build_subspace("$FSBSS$",
			   "$PRIVATE$",
			   PRIVATE_SORTKEY,
			   0x1f,
		           DATA_QUADRANT,
			   94,
			   4096,
			   0,
			   0);
	    }
#endif /* ESOM */
  
    	/* build subspace to hold DLT (data linkage table) */
        DLT_subsp_index = build_subspace("$DLT$",
			   	    	 "$PRIVATE$", PRIVATE_SORTKEY,
			   	    	 0x1f,
			   	    	 DATA_QUADRANT,
					 SORT_DLT, 
					 8, 0, 0); 

    	/* build subspace to hold PLT, (procedure linkage table)      */
	/* must be created after DLT when building a shared library.  */
        PLT_subsp_index = build_subspace("$PLT$",
			   	    	 "$PRIVATE$", PRIVATE_SORTKEY,
			   	    	 0x1f,
			   	    	 DATA_QUADRANT,
					 SORT_PLT,
					 8, 0, 0); 

    	/* build subspace to hold SHLIB_DATA, data copied from shared 
	   library */
        SHLIB_DATA_subsp_index = build_subspace("$SHLIB_DATA$",
			   	    	 "$PRIVATE$", PRIVATE_SORTKEY,
			   	    	 0x1f,
			   	    	 DATA_QUADRANT,
					 SORT_WITH_EXEC_DATA, 
					 8, 0, 0); 

	/* build for all non-partial links. Contains the dl 	  	 */
	/* (dynamic loader) header and may be needed for standalone PIC. */
	shlib_info_subsp_index = build_subspace("$SHLIB_INFO$", 
			   			"$TEXT$", TEXT_SORTKEY, 
			   			0x2c, 
			   			CODE_QUADRANT, 
			   			SORT_FIRST, 
						8, 0, 0);

        if(!building_shlib) {
    	    add_predef_sym("__text_start", 
			   shlib_info_subsp_index, 
			   ST_DATA, 
			   0, 
			   FALSE);
    	    /* since "__text_start" goes at beginning of subsp instead of end 
	      like other predef syms, finish filling it in now. */
    	    set_spec_sym_addr("__text_start", shlib_info_subsp_index);

	    /* Define value of absolute symbol "___stack_zero", which
	       crt0.o will be changed to use as the value of the number of
	       bytes to pop the stack by so that user programs with
	       uninitialized variables in the main (and possibly the low
	       stack frames) will be left zeroed.  The original value for
	       8.0 was 64K.  This is done to reduce the swap area used for
	       processes using shared libraries.  */
    	    add_predef_sym("___stack_zero", 
			   shlib_info_subsp_index, 
			   ST_ABSOLUTE, 
			   clean_stack_size, 
			   FALSE);

    	    /* build subspace to hold PLT, (procedure linkage table)      */
	    /* must be created after DLT when building a shared library.  */
            data_start_subsp = build_subspace("$DATA_START$",
			   	    	 "$PRIVATE$", PRIVATE_SORTKEY,
			   	    	 0x1f,
			   	    	 DATA_QUADRANT,
			   	    	 SORT_FIRST, 8, 0, 0); 

    	    add_predef_sym("__data_start", data_start_subsp, ST_DATA, 0, 
			   FALSE);
    	    /* since "__data_start" goes at beginning of subsp instead of end 
	      like other predef syms, finish filling it in now. */
    	    set_spec_sym_addr("__data_start", data_start_subsp);


         }
#ifdef CNX_TOOLS 
   if (generate_tools_spaces) 
      cnx_build_link_info_subspaces();
#endif /* CNX_TOOLS */  
      }
} /* END build_predefined_subspaces */

static void build_fdp_subspace ()
{
  int fdp_branch_string_names_end_subsp_index;

  fdp_branch_string_names_subsp_index = build_subspace("$FDP_BRANCH_STRINGS$",
                                         "$PRIVATE$", PRIVATE_SORTKEY,
                                         0x1f,
                                         DATA_QUADRANT,
                                         SORT_WITH_EXEC_DATA,
                                         8, 0, 0);
  
  /* Need a symbol to access the beginning of the subspace */
  add_predef_sym(branch_name_string, fdp_branch_string_names_subsp_index,
        ST_DATA, 0, FALSE);

  set_spec_sym_addr(branch_name_string, fdp_branch_string_names_subsp_index);

  /* This subspace will go immediately after $FDP_BRANCH_STRINGS$ in order
   * to calculate the size of the strings from the users a.out.
   *   eg. SIZE = branch_name_string_end - branch_name_string
   */
  fdp_branch_string_names_end_subsp_index = build_subspace
                                               ("$FDP_BRANCH_STRINGS_END$",
                                         "$PRIVATE$", PRIVATE_SORTKEY,
                                         0x1f,
                                         DATA_QUADRANT,
                                         SORT_WITH_EXEC_DATA,
                                         8, 0, 0);

  /* Need a symbol to access the beginning of the subspace */
  add_predef_sym(branch_name_string_end, 
                 fdp_branch_string_names_end_subsp_index,
                 ST_DATA, 
		 0, 
		 FALSE);

  set_spec_sym_addr(branch_name_string_end,
                    fdp_branch_string_names_end_subsp_index);

}

void collect_soms(fru_file_offset)
/* fru_file_offset is only valid if we are, in fact, doing a FRU relink */
int fru_file_offset;
{
    FILE *f;
    int fildes;
    int	    i, old_index;
    int	    som_offset;
    Boolean som_added = FALSE, tmp_bool;
    /* cmdline_pass : 0 -> Read in all objects
		    : 1 -> Read in archives and shlibs with unsats
		    : >=2 -> Read in archives and shlibs without unsats */
    int cmdline_pass = 0;
    struct stat stat_buf;
    Boolean dash_l_reference;	/* shlib referenced by -l? */
#ifdef NO_MULTIPLE_INITIALIZERS
    extern char *initializer_name;
#endif /* NO_MULTIPLE_INITIALIZERS */
    struct space_dictionary_record *space;
    struct space_misc_record *sp_misc;
    struct subspace_dictionary_record *subsp;
    struct ar_hdr ar_hdr;

#ifdef ESOM
    int first, is_edata = 0;
#endif /* ESOM */

    /* make sure that som_list_ptr is initialized before 
       going to som_add() */
    som_info_ptr = som_info;

    dynamic_load_subsp_count = 0;
    fru_subsp_count = 0;

    /* get the temporary directory to read the temp compiled soms file */
    if (ld_after_be_process) {
        if ((temp_compiled_dir = getenv ("TMPDIR")) == NULL)
            temp_compiled_dir = DEFAULT_TEMP_DIR;
    }

    if (base_file_name != NULL) {
	base_file_flag = TRUE; /* must declare base_file_flag */
	cur_file_name = base_file_name;
	cur_name = base_file_name;
        f = efopen (cur_name, READ_PERM, CANT_OPEN);

        if (! stat(base_file_name,&stat_buf)) { /*Make sure stat succeeds*/
            if ((stat_buf.st_dev == out_file_stat.st_dev) &&
                (stat_buf.st_ino == out_file_stat.st_ino)) {
                user_error(SAME_FILE_INPUT_OUTPUT,cur_name,0);
            }
        }
	fildes = fileno(f);
	cur_fildes = fildes;
        if (relinkable)
    	    cur_ofs = fru_file_offset;
        else
            cur_ofs = 0;
	som_add();
	fclose(f);
        if (relinkable) {
            /* FRU RELINK */
            fru_subsp_count = next_subsp_index_bias;
        } else {
            /* dynamic loading */
            dynamic_load_subsp_count = next_subsp_index_bias;
        }
	base_file_flag = FALSE;
    }
    build_predefined_subspaces();  /* create linker-created subspaces/spaces */

    /* If we are instrumenting code for fdp build this subspace for strings */
    if (do_fdp_measure && !relocatable) {
       build_fdp_subspace();
    }

    do {
      som_added = FALSE;
      while (cur_file_name = som_info_ptr->som) {
	  som_offset = som_info_ptr->offset;
	  cur_name = cur_file_name;
	  f_name = cur_file_name;
	  module_name = NULL;
          dash_l_reference = (som_info_ptr->flags & IS_DASH_L_REF) ? TRUE : 
	                      FALSE;	/* -l opt used? */
	  /* After the first pass only process archive and shared libraries */
          if (cmdline_pass > 0 && !(som_info_ptr->flags & IS_LIBRARY)) {
	      goto SKIP_FILE;
          }
          compiled_som_read_already = FALSE;
          /* isom_exist  - TRUE if an isom file found during symbol resolution.
             ld_after_be_process - TRUE if the link is after the backend
                      is invoked for the isoms and now do the actual link. */

          if (isom_exist) {
              /* get the file name for the compiled soms */
              temp_compiled_fname = get_temp_compiled_fname(cur_file_name,
							    FALSE);
              use_previous_isom_fname = FALSE;
          } else {
              /*
              ** If a second pass or more is made over the libraries list
              ** then the compiled ISOM's have already been read in the first
	      ** pass.  So, if we are making multiple passes over the
              ** libraries then dont force load the compiled ISOM's again.
              */
              if (cmdline_pass == 0 && ld_after_be_process) {
                  temp_compiled_fname = 
                      get_temp_compiled_fname(cur_file_name,TRUE);
                      /* check if temporary compiled soms exists */
                      if ((f = fopen(temp_compiled_fname,"r")) != NULL)
                          read_compiled_soms(f);
		      else {
			 ANALYZE_LARGE_FILE_ERROR(temp_compiled_fname);
		      }
              }
          }
          f = efopen(cur_file_name,"r", CANT_OPEN);
          if (! stat(cur_file_name,&stat_buf)) { /*Make sure stat succeeds*/
              if ((stat_buf.st_dev == out_file_stat.st_dev) &&
                  (stat_buf.st_ino == out_file_stat.st_ino)) {
                  user_error(SAME_FILE_INPUT_OUTPUT,cur_name,0);
              }
          }
          fildes = fileno(f);

	  /* If som_offset is non-negative, link only som_count */
	  /* SOM's starting at that offset in the file */

           /* Currently, we do not support PBO and IPO on MPE platforms.
              Since som_offset and som_count are set to less than 0 on HPUX
              platforms, this part of code will not be executed for
              HPUX. If we were to support PBO and IPO on MPE platforms, we
              will have to examine the following code for multiple soms in
              one file. */

	  if (som_offset >= 0) {
	      cur_fildes = fildes;
	      cur_ofs = som_offset;
	      repeat {
		  som_add();
		  cur_ofs += cur_header.som_length;
	      }
              until (--som_count <= 0);
	      goto SKIP_FILE;
	  }
	  /* ... Otherwise, look for an archive header */
	  ffetch(fildes, 0, (void *) &cur_header, SARMAG, 1);

	  cur_fildes = fildes;

	  if (strncmp((char *)&cur_header, ARMAG, SARMAG) == 0) { /* Archive */
	      som_info_ptr->flags |= IS_LIBRARY;
	      /* If +n, pass 0 is for obj files only,
		 unless FORCE_LOAD is used. */
	      if (no_local_search && (cmdline_pass == 0) && 
		  (som_offset != FORCE_LOAD) &&
		  (som_offset != FORCE_LOAD_WITH_FEQ)) {
		      goto SKIP_FILE;
	      }

	      /* Don't scan FORCE_LOAD libs after pass 0 */
	      if ((cmdline_pass > 0) && 
		  ((som_offset == FORCE_LOAD) ||
		   (som_offset == FORCE_LOAD_WITH_FEQ))) {
		       goto SKIP_FILE;
	      }

	      ffetch(fildes, -1, (void *) &ar_hdr, sizeof(ar_hdr), 1);

	      /*
	      ** Verify that the first member is the special symbol table
	      ** member and not the long member name table member.
	      */
    	      if (ar_hdr.ar_name[0] != '/' && ar_hdr.ar_name[1] != ' ') {
		  external_error(NO_SYM_TABLE, cur_name, 0);
    	      }
	      cur_ofs = SARMAG + sizeof(ar_hdr);
	      tmp_bool = lib_search(&ar_hdr, som_offset,
				    som_info_ptr->flags & LINEAR,
				    som_info_ptr->flags & NOLOOP);
	      som_added |= tmp_bool;
	      /* since we just looked at an archive library, it is possible
		 that new unsats have been introduced.  Therefore, if a shared
		 library is referenced in the future, we must search it, even
		 if we've seen it before.  Therefore, we clear the list of
		 shared libraries already searched. -  */
	      /* 
	      ** Well, we only really need to do this if we actually dragged
	      ** in a module from the archive, which we know from lib_search.
	      */
	      if (tmp_bool)
		  clear_shlib_seen_lately();
          } else if (cur_header.a_magic == SHL_MAGIC) { /* Shared Library */
	      som_info_ptr->flags |= IS_LIBRARY;

              /* If +n, pass 0 is for obj files only. */
              if (no_local_search && (cmdline_pass == 0)) {
		      goto SKIP_FILE;
              }

	      /*
	      **
	      ** If -noshared, cannot use shared libraries.
	      */
              if (!allow_link_with_shlibs) {
		  external_error(SAW_SHLIB_IN_NOSHARED, cur_name , 0);

		  goto SKIP_FILE;
              }

	      /*above assumes first "SARMAG" bytes of record has magic number*/
	      if (relocatable) {
		  warning(RELOC_WITH_SHLIB, cur_name, 0);
		  goto SKIP_FILE;
	      }
	      if (!building_shlib) {
		  /* If -b is not seen and a shlib is on the command line then 
		     we are building an incomplete executable. */
		  building_incomp_exec = TRUE;
                  if ((base_file_name != NULL) && (!relinkable))
                     /* -A base_file_name doesn't work with shared
                        libraries.  Issue an error */
                     user_error(ILLEGAL_SHLIB_REF_DASH_A, cur_name, 0);
		  gen_ldr_fixups = FALSE;
		  alloc_stubs_ux = TRUE;
		  extern_plabels = TRUE;
	      }
	      /* read rest of header record */
	      ffetch(fildes, -1,
		       ((char *)&cur_header)+SARMAG, /*address of rest of hdr*/
		       sizeof(cur_header)-SARMAG, 1);   /* size of rest of hdr */

	      cur_ofs = sizeof(cur_header);
              shlib_search(dash_l_reference,
			   cur_name,
			   fildes,
			   &cur_header,
	                   /* Always set to TRUE if not no_local_search.
		              If no_local_search, then set to TRUE the first
		              time we process library files,
			      i.e., cmdline_pass == 1 */
			   ((cmdline_pass==1 || !no_local_search)?TRUE:FALSE),
			   TRUE);  /* do full sym resolution */
	  } else {	/* Presumably, a Relocatable file */
	      cur_ofs = 0;
	      som_file_add();
	      /* since we just looked at a relocatable file, it is possible
		 that new unsats have been introduced.  Therefore, if a shared
		 library is referenced in the future, we must search it, even
		 if we've seen it before.  Therefore, we clear the list of
		 shared libraries already searched.  */
	      clear_shlib_seen_lately();
          }

    SKIP_FILE:
	  fclose(f);
          som_list_index++;  
	  som_info_ptr++;
    }
      cmdline_pass++;
      som_info_ptr = som_info;	/* Reset som_list_ptr for next pass */
      som_list_index = 0;	/* Reset som_list_index for next pass */
      /* 
      ** Never repeat if no_local_search is FALSE
      ** If it is TRUE, repeat only if som_added is true
      ** Also, if no_local_search, always force a second pass to search
      ** libraries, which are skipped on the first pass. 
      ** since we are about to reiterate the command line (+n option)
      ** there must still be unsats.  Therefore, if a shared
      ** library is referenced in the future, we must search it, even
      ** if we've seen it before.  Therefore, we clear the list of
      ** shared libraries already searched.  
      */
      clear_shlib_seen_lately();
    }
    while ((som_added && no_local_search) || 
	   (no_local_search && (cmdline_pass == 1)));

    /*
    ** We are done searching files, so we don't need this around anymore
    */
    free_uniq_shlib_info();

    /*
    ** Clean up any memory allocated for the long name table.
    */
    if (cur_ntbl != NULL) {
        efree(cur_ntbl);
        cur_ntbl = NULL;
    }

    if (lib_area != NULL) {
        efree(lib_area);  /* clean up libraries temp area */
	lib_area = NULL;  /* reset so linker is reentrant */
    }

    if (som_area != NULL) {
        efree(som_area);  /* clean up SOM temp area */
	som_area = NULL;  /* reset so linker is reentrant */
    }

    if (som_str_area != NULL) {
        efree(som_str_area);  /* clean up SOM temp area */
	som_str_area = NULL;  /* reset so linker is reentrant */
    }

    /* clean up buffers used to read in strings */ 
    if (sym_str_buffer.block_ptr != NULL) {
        efree(sym_str_buffer.block_ptr);
        sym_str_buffer.block_ptr = NULL;
        sym_str_buffer.size      = 0;
    }
    purge_string_table_hash(&sym_strings);

    if (space_str_buffer.block_ptr != NULL) {
        efree(space_str_buffer.block_ptr);
        space_str_buffer.block_ptr = NULL;
        space_str_buffer.size      = 0;
    }
    purge_string_table_hash(&space_strings);

    free_name_pair_list();
	
    input_symbols_bias = sym_dict_size;  /* bias of last symbol read 
					    from all input */
    /* if we aren't building a shared lib and we have a DLT subpspace,  */ 
    /* we need to move it next to $global$ 				*/
    if (!building_shlib && DLT_subsp_index != BAD_SUBSP)
	change_sort_keys();

    /* if we have not determined the system id for the output file
       we have not read any input files - this is a NULL link. 
       Exit now to avoid problems down stream. 
    */
    if (!new_som_header.system_id) 
	longjmp(drive, 1);

    subprog_elim();

    if (command_file_seen) {
    	/* This is time consuming but accurate : BSS doesn't have to be the
	   last subspace seen in an embedded systems link */
    	bss_subsp = find_subspace_by_name("$BSS$");
    } else {
	bss_subsp = BAD_SUBSP;
    }

    /*
    ** Now that all of the SOM's have been seen, look to see if the 
    ** $DEBUG$ space exists.  If it doesn't then disallow the 
    ** linker from building line tables to debug optimized code.
    ** If it does exist then build the $LINES$ subspace before the
    ** subspaces are sorted. 
    */
    doc_init_pass1();

/*  No longer generate PA annotations.
 * do_ww_annotation is always FALSE.
 */
#ifdef WW_ANNOTATIONS_REMOVED
    if (do_ww_annotations)
      init_annotations();
#endif /* WW_ANNOTATIONS */

    /* doom support */
    lm_linkmap_build_subspaces();

    subspaces_sort();

    if (!relocatable || force_common) {
#ifdef ESOM
	int last_bss;
#endif /* ESOM */
	Boolean bss_subsp_seen = FALSE;

        /* need these to support etext, edata, end, etc. on UX */
        text_subsp = BAD_SUBSP;
        data_subsp = BAD_SUBSP;
        last_subsp = BAD_SUBSP;
	TBSS_subsp_index = BAD_SUBSP;	/* reset before setting the value */
        for (i = 0; i < subsp_dict_size; i++) {
    	    old_index = Subsp_Misc(i).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    space = &space_array[subsp->space_index];
	    sp_misc = &space_misc[subsp->space_index];

	    /* not concerned with unloadable spaces */
	    if (!space->is_loadable && !sp_misc->embed_unloadable)
	        continue;

	    /* deleted comdat sections are not eligible for consideration */
	    if (subsp->is_comdat && Subsp_Misc(old_index).comdat_nulled) 
	        continue;

	    /* remember last text subspace (loadable, not private) */
	    /* we'll set "etext" to point to its end */
	    if (!space->is_private) { 
		    /* Look for last subsp over all non private space... */
		    /* && (code_mmap_addr == 
			  space_misc[subsp->space_index].start_virt_addr)) */
		text_subsp = old_index;
	    }
	    /* 
	    ** remember last init. data subspace (loadable, private) 
	    ** we'll set "edata" to point to its end 
	    **  Do not include $TSPECIFIC$ in "edata"
            **
            ** Allow 0 subsp_len and 0 init_len subspaces if we haven't yet
            ** seen a subspace with 0 init_len and non-0 subsp_len, i.e., a
            ** BSS subspace.  This assumes that we won't grow any BSS
            ** subspaces in the mid-pass, like we grow the unwind, DLT
            ** and some other subspaces. 
	    */
	    if (space->is_private && 
#ifdef TSD /* TSD */
		/* 
		**  Don't do for $TSPECIFIC$.  
		*/
		!space->is_tspecific &&
#endif /* TSD */
                  (subsp->initialization_length != 0     ||
                   (subsp->initialization_length == 0 &&
                    subsp->subspace_length       == 0 &&
                    ! bss_subsp_seen) ||
                   data_subsp == BAD_SUBSP) )
		data_subsp = old_index;

#ifdef TSD /* TSD */
	    /* save off $TBSS$ index, length */
	    if (subsp->is_tspecific) {
	       /* only set for first $TBSS$ we find */
	       if (TBSS_subsp_index == BAD_SUBSP) {
	          TBSS_subsp_index = old_index;
	       }
	    }
#endif /* TSD */

	    /* 
	    ** remember last loadable, private subspace and set "end" to 
	    ** point to its end 
	    */
#ifdef TSD /* TSD */
	    /*   Do not include $TSPECIFIC$ in "end" */
	    if (space->is_private && !space->is_tspecific) {
#else
	    if (space->is_private) {
#endif /* TSD */
                if (subsp->initialization_length == 0 &&
                    subsp->subspace_length != 0 &&
                    subsp->fixup_request_quantity == 0) {
                    /* We have seen a non-zero len bss subspace, so remember
                       this for our check for data_subsp above.  Must check
                       that fixup_request_quantity == 0 since a BSS subsp
                       can't have fixups, yet a valid $DATA$ subspace with zero
                       init_len, non-zero subsp_len, and some R_ZEROES fixups
                       can exist.
                        */
                    bss_subsp_seen = TRUE;
		}

		last_subsp = old_index;
#ifdef ESOM
		if (strcmp("$BSS$", subsp->name.n_name) == 0)
		    last_bss = old_index;

		/*
		 * if the subspace is a esom subspace, the first one must have
		 * it alignment changed to be on a page boundary. Also the
		 * first non esom subspace after the esom data subspaces must
		 * be aligned on a page boundary.
		 */
		if ( subsp->subspace_length != 0 ) {
		    if (is_esom_subsp(subsp->name.n_name, &first, &is_edata)) {
			if ( first )
		    	    subsp->alignment = 4096;
		    }
		    else {
			if ( is_edata )
			    subsp->alignment = 4096;
			is_edata = 0;
		    }
		}
#endif /* ESOM */
	    }
	}  /* end for */

#ifndef ESOM
	if (bss_subsp == BAD_SUBSP) 
	    bss_subsp = last_subsp;
#else
	if (bss_subsp == BAD_SUBSP) 
	    bss_subsp = last_bss;
#endif /* ESOM */

        resolve_secondary_syms();

	add_predef_syms();

#ifndef NO_MULTIPLE_INITIALIZERS
        if(building_shlib && initializer_list)
#else
        if(building_shlib && initializer_name != NULL)
#endif /* !NO_MULTIPLE_INITIALIZERS */
        {
           int index;
#ifndef NO_MULTIPLE_INITIALIZERS
           char *initializer_name;
	   char **list = initializer_list;
           while ((initializer_name = *list++) != NULL) {
#endif /* !NO_MULTIPLE_INITIALIZERS */

           unsigned int hashval = hash_string(initializer_name);
           if ((index = univ_find(initializer_name, 
				  0, 
				  NULL, 
				  hashval, 
				  ST_CODE)) 
                    != BAD_SYM) {
               unsat_add(initializer_name, 
			 0, 
			 NULL, 
			 hashval, 
			 index,
			 ST_CODE,
			 0, 
			 0);
           } else {
    	       index = symbol_allocate(text_subsp);
    	       Sym_Type(index) = ST_CODE;
    	       Sym_Scope(index) = SS_UNSAT;
    	       Sym_Value(index) = text_subsp;
    	       Sym_Dict(index).NAME_PT = add_string(&sym_strings, 
						    initializer_name, 
						    hashval, 
						    FALSE, 
						    TRUE);
               unsat_add(initializer_name,
			 FALSE,
			 NULL,
			 hashval,
			 index,
			 ST_CODE,
			 0, 
			 0);
           }
#ifndef NO_MULTIPLE_INITIALIZERS
           } 
#endif /* !NO_MULTIPLE_INITIALIZERS */
        }

	if (building_incomp_exec || building_shlib) { /* shared libaries */
		/*   Before we build any shared
		** lib tables, we need to process the saved shared lib
		** exports in the shlib_exports_hash_table[] */

	    resolve_unsats_with_exports (FALSE, NULL, 0, NULL, NULL);

	    select_shlib_exports();

#ifdef TSD /* TSD */
	    shlib_build_tables(bss_subsp, TBSS_subsp_index);
#else
	    shlib_build_tables(bss_subsp);
#endif /* TSD */
        }

#ifdef TSD /* TSD */
        storage_create(bss_subsp, TBSS_subsp_index);

	/* 
	**  align tbss_size on a 8 byte boundary. 
	** Set __tdsize to size of TSD, __tpoff to 0
	*/
	tbss_size = round(tbss_size, 8);
	/* if two subspaces are supported, tpoff is tbss_size / 2 */
        if (!building_shlib) {
            int tsd_ind;
            tsd_ind = univ_find("__tdsize",
				FALSE,
				NULL,
				hash_string("__tdsize"),
				ST_ABSOLUTE);

	    if (tsd_ind == BAD_SYM)
	        add_predef_sym("__tdsize",
			       data_subsp, 
			       ST_ABSOLUTE,
			       tbss_size, 
			       TRUE);
            else
	        Sym_Value(tsd_ind) = tbss_size;

#if defined (DEBUG) && defined (TSD) /* DEBUG and TSD */
	    if (verbose & V_TSD)
               printf("Final TSD size is %d\n", tbss_size);
#endif /* DEBUG and TSD */
        } /* !building_shlib */
#else
        storage_create(bss_subsp);

#endif /* TSD */	

	if (building_incomp_exec) {
	    /* 
	    ** set addr for special symbols (after last storage allocated) 
	    **  Only set the address if
	    ** the special symbol was added above in add_predef_syms() 
	    */
	    if (special_syms_added & S_S_ETEXT)
            	set_spec_sym_addr("etext", text_subsp);
	    if (special_syms_added & S_S_EDATA)
            	set_spec_sym_addr("edata", data_subsp);
	    if (special_syms_added & S_S_END)
            	set_spec_sym_addr("end", last_subsp);

            set_spec_sym_addr("_etext", text_subsp);
            set_spec_sym_addr("_edata", data_subsp);
            set_spec_sym_addr("_end", last_subsp);
	}    
	
	if (!building_incomp_exec && !building_shlib) {
            unsat_resolve_special("etext", text_subsp);
            unsat_resolve_special("edata", data_subsp);
            unsat_resolve_special("end", last_subsp);
            unsat_resolve_special("_etext", text_subsp);
            unsat_resolve_special("_edata", data_subsp);
            unsat_resolve_special("_end", last_subsp);
	}
    } else {     /* !relocatable || force_common */
        resolve_secondary_syms();

	/* doom support */
	lm_process_stor_unsats();
    }
 
    hide_symbols();
    forget_unsats();

    if (relocatable)
	return;

    if (dont_allow_unsats && unsat_print_list()) {
        /*
        **  Remove #ifdef PBO for the -Fu, -Fs code since
        ** we can use this in a non PBO environment.
        */
        unsat_found = TRUE;
	bad_obj = TRUE;
    }

    /*   Code to disable smartbind for C++ shared 
     *                          library builds.
     */

    if (!smartbind_enabled) {
        add_singleton_module_rec(subsp_dict_size, sym_dict_size);
    }

}  /* end collect_soms */

/* HP-UX shared libraries */
void set_spec_sym_addr(sym_name, subsp_index)
char *sym_name;
int subsp_index;
{
    /* set addr for special symbols (after last storage allocated) */

    struct symbol_dictionary_record *sym; 
    int sym_index;  /* symbol table index */

    int hashval = hash_string(sym_name);  /* hash key */

    sym_index = univ_find(sym_name, 0, NULL, hashval, ST_DATA);

    if (sym_index == BAD_SYM) { /* If it doesn't exist, just return */
        return;
    }
    sym = &Sym_Dict(sym_index);
    sym->symbol_type = ST_DATA;
    sym->symbol_scope = SS_UNIVERSAL;
    sym->q_nptr = NULL;  /* is checked in "count_symbols" */
    sym->symbol_value = Subsp_Dict(subsp_index).subspace_start +
			Subsp_Dict(subsp_index).subspace_length;
} /* end set_spec_sym_addr */

extern fatal_ffetch;
void som_file_add()
{
    for (som_index_this_file=0;;som_index_this_file++) {
	som_add();
	cur_ofs += cur_header.som_length;

	fatal_ffetch = FALSE;
	if (ffetch(cur_fildes, cur_ofs, (void *) &cur_header, 
		   sizeof(cur_header), 1) == -1)
            break;

	/* MPE XL files may be padded with nulls! */
    	if (cur_header.system_id == 0 && cur_header.a_magic == 0)
	    break;
    }
    som_index_this_file=0; /* restore to default state */
} /* end som_file_add */

void som_add()
{
    int i;
    int prev_sym_bias;
    int dlversion;
    Boolean obj_is_isom = FALSE;
    char *som_name, *lib_name;
    struct som_exec_auxhdr exec_hdr;
    extern void aux_area_read();
    extern void comp_unit_read();
#ifdef TSD
    Boolean multi_dash_r = FALSE;
#endif /* TSD */

    /* increment the module sequence number - will uniquely identify
       this module */

    ++module_seq_num;
    
    if (verbose & V_WHY)
	info_message(VERBOSE_LOADING, cur_name, 0);
    else if (trace_som || (verbose & V_BIGSTATS))
	printf ("%s:\n",cur_name);
    /*
    **  Remove #ifdef PBO for the -Fu, -Fs code since 
    ** we can use this in a non PBO environment.
    */
    if (trace_sym_files [FS_TRACE_ALL])
        fprintf (trace_sym_files [FS_TRACE_ALL], "%s\n", cur_name);

    ffetch (cur_fildes, cur_ofs, &cur_header, sizeof(cur_header), 1);
    if (!_PA_RISC_ID(cur_header.system_id)) {
	int elf_type = elfd_get_elf_object_type(cur_fildes);

	if (elf_type == ELFD_OBJECT_PARISC_HPUX_64BIT) {
	    external_error (PA64_OBJECT_FILE_32BIT_LINK, cur_name , 0);
	} else if (elf_type == ELFD_SHLIB_PARISC_HPUX_64BIT) {
	    external_error (PA64_SHLIB_FILE_32BIT_LINK, cur_name , 0);
	} else {
	    external_error (BAD_SYS_ID, cur_name , 0);
	}
    }
    
    /*
     * Check for pcx-U PA2.0 system_id. If any of the input SOM
     * is compiled with PA2.0 pcx-U then the linker will use the
     * new instructions for stubs.
     *
     *  Also, output a warning message if a PA 2.0
     * or later file is found. Emit this even if V_DETAIL_CHANGE_WARN
     * bit is not set.
     */
    if (!pcx_u_pa2_0) {
	if (cur_header.system_id >= PCX_U_SYSTEM_ID) {
	    pcx_u_pa2_0 = TRUE;

#ifdef OBS_FEATURES_WARN

            if (verbose & V_CHANGE_WARN)
               if (!relocatable)
                  warning(PA2_0_OUTPUT_WARNING, cur_name, 0);

#endif

        }
    }

    new_som_header.system_id = max(new_som_header.system_id,
				   cur_header.system_id);

    if ((!base_file_flag &&
#ifndef ESOM
         cur_header.a_magic != RELOC_MAGIC &&
#else
	 !(cur_header.a_magic == RELOC_MAGIC ||
	   cur_header.a_magic == CNX_RELOC_MAGIC) &&
#endif /* ESOM */
    	 cur_header.a_magic != OLD_SPECMAGIC) ||
	(base_file_flag &&
	 cur_header.a_magic != EXEC_MAGIC &&
	 cur_header.a_magic != DEMAND_MAGIC &&
#ifdef ESOM
	 cur_header.a_magic != CNX_EXEC_MAGIC &&
	 cur_header.a_magic != CNX_DEMAND_MAGIC &&
	 cur_header.a_magic != CNX_SHARE_MAGIC &&
#endif /* ESOM */
	 cur_header.a_magic != SHARE_MAGIC)) {
	external_error(BAD_MAGIC_NUM, cur_name , 0);
    }
    if (base_file_flag && !relinkable) {
        ffetch(cur_fildes,cur_header.aux_header_location,
               (char *) &exec_hdr,sizeof(exec_hdr),1);
        ffetch(cur_fildes,exec_hdr.exec_tfile,(char *) &dlversion,
               sizeof(dlversion),1);
	/*
	** We used to assume exec_tfile always pointed to first word of
	** SHLIB_INFO, but that may not be true since the "unpad a.out"
	** enhancement. We now have a bit in exec_flags to tell us if a
	** program is linked shared. Note that there is never a case where
	** dlversion == DL_HDR_VERSION_ID2 && !(exec_hdr.exec_flags & 0x4).
	*/
        if (exec_hdr.exec_flags & 0x4 ||
	    dlversion == DL_HDR_VERSION_ID) {
          user_error(BASE_FILE_IS_DYN_LINKED,cur_name,0);
        }
    }
    if (cur_header.version_id != VERSION_ID &&
    	cur_header.version_id != OLD_VERSION_ID &&
        cur_header.version_id != NEW_VERSION_ID) {
	external_error(BAD_SOM_VERS, cur_name , 0);
    }
    if (cur_header.checksum != checksum(&cur_header,sizeof(cur_header))) {
	external_error(BAD_HDR_CHKSM_IN, cur_name , 0);
    }
    if (verbose & V_BIGSTATS) {
	printf(ld_gets(1, 1131, "- %d space records\n"),
	       cur_header.space_total);
	printf(ld_gets(1, 1132, "- %d subspace records\n"),
	       cur_header.subspace_total);
	printf(ld_gets(1, 1133, "- %d symbol records\n"),
	       cur_header.symbol_total);
	printf(ld_gets(1, 1134, "- %d fixup records\n"),
	       cur_header.fixup_request_total);
	printf(ld_gets(1, 1135, "- %d symbol string bytes\n"),
			cur_header.symbol_strings_size);
	printf(ld_gets(1, 1136, "- %d space string bytes\n"),
			cur_header.space_strings_size);
    }

    prev_sym_bias = sym_dict_size;

    if (ld_after_be_process) {
        /* Return here if the new compiled som for this isom have been read
           already. */ 
        if (compiled_som_read_already &&
            read_space_to_check_isom(cur_ofs)) {
           return;
        }
    }


    /* read in strings, subspaces, symbols, fixups from file */
    strings_read(cur_header.space_strings_location + cur_ofs,
		 cur_header.space_strings_size, 
		 &space_str_buffer, 
		 &space_strings);
    strings_read(cur_header.symbol_strings_location + cur_ofs,
		 cur_header.symbol_strings_size, 
		 &sym_str_buffer,
		 &sym_strings);

    subspaces_read(cur_header.subspace_location + cur_ofs,
		   cur_header.subspace_total);

    symbols_read(cur_header.symbol_location + cur_ofs,
		 cur_header.symbol_total);

    /* doom support - must be called after cur_subsp_index_bias is updated */
    lm_som_add();

    /* spaces_add must be done before translating OLD format files */
    /* add / or merge space records */
    spaces_add(cur_header.space_location + cur_ofs, cur_header.space_total);


    /* check if any intermediate code exists in the SOM file. If it exists,
     * set isom_exist to true and set up the backend process file.  
     * When isom_exist is set to true, the linker will just perform
     * symbol resolution to get a list of som names that contain 
     * intermediate code for the backend to perform code generation and
     * optimization. This is called the pre-link phase. After the backend
     * process is returned, then a full link will be performed. 
     */

    if (!base_file_flag) {     /* not a dynamic executable module */
	int     j;

	for ( j = 0; j < cur_header.space_total; j++ ) {
	   if ( SPACE_HAS_IL( space_array[ sp_remap[ j ] ] )) {
	      obj_is_isom = TRUE;
	      break;
	   }
	}
    }
   
    if (obj_is_isom) {	/* intermediate code exists in som */

        if (verbose & V_PBO) 
	    printf(ld_gets(1, 1137, "file is isom %s\n"), cur_name );

	/* if linking after compilation of ISOMs, no ISOMs should remain. */
	if (ld_after_be_process)
	    internal_error(ISOM_AFTER_COMPILE,cur_name,0);

        /* to compile soms that have intermediate code           */
        if (!isom_exist) {
            /* set global flag, isom_exist, to invoke backend        */
            /* to compile soms that have intermediate code           */
            isom_exist = TRUE;
            setup_be_file(TRUE);   /* set up and open the backend cmd file*/
            temp_compiled_fname = get_temp_compiled_fname(cur_file_name,
                                                          FALSE);
        }
        if (!(som_info_ptr->flags & IS_LIBRARY)) {
            /* A concatenated som or single som file.                   */
            if ((som_name = (MB_CUR_MAX == 1) 
			   ? strrchr(cur_name,'/') 
			   : mb_strrchr(cur_name,'/')) != NULL) 
               som_name++;                  /* skip over '/' */ 
            else
               som_name = cur_name;         /* directory not specified in file
                                               name */
            if (!use_previous_isom_fname) {
                fprintf(backend_command_file,"%s %s %d %s\n",cur_name,"/",
                    cur_ofs, temp_compiled_fname);
                use_previous_isom_fname = TRUE;
            } else
                fprintf(backend_command_file,
			"%s %s %d %s\n",
			"/",
			"/",
			cur_ofs, 
			"/");
        } else {
            /* An archive library file:                            */
            /* cur_name is in this format: lib_name(som_name)      */
	    if (MB_CUR_MAX == 1) {
		lib_name = strtok(cur_name,"(");
		som_name = strtok(NULL,")");
	    } else {
		lib_name = mb_strtok(cur_name,"(");
		som_name = mb_strtok(NULL,")");
	    }
            if (!use_previous_isom_fname) {
                fprintf(backend_command_file,"%s %s %d %s\n",lib_name,
                    som_name, cur_ofs, temp_compiled_fname);
                use_previous_isom_fname = TRUE;
                }
            else 
                fprintf(backend_command_file,"%s %s %d %s\n","/",
                    som_name, cur_ofs, "/");
            }
        }                   /* intermediate code exists in som */
/*
**  Remove #ifdef PBO for the -Fu, -Fs code since
** we can use this in a non PBO environment.
*/
    /* Avoid reading in the fixups and compilation unit if the linker just */
    /* perform symbol resolution (pre-link).                               */
    if (!isom_exist &&        /* need to invoke backend to compile isoms */
        !list_unsats_only &&     /* link stop after symbol resolution */
        !trace_syms_only ) {     /* link stop after symbol resolution */

    if (!base_file_flag || relinkable) {
	if (cur_header.version_id == NEW_VERSION_ID) {
	    fixups_read(cur_header.fixup_request_location + cur_ofs,
			cur_header.fixup_request_total);
        } else {
	    old_fixups_read(cur_header.fixup_request_location + cur_ofs,
			    cur_header.fixup_request_total);
        }

	cur_header.fixup_request_location = fixup_area_first;
	/* don't bother to update cur_header.fixup_request_total */

        /*
	** read in compilation unit records 
	** skip compilation unit records in first file (crt0)          
	** for HPE only. For HPUX we will include crt0 com_unit        
        ** Also not if we are relocatable or doing a FRU relink, or    
	** strip_symbols specified.                                    
        */ 

	if (cur_header.compiler_total) {
	    if (relocatable ||
                 !strip_symbols || 
                 base_file_name != NULL )
		comp_unit_read(cur_header.compiler_location + cur_ofs,
				cur_header.compiler_total);
        }

	/* read in all aux headers, if any exist */
	ld_footprint_seen = FALSE;
	shlib_version = 0; /* assume 0 unless SHLIB_VERSION aux record seen */
	if (cur_header.aux_header_size)
	    aux_area_read(cur_header.aux_header_location + cur_ofs,
			cur_header.aux_header_size);
    }

    /* if FRU RELINK, then read in the existing loader fixups */
    if (base_file_flag && relinkable && cur_header.loader_fixup_total != 0) {
        loader_fixup_index = loader_fixup_size = cur_header.loader_fixup_total;
        create_loader_fixups();
        ffetch(cur_fildes,
               cur_header.loader_fixup_location + cur_ofs,
               loader_fixup_array,
               sizeof(*loader_fixup_array),
               loader_fixup_size);
    }

    } /* !trace_syms */
    /* now process the spaces, subspaces, symbols, and fixups */

#ifdef TSD /* TSD */
      /* Add the TBSS size to the total.  Save the previous tbss size */

      prev_tls = previous_tls_addr = round(tbss_size, 8);

      for (i = 0; i < cur_header.subspace_total; i++) {
         subspace_add(cur_subsp_index_bias + i);
         if (Subsp_Dict(cur_subsp_index_bias + i).is_tspecific) {
	    if (relocatable && 
               (Subsp_Dict(cur_subsp_index_bias + i).code_only)) {
 	       /* -r of a -r'd file */
	       multi_dash_r = TRUE;
	    }
	    /* 
            ** TBSS that only contains TLS commons has length of 0.  Don't 
            ** bump up tls_addr in this case.
            */
	    if (Subspace_Length(cur_subsp_index_bias + i) > 0) {
               /*
               **  Round tbss_size so first item in SOM is aligned
               **               Using 8 should satisfy current alignment
               **               requirements. This might be 16 later.
	       **               Save previous tls_addr.  For -r link and 
	       **               subsequent link with it later, we need to be
               **               able to set the tls offset correctly, which
               **               we can't do simply by calculating the new
               **               "total" tls addr here.  Set tls_addr to
	       **               tbss_size after rounding.  Bump tls_addr
	       **               if this subspace was -r'd in a previous link.
               */
#if defined (DEBUG) && defined (TSD) 
	       if (verbose & V_TSD) {
	          printf("tbss_size: %d tls_addr: %d prev: %d\n", 
			 tbss_size,
		         tls_addr, 
			 previous_tls_addr);
	       }
#endif /* TSD */
 	       tbss_size = round(tbss_size, 8);
	       tls_addr = tbss_size;

	       /* doom support */
               if (!lm_should_skip_subspace(cur_subsp_index_bias+i)) {
	          lm_bss_subspace_add(cur_subsp_index_bias+i, tls_addr);
               }

               tbss_size += Subspace_Length(cur_subsp_index_bias + i);
               if (Subsp_Dict(cur_subsp_index_bias + i).code_only && 
		   (!relocatable || (relocatable && multi_dash_r))) {
		   /* this subspace is from a -r'd file */
		   tls_addr = round(tbss_size, 8);
	       }

	    } /* TBSS subspace length > 0 */
         } else  if (Subsp_Misc(cur_subsp_index_bias + i).is_bss_subspace) {
            if (Subspace_Length(cur_subsp_index_bias + i) > 0) {

               /* doom support */
               if (!lm_should_skip_subspace(cur_subsp_index_bias+i)) {
	          lm_bss_subspace_add(cur_subsp_index_bias+i, -1);
               }
            } 
         }
      }
#else
      for (i = 0; i < cur_header.subspace_total; i++) 
         subspace_add(cur_subsp_index_bias + i);
#endif /* TSD */

    /* doom support */
    lm_linkmap_read();

    /* symbols_add must come after adding subspaces, since we may */
    /* build export stubs in the appropriate subspace             */
    symbols_add(cur_sym_index_bias,cur_header.symbol_total);

/*
** Remove #ifdef PBO for the -Fu, -Fs code since
** we can use this in a non PBO environment.
*/
    if (trace_syms_only)
        print_syms_in_som (cur_sym_index_bias, cur_header.symbol_total);

    if (building_shlib && smartbind_enabled)
        add_module_rec(prev_sym_bias);
} /* som_add */


/* aux_area_read() assumes that all aux headers from input file */
/* should be copied to the output file */
/* This does a copy in place which is why when skipping auxheaders we */
/* are careful not to overlap regions */

void aux_area_read(fil_ofs, size)
unsigned int fil_ofs, size;
{
#ifdef ESOM
#   define PREAMBLE     "CONVEX Version Info: "
#   define PREAMBLELEN  strlen(PREAMBLE)
    struct user_string_aux_hdr *vers_str;
    static int got_cnx_vers = FALSE;
#endif /* ESOM */
    struct header_node *usr;
    struct aux_id *aux_header;
    struct shlib_version_aux_hdr *shlib_vers_hdr;
    struct product_specific_aux_hdr *product_aux_hdr;
    int i, k;
    char *dest;
    char *buffer_end;
    int skip;
    int bytes_left;
    int skipped_hdr_len = 0;
    int cur_hdr_len;

    bytes_left = size;
    usr = (struct header_node *) emalloc(sizeof(struct header_node) + size);

    /* read in aux headers just past allocated header node */
    ffetch(cur_fildes, fil_ofs, usr+1, 1, size);

    aux_header = (struct aux_id *) (usr+1);
    dest = (char *) (usr+1); 			/* destination pointer */
    buffer_end = ((char *) (usr +1)) + size; 

    while (((char *) (aux_header+1)) <= buffer_end ) {
	/* while room for another aux_header */
	skip = FALSE;
	switch(aux_header->type) {
	case MPE_SOM_AUX_ID:
	    	if (base_file_flag && relinkable) 
		    skip = TRUE;
		break;
        case SHLIB_VERSION_AUX_ID:
		/*  Only use the shlib version header
		** if we're building a shared library.  And always skip
		** unless were doing an ld -r */
		if (building_shlib) {
		    shlib_vers_hdr = (struct shlib_version_aux_hdr *) 
				     (aux_header);
		    shlib_version = shlib_vers_hdr->version;
		    max_shlib_version = max(max_shlib_version, shlib_version);

#ifdef OBS_FEATURES_WARN

                    /*
                    ** If a version number other than zero is
                    ** detected, intra-library versioning has been
                    ** used.  Emit a warning if "verbose" says to.
                    */

                    if (verbose & V_CHANGE_WARN)
		       if (shlib_version != 0) {

		          found_change_warn = TRUE;

		          if (verbose & V_DETAIL_CHANGE_WARN) {
                             warning(INTRA_LIB_VERSION_NUKED, cur_name, 0);
			  }
		       }
#endif

		}
		if (!relocatable)
		    skip = TRUE;
		break;
#ifdef ESOM
	case VERSION_AUX_ID:
		/*
		 * Skip over all of the Convex MPP Vers records but the first
		 * one. The rest are not needed and just take up space.
		 */
		vers_str = (struct user_string_aux_hdr *) aux_header;
		if (strncmp(vers_str->user_string, 
			    PREAMBLE, PREAMBLELEN) == 0) {
		    if ( got_cnx_vers )
			skip = TRUE;
		    else
			got_cnx_vers = TRUE;
		}
		break;
	case CNX_OPTION_HDR:
		/*
		 * process ESOM option headers for MPP
		 */
		skip = TRUE;
		if ( opt_hdr == NULL ) {
		    opt_hdr = 
			(struct cnx_option_header *)emalloc(sizeof(*opt_hdr));
		    (void) memcpy(opt_hdr, aux_header, sizeof(*opt_hdr));
		}
		else {
		    struct cnx_option_header *newopt;

		    newopt = (struct cnx_option_header *) aux_header;
		    set_min_max(opt_hdr, newopt);
		    opt_hdr->flags |= newopt->flags;
		}

		if ( opt_hdr->flags & CNX_OPT_PARALLEL && !esom_no_parallel ) {
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    if ( !Rflag )
		    	code_offset = 0x1000;
		    if ( !Dflag ) {
		    	data_offset = -1;
		    	data_on_page_after_text = TRUE;
		    }
		    
		    if ( magic_number == EXEC_MAGIC )
			magic_number = CNX_EXEC_MAGIC;
		    else if ( magic_number == SHARE_MAGIC )
			magic_number = CNX_SHARE_MAGIC;
		    
		}
		break;
#endif /* ESOM */
        case LINKER_AUX_ID:
		ld_footprint_seen = TRUE;
		break;
	case PRODUCT_SPECIFIC_AUX_ID:
		product_aux_hdr = (struct product_specific_aux_hdr *) 
				  (aux_header);
		if (product_aux_hdr->header_id.length > product_key_size) {
		    if (product_key_size == 0) {
			product_key = (unsigned int *) emalloc 
				      (product_aux_hdr->header_id.length);
		    } else {
		        product_key = (unsigned int *) erealloc 
				      ((char *) product_key, 
				       product_aux_hdr->header_id.length);
	   	    }
		    for (i = product_key_size / WORDSIZE; 
			 i < product_aux_hdr->header_id.length / WORDSIZE; 
			 i++) {
			 product_key[i] = 0;
		    }
		    product_key_size = product_aux_hdr->header_id.length; 
		}
		k = min(product_key_size, 
			product_aux_hdr->header_id.length) / WORDSIZE;
		for (i = 0; i < k;  i++) {
		     product_key[i] |= product_aux_hdr->key[i];
		}
		skip = TRUE;
		break;
	default:
		break;
	}
	
	cur_hdr_len = round(aux_header->length + 
			    sizeof(struct aux_id), WORDSIZE);
	bytes_left -= cur_hdr_len;

        if (skip) {
	    size -= cur_hdr_len; 
	    skipped_hdr_len += cur_hdr_len;
	} else { 
	    if (skipped_hdr_len == 0) {
		/* if we have never skipped a hdr then dest will equal 
		   aux_header and no move is needed */
	        dest += cur_hdr_len;
	    } else {
		/* 
		   Use memmove() since source and destination regions
		   may be overlapping. */
		memmove(dest, (char *) aux_header, cur_hdr_len);
	        dest += cur_hdr_len;
	    }
	}
	aux_header = (struct aux_id *) ( ((char *)aux_header) + cur_hdr_len);
    }

    if (bytes_left != 0) 
	 warning(BAD_AUX_RECORDS, cur_name, 0);

    if (size > 0) {
    	aux_area_count++;
    	aux_area_size += size;
    	usr->next = NULL;
    	usr->size = size;
   	if (aux_header_tail != NULL)
	    aux_header_tail->next = usr;
    	else
	    aux_header_head = usr;
    	aux_header_tail = usr;
    } else {
	efree(usr);
    }
}

void comp_unit_read(fil_ofs, count)
int fil_ofs, count;
{
    int i;
    struct header_node *comp_area;
    struct compilation_unit *comp_rec;
    char *str;   /* temp string ptr */

    comp_area = (struct header_node *)
		emalloc(sizeof(struct header_node) +
				count * sizeof(struct compilation_unit));

    ffetch(cur_fildes, 
	   fil_ofs, 
	   comp_area+1,
	   sizeof(struct compilation_unit), 
	   count);

    for (i = 0; i < count; i++) {
	comp_rec = (struct compilation_unit *)(comp_area+1) + i;
	if (comp_rec->name.n_strx != 0) {
	    /* don't hash the name field since it includes the .o name  */ 
	    /* and will likely be unique                                */
	    str = comp_rec->name.n_strx + sym_str_buffer.block_ptr;
	    comp_rec->name.n_name = add_string(&sym_strings, 
					       str, 
					       0, 
					       TRUE, 
					       FALSE);
	}
	if (comp_rec->language_name.n_strx != 0) {
	    str = comp_rec->language_name.n_strx + sym_str_buffer.block_ptr;
	    comp_rec->language_name.n_name = add_string(&sym_strings, 
							str, 
					                hash_string(str), 
							TRUE, 
							TRUE);
	}
	if (comp_rec->product_id.n_strx != 0) {
	    str = comp_rec->product_id.n_strx + sym_str_buffer.block_ptr;
	    comp_rec->product_id.n_name = add_string(&sym_strings, 
						     str, 
					             hash_string(str), 
						     TRUE, 
						     TRUE);
        }
	if (comp_rec->version_id.n_strx != 0) {
	    str = comp_rec->version_id.n_strx + sym_str_buffer.block_ptr;
	    comp_rec->version_id.n_name = add_string(&sym_strings, 
						     str, 
					             hash_string(str), 
						     TRUE, 
						     TRUE);
        }
	comp_rec->chunk_flag = 0;
    }

    compiler_dict_total += count;
    comp_area->next = NULL;
    comp_area->size = count * sizeof(struct compilation_unit);

#ifdef CNX_TOOLS
    if ((CNX_COMPILE_MAP_subsp_index != BAD_SUBSP) && cur_name)
       comp_area->obj_fname = add_string(&space_strings, cur_name,
                                    hash_string(cur_name), FALSE, TRUE);
    else
       comp_area->obj_fname = 0;
#endif /* CNX_TOOLS */

    if (compiler_tail != NULL)
	compiler_tail->next = comp_area;
    else
	compiler_head = comp_area;
    compiler_tail = comp_area;

    /* doom support */
    lm_compunit_read(comp_area->size);
}

/**
 **   Invoke fastbind tool on the executable.
 **/

Boolean
invoke_fastbind()
{
   Boolean is_error = FALSE;

   if (! building_incomp_exec) {
      /* Has to be a incomplete executable to fastbind */

      warning(CANT_FASTBIND, output_name, NULL, NULL, NULL);
   }
   else {
      /* Fastbind incomplete executable */
  
      char	*p;
      char	*command_p;
  
      if ((p = getenv("ST_FASTBIND")) == NULL) {
         p = DEFAULT_FASTBIND_PATH;
      }

      command_p = emalloc(strlen(p) + strlen(output_name) + 5);

      if (is_fastbind_unresolved) {
	 (void) sprintf(command_p, "%s -u %s", p, output_name);
      }
      else {
	 (void) sprintf(command_p, "%s %s", p, output_name);
      }

      /* Execute fastbind command */

      is_error = system(command_p);
   }

   return(is_error);
}

extern void invoke_pxdb()
/* invokes pxdb if debug information is present in the output file */
{
    char *pxdb_path;
    char *exec_string;
    int space_index;
    int space_count;

    /* doom support */
    if (!lm_should_invoke_pxdb()) {
      return;
    }

#if 0
    /* no need to do this anymore, handled by the above */
    for (space_count = 0; space_count < cur_space_total; space_count++) {
        space_index = sp_remap[space_count];
        if (!space_array[space_index].is_loadable && 
            (strcmp(space_array[space_index].name.n_name, "$DEBUG$") == 0)) {
	    break;
	}
    }
#endif

    pxdb_path = getenv("LD_PXDB");
    if (!pxdb_path)
        pxdb_path = PXDB_PATH;
    if (verbose & V_WHY) 
	info_message(INVOKE_PXDB, pxdb_path, 0);
    if (access(pxdb_path, 1) != 0) {
	if ( getenv("LD_PXDB") || (verbose & V_WHY) ) {
	    /* only issue warning for user specified pxdb path, possible  */
	    /* pxdb isn't present in the default place (optional program) */
            warning(CANT_EXEC_PXDB, pxdb_path, 0);
        }
    } else {
	/* set stdout to /dev/null to shut up pxdb */
	freopen("/dev/null","w",stdout);
#ifdef PFA
	/* dump counters before the exec causes them to be lost */
	pfa_dump();
#endif /* PFA */
        if (execl(pxdb_path,pxdb_path,output_name,0))
	    /* Only reached if an error */
            warning(CANT_EXEC_PXDB, pxdb_path, 0);
    }
} /* invoke_pxdb */

void set_fdp_subspace_information(fdp_names, fdp_mem_size)
char   *fdp_names;  /* Ptr to fdp strings */
unsigned int fdp_mem_size; /* The fdp string subspace area size */

/* Set the som subspace header information */
{
    struct subsp_misc_record *misc;
    struct subspace_dictionary_record *sym;

    misc = & Subsp_Misc(fdp_branch_string_names_subsp_index);
    /* Just assign the ptr of the area malloced for the strings */
    misc->subsp_data = fdp_names;
    /* This tells a later pass that the subspace information resides
     * in memory. It will be written from misc->subsp_data.
     */
    misc->data_file_offset = IN_MEMORY;

    sym = &Subsp_Dict(fdp_branch_string_names_subsp_index);
    /* fdp_mem_size maintained in stubs.c to track the size of the strings */
    sym->subspace_length = fdp_mem_size;
    sym->initialization_length = fdp_mem_size;

} /* end set_fdp_subspace_information */

/******************************************************************************
* FUNCTION :            read_space_to_check_isom   
*
* ARGUMENTS:
*       file_ofs - the file offsets within a som file.
*
* RETURN VALUE:
*       ret_val - TRUE is the has_intermediate_code is set in the space
*                 dictionary record of any spaces. Otherwise, return FALSE. 
*
* PURPOSE:
*       This routine checks if the current som in the som file (with file_ofs
*       set to non zero if a concatenated som or an archive library) that is
*       being read contains any intermediate code.
* NOTES:
*
* ALGORITHM:
*
******************************************************************************/

Boolean read_space_to_check_isom(file_ofs)
int file_ofs;
{ 
    static struct  space_dictionary_record *temp_space_array;
    static int temp_space_size;
    int     total_spaces;    
    int     i,j;
    Boolean found_isom=FALSE;

    if (cur_header.unloadable_sp_location &&
        cur_header.unloadable_sp_size) {
         total_spaces = cur_header.space_total;
         /* 
	 ** only call emalloc if the total_spaces exceed the previous numbers
	 */
         if (total_spaces > temp_space_size) {
             if (temp_space_array != 0)
                 efree(temp_space_array);
             temp_space_array = (struct space_dictionary_record *)
                                emalloc(total_spaces *
                                sizeof(struct space_dictionary_record));
             temp_space_size = total_spaces;
         }
         ffetch(cur_fildes, cur_header.space_location + file_ofs, 
                temp_space_array, 
                sizeof (struct space_dictionary_record), 
                total_spaces);

         for ( j = 0; j < total_spaces; j++ ) {
	    if ( SPACE_HAS_IL( temp_space_array[j] ) ) {
	       found_isom = TRUE;
	       break;
	    }
	 }

         if ((verbose & V_PBO) && found_isom) 
             printf(ld_gets(1, 1138, "file is isom %s\n"), cur_name );
     } else {
         found_isom = FALSE;    /* no unloadable space found */
     }
     return (found_isom);
} /* end read_space_to_check_isom */

/******************************************************************************
* FUNCTION :            setup_be_file       
*
* ARGUMENTS:
*
* RETURN VALUE:
*                                                                         
*
* PURPOSE:
*       generate an unique file name for the backend to read a list of som
*       names (in a relocatable object or archive library) that need to be 
*       recompiled by the backend.       
*
* NOTES:
*       The backend command file is opened by this routine.
*       ========== FORMAT of the backend command file: ====================
*       The 1st line of the backend command file contains the temp directory
*       name.
*       From the second line on, the file contains information about each
*       isom in an object file:
*        <isom_fname> <som_name> <file_offset> <output_fname>   
*       
*        - isom_fname is the file name which contains an isom.
*        - som_name is the som name specified in the som directory of an 
*          archived library. If file_name is a relocatable object file 
*          (.o files), then specify som_name with a /.
*        - file offset is the file offset in the isom object file and 
*          it always referred to one som only.
*        - output_fname is the output file name that will contain the 
*          compiled object code for the isom. The file name is
*          composed by using the som_list_index, process_id and the isom
*          base file name (see get_temp_compiled_fname).
*
*        If / is specified in isom_fname or output_fname, use the same
*        name in the previous line.
*
*        example:
*        /tmp 
*        /lib/crt0.o / 0 #0999crt0.o
*        /mnt/linker/elice/c/readdata1.o / 0 #1999readdata1.o
*        /mnt/linker/elice/c/libtmp.a call_library.o 16760 #2999libtmp.a
*        /lib/libc.a _start.o 225668 #3999libc.a
*        / printf.o 772796 /
*        / scanf.o 784600 /
*        /lib/milli.a Mcerror.o 59352 #4999milli.a
*        / MdivI.o 85732 /
*        / MdivU.o 88736 /
*        / MremU.o 187632 /
*
* ALGORITHM:
*       The backend command file name is based on the process_id.
*       i.e.: if process_id = 9999 and temp_compiled_dir = /tmp
*             backend_command_fname = /tmp/_9999BE
*
******************************************************************************/
setup_be_file(open_file)
Boolean open_file;              
{
    if ((temp_compiled_dir = getenv ("TMPDIR")) == NULL)
        temp_compiled_dir = DEFAULT_TEMP_DIR;
    /* add constant 16 to emalloc to make sure the string still fits for 
       worst case (for process_id and other constant chars) */

    backend_command_fname = emalloc(strlen(temp_compiled_dir) + 16);
    process_id = emalloc(11);   /* the longest string length that could be
                                   return should be 10, add 1 for null byte. */
    strcpy (process_id, ltoa(getpid()));
    sprintf(backend_command_fname,"%s%s%s%s",temp_compiled_dir,"/_",
            process_id,"BE");
    if (open_file){
        backend_command_file = 
	    efopen( backend_command_fname, "w", CANT_OP_OUTP_FL);
        fprintf(backend_command_file,"%s \n",temp_compiled_dir); 
    }
} /* end setup_be_file */

/******************************************************************************
* FUNCTION :            get_temp_compiled_fname
*
* ARGUMENTS:
*       file_name - the name (including the directory path) specified in the
*                   som list 
*       include_temp_dir - boolean to indicate if the temp directory name 
*                          should be included in the file name.
*
* RETURN VALUE:
*       ret_val - a unique file name.
*
* PURPOSE:
*       compose a unique file name that is based on the file name specified
*       in the som list. 
*       This routine is called twice for soms that contain intermediate code:
*       1) before invoking the backend, this routine is called to compose a
*          unique name for the backend to deposit the compiled object code.
*       2) after the isoms are compiled, this routine is called for
*          each file name specified in the som list to check if the
*          compiled som file exist.
*
* NOTES:
*
* ALGORITHM:
*   The following fields are used to compose a unique file name:
*   temp_compiled_dir - temporary directory that the users specified in
*                       an env variable: TMPDIR. If not specified, /tmp is
*                       used.
*   process_id        - unique process name return by getpid
*   som_list_index    - an index to indicate the position in the som list.
*                       Since the base file name can be the same, including  
*                       this index will guarantee that the file name will
*                       be unique.                       
*   base_file_name    - the file name excluding the directory path.
*      
*   For example:   /users/foo/c_src/othello.o  <- name specified in the som list
*                                                 and this is the 5th file
*                                                 in the list.
*                       base_fname        = othello.o
*                       process_id        = 9999
*                       som_list_index    = 4
*                       temp_compiled_dir = /tmp
*               
*                       get_temp_compiled_fname = /tmp/_4_9999othello.o 
*
******************************************************************************/
char *get_temp_compiled_fname(file_name, include_temp_dir)
char *file_name;
Boolean include_temp_dir; 
{
    char *temp_compiled_fname;
    char *base_fname;        
 
    if ((base_fname = (MB_CUR_MAX == 1) 
		      ? strrchr(file_name,'/')
		      : mb_strrchr(file_name,'/')) != NULL)
        base_fname++;                  /* skip over '/' */
    else
        base_fname = file_name;        /* directory not specified in 
                                                   file name */
    /* add constant 13 to emalloc to make sure the string still fits for 
       worst case (for som_list_index and other constant chars) */

    temp_compiled_fname = emalloc(strlen(temp_compiled_dir) + 
                                  strlen(process_id) +
                                  strlen(base_fname) + 13);
    if (include_temp_dir) {
        sprintf(temp_compiled_fname,"%s%s%s%s%s%s",
                temp_compiled_dir,"/_",
                ltoa(som_list_index),
                "_",
                process_id,
                base_fname);
    } else
        sprintf(temp_compiled_fname,"%s%s%s%s%s",
                "_", ltoa(som_list_index),
                "_",
                process_id,
                base_fname);
    return(temp_compiled_fname);
} /* end get_temp_compiled_fname */

/******************************************************************************
* FUNCTION :            read_compiled_soms  
*
* ARGUMENTS:
*       f     - the file pointer for compiled som file.            
*
* RETURN VALUE:
*                                                                        
*
* PURPOSE:
*       The linker has already invoked the backend to generate compiled
*       object files from intermediate code. At this point, a temporary
*       compiled object file is opened, and this routine sets up all the
*       work to call som_file_read to read in the compiled object.
*       After som_file_read succeed, reset the file descriptors back to
*       the current file in the som list that is specified by the user.
*
* NOTES:
*       All the file descriptors and file pointers are temporary set at
*       the temporary compiled object file generated by the backend.  
*
* ALGORITHM:
*
******************************************************************************/
read_compiled_soms(f)
FILE *f;
{
    char     *save_cur_file_name;
    int      fildes; 

    /* set the file descriptor to the temporarily compiled file name. */        
    cur_fildes = fileno(f);
    save_cur_file_name = cur_file_name;
    cur_file_name = temp_compiled_fname;
    f_name     = temp_compiled_fname;
    fildes     = cur_fildes;
    if (verbose & V_PBO)
        info_message(VERBOSE_READING_ISOM, temp_compiled_fname, 0);
    cur_ofs = 0;
    som_file_add();
    fclose(f);
    som_info_ptr->flags |= IS_ISOM;

    /* reset the file back to the orginial file name in the som list. */
    cur_file_name = save_cur_file_name;
    f_name   = cur_file_name;

    /* 
    ** compiled_som_read_already is set to true if a temporarily compiled som 
    ** file exist and already read in by the linker. This flag is used to 
    ** avoid expensive checks for the som files that do not have intermediate
    ** code. 
    */ 
    compiled_som_read_already = TRUE;
} /* end read_compiled_soms */

/******************************************************************************
* FUNCTION :            cleanup_compiled_isom_files
*
* ARGUMENTS:
*
* RETURN VALUE:
*
* PURPOSE:
*       This routine goes through the som list and delete all the 
*       temporarily compiled isom files created by the backend.
*
* NOTES:
*
* ALGORITHM:
*
******************************************************************************/

void cleanup_compiled_isom_files()
{
   
    som_info_ptr = som_info;
    som_list_index = 0;

    if (som_info_ptr == NULL) {
       /*
       ** If som_info_ptr is NULL, the arguments are still being parsed and
       ** linker() has not been called yet.  As a result, removing the
       ** file returned by setup_be_file (which gets created in som_add()
       ** which happens during linker() processing) is not necessary.  As
       ** a result, we can just return
       */
       return;
    }

    while (cur_file_name = som_info_ptr->som) {
       if (verbose & V_PBO)
          printf(ld_gets(1, 
			 1139, 
			 "cleanup files, is_isom: %s %d\n"),
		 cur_file_name,
		 som_info_ptr->flags & IS_ISOM);
       if (som_info_ptr->flags & IS_ISOM) {
	  temp_compiled_fname = get_temp_compiled_fname(cur_file_name,TRUE);
	  remove (temp_compiled_fname);    
	  if (verbose & V_PBO)
	     printf(ld_gets(1, 
			    1140, 
			    "file purged: %s\n"), 
		    temp_compiled_fname);
       }
       som_info_ptr++;
       som_list_index++;
    }
    setup_be_file(FALSE); /* only get the backend command file name and do
                             not open the file */
    remove (backend_command_fname); /* purge the file */
    if (verbose & V_PBO)
        printf (ld_gets(1, 
			1141, 
			"file purged: %s\n"), 
		backend_command_fname);
} /* end cleanup_compiled_isom_files */

#ifdef ESOM

set_min_max(opt, nopt)
struct cnx_option_header *opt, *nopt;
{
    /*
     * Rules for determining min and max cpus needed for parallelism:
     *	o if not parallel ignore fields
     *	o if current is not parallel and new one is, then use new record values
     *	o if parallel, take the min of the min and the max of the max.
     */
    if ( nopt->flags & CNX_OPT_PARALLEL ) {
	if ( opt->flags & CNX_OPT_PARALLEL ) {
	    if ( opt->min_cpu == 0 ) {
		opt->min_cpu = nopt->min_cpu;
	        } else if ( nopt->min_cpu != 0 ) {
		    if ( nopt->min_cpu < opt->min_cpu )
		    	opt->min_cpu = nopt->min_cpu;
	    	    }

	    if ( opt->max_cpu == 0 ) {
		opt->max_cpu = nopt->max_cpu;
	    	} else if ( nopt->max_cpu != 0 ) {
		    if ( nopt->max_cpu > opt->max_cpu )
		    	opt->max_cpu = nopt->max_cpu;
	        }
	} else {
	    opt->min_cpu = nopt->min_cpu;
	    opt->max_cpu = nopt->max_cpu;
	}
    }
}

typedef struct {
	char *esom_name;	/* esom subspace name */
	int  is_first_idx;	/* first flag index */
	int  is_data;		/* has data flag */
} esom_subspace_t;

#define ESOM_ARRAY	11

is_esom_subsp(str, first, is_data)
char *str;
int  *first, *is_data;
{
    static esom_subspace_t array[ESOM_ARRAY] = {
	{"$SEMA_DATA$", 0, 1 },
	{"$NPDATA$", 1, 1 },
	{"$NPDATA2$", 1, 1 },
	{"$NSDATA$", 2, 1 },
	{"$NSDATA2$", 2, 1 },
	{"$FSDATA$", 3, 1 },
	{"$FSDATA2$", 3, 1 },
	{"$SEMA_BSS$", 4, 0 },
	{"$NPBSS$", 5, 0 },
	{"$NSBSS$", 6, 0 },
	{"$FSBSS$", 7, 0 }
    };

    static int is_first[ESOM_ARRAY] = { 1,1,1,1,1,1,1,1,1,1,1 };
    
    int i;
    
    for ( i = 0; i < ESOM_ARRAY; i++ ) {
	if ( strcmp(str, array[i].esom_name) == 0 ) {
	    *first = is_first[array[i].is_first_idx];
	    *is_data = array[i].is_data;
	    is_first[array[i].is_first_idx] = 0;
	    return 1;
	}
    }
    return 0;
}
#endif /* ESOM */

#ifdef SPP_UX
remove(path)
register const char *path;
{
    return unlink(path);
}
#endif /* SPP_UX */
