/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Fixup Manipulation Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/opt.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $
 */

#include <stdio.h>

#ifndef DEBUG
#define NDEBUG
#endif 
#include <assert.h>

#include "std.h"
#include "ldlimits.h"
#include "aouthdr.h"
#include "scnhdr.h"
#include "reloc.h"
#include "syms.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "libraries.h"
#include "stub_inst.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "bv_dense.h"
#include "opt.h"

Boolean in_branch_table;        /* Currently looking into a branch table? */

int last_seen_brtab_end;        /* inst offset-end of last branch table seen */

int addils_deleted;      /* number of deletable ADDIL insts found */
int copies_deleted;      /* number of deletable COPY insts found */


extern int  dollar_global_space; 


dense_set_type *elim_insts = NULL;	/* table of ptrs to bit vectors */
					/* representing instructions in */
					/* each subspace */

#ifdef NO_PROC_ELIM
int *new_subsp_start;                   /* subspace start after opt */
#endif

int opt_data_offset; /* (word) offset of current instruction copy point */
int uninit_offset;   /* number of uninit bytes in subsp for del_instructions()*/

void read_subsp_data(target_subsp)
int target_subsp; /* current subspace index */
    {	
    
    /* read in the initialized data of the current subspace, attach to 
       Subsp_Misc record. */

    FILE *f;	/* pointer to stdio file struct */
    int data_fildes;	/* file descriptor */
    struct subsp_misc_record *misc = & Subsp_Misc(target_subsp);
    char *cur_file_name = misc->subsp_data;
    int size = Subsp_Dict(target_subsp).initialization_length -
               misc->next_stub_offset; 

    assert(size != 0);

    f = efopen(cur_file_name, "r", CANT_OPEN);
    data_fildes = fileno(f);

    cur_name = cur_file_name; 

    misc->subsp_data = (char *)emalloc(size);
    ffetch(data_fildes, misc->data_file_offset,
    	       misc->subsp_data, sizeof(char), size);
    misc->data_file_offset = IN_MEMORY;
    fclose(f);
    }

	/* Defined in fixups.h now. REG_MASK now is ~0x03e00000 */
#if 0
#define REG_MASK        (0x03e00000)   /* mask to extract ADDIL/LDW reg field */
#define R27_MASK        (0x03600000)   /* mask to check reg = DP in ADDIL/LDW */
#endif /* 0 */

#define COPY_R1_INST	0x8010240     /* bit pattern for COPY r1,r0 */
#define COPY_R1_MASK	0xffffffe0    /* mask to check COPY, less target reg */

#define NULLIFY_ON	0x2	      /* bit to test unconditional branches
					 for nullified ADDIL in delay slot */

#define FORWARDS_BRANCH(inst_value)	((inst_value & 0x1) == 0)
#define NULLIFY_BITS4	0xf000
#define NULLIFY_BITS3	0xe000
#define NULLIFY_BITS1	0x20


/*
**	addil_can_be_elim().  Called by try_to_elim_inst() and by
**	delete_instructions():  used for confusing LR'/RR' calculation
**	to see if an ADDIL with a DP_REL fixup can be nuked.  This is
**	also called for a load/store with a DP_REL fixup applied too
**	(from delete_instructions()), to see if its __matching__ ADDIL
**	was removed.
**
**	The overriding thing to remember is that we cannot know unerringly
**	if we can eliminate each ADDIL; we've got to take a conservative
**	approach.  We need to estimate from the constant in the ADDIL
**	and the difference between (symbol - $global$) whether __any__
**	possible matching load/store/ldo instruction will not be able
**	to have its displacement fit in 14 signed bits.  Here is the
**	precept:
**
**		The immediate constant in an ADDIL must be within
**		0x1000 of the __rounded__ constant of any matching
**		instruction.
**
**	This of course only holds for LR'/RR' rounding modes.  With this
**	in mind, we can round the constant and (abs) add 0x1000 to it before
**	we calculate the entire expression value; this gives us the
**	maximum displacement we could ever hit, and is the most conservative
**	we can be.
**
**	This routine assures us that we will use the same calculation
**	both to determine if the ADDIL can be nuked as well as, when
**	examining a load/store, determine if its matching ADDIL __was__
**	nuked (and hence that we need to change %r1 to %dp).
**
**	The "is_addil" parameter is TRUE when called from try_to_elim(),
**	'cause the instruction in question is an ADDIL; FALSE otherwise.
**
*/

static Boolean addil_can_be_elim (int constant,
				  int sym_index,
				  Boolean is_addil)
{
    int prefix, test_prefix, test_selector;
    int expr, range;

    if ((Subsp_Dict(Sym_Subsp(sym_index)).space_index) != (dollar_global_space))
	return(FALSE);

    if (is_addil) {
    	test_prefix = e_lrsel;
    	test_selector = R_LSEL;
    } else {
    	test_prefix = e_rrsel;
    	test_selector = R_RSEL;
    }

    prefix = get_prefix(test_selector, field_sel);

    if (prefix == test_prefix) {

        constant = FIXUP_ROUND(constant);
        range = ADDIL_ELIM_RANGE / 2;
    }
    else
        range = ADDIL_ELIM_RANGE;

    /*******************************************************************
     *  The previous code used to add or subtract 0x1000 depending
     *  on the symbol is positive or negative off DP to get the
     *  widest range, but is was complicated and the bug was that
     *  it left out the constant value when it checks for + or -
     *  off of DP as:

          if (symbol_value(sym_index) >= dollar_global_addr)
            constant = HALF_FIXUP_ROUND_VALUE + constant;
          else
            constant = constant - HALF_FIXUP_ROUND_VALUE;
     *
     *  Where this should have been: 
          if ((symbol_value(sym_index) + constant) >= dollar_global_addr)
          ...
     *
     ********************************************************************/

    expr = symbol_value(sym_index) - dollar_global_addr + constant;

    /**
     ** If expr doesn't fit into the ADDIL elimination range 
     ** then addil cannot be eliminated.
     **/

    return (abs(expr) < range);

}  /* addil_can_be_elim */


/*
** 	try_to_elim_inst().  Return value is whether next R_NO_RELOC fixup
**	should be decremented, accounting for the last COPY elimination.
**
**	inst_offset: word offset of this instruction in the current subspace
**	sym_index:   index of symbol referenced in fixup
**
*/

Boolean try_to_elim_inst(int inst_offset, int sym_index)
{
    int inst_value;  /* current instruction image */
    struct subsp_misc_record *misc = & Subsp_Misc(fixup_subsp);
    int *inst = (int *) misc->subsp_data;	/* instruction "array" */
    int constant;        /* constant from instruction */


    if (misc->data_file_offset != IN_MEMORY) {
	int i;  /* loop counter */

	read_subsp_data(fixup_subsp);
    	inst = (int *) misc->subsp_data;  /* reset ptr to instruction "array" */

	/* check for previous BLR,r0 instructions */
	for (i=last_seen_brtab_end;i < inst_offset; i++) {
    	    inst_value = inst[i];
    	    if (GET_OP(inst_value) != 0x03a)   /* if not a branch, forget it */
		continue;
    	    if (GET_LINK(inst_value) != 0)   /* if link reg not r0, forget it */
		continue;
    	    if (GET_EXT3(inst_value) != 0x2)   /* if not BLR, forget it */
		continue;
	    in_branch_table = TRUE;
	    }
	}	/* END if not previously read in */

    if (in_branch_table)  /* no-op until R_END_BRTAB seen or end of subsp */
	return(FALSE);

    inst_value = inst[inst_offset];
    if (GET_OP(inst_value) != 0x0a)   /* if not an ADDIL, forget it */
	return(FALSE);
    if ((inst_value & ~REG_MASK) != R27_MASK) /* if not dp-relative, forget it*/
	return(FALSE);

    /* grab constant from instruction */
    constant = get_constant(GET21(inst_value));

    if (!addil_can_be_elim (constant, sym_index, TRUE))
	return FALSE;

    /* Don't eliminate ADDILs that are potentially nullified, as that would
       pull up the following instruction that presumably would be needed,
       which would then be erroneously nullified. */

    if (inst_offset != 0) {	/* check for delay slot */
	int prev_inst_value = inst[inst_offset-1]; /* previous instruction */
	switch (GET_OP(prev_inst_value)) {
	    case 0x3a:  /* BL and GATE */
	    case 0x38:  /* BE  */
	    case 0x39:  /* BLE */
                return FALSE;  /* ALWAYS punt on ADDILs */
                               /* in branch delay slots */

    		/* ENHANCE LATER TO ALLOW ELIM IN NON-NULLIFIED DELAY SLOTS
		   BY SETTING NULLIFY BIT IN PREVIOUS BRANCH? */

	    /* conditional branches */
#ifdef PA_2_0
	case 0x27: case 0x3b: case 0x2f:		/* COMDT COMDIB COMBDF*/
#endif
	    case 0x20: case 0x21: case 0x22: case 0x23:     /* COMB */
	    case 0x28: case 0x29: case 0x2a: case 0x2b:     /* ADDB */
	    case 0x30: case 0x31: case 0x32: case 0x33:     /* BB, MOVB, MOVIB*/
		if ((prev_inst_value & NULLIFY_ON) &&
		    FORWARDS_BRANCH(prev_inst_value))
		    break;  /* forwards nullified branch - go ahead and elim */
	        return(FALSE);	/* forget it, we're in a delay slot and executed. */

	    case 0x02: /* arith/log */
	    case 0x24: case 0x25: case 0x2c:	    /* COMICLR, SUBI, ADDIT */
	    case 0x2d: /* ADDI */
		/* instructions with 4-bit conditional nullification codes */
		if ((prev_inst_value & NULLIFY_BITS4) != 0)
		    return(FALSE);  /* nullify condition other than Never */
    		/* ENHANCE LATER TO PASS IF COND IS FOR TRAP, NOT NULLIFY? */
		break;

	    case 0x34: case 0x35: /* Extract, Deposit */
		/* instructions with 3-bit conditional nullification codes */
		if ((prev_inst_value & NULLIFY_BITS3) != 0)
		    return(FALSE);  /* nullify condition other than Never */
		break;

	    case 0x04: /* SPOPn */
	    case 0x0c: /* COPR - actually looking for FTEST and COPR only */
		/* instructions with 1-bit conditional nullification codes */
		if ((prev_inst_value & NULLIFY_BITS1) != 0)
		    return(FALSE);  /* nullify condition ON */
		break;

	    default: {};	/* fall through */
	    }
	}  /* END check for delay slot/nullification */

    if (!(elim_insts[fixup_subsp])) {
	/* create bit vector for this subspace if necessary */
	elim_insts[fixup_subsp] = realloc_dense_set (elim_insts[fixup_subsp], 
		Subsp_Dict(fixup_subsp).subspace_length/WORDSIZE);
	}

    /* Success! Add to bit vector for later deletion. */
    add_dense_set_item(elim_insts[fixup_subsp],inst_offset);
    addils_deleted++;

    /* If the following inst is a COPY instruction whose source register is
    r1, the COPY instruction can also be removed.  This removal assumes that
    the target register of the COPY instruction will be used only by LDW-,
    STW-, or LDO-family instructions that are properly paired with the
    ADDIL.  Note that we cannot remove a COPY instruction that is not
    immediately after the ADDIL because data flow analysis would be
    necessary to guarantee that the COPY is actually using the result of the
    ADDIL.  */
    if ((inst[inst_offset+1] & COPY_R1_MASK) == COPY_R1_INST) {
    	add_dense_set_item(elim_insts[fixup_subsp],inst_offset+1);
    	copies_deleted++;
	return(TRUE);
	}

    return(FALSE);
} /* end "try_to_elim_inst" */

/* build one-byte style of R_NO_RELOCATION fixup */
Fixup *build_no_reloc_fixup(no_reloc_len)
int no_reloc_len;  /* length of no reloc area in bytes */
    {

    /* this form of fixup is only allowed to work on word-size items */
    assert(no_reloc_len % WORDSIZE == 0);
    assert(no_reloc_len <= (24*WORDSIZE));

    static_fixup_area[0] = sizeof(Fixup);

    /* this fixup is opcode + (dispacment-1) */
    static_fixup_area[1] = R_NO_RELOCATION + ((no_reloc_len/WORDSIZE) - 1);
    return(static_fixup_area);
    }

/* build R_NOP_CLR_OVERRDS fixup to cover fixup from deleted instruction */
Fixup *build_nop_fixup(fixup_size)
int fixup_size;  /* bytes in original fixup */
    {
    /* offset to possibly create two-byte no-op, so that R_PREV fixup queue
       will be maintained even for references "over" deleted fixups */
    int is_multi_byte_fixup = (fixup_size > 1);

    static_fixup_area[0] = sizeof(Fixup) + is_multi_byte_fixup;
    static_fixup_area[1] = R_NOP_CLR_OVERRDS + is_multi_byte_fixup;
    if (is_multi_byte_fixup)
    	static_fixup_area[2] = 0;
    return(static_fixup_area);
    }

static Fixup *add_fprime_fixup(fix_info, old_fixup)
struct fix_desc *fix_info;
Fixup *old_fixup;
    {
    static_fixup_area[0] = fix_info->len + 1;
    static_fixup_area[1] = R_FSEL;
    memcpy(&static_fixup_area[2], old_fixup, fix_info->len);
    return(static_fixup_area);
    }


static int fix_resolved_branch(word, inst_offset)
int word;  /* instruction to be checked and possibly corrected */
int inst_offset;  /* (word) offset within subspace of this instruction */
    {
    int constant;
    int expected_prefix, expected_format;
    int bytes_less = 0;  /* bytes removed from this branch by ADDIL-elim */

    switch (GET_OP(word)) {
        case 0x3a:  /* BL,  GATE, BV, and BLR */
	    /* Don't adjust BV or BLR.  For PA2.0 instructions, for
	    ** BVE the extenstion bits are 6 (as for BE).  For BLL they are 5,
	    ** For BLVE, the extension bits are 7.  Don't adjust BVE or BLVE.
	    */
            if ((GET_EXT3(word) == 2) || (GET_EXT3(word) == 6)
#ifdef PA_2_0
                || (GET_EXT3(word) == 7)
#endif /* ifdef PA_2_0 */
	       )
                return(word);

#ifdef PA_2_0
	    /* For a PA2.0 BLL instruction, the extension bits are 5.
	    ** BLL has a 22 bit immediate instead of 17 bits.
	    */
            if (GET_EXT3(word) == 5) {
		constant = GET22(word);
		expected_prefix = get_prefix(R_FSEL, field_sel);
		expected_format = i_rel22;
	    } else
#endif /* ifdef PA_2_0 */
	    {
		constant = GET17(word);
		expected_prefix = get_prefix(R_FSEL, field_sel);
		expected_format = i_rel17;
	    }
            break;
#ifdef PA_2_0
	case 0x27: case 0x3b: case 0x2f:		/* COMDT COMDIB COMBDF*/
#endif
        case 0x20: case 0x21: case 0x22: case 0x23:     /* COMB */
        case 0x28: case 0x29: case 0x2a: case 0x2b:     /* ADDB */
        case 0x30: case 0x31: case 0x32: case 0x33:     /* BB   */
            constant = GET12(word);  
            expected_prefix = get_prefix(R_FSEL, field_sel);
            expected_format = i_rel12;
            break;
        default:
            return (word);
        }

    /* We have a resolved branch, correct it for any deleted instructions */
    /* pc+constant+8 is where the target will be for these instructions*/
    /* (except BLE or BE) which are not taken care of here */
    /* '+2' is +2 words or 8 bytes! */

    if (constant >= 0) {  /* forwards branch */
	assert(FORWARDS_BRANCH(word));  /* check macro definition */
	bytes_less = num_elements(elim_insts[fixup_subsp],
				inst_offset+1,  /* from inst in delay slot */
				inst_offset+(constant/WORDSIZE)+2-1) * WORDSIZE;
						/* to inst before target, */
    	/* because on a forward branch we do not want to check the target */
    	/* instruction to see if it was deleted. Even if it was, we */
    	/* still branch the same distance as if it were still there. */
        constant -= bytes_less;
	}
    else if (constant < -8) {  /* backwards branch */
	assert(!(FORWARDS_BRANCH(word)));  /* check macro definition */
        bytes_less = num_elements(elim_insts[fixup_subsp], 
				  inst_offset + (constant/WORDSIZE)+2,
						 /* from target inst */
				  inst_offset-1) * WORDSIZE;
				  		 /* to inst before this one */
        constant += bytes_less;
	}
    /* if constant == -8 or -4, branch to current inst! No intervening
       inst to eliminate.  Ignore, save the PFA */

    if (bytes_less != 0)
        word = fix_format (word, constant, expected_format, ST_NULL);
    return (word);
    }	/* END "fix_resolved_branch" */


/*
**************************************************************************
**
** build_end_try_fixup()
**
** Routine builds a new R_END_TRY fixup whose size is determined by 
** fixup_size and argument is word_offset.  word_offset represents a 
** branch_dot relative word offset of the RECOVER location.
**
** Note! the R_END_TRY fixup is defined to have an argument which 
** represents the byte offset of the RECOVER location.  However, in 
** reality the argument is a word offset. 
**
**
**************************************************************************
*/
static Fixup *build_end_try_fixup(int word_offset, int fixup_size)
{

    static_fixup_area[0] = fixup_size;
    switch (fixup_size) {
	case 1:
            static_fixup_area[1] = R_END_TRY;
	    break;
	case 2:
            static_fixup_area[1] = R_END_TRY + 1;
            static_fixup_area[2] = word_offset; 
	    break;
	case 4:
            static_fixup_area[1] = R_END_TRY + 2;
            static_fixup_area[2] = (word_offset >> 16); 
            static_fixup_area[3] = (word_offset >> 8); 
            static_fixup_area[4] = word_offset; 
	    break;
    }
    return(static_fixup_area);
}

Fixup *delete_instructions(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
    {
    int info_type;
    int word;
    int inst_count;  /* number of instructions to copy */
    int i;  /* loop counter */
    int base;  /* temp to hold 2nd symval as is sym-sym2+const */
    int constant;

    unsigned int *data;	/* pointer to subspace's "array" of instructions */
    int inst_offset; /* (word) offset of this instruction in the fixup subsp */
    int data_inst_offset; /* (word) offset of instruction in the files subsp */
    Boolean elim_first_inst_in_block;  /* has this COPY been eliminated? */

    extern int milli_label;

    assert(eliminating_addils);
    assert(Subsp_Misc(fixup_subsp).data_file_offset == IN_MEMORY);
    assert(Subsp_Dict(fixup_subsp).code_only);

    /* don't need protective code against subsp init length < subsp length,
       as in "adjust_instructions",  since already have checked that this is
       a "code_only" subspace - which we fervently hope means that init
       length == subsp length.  */
    assert(Subsp_Dict(fixup_subsp).initialization_length == 
    	   Subsp_Dict(fixup_subsp).subspace_length);

    data = (unsigned int *) Subsp_Misc(fixup_subsp).subsp_data;
    inst_offset = (branch_dot-original_branch_dot)/WORDSIZE;

    /* data_inst_offset is real offset in file */
    data_inst_offset = inst_offset - uninit_offset;

    switch (info_type = fix_info->type) {
#ifdef PA_2_0
	case R_SHORT_PCREL_MODE:
	case  R_LONG_PCREL_MODE:
#endif /* ifdef PA_2_0 */
        case R_BEGIN_BRTAB:
        case R_END_BRTAB:
        case R_FSEL:
        case R_LSEL:
        case R_RSEL:
        case R_N_MODE:
        case R_S_MODE:
        case R_D_MODE:
        case R_R_MODE:
        case R_DATA_OVERRIDE:
        case R_DATA_ONE_SYMBOL:
        case R_DATA_PLABEL:
        case R_DATA_EXPR:
        case R_TRANSLATED:
        case R_COMP1:
        case R_COMP2:
        case R_COMP3:
        case R_SEC_STMT:
        case R_ENTRY:
        case R_ALT_ENTRY:
        case R_AUX_UNWIND:
        case R_EXIT:
        case R_BEGIN_TRY:
        case R_STATEMENT:
        case R_NEW_BLE:
	case R_EXEC_LEVEL:
        case R_RELOCATION:
#ifndef NO_LTP_OVERRIDE
	case R_LTP_OVERRIDE:
#endif
#ifndef NO_DOC
	case R_LINETAB:
	case R_LINETAB_ESC:
#endif
	    /* recognized, but ignored */
	    return (NULL);

        case R_END_TRY:
	    /*
	    ** Deleting instructions may affect the argument to the
	    ** R_END_TRY fixup.  This argument is offset of the RECOVER
	    ** region relative to the end of the TRY region (branch_dot).
	    ** If any instructions have been deleted between the end of
	    ** the TRY region and the beginning of the RECOVER region 
	    ** then the offset argument will need adjusting.
	    */

	    /*
	    ** arg0 is actually a word offset instead of a byte as
	    ** it is documented.  Were going to leave it in words
	    ** since the RECOVER region offset is word aligned.
	    */
	   
	    /*
	    ** If the offset is 0 then no instructions can be 
	    ** deleted between the end of the TRY region and
	    ** the beginning of the RECOVER region so just return.
	    */
	    if (arg0 == 0) 
	        return(NULL);

	    /*
            ** If there is an offset check to see if any instructions
            ** were deleted between the end of the TRY region and
            ** the beginning of the RECOVER region.  If so adjust the
            ** existing R_END_TRY fixup by annotating it.
            **
            ** Note! Since the offset can only get smaller in distance
            ** the current R_END_TRY fixup will be large enough to
            ** hold any adjusted offset value.  Therefore build an
            ** annotated fixup of the same size as the current fixup.
            */
	    return(build_end_try_fixup(
	        (arg0 > 0 ? 
		 arg0 - num_elements(elim_insts[fixup_subsp],
		                     inst_offset,
				     inst_offset + arg0) :
		 arg0 + num_elements(elim_insts[fixup_subsp],
				     inst_offset + arg0,
				     inst_offset)
                ), 
                fix_info->len));

        case R_UNINIT:
        case R_ZEROES:
	    /* Adjust inst_offset by this many bytes which are in the */
	    /* subsp but not in the file */
	    uninit_offset += arg0/WORDSIZE;
	    return(NULL);

        case R_REPEATED_INIT:
	    /* Adjust inst_offset by this many bytes which are in the */
	    /* subsp but not in the file */
	    uninit_offset += arg1/WORDSIZE;
	    return(NULL);

        case R_CODE_PLABEL:
        case R_PCREL_CALL:
        case R_DLT_REL:
        case R_ABS_CALL:
        case R_BREAKPOINT:
        case R_CODE_EXPR:
        case R_PCREL_TO_STUB:
	    /* copy one instruction, unmodified */
	    data[(opt_data_offset++)-uninit_offset] = data[data_inst_offset];
	    return (NULL);

        case R_MILLI_REL:
	    word = data[data_inst_offset]; 
	    arg0 += sym_bias;
     	    arg0 = Sym_Remap(arg0);

	    if (!(Subsp_Dict(Sym_Subsp(arg0)).code_only)) {
	        data[(opt_data_offset++)-uninit_offset] = data[data_inst_offset];
                return(NULL);
		}

	    /* adjust constant if necessary */

	    base = 0;  
	    if (Sym_Remap_Type(arg0) != ST_MILLI_EXT) 
                base = symbol_value(milli_label);


	    /* grab constant from instruction */
	    constant = fix_instruction(word,
                        symbol_value(arg0)-base,
                        ST_NULL, /* we lie so sr field won't get modified */
                        RET_CONSTANT
                        );

	    data[(opt_data_offset++)-uninit_offset] =
				adjust_constant(word, arg0, base, constant);
	    return (NULL);

        case R_CODE_ONE_SYMBOL:
	    /* adjust constant if necessary */

	    word = data[data_inst_offset]; 
	    arg0 += sym_bias;
     	    arg0 = Sym_Remap(arg0);
	    base = 0;    /* not relative to a sym */

	    if (!(Subsp_Dict(Sym_Subsp(arg0)).code_only)) {
	        data[(opt_data_offset++)-uninit_offset] = data[data_inst_offset];
                return(NULL);
		}

	    /* grab constant from instruction */
	    constant = fix_instruction(word, symbol_value(arg0),
				                       ST_NULL, RET_CONSTANT);
            /* constant = get_constant(GET14(word)); */

	    data[(opt_data_offset++)-uninit_offset] =
				adjust_constant(word, arg0, base, constant);
	    return (NULL);

	case R_NO_RELOCATION:
	    assert ((arg0 & 3) == 0);  /* code segment length is in words */

	    inst_count = arg0 / WORDSIZE;
	    if (elim_first_inst_in_block  = 
		test_dense_set_item(elim_insts[fixup_subsp], inst_offset)){
		/* if to be deleted */
	    	inst_offset++;
		data_inst_offset++;
		inst_count--;
		}

	    for (i = 0; i < inst_count; i++) {
	        data[(opt_data_offset++)-uninit_offset] =
		    fix_resolved_branch(data[data_inst_offset], inst_offset);
		inst_offset++;
		data_inst_offset++;
		}  /* END for loop over words to copy */

	    if (elim_first_inst_in_block) {
                if( arg0 == WORDSIZE ) {
		    /* no-op the fixup, is just covering the eliminated COPY */
		    return(build_nop_fixup(fix_info->len));
		    }
    	        else {
		    /* decr the fixup, covering more than the eliminated COPY */
            	    assert( fix_info->len == 1 );
		    /* otherwise, bit would have been cleared to not delete,
			as would be an annotated multi-byte fixup (i.e.,
			IS_ANNOTATABLE(R_NO_RELOCATION) == TRUE) and would
			cause a lot of R_NO_RELOCATION's to be expanded from
			R_PREVs unnecessarily - and is rare enough to ignore
			for performance purposes.  */
		    return(build_no_reloc_fixup(arg0-WORDSIZE));
		    }
	        }
	    return (NULL);

        case R_DP_RELATIVE:

	    if (in_branch_table)
		return(NULL);          /* if in branch table get out quick! */

	    word = data[data_inst_offset];
	    arg0 += sym_bias;
     	    arg0 = Sym_Remap(arg0);
	    if (GET_OP(word) == 0x0a) {  /* if an ADDIL */
	        if (test_dense_set_item(elim_insts[fixup_subsp], inst_offset)){
		    /* if to be deleted */
	    	    inst_offset++;
		    data_inst_offset++;
		    return(build_nop_fixup(fix_info->len));
		    }
		else  /* ADDIL, but NOT deleted */
	            data[(opt_data_offset++)-uninit_offset] = word; /* copy it*/
		}
	    else {  /* Load/Store - Change register to DP */

                /*
                ** If this symbol is a shared global, the preceding ADDIL 
                ** would not have been removed.  If it is a shared global
                ** just copy the instruction without modification.
                */
                if (Sym_SharedGlobal(arg0)) {
	            data[(opt_data_offset++)-uninit_offset] = word;
                } else {

		    /*
		    ** Note! we must determine if the ADDIL for this load/store
		    ** instruction was removed.  The elim_insts[] vector
		    ** is not sufficient since the ADDIL could have been
		    ** hidden in a branch delay slot.  In short, there 
		    ** is no way to know which ADDIL instruction will set 
		    ** the %r1 register.
		    */  

		    /* grab constant from instruction */
#ifdef PA_2_0
		if (   GET_OP(word) == 0x16 	/* FLDWM 	*/
		    || GET_OP(word) == 0x17 	/* FLDW/LDWMC 	*/
		    || GET_OP(word) == 0x1e	/* FSTWM 	*/
		    || GET_OP(word) == 0x1f	/* FSTW/STWMC 	*/
		   ) 
		{
		    /* fldwm ldwmc fldw fstwm fstw stwmc - 32-bit operand */
		    constant = get_constant((int) GET14LONGDISP(word));
		} else if (GET_OP(word) == 0x14 || GET_OP(word) == 0x1c) {
		    /* ldd fldd std fstd - 64-bit operand */
		    constant = get_constant((int) GET14LONGDISPDBL(word));
		} else 
#endif /* ifdef PA_2_0 */
                { 
	            constant = get_constant((int) GET14(word));
		}
			/* New routine now added
			** and called to determine the range.
			** if expr fits in 14 bits as F', then addil was
			** eliminated */
		    if (addil_can_be_elim (constant, arg0, FALSE)) {
	                data[(opt_data_offset++)-uninit_offset] = 
			    ((word & REG_MASK) | R27_MASK);

		        /* 
                        ** it needs the F' field selector fixup to make
		        ** sure all 14 bits are retrieved R_FSEL will cause 
                        ** the full value to be placed into the constant 
                        ** field of the LDW/STW/... instruction.
                        */
		        return(add_fprime_fixup(fix_info, fixup));
		    } else {
	                data[(opt_data_offset++)-uninit_offset] = word;
                    }
	        }
            }
            break;

        default: {} /* do nothing */
        }

    return (NULL);
    }


Fixup *adjust_instructions(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
    {
    int info_type;
    int word;
    int inst_count;  /* number of instructions to copy */
    int i;  /* loop counter */
    int base;  /* temp to hold 2nd symval as is sym-sym2+const */
    int constant;

    unsigned int *data;	/* pointer to subspace's "array" of instructions */
    int inst_offset; /* (word) offset of this instruction in the fixup subsp */
    int data_inst_offset; /* (word) offset of instruction in the files subsp */

    extern int milli_label;

    assert(eliminating_addils);

    /* code-only subspaces that have no instructions deleted can't need to
       adjust constants - can they? */
    if ((Subsp_Dict(fixup_subsp).code_only) ||

       /* if data word is not in initialized area of subspace, it implicitly
       is zero and can't need to be adjusted.  Important since "read_subsp_data"
       only allocates enough space for the initialized part of subspace - keeps
       us from accessing off end of "data" array.  */
       (Subsp_Dict(fixup_subsp).initialization_length <= 
				(branch_dot-original_branch_dot))) {
	return(NULL);
	}

    if (Subsp_Misc(fixup_subsp).data_file_offset != IN_MEMORY) {
        read_subsp_data(fixup_subsp);
        Subsp_Misc(fixup_subsp).data_file_offset = IN_MEMORY;
	}
    assert(Subsp_Misc(fixup_subsp).data_file_offset == IN_MEMORY);

    data = (unsigned int *) Subsp_Misc(fixup_subsp).subsp_data;
    inst_offset = (branch_dot-original_branch_dot)/WORDSIZE;
    data_inst_offset = inst_offset - uninit_offset;

    switch (info_type = fix_info->type) {
#ifdef PA_2_0
        case R_SHORT_PCREL_MODE:
        case  R_LONG_PCREL_MODE:
#endif /* ifdef PA_2_0 */
        case R_BEGIN_BRTAB:
        case R_END_BRTAB:
        case R_FSEL:
        case R_LSEL:
        case R_RSEL:
        case R_N_MODE:
        case R_S_MODE:
        case R_D_MODE:
        case R_R_MODE:
        case R_DATA_OVERRIDE:
        case R_TRANSLATED:
        case R_COMP1:
        case R_COMP2:
        case R_COMP3:
        case R_SEC_STMT:
        case R_ENTRY:
        case R_ALT_ENTRY:
        case R_AUX_UNWIND:
        case R_EXIT:
        case R_BEGIN_TRY:
        case R_END_TRY:
        case R_STATEMENT:
        case R_NEW_BLE:
	case R_EXEC_LEVEL:
        case R_RELOCATION:
	case R_DATA_ONE_SYMBOL:
        case R_DATA_PLABEL:
        case R_DATA_EXPR:
        case R_CODE_PLABEL:
        case R_PCREL_CALL:
        case R_DLT_REL:
        case R_ABS_CALL:
        case R_BREAKPOINT:
        case R_CODE_EXPR:
        case R_PCREL_TO_STUB:
	case R_NO_RELOCATION:
        case R_DP_RELATIVE:
#ifndef NO_LTP_OVERRIDE
	case R_LTP_OVERRIDE:
#endif
#ifndef NO_DOC
	case R_LINETAB:
	case R_LINETAB_ESC:
#endif
	    /* recognized, but ignored */
	    return (NULL);

        case R_UNINIT:
        case R_ZEROES:
	    /* Adjust inst_offset by this many bytes which are in the */
	    /* subsp but not in the file */
	    uninit_offset += arg0/WORDSIZE;
	    return(NULL);

        case R_REPEATED_INIT:
	    /* Adjust inst_offset by this many bytes which are in the */
	    /* subsp but not in the file */
	    uninit_offset += arg1/WORDSIZE;
	    return(NULL);


        case R_MILLI_REL:
	    /* Used only for COBOL decimal millicode and external millicode -
	       if not for COBOL/UX this would be dead code.  */
	    arg0 += sym_bias;
     	    arg0 = Sym_Remap(arg0);

	    /* if target symbol isn't in a subspace that could have deleted
	       instructions, it can't need adjustment. */
	    if (!(Subsp_Dict(Sym_Subsp(arg0)).code_only)) {
                return(NULL);
		}

	    /* adjust constant if necessary */

	    base = 0;  
	    if (Sym_Remap_Type(arg0) != ST_MILLI_EXT) 
                base = symbol_value(milli_label);

            /* get instruction from subspace */
	    word = data[data_inst_offset]; 

	    /* grab constant from instruction */
	    constant = fix_instruction(word,
                        symbol_value(arg0)-base,
                        ST_NULL, /* we lie so sr field won't get modified */
                        RET_CONSTANT
                        );

	    data[data_inst_offset] = 
				adjust_constant(word, arg0, base, constant);
	    return (NULL);

        case R_CODE_ONE_SYMBOL:
	    /* adjust constant if necessary */

	    /* printf("code 1 in adjust_inst\n"); */

	    arg0 += sym_bias;
     	    arg0 = Sym_Remap(arg0);

	    /* if target symbol isn't in a subspace that could have deleted
	       instructions, it can't need adjustment. */
	    if (!(Subsp_Dict(Sym_Subsp(arg0)).code_only)) {
                return(NULL);
		}

	    /* get instruction from subspace */
	    word = data[data_inst_offset]; 

	    /* grab constant from instruction */
	    constant = fix_instruction(word, symbol_value(arg0),
				                       ST_NULL, RET_CONSTANT);

	    base = 0;    /* not relative to a sym */
	    data[data_inst_offset] =  
				adjust_constant(word, arg0, base, constant);
	    return (NULL);

        default: {} /* do nothing */
        }

    return (NULL);
    }



int adjust_constant(word, sym_index, base, constant)
int word;               /* The instruction where the constant resides */
int sym_index;         
int base;             /* an adjustment to symval+constant (e.g. $global) */
int constant;         /* The constant found in the instruction */
{
    struct symbol_dictionary_record sym;
    int temp_data_override, temp_data_override_val;
    int temp_field_sel;
    unsigned int sym_val;
    int bytes_less;
    int offset;
    int is_data = FALSE;
    int subsp_index;             /* symbol's subspace index */

    /*
    ** If this symbol is an absolute symbol then it is not subject
    ** to relocation and no constant adjustment is necessary.
    */
    if (Sym_Type(sym_index) == ST_ABSOLUTE) {
	return(word);
    }

    if (constant == word)   
       is_data = TRUE;     /* we are not adjusting an instruction */

    /* offset of sym val in its subsp */
    sym_val = (symbol_value(sym_index) /* - base*/) /WORDSIZE;
    offset = Subspace_Virtual_Offset(Sym_Subsp(sym_index))/WORDSIZE;

    sym_val -= offset;

    subsp_index = Sym_Subsp(sym_index);
    if ((Subsp_Dict(subsp_index).initialization_length <= 0) ||
	 (elim_insts[subsp_index] == NULL)) {
	 /* The symbol's subspace has no bit vector! -- Get out quick! */
         return(word);     
	 }


    /* -1 because on a forward branch we do not want to check the target */
    /* instruction to see if that has been deleted. Even it is was we */
    /* still branch the same distance as if it were still there */

    offset = constant / WORDSIZE;
    if (constant > WORDSIZE-1) {  /* forwards branch */
	
	if (offset + sym_val -1 > elim_insts[subsp_index]->size) 
	    offset = elim_insts[subsp_index]->size+1;
	bytes_less = num_elements(elim_insts[subsp_index], sym_val,
				  sym_val+offset-1) * WORDSIZE;
        constant -= bytes_less;
	}
    else if (constant < -WORDSIZE+1) {  /* backwards branch */
	if (offset + sym_val < 0) 
	    offset = 0;
        bytes_less = num_elements(elim_insts[subsp_index], sym_val+ offset,
					   sym_val-1) * WORDSIZE;
        constant += bytes_less;
	}
    else {
	/* constant = 0 */
	return(word);
	}

    if (bytes_less != 0) {
     
	 /* put new constant back into instruction */
	 if (!is_data) {
		 /* use the data_override to force it in */
		 temp_data_override = data_override;
		 temp_data_override_val = data_override_value;
		 temp_field_sel = field_sel;

		 /* Force the values */
		 data_override = 1;
		 data_override_value = constant;
		 field_sel = R_FSEL;

		 /* Update word */
		 word = fix_instruction(word, 0, ST_NULL, RET_WORD);

		 /* Restore */
		 data_override = temp_data_override;
		 data_override_value = temp_data_override_val;
		 field_sel = temp_field_sel;
		 }
	 else {
	      /* this must be data not an instruction */
	     word = constant;
	     }
	 }

    return(word);     /* Return adjusted word */
    }


int compute_new_sym_values()
{
    int i;
    int stop_pos, subsp_offset;
    int sym_index;
    int subsp_index;
    struct symbol_dictionary_record *sym;
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record *misc;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
                             means 'seen before in this search' */

    if (sym_dict_size > 0) /* If no symbols, don't dereference a null pointer*/
      seen_before = !Sym_Misc(0).checked; /*inverse of value from last search*/

    for (i = 0; i < sym_dict_size; i++) {
        /* if this entry was previously visited, don't check it again */
        if (Sym_Misc(i).checked == seen_before)
            continue;
        Sym_Misc(i).checked = seen_before; /* toggle all bits for next search */

	/* get sym index */
	sym_index = Sym_Remap(i);
	sym = &Sym_Dict(sym_index);
	/*  This better be set correctly in add_symbol().
	** Don't explicitly set to zero for all the cases below! */
	assert (Sym_Misc(i).new_sym_value_delta == 0);

        switch (sym->symbol_type) {
	    case ST_PLABEL:
	    case ST_PRI_PROG:
	    case ST_SEC_PROG:
	    case ST_ENTRY:
	    case ST_CODE:
	    case ST_MILLICODE:
	    case ST_MILLI_EXT:
	        subsp_index = Sym_Subsp(sym_index);

	        if (!(elim_insts[subsp_index])) {
	            /* Sym_Misc(i).new_sym_value_delta = 0; */
	            break;                 /* ignore sym if in a subspace */
					   /* without a bit vector */
	            }

                subsp_offset = (sym->symbol_value
			         - Subsp_Dict(subsp_index).subspace_start);

	        stop_pos = (subsp_offset/WORDSIZE) - 1;

		if (stop_pos < 0) {
		     /* stop_pos must be at the beginning of the subspace */
		     /* Whether instr elim or not this sym won't have delta! */
	             /* Sym_Misc(i).new_sym_value_delta = 0; */
		     }
		else  {
	             Sym_Misc(i).new_sym_value_delta = 
		         (num_elements(elim_insts[subsp_index], 0, stop_pos)
				     * WORDSIZE);
		     }
	        break;  
	    default:
	        /* Sym_Misc(i).new_sym_value_delta = 0; */
	        break;
	    }
        }
}

