/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Output File Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/output.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#ifndef DEBUG
#define NDEBUG
#endif  /* !DEBUG */
#include <assert.h>
#include <stdlib.h>

#include "filehdr.h"
#include "aouthdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "initptr.h"
#include "compunit.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "ldlimits.h"
#include "allocate.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "ldnls.h"
#include "linker.h"
#include "o2n_tally.h"
#include "output.h"
#include "shl.h"
#include "spaces.h"
#include "ld_strings.h"
#include "stub_inst.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "libraries.h"
#include "embed.h"

#ifdef ESOM
#include "cnx_aout.h"
#endif /* ESOM */

#include "annotate.h"

#include "debug_opt.h"

#ifdef CNX_TOOLS
#include "cnx_link_info.h"
#endif /* CNX_TOOLS */

/* doom support */
#include "ld_linkmap.h"

struct tmp_space_misc_record {
    int	new_sub_index;
    int new_sub_quantity;
};

#define CODE_TYPE         	0X20
#define LAST_VALID_TYPE   	0X7F
#define FIRST_DATA_TYPE   	0
#define LAST_DATA_TYPE    	0X1F

#define UNWIND_START		"$UNWIND_START"
#define UNWIND_END		"$UNWIND_END"
#define RECOVER_START		"$RECOVER_START"
#define RECOVER_END		"$RECOVER_END"

#define ZBUFSIZE 		 512	/* size of buffer for padding file */
#define ABS_BUF_SIZE             512
#define MAX_LINE_TBL_SZ         1024
/* Globals */

struct header	new_som_header;
int		out_som_fd = 0;

int		output_mode = 0;

/* global hash table support */
int             dl_header_ext_offset = 0;

extern Boolean mixed_mode_off;
extern int branch_dot;
extern int unwind_branch_dot;
extern int recover_branch_dot;
extern int unwind_bits;
extern int frame_size;
#ifdef TSD /* TSD */
extern int tbss_size;
int tsd_addr;
Boolean seen_tls = FALSE;
extern int num_tbss;
#endif /* TSD */

int abs_fix_base;
int code_reloc_factor;
int line_table_virtual_addr;  /* set in fixups.c do_fixups() */
int aux_unwind_size;          /* set at start of out_subsp_data */

int curr_copyram_index;       /* set in fixups.c do_fixups() */

#ifndef WW_ANNOTATIONS
/* This is used by the zap ld (the linker that goes in the BE and ignores
   annotations).  It uses this flag to determine if it should ignore the
   R_COMMENT fixup, or if it should relocate the symbol index for a -r link */
int doing_relocatable_fixups = FALSE;
#endif /* !WW_ANNOTATIONS */

extern int  no_dlheader_ext;/* output dl_header_ext structure ? */
extern int  gh_ext_opt_specified;
extern int  dollar_global;  /* abuse perpetuated from o2n_driver.c */

#ifdef ESOM
extern Boolean	 perfer_som;
extern Boolean   esom_no_parallel_obj;
extern Boolean   esom_is_parallel;
extern Boolean   esom_is_oversubscribe;
extern Boolean	 esom_object;
extern Boolean	 esom_spinwait;
extern Boolean	 esom_onenode;
extern Boolean   spp2000_target;
extern int       esom_min_cpus;
extern int       esom_max_cpus;
extern int	 esom_max_thr_node;
extern int	 esom_stack_type;
extern int	 esom_tstack_type;
extern struct cnx_option_header *opt_hdr;

static void out_esom_header();
static void bd_esom_header();
#endif /* ESOM */

/* Locals */
static struct som_exec_auxhdr 			hp_ux_header;
static struct ipl_aux_hdr 		        ipl_header;
#ifndef ESOM
static struct init_pointer_record 	       *init_array = NULL;
#else
static struct init_pointer_record              *som_init_array = NULL;
static struct cnx_init_pointer_record          *esom_init_array = NULL;
static struct cnx_init_pointer_record          *init_array = NULL;
#endif /* ESOM */
static struct mpe_som_aux_hdr 		        new_hpe_header;
static struct linker_footprint 		        ld_aux_header;
static struct product_specific_aux_hdr         *product_aux_header; 

       /* allocated in bd_product_specific_header() */
static struct tmp_space_misc_record         *tmp_space_misc = NULL;
static struct subspace_dictionary_record       *temp_sub = NULL;
static int    user_header_loc = 0; 

static char abs_buf[ABS_BUF_SIZE];
static int out_abs_fixup_count;
static int abs_buf_count;
static int abs_fix_loc;
static int old_recover_count, old_unwind_count;
static int curr_unwind_file_loc;
static int curr_recover_file_loc;
static int curr_aux_unwind_file_loc;
static int curr_line_tbl_file_loc;
static int line_table_offset;
static int curr_copyram_file_loc;
static int old_copyram_count;

/*##################### Functions and Subroutines ##########################*/

/* FORWARD DECLARATIONS */
struct relink_indices *relocate_old_subspace();
void relocate_shlib_info();
void relocate_DLT();
void relocate_PLT();

/*
 * build_init_array() makes a pass through the subspace dictionary
 * to build the initialization pointers.  This algorithm
 * uses the same two routines (need_new_init_ptr() and
 * combine_init_ptrs()) that are used in count_init_ptrs() in
 * reloc.c.  For each non-empty subspace, build_init_array()
 * determines whether a new init pointer is needed, or whether it
 * can be included with the current init pointer (by extending the
 * range of the current one).  Because of the details of extending
 * an init pointer (see need_new_init_ptr()), it is possible that
 * after extending the current one, it can be coalesced with the
 * previous one.  The coalescing is done by combine_init_ptrs().
 */

void build_init_array()
{
    int    new_sp_index, sp_index, old_index, subsp_index, num_subsp;
    int	    num_init_ptr, ind;
    struct  subspace_dictionary_record	    *subsp;
    struct  subsp_misc_record		    *misc;
#ifndef ESOM
    struct  init_pointer_record		    *init, *prev_init, *new_init;
#else
    struct  cnx_init_pointer_record	    *init, *prev_init, *new_init;
    int	    is_private;
#endif /* ESOM */

    unsigned int temp_subsp_start;      /* save orig for copyram */
    unsigned int temp_subsp_len;        /* save orig for copyram */
    int rom_sp_index;                /* index of fake space */


    if (init_array != NULL)
        efree(init_array);
    /* allocate two extra init pointers to allow for coalescing near end */
#ifndef ESOM
    init_array = (struct init_pointer_record *)
	emalloc((init_array_size + 2) *
		sizeof(struct init_pointer_record));
#else
    init_array = (struct cnx_init_pointer_record *)
	emalloc((init_array_size + 2) *
		sizeof(struct cnx_init_pointer_record));
#endif /* ESOM */
    prev_init = init = NULL;
    new_init = init_array;
    num_init_ptr = 0;
    ind = 0;

    if (verbose & V_ALLDEBUG)
        printf(ld_gets(1, 1171, "build_init_array:\n"));

    /* for each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

       if (!space_array[sp_index].is_loadable ||
	          space_misc[sp_index].copyram_needed)
				      continue;

#ifdef ESOM
	is_private = space_array[sp_index].is_private;
#endif /* ESOM */
	subsp_index = space_array[sp_index].subspace_index;
	num_subsp = space_array[sp_index].subspace_quantity;

	/* For each of its subspaces */
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    misc = &Subsp_Misc(old_index);

	    /* ignore zero-length subspaces */
	    if (subsp->subspace_length == 0)
		continue;

#ifdef TSD /* TSD */
	    /* ignore init pointers for TSD */
	    if (subsp->is_tspecific) {
               continue;
	    }
#endif /* TSD */         

            /* Miscounted init pointers when
            ** building the init pointer array.  We should skip duplicate
            ** common blocks just like we do when counting init pointers.
            */
	    if (misc->first_common_def != -1)
                continue;

	    if (verbose & V_ALLDEBUG)
 	        printf("%3d %-20s %02x %c%c%c %08x %08x:  ",
				  subsp_index, subsp->NAME_PT,
				  subsp->access_control_bits,
				  subsp->initialization_length? 'H':'.',
				  subsp->memory_resident? 'R':'.',
				  subsp->initially_frozen? 'F':'.',
				  misc->new_subspace_start,
				  subsp->subspace_length);

	    /* skip small non-resident subspaces when a resident */
	    /* subspace begins later on the same page */
	    if (mr_seen &&  /* faster to not try if no resident seen -  */
	        res_look_ahead(subsp, misc, subsp_index, num_subsp, init)) {
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1172, "skip\n"));
    		init->initially_frozen |= subsp->initially_frozen;
    		init->initialization_length =
				    misc->new_subspace_start +
    				    subsp->subspace_length -
				    init->space_offset;
    		continue;
     	    }

    	    /* update current init pointer and/or make new one */
#ifndef ESOM
    	    if (need_new_init_ptr(subsp, misc, init, new_init)) {
#else
    	    if (need_new_init_ptr(subsp, misc, init, new_init, is_private)) {
#endif /* ESOM */
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1173, "new"));
    		num_init_ptr++;
    		prev_init = init;
    		init = new_init;
    		new_init++;
    		if (num_init_ptr > init_array_size + 1)
    		    internal_error(WRNG_INIT_PTR_COUNT, 0);
    	    }
    	    /* merge new init pointer with last one if possible */
    	    else if (combine_init_ptrs(prev_init, init)) {
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1174, "com"));
    		num_init_ptr--;
    		new_init = init;
    		init = prev_init;
    		prev_init = NULL;
    	    } else {
     	        /* extend current init pointer to include next subspace */
                if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1175, "ext"));
            }

            if (verbose & V_ALLDEBUG)
                printf(" %08x %08x\n",
        			init->space_offset,
				init->initialization_length);

    	}

        space_array[sp_index].init_pointer_index = ind;
        space_array[sp_index].init_pointer_quantity = num_init_ptr-ind;
    	ind = num_init_ptr;

	/*
	** To remove the padding between the SOM header and the TEXT
	** space, we need to patch the init pointer for TEXT, even
	** though they are not used on HP-UX. However, changes here
	** will be propagated to the all important exec aux header.
	** This expands the init pointer to include the header as 
	** part of the TEXT space.
	*/

        /*
        ** If there are multiple init pointers for TEXT,
        ** patch all of them.
        */
	if (unpad_after_header &&
	    space_array[sp_index].is_loadable &&
	    !space_array[sp_index].is_private) {
            int i;
#ifdef ESOM
            struct  cnx_init_pointer_record	*ipr;
#else
            struct  init_pointer_record	*ipr;
#endif /* ESOM */
            ipr = &init_array[space_array[sp_index].init_pointer_index];
            for (i = 0; i < space_array[sp_index].init_pointer_quantity; i++) {
		ipr->file_loc_init_value   -= unpad_after_header;
		ipr->space_offset          -= unpad_after_header;
		ipr->initialization_length += unpad_after_header;
                ipr++;
            }
	}

	/* 
	** Make the same adjustment for the data space if it has been moved
	** up to get rid of the padding between $TEXT$ and $PRIVATE$.
	*/

	if (   unpad_before_private
	    && space_array[sp_index].is_loadable
	    && space_array[sp_index].is_private
#ifdef TSD
	    && !space_array[sp_index].is_tspecific
#endif
            ) {

            int i;
            struct  init_pointer_record	*ipr;
            ipr = &init_array[space_array[sp_index].init_pointer_index];
            for (i = 0; i < space_array[sp_index].init_pointer_quantity; i++) {
		ipr->file_loc_init_value   -= unpad_before_private;
		ipr->space_offset          -= unpad_before_private;
		ipr->initialization_length += unpad_before_private;
                ipr++;
            } /* for each init pointer */
	} /* If this is the $PRIVATE$ space and unpad_before_private */
    } /* for each space */

    if (verbose & V_ALLDEBUG)
        printf(ld_gets(1, 1176, "Total init pointers:  %d\n"), num_init_ptr);

    if (num_init_ptr != init_array_size)
	    internal_error(WRNG_INIT_PTR_COUNT , 0);

} /* build_init_array */

void create_loader_fixups()
{
    static unsigned int old_size = 0;

    if (loader_fixup_size > old_size) {
        if (loader_fixup_array == NULL) {
            loader_fixup_array = (struct loader_fixup *)
            				emalloc(loader_fixup_size *
                    				sizeof(struct loader_fixup));
	} else {
            /* keep old entries around (FOR FRU RELINK) */
            loader_fixup_array = (struct loader_fixup *)
            				erealloc((char *) loader_fixup_array,
                                                 loader_fixup_size *
                     				 sizeof(struct loader_fixup));
        }
        old_size = loader_fixup_size;
    }
} /* create_loader_fixups */

void bd_ipl_header()
/* build ipl aux header */
{
    int	    i, b_flag = FALSE;
    int    bsize = 0, entry_addr, new_index, subsp_index;
#ifndef ESOM
    struct init_pointer_record	    *init_array_start;
#else
    struct cnx_init_pointer_record  *init_array_start;
#endif
    int	    padding, len, zeroes[ZBUFSIZE];
    extern int ipl_checksum();
    extern void out_ipl_header();
    off_t	offset;

    ipl_header.header_id.mandatory = FALSE;
    ipl_header.header_id.copy = FALSE;
    ipl_header.header_id.append = FALSE;
    ipl_header.header_id.ignore = TRUE;
    ipl_header.header_id.reserved = 0;
    ipl_header.header_id.type = IPL_AUX_ID;
    ipl_header.header_id.length = sizeof(struct ipl_aux_hdr) -
				      sizeof(struct aux_id);

    ipl_header.file_length = new_som_header.som_length;

    if (!code_mmap_addr)
        ipl_header.address_dest = -1;
    else
        ipl_header.address_dest = code_offset -
				     init_array[0].file_loc_init_value;
    new_index = Sym_Remap(entry_symbol_index);
    entry_addr = symbol_value(entry_symbol_index);
    subsp_index = Sym_Subsp(new_index);
    ipl_header.entry_offset = entry_addr +
	   Subsp_Misc(subsp_index).stubs_file_loc -
	   Subsp_Misc(subsp_index).new_subspace_start;
    /* calculate bsize */
    bsize = 0;
    b_flag = FALSE;
    init_array_start = &init_array[0];
    for (i = 0; i < init_array_size; i++) {
         if ((init_array_start->access_control_bits >= FIRST_DATA_TYPE) &&
	     (init_array_start->access_control_bits <= LAST_DATA_TYPE)) {
    	    /*
    	       ASSUME initialized data are allocated before
	       uninitialized data
	    */
	    if (init_array_start->has_data == FALSE) {
	        b_flag = TRUE;
	        bsize = init_array_start->space_offset;
	        break;
	    }
	}
        init_array_start++;
    }

    if (b_flag) { /* there exists uninitialized data subsp */
         ipl_header.bss_size =
		    init_array[init_array_size - 1].space_offset +
		    init_array[init_array_size - 1].initialization_length -
		    bsize;
    } else {
        ipl_header.bss_size = 0;
    }
    ipl_header.checksum = 0;
	
    /* compute actual checksum of entire file less checksum word itself */

    out_ipl_header(new_som_header.aux_header_location);

    /* Going to be doing raw i/o, so clear the buffer first */
    flush_fdump_buffer();

    /* Pad file out to som_length */ 

    if ((offset = lseek(out_som_fd, 0L, 2)) == -1) {
       system_error(CANT_SEEK_IN, output_name, 0);
    }

    padding = new_som_header.som_length - offset;
    if (padding > 0) {
	for (len = 0; len < ZBUFSIZE/sizeof(int); len++)
	    zeroes[len] = 0;
	while (padding > 0) {
	    len = (padding > ZBUFSIZE)? ZBUFSIZE : padding;
            if (write (out_som_fd, (void *) zeroes, len) != len) {
               system_error(FDMP_CANT_WRT, output_name, 0);
            }
	    padding -= len;
	    }
	}
    /* Clear remembered filofs in fdump since we used write() directly */
    clear_oldfilofs();

    ipl_header.checksum = ipl_checksum(new_som_header.som_length);

} /* end bd_ipl_header */

int ipl_checksum(length)
int length;
{
    int	    i, chunk;
    int	    cksum;
    int	    *p, som_buf[512];

    cksum = 0;

    /* Going to be using raw i/o, so clear the buffer first */
    flush_fdump_buffer();

    if (lseek(out_som_fd, 0, 0) == -1)
	system_error(CANT_SEEK_IN, output_name , 0);

    while (length > 0) {
        chunk = (length > 512) ? 512 : length;
        if (read (out_som_fd, (void *) som_buf, chunk) != chunk)
	    external_error(CANT_READ_FL, output_name , 0);
        p = som_buf;
        for (i = 0;  i < chunk; i += sizeof(int))
	    cksum += *p++;
        length -= chunk;
	}
    /* Clear remembered filofs in fdump since we used read() directly */
    clear_oldfilofs();

    return (-cksum);

}   /* End ipl_checksum */

/*
** build hp-ux aux header, should be called when init pointers have 
** been built.
*/
void bd_hp_ux_header()
{
    int	   i, b_flag = FALSE;
    int    size = 0, bsize = 0;
#ifndef ESOM
    struct init_pointer_record	    *init_array_start;
#else
    struct cnx_init_pointer_record  *init_array_start;

    /* build esom option header */
    bd_esom_header();
#endif

    hp_ux_header.som_auxhdr.mandatory = FALSE;
    hp_ux_header.som_auxhdr.copy = FALSE;
    hp_ux_header.som_auxhdr.append = FALSE;
    hp_ux_header.som_auxhdr.ignore = TRUE;
    hp_ux_header.som_auxhdr.reserved = 0;
    hp_ux_header.som_auxhdr.type = HPUX_AUX_ID;
    hp_ux_header.som_auxhdr.length = sizeof(struct som_exec_auxhdr) -
			             sizeof(struct aux_id);
#if 0
    hp_osf_header.som_auxhdr.type = HPOSF_AUX_ID;
    hp_osf_header.som_auxhdr.length = sizeof(struct hposf_auxhdr) -
			              sizeof(struct aux_id);
#endif /* 0 */

    init_array_start = &init_array[0]; /* get the 1st init ptr */
    if ((init_array_start->access_control_bits >= CODE_TYPE) &&
            (init_array_start->access_control_bits <= LAST_VALID_TYPE)) {
        hp_ux_header.exec_tfile = init_array_start->file_loc_init_value;
        hp_ux_header.exec_tmem  = init_array_start->space_offset;
        }
    else
	/* for embedded systems init ptr does not have to be code */
	; /* external_error(FRST_INIT_PTR_NOT_CODE , 0); */

    /* compute the size of code (text size) */
    for (i = 0; i < init_array_size; i++) {
        /* ASSUME all code subspaces are consecutive */
        if ((init_array_start->access_control_bits >= CODE_TYPE) &&
               (init_array_start->access_control_bits <= LAST_VALID_TYPE)) {
            size = (init_array_start->file_loc_init_value
	             + init_array_start->initialization_length)
	             - hp_ux_header.exec_tfile;
            }
	else
            break;
        init_array_start++;
        }
    hp_ux_header.exec_tsize = size;

    /*
    **  reset pointer to the begining of init ptr and do the
    **  same for data
    */

    init_array_start = init_array;
    for (i = 0; i < init_array_size; i++) {
        /* find the 1st init pointer of data type */
        if ((init_array_start->access_control_bits >= FIRST_DATA_TYPE) &&
                (init_array_start->access_control_bits <= LAST_DATA_TYPE)) {
            b_flag = TRUE;
            break;
    	} else
            init_array_start++;
    }

    if (b_flag) { /* prevent run off when no data subsp exists */
        hp_ux_header.exec_dfile = init_array_start->file_loc_init_value;
        hp_ux_header.exec_dmem  = init_array_start->space_offset;
	if (do_private_unpadding) {
	   /*
	   ** round exec_dfile down to a page boundary for the case that
	   ** the padding before $PRIVATE$ has been removed.
	   */
	   hp_ux_header.exec_dfile &= ~(page_size - 1);
	   hp_ux_header.exec_dmem &= ~(page_size - 1);
	} /* if do_private_unpadding */
    } else {
        /*
	** dmem is NOT set to zero when there is no data to workaround a 
	** problem found in a 7.0 system. When the a.out is read over an 
	** nfs mount on a 7.0 system and the value is 0 the system will 
	** crash! Later systems do not exhibit this behaviour. This 
        ** workaround is included because embedded systems users are more 
        ** than likely to run into the problem 
        */
     	hp_ux_header.exec_dfile = 0;
     	hp_ux_header.exec_dmem = data_mmap_addr;
    }

    /* calculate dsize and bsize */
    size = bsize = 0;
    b_flag = FALSE;
    init_array_start = &init_array[0];

    for (i = 0; i < init_array_size; i++) {
        if ((init_array_start->access_control_bits >= FIRST_DATA_TYPE) &&
                (init_array_start->access_control_bits <= LAST_DATA_TYPE)) {
            /*
            ** ASSUME initialized data are allocated before 
	    ** uninitialized data
            */
            if (init_array_start->has_data == FALSE) {
	        b_flag = TRUE;
                bsize = init_array_start->space_offset;
                break;
    	    } else
	        size = init_array_start->space_offset +
			    init_array_start->initialization_length -
			    hp_ux_header.exec_dmem;
        }
        init_array_start++;
    }

    if (b_flag) { /* there exists uninitialized data subsp */
        hp_ux_header.exec_dsize = bsize - hp_ux_header.exec_dmem;
        hp_ux_header.exec_bsize =
                       init_array[init_array_size - 1].space_offset +
                       init_array[init_array_size - 1].initialization_length
       	               - bsize;
    } else {
        hp_ux_header.exec_dsize = size;
        hp_ux_header.exec_bsize = 0;
    }
#if 0
    /* bmem should always equal dmem + dsize, even if bsize is 0 */
    hp_osf_header.bmem = hp_osf_header.dmem + hp_osf_header.dsize;
#endif /* 0 */

#ifdef ESOM
    if ( esom_onenode ) {
	/*
	 * we are a one node parallel executable, so mapped all far and
	 * near shared memory regions to node private.
	 */
	init_array_start = init_array;
	for (i = 0; i < init_array_size; i++) {
	    if ( init_array_start->memory_type == CNX_INIT_FAR ||
		init_array_start->memory_type == CNX_INIT_NEAR )
		init_array_start->memory_type = CNX_INIT_NODE;
	}
    }
#endif /* ESOM */

    if (entry_symbol_index != BAD_SYM)
        hp_ux_header.exec_entry = symbol_value(entry_symbol_index);
    else 
	if (!building_shlib)
            user_error(ENTRY_SYM_NOT_FND, entry_name, 0);

    /*
    ** HP-UX aux header exec_flags field:
    **   bit 31 - trap nil pointers
    **   bit 30 - external millicode (never implemented on HP-UX)
    **   bit 29 - dynamically linked (incomplete) executable
    **   bit 28 - executable built with the aid of profile information
    **
    **   bits 25-27 - instruction page size field:
    **   bits 22-24 - instruction page size field:
    **      0:4k  1:16k  2:64k  3:256k  4:1M  5:4M  6:16M  7:64M
    **
    **   bit 21 - static branch prediction recommended for this load image
    **
    **   all other bits initialized to 0 and reserved
    */

    hp_ux_header.exec_flags = 0;
    if (trap_nil_ptrs) 
        hp_ux_header.exec_flags |= 0x1;
    if (building_incomp_exec)
        hp_ux_header.exec_flags |= 0x4;

    if (ld_after_be_process && do_fdp_position)
       hp_ux_header.exec_flags |= 0x8;

    
    /* set page sizes, checking that values do not overflow into other fields */
#ifndef SPP_UX
    /*  This #ifdef will need to go when we comply
     *		     with HP-UX page size directives */
    /* changed width from 3 to 4 */
    assert(inst_page_size >> 4 == 0);
    assert(data_page_size >> 4 == 0);
#else
    assert(inst_page_size >> 3 == 0);
    assert(data_page_size >> 3 == 0);
#endif /* SPP_UX */
    hp_ux_header.exec_flags |= (inst_page_size << 4);
#ifndef SPP_UX
    /*  See above */
    /* changed shift count from 7 to 11 */
    hp_ux_header.exec_flags |= (data_page_size << 11);
#else
    hp_ux_header.exec_flags |= (data_page_size << 7);
#endif /* SPP_UX */

    /* Set the (new) bit to use the PA2.0 static branch prediction convention.*/
    if (staticbranch)
       hp_ux_header.exec_flags |= 0x400;

    hp_ux_header.exec_bfill	= 0;
#ifdef UNPAD_SL_POST_11_0
    if (building_shlib || building_incomp_exec) {
       hp_ux_header.text_offset = unpad_after_header;
    } else {
       hp_ux_header.text_offset = 0;
    }
    assert(   !do_text_unpadding
           || unpad_after_header 
	      ==   Subsp_Misc(shlib_info_subsp_index).exec_file_offset 
	         - hp_ux_header.exec_tfile);
#endif
#ifdef UNPAD_SL
    if (unpad_after_header) {
	/* Set bit 12 - TRUE if dl_header is offset from the mapped start 
	** of text.
	*/
	hp_ux_header.exec_flags |= (1 << (31 - 12));
    }
#endif

#if 0
    hp_osf_header.sfile = 0;
    hp_osf_header.ssize = 0;
    if (O_S == OS_HPOSF) {
	/* fill in fields only defined on OSF - complete a.outs on HP-UX
         				may not have unwind subsps defined. */
	hp_osf_header.ufile = Subsp_Misc(unwind_subsp).exec_file_offset;
	hp_osf_header.usize = Subsp_Misc(unwind_end_subsp).new_subspace_start -
                              Subsp_Misc(unwind_subsp).new_subspace_start;
	}
#endif /* 0 */
} /* end bd_hp_ux_header */

#if 0
void bd_hp_ux_header()
/* build hp-ux aux header, should be called when init pointers have */
/* been built.                                                     */
    {

    /* since osf header is a superset of hpux header, fill it in and 	*/
    /* then copy fields over. Want to avoid multiple copies of code	*/
    /* to help maintenance.						*/

    bd_hp_osf_header();

    hp_ux_header.som_auxhdr.mandatory = FALSE;
    hp_ux_header.som_auxhdr.copy = FALSE;
    hp_ux_header.som_auxhdr.append = FALSE;
    hp_ux_header.som_auxhdr.ignore = TRUE;
    hp_ux_header.som_auxhdr.reserved = 0;
    hp_ux_header.som_auxhdr.type = HPUX_AUX_ID;
    hp_ux_header.som_auxhdr.length = sizeof(struct som_exec_auxhdr) -
			             sizeof(struct aux_id);

    hp_ux_header.exec_tsize	= hp_osf_header.tsize;
    hp_ux_header.exec_tmem	= hp_osf_header.tmem;
    hp_ux_header.exec_tfile	= hp_osf_header.tfile;
    hp_ux_header.exec_dsize	= hp_osf_header.dsize;	
    hp_ux_header.exec_dmem	= hp_osf_header.dmem;
    hp_ux_header.exec_dfile	= hp_osf_header.dfile;
    hp_ux_header.exec_bsize	= hp_osf_header.bsize;
    hp_ux_header.exec_entry	= hp_osf_header.entry;
    hp_ux_header.exec_flags	= hp_osf_header.flags;
    hp_ux_header.exec_bfill	= 0;

} /* end bd_hp_ux_header */

#endif /* 0 */

char unw_start[] = UNWIND_START,
     unw_end[] = UNWIND_END,
     rcv_start[] = RECOVER_START,
     rcv_end[] = RECOVER_END;

static int lookup_univ_code_sym(name)
char *name;  /* name to be looked up */

/* look up a global code symbol and return its address.  used for 
   unwind/recover entries in headers.  */
{
    int ind, hashval;
    hashval = hash_string(name);
    ind = univ_find(name,0,0,hashval,ST_CODE);

    if (ind != BAD_SYM)
        return(symbol_value(ind));
    else
        return(0);
}  /* end lookup_univ_code_sym */

void bd_new_hpe_header()
{

    new_hpe_header.header_id.mandatory = FALSE;
    new_hpe_header.header_id.copy = FALSE;
    new_hpe_header.header_id.append = FALSE;
    new_hpe_header.header_id.ignore = TRUE;
    new_hpe_header.header_id.reserved = 0;
    new_hpe_header.header_id.type = MPE_SOM_AUX_ID;
    new_hpe_header.header_id.length = sizeof(struct mpe_som_aux_hdr) -
				   sizeof(struct aux_id);

    new_hpe_header.reserved = FALSE;
    new_hpe_header.shared_data = 0;
    new_hpe_header.thread_private = (thread_private ? 1 : 0); 
    new_hpe_header.dumpworthy = (dumpworthy ? 1 : 0);
    new_hpe_header.hpe_som = (hpe_som ? 1 : 0);
    new_hpe_header.system_som = (system_som ? 1 : 0);
    /* num_xrts = number of xrt allocated including xrt0 */
    new_hpe_header.num_xrts = next_xrt;

    /* find unwind start/end, recover start/end */
    new_hpe_header.unwind_start = lookup_univ_code_sym(unw_start);
    new_hpe_header.unwind_end = lookup_univ_code_sym(unw_end);
    new_hpe_header.recover_start = lookup_univ_code_sym(rcv_start);
    new_hpe_header.recover_end = lookup_univ_code_sym(rcv_end);

    new_hpe_header.num_dxrts = 0;
    new_hpe_header.data_imports = 0;
    new_hpe_header.data_exports = 0;

} /*end bd_new_hpe_header*/

void bd_ld_footprint_header()
/* build linker footprint aux header. If the input files contained 
   linker footprints (if input file is the result of -r link) then 
   there will be multiple linker footprints in the output. Use the time 
   stamp to differentiate among them. */
   
{
    extern char *PRODUCT_ID;
    extern char *LD_VERSION;
    char *dest_ptr;
    char *src_ptr;
    int count;

    ld_aux_header.header_id.mandatory = TRUE;
    ld_aux_header.header_id.copy = FALSE;
    ld_aux_header.header_id.append = FALSE;
    ld_aux_header.header_id.ignore = FALSE;
    ld_aux_header.header_id.reserved = 0;
    ld_aux_header.header_id.type = LINKER_AUX_ID;
    ld_aux_header.header_id.length = sizeof(struct linker_footprint) -
			          sizeof(struct aux_id);

    dest_ptr = ld_aux_header.product_id;
    src_ptr = PRODUCT_ID;
    src_ptr += 4;
    for (count = 0; count < 8; count++) 
 	 *dest_ptr++ = *src_ptr++;
    src_ptr = LD_VERSION;
    *dest_ptr++ = *src_ptr;
    *dest_ptr = 0;

    dest_ptr = ld_aux_header.version_id;
    src_ptr += 1;
    while (*src_ptr) {
	*dest_ptr++ = *(++src_ptr);
    } 
    ld_aux_header.htime.secs = time((long *) 0);
    ld_aux_header.htime.nanosecs = 0;

} /* end bd_ld_footprint_header */

void bd_product_specific_header()
/* build product_specific aux header. */
{
    product_aux_header = (struct product_specific_aux_hdr *) emalloc
			 (sizeof(struct aux_id) + product_key_size);

    product_aux_header->header_id.mandatory = TRUE;
    product_aux_header->header_id.copy = FALSE;
    product_aux_header->header_id.append = FALSE;
    product_aux_header->header_id.ignore = FALSE;
    product_aux_header->header_id.reserved = 0;
    product_aux_header->header_id.type = PRODUCT_SPECIFIC_AUX_ID; 
    product_aux_header->header_id.length = product_key_size; 

    memcpy((char *)product_aux_header->key, 
	   (char *)product_key, 
	   product_key_size);

} /* end bd_product_specific_header */

void out_new_hpe_header(header_loc)
int    header_loc;
/* copy aux. header records to output som                            */
{
    fdump(out_som_fd,header_loc,&new_hpe_header,
			sizeof(struct mpe_som_aux_hdr),1);
}/* end out_new_hpe_header */

void out_som_header(header_loc)
int    header_loc;
/* copy som header to output som  */
{
    int el_bits;

    new_som_header.a_magic = magic_number;
    if (dollar_global != BAD_SYM) {
	/* complete and incomplete a.out's */
	new_som_header.presumed_dp = symbol_value(dollar_global);
	/* $global$ isn't at 0x40000000 any more - get actual value */
    }

    if (relocatable || !strip_fixups)
        new_som_header.version_id = NEW_VERSION_ID;
    else
        new_som_header.version_id = VERSION_ID;
    new_som_header.file_time.secs = 0;
    new_som_header.file_time.nanosecs = 0;
    if (entry_symbol_index != BAD_SYM) {
	el_bits = Sym_Dict(entry_symbol_index).symbol_value & 03;
	new_som_header.entry_offset =
        	    symbol_value(entry_symbol_index) | el_bits;
    } else {
	if (!relocatable) {
	    if (alloc_stubs_xl || alloc_stubs_ux)
		new_som_header.entry_offset = -1;
	    else
		user_error(ENTRY_SYM_NOT_FND , entry_name, 0);
	}
	new_som_header.entry_offset = 0;
    }
    new_som_header.checksum =
		checksum(&new_som_header, sizeof(new_som_header));
    fdump(out_som_fd, header_loc,&new_som_header,sizeof(struct header),1);
} /* end out_som_header */

void out_ipl_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy ipl header records to output som                            */
{
    fdump(out_som_fd,header_loc,&ipl_header,
			sizeof(struct ipl_aux_hdr),1);
}/* end out_ipl_header */

#if 0
void out_osf_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy aux. header records to output som                            */
    {
    fdump(out_som_fd,header_loc,&hp_osf_header,
			sizeof(struct hposf_auxhdr),1);
    }/* end out_osf_header */
#endif /* 0 */

void out_ux_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy aux. header records to output som                            */
{
    fdump(out_som_fd,header_loc,&hp_ux_header,
			sizeof(struct som_exec_auxhdr),1);
#ifdef ESOM
    /* dump the esom option header, it needs to be after the som exec header */
    fdump(out_som_fd,header_loc+sizeof(struct som_exec_auxhdr), opt_hdr,
	  sizeof(struct cnx_option_header),1);
#endif /* ESOM */
}/* end out_ux_header */

void out_ld_footprint_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy aux. header records to output som                            */
{
    fdump(out_som_fd,header_loc,&ld_aux_header,
			sizeof(struct linker_footprint),1);
}/* end out_ld_footprint_header */

void out_product_specific_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy aux. header records to output som                            */
{
    fdump(out_som_fd,header_loc,(char *)product_aux_header,
			sizeof(struct aux_id) + product_key_size,1);
}/* end out_product_specific_header */

void out_user_header(header_loc)
int    header_loc;
{
    struct header_node *usr, *next;

    /* traverse the list of aux headers, writing them out */
    for (usr = aux_header_head; usr != NULL; usr = next) {
	fdump(out_som_fd, header_loc, usr+1, 1, usr->size);
	header_loc += usr->size;
	next = usr->next;
	efree(usr);
	}
    aux_header_head = aux_header_tail = 0;
} /* end out_user_header */

void out_compunit_records()
{
    int    comp_dict_loc = new_som_header.compiler_location;
    struct header_node *comp_area, *next;

    /* traverse the list of compilation unit records, writing them out */
    for (comp_area = compiler_head; comp_area != NULL; comp_area = next) {
	fdump(out_som_fd, comp_dict_loc, comp_area+1,
				1, comp_area->size);
	comp_dict_loc += comp_area->size;
	next = comp_area->next;
	efree(comp_area);
	}
    compiler_head = compiler_tail = 0;
} /* end out_compunit_records */

void out_space_records(header_loc)
int    header_loc;
/* update space total and space loc in som header then   */
/* copy space_records to output som                      */
{
    struct space_dictionary_record space;
    int new_sp_index, x;

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	x = sp_remap[new_sp_index];

	/* doom support */
        if (!strip_debug && lm_should_skip_space(x))
           continue;
        else
        /* if strip or fake space or useless space */
/*  No longer generate PA annotation. */
#ifdef WW_ANNOTATIONS_REMOVED
	if ((strip_debug && !space_array[x].is_loadable &&
	    strcmp(space_array[x].name.n_name,"$ANS$")) ||
#else /* WW_ANNOTATIONS */
	if ((strip_debug && !space_array[x].is_loadable) ||
#endif /* WW_ANNOTATIONS */
	    ((space_array[x].subspace_quantity == 0) &&
	          (space_array[x].loader_fix_quantity == 0) &&
	          (space_array[x].init_pointer_quantity == 0)))
            continue;
	space = space_array[x];
	space.STR_INDEX = string_offset_linear(space_array[x].NAME_PT,
					       &space_strings);
	space.subspace_index = tmp_space_misc[x].new_sub_index;
	space.subspace_quantity = tmp_space_misc[x].new_sub_quantity;

	fdump(out_som_fd, header_loc, &space, sizeof(space), 1);
	header_loc += sizeof(space);
					
	}
} /* end out_space_record */

void out_init_array(header_loc)
int    header_loc;
/* copy init pointers to output som                    */
{
#ifndef ESOM
    fdump(out_som_fd,header_loc,init_array,
	  sizeof(struct init_pointer_record),init_array_size);
#else
    char *s;

    if ( esom_object ) {
    	fdump(out_som_fd,header_loc,init_array,
	      sizeof(struct cnx_init_pointer_record),init_array_size);
    }
    else {
    	s = ecalloc(init_array_size, sizeof(struct init_pointer_record));
    	esom2som_init_array(init_array, s, init_array_size);
    	fdump(out_som_fd,header_loc,s,
	      sizeof(struct init_pointer_record),init_array_size);
    }
#endif /* ESOM */
} /* end out_init_array */

union copyram_desc *c_table = NULL;    /* used for copyram */

void out_subsp_records(header_loc)
int    header_loc;
/* update subspace total and subspace loc in som header then   */
/* copy subspace_records to output som                         */
{
    void print_map();
    /* embedded systems routine */
    void print_embed_symbol_map();
    int	    temp_index = -1;
    int    fixup_index = 0, new_sub_index = 0,
	    sub_quan;
    int    new_sp_index, sp_index, num_subsp, subsp_index, old_index;
    int    out_sp_index;
    struct subspace_dictionary_record	    *tt,
					    *prev_subsp, *cur_subsp;
    struct subsp_misc_record	    *prev_misc, *cur_misc;
    extern void dump_subsp();
    extern void dump_space();
    /* Embedded systems code */
    extern void add_subsp_to_map();
    Boolean out_subs_seen = FALSE;

    union copyram_desc *this_entry;    /* used for copyram */
    unsigned int this_entry_start;
    Boolean copyram_space = FALSE;
    Boolean prev_subsp_has_compression = FALSE;
    unsigned int temp_subsp_start;      /* save orig for copyram */
    unsigned int temp_subsp_len;        /* save orig for copyram */
    int rom_sp_index = 0;               /* fake spaces index */
    int zero_subsp_adjust = 0;          /* zero len subsp's alignment */

    int ind, hashval;
    extern unsigned int hash_string();
    extern int univ_find();


    /* create an temp subsp array to compress all subspaces */
    /* with the same attributes                             */
    if (temp_sub != NULL)
	efree(temp_sub);
    temp_sub = (struct subspace_dictionary_record *)
                emalloc(new_subsp_dict_size *
			 sizeof(struct subspace_dictionary_record));

    /* create a tmp_space_misc array to store new subsp index */
    /* and subsp quantity for later use                   */
    if (tmp_space_misc != NULL)
        efree(tmp_space_misc);
    tmp_space_misc = (struct tmp_space_misc_record *)
			 emalloc(cur_space_total *
			 sizeof(struct tmp_space_misc_record));

    /* create an temp copyram table to be filled in by this routine as */
    /* well as out_subsp_data if a subsp has compression (zeroes fixups) */
    if (c_table != NULL)
	efree(c_table);
    if (copyram_count != 0) {
        c_table = (union copyram_desc *)
                ecalloc(1, copyram_count * sizeof(union copyram_desc));
	}
    else 
	c_table = NULL;
    this_entry = c_table;
    copyram_space = FALSE;


    if (verbose & V_DEBUG)
        printf(ld_gets(1, 1177, "out_subsp_records:\n"));

    out_sp_index = -1;      /* 1st space will be 0 */

    /* for each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
        /* Embedded systems code */
        if (space_misc[sp_index].copyram_needed) {
	    /* init to zero the last zero len subspace's align */
	    zero_subsp_adjust = 0;
        }

	/* doom support */
        if (!strip_debug && lm_should_skip_space(sp_index))
              continue;
        else
/*   No longer generate PA annotation. */
#ifdef WW_ANNOTATIONS_REMOVED
	if ((strip_debug && !space_array[sp_index].is_loadable &&
	     strcmp(space_array[sp_index].name.n_name,"$ANS$")) ||
#else /* WW_ANNOTATIONS */
	if ((strip_debug && !space_array[sp_index].is_loadable) ||
#endif /* WW_ANNOTATIONS */
	    ((space_array[sp_index].subspace_quantity == 0) &&
	         (space_array[sp_index].loader_fix_quantity == 0) &&
	         (space_array[sp_index].init_pointer_quantity == 0)))
            continue;

	subsp_index = space_array[sp_index].subspace_index;
	num_subsp = space_array[sp_index].subspace_quantity;

	/* next output space number is...*/
	out_sp_index++;

        if (space_misc[sp_index].copyram_needed && (num_subsp > 0)) {
            copyram_space = TRUE;
	    prev_subsp_has_compression = FALSE;
            this_entry_start = 
		Subsp_Misc(Subsp_Misc(subsp_index).r_n_x).rom_subspace_start;
	    this_entry->space_entry.addr = this_entry_start;
	    ++this_entry;
	    this_entry->space_entry.addr = space_misc[sp_index].ram_location;
	    ++this_entry;   /* go to next entry */

	} else { 
            copyram_space = FALSE;
        } 

	if (verbose & V_DEBUG) 
            dump_space(sp_index);

        /* Embedded systems code */
	if (embed_subsp_map) {
	    out_subs_seen = FALSE;
	    start_new_space_map(sp_index, out_sp_index);
        }

	/* For each of its subspaces */
	prev_subsp = NULL;
	prev_misc = NULL;
	sub_quan = 0;
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    cur_subsp = &Subsp_Dict(old_index);
	    cur_misc = &Subsp_Misc(old_index);

#ifdef TSD /* TSD */
	    /*  If relocatable, don't touch length 
	    ** Reset code_only bit that we overloaded
            ** when we did a -r link on a file that was subsequently linked
            ** without -r.  
            */
	    if (cur_subsp->is_tspecific && !relocatable) {
               cur_subsp->subspace_length = tbss_size;
	       cur_subsp->code_only = 0;
#ifdef DEBUG /* DEBUG */
	       if (verbose & V_TSD) {
	          printf("tbss subsp idx: %d size: %d\n", old_index, 
			 tbss_size); 
	       }
#endif /* DEBUG */
	    }
#endif /* TSD */

            /* if FRU RELINK subspace, then we know a priori we need it */
            if (old_index < fru_subsp_count)
                goto NEED_NEW_SUBSPACE;
            /* Embedded systems code */
	    if (copyram_space && prev_subsp_has_compression) {
		/* Start a new entry, take into account any subspaces */
		/* we have seen which had no length but did include */
		/* an alignment (adjustment) */
		prev_subsp_has_compression = FALSE;
	        this_entry_start = cur_misc->rom_subspace_start;
				    /*- cur_misc->rom_subsp_adjustment; */
	    }

            /* 
            ** If misc->delete_subspace bit is set, do not output the
            ** subspace.  For this will always be set for
            ** a zero-length $LINES$ subspace.
            */
            if (cur_misc->delete_subspace) 
                continue;

	    /* doom support */
	    if (lm_should_skip_subspace(old_index)) {
	       continue;
            }

	    /*
	     * ignore delete comdat subspaces 
	     */

	    if (cur_subsp->is_comdat && cur_misc->comdat_nulled)
	        continue;

	    /* eliminate empty subspaces */
            /* Part of this if is embedded systems code */

	    if (cur_subsp->subspace_length == 0 &&
		    cur_misc->symbol_count == 0 &&
		    cur_subsp->is_loadable &&
		    !relocatable &&
		    (cur_misc->input_subsp_only != 2) &&
		    (cur_misc->rom_subsp_adjustment == 0) &&
		    (cur_misc->copyram_index == -1))

                 continue;

            /*
            ** If doing ld -r with dupe common symbols,
            ** do NOT output more than one subspace--only output the first
            ** one.  We will explicitly set subspace_length, symbol_count,
            ** init length, fixup_request_quantity to zero in 
            ** delete_dup_common() in subspaces.c so we can check for these
            ** conditions when determining if we can omit dumping the subspace
            ** to the output file.
            **
	    */
            if (relocatable &&
                cur_subsp->subspace_length == 0 &&
                cur_subsp->initialization_length == 0 &&
                cur_subsp->dup_common &&
                cur_subsp->fixup_request_quantity == 0 &&
                cur_misc->symbol_count == 0) 
                continue;

	    /* eliminate overlayed common block initializations */
	    if (cur_misc->first_common_def != -1)
		continue;

	    if (need_new_subsp(prev_subsp, cur_subsp, prev_misc, cur_misc)) {
               NEED_NEW_SUBSPACE:
		if (verbose & V_DEBUG) 
		    /* arg3 of dump_sp should not be localized */
		    dump_subsp(cur_subsp, cur_misc, "new"); 
                /* Embedded systems code */
		if (embed_subsp_map) {
		    /* dump last out sub */
		    if (out_subs_seen && 
			       temp_sub[temp_index].subspace_length != 0) {
		        add_subsp_to_map(temp_sub[temp_index], NULL, "new"); 
		    }
		    /*
		    ** make output subsp entry.  Arg3 should not be localized
		    */
		    add_subsp_to_map(cur_subsp, cur_misc, "new"); 
		    /* dump as input subsp */
		    add_subsp_to_map(cur_subsp, cur_misc, "ext"); 
		    out_subs_seen = TRUE;
		}

		/* add new subsp to temp_sub */
		tt = &temp_sub[++temp_index];
		if (temp_index >= new_subsp_dict_size)
		    internal_error(WRNG_NUM_SUBSPS, 0);

#ifdef CNX_TOOLS
               if (CNX_SUBSPACE_MAP_subsp_index != BAD_SUBSP)
                  cnx_subspace_map_add(out_sp_index, temp_index, 
                                     cur_subsp, cur_misc);
#endif /* CNX_TOOLS */

		*tt = *cur_subsp;
		tt->subspace_start = cur_misc->new_subspace_start;
		tt->space_index = out_sp_index;
		if (cur_misc->stubs_file_loc != 0) {
		    tt->file_loc_init_value = cur_misc->stubs_file_loc;
		    if (!relocatable) {
                        if (space_misc[sp_index].copyram_needed) 
			    tt->initialization_length = 
						 cur_misc->rom_subsp_length;
			else 
			    tt->initialization_length = tt->subspace_length;
		    }
		}
		tt->fixup_request_index = fixup_index;
		
		/*
		**  We need to remove the is_comdat bit if it
		**              is set. It may mess up dld or the 
		**              debugger
		*/

		if (!relocatable)  {
		    tt->fixup_request_quantity = cur_misc->abs_fixup_count;

		    if (tt->is_comdat) {
			tt->is_comdat = 0;
		    }
		}
		sub_quan++;
		if (verbose & V_DEBUG)
		    /* dump_subsp(tt, NULL, "   ")*/; 
	    } else {  /* extend length of current subsp record */
	        /* and update fixup quantity             */
#ifdef TSD /* TSD */
                /* should never have to extend a $TBSS$ subspace 
                ** Now have to extend $TBSS$ for commons
		** Don't touch if relocatable and tls
                */
	        if (cur_subsp->is_tspecific && !relocatable) {
		   /* r_c_x is now assigned in count_subspaces, verify here */
                   assert(cur_misc->r_c_x == temp_index);
                   continue;
	        }
#endif /* TSD */
		if (verbose & V_DEBUG)
		    dump_subsp(cur_subsp, cur_misc, "ext");
                /* Embedded systems code */
		if (embed_subsp_map)
		    add_subsp_to_map(cur_subsp, cur_misc, "ext");

		tt = &temp_sub[temp_index];

#ifdef CNX_TOOLS
               if (CNX_SUBSPACE_MAP_subsp_index != BAD_SUBSP)
                  cnx_subspace_map_add(out_sp_index, temp_index, 
                                     cur_subsp, cur_misc);
#endif /* CNX_TOOLS */

    		if (cur_subsp->subspace_length != 0) {
    		    if (tt->subspace_length == 0) {
    		        /* if previous subsp len = 0 then */
		        /* use this definition */
		        tt->subspace_start =
			           cur_misc->new_subspace_start;
		        tt->subspace_length =
			           cur_subsp->subspace_length;

			/* we just redid the tt subspace; adjust the map! */
		        if (embed_subsp_map)
	                    add_subsp_to_map(cur_subsp, cur_misc, "redo"); 
		    } else
		        tt->subspace_length =
			           cur_misc->new_subspace_start +
			           cur_subsp->subspace_length -
			           tt->subspace_start;
		}

		if (relocatable)
		    tt->initialization_length +=
				    cur_subsp->initialization_length;
	      	else if (cur_misc->stubs_file_loc != 0) {
		    /* subspace has initialization */
		    if (tt->initialization_length == 0) {
                        tt->file_loc_init_value =
                                        cur_misc->stubs_file_loc;
                    }
		    if (space_misc[sp_index].copyram_needed) {
			/* Copyram'd subspaces get length of init data */
			/* Instead of the full length of the subspace */
		        tt->initialization_length += 
                               cur_misc->rom_subsp_length +
                               cur_misc->rom_subsp_adjustment;
		    } else
		        tt->initialization_length = tt->subspace_length;
		}
		if (relocatable)
		    tt->fixup_request_quantity +=
				    cur_subsp->fixup_request_quantity;
		else
		    tt->fixup_request_quantity +=
				    cur_misc->abs_fixup_count;
		if (verbose & V_DEBUG)
		    /* dump_subsp(tt, NULL, "   ")*/; 
	    }

            /* Embedded systems code */
	    if (copyram_space) {
		if (verbose & V_DEBUG)
		    printf(
		           ld_gets(1, 
				   1178, 
				   "%s: r_adj=0x%d st,l=0x%x %x "
				       "thisest=0x%x s=%x\n"),
			   cur_subsp->name.n_name,
			   cur_misc->rom_subsp_adjustment,
			   cur_misc->new_subspace_start,
			   cur_subsp->subspace_length,
                           this_entry_start, this_entry->size_entry.size);

		if (cur_misc->copyram_index != -1) {
		    /* this subsp has zeroes fixups - use new entry */
		    /* this_entry += cur_misc->num_copyram_entries_needed; */

		    /* set 1st entry for subspaces with zeroes fixups to */
		    /* the alignment used in the ram space */
		    /*this_entry++;*/
		    this_entry->size_entry.size += 
				   cur_misc->rom_subsp_adjustment;

                    /* skip the rest of the entries */
		    this_entry += cur_misc->copyram_count; 
		    /* this_entry = &c_table[cur_misc->copyram_index]; */
		    /* Start next entry after this whole subspace */
		    prev_subsp_has_compression = TRUE;
		    }
		else {      /* this subsp has NO compression */
		    /* This subsp looks just like BSS, make an entry for it*/
		    /* if ((cur_subsp->subspace_length > 0) && 
			(cur_subsp->initialization_length == 0) || */
		    if ((cur_misc->stubs_file_loc == 0)) {
			/* found an unitialized subspace */

                        /* see if we can reclaim the last entry */
			/* if subsp len is 0 don't bother touching the entry */
			if (cur_subsp->subspace_length != 0 || 
			       (cur_subsp->subspace_length != 0 && 
			   		    zero_subsp_adjust != 0)) {

			    if ((!this_entry->size_entry.initialize) &&
			        (this_entry->size_entry.size != 0)) {
			         /* go to next entry */
			        this_entry_start += 
				  this_entry->size_entry.size;
		                this_entry++;
			    }
		            this_entry->size_entry.size += 
                                 /*  cur_misc->new_subspace_start + */
                                   cur_misc->rom_subsp_adjustment + 
				   zero_subsp_adjust +
                                   cur_subsp->subspace_length; /* -
                                   this_entry_start; */
		            this_entry->size_entry.initialize = TRUE;

                            /* reset since it was just added in */
			    zero_subsp_adjust = 0;

			    /* this_entry++; */   /* go to entry after */
        
			    /* reset this_entry_start on next sub */
		            /* prev_subsp_has_compression = TRUE; */
		            /*this_entry_start+= this_entry->size_entry.size; */
			} else {
			    /* this is a zero len subsp with an adjustment */
			    /* save it till the next subsp with length */
			    zero_subsp_adjust += 
			      cur_misc->rom_subsp_adjustment;
			}
 		    } else {
			if (this_entry->size_entry.initialize) {
			    this_entry++;    /* go to next entry */
		            this_entry_start += this_entry->size_entry.size;
			}
			    
		        this_entry->size_entry.size += 
                                   /* cur_misc->rom_subspace_start + */
                                   cur_misc->rom_subsp_adjustment + 
                                   cur_misc->rom_subsp_length; /* -
                                   this_entry_start; */
		    }
                }
	    }

	    /* r_c_x is now assigned in count_subspaces, verify here */
	    assert (cur_misc->r_c_x == temp_index);
	    prev_subsp = cur_subsp;
	    prev_misc = cur_misc;
	    if (relocatable)
	        fixup_index += cur_subsp->fixup_request_quantity;
	    else
	        fixup_index += cur_misc->abs_fixup_count;

	}

        tmp_space_misc[sp_index].new_sub_index = new_sub_index;
        tmp_space_misc[sp_index].new_sub_quantity = sub_quan;
	new_sub_index += sub_quan;

        /* Embedded systems code */
        if (copyram_space) {
            /* write out ending entry for this space */
	    ++this_entry;                  /* advance to next entry */
            this_entry->space_entry.addr = 0;   /* place end marker down */
	    ++this_entry;                  /* advance to next entry */
            copyram_space = FALSE;         /* reset for next pass */
        }
        if (verbose & V_DEBUG) 
            dump_subsp(temp_sub[temp_index], NULL, "new"); 
        /* Embedded systems code */
	if (embed_subsp_map) {
	    if (out_subs_seen &&
		       temp_sub[temp_index].subspace_length != 0) {
	        add_subsp_to_map(temp_sub[temp_index], NULL, "new"); 
	    }
           
            dump_map(sp_index);
	}
    }  /* loop over spaces */

    /* Embedded systems code */
    if (c_table != NULL) { 
	/* adjust copyram_end symbol to signify there is a table */
        hashval = hash_string(END_COPYRAM_SYMBOL);
        ind = univ_find(END_COPYRAM_SYMBOL, 0, 0, hashval, ST_NULL);
        if (ind != BAD_SYM)
            Sym_Dict(ind).symbol_value += copyram_count * 
                                             sizeof(union copyram_desc);
        /* else no copyram end symbol */
    }

#ifdef CNX_TOOLS
    if (verbose & V_DEBUG) {
       if (CNX_SUBSPACE_MAP_subsp_index != BAD_SUBSP)
          printf("subspace map actual entries = %d\n", 
               cnx_subspace_map_header->entries);
       }
#endif /* CNX_TOOLS */

    /* print map if asked */
    if (map)
        print_map(temp_sub);

    /* Embedded systems code */
    if (embed_sym_map)
        print_embed_symbol_map(temp_sub);

    /* relocate the string pointers */
    for (subsp_index = 0; subsp_index < new_sub_index; subsp_index++) {
        cur_subsp = &temp_sub[subsp_index];
        cur_subsp->STR_INDEX = string_offset_linear(cur_subsp->NAME_PT, 
						    &space_strings);
    }

    if (strip_debug)
        fdump(out_som_fd, header_loc, temp_sub,
	    sizeof(struct subspace_dictionary_record), load_subsp);
    else
        fdump(out_som_fd, header_loc, temp_sub,
	    sizeof(struct subspace_dictionary_record), new_subsp_dict_size);
	
} /* end out_subsp_records */

#ifdef PRE_EMBED
void dump_subsp(subsp, misc, comment)
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
char *comment;
    {
    if (MB_CUR_LEN == 1)
	printf("%-3.3s %-20s %08x %08x %08x %08x",
		    comment,
		    subsp->NAME_PT,
		    subsp->file_loc_init_value,
		    subsp->initialization_length,
		    misc == NULL ?
			subsp->subspace_start :
			misc->new_subspace_start,
		    subsp->subspace_length);
    else
	printf("%s %-20s %08x %08x %08x %08x",
		    pad_string(-1, 3, 3, comment),
		    subsp->NAME_PT,
		    subsp->file_loc_init_value,
		    subsp->initialization_length,
		    misc == NULL ?
			subsp->subspace_start :
			misc->new_subspace_start,
		    subsp->subspace_length);

    if (misc != NULL) {
        printf(" %08x", misc->stubs_file_loc);
        printf("\n  %s,%s", misc->file_name, misc->input_name);
	}
    printf("\n");

    }
#endif /* PRE_EMBED */

/* more embedded system stuff */
struct map_entry {
    int indent;                   /* num of spaces to indent line */
    char *name;                   /* space/subsp/module name of this entry */
    unsigned int start;           /* start of this space/subsp */
    unsigned int end;             /* end of this space/subsp */
    unsigned int length;          /* length of space/subsp */
    char *input_name;             /* subsp input name if different than name */
    };


static struct map_entry *s_map = NULL;   /* subspace map for a space */
static struct map_entry *space_entry = NULL;        /* space entry in map */
static struct map_entry *first_subsp_entry = NULL;  /* space entry in map */
static struct map_entry *last_subsp_entry = NULL;   /* space entry in map */
static struct map_entry *cur_entry = NULL;  /* space entry in map */
static int map_size = 0;                /* num of possible entries in sp map */
static int num_of_entries = 0;          /* num of actual entries in space map */

int start_new_space_map(sp_index, first_space)
int sp_index;
int first_space;          /* 1 if this is the first space */
{
    char	msg_buf1[128];
    char	msg_buf2[128];
    char	msg_buf3[128];

    /* Alloc enough room for this space's map and set pointers */

    struct space_dictionary_record *space;

    space = &space_array[sp_index];

    /* The one extra is for the space name, need at least 3 entries */
    /* The *2 bit is because each subspace can generate two entries in
       the map.  One for the subspace name, and one for it's source file. */
    if (((space->subspace_quantity * 2) + 1) > map_size) {
            map_size = (space->subspace_quantity *2) + 1;
	    map_size = ((map_size > 3) ? map_size : 3 );
            s_map = (struct map_entry *) erealloc((char *) s_map, 
                                map_size * sizeof(struct map_entry));
        }

    /* init whole area to NULL's */
    memset((char *) s_map, '\0', map_size * sizeof(struct map_entry));

    /* Initialize pointers for this space */
    space_entry = s_map;             /* space is always entry 0 */
    first_subsp_entry = s_map + 1;   /* 1st subsp is always entry num 1 */
    last_subsp_entry = first_subsp_entry;    /* last is first */
    cur_entry = first_subsp_entry; 
    num_of_entries = 1;

    space_entry->name = space->name.n_name;
    space_entry->indent = 0;

    /* if beginning of map dump the header */
    if (first_space == 0) {
	strcpy(msg_buf1, ld_gets(1, 1161, "start"));
	strcpy(msg_buf2, ld_gets(1, 1162, "end"));
	if (MB_CUR_MAX == 1)
	    printf("\n%-24.24s  %-8.8s  %-8.8s\n",
		   ld_gets(1, 1160, "space"), 
		   msg_buf1, 
		   msg_buf2);
	else {
	    strcpy(msg_buf1, pad_string(-1, 8, 8, msg_buf1));
	    strcpy(msg_buf2, pad_string(-1, 8, 8, msg_buf2));
	    printf("\n%-24.24s  %s  %s\n",
		   pad_string(-1, 24, 24, ld_gets(1, 1160, "space")), 
		   msg_buf1, 
		   msg_buf2);
	}
	strcpy(msg_buf1, ld_gets(1, 1164, "address"));
	strcpy(msg_buf2, ld_gets(1, 1165, "address"));
	strcpy(msg_buf3, ld_gets(1, 1166, "length"));
	if (MB_CUR_MAX == 1)
	    printf("%-24.24s  %-8.8s  %-8.8s  %-8.8s\n",
		   ld_gets(1, 1163, "  subspace"), 
		   msg_buf1, 
		   msg_buf2, 
		   msg_buf3);
	else {
	    strcpy(msg_buf1, pad_string(-1, 8, 8, msg_buf1));
	    strcpy(msg_buf2, pad_string(-1, 8, 8, msg_buf2));
	    strcpy(msg_buf3, pad_string(-1, 8, 8, msg_buf3));
	    printf("%s  %s  %s  %s\n",
		   pad_string(-1, 24, 24, ld_gets(1, 1163, "  subspace")), 
		   msg_buf1, 
		   msg_buf2, 
		   msg_buf3);
	}
	printf("\n");
	}
}

char *get_basename(str)
char *str;	/* a NULL terminated string */
{
    char *c;

    if (!str) return ""; 

    /* return the basename of str */
    /* basename is anything after the last '/' in a pathname */

    /* going backwards through the string... */
    if (MB_CUR_MAX == 1) {
	for (c = str + strlen(str) ; c != str ; c--) {
	    if (*c == '/')
		return(c + 1);
	    }

	if (*c == '/')
	    return(c + 1);
	return(c);
    } else {
	c = mb_strrchr(str, '/');
	if (c == NULL)
	    return(str);
	else
	    return(c + 1);
    }
}


void add_subsp_to_map(subsp, misc, comment)
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
char *comment;
{
    struct map_entry *i;  /* tmp entry pointer */

    /* kludge to adjust the map if we redo subspace start (due to previous */
    /* subspaces being zero length! */
    if (comment[0] == 'r') {
	/* backpatch start addresses */
	for ( i = cur_entry - 2; ((i >= first_subsp_entry) && 
				       (i->length == 0)); i--) {
	    i->start = misc->new_subspace_start;
            i->end = i->start + i->length;
	    }
	return;
	}

    if (misc != NULL) {

        if ((misc->input_subsp_only != 2) && (subsp->subspace_length == 0)) 
	   return;

        /* If this is an output subspace (not extended) */
        if ((misc->input_subsp_only != 1) && (comment[0] != 'e')) {
	   cur_entry->name = subsp->NAME_PT;
           cur_entry->indent = 2;


	   /* make last_subsp_ptr point to this subspace (new output subsp) */
	   last_subsp_entry = cur_entry;

	   }
	else {            /* else this is an input subspace */
	   cur_entry->name = ((misc->input_file_name)? 
				      misc->input_file_name : misc->file_name);
	   cur_entry->name = get_basename(cur_entry->name);
           cur_entry->indent = 4;

	   }

        /* start, end, and length */
        cur_entry->start = (misc == NULL ? subsp->subspace_start :
					   misc->new_subspace_start);
        cur_entry->length = subsp->subspace_length;      
        cur_entry->end = cur_entry->start + cur_entry->length;


	/* what is the input name */
	cur_entry->input_name = misc->input_name;

        /* move ptr to next entry */
	cur_entry++;
        num_of_entries++;

        }
    else {           /*  else fill in the last output subspace */
        /* Update output subspace length and end */
        last_subsp_entry->length = subsp->subspace_length;      

        last_subsp_entry->end = 
			   last_subsp_entry->start + last_subsp_entry->length;

	/* output subspace never gets an input name; */
	last_subsp_entry->input_name = NULL;

	}
}


/* max spaces to indent map */
#define INDENT_MAX 4

int dump_map(sp_index)
  int sp_index;
{
    /* dump the map for this space */

    int i,j;
    struct subsp_misc_record          *cur_misc;
    int subsp_index,old_index;

    /* before we dump the map, update the space entry */
    if (num_of_entries != 1) {	/* If any subspaces in the map */
      space_entry->start = first_subsp_entry->start;

      space_entry->length = last_subsp_entry->end - space_entry->start;

      space_entry->end = space_entry->start + space_entry->length;
    } else {  /* No subspace in the map, so adjust space entry */
      /* Find first subspace, just like code in out_subsp_records */
      subsp_index = space_array[sp_index].subspace_index;
      old_index = Subsp_Misc(subsp_index).r_n_x;
      cur_misc = &Subsp_Misc(old_index);

      /* Set space start and end to address of first subspace */
      space_entry->start =  cur_misc->new_subspace_start;
      space_entry->end   =  cur_misc->new_subspace_start;
    }

    /* Now dump the whole thing */
    cur_entry = s_map;
    for (i=0 ; i < num_of_entries ; i++) {

	/* indent line */
	for (j = cur_entry->indent; j > 0 ; j--) {
            printf(" ");
        }

	if (MB_CUR_MAX == 1)
	    printf("%-20.20s", cur_entry->name);
	else {
	    printf("%s", pad_string(-1, 20, 20, cur_entry->name));
	}

	/* fill in if not indented */
	for (j = INDENT_MAX - cur_entry->indent; j > 0 ; j--) {
            printf(" ");
        }

        printf("  %08x  %08x  %08x",
	    cur_entry->start,
	    cur_entry->end,
	    cur_entry->length);

	if (cur_entry->input_name)
            printf("  %s", cur_entry->input_name);

	printf("\n");

        cur_entry++;
    }
}

void dump_space(index)
int index;               /* This space's index */
{
    char buf[5];

    printf("\n");
    printf("%-20.20s", space_array[index].name);
    printf("\n");
}

void dump_subsp(subsp, misc, comment)
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
char *comment;
{
    char buf[5];
    static int output_name;

    if (misc != NULL) {
        if ((misc->input_subsp_only != 2) && (subsp->subspace_length == 0)) 
	   return;

        if ((misc->input_subsp_only != 1) && (comment[0] != 'e')) {
	   printf("\n  %-18.18s", subsp->NAME_PT);
	   output_name = TRUE;
	} else {
	   output_name = FALSE;
	   printf("    %-16.16s", subsp->NAME_PT);
        }

        if (verbose & V_DEBUG) {
            /* show file info as well... */
	      printf("%08x %08x ", 
		subsp->file_loc_init_value,
		subsp->initialization_length);
	}

        printf("%08x %08x",
                misc == NULL ?
                    subsp->subspace_start :
    		    misc->new_subspace_start,
		subsp->subspace_length);      
		/*, misc->stubs_file_loc);             */

        printf(" %s:", 
	   ((misc->input_file_name)? misc->input_file_name : misc->file_name));
        printf("%s", 
		  ((misc->input_name)? misc->input_name : subsp->NAME_PT));
        printf("\n");
    } else {
	if (output_name == FALSE) {
	    printf("  %-18.18s", subsp->NAME_PT);

            if (verbose & V_DEBUG) {
                /* show file info as well... */
	          printf("%08x %08x ", 
		    subsp->file_loc_init_value,
		    subsp->initialization_length);
	    }

            printf("%08x %08x", subsp->subspace_start,
		subsp->subspace_length); 

	    printf("\n");
        }
    }
}

static int sym_compare(sp1, sp2)
int *sp1, *sp2;

    /* Compare symbols for qsort into increasing order by address */

{
    int key1, key2;

    *sp1 = Sym_Remap(*sp1);
    *sp2 = Sym_Remap(*sp2);

    switch (Sym_Dict(*sp1).symbol_type) {
	case ST_NULL:
	case ST_SYM_EXT:
	case ST_ARG_EXT:
	case ST_MILLI_EXT:
	    return (1);
		/* everything sorts ahead of ST_NULL and extension syms */
		/* more importantly, don't try to look at their subspace */
       /* HP-UX shared library or executable */
	case ST_STUB_IMPORT:
	    if (Sym_Subsp(*sp1) == BAD_SUBSP)
              /* HPUX Import that was never referenced to really generate a
                 stub - forget it. */
	      return(1);
	    break;
	default:		
            break;
    }

    switch (Sym_Dict(*sp2).symbol_type) {
	case ST_NULL:
	case ST_SYM_EXT:
	case ST_ARG_EXT:
	case ST_MILLI_EXT:
	    return (-1);
		/* everything sorts ahead of ST_NULL and extension syms */
		/* more importantly, don't try to look at their subspace */
        /* HP-UX shared library or executable */
        case ST_STUB_IMPORT:
            if (Sym_Subsp(*sp2) == BAD_SUBSP)
              /* HPUX Import that was never referenced to really generate a
                 stub - forget it. */
              return(-1);
            break;
	default:		
            break;
    }

    key1 = Subsp_Misc(Sym_Subsp(*sp1)).r_c_x;
    key2 = Subsp_Misc(Sym_Subsp(*sp2)).r_c_x;
    if (key1 != key2)
	return (key1 - key2);  /* respect output subspace order */

    return ( symbol_value(*sp1) - symbol_value(*sp2));
	/* if same subspace, compare values */
}

/* Embedded systems code */
static int embed_sym_compare(sp1, sp2)
int *sp1, *sp2;
{
    /* Compare symbols for qsort into alphabetical order */
    int key1, key2;

    switch (Sym_Dict(*sp1).symbol_type) {
	case ST_NULL:
	case ST_SYM_EXT:
	case ST_ARG_EXT:
	case ST_MILLI_EXT:
	    return (1);
		/* everything sorts ahead of ST_NULL and extension syms */
		/* more importantly, don't try to look at their subspace */
	default:		
            break;
    	}

    switch (Sym_Dict(*sp2).symbol_type) {
	case ST_NULL:
	case ST_SYM_EXT:
	case ST_ARG_EXT:
	case ST_MILLI_EXT:
	    return (-1);
		/* everything sorts ahead of ST_NULL and extension syms */
		/* more importantly, don't try to look at their subspace */
	default:		
            break;
    	}

    return ( strcmp(Sym_Dict(*sp1).name.n_name, Sym_Dict(*sp2).name.n_name));
}

void print_embed_symbol_map(sb)
struct subspace_dictionary_record *sb; /* condensed subsp recs */
{
    /* Print a map of the syms in alphabetical order with subspace info */

    struct symbol_dictionary_record *sym;
    int i, j, k, subquan, val;
    int new_sp_index;
    int *index_list;  /* list of indicies for symbol sort */
    int *cur_sym_index_ptr;  /* current position in sorted symbol array */
    char *c, *c2;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
				    means 'seen before in this search' */
    char msg_buf1[128];
    char msg_buf2[128];
    char msg_buf3[128];

    /* print titles */
    strcpy(msg_buf1, ld_gets(1, 1168, "address"));
    strcpy(msg_buf2, ld_gets(1, 1169, "subspace"));
    strcpy(msg_buf3, ld_gets(1, 1170, "module"));
    if (MB_CUR_MAX == 1)
	printf("\n%-22.22s %8.8s %-22.22s %s\n\n",
	       ld_gets(1, 1167, "symbol name"),
	       msg_buf1,
	       msg_buf2,
	       msg_buf3);
    else {
	strcpy(msg_buf1, pad_string(0, 8, 8, msg_buf1));
	strcpy(msg_buf2, pad_string(-1, 22, 22, msg_buf2));
	printf("\n%s %s %s %s\n\n",
	       pad_string(-1, 22, 22, ld_gets(1, 1167, "symbol name")),
	       msg_buf1,
	       msg_buf2,
	       msg_buf3);
    }

    /* build secondary index into symbol dictionary in virtual address order */
    index_list = (int *) emalloc(sizeof(int) * sym_dict_size);
    for (k = 0; k < sym_dict_size; k++)
	index_list[k] = k;  /* init to original order */
    qsort((char *)index_list, sym_dict_size, sizeof(int), 
	  (int (*)(const void *, const void *))embed_sym_compare);
    cur_sym_index_ptr = index_list;

    if (sym_dict_size > 0) /* If no symbols, don't derefence a null pointer */
      seen_before = !Sym_Misc(0).checked; /*inverse of value from last search*/
    /* for each sym */
    while(cur_sym_index_ptr < &index_list[sym_dict_size]) {

	/* if this entry was previously visited, don't print it again */
	if (Sym_Misc(*cur_sym_index_ptr).checked == seen_before) {
	    cur_sym_index_ptr++;
	    continue;
	    }
	Sym_Misc(*cur_sym_index_ptr).checked = seen_before; 
					/* toggle all bits for next search */

	switch (Sym_Dict(*cur_sym_index_ptr).symbol_type) {
	    case ST_NULL:
	    case ST_SYM_EXT:
	    case ST_ARG_EXT:
	    case ST_MILLI_EXT:
		cur_sym_index_ptr++;
		continue;  /* skip to next sym, 
				don't look at subspace record */
	    default:		
		break;
	    }
	if ((Sym_Dict(*cur_sym_index_ptr).symbol_scope == SS_UNSAT) ||
	  (Sym_Dict(*cur_sym_index_ptr).symbol_scope == SS_LOCAL)) {
	    cur_sym_index_ptr++;
	    continue;  /* skip to next sym, don't print unsats as
			  they aren't really at their apparent address,
			  even stor-reqs get moved to $BSS$ and promoted
			  to Data Univ in a.outs */
	    }

	/* at this point, have a printable sym in the curr subsp */
	sym = &Sym_Dict(*cur_sym_index_ptr);
	val = symbol_value(*cur_sym_index_ptr);
	/* c = Subsp_Misc(Sym_Subsp(*cur_sym_index_ptr)).input_name; */

	c2 = Subsp_Misc(Sym_Subsp(*cur_sym_index_ptr)).input_file_name;
	if (c2 == NULL) {
	    c2 = 
	     get_basename(Subsp_Misc(Sym_Subsp(*cur_sym_index_ptr)).file_name);
	    }
	else 
	    c2 = get_basename(c2);

	if (MB_CUR_MAX == 1)
	    printf("%-22.22s %08x %-22.22s %.22s\n", 
		   sym->NAME_PT, 
		   val,
		   Subsp_Dict(Sym_Subsp(*cur_sym_index_ptr)).name.n_name,
		   c2 );
	else
	    printf("%-22.22s %08x %-22.22s %s\n", 
		   sym->NAME_PT, 
		   val,
		   Subsp_Dict(Sym_Subsp(*cur_sym_index_ptr)).name.n_name,
		   pad_string(0, 0, 22, c2));

		/* don't print input subspace name 
		       ((c == NULL)? 
			 Subsp_Dict(Sym_Subsp(*cur_sym_index_ptr)).name.n_name 
			 : c ));
		 */

	cur_sym_index_ptr++;
	}      /* end while loop over the sorted auxilary sym list */

    efree(index_list);
}

void print_map(sb)
struct subspace_dictionary_record *sb; /* condensed subsp recs */


{
    struct symbol_dictionary_record *sym;
    int i, j, k, subquan, val;
    int new_sp_index;
    int *index_list;  /* list of indicies for symbol sort */
    int *cur_sym_index_ptr;  /* current position in sorted symbol array */
    char *prev_sym_name;
    int  prev_sym_val;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
				    means 'seen before in this search' */

    if (entry_symbol_index != BAD_SYM)
	val = symbol_value(entry_symbol_index);
    else {
	if (!relocatable)
            val = -1;
	else
            val = 0;
	}
    printf(ld_gets(1, 1179, "Entry Point 0x%08x"), val);

    /* build secondary index into symbol dictionary in virtual address order */
    index_list = (int *) emalloc(sizeof(int) * sym_dict_size);
    for (k = 0; k < sym_dict_size; k++)
	index_list[k] = k;  /* init to original order */
    qsort((char *)index_list, sym_dict_size, sizeof(int), 
	  (int (*)(const void *, const void *)) sym_compare);
    cur_sym_index_ptr = index_list;
    if (sym_dict_size > 0) /* If no symbols, don't dereference a null pointer*/
      seen_before = !Sym_Misc(0).checked; /* inverse from last search */

    /* for each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	i = sp_remap[new_sp_index];
	printf(ld_gets(1, 1180, "\n\nSpace %s\n"), space_array[i].NAME_PT);

	/* doom support */
        if (!strip_debug && lm_should_skip_space(i))
           continue;
        else
#ifdef WW_ANNOTATIONS_REMOVED
	if ((strip_debug && !space_array[i].is_loadable &&
	     strcmp(space_array[i].name.n_name,"$ANS$")) ||
#else /* WW_ANNOTATIONS */
	if ((strip_debug && !space_array[i].is_loadable) ||
#endif /* WW_ANNOTATIONS */
	    ((space_array[i].subspace_quantity == 0) &&
	         (space_array[i].loader_fix_quantity == 0) &&
	         (space_array[i].init_pointer_quantity == 0))) {
	    /* if the "tmp_space_misc" record isn't really there */
	    printf(ld_gets(1, 
			   1181, 
			   "    *** No subspaces in this space ***\n"));
            continue;
	    }

	j = tmp_space_misc[i].new_sub_index;
	subquan = tmp_space_misc[i].new_sub_quantity;
	if (subquan == 0)
	    printf(ld_gets(1, 
			   1182, 
			   "    *** No subspaces in this space ***\n"));

	/* for each subsp belonging to this space */
	for ( ; subquan > 0; subquan--, j++) {
	    val = sb[j].subspace_start;
	    printf(ld_gets(1, 
			   1183, 
			   "\n    Subspace %-24s ACB 0x%02x    0x%08x\n"),
			sb[j].NAME_PT,
			sb[j].access_control_bits,
			val);

	    /* for each sym belonging to this output subsp */
	    prev_sym_name = NULL;
	    prev_sym_val  = 0;
	    while(cur_sym_index_ptr < &index_list[sym_dict_size]) {

		/* if this entry was previously visited, don't print again */
		if (Sym_Misc(*cur_sym_index_ptr).checked == seen_before) {
		    cur_sym_index_ptr++;
	    	    continue;
		    }
		Sym_Misc(*cur_sym_index_ptr).checked = seen_before; 
					/* toggle all bits for next search */
    		switch (Sym_Dict(*cur_sym_index_ptr).symbol_type) {
		    case ST_NULL:
		    case ST_SYM_EXT:
		    case ST_ARG_EXT:
		    case ST_MILLI_EXT:
			cur_sym_index_ptr++;
			continue;  /* skip to next sym, 
					don't look at subspace record */
                   /* HP-UX shared library or executable */
		    case ST_STUB_IMPORT:
			if (Sym_Subsp(*cur_sym_index_ptr) == BAD_SUBSP) {
                            /* HPUX Import that was never referenced to
                               really generate a stub - forget it. */
			    cur_sym_index_ptr++;
			    continue;
			    }
			break;
		    default:		
            		break;
    		}
	        if (Sym_Dict(*cur_sym_index_ptr).symbol_scope == SS_UNSAT) {
		    cur_sym_index_ptr++;
                    /*
		    ** skip to next sym, don't print unsats as
		    ** they aren't really at their apparent address
		    ** even stor-reqs get moved to $BSS$ and promote to
		    ** Data Univ in a.outs
		    */
		    continue;  
		}
	        if (j != Subsp_Misc(Sym_Subsp(*cur_sym_index_ptr)).r_c_x) {
		    /* Toggle this bit back, so this symbol will be checked
		       again in the next subspace. */
		    Sym_Misc(*cur_sym_index_ptr).checked = !seen_before; 
		    break;  /* leave while loop, go back to subspace loop */
		}

		/* at this point, have a printable sym in the curr subsp */
	        sym = &Sym_Dict(*cur_sym_index_ptr);
	        val = symbol_value(*cur_sym_index_ptr);
		/*   Explicitly check to see if prev_sym_name
		** is NULL; don't go to strcmp() if it is! */
		if (val != prev_sym_val || prev_sym_name == NULL ||
		    strcmp(sym->NAME_PT, prev_sym_name))
		    printf("\t%-40s  0x%08x\n", sym->NAME_PT, val);
	        prev_sym_val = val;
		prev_sym_name = sym->NAME_PT;
		cur_sym_index_ptr++;
    		}  /* end while loop over the sorted auxilary sym list */
	    }	/* end for loop over subspaces */
	}    /* end for loop over spaces */
    efree(index_list);
}

/*
** copy subspace_data of each space to output som      
** need modification to copy & update unloadable data  
** for convenience, while we make the final pass over the data, we also 
** generate unwind tables, recover tables, loader fixups and absolute   
** fixups (including the relinkable fixups)                             
*/

void out_subsp_data()
{
    int	   old_index;
    int	   size, fill;
    int	   i;
    int    *ip;
    int    file_loc, init_value, recover_end_value;
    char   *data;
    FILE   *f;
    struct subsp_misc_record		    *misc;
    struct subspace_dictionary_record	    *subsp;
    static int init_buf[1024/sizeof(int)];
    extern void out_stubs();
    extern void build_stub_unwind_desc();
    extern struct relink_indices *sort_relink_list();
    struct stub_record *stub;
    int dot;
    struct relink_indices *relink_indices, *relink_ptr;

    int DLT_file_loc; /* file location of this subspace */
    char *DLT_data;  /* subsp initialized data, in this case DLT linkage tbl */

    int PLT_file_loc; /* file location of this subspace */
    char *PLT_data;  /* subsp initialized data, in this case PLT linkage tbl */

    int SHL_INFO_file_loc; /* file location of this subspace */
    char *SHL_INFO_data;  /* subsp init data, in this case SHLIB_INFO tbls */
    int last_space_index;   /* space index to start a new copyram entry */
#ifdef WW_ANNOTATIONS
    int subsp_index;
#endif /* WW_ANNOTATIONS */

#ifdef TSD /* TSD */
    int current_tbss = 0;
#endif
    struct subspace_dictionary_record *prev_subsp;

    flush_fdump_buffer();

    aux_unwind_size = unwind_count * sizeof(struct aux_udesc);
    old_unwind_count = unwind_count - fru_unwind_count;    /* For ASSERT */
    old_recover_count = recover_count - fru_recover_count; /* For ASSERT */
    old_copyram_count = copyram_count;

    unwind_count = 0;
    recover_count = 0;
    aux_unwind_count = 0;
    line_table_offset = 0;
    copyram_count = 0;
    last_space_index = -1;     /* Init for copyram subspaces */

    code_reloc_factor = -1;

#ifdef TSD /* TSD */
    tsd_addr = 0;
#endif /* TSD */

    f = NULL;
    cur_file_name = NULL;
    if (two_pass)
	subsp_data_area = (char *)emalloc(subsp_data_area_max);

    /* for all subspaces in ORIGINAL order */

    out_abs_fixup_count = 0;
    if (relinkable) {
        relink_indices = sort_relink_list();
        relink_ptr = relink_indices;
    }
#ifdef SPP_UX
    else {
	relink_indices = (struct relink_indices *)0;
    }
#endif /* SPP_UX */

    /* set the first word of the recover_end subspace */

    if(recover_end_subsp != BAD_SUBSP) {
        if(generate_aux_unwind)
            recover_end_value = line_table_size + aux_unwind_size + WORDSIZE;
        else
            recover_end_value = 0;
	fdump (out_som_fd, Subsp_Misc(recover_end_subsp).exec_file_offset, 
              &recover_end_value, 1, sizeof(int));
    }

    /* 
    ** initialize internal DOC structures for final pass over the fixups
    */
    if (!doc_disabled && !doc_initialized)
        doc_init_pass2();

/*   No longer generate PA annotation -
 * annotation_killed_at_startup is always TRUE.
 */
#ifdef WW_ANNOTATIONS_REMOVED
    for (subsp_index = 0; subsp_index < subsp_dict_size; subsp_index++) {
	if (! annotations_killed_at_startup) {
	    old_index=Subsp_Misc(subsp_index).r_n_x;
	} else {
	    old_index = subsp_index;
	}
#else /* WW_ANNOTATIONS */
    for (old_index = 0; old_index < subsp_dict_size; old_index++) { 
#endif /* WW_ANNOTATIONS */
	subsp = &Subsp_Dict(old_index);
	misc = &Subsp_Misc(old_index);

	/* doom support */
	if (misc->subsp_data_out) {
	   /* data for this subspace has been written out */
	   continue;
       	}

	/* doom support */
        if (!strip_debug && lm_should_skip_subspace(old_index))
           continue;
        else
#ifdef WW_ANNOTATIONS_REMOVED
	if (strip_debug && !subsp->is_loadable &&
	    old_index != annot_subsp_index)
#else /* WW_ANNOTATIONS */
	if (strip_debug && !subsp->is_loadable)
#endif /* WW_ANNOTATIONS */
            continue;
        /*
        **  If the delete_subspace bit in the misc
        ** record is set, we don't want to output the subspace.  The fix
        ** is originally for DOC (do not output a zero-length $LINES$
        ** subspace because SoftStatic can't handle it) but now anyone can
        ** specify a subspace to delete.
        */
        if (misc->delete_subspace) 
            continue;

	if (subsp->is_comdat && misc->comdat_nulled)
	    continue;

        /* Embedded systems code */
        if (space_misc[subsp->space_index].copyram_needed) {

 	    if (Subsp_Dict(old_index).space_index != last_space_index) {
	        last_space_index = Subsp_Dict(old_index).space_index;
	    }
	    curr_copyram_file_loc = Subsp_Misc(old_index).exec_file_offset;
	} else if (subsp->subspace_length == 0)
	    continue;

#ifdef WW_ANNOTATIONS_REMOVED
	/* If we are processing the annotations subspace, make sure
	   every bit of data is flushed to the in memory data area */
	if (old_index == annot_subsp_index) {
	     flush_current_annotations(BAD_SUBSP,0,FLUSH_MODE);
	     } 
#endif /* WW_ANNOTATIONS */

        if (!relocatable && !strip_fixups) {
            /* initialize buffer for absolute fixups */
            abs_buf_count = 0;
            abs_fix_loc = new_som_header.fixup_request_location +
                          misc->abs_fixup_index;

	    abs_fix_base = temp_sub[misc->r_c_x].subspace_start;

	    /* loop through fixup requests in stubs */
            /* generating absolute fixups           */
	    for (stub = misc->stub_list; stub != NULL; 
		 stub = stub->next_stub) {
	        if (stub->type == LONG_BRANCH_STUB ||
	    	    stub->type == MILLILONG_BRANCH_STUB) {
	    	    dot = misc->new_subspace_start + stub->subsp_off;
	    	    out_one_abs_fixup(R_ABS_CODE, dot-abs_fix_base);
	    	    out_one_abs_fixup(R_ABS_CODE, dot+WORDSIZE-abs_fix_base);
	  	}
            }

            /* 
	    ** add 2*WORDSIZE here to abs_fix_base, since what we really want
            ** is the difference between dot and the base address, but what  
            ** we actually have during apply_fixups is branch_dot.           
	    */
    	    abs_fix_base += 2*WORDSIZE;
        }

        file_loc = misc->exec_file_offset;

	/* Output stubs, if any */
	out_stubs(old_index, misc);
#ifdef WW_ANNOTATIONS_REMOVED
        if (Subsp_Stubs_Size(old_index) != 0) {
            flush_current_annotations(old_index,
				      Subspace_Virtual_Offset(old_index),
				      FLUSH_MODE);
            out_annotation(STUBS_HEADER,old_index,
			   Subspace_Virtual_Offset(old_index),
			   0,
			   0,
			   0);
        }
#endif /* WW_ANNOTATIONS */

	/* Output subspace initialization, if any */
	size = subsp->initialization_length -
			        Subsp_Stubs_Size(old_index);
	if (verbose & V_DEBUG)
	     printf(ld_gets(1, 
			    1184, 
			    "out_subsp_data: (subspace_index : %3d, "
			    "size : %08x\n"), 
		    old_index, 
		    size);
#ifdef TSD /* TSD */
	if (!subsp->is_tspecific) {
#endif /* TSD */
	if (size > 0 ||
            subsp->fixup_request_quantity != 0 ||
            old_index == unwind_subsp ||
            old_index == unwind_end_subsp ||
            old_index == recover_subsp ||
            /* Embedded systems code */
            old_index == copyram_subsp ||
            old_index == recover_end_subsp ||
            space_misc[subsp->space_index].copyram_needed) {
	    /* Subspace has initialization */
            if (size == 0)
                data = NULL;
	    else if (two_pass 
	    	 && (misc->data_file_offset != IN_MEMORY)) {
		if (cur_file_name != misc->subsp_data) {
		    if (f != NULL)
			fclose(f);
		    cur_file_name = misc->subsp_data;
		    f = efopen(cur_file_name, "r", CANT_OPEN);
		    data_fildes = fileno(f);
		    if (trace_som)
			printf("%s:\n", cur_file_name);
		}
		ffetch(data_fildes, misc->data_file_offset,
		       subsp_data_area, sizeof(char), size);
		data = subsp_data_area;
    	    } else if (save_data
			     && (misc->data_file_offset != IN_MEMORY)) {
	        ffetch(data_fildes, misc->data_file_offset,
		       subsp_data_area, sizeof(char), size);
	        data = subsp_data_area;
	    } else        /* one-pass and linker-created subspaces case */
	        data = misc->subsp_data;

            init_unwind_recover_build(misc);

	    /* 
	     *
	     * Turn on fdump_autoalign only if the current subspace and
	     * the previous subspace output to the same output subspace.
	     *
	     * Currently, there does not appear to be anyway to map the
	     * input subspace index to the output subspace index. 
	     * This code uses  in order to determine whether
	     * two subspaces should be output with autoalign on or not.
	     * We simply compare their names, if they are equal, it should
	     * be safe to user autoalign, if they're different, if might
	     * not be. I didn't want to do a strcmp on every subspace
	     * output operation, so I am taking advantage of the fact 
	     * that we merge identical names on input, so a simple
	     * pointer comparison should be sufficient.
	     */

	    if (old_index != 0) {
		prev_subsp = &Subsp_Dict(old_index - 1);

		if (subsp->name.n_strx == prev_subsp->name.n_strx) {
		    set_fdump_autoalign();
		}
	    }

	    if (relocatable) {
		/* do_relocatable_fixups(...); */
		fdump(out_som_fd, file_loc, data, 1, size);
	    } else {
                if (old_index == unwind_subsp) {
                    relocate_unwind(subsp, file_loc, data, relink_indices);
                } else if (old_index == unwind_end_subsp) {
                    relocate_stub_unwind(subsp, file_loc, data);
	            build_stub_unwind_desc(subsp,
                        file_loc+subsp->initialization_length);
	        } else if (old_index == recover_subsp) {
                    relocate_recover(subsp, file_loc, data);
                }else if (old_index == copyram_subsp) {
                    ; /* do nothing - this stuff should not be executed */
		      /* when this is NOT a Fru Link */
                } else if (old_index == recover_end_subsp) {
                    relocate_aux_unwind(subsp, file_loc, data);
                } else if (old_index == PLT_subsp_index) { /* PLT Link Tbl */
		    /* save args for later call to "relocate_PLT" */
    		    PLT_file_loc = file_loc;
    		    PLT_data = data;
                } else if (old_index == DLT_subsp_index) { /* DLT Link Tbl */
		    /* save args for later call to "relocate_DLT" */
    		    DLT_file_loc = file_loc;
    		    DLT_data = data;
                } else if (old_index == shlib_info_subsp_index) { 
		    /* $SHLIB_INFO$ subspace */
		    /* save args for later call to "relocate_shlib_info" */
    		    SHL_INFO_file_loc = file_loc;
    		    SHL_INFO_data = data;
                } else if (old_index == doc_lines_subsp) { 
		    /* 
		    ** $LINES$ supspace is an unloadable subspace which 
		    ** requires no relocation.  So, do nothing!
		    */
		} else if (old_index < fru_subsp_count) {
                    if (old_index < unwind_subsp) {
                        if (code_reloc_factor == -1) {
                            /*
                            ** set relocation for first subsp and all
                            ** subsequent subspaces
                            */
                            code_reloc_factor =
                                misc->new_subspace_start-subsp->subspace_start;
                            if (verbose & V_DEBUG)
                                printf(ld_gets(1, 
					       1185, 
					       "relocating code by : 0x%x\n"),
                                       code_reloc_factor);
                        } else {
                            i = misc->new_subspace_start-subsp->subspace_start;
                            if (code_reloc_factor != i) {
                                internal_error(INCONSISTENT_RELOCATION, 0);
                        } 
                     }
		 }
                 relink_ptr = relocate_old_subspace(old_index,
                                                    subsp,
                                                    file_loc,
                                                    data,
                                                    relink_ptr);
                } else { /* NORMAL SUBSPACES */
		    /* do_fixups will call output_flush to write file */
		    do_fixups(old_index, data, out_som_fd, file_loc);
		}
	    }

	    clear_fdump_autoalign(); 

	    if (!two_pass && !save_data && data &&
	     		     misc->data_file_offset != IN_MEMORY) {
	        efree(data);
	    }
	} else if (misc->exec_file_offset > 0) {
	    /* Subspace has no initialization, but must */
	    /* be initialized at link time */
            init_value = subsp->file_loc_init_value;
            fill = subsp->subspace_length -
			        Subsp_Stubs_Size(old_index);
            size = (fill > 1024)? 1024 : fill;
            ip = init_buf;
            for (i = size/sizeof(int); i > 0; i--)
	        *ip++ = init_value;
            while (fill > 0) {
	        if (size > fill)
                    size = fill;
	        fdump(out_som_fd, file_loc,
    				    (char *)init_buf, 1, size);
	        fill -= size;
	        file_loc += size;
	        }
	    }
#ifdef TSD /* TSD */
    } /* ! subsp->tspecific  */
#endif /* TSD */
    /*
    ** Terminate the current line table for this subpsace.
    */
    if (doc_enabled) {
	doc_gen_end();
    }
	
        /* flush last buffer of absolute fixups */

        if (abs_buf_count > 0)
            fdump(out_som_fd, abs_fix_loc, abs_buf, abs_buf_count, 1);
    } /* end for each subsp */

    flush_fdump_buffer();

    /*
    ** Write out any remaining line table entries and patch the specified
    ** subpaces with the subspace relative offsets of the individual line
    ** tables.
    */
    if (doc_enabled) {
	doc_finish();
    }

    if (building_incomp_exec && !do_data_copy)
	emit_shared_drelocs();

    /* finish tables after all other subspaces relocated, since tables
       may be referred to when doing fixups for other subspaces */
    if (DLT_subsp_index != BAD_SUBSP && 
        (&Subsp_Dict(DLT_subsp_index))->subspace_length > 0)
       relocate_DLT(&Subsp_Dict(DLT_subsp_index), DLT_file_loc, DLT_data);
    if (PLT_subsp_index != BAD_SUBSP &&
        (&Subsp_Dict(PLT_subsp_index))->subspace_length > 0)
       relocate_PLT(&Subsp_Dict(PLT_subsp_index), PLT_file_loc, PLT_data);
    if (building_shlib || building_incomp_exec)
        relocate_shlib_info(&Subsp_Dict(shlib_info_subsp_index), 
			    SHL_INFO_file_loc, SHL_INFO_data);

    flush_unwind_recover_desc();

    if (two_pass) {
	if (f != NULL)
	    fclose(f);
	if(subsp_data_area) efree(subsp_data_area);
    }

    if (abs_fixup_total != out_abs_fixup_count)
	internal_error(WRNG_NUM_ABS_FXPS, 0);

} /* end out_subsp_data */

struct export_values {
    int value;
    int export_index;
    int module_index;
};

find_localsym_addr(table, key, lowIndex, highIndex)
int *table;
int key;
int lowIndex;
int highIndex;
    {
    /*
     * Purpose:		Searches the local symbol map table for "key" 
     *		        using the binary search algorithm
     *		       
     * Return: 		1) If the "key" is found in the table, we need to
     *			   keep searching. Only way a local symbol can have
     *		           the same address as a global symbol is if it
     *			   is not referenced.
     *			2) If the "key" was not in the table, return the 
     *			   value of the first entry in the table that is 
     *			   greater than "key". If "key" is greater than 
     *			   all entries in the table, return -1;
     *			
     *			   Note: We do not expect to find the key in the 
     *			         table.
     */

    int middle;
    int high;
    int low;

    high = highIndex; 
    low  = lowIndex;

    while (low <= high) {
	middle = (low + high) / 2;
	if ( key < table[middle] ) {
	    high = middle -1;
	    } 
	else if ( key > table[middle] ) {
	    low  = middle +1;
	    } 
	else /* key == table[middle] */ {
	    /* find next entry that is greater than key */
	    while (++middle <= highIndex) {
	        if (table[middle] != key) 
		    return(table[middle]);
	        } 
	    return(-1);
	    }
        }

    if ( low > highIndex )
	return(-1);

    if ( high < lowIndex )
	low = lowIndex;

    return(table[low]);

    } /* end find_localsym_addr() */

int export_value_compare(rec1, rec2)
struct export_values *rec1; 
struct export_values *rec2; 
    {
    return(rec1->value - rec2->value);
    }

int dreloc_location_compare(rec1, rec2)
struct dreloc_record *rec1;
struct dreloc_record *rec2;
    {
    return(rec1->location - rec2->location);
    }

int int_compare(rec1, rec2)
int *rec1;
int *rec2;
    {
    return(*rec1 - *rec2);
    }

/*
** the main purpose of this routine is to compute the size of data exports
** and place the info in the export extension record. It also builds up the
** circular list of exports that all have the same value.  This is done for
** both code and data exports, although we only compute sizes for DATA 
** exports.
*/
int compute_export_sizes(export_sort, export_sort_count, dl_hdr) 
struct export_values *export_sort;
int export_sort_count;
struct dl_header *dl_hdr;
{

    int new_index;
    int *localsym_map, localsym_map_count, localsym_max;
    int next_value, localsym_addr;
    int current_subsp;
    int current_module;	/* last module that was looked up */
    int remapped_subsp;	/* last subspace that was matched to a module */
    int i,j;
#ifdef TSD /* TSD */
    int next_tsd_idx=-1;   /* next index in export_sort of TSD symbol */
#endif /* TSD */
    struct export_entry     *export_list;
    struct export_entry_ext *export_ext;
    int current_run;	        /* handle runs of export symbols 
			           that have the same value */
    int export_remap;	  	/* index into export table for current sort 
				   value */
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
				means 'seen before in this search' */

    export_list = (struct export_entry *)
                           (((char *) dl_hdr) + dl_hdr->export_list_loc);

    export_ext = (struct export_entry_ext *)
                           (((char *) dl_hdr) + dl_hdr->export_ext_loc);

    qsort((char *)export_sort, export_sort_count, sizeof(*export_sort),
	  (int (*)(const void *, const void *)) export_value_compare);

    /* compute what we believe to be the maximum number of local symbols
       that we could see. Add one to make sure we allocate and free at
       least one record.
    */
    localsym_max = hidden_shlib_exports + local_data_sym_count +1;

    /* allocate buffer to hold memory map for local symbols */
    localsym_map = (int *) emalloc(sizeof(int) * localsym_max);
    localsym_map_count = 0;

    /* 
    ** go through all the symbol records and record the addresses of local
    ** and hidden global symbols. These will be used to determine the 
    ** size of exported data symbols. We do not need to remap symbols here
    ** since we will be going through all symbol records - no sense 
    ** remapping unsats to definitions. 
    */
    if (sym_dict_size > 0) /* If no symbols, don't dereference a null pointer*/
      seen_before = !Sym_Misc(0).checked; /*inverse of value from last search*/
    for (i=0; i<sym_dict_size; i++) {

	/* if this entry was previously visited, don't count it again */
	if (Sym_Misc(i).checked == seen_before)
	    continue;

        /* toggle all bits for next search */
	Sym_Misc(i).checked = seen_before; 
#ifdef TSD /* TSD */
        if ((Sym_TLS(i) || Sym_Type(i) == ST_DATA) &&
#else
  	if (Sym_Type(i) == ST_DATA &&
#endif /* TSD */
            (Sym_Scope(i) == SS_LOCAL || Sym_Misc(i).hide_export) &&
	    Sym_Subsp(i) != BAD_SUBSP &&
	    Subsp_Dict(Sym_Subsp(i)).initialization_length > 0 ) {

	    /* 
	    ** It is expected that the size calculated for the local
	    ** virtual address array is correct. The below code was
	    ** implemented as a precaution in the event that extra 
	    ** local symbols are seen. In debug mode the linker will
	    ** abort if the array needs to be enlarged. 
	    */

	    if (localsym_map_count >= localsym_max) {
	        assert(localsym_map_count < localsym_max);
		localsym_max += 2000; /* seems like reasonable number */
		localsym_map = (int *)erealloc((char *) localsym_map, 
				       sizeof(int) * localsym_max);
 	    }
            localsym_map[localsym_map_count++] = symbol_value(i);
        }
   }

    qsort((char *)localsym_map, 
	  localsym_map_count, 
	  sizeof(int), 
	  (int (*)(const void *, const void *)) int_compare); 
    --localsym_map_count; /* convert to max array index */ 

    current_module = -1;
    remapped_subsp = BAD_SUBSP;

    current_subsp = export_sort[0].module_index;
    current_run = -1;
    for (i=0; i<export_sort_count -1; i++) {

#ifdef TSD /* TSD */
        if (!export_list[export_sort[i].export_index].is_tp_relative) 
#endif /* TSD */
	if (export_sort[i].value == export_sort[i+1].value) {
	    if (current_run == -1) 
		current_run = i;
	    continue;
	}

	export_remap = export_sort[i].export_index;

	assert(out_explist_subsp[export_remap] >= 0);

	if (export_list[export_remap].type == ST_STORAGE ||
#ifdef TSD /* TSD */
	    export_list[export_remap].type == ST_TSTORAGE ||
#endif /* TSD */
	    export_list[export_remap].type == ST_PLABEL) {
	    remapped_subsp = current_module = BAD_SUBSP;
	} else if (out_explist_subsp[export_remap] != remapped_subsp) {
	    current_module = find_module_by_subspace(
				   out_explist_subsp[export_remap]);
	    assert(current_module != BAD_SYM);
	    remapped_subsp = out_explist_subsp[export_remap];
        }

	export_list[export_remap].module_index = current_module;

        export_ext[export_remap].same_list = export_remap;

#ifdef TSD /* TSD */
	if (export_list[export_remap].type == ST_DATA && 
            !export_list[export_remap].is_tp_relative) {
#else
	if (export_list[export_remap].type == ST_DATA) {
#endif /* TSD */
	    /* check if cross subsp boundary */
	  
	    if (current_subsp != export_sort[i+1].module_index) {
	        new_index = export_sort[i].module_index;
	        current_subsp = export_sort[i+1].module_index;
		next_value = 
		     (Subsp_Misc(new_index).new_subspace_start +
		      Subsp_Dict(new_index).subspace_length);  
	    } else {
		next_value = export_sort[i+1].value;
   	    }
	    localsym_addr = find_localsym_addr(localsym_map, 
				               export_sort[i].value, 
					       0,
					       localsym_map_count);
	    if (localsym_addr > export_sort[i].value && 
		localsym_addr < next_value) 
		next_value = localsym_addr;
	    export_ext[export_remap].size = next_value - export_sort[i].value;
	}
#ifdef TSD /* TSD */
	else if (export_list[export_remap].is_tp_relative) {
	    /*
	    **  Get export size based on TSD offsets in
            ** $TBSS$.  This assumes the TSD exports are grouped together,
	    ** IN ORDER.  The qsort() routines sort by value so the TSD symbols
	    ** should be grouped togehter.  We're in trouble if we have a 
	    ** TSD symbol with a bigger offset than a code export address.  
	    ** So we'll skip the non TSD symbols and keep the index of the 
	    ** last/next TSD symbol we found.  This way in the next iteration 
            ** over export_sort[], we can start looking for the next TSD symbol
	    ** after that--we don't have to go back over the previous non TSD
	    ** symbols.  When we're at the end, we use tbss_size to calculate
	    ** the size of the last TSD symbol in export_sort[].
     	    */
	    Boolean not_found;
	    if (next_tsd_idx == -1) /* first time */
	        next_tsd_idx = i+1;
	    else
	        next_tsd_idx++;

	    not_found = TRUE;
            while (next_tsd_idx < export_sort_count - 1 && not_found) {
	        if (export_list[export_sort[next_tsd_idx].export_index].is_tp_relative) {
		    export_ext[export_remap].size = 
		       export_sort[next_tsd_idx].value - 
		       export_sort[i].value;
		    not_found = FALSE;
	        } else { /* keep looking */
                    next_tsd_idx++;
		}
	    } 
            /* 
	    ** if we're here and we didn't find another TSD symbol, we're at
	    ** the end so calculate the size based on tbss_size.
            */
	    if (not_found) {
                export_ext[export_remap].size = tbss_size - 
					      export_list[export_remap].value;
	    }

	    /*   put the size of TLS common in info.size 
	     * just like storage request.
             */
	    if (export_list[export_remap].type == ST_TSTORAGE) {
	       export_list[export_remap].info.size = 
			export_ext[export_remap].size;
	    }
	} /* TLS */
#endif /* TSD */

	if (current_run != -1) {
	    for (j=current_run; j<i; j++) {
		export_ext[export_sort[j].export_index].size = 
		    export_ext[export_remap].size;
		export_ext[export_sort[j].export_index].same_list = 
		    export_sort[j+1].export_index;
	        export_list[export_sort[j].export_index].module_index = 
	            export_list[export_sort[i].export_index].module_index;
	    }
	    /* complete the circle */
            export_ext[export_remap].same_list = 
		    export_sort[current_run].export_index;
	    current_run = -1;
	}
    }
    efree(localsym_map);

} /* end compute_export_sizes() */

int find_export_by_location(export_sort, export_sort_count, 
		            export_ext, location) 
struct export_values *export_sort;
int export_sort_count;
struct export_entry_ext *export_ext;
int location;
    /* uses binary search algorithm to search a export list that has 
       been sorted by value. Returns index to export symbol if "location" 
       falls within the address range spanned by the symbol, else 
       returns BAD_SYM */ 
    {

    int middle;
    int high;
    int low;
    int highIndex;
    int lowIndex;
    int ret_index;

    high = highIndex = export_sort_count -1;
    low  = lowIndex  = 0;

    while (low <= high) {
        middle = (low + high) / 2;
        if (location == export_sort[middle].value) {
	    return(export_sort[middle].export_index);
            } 
	else if (location > export_sort[middle].value) {
            low = middle +1;
            } 
	else {
            high = middle -1;
            }
        }

    /* if not exact match, then find the index of the first export symbol 
       whose value is less than "location" */ 
    if (low > highIndex) {
        ret_index = highIndex;
        } 
    else if (high < lowIndex) {
        return(BAD_SYM);
        } 
    else {
        ret_index = high;
        }

    /* remap export_sort index to actual export index */
    middle = export_sort[ret_index].export_index;

    if (export_ext[middle].size > 0 && 
	(location >= export_sort[ret_index].value &&
         location < export_sort[ret_index].value + export_ext[middle].size)) {
	return(middle);
        }
    else {
	return(BAD_SYM);
	}

    }  /* end find_export_by_location() */

int sort_drelocs(export_sort, export_sort_count, dl_hdr)
struct export_values *export_sort;
int export_sort_count;
struct dl_header *dl_hdr;
    {
    int dreloc_count;
    int export_index;
    int i,j;
    struct export_entry_ext *export_ext;
    struct dreloc_record *dreloc_rec;

    export_ext = (struct export_entry_ext *)
                           (((char *) dl_hdr) + dl_hdr->export_ext_loc);

    dreloc_rec = (struct dreloc_record *)
                           (((char *) dl_hdr) + dl_hdr->dreloc_loc); 

    dreloc_count = dl_hdr->dreloc_count;

    qsort((char *)dreloc_rec, dreloc_count, sizeof(*dreloc_rec),
	  (int (*)(const void *, const void *)) dreloc_location_compare);

    for (i=0; i<dreloc_count; i++) {
      
	/* indicate the dreloc list for each export symbol */
        export_index = find_export_by_location(export_sort, 
			                  export_sort_count, 
					  export_ext, 
					  dreloc_rec[i].location + data_offset);
	if (export_index != BAD_SYM && export_ext[export_index].dreloc == -1) {
	    /* assign dreloc index to all exports on the (circular) same list */
	    j = export_index;
	    do {
	        export_ext[j].dreloc = i;
		j = export_ext[j].same_list;
	       } while (j != export_index);
	    }
	}
    } /* end sort_drelocs() */

relocate_module_fields()
    {
    struct module_entry *module_rec;
    int module_import_list_vaddr;
    int module_dreloc_list_vaddr;
    int i;

    module_import_list_vaddr = module_import_offset + 
			       Subspace_Virtual_Offset(shlib_info_subsp_index);
    module_dreloc_list_vaddr = module_dreloc_offset + 
			       Subspace_Virtual_Offset(shlib_info_subsp_index);

    /* add in text offset for module import list and module dreloc list */ 
    for (i=0; i<shlib_module_count; i++) {
        module_rec = &shlib_module[i];
        if (module_rec->drelocs >= 0) 
	    module_rec->drelocs += module_dreloc_list_vaddr;
	if (module_rec->imports >= 0)
	    module_rec->imports += module_import_list_vaddr;

	module_rec->reserved1 = 0;
	module_rec->reserved2 = 0;
   	}

    } /* end relocate_module_fields() */
				   
void relocate_shlib_info(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
char *data;  /* subspace initialized data, in this case the shlib tables */
{
    struct dl_header *dl_hdr;
    struct export_entry *export_list;    
    struct export_entry_ext *export_list_ext;
    struct dreloc_record *dreloc_rec;
    int sym_index, orig_sym_index; 
    int type;  		     /* temp copy of symbol type for compares */
    int export_sort_count;
    extern int elaborator_index;
#ifdef NO_MULTIPLE_INITIALIZERS
    extern int initializer_index;
#endif /* NO_MULTIPLE_INITIALIZERS */

    struct export_values *export_sort;

    int i, j;  

    dl_hdr = (struct dl_header *) data;

#ifdef NO_MULTIPLE_INITIALIZERS
    /* set the elaborator/initializer fields (not valid until after fixups) */
    if(elaborator_index != BAD_SYM) dl_hdr->flags |=  ELAB_DEFINED;
    if(initializer_index != BAD_SYM) dl_hdr->flags |= INIT_DEFINED;
    dl_hdr->elaborator = elaborator_index;
    dl_hdr->initializer = initializer_index;
#else
    if (dl_hdr->initializer_count) dl_hdr->flags |= INIT_DEFINED; 
    if(elaborator_index != BAD_SYM) dl_hdr->flags |=  ELAB_DEFINED;
    dl_hdr->elaborator = elaborator_index;
#endif /* NO_MULTIPLE_INITIALIZERS */

        /* NO_DATA_COPY */
	/*This flag means dld can search the entire shlib
	** list to satisfy a ST_STORAGE import, not just stop at one exported
	** from the program file. */
    if (building_incomp_exec && !do_data_copy)
	dl_hdr->flags |=  SEARCH_ALL_STORS;

    /* set other flag bits that may be defined */
    dl_hdr->flags |= dl_header_flags;

    /* 
    ** unset the GLOBAL_HASH_TABLE if building the shared library.
    ** unset the PLABEL_CACHE flag if building the shared library.
    ** issue warnings if +gstsize/+gstbuckets/+plabel_cache 
    ** specified without specifying +gst option to the linker
    */
    if (gh_ext_opt_specified && 
        !(dl_hdr->flags & GLOBAL_HASH_TABLE)) {
         warning(NO_PLUS_GST_OPTION_SEEN, 0);
    }

    if (building_shlib) {
       dl_hdr->flags &= ~(GLOBAL_HASH_TABLE);
       dl_hdr->flags &= ~(PLABEL_CACHE);
    } 

    if (!no_dlheader_ext) {
       dl_hdr->elaborator = dl_header_ext_offset; 
    }

    /* relocate dl_header DLT, PLT location values */
    dl_hdr->dlt_loc = Subspace_Virtual_Offset(DLT_subsp_index) - data_offset;
    dl_hdr->plt_loc = Subspace_Virtual_Offset(PLT_subsp_index) - data_offset;

    /* use fact that dl_header at beginning of subsp to get table pointers */
    if (dl_hdr->dreloc_count > 0)
        dreloc_rec = (struct dreloc_record *)
                            (((char *) dl_hdr) + dl_hdr->dreloc_loc);
    else
	dreloc_rec = NULL;
    
    if (dl_hdr->export_list_count > 0)
        export_list = (struct export_entry *)
                            (((char *) dl_hdr) + dl_hdr->export_list_loc);

    /* relocate dl_header ltptr value */
    if (building_shlib) {
    	dl_hdr->ltptr_value = dl_hdr->dlt_loc +
			    (ltptr_DLT_entry_index * sizeof(DLT_ENTRY));

	export_sort = (struct export_values *) emalloc 
					 ((dl_hdr->export_list_count +1) * 
					  sizeof(struct export_values));
	export_list_ext = (struct export_entry_ext *)
			       (((char *) dl_hdr) + dl_hdr->export_ext_loc);
    } else {
    	dl_hdr->ltptr_value = 0;  /* don't leave uninit holes */
	
	if (dreloc_rec != NULL) {
	    export_sort = (struct export_values *) emalloc 
			   (Subsp_Misc(SHLIB_DATA_subsp_index).symbol_count * 
			      sizeof(struct export_values));
	} else 
	    export_sort = NULL;
    }
  
    export_sort_count = 0;

    /* relocate export table fields*/
    for (i=0; i < dl_hdr->export_list_count; i++) { /* for each export entry */

	int prim_sym = 0, prim_stub_sym = BAD_SYM;

	assert(export_list[i].value != BAD_SYM);
#ifdef TSD /* TSD */
	/* 
	** Value contains the TSD offset, not the symbol
	** index.  Symbol index is contained in info.size.  Once we get it,
	** zero out info.size
	*/
	if (export_list[i].is_tp_relative) {
	   sym_index = export_list[i].info.size;
	   export_list[i].info.size = 0;
	} else
#endif /* TSD */

	sym_index = Sym_Remap(export_list[i].value);

	/* If we have a code secondary def, and
	** we can find the primary, and this primary has an export stub,
	** then use it, instead of the secondary. 
	*/
    	if (Sym_Dict (sym_index).secondary_def &&
	    (type == ST_ENTRY    || type == ST_PRI_PROG   ||
	     type == ST_SEC_PROG || type == ST_STUB_IMPORT)) {
	    prim_sym = map_secondary_to_primary (sym_index);
	    if (prim_sym != sym_index) {
		prim_stub_sym = find_export_stub_sym (prim_sym);
		if (prim_stub_sym != BAD_SYM)
		    sym_index = prim_sym;
	    }
	}

	orig_sym_index = sym_index;
	type = Sym_Remap_Type(sym_index);

	if (building_shlib) {
  	    /* we set the entire export ext. to -1 to ensure that code
               syms would have -1 size and dreloc fields, now need to clear
               reserved fields. */
            export_list_ext[i].reserved2 = 0;
            export_list_ext[i].reserved3 = 0;
        } else {
	    /* module index only valid in shared libraries */ 
	    export_list[i].module_index = -1;

            /* We need to tie the export symbol with the DR_PROPAGATE dreloc 
               copied over for it. Here we create an export array of all 
	       the symbols in the SHLIB_DATA_subspace. We will use this
	       array in relocate_dreloc_locations() to match the relocation
	       to the export index. */

	    if (Sym_Subsp(sym_index) == SHLIB_DATA_subsp_index) {
	        export_sort[export_sort_count].value = export_list[i].value;
	        export_sort[export_sort_count++].export_index = i;
		assert(export_sort_count <= 
		       Subsp_Misc(SHLIB_DATA_subsp_index).symbol_count);
	    }
	}

        /* relocate export table "value" symbol address fields */
	if (export_list[i].type == ST_PLABEL) {
	    /* plabel export "value" fields are the address of the PLT
	       entry for the symbol whose plabel is being taken. */
	    j = Sym_ShlImp_Indx(export_list[i].value);
	    /* use orig sym - remapped sym might not be in PLT */
	    assert (j >= DLT_entry_count && j < import_entry_count);
	    export_list[i].value = 
	        ((j - DLT_entry_count) * sizeof(struct PLT_entry)) +
		Subspace_Virtual_Offset(PLT_subsp_index);
	} else {
	    /* find the export stub in the chain */
 	    if ((type == ST_ENTRY || 
		 type == ST_PRI_PROG ||
		 type == ST_SEC_PROG ||
		 type == ST_STUB_IMPORT)) {

		/* If we got the prim_stub_sym
		** above, use it; otherwise, use find_export_stub_sym()
		** to get the export stub sym: */

		if (prim_stub_sym != BAD_SYM)
		    sym_index = prim_stub_sym;
		else {

		    /*
		     * 
		     * Symbols with no relocation and long return now have
		     * null export stubs: stub symbols that point back to
		     * the original routine. This makes the handling of
		     * such symbols more consistent and fixed some problems
		     * with it.
		     *
		     * The effect of it all is that we now have to search
		     * for export stub symbols even though the export stub
		     * itself is non-existent.
		     *
		     */
		    
		    sym_index = find_export_stub_sym(sym_index);
		}
		assert (sym_index != BAD_SYM);
	    }

	    /* 
	    ** Need the real offset (ex. 4 instead of something like 
	    ** 40002004) in the value field because dld won't know and won't
	    ** care about the start of $TBSS$.  We already put this real offset
	    ** in the symbol_value field in symbol_add().
	    */
	    export_list[i].value = symbol_value(sym_index);
	}

	/* save off values for sorting of the export list */
        if (building_shlib) {
            /* 
	    ** We want the entry point, not the stub for code syms.
            ** Entry point symbol should be on the end of the related stub
            ** list. 
	    */
            if (export_list[i].type == ST_CODE) {
		orig_sym_index = find_orig_sym(orig_sym_index);
                assert(orig_sym_index != BAD_SYM);
                export_sort[i].value = symbol_value(orig_sym_index);
            } else {
                export_sort[i].value = export_list[i].value;
            }
	    /* 
	    ** The module_index is still a subspace number at this time
	    ** so we should pull that field.  Luckily, the export_sort
	    ** structure allocated 32 bits for the module_index field. 
	    */
            export_sort[i].module_index = out_explist_subsp[i];
            export_sort[i].export_index = i;
        }

    } /* for all exports */

    /* relocate dynamic relocation record fields */
    relocate_dreloc_locations(dreloc_rec,dl_hdr,export_sort,export_sort_count);

    if (building_shlib) {
	relocate_module_fields();
        /*
    	** dummy record to force correct size calculation of last data symbol
        ** We assume that the data will end up after the code in virtual     
        ** address space 					             
        */
        export_sort_count = dl_hdr->export_list_count;
	export_sort[export_sort_count].value = MAXINT;
	export_sort[export_sort_count++].module_index = MAXINT;
	compute_export_sizes(export_sort, export_sort_count, dl_hdr); 
	sort_drelocs(export_sort, export_sort_count, dl_hdr);
	relocate_dreloc_modindex(dreloc_rec, dl_hdr);
    }

    if (export_sort)
	efree(export_sort);

    if (out_explist_subsp)
	efree(out_explist_subsp);

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);

} /* end relocate_shlib_info() */

/*
** uses binary search algorithm to search the module list that should
** already be in sorted order.  Returns index to a module if "subsp_indx" 
** falls within the subspace range spanned by the module, else 
** returns BAD_SYM 
*/

int find_module_by_subspace(subsp_indx)
int subsp_indx;
{
    int middle;
    int high;
    int low;
    int highIndex;
    int lowIndex;
    int ret_index;
    int key;

    high = highIndex = shlib_module_count -1;
    low  = lowIndex  = 0;

    while (low <= high) {
        middle = (low + high) / 2;
	key = shlib_module_misc[middle].end_subsp_indx;
        if (subsp_indx == key) {
	    return(middle);
        } else if (subsp_indx > key) {
            low = middle +1;
        } else { 
            high = middle -1;
        }
    }

    /* if not exact match, then find the index of the module that spans 
       the subspace index, or BAD_SYM if no module matches */
    if (low > highIndex) {
        return(BAD_SYM);      /* past the end of subspace ranges */ 
    } else if (high < lowIndex) {
        ret_index = lowIndex; 
    } else { 
        ret_index = low;
    }

    if (subsp_indx >= shlib_module_misc[ret_index].start_subsp_indx &&
        subsp_indx <= shlib_module_misc[ret_index].end_subsp_indx) {
	return(ret_index);
    } else {
	return(BAD_SYM);
    }

} /* end find_module_by_subspace() */

int relocate_dreloc_locations(dreloc_rec,dl_hdr,export_sort,export_sort_count)
struct dreloc_record *dreloc_rec;
struct dl_header *dl_hdr;
struct export_values *export_sort;
int export_sort_count;
{
    register int i, j;
    int dreloc_count, last_found, errors;

    dreloc_count = dl_hdr->dreloc_count;
    errors = last_found = 0;
   
    if (building_incomp_exec && export_sort_count) {
        qsort((char *)export_sort, export_sort_count, sizeof(*export_sort),
	      (int (*)(const void *, const void *)) export_value_compare);
    }

    /* relocate dynamic relocation record fields */
    for (i=0; i < dreloc_count; i++) {

        /* NO_DATA_COPY */
	/*   For DATA_EXT, we now use the 'shlib' field to
	** hold the subspace, not 'module'index' 
    	** relocate "location" field from subsp- to output-space-relative 
	*/
	dreloc_rec[i].location +=
    	 	(Subspace_Virtual_Offset (dreloc_rec[i].shlib) -
		 data_offset);

        /* Just because I'm paranoid, reset both fields here now.
	** Do this only for a.out's; we'll clear the fields for shlibs
	** in relocate_dreloc_modindex(). 
	*/
	if (! building_shlib)
	    dreloc_rec[i].shlib = dreloc_rec[i].module_index = -1;

   	if (building_incomp_exec
                /* NO_DATA_COPY 
		** This whole clause holds true only if we have
		** DR_PROPAGATE drelocs.  W/o data copying, we
		** have none 
		*/
               && do_data_copy) {

	    /* Ignore PLABEL_INT and PLABEL_EXT */
            if (!mixed_mode_off && 
                (dreloc_rec[i].type == DR_PLABEL_INT || 
                dreloc_rec[i].type == DR_PLABEL_EXT)) {
                continue;
            }

	    for (j = last_found; j < export_sort_count; j++) {
		if (export_sort[j].value == dreloc_rec[i].symbol) {
		    dreloc_rec[i].symbol = export_sort[j].export_index;
		    /* take advantage of the fact that symbol indecies     */
		    /* should be in sorted order within the dreloc records */
		    last_found = j + 1; 
		    break;
		}
     	    }

	    if (j == export_sort_count) {
	        warning(NO_EXPORT_FOR_DRELOC,
			Sym_Name(Sym_Remap(dreloc_rec[i].symbol)), 0);
		++errors;
            }

	    /* module_index not used by DR_PROPAGATE drelocs */
            dreloc_rec[i].module_index = -1;
	}
    }  

    if (errors)
	longjmp(drive, 1);

} /* end relocate_dreloc_locations() */

int relocate_dreloc_modindex(dreloc_rec, dl_hdr)
struct dreloc_record *dreloc_rec;
struct dl_header *dl_hdr;
{
    register int i;
    int curr_subsp;
    int curr_module;

    curr_module = 0;
    curr_subsp = BAD_SUBSP;

    /* set all entries to -1 to serve as list terminators */
    memset(module_dreloc_buffer, '\377', module_dreloc_count * sizeof(int)); 

    for (i=0; i < dl_hdr->dreloc_count; i++) { 

                /* NO_DATA_COPY */
		/*  Now we're using "shlib" instead of
		** "module_index" to hold the fixup_subsp. */
        if (dreloc_rec[i].shlib != curr_subsp) {
	    curr_module = find_module_by_subspace (dreloc_rec[i].shlib);
	    assert(curr_module != BAD_SYM);
	    assert(shlib_module_misc[curr_module].dreloc_list_index <=
		   module_dreloc_count);
	    module_dreloc_buffer[shlib_module_misc[curr_module].
				                      dreloc_list_index++] = i;
	    curr_subsp = dreloc_rec[i].shlib;
	}	

	    /* Reset the 'shlib' field here, since it's never used by dld */
	dreloc_rec[i].shlib = -1;

        dreloc_rec[i].module_index = curr_module;
    }  

} /* end relocate_dreloc_modindex() */

void relocate_DLT(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
char *data;  /* subspace initialized data, in this case the DLT  */
{
    DLT_ENTRY *curr_DLT_entry;         /* allocated DLT in memory */
    int i;  /* loop counter */
    int sym_index;


    /* relocate DLT address fields */

    curr_DLT_entry = (DLT_ENTRY *) data;

#ifdef DEBUG
    if (verbose & V_ALLDEBUG) 
    	printf(ld_gets(1, 
		       1186, 
		       "\nOutput Data Linkage Table (offset, value) :\n"));
#endif /* DEBUG */

    /* make sure the unwind slot is skipped */
    if (building_shlib)
        curr_DLT_entry[ltptr_DLT_entry_index] = BAD_SYM; 

    for (i=0; i < DLT_entry_count; i++) { 

        /* if this is a CODE_PLABEL DLT entry, it is LT-subsp-rel
	   and needs to be data-space-rel - but including the
	   0x40000000 to keep dld from having to check the sym type */
 	if (i >= DLT_entry_count - code_plab_DLT_entry_count) {
 	    curr_DLT_entry[i] = ((curr_DLT_entry[i] - DLT_entry_count) *
                                 sizeof(struct PLT_entry)) +
                                HPUX_PLABEL_BITS;
	    curr_DLT_entry[i] += Subspace_Virtual_Offset(PLT_subsp_index);
	    continue;
	}

	if (curr_DLT_entry[i] != BAD_SYM) { 
	   sym_index = Sym_Remap(curr_DLT_entry[i]);
#ifdef TSD /* TSD */
        /* 
        ** Set the is_tp_relative bit for TLS symbols.
	** Stuff the TLS offset into the slot for the import.
        */
	if (Sym_TLS(sym_index)) {
#ifdef DEBUG /* DEBUG */
	   if (verbose & V_TSD) {
	      printf("Sym shl imp %d for %s\n", Sym_ShlImp_Indx(sym_index), 
		     Sym_Name(sym_index)); 
	   }
#endif /* DEBUG */
	   if (building_shlib || building_incomp_exec) {
	      out_import_list[Sym_ShlImp_Indx(sym_index)].is_tp_relative =
		TRUE;
	   }
	   curr_DLT_entry[i] = Sym_Value(sym_index);
           continue;
	}
#endif /* TSD */
	    if (building_shlib && 
           	Sym_Scope(sym_index) == SS_UNSAT &&
		out_import_list[Sym_ShlImp_Indx(sym_index)].type != ST_NULL)
	        curr_DLT_entry[i] = BAD_SYM; /* don't know stor_req & unsats */
	    else
	        curr_DLT_entry[i] = symbol_value(Sym_Remap(curr_DLT_entry[i]));
		/* 
		** takes advantage of same processing for code syms for the
		** entries in the DLT for symbols seen in CODE_PLABEL 
		** fixups 
		*/
	}
    }

    /* fill in the unwind info record at end of the DLT table */
    /* magic number and index of shlib file name entered previously */
    if (building_shlib) {
    
        struct shlib_unwind_info *unw_rec; 

        /* 
	** the UNWIND SLOT is located and the end of the DLT in a 
	** shared library, set unwind offset in *r19             
        */
	curr_DLT_entry[ltptr_DLT_entry_index] =  
	    (DLT_entry_count - ltptr_DLT_entry_index) * sizeof(DLT_ENTRY);

    	unw_rec = (struct shlib_unwind_info *) 
		    (data + (sizeof(DLT_ENTRY) * DLT_entry_count)); 

    	/* find text and data start */
    	unw_rec->text_start = code_offset;
    	unw_rec->data_start = data_offset;

    	/* find unwind start/end, recover start/end */
	if (suppress_unwind) {  
    	    unw_rec->unwind_start = unw_rec->unwind_end =
				    unw_rec->recover_start =
				    unw_rec->recover_end = 0;
	} else {
    	    unw_rec->unwind_start = Subspace_Virtual_Offset(unwind_subsp);
    	    unw_rec->unwind_end = Subspace_Virtual_Offset(unwind_end_subsp);
    	    unw_rec->recover_start = Subspace_Virtual_Offset(recover_subsp);
    	    unw_rec->recover_end = Subspace_Virtual_Offset(recover_end_subsp);
	}

    }  /* END building_shlib */

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);

}  /* END relocate_DLT */

void relocate_PLT(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
char *data;  /* subsp initialized data, in this case the PLT linkage table */
{
    struct PLT_entry *curr_PLT_entry;  /* allocated PLT in memory */
    int i;  /* loop counter */
    struct symnode *n;
    Boolean addr_taken;

    if (!PLT_entry_count)
        return;	

    /* relocate PLT address fields */
    curr_PLT_entry = (struct PLT_entry *) data;

    for (i=0; i < PLT_entry_count; i++) {  /* for each PLT entry */
    	int sym_index = curr_PLT_entry->proc_addr; /* saved sym index val */

    	/* 
        ** if PLT entry's symbol has no fixups, the "Sym_Subsp" field will
	** be -1 and we don't need a PLT entry to branch through, as it
	** is not referenced in the shlib 
	*/
	curr_PLT_entry->proc_addr = (Sym_Subsp(sym_index) == BAD_SUBSP ?
				     BAD_SUBSP : symbol_value(sym_index));
	
	/* 
	** set the bypassable bit in the import entry for all code symbols
	** in a shlib which do not have their addresses taken. 
	*/
	if (building_shlib && bypass_export_stubs) {
	   int imp = Sym_ShlImp_Indx(sym_index);
	   assert(imp >= 0);
	   /* Since we don't resolve two code unsats to each other, but
	      just put them on the same list in the symnode, make sure that
	      none of the unsats are associated with a plabel */
	   addr_taken = FALSE;
	   n = Sym_Back_Ptr(sym_index);
	   while (n != NULL) {
	       if (Sym_addr_taken(n->index)) {
	           addr_taken = TRUE;
		   break;
	       }
	       n = n->same;
	   }
	   out_import_list[imp].bypassable = !addr_taken;
	};

	curr_PLT_entry++;
    } /* for */

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);

}  /* END relocate_PLT */

relocate_unwind(subsp, file_loc, data, relink_list)
struct subspace_dictionary_record *subsp;
int file_loc;
struct udesc *data;
struct relink_indices *relink_list;
{
    int last_index, i, sym_index;
    unsigned int start, end, next_sym_value;

    last_index = subsp->initialization_length / sizeof(struct udesc);

    next_sym_value = 0;

    for (i = 0; i < last_index; i++) {
        /* traverse relink list in order with unwind descriptors */
        start = data[i].start;
        data[i].start = start + code_reloc_factor;
        end = data[i].end;
        data[i].end = end + code_reloc_factor;
        while (next_sym_value < start) {
            sym_index = relink_list->old_sym;
	    relink_list++;
            next_sym_value =
                (sym_index == BAD_SYM) ?
                    0xffffffff :
                    Sym_Dict(sym_index).symbol_value &~ CLEAR_SYM_XL;
        }
        /* at this point, we know that start <= next_sym_value */
        if (end > next_sym_value) {
            /* yes, this is a replaced region */
            /* basically, zap the unwind descriptor */
            data[i].flags &= 0x40000000;  /* KEEP MILLICODE BIT */
            data[i].fsize = 0;

            /* make sure that the routine has at least 3 instructions */
            if (end - start < (3*WORDSIZE)) 
	        user_error(CANT_RELINK_ROUTINE, 
                               Sym_Dict(sym_index).name.n_name, 0);
        }
    }

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);
} /* end relocate_unwind */

relocate_stub_unwind(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
struct stub_desc *data;
{
    int i;

    i = subsp->initialization_length / sizeof(struct stub_desc);
    if (i == 0)
        return;

    for ( ; --i >= 0; ) {
        data[i].addr += code_reloc_factor;
    }

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);
} /* end relocate_stub_unwind */

relocate_recover(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
struct rdesc *data;
{
    int i;

    i = subsp->initialization_length / sizeof(struct rdesc);

    for ( ; --i >= 0; ) {
        data[i].start += code_reloc_factor;
        data[i].end += code_reloc_factor;
        data[i].recover += code_reloc_factor;
    }

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);
} /* end relocate_recover */

relocate_aux_unwind(subsp, file_loc, data)
struct subspace_dictionary_record *subsp;
int file_loc;
struct aux_udesc *data;
{
    int i;

    i = subsp->initialization_length / sizeof(struct aux_udesc);
    if (i == 0)
        return;

    for ( ; --i >= 0; ) {
        data[i].cu_name += code_reloc_factor;
        data[i].scope_name += code_reloc_factor;
        data[i].line_number_tbl += code_reloc_factor;
    }

    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);
} /* end relocate_aux_unwind */

#define FRU_STUB_LEN (3*WORDSIZE)

struct relink_indices *relocate_old_subspace(subsp_index, subsp, file_loc, 
					     data, relink_list)
int subsp_index;
struct subspace_dictionary_record *subsp;
int file_loc;
int *data;
struct relink_indices *relink_list;
{
    int fixup_count, nfixups;
    Fixup *fixup, *fixup_start;
    int fixop;
    int old, new;
    int sym_index, sym_subsp;
    int new_index;
    int fixup_offset, symbol_offset, symbol_difference, len;

    len = subsp->initialization_length;
    nfixups = subsp->fixup_request_quantity;

    if (nfixups > 0) {
        if (save_fixups) {
            ffetch(fixup_fildes,subsp->fixup_request_index,subsp_fixup_area,
        	        sizeof(Fixup),
        	        nfixups);
            fixup_area_first = subsp->fixup_request_index;
            fixup_area_count = nfixups;
            fixup_start = subsp_fixup_area;
        } else {
            fixup_start = (Fixup *) subsp->fixup_request_index;
        }
    } else
        fixup_start = NULL;

    fixup = fixup_start;

    /* we need to traverse the relink list in parallel with the fixups */

    fixup_count = 0;

    symbol_offset = -1;
    fixup_offset = -1;

    for (;;) {
        if (symbol_offset < 0) {
            /* get next symbol_offset */
            sym_index = relink_list->old_sym;
	    new_index = relink_list->new_sym;

            if (sym_index == BAD_SYM ||
                (sym_subsp = Sym_Subsp(sym_index)) > subsp_index)
                symbol_offset = len;
            else if (sym_subsp < subsp_index)
                internal_error(RELINK_LIST_BOTCH, 0);
            else {
                relink_list++;
                /* Sym_Subsp(sym_index) matches */
                /* get ORIGINAL subspace offset */
                symbol_offset =
                    (Sym_Dict(sym_index).symbol_value &~ CLEAR_SYM_XL) -
                        Subsp_Dict(sym_subsp).subspace_start;
                /* 
		** get difference, which is NEW subspace offset of the new
                ** location (of the remapped symbol), minus the
                ** ORIGINAL subspace offset, minus 2*WORDSIZE
                */
                symbol_difference =
                    ((symbol_value(new_index) &~ CLEAR_SYM_XL) -
                        Subspace_Virtual_Offset(sym_subsp)) -
                    symbol_offset - 2*WORDSIZE; 

            }
        } /* symbol_offset < 0 */

        if (fixup_offset < 0) {
            if (fixup_count >= nfixups)
                fixup_offset = len+FRU_STUB_LEN;
            else {
                /* get fixup_offset and fixop */
                fixup_count += 5;
                fixop = *fixup++;
                if (fixop == R_NOP) {
                    fixup += 4;         /* we zapped a previous fixup */
                    continue;           /* skip this and try again */
                }
                fixup_offset = *fixup++ << 24;
                fixup_offset |= *fixup++ << 16;
                fixup_offset |= *fixup++ << 8;
                fixup_offset |= *fixup++;
            }
        }

        if (fixup_offset < symbol_offset) {
            /* this also implies that fixup_offset < len */
            /* Fixup_offset is a byte value -- convert to word value (>> 2) */
            /* before accessing data                                        */
            fixup_offset >>= 2;
            old = data[fixup_offset];
            /* apply the fixup */
            switch (fixop) {
	        case R_ABS_DATA:
	            data[fixup_offset] = old + code_reloc_factor;
	            break;
	        case R_ABS_CODE:
     	            /* reloc_factor is guaranteed to be a multiple */
     	            /* of the page size (2K), so we don't have to  */
     	            /* worry about any instructions but LDIL/ADDIL */
     	            switch (GET_OP(old)) {
     	    	        case 0x08:      /* LDIL */
     	    	        case 0x0a:      /* ADDIL */
     	    	            new = GET21(old) << 11;
     	    	            new += code_reloc_factor;
     	    	            new = fix_field(new, 0, e_lsel);
     	    	            new = fix_format(old, new, i_exp21, SR_IS_VALID);
     	    	            data[fixup_offset] = new;
			    break;
     	    	    }
	            break;
            } /* switch */

            fixup_offset = -1;
            /* we will advance fixup_offset next time through the loop */

        } else if (fixup_offset < symbol_offset+FRU_STUB_LEN) {
            /* symbol_offset <= fixup_offset < symbol_offset+FRU_STUB_LEN */
            /* note that this implies fixup_offset < len */
            /* ZAP this fixup */

            fixup[-5] = fixup[-4] = fixup[-3] = fixup[-2] = fixup[-1] = R_NOP;
            fixup_offset = -1;
        } else {
            /* fixup_offset >= symbol_offset+FRU_STUB_LEN */
            /* if symbol_offset >= len then we are done */
            if (symbol_offset >= len)
                break;

            /* drop down the stub code */
            symbol_offset >>= 2;

            data[symbol_offset] = BLR_0_1;
            data[symbol_offset+1] =
                fix_format(ADDIL_R1,
                           fix_field(symbol_difference, 0, e_lsel),
                           i_exp21,
                           SR_IS_VALID);
            data[symbol_offset+2] =
                fix_format(BE_SR4_R1_NULL,
                           fix_field(symbol_difference, 0, e_rsel),
                           i_abs17,
                           SR_IS_VALID);
            /* go to next symbol_offset */
            symbol_offset = -1;
        } /* else */
    } /* for */

    /* write out the data */
    fdump(out_som_fd, file_loc, data, 1, subsp->initialization_length);
    /* write the absolute fixups out too */
    fdump(out_som_fd, abs_fix_loc, fixup_start, 1, nfixups);
    out_abs_fixup_count += nfixups;
    return (relink_list);
} /* end relocate_old_subspace */

output_retrieve(buff, loc, lastloc, size)
char *buff;
int loc, lastloc;
int size;
{
    if (size > lastloc - loc)
	size = lastloc - loc;
    ffetch(out_som_fd, loc, buff, 1, size);

} /* end output_retrieve */

void build_stub_unwind_desc(subsp, file_loc)
struct subspace_dictionary_record *subsp;
int file_loc;
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp, ind, prev_type;
    struct  subsp_misc_record *misc;
    struct  stub_record	      *stub;
    struct  stub_desc	      *stub_desc_ptr;
    char *start;
    int len;

    len = subsp->subspace_length - subsp->initialization_length;
    if (len == 0)
	return;

    if (verbose & V_DEBUG)
	printf(ld_gets(1, 1187, "malloc 0x%x bytes\n"), len);

    start = (char *) emalloc(len);
    stub_desc_ptr = (struct  stub_desc *) start;
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	if (space_array[sp_index].is_loadable) {
	    /* for all subspaces */
	    subsp_index = space_array[sp_index].subspace_index;
	    num_subsp  = space_array[sp_index].subspace_quantity;
	    for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
		old_index = Subsp_Misc(subsp_index).r_n_x;
		misc  = &Subsp_Misc(old_index);
		prev_type = 0;
	        /* for all stubs */
		for (stub = misc->stub_list;
    		     stub != NULL;
                     stub = stub->next_stub) {
		    if (stub->type == LOCAL_RELOC_STUB ||
			stub->type == EXPORT_RELOC_STUB ||
    		        stub->type != prev_type) {
		        /* add new stub descriptor */
		        if (stub->type == HPUX_EXPORT_STUB_NO_RP)
		            stub_desc_ptr->type = 9; 
			else if (stub->type == HPUX_IMPORT_STUB_NO_RP)
		            stub_desc_ptr->type = 6; 
			else
		            stub_desc_ptr->type = stub->type;
		        ind = stub->subsp_index;
		        stub_desc_ptr->addr =
		            Subsp_Misc(ind).new_subspace_start +
		            stub->subsp_off;
		        /* stub_length is in words */
		        stub_desc_ptr->length = stub->length / 4;
		        stub_desc_ptr->reloclen = stub->arg_reloc_size / 4;
		        stub_desc_ptr->mbz1 = 0;
		        stub_desc_ptr->mbz2 = 0;
		        prev_type = stub->type;
		        if (verbose & V_DEBUG) {
			    printf(ld_gets(1, 1188, "one stub desc added!\n"));
			    printf(ld_gets(1, 
					   1189, 
					   "type: %x, addr: %x length: %x\n"),
				   stub_desc_ptr->type,
				   stub_desc_ptr->addr,
				   stub_desc_ptr->length);
		        }
		    } else {
		        /* back to the previous one */
		        stub_desc_ptr--;
		        stub_desc_ptr->length += stub->length / 4;
		        if (verbose & V_DEBUG) {
	                    printf(ld_gets(1, 
					   1190, 
					   "one stub desc expanded!\n"));
	                    printf(ld_gets(1, 
					   1191, 
					   "type: %x, addr: %x length: %x\n"),
				   stub_desc_ptr->type,
				   stub_desc_ptr->addr,
				   stub_desc_ptr->length);
 		        }
		    }
	            /* move to next position */
	            stub_desc_ptr++;
	        }
	    }
	}
    }
    fdump(out_som_fd, file_loc, start, 1, len);
    efree(start);
} /* build_stub_unwind_desc */

#define MAX_UNWIND_KNT  8192
#define MAX_RECOVER_KNT 16
#define MAX_COPYRAM_KNT 16

static struct udesc     unwind_output[MAX_UNWIND_KNT];
static struct aux_udesc aux_unwind_output[MAX_UNWIND_KNT];
static struct rdesc     recover_output[MAX_RECOVER_KNT];
static char             line_table_output[MAX_LINE_TBL_SZ];
static union copyram_desc     copyram_output[MAX_COPYRAM_KNT];


init_unwind_recover_build(misc)
struct subsp_misc_record *misc;
{
    int computed_loc, new_loc;

    if (unwind_subsp != BAD_SUBSP && misc->unwind_index != -1) {
        computed_loc = curr_unwind_file_loc +
                                unwind_count*sizeof(struct udesc);
        new_loc = Subsp_Misc(unwind_subsp).exec_file_offset +
                                misc->unwind_index*sizeof(struct udesc);


        if (new_loc != computed_loc) {
            old_unwind_count -= unwind_count;
            /* flush current unwind entries */
            if (unwind_count != 0)
                fdump(out_som_fd, curr_unwind_file_loc,
                      unwind_output, unwind_count, sizeof(struct udesc));
            if (recover_end_subsp != BAD_SUBSP) {
                if (generate_aux_unwind) {
                    if (unwind_count != 0)
                        fdump(out_som_fd, curr_aux_unwind_file_loc,
                              aux_unwind_output, unwind_count, 
                              sizeof(struct aux_udesc));
                    curr_aux_unwind_file_loc = 
                               Subsp_Misc(recover_end_subsp).exec_file_offset +
                               WORDSIZE + 
                               misc->unwind_index * sizeof(struct udesc);
                    
                    
                }
            }
            unwind_count = 0;
            aux_unwind_count = 0;
            curr_unwind_file_loc = new_loc;
        }
    }

    if (recover_subsp != BAD_SUBSP && misc->recover_index != -1) {
        computed_loc = curr_recover_file_loc +
                                recover_count*sizeof(struct rdesc);
        new_loc = Subsp_Misc(recover_subsp).exec_file_offset +
                                misc->recover_index*sizeof(struct rdesc);

        if (new_loc != computed_loc) {
            old_recover_count -= recover_count;
            /* flush current recover entries */
            if (recover_count != 0)
                fdump(out_som_fd, curr_recover_file_loc,
                      recover_output, recover_count, sizeof(struct rdesc));
            recover_count = 0;
            curr_recover_file_loc = new_loc;
        }
    }

    if (generate_aux_unwind && 
        misc->unwind_index != -1 && 
	recover_end_subsp != BAD_SUBSP) {

        computed_loc = curr_line_tbl_file_loc + line_table_offset;

        new_loc = Subsp_Misc(recover_end_subsp).exec_file_offset +
                             aux_unwind_size + WORDSIZE + 
			     misc->line_tbl_offset;

	/*
	** Don't round new_loc (or curr_line_tbl_file_loc) - let 
	** make_line_tbl_entry() do it when it initializes the new line table 
	*/

        if (new_loc != computed_loc) {
            /* flush current line entries */
            if (line_table_offset != 0)
                fdump(out_som_fd, curr_line_tbl_file_loc,
                      line_table_output, line_table_offset, 1);
            line_table_offset = 0;
            curr_line_tbl_file_loc = new_loc;
        }

    }
    /*Embedded systems code */
    if (copyram_subsp != BAD_SUBSP && misc->copyram_index != -1) {
        computed_loc = curr_copyram_file_loc +
                                copyram_count*sizeof(union copyram_desc);
        new_loc = Subsp_Misc(copyram_subsp).exec_file_offset +
                     misc->copyram_index* sizeof(union copyram_desc);

        if (new_loc != computed_loc) {
            old_copyram_count -= copyram_count;         
            /* flush current copyram entries */
            if (copyram_count != 0)
                fdump(out_som_fd, curr_copyram_file_loc,
                    copyram_output, copyram_count, sizeof(union copyram_desc));
            copyram_count = 0;
            curr_copyram_file_loc = new_loc;
        }
    }
} /* init_unwind_recover_build */

make_unwind_region(region_desc)
int region_desc;
{
    struct udesc     *uptr;
    struct aux_udesc *aux_uptr;

    if (unwind_subsp == BAD_SUBSP)
        return;

    if (unwind_branch_dot != branch_dot) {
        uptr = & unwind_output[unwind_count++];
        uptr->start = unwind_branch_dot-8;
        uptr->end = branch_dot-12;
        uptr->flags = unwind_bits | region_desc;
        uptr->fsize = frame_size;

        /* make aux_unwind_entry */
        if (generate_aux_unwind) {
            aux_uptr = & aux_unwind_output[aux_unwind_count++];
            aux_uptr->cu_name = curr_aux_unwind.cu_name;
            aux_uptr->scope_name = curr_aux_unwind.scope_name;
            aux_uptr->scope_kind = curr_aux_unwind.scope_kind;
            aux_uptr->line_number_tbl = curr_aux_unwind.line_number_tbl;
            if (curr_aux_unwind.line_number_tbl != 0) {
                /* terminate line number table (with a 255,0 pair) */
                line_table_output[line_table_offset++] = 255; 
                line_table_output[line_table_offset++] = 0; 

		/* advance virtual address as well */
		line_table_virtual_addr += LINE_ENT_SZ;

                /* reset line table field to zero */
                curr_aux_unwind.line_number_tbl = 0;
            }
        }
        
        if (unwind_count == MAX_UNWIND_KNT) {
            old_unwind_count -= MAX_UNWIND_KNT;
            fdump(out_som_fd, curr_unwind_file_loc,
                  unwind_output, MAX_UNWIND_KNT, sizeof(struct udesc));
            if(generate_aux_unwind) {
                fdump(out_som_fd, curr_aux_unwind_file_loc, aux_unwind_output, 
                      MAX_UNWIND_KNT, sizeof(struct aux_udesc));
                aux_unwind_count = 0;
                curr_aux_unwind_file_loc += 
                                       MAX_UNWIND_KNT*sizeof(struct aux_udesc);
            }
            unwind_count = 0;
            curr_unwind_file_loc += MAX_UNWIND_KNT*sizeof(struct udesc);
        }
    }
    unwind_branch_dot = branch_dot;
} /* make_unwind_region */

make_recover_region(offset)
int offset;
{
    struct rdesc * rptr;

    if (recover_subsp == BAD_SUBSP)
        return;

    rptr = & recover_output[recover_count++];
    rptr->start = recover_branch_dot-8;
    rptr->end = branch_dot-8;
    rptr->recover = rptr->end + offset;
    if (recover_count == MAX_RECOVER_KNT) {
        old_recover_count -= MAX_RECOVER_KNT;
        fdump(out_som_fd, curr_recover_file_loc,
              recover_output, MAX_RECOVER_KNT, sizeof(struct rdesc));
        recover_count = 0;
        curr_recover_file_loc += MAX_RECOVER_KNT*sizeof(struct rdesc);
    }
} /* make_recover_region */

static int     prev_line_number;
static int     prev_line_addr;
static Boolean prev_was_secondary;
#define LINE_TBL_FDUMP_CHECK MAX_LINE_TBL_SZ-LINE_ENT_SZ-SEC_ENT_SZ

make_line_tbl_entry(line_addr, line_number, secondary)
unsigned int line_addr; /* line_addr is a word offset */
int line_number;
Boolean secondary;  /* secondary stmt override */
{
        int   i;
        int   ovfl_size = 0;
        int   sec_ovfl = 0;
        int   line_num_delta;
        int   line_addr_delta;
	int   temp;
        static int   sec_line_number;

        if(!curr_aux_unwind.line_number_tbl) { /* start new line table */
            if (line_table_offset + INIT_LINE_ENT_SZ >= MAX_LINE_TBL_SZ) {
                /* flush current line_table_buffer */
                fdump(out_som_fd, curr_line_tbl_file_loc,
                      line_table_output, line_table_offset, sizeof(char));
                curr_line_tbl_file_loc += line_table_offset;
                line_table_offset = 0;
            } 
            /* need a new line number table */
            /* Increase the line_table_offset by the amount the virtual */
	    /* address needs to be aligned */ 
	    /* Eventually, virt. addr should be computed */
	    /* from the offset as opposed to incremented in parallel */

            temp = (line_table_virtual_addr + WORDSIZE -1) & ~(WORDSIZE-1);

	    /* add to offset the same amount we rounded the virtual addr */
	    line_table_offset += (temp - line_table_virtual_addr); 

 	    /* Set va to rounded value */
            line_table_virtual_addr = temp;

            /* Fill in byte by byte - offset might not land on a word */
	    /* boundary, but va will! */
	    line_table_output[line_table_offset++] = 
	      (LINE_TABLE_VERSION >> 24);
	    line_table_output[line_table_offset++] = 
	      (LINE_TABLE_VERSION >> 16);
	    line_table_output[line_table_offset++] = (LINE_TABLE_VERSION >> 8);
	    line_table_output[line_table_offset++] = LINE_TABLE_VERSION;
	    temp = line_addr*WORDSIZE - (unwind_branch_dot-8);
	    line_table_output[line_table_offset++] = (temp >> 24);
	    line_table_output[line_table_offset++] = (temp >> 16);
	    line_table_output[line_table_offset++] = (temp >> 8);
	    line_table_output[line_table_offset++] = temp;
	    line_table_output[line_table_offset++] = (line_number >> 24);
	    line_table_output[line_table_offset++] = (line_number >> 16);
	    line_table_output[line_table_offset++] = (line_number >> 8);
	    line_table_output[line_table_offset++] = line_number;

	    /* must place into buffer as bytes instead of ints  */
            /* line_tbl_ptr = &line_table_output[line_table_offset]; */
            /* line_tbl_ptr++ = LINE_TABLE_VERSION; */
            /* line_tbl_ptr++ = line_addr*WORDSIZE - (unwind_branch_dot-8); */
            /* line_tbl_ptr = line_number; */
            /* line_table_offset += 12; */

            curr_aux_unwind.line_number_tbl = (char *) line_table_virtual_addr;
            line_table_virtual_addr += 12;
            prev_was_secondary = FALSE;
        } else {
            /* normal/secondary line table entry */

            /* When creating a secondary line number, first a normal   */
            /* line entry is made -- then a secondary entry -- this is */
            /* so multiple secondary statement entries can be created  */
            /* for a single primary statement fixup.                   */
            /* If the previous pass through was a secondary entry then */
            /* a duplicate secondary entry must be emitted for each    */
            /* overflow entry -- NOTE: this currently doesn't handle   */
            /* multiple secondary entries in the presence of overflow. */

            if(secondary) {
                sec_line_number = line_number;
                line_number = prev_line_number;
            }
            line_num_delta = line_number - prev_line_number;
            line_addr_delta = line_addr - prev_line_addr;

            if(line_addr_delta > CODE_DIFF_MAX) {
                /* need to add overflow entries */
                ovfl_size = ((line_addr_delta-1)/CODE_DIFF_MAX) * LINE_ENT_SZ;
                if (prev_was_secondary) {
                    sec_ovfl = ((line_addr_delta-1)/CODE_DIFF_MAX) * 
		               SEC_ENT_SZ;
                } else {
                    sec_ovfl = 0;
                }

                for(i=0; i < ovfl_size/LINE_ENT_SZ; i++) {
                    if(line_table_offset >= LINE_TBL_FDUMP_CHECK) {
                        /* flush current line_table_buffer */
                        fdump(out_som_fd, curr_line_tbl_file_loc,
                              line_table_output, line_table_offset, 1);
                        curr_line_tbl_file_loc += line_table_offset;
                        line_table_offset = 0;
                    }
                    line_table_output[line_table_offset++] = CODE_DIFF_MAX;
                    line_table_output[line_table_offset++] = 0;
                    /* make the secondary entry if needed */
                    if(prev_was_secondary) {
                        make_sec_line_tbl_entry(sec_line_number);
                    }
		    line_addr_delta -= CODE_DIFF_MAX;
                } /* for */

                /* last overflow should have line_num_delta */
                if(line_table_offset >= (MAX_LINE_TBL_SZ-LINE_ENT_SZ)){
                    /* flush current line_table_buffer */
                    fdump(out_som_fd, curr_line_tbl_file_loc,
                          line_table_output, line_table_offset, sizeof(char));
                    curr_line_tbl_file_loc += line_table_offset;
                    line_table_offset = 0;
                } 
                line_table_output[line_table_offset++] = line_addr_delta;

                if (line_num_delta > 0) {
                   temp = min (line_num_delta, LINE_DIFF_MAX);
                } else {
                   temp = max (line_num_delta, LINE_DIFF_MIN);
                }

                line_table_output[line_table_offset++] = temp;
                line_num_delta -= temp;
                line_table_virtual_addr += LINE_ENT_SZ;

                line_addr_delta = 0;
                line_table_virtual_addr += ovfl_size + sec_ovfl;
            }

            if (line_num_delta > LINE_DIFF_MAX) {
		/* now account for line overflow entries */
                ovfl_size = ((line_num_delta-1)/LINE_DIFF_MAX) * LINE_ENT_SZ;
                if(prev_was_secondary) {
                    sec_ovfl = ((line_num_delta-1)/LINE_DIFF_MAX) * SEC_ENT_SZ;
                } else {
                    sec_ovfl = 0;
                }

                if (line_table_offset >= MAX_LINE_TBL_SZ-4 * LINE_ENT_SZ - 4 *
		    sec_ovfl){
                    /* flush current line_table_buffer */
                    fdump(out_som_fd, curr_line_tbl_file_loc,
                          line_table_output, line_table_offset, sizeof(char));
                    curr_line_tbl_file_loc += line_table_offset;
                    line_table_offset = 0;
                } 

                if (ovfl_size > ABS_ENT_SZ) {
                    /* 
		    ** then put out an code diff entry followed by an absolute 
                    ** line entry  
		    */
                    line_table_output[line_table_offset++] = line_addr_delta;
                    line_table_output[line_table_offset++] = 0;
                    line_table_output[line_table_offset++] = ABS_ENT;
                    line_table_output[line_table_offset++] = line_number >> 16;
                    line_table_output[line_table_offset++] = line_number >> 8;
                    line_table_output[line_table_offset++] = line_number;

                    if (prev_was_secondary) {
                        make_sec_line_tbl_entry(sec_line_number);
                        line_table_virtual_addr += SEC_ENT_SZ;
                    }

                    line_addr_delta = line_num_delta = 0;

		    /*
                    ** three entries more, secondary overflow was added 
                    ** above 
		    */
                    line_table_virtual_addr += (LINE_ENT_SZ * 3);
                } else {
		    temp = min (line_num_delta, LINE_DIFF_MAX);
                    line_table_output[line_table_offset++] = line_addr_delta;
                    line_table_output[line_table_offset++] = temp;
                    line_num_delta -= temp;
                    line_table_virtual_addr += LINE_ENT_SZ;

                    for(i=0; i < ovfl_size/LINE_ENT_SZ; i++) {
                        line_table_output[line_table_offset++] = 0;
                        line_table_output[line_table_offset++] = 
					     min(line_num_delta,LINE_DIFF_MAX);
                        /* make the secondary entry if needed */
                        if (prev_was_secondary) {
                            make_sec_line_tbl_entry(sec_line_number);
                        }
		        line_num_delta -= LINE_DIFF_MAX;
                    }

                    line_addr_delta = 0;
                    /* If we "underflowed", correct to no remaining delta */
                    if (line_num_delta < 0) line_num_delta = 0;
 
		    /* update virtual address with overflow sizes */
                    line_table_virtual_addr += ovfl_size + sec_ovfl;

                }
            } else if(line_num_delta < LINE_DIFF_MIN) {
                /* now account for line overflow entries */
                ovfl_size = -1 * (((-line_num_delta-1)/LINE_DIFF_MIN) * 
				  LINE_ENT_SZ);
                if(prev_was_secondary) {
                    sec_ovfl = -1 * (((line_num_delta-1)/LINE_DIFF_MIN) * 
				     SEC_ENT_SZ);
                } else {
                    sec_ovfl = 0;
                }
                if (line_table_offset >= MAX_LINE_TBL_SZ - 4 * LINE_ENT_SZ -4 *
		    sec_ovfl){
                    /* flush current line_table_buffer */
                    fdump(out_som_fd, curr_line_tbl_file_loc,
                          line_table_output, line_table_offset, sizeof(char));
                    curr_line_tbl_file_loc += line_table_offset;
                    line_table_offset = 0;
                } 

                if(ovfl_size > ABS_ENT_SZ) {
                    /* then put out a code diff entry followed by an absolute 
                       line entry  */
                    line_table_output[line_table_offset++] = line_addr_delta;
                    line_table_output[line_table_offset++] = 0;
                    line_table_output[line_table_offset++] = ABS_ENT;
                    line_table_output[line_table_offset++] = line_number >> 16;
                    line_table_output[line_table_offset++] = line_number >> 8;
                    line_table_output[line_table_offset++] = line_number;

                    if(prev_was_secondary) {
                        make_sec_line_tbl_entry(sec_line_number);
                        line_table_virtual_addr += SEC_ENT_SZ;
                    }

                    line_addr_delta = line_num_delta = 0;

                    /* 
		    ** three entries more, secondary overflow was added above 
		    */
                    line_table_virtual_addr += (LINE_ENT_SZ * 3);
                } else {
                    temp = max (line_num_delta, LINE_DIFF_MIN);
                    line_table_output[line_table_offset++] = line_addr_delta;
                    line_table_output[line_table_offset++] = temp;
                    line_num_delta -= temp;
                      line_table_virtual_addr += LINE_ENT_SZ;

                    for(i=0; i < ovfl_size/LINE_ENT_SZ; i++) {
                        line_table_output[line_table_offset++] = 0;
                        line_table_output[line_table_offset++] = 
					     max(line_num_delta, 
						 LINE_DIFF_MIN);
                        /* make the secondary entry if needed */
                        if(prev_was_secondary) {
                            make_sec_line_tbl_entry(sec_line_number);
                        }
		        line_num_delta -= LINE_DIFF_MIN;
                    }
 
                    line_addr_delta = 0;
                    /* If we "underflowed", correct to no remaining delta */
                    if (line_num_delta > 0) line_num_delta = 0;
 
                    /* update virtual address with overflow sizes */
                    line_table_virtual_addr += ovfl_size + sec_ovfl;
                }
            }

	    /* Only add in an entry if there were differences. No entry */
	    /* is generated if there were no differences. */
            if ((line_addr_delta != 0) || (line_num_delta != 0)) {
	        /* Add in 1 entry to va */
                line_table_virtual_addr += LINE_ENT_SZ;
	    }

            if (line_table_offset + LINE_ENT_SZ >= MAX_LINE_TBL_SZ) {
                /* flush current line_table_buffer */
                fdump(out_som_fd, curr_line_tbl_file_loc,
                      line_table_output, line_table_offset, sizeof(char));
                curr_line_tbl_file_loc += line_table_offset;
                line_table_offset = 0;
            } 

            /*
              Only emit a line entry if 1) it wasn't emitted during
              overflow processing and 2) the deltas are non-zero.  Note
              that the !ovfl_size&& condition has been removed as it was
              unreliable when both the address delta and the line number
              delta overflowed at the same time.  First the address
              overflow would set ovfl_size, but then if the line number
              overflow was small enough (only 1 overflow), ovfl_size would
              get cleared.  We could have simply forced ovfl_size to
              non-zero at the end of line number overflow processing.
              Instead we chose to force both of the deltas to zero in each
              of the overflow processing paths when no further processing
              is needed as it is a clearer indication that there is
              nothing left to do.
            */

            if ((line_addr_delta != 0) || (line_num_delta != 0)) {
                line_table_output[line_table_offset++] = line_addr_delta;
                line_table_output[line_table_offset++] = line_num_delta;
            }

        } /* end else - normal/secondary line table entry */

        if (secondary) {
            if (line_table_offset + SEC_ENT_SZ >= MAX_LINE_TBL_SZ) {
               /* flush current line_table_buffer */
               fdump(out_som_fd, curr_line_tbl_file_loc,
                     line_table_output, line_table_offset, sizeof(char));
               curr_line_tbl_file_loc += line_table_offset;
               line_table_offset = 0;
            } 
            make_sec_line_tbl_entry(sec_line_number);
            prev_was_secondary = TRUE;

	    /* bump up virtual address */
            line_table_virtual_addr += SEC_ENT_SZ;
        } else if (prev_was_secondary) {
            prev_was_secondary = FALSE;
    }

    prev_line_number = line_number;
    prev_line_addr = line_addr;
} /* end make_line_tbl_entry */

make_sec_line_tbl_entry(sec_line_number)
int sec_line_number;
{
    line_table_output[line_table_offset++] = 251;
    line_table_output[line_table_offset++] = sec_line_number >> 16;
    line_table_output[line_table_offset++] = sec_line_number >> 8;
    line_table_output[line_table_offset++] = sec_line_number;
}

#define SPACE_ENTRY     1

/* Embedded systems code */
make_copyram_entry(type, init, size, to_loc)
int type;              /* space or size entry */
Boolean init;
int size;
unsigned int to_loc;
{
    union copyram_desc * cptr;

    if (copyram_subsp == BAD_SUBSP || curr_copyram_index == -1)
        return;

    /* Fill in this entry in the copyram_table */
    cptr = &c_table[curr_copyram_index++];
    if (type == SPACE_ENTRY) {     /* create a space entry */
        cptr->space_entry.addr = size;
	cptr++;
        cptr->space_entry.addr = to_loc;
    } else {
	/* create a size entry */
        cptr->size_entry.size += size;
        cptr->size_entry.initialize = init;
        /* don't touch end flags - might already be set */ 
	/* cptr->size_entry.end_space = FALSE;
        cptr->size_entry.end_table = FALSE;
        cptr->size_entry.reserved = 0; */ /* init for future use */
   }
}

flush_unwind_recover_desc() 
{
    if (unwind_subsp != BAD_SUBSP) {
        if (unwind_count != old_unwind_count)
            internal_error(UNWIND_MISCOUNT, 0);

        if (unwind_count != 0)
            fdump(out_som_fd, curr_unwind_file_loc,
                  unwind_output, unwind_count, sizeof(struct udesc));
    }

    if (recover_subsp != BAD_SUBSP) {
        if (recover_count != old_recover_count)
            internal_error(RECOVER_MISCOUNT, 0);

        if (recover_count != 0)
            fdump(out_som_fd, curr_recover_file_loc,
                  recover_output, recover_count, sizeof(struct rdesc));
    }
    /* Embedded systems code */
    if (c_table != NULL) {
	/* Output copyram table */
	curr_copyram_file_loc = Subsp_Misc(copyram_subsp).exec_file_offset;
        fdump(out_som_fd, curr_copyram_file_loc,
                   c_table, old_copyram_count, sizeof(union copyram_desc));
    }

    if (generate_aux_unwind && (recover_end_subsp != BAD_SUBSP)) {
        if (aux_unwind_count != unwind_count) {
            internal_error(AUX_UNWIND_MISCOUNT, 0);
        }

        if (aux_unwind_count != 0)
            fdump(out_som_fd, curr_aux_unwind_file_loc, aux_unwind_output, 
                  aux_unwind_count, sizeof(struct aux_udesc));

        fdump(out_som_fd, curr_line_tbl_file_loc, line_table_output, 
              line_table_offset, sizeof(char));
    }
}

void out_stubs(old_index, misc)
int old_index;
struct subsp_misc_record *misc;
{
    char    *stub_area;
    int size;

    if (!(size = Subsp_Stubs_Size(old_index)))
        return;
    stub_area = build_stubs(old_index, size);
    fdump(out_som_fd,misc->stubs_file_loc,stub_area,1,size);
}

void build_sym_strings()
{
    int i;
    struct symbol_dictionary_record *sym;
    struct compilation_unit *comp;
    struct header_node *comp_area;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
				    means 'seen before in this search' */

    build_string_sort (&sym_strings);

    /* if no symbols, don't dereference a null pointer */
    if (sym_dict_size > 0) 
        seen_before = !Sym_Misc(0).checked; /*inverse of value from 
                                              last search*/

    for (i = 0; i < sym_dict_size; i++) {

	/* if this entry was previously visited, don't count it again */
	if (Sym_Misc(i).checked == seen_before)
	    continue;

        /* toggle all bits for next search */
	Sym_Misc(i).checked = seen_before; 

	sym = &Sym_Dict(i);
	if (sym->symbol_type == ST_NULL || 
            (OPTIONAL_PROC(i) && !relocatable) ||
	        sym->symbol_type == ST_SYM_EXT ||
	        sym->symbol_type == ST_ARG_EXT)
	    continue;

	if ((Sym_Dict(i).symbol_type == ST_MILLI_EXT)
             && !Sym_Misc(i).referenced)
            continue;     /* dont output unreferenced ext milli sym strings*/

	if ((strip_local_symbols) && (sym->symbol_scope == SS_LOCAL))
	    continue;

        /* if this sym was remapped to a previous sym it's name has already
	   been converted to an offset and output, so don't try to again */
	if (sym->name.n_strx < QUAD_1_BASE)
	    continue;

	sym->name.n_strx = string_offset_sorted (sym->name.n_name, 
                                                 &sym_strings);
	if (sym->qualifier_name.n_name != NULL) 
	    sym->qualifier_name.n_strx = 
			   string_offset_sorted (sym->qualifier_name.n_name, 
			   		         &sym_strings);

    }

    for (comp_area = compiler_head; comp_area != NULL;
    	                            comp_area = comp_area->next) {
	comp = (struct compilation_unit *) (comp_area + 1);
	for (i = comp_area->size; i > 0;
	                          i -= sizeof(struct compilation_unit)) {

	    if (comp->name.n_name != NULL) 
	        comp->name.n_strx = string_offset_sorted (comp->name.n_name, 
					                  &sym_strings);
	    if (comp->language_name.n_name != NULL) 
	        comp->language_name.n_strx = 
		             string_offset_sorted(comp->language_name.n_name,
 				                  &sym_strings);
	    if (comp->product_id.n_name != NULL) 
	        comp->product_id.n_strx = 
	                        string_offset_sorted (comp->product_id.n_name, 
						      &sym_strings);
	    if (comp->version_id.n_name != NULL) 
	        comp->version_id.n_strx = 
			        string_offset_sorted (comp->version_id.n_name, 
						      &sym_strings);
	    comp++;
	}
    }
} /* end build_sym_strings */

int sort_loader_fixup(ldr_fxp_1, ldr_fxp_2)
struct loader_fixup *ldr_fxp_1;
struct loader_fixup *ldr_fxp_2;
{
    if (ldr_fxp_1->space_index != ldr_fxp_2->space_index)
        return (ldr_fxp_1->space_index - ldr_fxp_2->space_index);
    return (ldr_fxp_1->space_offset - ldr_fxp_2->space_offset);
}

void out_loader_fixup(header_loc)
int header_loc;
/* copy loader_fixup to output som */
{
    int index, total_so_far;

    if (loader_fixup_size != loader_fixup_index)
        internal_error(WRNG_LODR_FXP_COUNT, 0);
    qsort(loader_fixup_array,
          loader_fixup_size,
          sizeof(struct loader_fixup),
          (int (*)(const void *, const void *)) sort_loader_fixup
         );
    fdump(out_som_fd,header_loc,loader_fixup_array,
		sizeof(struct loader_fixup),loader_fixup_size);

    /* index through the spaces */
    for (index = 0; index < cur_space_total; index++)
        space_array[index].loader_fix_quantity = 0;

    /* index through the fixups */
    for (index = 0; index < loader_fixup_size; index++)
      space_array[loader_fixup_array[index].space_index].loader_fix_quantity++;

    total_so_far = 0;

    /* index through the spaces */
    for (index = 0; index < cur_space_total; index++) {
        space_array[index].loader_fix_index = total_so_far;
        total_so_far += space_array[index].loader_fix_quantity;
    }

}/* end out_loader_fixup */

void out_symbol_records(header_loc)
int    header_loc;
/* update symbol_records total and symbol_records loc in som header then */
/* copy symbol_records to output som                                    */
{
    struct symbol_dictionary_record sym;
    int type, scope;
    int i, j, t, old_info, el_bits;
    int symbols_written = 0;
#define SYMBUFSIZE 400
    struct symbol_dictionary_record symbuf[SYMBUFSIZE], *symbufptr;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever
				    means 'seen before in this search' */

    symbufptr=symbuf;

    if (sym_dict_size > 0) /* If no symbols, don't derefence a null pointer */
      seen_before = !Sym_Misc(0).checked; /*inverse of value from last search*/
    for (i = 0; i < sym_dict_size; i++) {

	/* if this entry was previously visited, don't count it again */
	if (Sym_Misc(i).checked == seen_before)
	    continue;
          
	/* If this symbol has extension records, but they are not following
   	this symbol, skip it WITHOUT setting the checked bit, since
   	the extension records follow another index and we will deal with
   	the symbol and the extension records then. */
	if (i+1 < sym_dict_size) { /* Don't index off the end of the array */
	    if (Sym_Misc(i).has_ext_recs && Sym_Type(i+1) != ST_SYM_EXT)
                continue;
	}
	/* toggle all bits for next search */
	Sym_Misc(i).checked = seen_before; 

	/* don't output null records */
	if (Sym_Dict(i).symbol_type == ST_NULL ||
	    (OPTIONAL_PROC(i) && !relocatable))
            continue;

  	if ((Sym_Dict(i).symbol_type == ST_MILLI_EXT)
             && !Sym_Misc(i).referenced)
            continue;     /* do not output unreferenced external milli syms */

	if ((strip_local_symbols) &&
		Sym_Dict(i).symbol_type != ST_SYM_EXT &&
		Sym_Dict(i).symbol_type != ST_ARG_EXT &&
		Sym_Scope(i) == SS_LOCAL) {
	    /* strip all extension records too! */
	    for (j = i+1; j < sym_dict_size; j++) {
		t = Sym_Dict(j).symbol_type;
		if (t != ST_SYM_EXT && t != ST_ARG_EXT)
		    break;
		/**
		***  Set seen_before to skip this record only if it is
		***  an extension record.
		***/
		Sym_Misc(j).checked = seen_before; /* toggle for next search */
		}
	    i = j-1;
	    continue;
	    }
	/* 
	**
	** this case we do not want to zero out the secondary_def.
	*/
	if (!relocatable)
	    Sym_Dict(i).secondary_def = FALSE;
	old_info = Sym_Subsp(i);
	sym = Sym_Dict(i);
	type = sym.symbol_type;
        scope = sym.symbol_scope;
     
	/* remap symbol type for loader */
	switch (type) {
	    case ST_STUB_RELOC:
	    case ST_STUB_IMPORT:
	    case ST_FDP_COUNT:
                type = ST_STUB;
		break;
	    case ST_STUB_ENTRY:
                type = ST_ENTRY;
		break;
	    case ST_STUB_PRI_PROG:
                type = ST_PRI_PROG;
		break;
	    case ST_STUB_SEC_PROG:
                type = ST_SEC_PROG;
		break;
	    case ST_ENTRY:
	    case ST_PRI_PROG:
	    case ST_SEC_PROG:
                /* if we are allocating stubs (building UX shlib or MPE XLs) 
		   or dynamic loading on HPUX, then change the symbol type */
                if ((alloc_stubs_xl || alloc_stubs_ux || 
		     base_file_name != NULL) && scope == SS_UNIVERSAL)
                    type = ST_CODE;
		break;
	    default:		
                break;
    	    }
	sym.symbol_type = type;
	/* if type == ST_ARG_EXT || type == ST_SYM_EXT do nothing */
	if (type != ST_ARG_EXT && type != ST_SYM_EXT) {
	    el_bits = sym.symbol_value & 03;

            /* HP-UX shared library or executable */
	    if ((Sym_Remap_Type(i)==ST_STUB_IMPORT) && (old_info == BAD_SUBSP))
		sym.symbol_value = BAD_SYM;
		/* HPUX Import that was never referenced to really generate a 
		   stub - forget it. */
	    else
  	        sym.symbol_value = symbol_value(i);

	    if (type == ST_CODE ||
		    type == ST_STUB ||
		    type == ST_PLABEL ||
		    type == ST_PRI_PROG ||
		    type == ST_SEC_PROG ||
		    type == ST_ENTRY ||
		    type == ST_MILLICODE ||
		    type == ST_MILLI_EXT)
		sym.symbol_value |= el_bits;
	    if (scope == SS_EXTERNAL)
		/* MPE XL loader wants XRT offset in value fld */
#ifdef Karl
		sym.symbol_value = sym.symbol_info;
#else
                {}
#endif
	    else if (type == ST_PLABEL) {
		     /* if not -A link then leave symbol_info alone */ 
                     if(base_file_name != NULL && !relinkable) 
		       sym.symbol_info = Subsp_Misc(old_info).r_c_x;
    	    } else if ((alloc_stubs_ux || alloc_stubs_xl) &&
 		      scope == SS_UNIVERSAL &&
		      (type == ST_ENTRY ||
                       type == ST_PRI_PROG ||
	    	       type == ST_SEC_PROG)) {
		     /* put address of real entry in symbol_info */
 		     if (Sym_Remap_Type(sym.symbol_info) == ST_STUB_IMPORT)
		         sym.symbol_info = Sym_Related_Stub(sym.symbol_info); 

		     /* for export stubs */
  		          sym.symbol_info = symbol_value(sym.symbol_info);
	    } else if (relocatable || scope == SS_UNIVERSAL ||
               /* HP-UX shared library or executable */
#ifdef TSD /* TSD */
                (building_incomp_exec && (scope == SS_UNSAT && 
		  (type == ST_TSTORAGE || type == ST_DATA))) ||
#else
		(building_incomp_exec && scope==SS_UNSAT && type==ST_DATA) ||
#endif /* TSD */
		       scope == SS_GLOBAL || type == ST_STORAGE) {
		sym.symbol_info = Subsp_Misc(old_info).r_c_x;
	    } else
                sym.symbol_info = -1;
        }
        

	if (symbufptr >= symbuf + SYMBUFSIZE) { /* Is buffer full? */
	    fdump(out_som_fd, header_loc, symbuf, sizeof(sym), SYMBUFSIZE);
	    header_loc += sizeof(sym)*SYMBUFSIZE;
	    symbufptr = symbuf;
        }
	*symbufptr = sym;
	symbufptr++;

	if (Sym_Out_Remap(i) != symbols_written)
    	    internal_error(WRNG_NUM_NON_NULL_SYMS , 0);
        symbols_written++;
    }

    /* Dump out what's still in the buffer */
    fdump(out_som_fd, header_loc, symbuf, sizeof(sym), symbufptr-symbuf);
    header_loc += sizeof(sym)*(symbufptr-symbuf);

    if (new_som_header.symbol_total != symbols_written)
	internal_error(WRNG_NUM_NON_NULL_SYMS , 0);
} /* end out_symbol_records */

out_reloc_fixups() 
{
    write_fixups(out_som_fd, new_som_header.fixup_request_location);
}

out_one_abs_fixup(opcode, offset)
int opcode, offset;
{
    char *p;

    if (abs_buf_count+5 > ABS_BUF_SIZE) {
	fdump(out_som_fd, abs_fix_loc, abs_buf, abs_buf_count, 1);
	abs_fix_loc += abs_buf_count;
	abs_buf_count = 0;
    }
    p = &abs_buf[abs_buf_count];
    *p++ = opcode;
    *p++ = offset >> 24;
    *p++ = offset >> 16;
    *p++ = offset >> 8;
    *p++ = offset;
    abs_buf_count += 5;
    out_abs_fixup_count += 5;
}

/* FORWARD declaration */
Fixup *relocate_fixups();
extern Boolean use_PUT_table;

void build_relocatable_fixups()
{
    struct subspace_dictionary_record *subsp;
    int old_index;
    int new_sp_index, sp_index, subsp_index, num_subsp;
    int new_fixup_index;

    use_PUT_table = TRUE;
    reset_new_fixups();
    initial_fixup_pass = TRUE;
#ifndef WW_ANNOTATIONS
    /* See comment attached to declaration of this symbol
       at the top of this file for more info */
    doing_relocatable_fixups = TRUE;
#endif /* !WW_ANNOTATIONS */

    /* for each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	subsp_index = space_array[sp_index].subspace_index;
	num_subsp = space_array[sp_index].subspace_quantity;

	/* For each of its subspaces */
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
            subsp = &Subsp_Dict(old_index);

	    if ((subsp->subspace_length == 0 ||
			subsp->fixup_request_quantity == 0) ||
		/* doom support */
                (!strip_debug && lm_should_skip_subspace(old_index)))
                continue;

	    clear_PUT_table();
            new_fixup_index = new_fixup_size;
            traverse_fixups(old_index, RELOCATE_FIXUPS);
	    if (old_format_file) {
		start_fixup();
		PUT_8(R_TRANSLATED);
	    }
#ifdef PA_2_0
            /* Reset the PC_REL_CALL mode to default */
	    start_fixup();
	    PUT_8(R_SHORT_PCREL_MODE);
#endif /* ifdef PA_2_0 */
	    
            /* Reset the rounding mode to the default */
	    start_fixup();
	    PUT_8(R_N_MODE);

            start_fixup();

/* NEED TO FREE OLD FIXUPS HERE, BUT HAVE TO BE VERY CAREFUL IN DOING SO */
/*          if (!save_fixups && subsp->fixup_request_quantity > 0)       */
/*              efree((Fixup *) subsp->fixup_request_index);             */

            subsp->fixup_request_index = new_fixup_index;
            subsp->fixup_request_quantity = new_fixup_size - new_fixup_index;
        }
    }

    initial_fixup_pass = FALSE;
#ifndef WW_ANNOTATIONS
    doing_relocatable_fixups = FALSE;
#endif /* !WW_ANNOTATIONS */
}

Fixup *relocate_fixups(fix_info, fixup, arg0, arg1, arg2)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1, arg2;
{
    int i, info_type;

    switch (info_type = fix_info->type) {
        case R_NO_RELOCATION:
        case R_ZEROES:
        case R_UNINIT:
        case R_RELOCATION:
        case R_SPACE_REF:
        case R_REPEATED_INIT:
#ifdef PA_2_0
        case R_SHORT_PCREL_MODE:
        case  R_LONG_PCREL_MODE:
#endif /* ifdef PA_2_0 */
        case R_BREAKPOINT:
        case R_ENTRY:
        case R_ALT_ENTRY:
        case R_EXIT:
        case R_BEGIN_TRY:
        case R_END_TRY:
        case R_BEGIN_BRTAB:
        case R_END_BRTAB:
        case R_STATEMENT:
        case R_SEC_STMT:
        case R_DATA_EXPR:
        case R_CODE_EXPR:
        case R_FSEL:
        case R_LSEL:
        case R_RSEL:
        case R_N0SEL:
        case R_N1SEL:
	case R_LINETAB_ESC:
        case R_N_MODE:
        case R_S_MODE:
        case R_D_MODE:
        case R_R_MODE:
	case R_INDIRECT_CALL:   /* OGL support */
	case R_R19_LDST:        /* -B symbolic */
        case R_DATA_OVERRIDE:
	case R_EXEC_LEVEL:
        case R_TRANSLATED:
	case R_LTP_OVERRIDE:
#ifdef TSD /* TSD */
        case R_TP_OVERRIDE:
#endif /* TSD */
        case R_COMP1:
        case R_COMP3:           /* THIS MUST CHANGE LATER */
                                /* IF we implement PUSH-PROC & PUSH-PLABEL */
            /* duplicate the old fixup */
            start_fixup();
            for (i = fix_info->len; i != 0; i--)
                PUT_8(*fixup++);
            break;
        case R_DATA_ONE_SYMBOL:
        case R_DATA_PLABEL:
        case R_CODE_PLABEL:
        case R_DLT_REL:
        case R_PLT_REL:		/* OGL support */
        case R_MILLI_REL:
	    CHECK_SUBSP_SYM(arg0);
            make_symbol_fixup(info_type, remap_symbol(arg0));
            break;
        case R_DATA_GPREL:
	    CHECK_SUBSP_SYM(arg0);
            make_symbol24_fixup(info_type, remap_symbol(arg0));
            break;
        case R_PCREL_CALL:
        case R_ABS_CALL:
	    CHECK_SUBSP_SYM(arg1);
            make_call_fixup(info_type, arg0, remap_symbol(arg1), 0, 0);
            break;
        case R_DP_RELATIVE:
        case R_CODE_ONE_SYMBOL:
	    CHECK_SUBSP_SYM(arg0);
            make_code_reference(info_type, remap_symbol(arg0));
            break;
        case R_COMP2:
            /* Put five bytes */
            start_fixup();
            PUT_8(info_type);
            PUT_8(arg0);
            if (arg0 == R_PUSH_SYM) {
		CHECK_SUBSP_SYM(arg1);
                arg1 = remap_symbol(arg1);
	    }
            PUT_24(arg1);
            break;
        case R_AUX_UNWIND:
            start_fixup();
            PUT_8(info_type);
	    CHECK_SUBSP_SYM(arg0);
            PUT_24(remap_symbol(arg0));
            PUT_32(arg1);
            PUT_32(arg2);
            break;
	case R_LINETAB:
	    start_fixup();
	    PUT_8(info_type);
	    PUT_8(arg0);
	    CHECK_SUBSP_SYM(arg1);
	    PUT_24(remap_symbol(arg1));
	    PUT_32(arg2);
	    break;

	/* This is for WW_ANNOTATIONS support,
	   both the GS and special BE linker */
	case R_COMMENT:
	    start_fixup();
	    PUT_8(info_type);
	    PUT_8(arg0);
	    /* If this fixup has an embedded symbol index */
	    if ( ((arg0 >> 5) & 0x7) == R_COMMENT_SYM_ADDR_LOOKUP) {
	      unsigned int temp;

	      temp = (arg1 & 0xFFFFFFF);  /* Get symbol index */
	      CHECK_SUBSP_SYM((int) temp);
	      temp = remap_symbol(temp);  /* Remap it to output symbol */
	      /* merge symbol index with upper 4 bits of arg1 */
	      temp = temp | (arg1 & 0xF0000000);
	      PUT_32(temp);
	    } else {
	      /* Otherwise, just copy the bits out */
	      PUT_32(arg1);
	    }
	    break;

      /* INTERNAL FIXUPS NOT ALLOWED */
        default:
            external_error_hex(INVALID_FIXUP, info_type, 
				Subsp_Misc(fixup_subsp).file_name);
    }

    return (NULL);
} /* end relocate_fixups */

remap_symbol(i)
int i;
{
    i += sym_bias;
    i = Sym_Remap(i);
    i = Sym_Out_Remap(i);
    return (i);
}

/* Embedded systems routine */
check_reserve_regions()
{
    struct subspace_dictionary_record *subsp;
    int warn;        /* count num of regions breached */
    int i;
    char str[20];
    extern Boolean check_reserve_list();

    warn = 0;

    if (!reserve_regions_seen)
	return;          /* the reserve list does not exist */

    /* traverse the temp_sub array and */
    for (i=0; i < new_subsp_dict_size; i++) {
	subsp = &temp_sub[i];

	/* Ignore Zero length output subspaces */
	if (subsp->subspace_length == 0) 
	    continue;

	if (check_reserve_list(subsp->NAME_PT, subsp->subspace_start, 
			     subsp->subspace_start + subsp->subspace_length))
	    warn++;
    }

    if (warn) {
        sprintf(str, "%d", warn);
        external_error(RESERVE_REGION_ERR, str);
    }
} /* end check_reserve_regions */

    /* UNIX AND NOT LINKEDIT */
    /* fopen output SOM for HP-UX */
#define FOPEN_OUTPUT_TYPE	"w+"

/* main procedure to build output som */

void build_output_som()
{
    FILE    *f;
    int	    padding, len, zeroes[ZBUFSIZE];
    int     oldumask;
    struct stat stbuf;
    int     size;
    off_t   offset;

    oldumask = umask(0);  /* get users mask */
    umask(oldumask);

    /* Open output SOM */
    f = efopen (output_name, FOPEN_OUTPUT_TYPE, CANT_OP_OUTP_FL);
    out_som_fd = fileno(f);

    fstat (out_som_fd, &stbuf);
    if (stbuf.st_mode & 0111) {
	/* if was an executable file before, preserve its access mode bits */
	fchmod(out_som_fd, stbuf.st_mode & 0666);
	output_mode = stbuf.st_mode;
    } else
        output_mode = 0777 & ~oldumask;

    /* init tmp_space_misc array                           */
    if (!relocatable)
        build_init_array();
    if (loader_fixup_size && !building_shlib && !building_incomp_exec)
        create_loader_fixups();

    /* doom support */
    lm_linkmap_create();

    /* write subspace recs first for subsp compression */
    out_subsp_records(new_som_header.subspace_location);
    out_subsp_data();

    /* if reserve regions exist check the output subspaces to determine */
    /* if any region has been breached */
    check_reserve_regions();

    /* this must come after out_subsp_data (since that is when the      */
    /* loader fixups are initialized), and before out_space_records     */

    if (loader_fixup_size && !building_shlib && !building_incomp_exec)
	out_loader_fixup(new_som_header.loader_fixup_location);

    out_space_records(new_som_header.space_location);
    size = out_string_table(&space_strings,
    	                    new_som_header.space_strings_location); 
    if (size != new_som_header.space_strings_size)  
	internal_error(WRONG_SPACE_STR_SIZE, 0);

    if (relocatable || !strip_symbols) {
	build_sym_strings();
	out_symbol_records(new_som_header.symbol_location);
	out_compunit_records();	
	size = out_string_table(&sym_strings, 
		                new_som_header.symbol_strings_location);
        if (size != new_som_header.symbol_strings_size) 
	    internal_error(WRONG_SYMSTR_SIZE, 0);
    } 

    if (relocatable)
	out_reloc_fixups(new_som_header.fixup_request_location);

    user_header_loc = new_som_header.aux_header_location;
    if (!relocatable) {
	out_init_array(new_som_header.init_array_location);
	if (ipl) {
	    /* delay for ipl checksum */
	    user_header_loc += sizeof(struct ipl_aux_hdr);
	}
#if 0
	else if (O_S == OS_HPOSF) {
	    bd_hp_osf_header();
	    out_osf_header(new_som_header.aux_header_location);
	    user_header_loc += sizeof(struct hposf_auxhdr);
	    }
#endif /* 0 */
	else if (O_S == OS_HPUX) {
	    bd_hp_ux_header();
	    out_ux_header(new_som_header.aux_header_location);
#ifndef ESOM
	    user_header_loc += sizeof(struct som_exec_auxhdr);
#else
	    user_header_loc += (sizeof(struct som_exec_auxhdr) +
				sizeof(struct cnx_option_header));
#endif /* ESOM */
	} else /* if (O_S == OS_HPE_NEW) */ {
	    bd_new_hpe_header();
	    out_new_hpe_header(new_som_header.aux_header_location);
	    user_header_loc += sizeof(struct mpe_som_aux_hdr);
	}
    }
    
    if (product_key_size > 0) {
	/* product aux header is should immediately follow HP_UX aux hdr */
        bd_product_specific_header();
        out_product_specific_header(user_header_loc);
	user_header_loc += (sizeof(struct aux_id) + product_key_size);
	product_key_size = 0; 
	efree(product_key);
    }

#ifdef ESOM
    if ( relocatable && (esom_is_parallel || opt_hdr != NULL) ) {
	bd_esom_header();
	out_esom_header(user_header_loc);
	user_header_loc += sizeof(struct cnx_option_header);
    }
#endif /* ESOM */

    bd_ld_footprint_header();
    out_ld_footprint_header(user_header_loc);
    user_header_loc += sizeof(struct linker_footprint);
 
    if (aux_area_size > 0)
	out_user_header(user_header_loc);
    out_som_header(0);

    if (ipl) {
	bd_ipl_header();
	out_ipl_header(new_som_header.aux_header_location);
    }


    /* Flush any buffered information */
    flush_fdump_buffer();

    /* Pad file out to som_length */

    if ((offset = lseek(out_som_fd, 0L, 2)) == -1) {
       system_error(CANT_SEEK_IN, output_name, 0);
    }

    padding = new_som_header.som_length - offset;
    if (padding > 0) {
	for (len = 0; len < ZBUFSIZE/sizeof(int); len++)
	    zeroes[len] = 0;
    	while (padding > 0) {
	    len = (padding > ZBUFSIZE)? ZBUFSIZE : padding;
	    if (write (out_som_fd, (void *) zeroes, len) != len) {
               system_error(FDMP_CANT_WRT, output_name, 0);
            }
		padding -= len;
	}
    }
    /* Clear remembered filofs in fdump since we used write() directly */
    clear_oldfilofs();
    close(out_som_fd); 

    if (bad_fixups) {
	warning(INVALID_FIXUPS , 0);
	unlink(output_name);
    }
} /* end build_output_som */
#undef FOPEN_OUTPUT_TYPE

#ifdef ESOM
/*
 * esom2som_init_array - converts esom init pointers to som init pointers
 *
 * arguments
 *	e	- esom init pointers to convert
 *	s	- som init pointers to convert to
 *	n	- number of init pointers to convert
 */

esom2som_init_array(e, s, n)
struct cnx_init_pointer_record *e;
struct init_pointer_record *s;
int n;
{
    int i;

    for ( i = 0; i < n; i++ ) {
	s[i].space_index = e[i].space_index;
	s[i].access_control_bits = e[i].access_control_bits;
	s[i].has_data = e[i].has_data;
	s[i].memory_resident = e[i].memory_resident;
	s[i].initially_frozen = e[i].initially_frozen;
	s[i].new_locality = e[i].new_locality;
	s[i].file_loc_init_value = e[i].file_loc_init_value;
	s[i].initialization_length = e[i].initialization_length;
	s[i].space_offset = e[i].space_offset;
	s[i].reserved = 0;
    }
}

/*
 * bl_esom_header - build esom option header if one does not already exist.
 */
static void
bd_esom_header()
{
    if ( opt_hdr == NULL ) {
	opt_hdr = (struct cnx_option_header *) emalloc(sizeof(*opt_hdr));
	(void) memset((void *) opt_hdr, 0, sizeof(*opt_hdr));
    }

    opt_hdr->header_id.mandatory = FALSE;
    opt_hdr->header_id.copy = FALSE;
    opt_hdr->header_id.append = FALSE;
    opt_hdr->header_id.ignore = TRUE;
    opt_hdr->header_id.reserved = 0;
    opt_hdr->header_id.type = CNX_OPTION_HDR;
    opt_hdr->header_id.length = sizeof(*opt_hdr) - sizeof(struct aux_id);

    opt_hdr->flags |= CNX_OPT_NEWFIELDS;
    opt_hdr->version = CNX_OPT_VERSION001;
    opt_hdr->starting_node = CNX_OPT_ANYNODE;

    opt_hdr->utsname_mode = CNX_OPT_DEFAULT;
    opt_hdr->rlim_cpu = CNX_OPT_DEFAULT;
    opt_hdr->rlim_fsize = CNX_OPT_DEFAULT;
    opt_hdr->rlim_data = CNX_OPT_DEFAULT;
    opt_hdr->rlim_stacksize = CNX_OPT_DEFAULT;
    opt_hdr->rlim_core = CNX_OPT_DEFAULT;
    opt_hdr->rlim_rss = CNX_OPT_DEFAULT;
    opt_hdr->rlim_nofile = CNX_OPT_DEFAULT;

    if ( esom_no_parallel_obj ) {
	esom_is_parallel = FALSE;
	opt_hdr->flags &= ~CNX_OPT_PARALLEL;
    }

    if ( esom_is_parallel ) {
	opt_hdr->flags |= CNX_OPT_PARALLEL;
	if ( esom_is_oversubscribe ) 
	    opt_hdr->flags |= CNX_OPT_OVERSUB;
	if ( esom_min_cpus >= 1 ) {
	    opt_hdr->min_cpu = esom_min_cpus;
	    opt_hdr->max_cpu = esom_max_cpus;
	}
    } 
    
    if ( opt_hdr->flags & CNX_OPT_PARALLEL ) {
	/*
	 * max sure that min and max are set.
	 */
	if ( esom_min_cpus <= 0 ) {
	    if ( opt_hdr->min_cpu <= 0 )
		opt_hdr->min_cpu = 1;
	    if ( opt_hdr->max_cpu <= 0 ) {
		opt_hdr->max_cpu = 32;
		if ( opt_hdr->max_cpu < opt_hdr->min_cpu )
		    opt_hdr->max_cpu = opt_hdr->min_cpu;
	    }
	}
	if ( esom_spinwait )
		opt_hdr->flags |= CNX_OPT_SPINWAIT;

	/*
	 * default memory types for parallel programs
	 */
	if ( opt_hdr->max_cpu <= (spp2000_target ? 16 : 8) )
	    opt_hdr->private = CNX_INIT_NEAR;
	else
	    opt_hdr->private = CNX_INIT_FAR;
	opt_hdr->stack = CNX_INIT_NEAR;
	opt_hdr->tstack = CNX_INIT_NEAR;
	opt_hdr->specific = CNX_INIT_NEAR;
    } else {
	/*
	 * for non parallel programs all memory types default to node private.
	 */
	opt_hdr->private = CNX_INIT_NODE;
	opt_hdr->stack = CNX_INIT_NODE;
	opt_hdr->specific = CNX_INIT_NODE;
	opt_hdr->tstack = CNX_INIT_NODE;
    }

    if ( esom_stack_type != -1 )
	opt_hdr->stack = esom_stack_type;

    if ( esom_tstack_type != -1 )
	opt_hdr->tstack = esom_tstack_type;

    if ( esom_onenode ) {
	/*
	 * make sure that the parallel executable will only run on one node
	 */
	opt_hdr->flags |= CNX_OPT_PARALLEL;
	opt_hdr->min_cpu = 1;
	opt_hdr->max_cpu = spp2000_target ? 16 : 8;
	opt_hdr->private = CNX_INIT_NODE;
	opt_hdr->stack = CNX_INIT_NODE;
	opt_hdr->specific = CNX_INIT_NODE;
	opt_hdr->tstack = CNX_INIT_NODE;
    }

    opt_hdr->thr_per_node = esom_max_thr_node >= 1 ? esom_max_thr_node : 
      (spp2000_target ? 16 : 8);
}

static void
out_esom_header(header_loc)
int    header_loc;
/* update aux. header total and aux. header loc in som header then   */
/* copy aux. header records to output som                            */
{
    fdump(out_som_fd,header_loc, opt_hdr,
	  sizeof(struct cnx_option_header),1);
}/* end out_esom_header */
#endif /* ESOM */
