/* @(#) $Revision: 1.1.1.1 $ */
/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Object File Format Definitions
 *
 */
#ifndef _AOUTHDR_INCLUDED /* allow multiple inclusions */
#define _AOUTHDR_INCLUDED

#ifdef __hp9000s800
#if defined(__LP64__)
#include "elf.h"
#endif

#include "aouttypes.h"

struct aux_id { 
	unsigned int mandatory : 1;
	unsigned int copy : 1;
	unsigned int append : 1;
	unsigned int ignore : 1;
	unsigned int reserved : 12;
	unsigned int type : 16;
	unsigned int length;
};

/* Auxiliary Header types */

#define LINKER_AUX_ID		1
#define MPE_AUX_ID		2
#define DEBUGGER_AUX_ID		3
#define HPUX_AUX_ID		4
#define IPL_AUX_ID		5
#define VERSION_AUX_ID		6
#define MPE_PROG_AUX_ID		7
#define MPE_SOM_AUX_ID		8
#define COPYRIGHT_AUX_ID	9
#define SHLIB_VERSION_AUX_ID	10
#define PRODUCT_SPECIFIC_AUX_ID 11
#define NLM_AUX_ID		12

struct debugger_footprint {
	struct aux_id	 header_id;
	char		 debugger_product_id[12];
        char             debugger_version_id[8];
        struct sys_clock debug_time;
};

struct linker_footprint {
        struct aux_id    header_id;
        char             product_id[12];
        char             version_id[12];
        struct sys_clock htime;
};

struct cap_list {
        unsigned int    reserved1	: 23;
        unsigned int    batch_acc 	:  1;	/* BA */
        unsigned int    inter_acc 	:  1;	/* IA */
        unsigned int    priv_mode 	:  1;	/* PM */
	unsigned int	reserved2	:  2;
        unsigned int    multiple_rins 	:  1;	/* MR */
	unsigned int	reserved3	:  1;
        unsigned int    extra_data_seg 	:  1;	/* DS */
        unsigned int    process_hand 	:  1;	/* PH */
};

struct mpe_aux_header { 
        struct aux_id   header_id;
        unsigned int    internal_flag :1;
        unsigned int    reserved      :31;
        unsigned int    num_xrts;
        unsigned int    entry_name;
        unsigned int    unsat_name;
        int             search_list;
        struct cap_list capabilities;
        unsigned int    max_stacksize;
        unsigned int    max_heap_size;
	unsigned int	unwind_start;
	unsigned int	unwind_end;
	unsigned int	recover_start;
	unsigned int	recover_end;
};       

struct mpe_prog_aux_hdr {
	struct aux_id	header_id;
	unsigned int	entry_name;
	unsigned int	unsat_name;
	int		search_list;
	struct cap_list	capabilities;
	unsigned int	max_stacksize;
	unsigned int	max_heap_size;
	unsigned int	reserved:13;
        unsigned int    bind_mode :1;       /* If set, bind deferred.  
                                               Otherwise, bind immediate */
        unsigned int    allow_override :1; /* if set, allow runtime override
                                              of directories to search */
	unsigned int	posix:1;
	unsigned int	max_priority:8;
	unsigned int	priority:8;
};

struct mpe_som_aux_hdr {
	struct aux_id	header_id;          /* som auxiliary header id      */
	unsigned int	reserved	:27;/* reserved for future use      */
	unsigned int    shared_data     :1; /* If = 1, SOM is a shared global 
                                               data SOM; else it is an 
                                               old-style SOM                */
        unsigned int    thread_private  :1; /* If = 1, SOM is a thread-private
                                               SOM */
	unsigned int	dumpworthy     	:1; /* If = 1, SOM is dumpable      */
	unsigned int	hpe_som      	:1; /* If = 1, SOM is part of the MPE
                                               bootable image               */
	unsigned int	system_som   	:1; /* If = 1, SOM is part of the MPE
                                               kernel                       */
	unsigned int	num_xrts;           /* number of XRT entries        */
	unsigned int	unwind_start;       /* virtual address of start of 
                                               unwind table                 */
	unsigned int	unwind_end;         /* virtual address of end of the
                                               unwind table                 */
	unsigned int	recover_start;      /* virtual address of start of the
                                               try-recover table            */
	unsigned int	recover_end;        /* virtual address of end of the
                                               try-recover table            */
	unsigned int    num_dxrts;          /* number of DXRT entries       */
	unsigned int    data_imports;       /* number of LST data imports   */
	unsigned int    data_exports;       /* number of LST data exports   */
};

struct som_exec_auxhdr {
	struct aux_id som_auxhdr;	/* som auxiliary header header  */
	int  exec_tsize;		/* text size in bytes           */
	int  exec_tmem;			/* offset of text in memory     */
	int  exec_tfile;		/* location of text in file     */
	int  exec_dsize;		/* initialized data             */
	int  exec_dmem;			/* offset of data in memory     */
	int  exec_dfile;		/* location of data in file     */
	int  exec_bsize;		/* uninitialized data (bss)     */
	int  exec_entry;		/* offset of entrypoint         */
	int  exec_flags;		/* loader flags                 */
	int  exec_bfill;		/* bss initialization value     */
};

/*
 * som_exec_auxhdr.exec_flags field:
 *   bit 31 - trap nil pointers
 *   bit 30 - external millicode (never implemented on HP-UX)
 *   bit 29 - dynamically linked (incomplete) executable
 *   bit 28 - executable built with the aid of profile information
 *
 *   bits 24-27 - instruction page size field:
 *      0:4k  1:16k  2:64k  3:256k  4:1M  5:4M  6:16M  7:64M  8:256M
 *     15:use the largest page size available
 *
 *   bits 22-23 - initialized to 0 and reserved
 *
 *   bit 21 - static branch prediction recommended for this load image
 *
 *   bits 17-20 - data page size field:
 *      0:4k  1:16k  2:64k  3:256k  4:1M  5:4M  6:16M  7:64M  8:256M
 *     15:use the largest page size available
 *
 *   bits 16 - disable KABP (Kernel Assisted Branch Prediction) when set
 *
 *   bit 15 - Enable lazy swap when set.
 *
 *   bit 14 - Lock text into physical memory when set.
 *
 *   bit 13 - Lock data into physical memory when set.
 *
 *   bit 12 - Text contents is offset from the mapped start of text if this
 *	      bit is set.  Pre 11.0 a.out programs made with -s (strip) option
 *	      will not have this bit set, but text is offset.
 *
 *   bit 11 - Enable executable stack when set.
 *
 *   bit 10 - Third quadrant of address space used as private data space when set.
 * 
 *   bit  9 - Fourth quadrant of address space used as private data space when set.  
 *            Third quadrant of address space is automatically used as private data
 *            space when the fourth quadrant is used as such.
 * 
 *   all other bits initialized to 0 and reserved
*/

/*
 * The low-order bit of the field exec_flags specifies whether nil
 * pointers should be treated as an error.  (The -z linker flag sets
 * this bit).  If on, dereferencing a nil pointer will cause the
 * program to abort.  If off, dereferencing a nil pointer will return
 * zero.
 */

typedef struct som_exec_auxhdr AOUTHDR;

struct ipl_aux_hdr {
        struct aux_id   header_id;
	unsigned int	file_length;
	unsigned int    address_dest;
	unsigned int    entry_offset;
	unsigned int	bss_size;
	unsigned int    checksum;
};

struct user_string_aux_hdr {
        struct aux_id   header_id;
	unsigned int    string_length;
	char		user_string[1];
};

struct copyright_aux_hdr {
        struct aux_id   header_id;
	unsigned int    string_length;
	char		copyright[1];
};

struct shlib_version_aux_hdr {
	struct aux_id   header_id;
	short   version;
};

struct product_specific_aux_hdr { 
	struct aux_id   header_id;
	unsigned int key[1];
};

#endif /* __hp9000s800 */
#endif /* _AOUTHDR_INCLUDED */
