/* @(#) $Revision: 1.2 $ */
/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Object File Format Definitions
 *
 */
#ifndef _INITPTR_INCLUDED /* allow multiple inclusions */
#define _INITPTR_INCLUDED

#include <inttypes.h>

#ifdef __hp9000s800
struct init_pointer_record {
        uint32_t space_index;               /* index of space entry       */
        uint32_t access_control_bits: 7;    /* access field for PDIR      */
        uint32_t has_data	 	: 1;    /* file pages exist for this 
                                                   area of memory             */
        uint32_t memory_resident	: 1;
        uint32_t initially_frozen	: 1;     /* must be locked into memory 
                                                    when OS is booted         */
	uint32_t new_locality       : 1;    /* this init ptr begins a new
						   locality                   */
        uint32_t reserved: 21;
        uint32_t file_loc_init_value;       /* starting location in file 
                                                  (page aligned)              */
        uint32_t initialization_length;
        uint32_t space_offset;              /* starting offset in space 
                                                   (page aligned)             */
};

#define INITPTR struct init_pointer_record
#define INITPTRSZ sizeof(INITPTR)

#endif /* __hp9000s800 */
#endif /* _INITPTR_INCLUDED */
