/* @(#) shared src: 70.5 $ */
/* @(#) $Revision: 1.1.1.1 $ */

#ifndef		_SHL_INCLUDED	/* allow multiple inclusion */
#define		_SHL_INCLUDED

#ifdef 		__hp9000s800

#ifdef __LP64__
#include "elf.h"
#endif
/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  External Definitions for Shared Library manipulation routines and
 *					    data structures
 *
 *
 *  $Header: /home/cvs/cvsroot/linker/som/shl.h,v 1.1.1.1 1999/10/18 19:53:04 pschwan Exp $
 */

#define DL_HDR_VERSION_ID	89060912
#define DL_HDR_VERSION_ID2	93092112
#define SHLIB_UNW_VERS_ID	89081712

#define DLT_ENTRY     int

struct dl_header {
    int	hdr_version;		/* header version number */
    int	ltptr_value;		/* space-rel offset of linkage table ptr(r19)*/
    int	shlib_list_loc;		/* text relative offset of shlib list */
    int	shlib_list_count;	/* count of items in shlib list */
    int	import_list_loc;	/* text relative offset of import list */
    int	import_list_count;	/* count of items in import list */
    int	hash_table_loc;		/* text relative offset of export hash table */
    int	hash_table_size;	/* count of slots in export hash table */
    int	export_list_loc;	/* text relative offset of export list */
    int	export_list_count;	/* count of items in export list */
    int	string_table_loc;	/* text relative offset of string table */
    int	string_table_size;	/* length in bytes of string table */

    int	dreloc_loc;	/* text-relative offset of dynamic relocation records */
    int	dreloc_count;	/* number of dynamic relocation records */
    int dlt_loc;	/* space-relative offset of data linkage table */
    int plt_loc;	/* space-relative offset of procedure linkage table */
    int dlt_count;	/* number of dlt entries in linkage table */
    int plt_count;	/* number of plt entries in linkage table */
    short highwater_mark; 	/* highest version number seen in the library */
    short flags;	/* various flags -- currently elab_used, init_used */
    int export_ext_loc; /* text-relative offset of export extension table */  
    int module_loc;     /* text-relative offset of module table */
    int module_count;   /* number of module entries */
    int elaborator;	/* import index of elaborator */
    int initializer;	/* text relative offset of initializer import list */
    int embedded_path;	/* index into the string_table for the search path */
			/* index must be > 0 to be valid                   */
    int initializer_count; /* count of items in initializer import list */
    int tdsize;         /* size of the TSD area */
    int fastbind_list_loc;   /* text-relative offset of fastbind info */

};

/* dl_header flags */
#define ELAB_DEFINED 0x1  /* An elaborator has been defined for this library  */
#define INIT_DEFINED 0x2  /* An initializer has been defined for this library */
#define SHLIB_PATH_ENABLE      0x4  /* allow search of SHLIB_PATH at runtime  */
#define EMBED_PATH_ENABLE      0x8  /* allow search of embed path at runtime  */
#define SHLIB_PATH_FIRST       0x10 /* search SHLIB_PATH first                */
#define SEARCH_ALL_STORS       0x20 /*search all shlibs to satisfy STOR import*/
#define SHLIB_INTERNAL_NAME    0x40 /* shlib has an internal name */
#ifndef SYBASE_SHARED_DATA
/*
 */
#define SYBASE_SHARED_DATA
#endif /* SYBASE_SHARED_DATA */
#define SHARE_DATA 0x80 /* Share data and bss with descendants of a process */
#define UNPAD_UNLOADABLE       0x100 /* No zero padding after data */

/*
 * Do NOT define 0x100 value, as it defined in Roseville as UNPAD_UNLOADABLE 
 * Do define two new values for the global hash table mechanism
 */
#define GLOBAL_HASH_TABLE       0x200 /* use global hash table mechanism */
#define PLABEL_CACHE            0x400 /* dld: cache plabel entries */

#define SHLIB_FIXED_ENABLE      0x800 /* dld: shared vtable implementation */

#ifdef IMPLICIT_TERMINATORS 
  #define INVOKE_IMPLICIT_INIT    0x1000
#endif /* IMPLICIT_TERMINATORS */

/*
 * dl_header_ext structure is used to extend current functionality
 * of the dynamic loader.  The structure supports version control to
 * allow future expansion without changing the dynamic loader.
 */
struct dl_header_ext { 
    int           size;           /* size of this structure */
    int           hash_array_size;/* size of global hash array */
    int           hash_buckets_per_entry;
                                  /* number of buckets per array entry */
    int           hash_function_ver;
                                  /* version of the hash function used */
    int           import_hashvals;/* offset to the hashed import values */
    int           export_hashvals;/* offset to the hashed export values */
    int           plabel_hashvals;/* offset to the hashed plabel values */
};

/* defines for the struct dl_header_ext */
#define HASH_FUNCTION_VERSION_1 1
#define HASH_FUNCTION_VERSION HASH_FUNCTION_VERSION_1

/* defaults for global hash table */
#define SYMTAB_DEFAULT_SIZE      1103  /* value for hash_array_size */
#define SYMTAB_DEFAULT_NBUCKETS  3     /* value for hash_buckets_per_entry */

struct import_entry {
    int           name;           /* offset in string table */
    short         reserved2;      /* currently unused */
    unsigned char type;           /* symbol type */
    unsigned int  bypassable : 1; /* addr of code symbol not taken in shlib */
    unsigned int  is_tp_relative:1;  /* TLS local import */
    unsigned int reserved1 : 6;
};

#ifndef EXPORT_VERSION

struct misc_info {
    short version;		/* months since January, 1990 */
    unsigned int reserved2 :  6;
    unsigned int arg_reloc : 10; /* parameter relocation bits (5 * 2) */
};

struct export_entry {
    int 	    next;	/* index of next export entry in hash chain */
    int 	    name;	/* offset within string table */
    int 	    value;	/* offset of symbol (subject to relocation) */
    union {
    	int   size;		/* storage request area size in bytes */
    	struct misc_info misc;	/* version, etc. N/A to storage requests */
    } info;
    unsigned char type;		/* symbol type */
    unsigned int is_tp_relative:1; /* TLS export */
    unsigned int reserved1:7;   /* currently unused */
    short	module_index;   /* index of module defining this symbol */
};

#define EXPORT_VERSION		info.misc.version
#define EXPORT_ARG_RELOC	info.misc.arg_reloc

#endif   /* ifndef EXPORT_VERSION */

/* extension records to be used in shared libraries */
struct export_entry_ext {
    int size;	     /* export symbol size, data only. */
    int dreloc;      /* start of dreloc list for this symbol. */
    int same_list;   /* circular list of exports that have the same value */
    int reserved2;
    int reserved3;
};

/* 
*/
struct shlib_list_entry {
    int	shlib_name;		/* offset within string table */
    unsigned char reserved1:6;
    unsigned char internal_name:1; /* shlib entry is an internal name */
    unsigned char dash_l_reference:1;/* referenced with -l<> (True) or 
					absolute path (False) */
    unsigned char bind;		/* bind immediate, or deferred, or reference */
    short highwater_mark;	/* highest version number of any exported sym */
};

struct PLT_entry {
    int	proc_addr;	/* address  of procedure */
    int	ltptr_value;	/* value of r19 required for this procedure */
};

struct shlib_unwind_info {
	int	magic;	        /* magic number for unwind detection */
	int	shlib_name;	/* index into string table */
	int	text_start;	/* virtual address of the start of text */
	int	data_start;	/* virtual address of the start of data */
	int	unwind_start;	/* text-relative offset of unwind table */ 
	int	unwind_end;	/* text-relative offset of stub unwind table */
	int	recover_start;  /* text-relative offset of recover table */
	int	recover_end;	/* text-relative offset of the line table */
};

/* dynamic relocation record */
struct dreloc_record {
	int	shlib;    /* if a.out fixup, this is the index in shlib_list of 
			     shlib from which this fixup was copied, else -1 */
	int	symbol;	  /* index into import table if *_EXT type */
	int 	location; /* offset of location to patch (dp-relative); */
	int	value;	  /* text or data-relative offset to use for patch if
			     internal-type fixup; else NULL */
	unsigned char type; /* type of dreloc record */
	char	reserved;     /* currently unused */
 	short	module_index; /* index of module that this record refers to */	
};

/* dynamic relocation types */
#define DR_PLABEL_EXT 	1
#define DR_PLABEL_INT 	2
#define DR_DATA_EXT 	3
#define DR_DATA_INT 	4
#define DR_PROPAGATE    5
#define DR_INVOKE       6
#define DR_TEXT_INT     7

/* module descriptor */
struct module_entry {
        int drelocs;       /* text-relative offset into module dynamic 
			      relocation array. */
 	int imports;       /* text-relative offset into module import array */ 
	int import_count;  /* number of entries into module import array    */ 
        char flags;        /* currently flags defined: ELAB_REF */
        char reserved1;
        unsigned short module_dependencies;
        int reserved2;
};

/* module flags */
#define ELAB_REF	0x1   	/* elaborator referenced in this module */

/* extra parms passed to dld from crt0 */
struct dld_parms {
    int  version;               /*  version num of dld_parms */
    int  text_addr;             /*  text address of dld */
    int  text_end;              /*  text end of dld */
    int  prog_data_addr;        /*  start of data in program file */
#ifdef __LP64__
    int  envp;	        /*  environment pointer */
#else
    char **envp;	        /*  environment pointer */
#endif /* __LP64__ */
    int  orig_usr_sp;		/*  user sp prior to mapping dld */
    int  system_id_addr;	/*  address of _SYSTEM_ID variable */
    int  keybits_1_ptr;         /*  address of _CPU_KEYBITS_1 variable */
    unsigned int ten_0 : 1;	/*  TRUE if this is 10.0 or later */
    unsigned int reserved1 : 31;/*  reserved -- set to zero */
#ifdef __LP64__
    int ismt_p;			/*  address of __ismt */
    int ktepv_p;		/*  address of _ktepv  */
    int tepv_p;			/*  address of _tepv  */
#else
    int *ismt_p;		/*  address of __ismt */
    int *ktepv_p;		/*  address of _ktepv  */
    int *tepv_p;		/*  address of _tepv  */
#endif /* __LP64__ */
    unsigned int tdsize;        /*  size of TSD */
#ifdef __LP64__
    int thread_init;            /*  address of __thread_init */
#else
    int (*thread_init)();       /*  address of __thread_init */
#endif /* __LP64__ */
#ifdef SPP_UX
    /*
     * The two unions are needed to resolve a HP-UX/SPP-UX conflict. The
     * FLD14 code was used by both for different fields, and therefore dld.sl
     * needs to make a determination at runtime to see which crt0 is calling
     * it (PA32 only). See comments in dld.c
     */
    union {
        char *v10_pthread_args; /*  address of pthread argument block */
        int *islwp_p_member;    /*  address of __islwp */
    } v10_parm;
#else
#ifdef __LP64__
    int islwp_p;            	/*  address of __islwp */
#else
    int *islwp_p;		/*  address of __islwp */
#endif /* __LP64__ */
#endif /* SPP_UX */
#ifdef SPP_UX
    union {
        int dummy_member;
        int v10_pthread_args_length;
    } v10_cxd_parm;
#else
    int dummy;
#endif /* SPP_UX */
    char *pthread_args;         /*  address of pthread argument block */
    int  pthread_args_length;   /*  length of argument block */
#ifdef __LP64__
    int cxperf_dld_hook;            	/*  address of __cxperf_dld_hook */
#else
    void (*cxperf_dld_hook)();		/*  address of __cxperf_dld_hook */
#endif /* __LP64__ */
};

#ifdef SPP_UX
#define islwp_p v10_parm.islwp_p_member
#define dummy v10_cxd_parm.dummy_member
#endif /* SPP_UX */

#define PARMS_STRUCT_FLD4	0
#define PARMS_STRUCT_FLD5	1
#define PARMS_STRUCT_FLD6	2
#define PARMS_STRUCT_FLD7	3
#define PARMS_STRUCT_FLD8       4
#define PARMS_STRUCT_FLD9       5
#define PARMS_STRUCT_FLD10      6
#define PARMS_STRUCT_FLD11      7
#define PARMS_STRUCT_FLD12      8
#define PARMS_STRUCT_FLD13      9
#define PARMS_STRUCT_FLD14      10
#define PARMS_STRUCT_FLD15      11
#ifdef SPP_UX
#define PARMS_STRUCT_FLD16      12
#endif /* SPP_UX */
#define PARMS_STRUCT_FLD17      13

#define PARMS_STRUCT_USED      -1

/* fastbind structures */

struct fb_imp_exp {
    unsigned int imp_shl:8;
    unsigned int imp_index:24;
    unsigned int exp_shl:8;
    unsigned int exp_index:24;
};

struct fb_unsat {
    unsigned int imp_shl:8;
    unsigned int imp_index:24;
};

struct fb_exp {
    unsigned int exp_shl:8;
    unsigned int exp_index:24;
};

struct fb_dynam_rel {
    unsigned int type:3;
    unsigned int imp_index:21;
    unsigned int imp_shl:8;
    unsigned int location;
    union {
        struct fb_exp exp_info;
        unsigned int value;
    } misc;
};

struct fb_lib_ver {
    unsigned int timestamp;
    unsigned int checksum;
    unsigned int mod_bv;	/* text offset */
};

struct fb_header_t {
    unsigned int lib_ver_list;   /* text offset */
    unsigned int lib_ver_list_len;
    unsigned int imp_exp_list;   /* text offset */
    unsigned int imp_exp_list_len;
    unsigned int dynam_rel_list; /* text offset */
    unsigned int dynam_rel_list_len;
    unsigned int unsat_list; /* text offset */
    unsigned int unsat_list_len;
};
#endif 		/* __hp9000s800 */

#endif		/* _SHL_INCLUDED */
