/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Space records manipulation routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/spaces.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $
 */

#include <stdio.h>
#include <memory.h>

#ifndef DEBUG
#define NDEBUG
#endif /* !DEBUG */
#include <assert.h>

#include "filehdr.h"
#include "spacehdr.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "ldlimits.h"
#include "linker.h"
#include "spaces.h"
#include "scnhdr.h"
#include "subspaces.h"
#include "ld_strings.h"
#include "util.h"
#ifdef CNX_TOOLS
#include "cnx_link_info.h"
#endif /* CNX_TOOLS */

/* doom support */
#include "ld_linkmap.h"

/* Globals */

struct space_dictionary_record	*space_array = NULL;
struct space_misc_record	*space_misc = NULL;
int    *sp_remap = NULL;
int    space_array_size = MAX_SP_INDEX;
int    cur_space_total = 0;
int    load_spaces = 0;

Boolean obj_has_dbg = FALSE;

void spaces_initialize()
{
    cur_space_total = 0;
    load_spaces = 0;
    if (space_array == 0)
        space_array = (struct space_dictionary_record *)
		emalloc(space_array_size *
			sizeof(struct space_dictionary_record));
    if (space_misc == 0)
        space_misc = (struct space_misc_record *)
		emalloc(space_array_size *
			sizeof(struct space_misc_record));
    if (sp_remap == 0)
        sp_remap = (int *) emalloc(space_array_size * sizeof(int));
} /* end spaces_initialize */

/* 
** read all space definition records from the input som 'cur_fildes' starting  
** at location fil_ofs to space_array.  If the space definition for a 
** particular space in this som have been previously defined, then update
** that space.
*/
void spaces_add(fil_ofs, total_sps)
int fil_ofs;
int  total_sps;
{
    static struct space_dictionary_record *tmp_spaces = 0;
    static int tmp_space_size = 0;
    static int s_objdebug_idx = BAD_SPACE;
    static int s_debug_idx    = BAD_SPACE;
    static int s_linkmap_idx  = BAD_SPACE;
    static int s_igndbg_idx   = BAD_SPACE;

    int objdebug_idx = BAD_SPACE;
    int debug_idx    = BAD_SPACE;
    int linkmap_idx  = BAD_SPACE;
    int igndbg_idx   = BAD_SPACE;

    int	old_sp_index, new_sp_index;
    char *space_name;

    extern int space_search();
    extern int space_append(); 
    extern void space_update();
				
    if (total_sps <= 0)
	return;
    if (total_sps > tmp_space_size)  {
	if (tmp_spaces != 0)
	    efree(tmp_spaces);
	tmp_space_size = max(MAX_SP_INDEX, total_sps);
	tmp_spaces = (struct space_dictionary_record *)
		      emalloc(tmp_space_size *
			sizeof(struct space_dictionary_record));

	/* 
        ** space remap needs to be as large as the maximum of the size of the 
	** space table in the som and the size of the new space table 
	*/
	sp_remap = (int *) erealloc((char *) sp_remap, 
				    tmp_space_size * sizeof(int));
    }

    ffetch(cur_fildes, 
	   fil_ofs, 
	   tmp_spaces,
	   sizeof(struct space_dictionary_record), 
	   total_sps);

    /* search and append or update space record to space_array */
    for (old_sp_index = 0; old_sp_index < total_sps; old_sp_index++) {
	struct space_dictionary_record *tmp_space = &tmp_spaces[old_sp_index];
	space_name = tmp_space->STR_INDEX + space_str_buffer.block_ptr;
	if (space_search(tmp_space,&new_sp_index)) {
	    space_update(tmp_space, new_sp_index);
           if (new_sp_index == s_debug_idx) {
              debug_idx = s_debug_idx;
           } else if (new_sp_index == s_objdebug_idx) {
              objdebug_idx = s_objdebug_idx;
           } else if (new_sp_index == s_linkmap_idx) {
              linkmap_idx = s_linkmap_idx;
           } else if (new_sp_index == s_igndbg_idx) {
              igndbg_idx = s_igndbg_idx;
	   }
        } else {
    	    tmp_space->NAME_PT = add_string(&space_strings, 
	    	   			    space_name,
	   	   		            hash_string(space_name), 
		   		            TRUE, 
					    TRUE);
	    new_sp_index = space_append(tmp_space);
	    /* convert name to char * so space_append() just copies */
	    if (strcmp(space_name, "$DEBUG$") == 0) {
 	       /* 
    	       ** 	- cc -g +Ofastaccess will still perform the 
	       **	the ADDIL elimination, but will issue a 
               **       warning message about validity of the debug info.
	       */
	       if (eliminating_addils) {
		  printf(ld_gets(1, 1594, "(Warning) Optimizing ADDILs "
			"in the presence of the debug information. "
			" Debug information may be corrupted (1594)"));
	       }
               s_debug_idx = new_sp_index;
               debug_idx = s_debug_idx;
	    } else if (strcmp(space_name, "$OBJDEBUG$") == 0) {
               s_objdebug_idx = new_sp_index;
               objdebug_idx = s_objdebug_idx;
	    } else if (strcmp(space_name, "$LINKMAP$") == 0) {
               s_linkmap_idx = new_sp_index;
               linkmap_idx = s_linkmap_idx;
	    } else if (strcmp(space_name, "$IGNDBG$") == 0) {
               s_igndbg_idx = new_sp_index;
               igndbg_idx = s_igndbg_idx;
            }
	}
	sp_remap[old_sp_index] = new_sp_index;
    }

    /* doom support */
    lm_spaces_add(debug_idx, objdebug_idx, linkmap_idx, igndbg_idx);

    /* Set global flag indicating that the current object has debug info */
    obj_has_dbg = (debug_idx != BAD_SPACE);

} /* end spaces_add */

/* 
** Search space array for name of new space record.  Return TRUE/FALSE and
** also correct index if true
*/
int space_search(new,index)
struct space_dictionary_record *new;
int *index;
{
    int i, found = FALSE;
    char *new_name, *old_name;

    new_name = new->STR_INDEX + space_str_buffer.block_ptr;
    for (i = 0; i < cur_space_total; i++) {
	old_name = space_array[i].NAME_PT;
	if (strcmp(new_name, old_name) == 0) {
	    found = TRUE;
	    *index = i;
	    break;
	}
    }
    return (found);
} /*end space_search */

int space_append(new)
/* 
** append new space record to space_array.  Return index to newly added space
*/
struct space_dictionary_record *new;
{
    struct space_dictionary_record  *old;
    struct space_misc_record  *old_misc;
    int	new_sp_index;

    new_sp_index = cur_space_total++;

    if (new_sp_index >= space_array_size) {
	space_array_size += MAX_SP_INDEX;
	space_array = (struct space_dictionary_record *)
		    erealloc((char *) space_array, space_array_size *
			sizeof(struct space_dictionary_record));
        /* Misc too! */
	space_misc = (struct space_misc_record *)
		    erealloc((char *) space_misc, space_array_size *
			sizeof(struct space_misc_record));

	/* space remap needs to be as large as space array because it is */
	/* reused while sorting spaces */
	sp_remap = (int *) erealloc((char *) sp_remap, 
			    space_array_size * sizeof(int));
    }

    /* copy the space record into the space_array and initialize */
    old = &space_array[new_sp_index];
    old_misc = &space_misc[new_sp_index];
    *old = *new;
    old->subspace_index = BAD_SUBSP;
    old->loader_fix_index = -1;
    if (base_file_name == NULL ||
        base_file_name != cur_file_name ||
        !relinkable)
        /* Leave alone if FRU RELINK */
        old->loader_fix_quantity = 0;
    old->init_pointer_index = -1;
    old->init_pointer_quantity = 0;

    /* Initialize the space misc record */
    memset((char *) old_misc, '\0', sizeof(struct space_misc_record));

    old_misc->space_align = 1;  /* default to byte alignment */

#if 0
	/*   We don't need to do this; the is_tspecific
	** bit will be set on the input space. */

    /* if $PRIVATE$, set is_private bit */
#ifdef TSD /* TSD */
    /*
    ** set bits for TSD space.  
    */
    if (strcmp(old->NAME_PT, "$TSPECIFIC$") == 0) {
        old->is_private = 1;
	old->is_tspecific = 1;
    } else
        old->is_tspecific = 0;
#endif /* TSD */

#endif /* 0 */

    /* if $PRIVATE$, set is_private bit */
    if (strcmp(old->NAME_PT, "$PRIVATE$") == 0) {
	old->is_private = 1;
	if (data_mmap_addr != -1) {
	    old_misc->start_addr_specified = TRUE;
	    old_misc->start_virt_addr = data_mmap_addr;
        }
	/* else data_mmap_addr was reset (-N or $PRIVATE seen without an at */
	/* qualifier in a command file) */
    } 

    if (strcmp(old->NAME_PT, "$TEXT$") == 0) {
	if (code_mmap_addr != -1) {
	    old_misc->start_addr_specified = TRUE;
	    old_misc->start_virt_addr = code_mmap_addr;
	}
    }

    /* increment the loadable spaces count */
    if (!(strip_debug && !old->is_loadable))
	load_spaces++;

    return(new_sp_index);

}/* end space_append */

void space_update(new, index)
/* update space array to reflect new space record */
struct space_dictionary_record *new;
int index;
{
    struct space_dictionary_record  *old;

    old = &space_array[index];

    if (old->sort_key == 0)
	old->sort_key = new->sort_key;
    old->is_defined |= new->is_defined;
    old->subspace_quantity += new->subspace_quantity;

} /* end space_update */

int build_space(name, sort_key)
char *name;
int sort_key;

/* 
** Build space array entry for named space created by linker "on the fly"
** (not read in from object files, e.g., crt0.o).  
*/
{
    struct space_dictionary_record temp_space_rec;
    int new_sp_index; 	

    /* init local struct to zero */
    memset((char *) &temp_space_rec,
	   '\0',
	   sizeof(struct space_dictionary_record));

    temp_space_rec.NAME_PT = add_string(&space_strings, 
					name, 
					hash_string(name), 
					FALSE, 
					TRUE);
    temp_space_rec.sort_key = sort_key;
    temp_space_rec.subspace_quantity = 0;
    temp_space_rec.is_loadable = TRUE; /* linker doesn't build DEBUG, etc. */
    temp_space_rec.is_defined = TRUE;
#ifdef TSD /* TSD */
    temp_space_rec.is_tspecific = FALSE; /* ld doesn't build $TSPECIFIC$ */
#endif /* TSD */

    /* space_append will init misc record as well */
    new_sp_index = space_append(&temp_space_rec);
    space_array[new_sp_index].space_number = new_sp_index;

    return(new_sp_index);

} /* end build_space */


