/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Stubs Definitions and Typedefs
 *
 */

struct stub_desc {
	unsigned int	addr;
	unsigned int	mbz1 : 4;  /* must be zero - reserved */
	unsigned int	type : 4;
	unsigned int	mbz2 : 3;  /* must be zero - reserved */
	unsigned int	reloclen : 5;
	unsigned int	length : 16;
};

struct stub_record {
	unsigned int type;
  	unsigned int subsp_index;
	unsigned int subsp_off;
	unsigned int length;
	unsigned int arg_reloc_size :  6;
	unsigned int rtn_reloc_size :  6;
	unsigned int caller_reloc   : 10;
	unsigned int callee_reloc   : 10;
        int stub_symbol;
        int stub_constant;
	struct stub_record *next_stub;
	struct stub_record *next_import_stub;
	unsigned int count_index;
};

/* Stub types *************************************************************
**	NULL		     	 0 not used
**	LONG_BRANCH_STUB     	 1 stubs generated for branches beyond 
**				   256K-bytes offset
**	LOCAL_RELOC_STUB     	 2 parameter relocation stub
**	EXTERN_IMPORT_STUB   	 3 MPE shared library import stub
**	EXTERN_EXPORT_STUB   	 4 calls entry point, handles
**				   inter-quad return;  deposits
**				   caller's exec level in rp
**	LONG_LOAD_STUB       	 5 not used
**	EXPORT_RELOC_STUB    	 6 like EXTERN_EXPORT_STUB with
**				   argument relocation
**	MILLILONG_BRANCH_STUB 	 7 like LONG_BRANCH_STUB, used to
**				   reach millicode routines
**	INTERQUAD_IMPORT_STUB 	 8 loads r22 with address of routine
**				   in quad0 and branches to
**				   _sr4export
**	DL_EXPORT_STUB    	 9 calls entry point, handles
**				   inter-quad return; used for
**				   dynamically loaded routines
**	HPUX_EXPORT_STUB     	10 HP-UX shared library export stub.
**				   like DL_EXPORT_STUB
**	HPUX_IMPORT_STUB     	11 HP-UX shared library import stub used
**				   in an incomplete executable.
**				   Loads r19 required by callee,
**				   makes inter-quad branch, stores
**				   rp at -24(sp).
**	SHLIB_IMPORT_STUB    	12 HP-UX shared library import stub used
**				   in a shared library.  See
**				   HPUX_IMPORT_STUB.
**	LONG_SHLIB_IMPORT_STUB	13 Like SHLIB_IMPORT_STUB except
**				   PLT entry is too far from r19.
**	SHL_LONG_BRANCH_STUB 	14 PC-relative long branch stub used
**				   in a shared library.
**	FDP_COUNTING_STUB    	15 Stub generated to count branches
**				   for feedback directed positioning.
****
**	HPUX_EXPORT_STUB_NO_RP  16 Like export stub but created when there
**			           is no return relocs and the the proc
**                                 uses long return instruction. This
**                                 export stub, thus, doesnot trap the 
**                                 return.
**      HPUX_IMPORT_STUB_NO_RP  17 Like import stub but does not save RP.
**                             
**      SHLIB_NO_RP_IMPORT_STUB  18 Like shlib import stub but RP is not 
**                                  saved.
***************************************************************************/

/*      NULL			0 */
#define	LONG_BRANCH_STUB		1
#define	LOCAL_RELOC_STUB		2
#define	EXTERN_IMPORT_STUB		3
#define	EXTERN_EXPORT_STUB		4
/*      LONG_LOAD_STUB	       		5 */
#define	EXPORT_RELOC_STUB		6
#define	MILLILONG_BRANCH_STUB		7
#define	INTERQUAD_IMPORT_STUB		8
#define	DL_EXPORT_STUB			9
#define	HPUX_EXPORT_STUB		10
#define	HPUX_IMPORT_STUB		11
#define	SHLIB_IMPORT_STUB		12
#define	LONG_SHLIB_IMPORT_STUB		13
#define	SHL_LONG_BRANCH_STUB		14
#define FDP_COUNTING_STUB 		15
#define HPUX_EXPORT_STUB_NO_RP      	16
#define HPUX_IMPORT_STUB_NO_RP		17
#define SHLIB_IMPORT_STUB_NO_RP		18

#define XRT_ENTRY_SIZE	  0x00000020	/* size of an xrt entry is 32 bytes */

/* Globals */

extern struct stub_record **_stubs;
extern int     stubs_size;
extern int     stubs_max;
extern int     log_stubs_max;
extern int     mask_stubs_max;
extern int     stub_segs;
extern int     stub_segs_max;
extern int     stub_area_max;
extern int     next_xrt;
extern int     lb_reach_pad;

extern void    stubs_initialize();
extern Boolean long_reach_stubs_added();
extern int     bld_extrn_imprt_stub_rec();
extern void    add_extrn_exprt_stub();
extern void    add_extrn_imprt_stub();
extern char    *build_stubs();
extern void    bld_import_stub_rec();

/* Access to the stubs table is through the following macros */

#define Stub_Seg(i)	((i) >> log_stubs_max)
#define Stub_Off(i)	((i) & mask_stubs_max)

#define Stubs(i)	_stubs[Stub_Seg(i)][Stub_Off(i)]

#define IS_STUB(index)   (Sym_Dict(index).symbol_type==ST_STUB_ENTRY    || \
			  Sym_Dict(index).symbol_type==ST_STUB_PRI_PROG || \
			  Sym_Dict(index).symbol_type==ST_STUB_SEC_PROG || \
			  Sym_Dict(index).symbol_type==ST_STUB_RELOC    || \
			  Sym_Dict(index).symbol_type==ST_STUB_IMPORT)

#define IS_BL_STUB(stub) (stub->type == EXTERN_EXPORT_STUB ||		\
			  stub->type == EXPORT_RELOC_STUB ||		\
			  stub->type == DL_EXPORT_STUB ||		\
			  stub->type == HPUX_EXPORT_STUB ||		\
			  stub->type == LOCAL_RELOC_STUB		\
			 )

