/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Subspaces Definitions and Typedefs
 *
 */

struct	subsp_misc_record {
        int    r_o_x;  /* Remap old index to new index */
        int    r_n_x;  /* Remap new index to old index */
        int    r_c_x;  /* Remap old_index to compressed */
        int    exec_file_offset;
        int    data_file_offset;
        char  *subsp_data;
        int    next_stub_offset;
        int    stubs_file_loc;
        char  *file_name;	/* e.g., "/lib/libc.a(_start.o)" */
        char  *f_name;          /* e.g., "/lib/libc.a" */
#ifdef CNX_TOOLS
        char  *obj_fname;           /* object file name as: library(som) */
#endif /* CNX_TOOLS */
        char  *module_name;     /* e.g., "_start.o" */
        int    abs_fixup_count;
        int    abs_fixup_index;
        struct stub_record *stub_list;
        struct stub_record *stub_tail;
        int    symbol_count;
        int    symbol_index_bias;
        struct annotate_record *annotate_list;
        int    new_subspace_start;
        int    unwind_index;
        int    recover_index;
        int    copyram_index;
        int    copyram_count;
	int    rom_subsp_adjustment;  /* adjustment for alignments for copyram*/
	int    rom_subsp_length;      /* length of rom subsp */
	int    rom_subspace_start;      /* start of rom subsp */
        int    line_tbl_offset;
	int    first_common_def;
	int    subsp_has_dreloc		: 1; /*true if subsp has dreloc recs*/ 
	unsigned int input_subsp_only   : 2; /*true if not in output file */
	unsigned int force_new_align    : 1; /*true if new align is needed */
	unsigned int is_qualified       : 1; /*true if build_subsp was used */
        unsigned int delete_subspace    : 1; /*true if subsp is to be deleted*/
	unsigned int comdat_nulled      : 1; /*true if in a deleted group */

 	/* doom support */
        unsigned int is_doom_stripped   : 1; /*true if stripped by objdebug */
	unsigned int is_undefined_region: 1; /*true if OP_UNDEFINED_REGION  */
	unsigned int is_linker_generated: 1; /*true if OP_LINKER_SECTION    */
	unsigned int is_bss_subspace    : 1; /*true if name = "*BSS$"       */
	unsigned int is_linkmap_entry   : 1; /*true if part of the linkmap  */
	unsigned int subsp_data_out 	: 1; /*subsp_data has been written  *
					      *before out_subsp_data() 	    */

	unsigned int obj_has_dbg	: 1; /* indicates SOM contains debug info */

	unsigned int reserved		: 18;
        /* HP-UX shared libraries */
	int    shlib_version;   /* version number for this module */
        int    FDP_order_specified;  /* 0 if no order given, else large 
					negative # to force ordered subspaces
					(w. same key) before non-ordered ones */

        /* Overriding Sort Keys for Embed. Sys */
	int    include_order;       /* 0 if no order given, else negative */
	int    subsp_order;         /* 0 if no order given, else negative */
	char   *input_name;         /* ptr to input subsp name - if null use */
				    /* dictionary name*/
	char   *input_file_name;    /* ptr to input file name */

	int    check_bl_stub_offset; /* Used in stub_add to see if we need to
				     ** fix a BL stub to go through a long
				     ** branch while it can still reach the
				     ** long branch stub.  It is equal to
				     ** check_bl_stub->offset if check_bl_stub
				     ** is not NULL, else zero.
				     */

	struct stub_record      *check_bl_stub;  /* Used in fix_bl_stub to
				     ** keep track of the next BL stub which
				     ** may need to be fixed to go through
				     ** a long branch stub.
				     */
	int    entry_sym;

	int    comdat_next;          /* link field to the next subspace in
				     ** a set of COMDAT subspaces.
				     */

	int    comdat_head;          /* link field to the head of the list
				     ** of subspaces in a COMDAT set.
				     */
        int    module_id;            /* the ID number of the subsp's SOM */
                                  
 	/* doom support */
	unsigned int 			objfile_index;  
	struct input_subsp_contrib 	*contrib;
};

extern struct subspace_dictionary_record **_subsp_dict;
extern struct subsp_misc_record **_subsp_misc;

/*
extern Boolean two_pass;
extern char    *cur_file_name;
*/
extern char    *cur_name;
extern int     subsp_dict_size;
extern int     new_subsp_dict_size;
extern int     subsp_segs;
extern int     subsp_segs_max;
extern int     next_subsp_index_bias;
extern int     cur_subsp_index_bias;
extern int     data_file_offset;
extern int     subsp_data_area_max;
extern int     data_fildes;
extern Boolean mr_seen;  /* has a Memory Resident subspace been seen? */
extern char    *subsp_data_area;
extern char    *data_file;

extern void    subsp_initialize();
extern int	build_subspace();
extern void    subspaces_read();
extern void    subspace_add();
extern void    subspaces_sort();
extern void    extend_common();
extern void    delete_dup_common();
extern int     get_common_length();
extern void     delete_subsp();
extern void     subprog_elim();

#ifdef TSD
extern int	get_tbss_subsp_index();
#endif /* TSD */

/* Access to the subspace dictionary is through the following macros */

#ifdef DEBUG
#define Subsp_Chk(i)  (((i) >= 0 && (i) <= subsp_dict_size) ? (i) : (abort(),0))
#else
#define Subsp_Chk(i)  (i)
#endif /* DEBUG */

#define Subsp_Seg(i)	((i) >> log_subsp_dict_max)
#define Subsp_Off(i)	((i) & mask_subsp_dict_max)

#define Subsp_Dict(i)	_subsp_dict[Subsp_Seg(Subsp_Chk(i))][Subsp_Off(i)]
#define Subsp_Misc(i)	_subsp_misc[Subsp_Seg(Subsp_Chk(i))][Subsp_Off(i)]
#define Subspace_Virtual_Offset(i)	Subsp_Misc(i).new_subspace_start
#define Subspace_Length(i)	Subsp_Dict(i).subspace_length
#define Subspace_Sp_Number(i)	Subsp_Dict(i).space_index
#define Subsp_Stubs_Size(i)	Subsp_Misc(i).next_stub_offset
#define Subsp_First_Common(i)	Subsp_Misc(i).first_common_def
#define Overlay_Common(i,j)	Subsp_First_Common(j) = i
#define ComdatNext(i)           Subsp_Misc(i).comdat_next
#define ComdatHead(i)           Subsp_Misc(i).comdat_head

#define SUBSP_DELETE(i)         Subsp_Misc(i).delete_subspace = 1

#define BAD_SUBSP       (-1)

#define UNWIND_SORT      56
#define UNWIND_SORT_END  72
#define RECOVER_SORT     73
#define RECOVER_SORT_END 88

#define BAD_MODULE_ID    (-1)

#ifdef TSD
#define TSPECIFIC_SPACENAME	"$THREAD_SPECIFIC$"
#endif /* TSD */
