/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Symbol Manipulation Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/symbols.c,v 1.1.1.1 1999/10/18 19:53:04 pschwan Exp $
 */

#include <stdio.h>

#ifndef DEBUG
#define NDEBUG
#endif  /* !DEBUG */
#include <assert.h>

#include <string.h>
#include <strings.h> 

#include "filehdr.h"
#include "aouthdr.h"
#include "scnhdr.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "ld_strings.h"
#include "ldlimits.h"
#include "linker.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "libraries.h"
#include "comdat.h"

/* doom support */
#include "ld_linkmap.h"

extern int use_opt_sym_values;   /* temp def put in fixups.c */

#define LOCALHASH 1

/* recycle one or more symnode structs onto the free list */
#define free_node(n)	{struct symnode *temp_m = n; \
			 while ((temp_m != NULL) && \
			 	(temp_m->index != BAD_SYM) && \
				(Sym_Back_Ptr(temp_m->index) == n)) { \
				    Sym_Back_Ptr(temp_m->index) = NULL; \
				    temp_m = temp_m->same; } \
			 n->next = free_nodes; free_nodes = n;}

/* Globals */

struct symbol_record	**_sym_record = NULL;
struct symnode	*unsat_hash_table[UNSATHASHSIZE];
struct symnode *univ_hash_table[UNIVHASHSIZE];
struct symnode *sec_hash_table[SECHASHSIZE];

/* HP-UX shared library "soft" unsat table */
struct symnode *shlib_unsat_hash_table[UNSATHASHSIZE];

struct shlib_export_item {
    char 			*name;
    unsigned char 		type;
#ifdef TSD 
    unsigned int		is_tp_relative:1;
    unsigned int		reserved1:7;
    unsigned short		reserved2;
#endif /* TSD */
    int                         size;
    char                        *filename;
    struct shlib_export_item	*next;  /* next on hash chain */
};

static struct shlib_export_item 
	*shlib_exports_hash_table[SHLIB_EXPORT_HASH_SIZE];

char** shlib_export_seg = NULL;
int shlib_export_seg_max = 0;
int cur_shlib_export_seg = -1;
int shlib_export_seg_free_bytes = 0;
#define SHLIB_EXPORT_SEG_MAX 50
#define SHLIB_EXPORT_SEG_SIZE 65536

struct namenode {
    struct namenode *next;
    char *name;
    unsigned int hashval;
};

static struct namenode *hide_hash_table[HIDE_LIST_HASH_SIZE];
static int hide_hash_count = 0;
static struct namenode *export_hash_table[EXPORT_LIST_HASH_SIZE];
static int export_hash_count = 0;
static struct namenode *excl_exp_hash_table[EXPORT_LIST_HASH_SIZE];
static int excl_exp_hash_count = 0;

static struct namenode *free_names;

/* recycle one or more hidenode structs onto the free list */
#define free_name(n)	{ n->next = free_names; free_names = n;}

/* 
** This is a null symbol record that is initialized to ST_NULL/SS_LOCAL
** at run time.  We point ST_SYM_EXT and ST_ARG_EXT symbols to this after
** we have done the symbol type checking. 
*/
struct symbol_record null_symbol_record = {0};
struct symbol_record *free_syms = NULL;

int    sym_dict_size = 0;	 /* bias of last symbol added               */
int    input_symbols_bias = 0;	 /* bias of last symbol read from all input */
int    cur_sym_index_bias = 0;   /* bias of first symbol read for a SOM     */
int    cur_syms_alloc = 0;	 /* syms currently with ptr space */
int    node_max = NODE_MAX;
int    node_segs = 0;
int    node_segs_max = MAX_SEGS;
int    entry_symbol_index = BAD_SYM;
int    num_storage_requests = 0;  /*Upper bound on num of storage requests*/
                                  /* for stor req sorting */
int    hidden_shlib_exports = 0;

Boolean type_match_table[NUM_TYPES][NUM_TYPES];

#ifdef TSD
int    tbss_size; /* current TSD offset */
extern int tls_addr; 
extern Boolean bad_tls;
extern int previous_tls_addr;
extern int prev_tls;
#endif /* TSD */
/* Locals */

#ifdef LOCALHASH
static struct symnode *local_hash_table[LOCALHASHSIZE];
#endif /* LOCALHASH */

static struct symnode **nodes = NULL;
static struct symnode *free_nodes = NULL;

static unsigned int	entry_hashval;

	/* Macros for format strings for -Fu/-Fs.  We can use macros
	** here, 'cause we compile w/ +ESlit, which shares strings */
#define FORMAT_STRING_UNDEF  "0000000000 U  %s\n"
#define FORMAT_STRING_TEXT   "0000000000 T  %s\n"
#define FORMAT_STRING_DATA   "0000000000 D  %s\n"

/* Forward declarations */

extern char* get_symbol_filename(int sym_index);
extern Boolean symnode_match();
extern Boolean symnode_same();

static void init_type_match_table();

extern int FDP_add();
extern int FDP_find();

#ifdef ESOM

static int nsBssIndex = BAD_SUBSP;
static int nsDataIndex = BAD_SUBSP;
static int fsBssIndex = BAD_SUBSP;
static int fsDataIndex = BAD_SUBSP;
static int npBssIndex = BAD_SUBSP;
static int npDataIndex = BAD_SUBSP;

#define isSPPspace(symIndex)           \
      ((nsBssIndex == symIndex)  ||    \
       (nsDataIndex == symIndex) ||    \
       (fsBssIndex == symIndex)  ||    \
       (fsDataIndex == symIndex) ||    \
       (npBssIndex == symIndex)  ||    \
       (npDataIndex == symIndex))

static void initMemIndexes()
{
   if (nsBssIndex == BAD_SUBSP) 
      nsBssIndex = find_subspace_by_name("$NSBSS$");
   if (nsDataIndex == BAD_SUBSP) 
      nsDataIndex = find_subspace_by_name("$NSDATA$");
   if (fsBssIndex == BAD_SUBSP) 
     fsBssIndex = find_subspace_by_name("$FSBSS$");
   if (fsDataIndex == BAD_SUBSP) 
     fsDataIndex = find_subspace_by_name("$FSDATA$");
   if (npBssIndex == BAD_SUBSP) 
     npBssIndex = find_subspace_by_name("$NPBSS$");
   if (npDataIndex == BAD_SUBSP) 
     npDataIndex = find_subspace_by_name("$NPDATA$");
}

struct esom_subspaces_s {
	int	value;
	char	*name;
};

static struct esom_subspaces_s esom_subspaces[] = {
	{1, "$FSDATA$"},
	{1, "$FSDATA2$"},
	{1, "$FSBSS$"},
	{2, "$NSDATA$"},
	{2, "$NSDATA2$"},
	{2, "$NSBSS$"},
	{3, "$NPDATA$"},
	{3, "$NPDATA2$"},
	{3, "$NPBSS$"},
	{-1, 0} 
};

static int
is_esom_subspa(name)
char *name;
{
    int i;

    /* Perf enhancement to reduce the number of strcmp's  */
    if (*name != '$' || (*(name+1) != 'F' && *(name+1) != 'N')) return -1;

    for(i = 0; esom_subspaces[i].value != -1; i++ ) {
	if ( strcmp(name, esom_subspaces[i].name) == 0 )
	    return esom_subspaces[i].value;
    }
    return -1;
}

/*
 * Verify that the subspaces of the two symbols are in the same memory class.
 * Returns zero if compatible, non-zero otherwise
 */
static int
check_spp_subspaces(newtype, oldtype, newindex, oldindex)
int newtype, oldtype, newindex, oldindex;
{
    struct subspace_dictionary_record *newsubspa = NULL;
    struct subspace_dictionary_record *oldsubspa = NULL;
    int i, nval, oval;

    if (!newtype || !oldtype || newindex == BAD_SUBSP || oldindex == BAD_SUBSP)
	return 0;

    newsubspa = &Subsp_Dict(newindex);
    oldsubspa = &Subsp_Dict(oldindex);

    /*
     * both have the same subspace names, so return success
     */
    if ( strcmp(newsubspa->name.n_name, oldsubspa->name.n_name) == 0 )
	return 0;

    oval = is_esom_subspa(oldsubspa->name.n_name);
    nval = is_esom_subspa(newsubspa->name.n_name);

    /*
     * both are not or are the same esom (spp/ux) subspaces, so return success
     */
    if (oval == nval )
	return 0;

    if ( oval == -1 ) {
	if ( nval == 0 )
		return -1;
	return 0;
    } else if ( nval == -1 ) {
	if ( oval == 0 )
		return -1;
	return 0;
    }
    return -1;
}

/* returns a pointer to the file name for the given symbol index */
char *get_symbol_filename(int sym_ind); /* defined further down */

static int bad_memory_class_common = 0;

void bad_common_subspaces(name,qname,first_sym_ind,second_sym_ind)
char *name, *qname;
int first_sym_ind, second_sym_ind;
{
    char buf[80];
    char *c;
    char *first_file, *second_file;

    if (qname != NULL) {
        sprintf(buf, "%.39s.%.39s", qname, name);
        c = buf;
        }
    else
        c = name;

    first_file = get_symbol_filename(first_sym_ind);
    second_file = get_symbol_filename(second_sym_ind);

    if (!first_file) 
	warning(BAD_MEM_COMMON, c, second_file, 0);
    else if (!second_file) 
	warning(BAD_MEM_COMMON, c, first_file, 0);
    else 
        warning(BAD_MEM_COMMONS, c, first_file, second_file, 0);
    ++bad_memory_class_common;
}
#endif /* ESOM */

void sym_initialize()
{
    int i;
    extern void init_free_list();

    dup_symbols = 0;
    parm_check_errs = 0;
    sym_dict_size = 0;
    cur_sym_index_bias = 0;
    input_symbols_bias = 0;
    entry_symbol_index = BAD_SYM;
    num_storage_requests = 0;

#ifdef TSD 
    tbss_size = 0;
#endif /* TSD */
    /* 
    ** Set up our null symbol record to point things at when we are done
    ** with symbol extension records. 
    */
    null_symbol_record.dict.symbol_type = ST_NULL;
    null_symbol_record.dict.symbol_scope = SS_LOCAL;
    null_symbol_record.dict.n_nptr = "NULL_SYMBOL_OF_DEATH";

    for (i = 0; i < UNSATHASHSIZE; i++)
	unsat_hash_table[i] = 0;
    /* HP-UX shared library processing */
    for (i = 0; i < UNSATHASHSIZE; i++)
	shlib_unsat_hash_table[i] = 0;
    for (i = 0; i < SHLIB_EXPORT_HASH_SIZE; i++)
	shlib_exports_hash_table[i] = 0;
    for (i = 0; i < UNIVHASHSIZE; i++)
	univ_hash_table[i] = 0;
#ifdef LOCALHASH
    for (i = 0; i < LOCALHASHSIZE; i++)
	local_hash_table[i] = 0;
#endif /* LOCALHASH */
    for (i = 0; i < SECHASHSIZE; i++)
	sec_hash_table[i] = 0;
    for (i = 0; i < HIDE_LIST_HASH_SIZE; i++)
	hide_hash_table[i] = 0;
    for (i = 0; i < EXPORT_LIST_HASH_SIZE; i++)
	export_hash_table[i] = 0;
    for (i = 0; i < EXPORT_LIST_HASH_SIZE; i++)
        excl_exp_hash_table[i] = 0;

    if (_sym_record == NULL) {
	/* If cur_syms_alloc is null, set the initial symbol table size */
	if (cur_syms_alloc == 0) {
	    cur_syms_alloc = sym_dict_max;	/* Initial table size */
	}

        /* allocate symbol dictionary segment pointers */
        _sym_record = (struct symbol_record **)
		       emalloc(cur_syms_alloc * 
			       sizeof(struct symbol_record *));
    }
    if (node_segs > 0)
        init_free_list(0);

    init_relink_list();

    init_type_match_table();
} /* end sym_initialize */

add_entry_name()
{
    /* set hashval of entry - this is called from linker */
    /* because initialize is now called from driver well before the */
    /* entry is given */
    if (entry_name) entry_hashval = hash_string(entry_name);

} /* end add_entry_name */

add_undef_list_to_unsat_table()
{
    char *name;
    unsigned int hashval;  

    /* add pre-undefined symbols specified by user (-u or unsat in cmd file)*/
    if (undef_list) {
	while (name = *undef_list++) {
	    hashval = hash_string(name);
	    name = add_string(&sym_strings, name, hashval, FALSE, TRUE);
	    unsat_add(name, 0, NULL, hashval, -1, ST_NULL, 0, 0);
	}
    }	   	
} /* end add_undef_list_to_unsat_table */

/* 
** 	for large links, symbol_allocate() gets called quite a lot and
** most of the times, there are no free symbols on the free list.  Use
** this helper function to provide "buffer" for symbol records and reduce
** amount of time consumed by malloc()
*/
#define LD_MIN_SYMALLOC_SIZE 1000
static struct symbol_record *ldi_sym_records = NULL;
static 
struct symbol_record *get_new_sym_record(void) 
{
   static index = 0;
 
   if ((index == LD_MIN_SYMALLOC_SIZE) || !ldi_sym_records) {
      ldi_sym_records = (struct symbol_record *)emalloc
	(LD_MIN_SYMALLOC_SIZE*sizeof(struct symbol_record));
      index = 0;
   }

   return (&ldi_sym_records[index++]);  
}

int symbol_allocate(subsp)
int subsp;
{
    /* 
    ** allocates a new set of symbol dictionary and misc records "on the fly".
    ** Does a limited amount of init as well (for globally used values). 
    */

    struct symbol_misc_record *misc;

    int index = sym_dict_size++;

    if (sym_dict_size >= cur_syms_alloc) {
	cur_syms_alloc += sym_dict_max;
	_sym_record = (struct symbol_record **)
			    erealloc((char *) _sym_record, cur_syms_alloc *
				sizeof(struct symbol_record *));
    }

    if (free_syms == NULL) {
	/* replace malloc() with a buffer */
	_sym_record[index] = get_new_sym_record();
    } else {
	/* recycle from free list */
	_sym_record[index] = free_syms;
	free_syms = (struct symbol_record *) free_syms->misc.back_ptr;
    }

    misc = &_sym_record[index]->misc;

    memset((char *) _sym_record[index], '\0', sizeof(struct symbol_record));

        /* 
        ** Init globally, on the principle that compilers do it for us when 
	** read in, so we need to do it when building a symbol on the fly. 
	*/

    /* all fields that are not explicitly set here will have the value zero */
    misc->out_remap = BAD_SYM;
    misc->related_stub = BAD_SYM;
    misc->subsp = subsp;
    misc->shlib_import_indx = -1; /* checked in alloc of standalone PIC DLT */
    misc->referenced = force_ext_milli_syms; /* Init to referenced if -Ht on */
    misc->checked = Sym_Misc(0).checked; /* Set it's checked value to
					    the same as everyone else's */

    return(index);
} /* end symbol_allocate */

#define READ_BUFSIZE	256

void symbols_read(fil_ofs,nsyms)
int fil_ofs,nsyms;
{
    register int index, count;
    struct symbol_dictionary_record *insym;
    struct symbol_dictionary_record read_buf[READ_BUFSIZE];  
					/* to read for reused sym_records */
    register int i;
    struct symbol_misc_record *misc;

    cur_sym_index_bias = sym_dict_size;
    while (nsyms > 0) {
        index = sym_dict_size;

	/* ensure enough space in symbols base pointer array */
	if (sym_dict_size+nsyms >= cur_syms_alloc) {
	    cur_syms_alloc = max(cur_syms_alloc+sym_dict_max, 
				 			sym_dict_size+nsyms);
	    _sym_record = (struct symbol_record **)
			    erealloc((char *) _sym_record, cur_syms_alloc *
				sizeof(struct symbol_record *));
        }

	/* get new syms' heap space */
	if (free_syms == NULL) {
	    /* 
	    ** free list is empty, malloc enough to read the rest of the syms
	    */
	    _sym_record[index] = (struct symbol_record *)
    			emalloc(nsyms * sizeof(struct symbol_record));
            insym = &_sym_record[index]->dict;
            count = nsyms;
	} else {
	    /* recycle structs from the free list */
    	    struct symbol_record *free_list_ptr;  /* working ptr for count */
            insym = read_buf;
	    /* count = min(READ_BUFSIZE, nsyms, # of free sym_records) */
	    for (count=0, 
		 free_list_ptr = (struct symbol_record *) free_syms; 
		 (count < min(READ_BUFSIZE, nsyms)) && (free_list_ptr != NULL); 
		 count++, 
		 free_list_ptr = (struct symbol_record *)
			 free_list_ptr->misc.back_ptr) {
		     assert(free_list_ptr != (struct symbol_record *)
					     free_list_ptr->misc.back_ptr);
	     }
	}

        ffetch(cur_fildes, 
	       fil_ofs, 
	       insym,
	       sizeof(struct symbol_dictionary_record), 
	       count);

	/* unpack into correct places all sym_dicts after the first read */
	for (i=count-1;i>=0; i--) {
	    if (free_syms == NULL) {
            	*(struct symbol_dictionary_record *) ((char *)insym +
                			i*sizeof(struct symbol_record)) =
                          *(struct symbol_dictionary_record *) ((char *)insym +
                          i*sizeof(struct symbol_dictionary_record));
	    	_sym_record[index+i] = (struct symbol_record *) 
				((char *)insym + 
				 i*sizeof(struct symbol_record));

		misc = &_sym_record[index+i]->misc;
		memset((char *)misc, '\0', sizeof(struct symbol_misc_record));

		/* all fields that are not explicitly set here will 
		   have the value zero */
		misc->out_remap = BAD_SYM;
		misc->related_stub = BAD_SYM;
		misc->shlib_import_indx = -1; /*init for alloc of standalone 
						PIC DLT */
		misc->referenced = force_ext_milli_syms; /* Init to referenced 
							    if -Ht on*/

	    } else { /* reuse struct from the free list */
		_sym_record[index+i] = free_syms;
	    	free_syms = (struct symbol_record *) free_syms->misc.back_ptr;
            	_sym_record[index+i]->dict = read_buf[i];

		misc = &_sym_record[index+i]->misc;
		memset((char *)misc, '\0', sizeof(struct symbol_misc_record));
		
		/* all fields that are not explicitly set here will 
		   have the value zero */
		misc->out_remap = BAD_SYM;
		misc->related_stub = BAD_SYM;
		misc->shlib_import_indx = -1; /*init for alloc of standalone 
						PIC DLT */
		misc->referenced = force_ext_milli_syms; /* Init to referenced 
							    if -Ht on*/
	    }
	}

        sym_dict_size += count;
        nsyms -= count;
        fil_ofs += count * sizeof(struct symbol_dictionary_record);
    } /* while nsyms */

} /* end symbols_read */

void symbols_add(sym_ind,count)
int sym_ind, count;
{
    int i, last;
#ifdef LOCALHASH
    extern void local_purge();
#endif /* LOCALHASH */

    last = sym_ind + count;

#ifdef LOCALHASH
    /* add locals first, then others */
    for (i = sym_ind; i < last; i++)
	if (Sym_Scope(i) == SS_LOCAL) symbol_add(i);
    for (i = sym_ind; i < last; i++) {
	if (Sym_Scope(i) != SS_LOCAL) {
	    symbol_add(i);

	    /*   +ee option. If we specify a symbol to export using
	     *              +ee, we need to add it to our export list here 
	     */

	    if (!search_alldefs && 
		Sym_Type(i) != ST_SYM_EXT && Sym_Type(i) != ST_ARG_EXT &&
		Sym_Type(i) != ST_NULL && on_excl_export_list(Sym_Name(i))) {
		struct symnode *n;
		
		n = Sym_Back_Ptr(i);
		n->next = minimum_export_list;
		minimum_export_list = n;
	    }
	}
    }

    /* add check for building shlib and dupe sym occurred */
    if ((dup_symbols > 0) && building_shlib)
      user_error (DUPE_SYMS_SHLIB, 0);

#else
    for (i = sym_ind; i < last; i++)  {
	symbol_add(i);

	/*   +ee option. If we specify a symbol to export using
	 *              +ee, we need to add it to our export list here 
	 *  Don't call for EXT's - no name.
	 */

	if (!search_alldefs && 
	    Sym_Type(i) != ST_SYM_EXT && Sym_Type(i) != ST_ARG_EXT &&
	    Sym_Type(i) != ST_NULL && on_excl_export_list(Sym_Name(i))) {
	    struct symnode *n;

	    n = Sym_Back_Ptr(i);
	    n->next = minimum_export_list;
	    minimum_export_list = n;
	}
    }

    /* add check for building shlib and dupe sym occurred */
    if ((dup_symbols > 0) && building_shlib)
      user_error (DUPE_SYMS_SHLIB, 0);

#endif /* LOCALHASH */

#ifdef ESOM
    if (bad_memory_class_common > 0)
	external_error_n(BAD_MEM_COMS, bad_memory_class_common);
#endif /* ESOM */

    /* 
    ** now look for unqualified definitions to satisfy optionally qualified
    ** references 
    */
#if 0
    /* COMMENTED OUT UNTIL/UNLESS NEEDED FOR COBOL */
    resolve_qualified_unsats(); 
#endif /* 0 */

#ifdef LOCALHASH
    /* locals not needed anymore */
    local_purge();
#endif /* LOCALHASH */

} /* end symbols_add */

void symbol_add (sym_ind) 
int sym_ind;
{
#ifdef ESOM
    int match_err;
#endif /* ESOM */
    register struct symbol_dictionary_record *sym;
    struct symbol_dictionary_record *dsym;
    struct symbol_misc_record *misc;
    struct symbol_misc_record *dmisc;
    int info, ind, value, secondary_sym;
    Boolean mq;
    int oldtyp;
    unsigned int hashval;
    char *name, *qname;
    int max_size = 0, len;
    int x; 
    int priv_level;  /* for checking fru promotion stubs re SR 5003045153 */
    int fru_type;

#ifdef TSD
    struct subspace_dictionary_record *subsp;
#endif /* TSD */

    extern void dup_sym_add();

    Boolean fru_promote = FALSE;  /* flag if we need to do extra checking for
				     promotion stubs. For FRU
				     re SR 5003045153 04/30/92*/

    sym = &Sym_Dict(sym_ind);
    misc = &Sym_Misc(sym_ind);
#if 0
    memset((char *)misc, '\0', sizeof(struct symbol_misc_record));

#ifdef TSD /* TSD */
    Sym_TLS(sym_ind) = FALSE;
#endif /* TSD */

    /* all fields that are not explicitly set here will have the value zero */
    misc->out_remap = BAD_SYM;
    misc->related_stub = BAD_SYM;
    misc->shlib_import_indx = -1; /*init for alloc of standalone PIC DLT */
    misc->referenced = force_ext_milli_syms;  /* Init to referenced if -Ht on*/
#endif
    /* 
    **  Check for extension records right here and set bit in misc
    ** record if we have them.	We check this bit in linear passes of the 
    ** fixups in out_symbol_records() and count_symbols().
    */
    x = sym_ind+1;
    if ( x < sym_dict_size) 
         if (Sym_Dict(x).symbol_type == ST_SYM_EXT)
             Sym_Misc(sym_ind).has_ext_recs = TRUE;

    /* if dynamic link, don't put millicode in symbol table */
    if (base_file_name == cur_file_name &&
	sym->symbol_type == ST_MILLICODE &&
        !relinkable)
	sym->symbol_type = ST_NULL;

    /* ignore extension records */
    if (sym->symbol_type == ST_SYM_EXT ||
    	sym->symbol_type == ST_ARG_EXT ||
	sym->symbol_type == ST_NULL)
	return;

    /* relocate indexes according to new bias */
    sym->symbol_info += cur_subsp_index_bias;
    info = sym->symbol_info;
    misc->subsp = info;

    /* doom support */
    lm_symbol_add(sym_ind);

    /*
     *  If this symbol is in a deleted comdat section, 
     *              we don't increment the symbol count, because
     *              the symbol is going to be nulled out anyhow.
     */

    if (base_file_name != cur_file_name || !relinkable) {
	/* NOT base file of FRU relink */

	if ((sym->symbol_scope != SS_UNSAT) &&
	    ( !comdat_is_nullified(info) )) {
	    
	    Subsp_Misc(info).symbol_count++;
	}
    }

    if (sym->name.n_strx > sym_str_buffer.size)
	external_error_sn(BAD_STR_INDEX, cur_name,
			sym_ind-sym_str_buffer.size);

    name = sym_str_buffer.block_ptr + sym->name.n_strx;
    hashval = hash_string(name);
    name = sym->name.n_name = add_string(&sym_strings,name,hashval,TRUE,TRUE); 

    if (Sym_Scope(sym_ind) == SS_LOCAL &&
	sym->is_comdat) {
       external_error(CTTI_LOCAL_KEY, name, get_symbol_filename(sym_ind), 0);
    }

    if (sym->qualifier_name.n_strx != 0) {
	if (sym->qualifier_name.n_strx > sym_str_buffer.size)
	    external_error_sn(BAD_STR_INDEX, cur_name,
			sym_ind-sym_str_buffer.size);
	qname = sym_str_buffer.block_ptr + sym->qualifier_name.n_strx;
	qname = sym->qualifier_name.n_name = add_string(&sym_strings, qname,
				                        hash_string(qname),
							TRUE,TRUE); 
    } else {
	qname = NULL;
    }

    if ((reset_secdef_syms) && (sym->symbol_type != ST_STORAGE)) {
       sym->secondary_def = FALSE; 
    }

    secondary_sym = sym->secondary_def;

    mq = sym->must_qualify;
    if (mq && hash_qual)
	hashval ^= hash_string(qname);
    value = sym->symbol_value;

    if (trace_list) check_trace_list(sym->NAME_PT, 
				     sym->symbol_type,
				     sym->symbol_scope,
				     cur_name);

    /* C++ duplicate inlines.  Hide the symbol unless this is an ld -r link.
    ** This reduces the exports from shared libraries and uniformly hiding
    ** these make life easier for the C++ link process.  We can only
    ** hide code symbols as COBOL uses the dup_common data symbols.
    */

    if (   sym->dup_common
	&& !relocatable
	&& sym->symbol_scope != SS_LOCAL
	&& sym->symbol_type == ST_CODE) {

	hide_list_add(name);
    }

    switch(sym->symbol_scope) {
	case SS_UNSAT:
	    switch(sym->symbol_type) {
    	        case ST_DATA:
#ifdef LOCALHASH
		    ind = (ld_footprint_seen ? BAD_SYM : 
			   local_find (name, 
				       mq, 
				       qname, 
				       hashval, 
				       ST_DATA));
		    if (ind == BAD_SYM)
#endif /* LOCALHASH */
		    ind = univ_find (name, 
				     mq, 
				     qname, 
				     hashval, 
				     ST_DATA);

		    if (ind == BAD_SYM)
			ind = univ_find (name, 
					 mq, 
					 qname, 
					 hashval, 
                                         ST_ABSOLUTE);
                       
		    if (ind == BAD_SYM)
			unsat_add (name, 
				   mq, 
				   qname, 
				   hashval, 
				   sym_ind,
                                   ST_DATA, 
				   0, 
				   0);
		    else 
                        symbol_resolve (sym_ind, ind);
		    break;
	        case ST_STUB:
#ifdef LOCALHASH
		    ind = (ld_footprint_seen ? BAD_SYM :
			   local_find (name, 
				       mq, 
				       qname, 
				       hashval, 
				       ST_CODE));
		    if (ind == BAD_SYM)
#endif /* LOCALHASH */
		    ind = univ_find (name, 
				     mq, 
				     qname, 
				     hashval, 
				     ST_CODE);

		    if (ind == BAD_SYM)
			unsat_add (name, 
				   mq, 
				   qname, 
				   hashval, 
				   sym_ind,
                                   ST_STUB, 
				   0, 
				   0);
                    else
		        symbol_resolve (sym_ind, ind);
		    break;
	        case ST_CODE:
	        case ST_MILLICODE:
#ifdef LOCALHASH
		    ind = (ld_footprint_seen ? BAD_SYM :
			   local_find(name,
				      mq,
				      qname,
				      hashval,
				      ST_CODE));
		    if (ind == BAD_SYM)
#endif /* LOCALHASH */
		    ind = univ_find(name,
				    mq,
				    qname,
				    hashval,
				    ST_CODE);

		    if (ind == BAD_SYM)
			ind = univ_find(name,
					mq,
					qname,
					hashval,
					ST_ABSOLUTE);

		    if (ind == BAD_SYM) {
			unsat_add(name,
				  mq,
				  qname,
				  hashval,
				  sym_ind,
				  ST_CODE,
				  0, 
				  0);
		        Sym_Misc(sym_ind).referenced = 1;
 		    } else {
			symbol_resolve(sym_ind,ind);

		        /* Mark this symbol as referenced so we actually */
			/* output it otherwise we weed out unused milli ext */
			/* syms. It does not matter that code syms have this */
			/* bit on */
		        Sym_Misc(ind).referenced = 1;
	   	    }
		    break;
#ifdef TSD /* TSD */
	        case ST_TSTORAGE:
		    /*
		    ** Don't look for Data Univ since we don't allow
                    ** initialized commons
                    */
		    Sym_TLS(sym_ind) = TRUE;
#if defined (TSD) && defined (DEBUG) /* TSD DEBUG */
		    if (verbose & V_TSD) {
		       printf("TLS COMMON sym %s size %d\n", name,
			      sym->symbol_value); 
		    }
#endif /* TSD DEBUG */

#ifdef LOCALHASH
		    ind = (ld_footprint_seen ? BAD_SYM :
			   local_find(name,
				      mq,
				      qname,
				      hashval,
				      ST_DATA));
    		    if (ind == BAD_SYM)
#endif /* LOCALHASH */
			unsat_add(name,
				  mq,
				  qname,
				  hashval,
				  sym_ind,
				  ST_TSTORAGE,
				  value, 
				  secondary_sym);
		    break; /* case ST_STORAGE */
#endif /* TSD */

	        case ST_STORAGE:
#ifdef LOCALHASH
		    ind = (ld_footprint_seen ? BAD_SYM :
			   local_find(name,
				      mq,
				      qname,
				      hashval,
				      ST_DATA));
    		    if (ind == BAD_SYM)
#endif /* LOCALHASH */
		    ind = univ_find(name,
				    mq,
				    qname,
				    hashval,
				    ST_DATA);

		    if (ind == BAD_SYM)
			ind = univ_find(name,
					mq,
					qname,
					hashval,
					ST_ABSOLUTE);

		    if (ind == BAD_SYM) {
			unsat_add(name,
				  mq,
				  qname,
				  hashval,
				  sym_ind,
				  ST_STORAGE,
				  value, 
				  secondary_sym );
		    } else {
                        /*
			** already defined; remap 
                        */
			if ((oldtyp = Sym_Remap_Type(ind)) != ST_DATA &&
						    oldtyp != ST_ABSOLUTE) {
			    /* 
			    ** Don't let a storage request be resolved by
			    ** a text symbol 
			    */
			    dup_sym_add (name, qname, ind, sym_ind);
			}
#ifdef ESOM
			match_err = 
			    check_spp_subspaces(Sym_Common(sym_ind), 
						Sym_Common(ind), 
						Sym_Subsp(sym_ind), 
						Sym_Subsp(ind));
			if ( match_err ) {
			    bad_common_subspaces(Sym_Name(ind), 
						 0, ind, sym_ind);
			}
#endif /* ESOM */
			symbol_resolve (sym_ind, ind);
			dsym = &Sym_Dict(ind);
			dmisc = &Sym_Misc(ind);
			if (dsym->is_common) {
			    /* 
			    ** adjust length of "common" subspace to 
			    ** max(max storage req, prev len) 
			    */
			    len = get_common_length(Sym_Subsp(ind));
			    /* if len == 0 then Univ sym came from basefile */ 
			    if (sym->symbol_value > len && len > 0) {
				char *  dup_sym_file;
				char *  dup_sym_file2;

				extend_common(Sym_Subsp(ind),
					      sym->symbol_value);

				dup_sym_file = get_symbol_filename(ind);
				if (!dup_sym_file) {
				    dup_sym_file = "";
				}
				dup_sym_file2 = get_symbol_filename(sym_ind);
				if (!dup_sym_file2) {
				    dup_sym_file2 = "";
				}

				/* doom support */
				dmisc->objfile_index = misc->objfile_index;

		      		warning(COMMON_BLOCKS_DIF_LEN, 
					name, 
					dup_sym_file,
					dup_sym_file2,
					0);
			    }
			}
		    }
		    num_storage_requests++; /* used when elim addil's */
		    break; /* case STORAGE */
	        case ST_ABSOLUTE:
	        case ST_MILLI_EXT:
		    ind = univ_find(name,
				    mq,
				    qname,
				    hashval,
				    ST_ABSOLUTE);

		    if (ind == BAD_SYM)
		       unsat_add(name,
				 mq,
				 qname,
				 hashval,
				 sym_ind,
				 ST_ABSOLUTE,
				 0,
				 0);
		    else symbol_resolve(sym_ind,ind);
		    break;
	        case ST_NULL: /* should prob print out message here */
		    break;
	        default:
		    external_error_sn(BAD_SYM_TYP_SS_UNSAT, 
				      cur_name,
				      sym->symbol_type);
		    break;
		}
	    break; /* case SS_UNSAT */
        case SS_UNIVERSAL:
	    switch(sym->symbol_type) {
	        case ST_DATA:
#ifdef TSD /* TSD */
	            if (Subsp_Dict(sym->symbol_info).is_tspecific) {
		       Sym_TLS(sym_ind) = TRUE;

#ifdef DEBUG
      		       if (verbose & V_TSD) {
		          printf("val: 0x%x tls: 0x%x sub: 0x%x\n", 
			         Sym_Value(sym_ind),
			         tls_addr,
			         Subsp_Dict(sym->symbol_info).subspace_start);
		       }
#endif /* DEBUG */
		       /* 
		       ** here.  1) we need to adjust symbol_value for a -r
		       ** link because code gen starts $TBSS$ at 40000000
		       ** instead of 0.  2) a -r linked .o file subsequently
		       ** linked normally had bad tls offsets.  Need to
		       ** special case this because tls_addr for a -r'd
		       ** file is for all $TBSS$ in the file, not just one
		       ** subspace.  We overload code_only to denote this
		       ** subspace is from a -r'd file.
                       */
		       if (!relocatable && 
			   Subsp_Dict(sym->symbol_info).code_only) {
			  /* special case first entry in $TBSS$ */
			  if (Sym_Value(sym_ind) == 0) {
			     Sym_Value(sym_ind) = previous_tls_addr;
			     if (previous_tls_addr == 0) {
			        previous_tls_addr++;
			     }
			  } else {
			      Sym_Value(sym_ind) = prev_tls + 
			                          Sym_Value(sym_ind);
			  }

		       } else if (relocatable && 
				  Sym_Value(sym_ind) != 0 && 
				  Subsp_Dict(sym->symbol_info).code_only) {
			 /* -r of a -r'd file */
			 Sym_Value(sym_ind) = tls_addr - Sym_Value(sym_ind);
                       } else if (Sym_Value(sym_ind) != 0) {
                          Sym_Value(sym_ind) = (Sym_Value(sym_ind) - 
		               Subsp_Dict(sym->symbol_info).subspace_start) +
			       tls_addr;
			  if (previous_tls_addr == 0) {
			     previous_tls_addr++;
			  }
		       }

#ifdef DEBUG /* DEBUG */
		       if (verbose & V_TSD) {
                          printf("sym %s at %d is TLS off %d\n", name, sym_ind,
	                         Sym_Value(sym_ind)); 
		       }
#endif /* DEBUG */
		    }
#endif /* TSD */
                    if (secondary_sym) {
		        secondary_add(name,
			 	      mq,
				      qname,
				      hashval,
				      sym_ind,
				      ST_DATA);
                       /* ignore duplicate secondary symbols */
                       return;
                    }
#ifdef TSD /* TSD */
		    /* flag initialized TLS commons right here and quit */
		    if (Sym_TLS(sym_ind) && sym->is_common) {
		        external_error(TSD_INIT_COMMON, name);
		    }
#endif /* TSD */


		    /* process the comdat stuff to see if we need to proceed */

		    if (!comdat_process(name, mq, qname, 
					hashval, sym_ind, ST_DATA)) {
		       return;
		    }

		    ind = univ_add(name,
				   mq,
				   qname,
				   hashval,
				   sym_ind,
				   ST_DATA);

                    if (ind != sym_ind) {
#ifdef TSD /* TSD */
		       /* 
		       ** If we have two TLS Data Univ or one TLS Data Univ
		       ** and one Data Univ, we have either duplicate symbols
                       ** or name space collisions.  
		       */
		       if (Sym_TLS(sym_ind) && Sym_TLS(ind)) {
                          /* duplicate TLS Data Univ */
                          dup_sym_add(name, qname, ind, sym_ind);
			  symbol_resolve(sym_ind, ind);
		       } else if (Sym_TLS(sym_ind) || Sym_TLS(ind)) {
			  /* name space collision */
			  warning(TSD_SYM_MISMATCH, name);
			  bad_obj = TRUE;
			  bad_tls = TRUE;
		       } else {
#endif /* TSD */ 
                        if (sym->is_common && sym->dup_common) {
                            /* 
                            ** COBOL-style common:  allow duplicate defs 
                            ** as long as they're all the same length;   
                            ** ignore all but first                      
                            */
                            symbol_resolve (sym_ind, ind);
                            /* 
                            **  ld -r on dupe commons
                            ** give length mismatch error.  After we call
                            ** symbol_resolve, Sym_Subsp(sym_ind) 
                            ** points to ind's subspace, which isn't what
                            ** what we want to delete.  We want the
                            ** subspace for sym_ind *before* the remap--
                            ** that subspace index is kept in info.
                            */
                            if (get_common_length(info) !=
				  get_common_length (Sym_Subsp (ind))) {

				char *  dup_sym_file;
				char *  dup_sym_file2;

				dup_sym_file = get_symbol_filename(ind);
				if (!dup_sym_file) {
				    dup_sym_file = "";
				}
				dup_sym_file2 = get_symbol_filename(sym_ind);
				if (!dup_sym_file2) {
				    dup_sym_file2 = "";
				}
				bad_obj = TRUE;
				warning(ERR_COMMON_BLOCKS_DIF_LEN,
					name,
					dup_sym_file,
					dup_sym_file2,
					0);
			    }
                            delete_dup_common (info);
			} else if (sym->is_common) {
			    /* 
			     ** FORTRAN-style common:  allow duplicate defs 
			     ** and chain them together so initializations  
			     ** can overlap				   
			     */
			    if (!relocatable) {
				symbol_resolve(sym_ind, ind);
				len = get_common_length(Sym_Subsp(ind));
				max_size = get_common_length(info);
				
				/* if len=0 then Univ sym came 
				 ** from the basefile
				 */ 
				
				if (max_size > len && len > 0)
				  extend_common(Sym_Subsp(ind), max_size);
				
				Overlay_Common(Sym_Subsp(ind), info);
#ifdef ESOM
				match_err = 
				    check_spp_subspaces(Sym_Common(sym_ind), 
							Sym_Common(ind), 
							Sym_Subsp(sym_ind), 
							Sym_Subsp(ind));
				if ( match_err ) {
				    bad_common_subspaces(Sym_Name(ind), 
							 0, ind, sym_ind);
				}
#endif /* ESOM */
			    }
			} else {
			    /* ordinary duplicate symbol */
			    dup_sym_add(name,qname,ind,sym_ind);
			    symbol_resolve(sym_ind, ind);
			    /* allow "chmod +x" a.out to overlay storage */
			}
#ifdef TSD /* TSD */
		      } /* else !TLS */
#endif /* TSD */
		    }
		
	    
		    /* 
		     ** remove all storage requests and data unsats 
		     ** corresponding to new data symbol and remap them 
		     */
		    max_size = 0;
		    unsat_resolve(name,
				  mq,
				  qname,
				  hashval,
				  ind,
				  ST_DATA, 
				  &max_size);
#ifdef TSD /* TSD */
		    if (max_size && !Sym_TLS(ind) && sym->is_common) {
#else
		    if (max_size && sym->is_common) {
#endif /* TSD */
		        /*
		        ** adjust length of "common" subspace
			** to max(max storage req, prev len) 
			*/
			len = get_common_length(Sym_Subsp(ind));
			/* if len == 0 then Univ sym came from basefile */ 
			if (max_size > len && len > 0) {
			    char *  dup_sym_file;
			    char *  dup_sym_file2;

			    extend_common(Sym_Subsp(ind),max_size);

			    dup_sym_file = get_symbol_filename(ind);
			    if (!dup_sym_file) {
			       dup_sym_file = "";
			    }
			    dup_sym_file2 = get_symbol_filename(sym_ind);
			    if (!dup_sym_file2) {
			       dup_sym_file2 = "";
			    }
			    warning(COMMON_BLOCKS_DIF_LEN, 
				    name , 
				    dup_sym_file, 
				    dup_sym_file2, 
				    0);
  			}
		    }
		    break; /* case ST_DATA */
	        case ST_CODE:
                    if (sym->hidden) {
                        /* 
			** there won't be any corresponding ENTRY stub this 
                        ** can only happen with the FRU relink 
			*/
                        sym->symbol_type = ST_ENTRY;
                    }

                    if (!secondary_sym) {
		        if (!comdat_process(name, mq, qname, hashval, 
					sym_ind, ST_CODE)) {
			    return;
                        }
                        goto NORMAL_CODE;
                    }
	        case ST_PRI_PROG:
	        case ST_SEC_PROG:
	        case ST_ENTRY:
	        case ST_MILLICODE:
		    /* 
		    ** run the comdat processing to see if we should keep
		    ** this symbol or not 
		    */

		    if (!comdat_process(name, mq, qname, hashval, 
					sym_ind, ST_CODE)) {
			return;
		    }

	     	    if (do_fdp_position || do_fdp_measure) {
 			FDP_add(name,mq,(qname == NULL) ? cur_name : qname,
				hashval,sym_ind,ST_ENTRY);
                    }
                   NORMAL_CODE:
                    if (base_file_name != cur_file_name || !relinkable) {
                        /* DON'T DO IF FRU RELINK */
                        Subsp_Misc(misc->subsp).entry_sym = sym_ind;
		        if (entry_hashval == hashval &&
		    			    strcmp(name, entry_name) == 0) {
		    	    entry_symbol_index = sym_ind;
		    	    sym->symbol_type = ST_PRI_PROG;
		        }
                    }

		    /* 
		     * 
		     * If the routine only has integer arguments, then
		     * no relocation should be implied, even if the 
		     * pragma wasn't given. This will allow the removal
		     * of export stubs for all long return integer routines,
		     * which is the large majority in +DA2.0N
		     *
		     */

		    if (!(sym->arg_reloc & 0x2aa)) {
		       sym->no_relocation = TRUE;
		    }

                    if (secondary_sym) {
		        ind = secondary_add(name,
					    mq,
					    qname,
					    hashval,
					    sym_ind,
					    ST_CODE);
                       /* ignore duplicate secondary def symbols */
                       return;
                    }

		    ind = univ_add(name,
				   mq,
				   qname,
				   hashval,
				   sym_ind,
				   ST_CODE);

		    if (ind != sym_ind) {
                        if (base_file_name == cur_file_name && relinkable) {
                            /* FRU RELINK */
                            /* BASE FILE */
                            /* 
			    ** change the existing CODE symbol to ENTRY 
                            ** change the existing ENTRY symbol to STUB 
                            ** change the info field back to original 
                            ** sym index 
			    **
                            ** now, we could have gotten the symbols in 
                            ** either order.  it is MUCH easier if the  
                            ** CODE is first, but we take what we get!  
			    */

                            if (sym->symbol_type == ST_CODE) {
                                /* 
				** got the ENTRY first.  Switch the univ list
                                ** to refer to the CODE one
				*/
                                univ_switch(ind, sym_ind, hashval);
                                /* switch the values of ind and sym_ind */
                                ind ^= sym_ind;     /* OLD XOR TRICK */
                                sym_ind ^= ind;
                                ind ^= sym_ind;
                                /* reassign sym & misc */
                                sym = &Sym_Dict(sym_ind);
                                misc = &Sym_Misc(sym_ind);
                            }

                            Sym_Dict(ind).symbol_type = sym->symbol_type;
                            switch (sym->symbol_type) {
                                case ST_PRI_PROG:
                                    sym->symbol_type = ST_STUB_PRI_PROG;
                            	    entry_symbol_index = sym_ind;
                                    break;
                                case ST_SEC_PROG:
                                    sym->symbol_type = ST_STUB_SEC_PROG;
                                    break;
                                case ST_ENTRY:
                                    sym->symbol_type = ST_STUB_ENTRY;
                                    break;
                                default:
                                    internal_error(UNEXPECTED_FRU_SYMBOL, 0);
                            }

                            sym->symbol_info = ind;
                            misc->subsp = Sym_Subsp(ind);
                            /* 
			    ** make the stub's symbol value be an offset 
                            ** within the subspace                       
			    */
                            sym->symbol_value -=
                                Subsp_Dict(misc->subsp).subspace_start;
                            /* associate this stub with the symbol */
                            Sym_Related_Stub(ind) = sym_ind;
                            if (verbose & V_BIGDEBUG) { 
                                printf(ld_gets(1, 
				 	       1213, 
					       "switched code and entry for"
					       " %s\n"),
				        name);
                                printf(ld_gets(1, 
				 	       1214, 
					       "ind: %d sym_ind: %d\n"),
				       ind,
				       sym_ind);
                                printf(ld_gets(1, 
					       1215, 
					       "priv level is %d\n"),
                                       sym->symbol_value & 03);
 	                    }
                            break;
                        } else if (base_file_name != NULL && relinkable) {
                            /* FRU RELINK */
			    /*
                            ** subsequent .o files remap original symbol to
			    ** new one
			    */
                            if (verbose & V_DEBUG) {
                                printf(ld_gets(1, 
				               1216, 
				       "remap original ind %d to new ind %d"
					       " for %s\n"),
			               ind,
				       sym_ind,name);  
                                printf(ld_gets(1, 
				 	       1217, 
					       "type: %d priv level: %d\n"),
                                       sym->symbol_type,
				       sym->symbol_value & 03);
		            } 
                            priv_level = sym->symbol_value & 03;
                            fru_type = sym->symbol_type;
                            univ_switch(ind, sym_ind, hashval);

                            /* 
			    ** check for possible promotion stub problem.
			    ** If priv level is not 3 (lowest), don't nullify
                            ** the symbol now but do the symbol remap.  We
			    ** will nullify the symbols in fru_list in 
			    ** stubs.c.  
			    */
                            if (base_file_name != cur_file_name && 
                                relinkable && priv_level != 3 &&
                                fru_type == ST_ENTRY) 
                              fru_promote = TRUE; /* flag symbol */

			    /* 
			    ** DON'T Resolve symbol, because we need to
			    ** Keep necessary stuff around.  However,
			    ** NULL IT OUT! 
			    */
			    if (!fru_promote)
                                Sym_Type(ind)=ST_NULL;
                            /* copy the associated export stub over */
                            Sym_Related_Stub(sym_ind) = Sym_Related_Stub(ind);
                            /* if the old one was hidden, the new one is too */
                            sym->hidden = Sym_Dict(ind).hidden;
			    /* Should I copy over the back_ptr also? */
                            add_relink_list(ind,sym_ind);
                            if (fru_promote) {
                              add_fru_list(ind); /* add to suspect list */
                              fru_promote = FALSE; /* reset */
                            }
                            break;
                        } else if (base_file_name != NULL && !relinkable &&
				 Sym_Subsp(ind) == Sym_Subsp(sym_ind)  &&
				 dynamic_load_subsp_count == 0         &&
				 Sym_Dict(ind).symbol_type == ST_CODE) { 
			    /* 
			    ** if -A link, and our basefile is the result
			    ** of a previous -A link, then there will 
			    ** be stubs that will cause dup symbol errors. 
			    ** When we did the -A link that created the 
			    ** basefile the following occurred:
			    ** 1) the ENTRY, PRI_PROG, or SEC_PROG sym
			    **	  was read in and a stub was immediately 
			    **	  generated.
			    ** 2) on output, the "ENTRY" symbol was converted
			    **	  to ST_CODE and the stub was changed to
			    **	  an "ENTRY" symbol. 
			    ** So we know the stub will immediately follow
			    ** the ST_CODE symbol and we remove that stub
			    ** here. 
			    */
			    Sym_Dict(ind).symbol_type = sym->symbol_type;
			    sym->symbol_type = ST_NULL;
			} else if (Sym_Subsp(ind) < dynamic_load_subsp_count) {
                            /* 
			    ** if previous symbol is from the basefile of
                            ** -A link overwrite symbol from basefile 
			    */
                            symbol_resolve(ind, sym_ind);
			} else if (sym->dup_common) {

			    int ind_subsp;

			    /* C++ duplicate inlines: ignore all but the
			    ** first one.
			    */

			    ind_subsp = Sym_Subsp (ind);
                            /*
                            ** changed from error to warning
                            ** only display warning if -v in effect
                            */
			    if ((verbose & V_WHY) && (   (   get_common_length(info) 
				    != get_common_length (Sym_Subsp (ind)))
				|| (   Subsp_Dict(info).fixup_request_quantity
				    != Subsp_Dict(ind_subsp)
					  .fixup_request_quantity))) {

			       char *  dup_sym_file;
			       char *  dup_sym_file2;

			       dup_sym_file = get_symbol_filename(ind);
			       if (!dup_sym_file) {
				  dup_sym_file = "";
			       }
			       dup_sym_file2 = get_symbol_filename(sym_ind);
			       if (!dup_sym_file2) {
				  dup_sym_file2 = "";
			       }
			       warning(COMMON_BLOCKS_DIF_LEN,
				       name,
				       dup_sym_file, 
				       dup_sym_file2, 
				       0);
			    }
			    delete_subsp(info);
			    symbol_resolve (sym_ind, ind);
                        } else {
    			    dup_sym_add(name,qname,ind,sym_ind);
                        }
                    }
                    if (base_file_name == cur_file_name && relinkable)
                        /* FRU RELINK SYMBOL */
                        break;

		    unsat_resolve(name,
				  mq,
				  qname,
				  hashval,
				  ind,
				  ST_CODE,
				  NULL);

                    /* 
		    ** if dynamically loading ( -A or MPE ) then create export 
		    ** stubs for all entry symbols in the dynamic file.  HPUX
		    ** shared libraries do this in "shlib_build_tables".
                    */
		    if ((alloc_stubs_xl ||
                         (base_file_name != NULL &&
                          base_file_name != cur_file_name)) &&
			!sym->hidden &&
			((sym->symbol_type == ST_ENTRY && !pri_prog_only) ||
			 sym->symbol_type == ST_PRI_PROG ||
			 sym->symbol_type == ST_SEC_PROG)) {
			/* make external export stub for MPE XL */
                        if (verbose & V_STUBS)
                            printf(ld_gets(1, 1218, "Export stub to %s\n"), 
				   sym->NAME_PT);
			add_export_stub(sym_ind);
                    }
		    break;
	        case ST_ABSOLUTE:
	        case ST_MILLI_EXT:
		    ind = univ_add(name,
				   mq,
				   qname,
				   hashval,
				   sym_ind,
				   ST_ABSOLUTE);
		    if (ind != sym_ind)
			dup_sym_add(name,qname,ind,sym_ind);
		    unsat_resolve(name,mq,qname,hashval,ind,ST_DATA,NULL);
		    unsat_resolve(name,mq,qname,hashval,ind,ST_CODE,NULL);
		    unsat_resolve(name,mq,qname,hashval,ind,ST_ABSOLUTE,NULL);
		    break;
	        case ST_NULL: /* should prob print out message here */
		case ST_MODULE:
		    break;

	        case ST_COMDAT:
		    if (comdat_st_comdat(name, mq, qname, hashval, sym_ind)) {
			univ_add(name, mq, qname, hashval, sym_ind, ST_COMDAT);
		    } else {
			return;
		    }
		    break;

	        default:
		    external_error_sn(BAD_SYM_TYP_SS_UNIV, 
				      cur_name,
				      sym->symbol_type);
		    break;
 	    }
	    break; /* end case SS_UNIVERSAL */
        case SS_LOCAL:
	    switch(sym->symbol_type) {
#ifdef LOCALHASH
	        case ST_ENTRY:
	     	    if (do_fdp_position || do_fdp_measure) {
 			FDP_add(name,mq,(qname == NULL) ? cur_name : qname,
				hashval,sym_ind,ST_ENTRY);
                    }
                    Subsp_Misc(misc->subsp).entry_sym = sym_ind;
                    /* fall through into CODE processing */
	        case ST_CODE:
		    ind = local_add(name, 
				    mq, 
				    qname, 
				    hashval, 
				    sym_ind, 
				    ST_CODE);
		    break;
	        case ST_DATA:
#ifdef TSD /* TSD */
		    if (Subsp_Dict(sym->symbol_info).is_tspecific) {
		       Sym_TLS(sym_ind) = TRUE;
		       /* 
		       ** here.  1) we need to adjust symbol_value for a -r
		       ** link because code gen starts $TBSS$ at 40000000
		       ** instead of 0.  2) a -r linked .o file subsequently
		       ** linked normally had bad tls offsets.  Need to
		       ** special case this because tls_addr for a -r'd
		       ** file is for all $TBSS$ in the file, not just one
		       ** subspace.  We overload code_only to denote this
		       ** subspace is from a -r'd file.
                       */
		       if (!relocatable && 
			   Subsp_Dict(sym->symbol_info).code_only) {
			  /* special case first entry in $TBSS$ */
			  if (Sym_Value(sym_ind) == 0) {
			     Sym_Value(sym_ind) = previous_tls_addr;
			     if (previous_tls_addr == 0) {
			        previous_tls_addr++;
			     }
			  } else {
                             Sym_Value(sym_ind) = prev_tls + 
			                          Sym_Value(sym_ind);
			  }
		       } else if (relocatable && 
				  Sym_Value(sym_ind) != 0 && 
				  Subsp_Dict(sym->symbol_info).code_only) {
			 /* -r of a -r'd file */
			 Sym_Value(sym_ind) = tls_addr - Sym_Value(sym_ind);
                       } else if (Sym_Value(sym_ind) != 0) {
                          Sym_Value(sym_ind) = (Sym_Value(sym_ind) - 
		               Subsp_Dict(sym->symbol_info).subspace_start) +
			       tls_addr;
			  if (previous_tls_addr == 0) {
			     previous_tls_addr++;
			  }
		       }

#ifdef DEBUG /* DEBUG */
		       if (verbose & V_TSD) {
	                  printf("local TLS %s at %d off %d\n", name, sym_ind,
		                 Sym_Value(sym_ind));
		       }
#endif /* DEBUG */
		    }
#endif /* TSD */
		    ind = local_add(name, 
				    mq, 
				    qname, 
				    hashval, 
				    sym_ind, 
				    ST_DATA);
		    break;
#endif /* LOCALHASH */
                case ST_PLABEL:
                    /* must be FRU relink  -- if relinkable== TRUE*/
                    if (relinkable)
                        set_max_xrt(sym->symbol_info);
                    /* fall through to ST_STUB */
                case ST_STUB:
		    if (relinkable) {
                        /* must be FRU relink */
                        /* assign misc->subsp & recompute stub offset */
                        misc->subsp = find_symbol_subspace(sym->symbol_value);
                        sym->symbol_value -=
                            Subsp_Dict(misc->subsp).subspace_start;
                    }
                    break;
	        default:
		    break;
	    }
	    break;
        case SS_EXTERNAL:
            /* must be FRU relink */
            set_max_xrt(sym->symbol_info);
            misc->subsp = find_symbol_subspace(sym->symbol_value);
            sym->symbol_value -=
                Subsp_Dict(misc->subsp).subspace_start;
            break;
    }
} /* end symbol_add */

/*************************************************************
** FUNCTION:	saved_export_add
**
** DESCRIPTION: We need to remember that a given name/type pair is exported
**		by some shared library.  shlib_exports_hash_table is
**		a hash table of such items.  If the name/type pair is already
**		in the table, we don't add it again.
**
** MOTIVATION:  At the end of the link we don't want to report as an
**		unsatisfied symbol, any symbol which is exported by
**		any shared library which we have searched.
**
**
*************************************************************/

void saved_export_add (const char *name,
		       unsigned char type,
		       int size,
#ifdef TSD /* TSD */
		       unsigned int is_TLS,
#endif /* TSD */
		       char *filename)
{
    int				hash_index;
    struct shlib_export_item	*this_export;
    struct shlib_export_item	*new_export;
    int				str_size;
    char*			block_p;

    /* Look for name/type in the table.  If not found, add it. */

    hash_index = hash_string(name) % SHLIB_EXPORT_HASH_SIZE;
    this_export = shlib_exports_hash_table[hash_index];
    
    while (this_export != NULL) {
	if (this_export->type == type &&
	    strcmp(this_export->name, name) == 0) {
		/* Remember the largest size found */
	    if (this_export->size < size)
		this_export->size = size;
	    return;  /* already in hash table, done. */
	}
	this_export = this_export->next;
    }

    str_size = round(strlen(name) + 1, sizeof(void*));

   if (shlib_export_seg_free_bytes < (sizeof(struct shlib_export_item) + str_size)) {
      cur_shlib_export_seg++;

      if (cur_shlib_export_seg >= shlib_export_seg_max) {
	 shlib_export_seg_max += SHLIB_EXPORT_SEG_MAX;
         shlib_export_seg = (char**) erealloc((char *) shlib_export_seg,
				              sizeof(void*) * shlib_export_seg_max);
      }

      shlib_export_seg[cur_shlib_export_seg] = emalloc(SHLIB_EXPORT_SEG_SIZE);
      shlib_export_seg_free_bytes = SHLIB_EXPORT_SEG_SIZE;
   }

   block_p = shlib_export_seg[cur_shlib_export_seg]
	     + SHLIB_EXPORT_SEG_SIZE - shlib_export_seg_free_bytes;
   shlib_export_seg_free_bytes -= (sizeof(struct shlib_export_item) + str_size);

    /* No match found, add a new item to the hash table. */
    new_export = (struct shlib_export_item *) block_p;

    new_export->type = type;
    new_export->name = block_p + sizeof(struct shlib_export_item);
    new_export->size = size;
    new_export->filename = filename;
    strcpy(new_export->name, name);
#ifdef TSD /* TSD */
    new_export->is_tp_relative = is_TLS;
#endif /* TSD */
    new_export->next = shlib_exports_hash_table[hash_index];
    shlib_exports_hash_table[hash_index] = new_export;
} /* end saved_export_add */

/*************************************************************
** FUNCTION:	saved_export_match
**
** DESCRIPTION: Return TRUE if the symbol is satisfied by a shared
**		library export as indicated by the information in
**		shlib_exports_hash_table.
**
** MOTIVATION:	In unsat_print_list and cleanup_shlib_unsat_tbl, we want
**		to ignore unsatisfied symbols that are satisfied by some
**		shared library export.
**
**
*************************************************************/

Boolean saved_export_match (struct symnode *symbol,
			    int *type,
			    int *size,
#ifdef TSD /* TSD */
			    unsigned int *is_TLS,
#endif /* TSD */
			    char **filename)
{

    int				hash_index;
    struct shlib_export_item	*this_export;

    hash_index = hash_string(symbol->name) % SHLIB_EXPORT_HASH_SIZE;
    this_export = shlib_exports_hash_table[hash_index];
    
    while (this_export != NULL) {
	if (strcmp(this_export->name, symbol->name) == 0) {
            if (symbol_type_match(symbol->type, this_export->type)) {
		*type = this_export->type;
		*size = this_export->size;
		*filename = this_export->filename;
#ifdef TSD /* TSD */
	        *is_TLS = this_export->is_tp_relative;
#endif /* TSD */
		return(TRUE);  /* export found for unsat */
	    }
	}
	this_export = this_export->next;
    }
    return(FALSE);  /* no export found for unsat */
} /* end saved_export_match */

static struct relink_list *relink_list = NULL;
init_relink_list() {
    struct relink_list *this_one, *next_one;

    fru_list = NULL;  /* global init of fru list */

    for (this_one = relink_list; this_one != NULL; this_one = next_one) {
        next_one = this_one->next;
        efree(this_one);
    }
    relink_list = NULL;
} /* init_relink_list */

/* 
** this routine keeps a list of symbols that will be nullified in stubs.c
** after stubs have been built.  We keep the symbol indices in a linked list.
*/

add_fru_list(ind)
int ind;
{
    struct fru_list *fru1;

    fru1 = (struct fru_list *) emalloc (sizeof (struct fru_list));
    fru1->index = ind;
    fru1->next = fru_list;
    fru_list = fru1; 

    if (verbose & V_STUBS)
      printf(ld_gets(1, 1219, "symbol index added to fru_list: %d\n"),ind);
} /* end add_fru_list */

add_relink_list(sym_ind,new_ind)
int sym_ind,new_ind;
{
    struct relink_list *this_one;

    if (verbose & V_STUBS)
        printf(ld_gets(1, 1220, "Relink: %s (%d)\n"), 
	       Sym_Dict(sym_ind).NAME_PT, 
	       sym_ind);

    if (relink_list == NULL || relink_list->num_used == RELINK_BLK) {
        this_one = (struct relink_list *) emalloc 
	  		(sizeof (struct relink_list));
        this_one->next = relink_list;
        this_one->num_used = 0;
        relink_list = this_one;
    } else
        this_one = relink_list;

    this_one->new_indices[this_one->num_used] = new_ind;
    this_one->sym_indices[this_one->num_used++] = sym_ind;
} /* add_relink_list */

relink_list_sort_routine(i1, i2)
struct relink_indices *i1, *i2;
{
    int t1, t2;

    /* sort by ORIGINAL subspace order */
    t1 = Sym_Subsp(i1->old_sym);
    t2 = Sym_Subsp(i2->old_sym);
    if (t1 != t2)
        return (t1-t2);
    /* subspaces are the same, check ORIGINAL symbol values */
    t1 = Sym_Dict(i1->old_sym).symbol_value;
    t2 = Sym_Dict(i2->old_sym).symbol_value;
    return (t1-t2);
} /* end relink_list_sort_routine */

struct relink_indices *sort_relink_list() 
{
    int count;
    struct relink_list *this_one;
    int i;
    struct relink_indices *indices;

    count = 0;

    for (this_one = relink_list; this_one != NULL; this_one = this_one->next)
        count += this_one->num_used;

    indices = (struct relink_indices *) emalloc (sizeof (struct relink_indices)
						 * (count + 1));
    indices[count].old_sym = BAD_SYM;
    indices[count].new_sym = BAD_SYM;

    count = 0;
    for (this_one = relink_list; this_one != NULL; this_one = this_one->next)
        for (i = this_one->num_used; --i >= 0; ) {
            indices[count].old_sym = this_one->sym_indices[i];
            indices[count++].new_sym = this_one->new_indices[i];
	 }
    qsort(indices, 
	  count, 
	  sizeof(struct relink_indices), 
	  relink_list_sort_routine);

    return (indices);
} /* end sort_relink_list */

int set_max_xrt(sym_xrt) 
int sym_xrt;
{
    int xrt_index;

    xrt_index = sym_xrt/XRT_ENTRY_SIZE;
    if (next_xrt <= xrt_index)
        next_xrt = xrt_index+1;
} /* end set_max_xrt */

void check_trace_list (char *symbol_name,
		       int symbol_type,
		       int symbol_scope,
		       char *filename)
{
    char **list = trace_list;
    char *name, *t, *s;

    while (name = *list++) {
	if (strcmp(symbol_name, name) != 0) continue;
	printf(ld_gets(1, 1221, "%s: %s is "), filename, name);
	switch(symbol_type) {
	    case ST_NULL: t = "NULL"; break;
	    case ST_ABSOLUTE: t = "ABSOLUTE"; break;
	    case ST_DATA: t = "DATA"; break;
	    case ST_CODE: t = "CODE"; break;
	    case ST_PRI_PROG: t = "PRI_PROG"; break;
	    case ST_SEC_PROG: t = "SEC_PROG"; break;
	    case ST_ENTRY: t = "ENTRY"; break;
	    case ST_STORAGE: t = "STORAGE"; break;
	    case ST_STUB: t = "STUB"; break;
	    case ST_MODULE: t = "MODULE"; break;
	    case ST_SYM_EXT: t = "SYM_EXT"; break;
	    case ST_ARG_EXT: t = "ARG_EXT"; break;
	    case ST_MILLICODE: t = "MILLICODE"; break;
	    case ST_PLABEL: t = "PLABEL"; break;
	    case ST_OCT_DIS: t = "OCT_DIS"; break;
	    case ST_MILLI_EXT: t = "MILLI_EXT"; break;
#ifdef TSD /* TSD */
	    case ST_TSTORAGE: t = "TSTORAGE"; break;
#endif /* TSD */
	    default: t = "????"; break;
	}
	switch (symbol_scope) {
	    case SS_UNSAT: s = "UNSAT"; break;
	    case SS_EXTERNAL: s = "EXTERNAL"; break;
	    case SS_UNIVERSAL: s = "UNIVERSAL"; break;
	    case SS_LOCAL: s = "LOCAL"; break;
	    default: s = "????"; break;
	}
	printf("%s %s\n",t,s);
    }
} /* end check_trace_list */

/* universal symbol routines */

#if 0  /* not used - was for HP-UX shared library processing */

static void univ_delete(name,mq,qname,hashval,type)
char *name, *qname;
register int type;
Boolean mq;
register unsigned int hashval;
    {
    register struct symnode *n, *last;

    /* force optionally qualified unsats to behave like fully qualified,
       COBOL and Pascal seem to want that behavior (for unsats). See
       commented-out routine "resolve_qualified_unsats" or  for
       details.   */
    if (qname != NULL) {
        mq = TRUE;
	}

    n = univ_hash_table[hashval % UNIVHASHSIZE];
    last = NULL;
    while (n != NULL) {
	if (n->hashval==hashval && symnode_match(n,name,mq,qname,type)) {
	    if (last == NULL) {  /* if head of chain */
    		univ_hash_table[hashval % UNIVHASHSIZE] = n->next;
	    }
	    else {  /* not head of bucket chain */
    		last->next = n->next;
	    }
	    return;
	}
	last = n;
	n = n->next;
	}
    }
#endif /* 0 */

/*************************************************************
** FUNCTION:	univ_find
**
** DESCRIPTION: Return a pointer to the symbol which defines
**		the value of name.  Handles symbol qualification.
**
** NOTES:	If you modify univ_find, you might need to modify
**		map_secondary_to_primary which contains a modified clone of
**		this code.
*************************************************************/
int univ_find(name,mq,qname,hashval,type)
char *name, *qname;
register int type;
register Boolean mq;
register unsigned int hashval;
{
    register struct symnode *n;

    /* 
    ** force optionally qualified unsats to behave like fully qualified,
    ** COBOL and Pascal seem to want that behavior (for unsats). See
    ** commented-out routine "resolve_qualified_unsats" for
    ** details.   
    */
    if (qname != NULL) {
        mq = TRUE;
    }

    n = univ_hash_table[hashval % UNIVHASHSIZE];
    while (n != NULL) {
	if (n->hashval==hashval && symnode_match(n,name,mq,qname,type)) {
	    return(n->index);
	}
	n = n->next;
    }
    return (BAD_SYM);
} /* end univ_find */

int univ_add(name,mq,qname,hashval,index,type)
char *name, *qname;
Boolean mq;
register unsigned int hashval;
int index, type;
{
    unsigned int hashkey;
    Boolean newmq;
    register struct symnode *n;

    hashkey = hashval % UNIVHASHSIZE;
    n = univ_hash_table[hashkey];
    newmq = mq;

    /* We treat ST_COMDAT symbols specially -- in a relocatable link, we
     * can add as many duplicates as we would like. 
     */

    if ( !(relocatable && (type == ST_COMDAT)) ) {
	/* 
	 ** Look up name.  If found, return found symbol index. 
	 ** If not found, insert new symnode into table and return index. 
	 */
	while (n != NULL) {
	    if (n->hashval==hashval) {
		if (symnode_same(n, name, qname, type, index, TRUE) 
		    /* HP-UX shared library processing */
		    /* allow duplicate univs for shared libs */
		    && (!building_shlib || 
			(Subsp_Misc(Sym_Subsp(n->index)).shlib_version ==
			 Subsp_Misc(Sym_Subsp(index)).shlib_version))) {
		    
		    return(n->index);
		}
		
		/* 
		 ** Also look for name conflicts between unqualified and 
		 ** optionally-qualified definitions; set must_qualify bit 
		 ** for such symbols. 
		 */
		if (!mq && !n->mq && symnode_match(n, name, 0, NULL, type)) {
		    /* 
		     ** Pretend the candidate symbol (univ) is unqualified 
                     ** and see if it would match with current univ sym.  
                     ** If it does, we would have an ambiguious situation, 
		     ** so set "mq" (must-qualify) bit on both syms to force 
		     ** their references to be fully qualified. 
		     */
		    if (Sym_Qual_Name(n->index) != NULL)
		      n->mq = TRUE;
		    if (qname != NULL)
		      newmq = TRUE;
		}
	    }
	    n = n->next;
	} /* while */
    } /* if ( !(relocatable && (type == ST_COMDAT)) ) */

    n = get_node(name,newmq,qname,hashval,index,type,0);
    Sym_Back_Ptr(index) = n;
    n->next = univ_hash_table[hashkey];
    univ_hash_table[hashkey] = n;
    return(n->index);
} /* end univ_add */

int univ_switch(old_index, new_index, hashval)
register int old_index, new_index;
register unsigned int hashval;
{
    unsigned int hashkey;
    register struct symnode *n;

    hashkey = hashval % UNIVHASHSIZE;
    n = univ_hash_table[hashkey];

    while (n->index != old_index)
        n = n->next;

    n->index = new_index;
} /* end univ_switch */

/*
 * function:   univ_replace
 *
 * description: similar to univ_switch(), but fully replaces the entire node
 *              instead of just the index.
 *
 *              currently used as part of the COMDAT implementation.
 */

int univ_replace(int old_index,
		 char *name,
		 int mq,
		 char *qname,
		 unsigned int hashval,
		 int new_index,
		 int type)
{
    unsigned int hashkey;
    struct symnode *n;

    hashkey = hashval % UNIVHASHSIZE;
    n = univ_hash_table[hashkey];

    while (n->index != old_index)
      n = n->next;

    /* nuke the old contents and replace with the new */
    memset((char *)n, (char) 0, sizeof(struct symnode));

    n->index = new_index;
    n->name = name;
    n->mq = mq;
    n->type = type;
    n->hashval = hashval;
    n->len = 0;

    Sym_Back_Ptr(new_index) = n;

    return n->index;
}

#ifdef LOCALHASH

/* local symbol routines */

int local_find(name,mq,qname,hashval,type)
char *name, *qname;
register Boolean mq;
register int type;
register unsigned int hashval;
{
    register struct symnode *n;

    /* 
    ** force optionally qualified unsats to behave like fully qualified,
    ** COBOL and Pascal seem to want that behavior (for unsats). See
    ** commented-out routine "resolve_qualified_unsats" for
    ** details.  
    */
    if (qname != NULL) {
        mq = TRUE;
    }

    n = local_hash_table[hashval % LOCALHASHSIZE];
    while (n != NULL) {
	if (n->hashval==hashval && symnode_match(n,name,mq,qname,type))
	    return(n->index);
	n = n->next;
    }
    return (BAD_SYM);
} /* end local_find */

int local_add(name,mq,qname,hashval,index,type)
char *name, *qname;
Boolean mq;
register unsigned int hashval;
int index, type;
{
    unsigned int hashkey;
    Boolean newmq;
    register struct symnode *n, *m;

    hashkey = hashval % LOCALHASHSIZE;
    n = local_hash_table[hashkey];
    newmq = mq;

    /* 
    ** Look up name.  If found, return found symbol index.
    ** If not found, insert new symnode into table and return index 
    */
    while (n != NULL) {
	if (n->hashval==hashval) {
   	    if (symnode_same(n,name,qname,type,index,TRUE)) {
#ifdef TSD /* TSD */
                /* TLS locals are added as new nodes. */
                if (Sym_TLS(index)) {
                   break;
		}
#endif /* TSD */

                if (building_shlib) {
                    /* 
		    ** if we are building a shared lib we want all unique local
                    ** data symbols in the local hash tbl since we use it to
                    ** generate DLT entries. It is common to get multiple
                    ** local syms with the same name when reading ld -r output.
                    ** If the symbol is identical, it will be added to the same
                    ** list, else it will be added as another entry
                    ** 1) same value, diff subsp -poss if one subsp is 0 len
                    ** 2) diff value, same subsp -poss if subspaces merged 
		    */
                    if (Sym_Value(n->index) == Sym_Value(index) &&
                        Sym_Subsp(n->index) == Sym_Subsp(index) ) {
                        m = get_node(name,
				     newmq,
				     qname,
				     hashval,
				     index,
				     type,
				     0);
                        m->same = n->same;
                        n->same = m;
                        return(n->index);
                    }
                } else {
                    return(n->index);
                }
	    }

    	    /* 
	    ** Also look for name conflicts between unqualified and 
    	    ** optionally-qualified definitions; set must_qualify bit 
    	    ** for such symbols. 
	    */
	    if (!mq && !n->mq && symnode_match(n, name, 0, NULL, type)) {
		/* 
		** Pretend the candidate symbol (univ) is unqualified and see
		** if it would match with current univ sym.  If it does,
		** we would have an ambiguious situation, so set "mq"
		** (must-qualify) bit on both syms to force  their references
		** to be fully qualified. 
		*/
		if (Sym_Qual_Name(n->index) != NULL)
                    n->mq = TRUE;
		if (qname != NULL)
                    newmq = TRUE;
	    }
	}
	n = n->next;
    } /* while n != NULL */
    n = get_node(name,
		 newmq,
		 qname,
		 hashval,
		 index,
		 type,
		 0);
    Sym_Back_Ptr(index) = n;
    n->next = local_hash_table[hashkey];
    local_hash_table[hashkey] = n;
    return(n->index);
} /* end local_add */

void local_purge()
{
    int i;
    register struct symnode *n, *m;

    for (i = 0; i < LOCALHASHSIZE; i++) {
	for (n = local_hash_table[i]; n != NULL; ) {
	    m = n->next;

            /* HP-UX shared library processing */
	    if ((n->type == ST_DATA) &&
		building_shlib &&
		(Sym_Subsp(n->index) != BAD_SUBSP) 
		/*
		**  Removed optimization where local
		** symbols in a zero length subspace were removed from
		** shared library tables.
		*/
#if 0
		&& (Subspace_Length(Sym_Subsp(n->index)) != 0) 
#endif
		) {
	    	n->next = data_locals_list; /* link into list for shlib proc */
	    	data_locals_list = n;
		local_data_sym_count++;
	    } else
            	free_node(n);
            n = m;
	}
	local_hash_table[i] = NULL;
    }
} /* end local_purge */

#endif /* LOCALHASH */

/* 
** duplicate symbols 
** returns a pointer to the file name for the given symbol index 
*/
char *get_symbol_filename(sym_ind)
int sym_ind;
{
    char *file_name = NULL;

    if (sym_ind >= 0 && Sym_Subsp(sym_ind) >= 0)
      file_name = Subsp_Misc(Sym_Subsp(sym_ind)).file_name;

    return(file_name);
} /* end get_symbol_filename */

/*
 * returns the unique identifier of the symbol's SOM
 * used by CTTI
 */

int get_module_id(int sym_ind)
{
    if (sym_ind >= 0 && Sym_Subsp(sym_ind) >= 0) {
        return Subsp_Misc(Sym_Subsp(sym_ind)).module_id;
    } else {
        return BAD_MODULE_ID;
    }
}

void dup_sym_add(name,qname,first_sym_ind,second_sym_ind)
char *name, *qname;
int first_sym_ind, second_sym_ind;
{
    char buf[80];
    char *c;
    char *first_file, *second_file;

    if (qname != NULL) {
        sprintf(buf, "%.39s.%.39s", qname, name);
        c = buf;
    } else if (strcmp(name, "_start") == 0)
        c = "_start (OUTER BLOCK)";
    else
        c = name;

    if (first_sym_ind == BAD_SYM)
        /* 
	** BAD_SYM indicates that the first symbol is reserved and is   
        ** "defined" by the linker                      
	*/
        first_file = progname;
    else
        first_file = get_symbol_filename(first_sym_ind);

    second_file = get_symbol_filename(second_sym_ind);

    /* 
    ** Removed #ifdef PBO for find_unsat_only and
    ** resolve_sym_only since we can use these in non PBO environments.
    ** if isom_exist, we do not want to print the warnings twice. With the
    ** exception that if the user wants to stop after symbol resolution and
    ** isom exist, then we still print the warnings.
    ** Changed the names 
    */
    if (!isom_exist ||
        list_unsats_only ||
        trace_syms_only ||
        building_shlib)

        if (!first_file) 
	    warning(DUP_SYM, c, second_file, 0);
        else if (!second_file) 
	    warning(DUP_SYM, c, first_file, 0);
        else 
            warning(DUP_SYMS_FILES, c, first_file, second_file, 0);
    dup_symbols++;
} /* end dup_sym_add */

/* secondary definition symbol handling */
int sec_find(name,mq,qname,hashval,type)
char *name, *qname;
register Boolean mq;
register unsigned int hashval;
int type;
{
    register struct symnode *n;

    /* 
    ** force optionally qualified unsats to behave like fully qualified,
    ** COBOL and Pascal seem to want that behavior (for unsats). See
    ** commented-out routine "resolve_qualified_unsats" 
    */
    if (qname != NULL) {
        mq = TRUE;
    }

    n = sec_hash_table[hashval % SECHASHSIZE];
    while (n != NULL) {
	if (n->hashval==hashval && symnode_match(n,name,mq,qname,type)) 
	    return(n->index);
	n = n->next;
    }
    return (BAD_SYM);
} /* end sec_find */

int secondary_add(name,mq,qname,hashval,index,type)
char *name, *qname;
Boolean mq;
register unsigned int hashval;
int index, type;
{
    unsigned int hashkey;
    Boolean newmq;
    register struct symnode *n;

    hashkey = hashval % SECHASHSIZE;
    n = sec_hash_table[hashkey];
    newmq = mq;

    /* 
    ** Look up name.  If found, return found symbol index. 
    ** If not found, insert new symnode into table and return index. 
    */
    while (n != NULL) {
	if (n->hashval==hashval) {
    	    if (symnode_same(n, name, qname, type, index, TRUE)
                /* HP-UX shared library processing */
                /* allow duplicate sec defs for shared libs */
                && (!building_shlib ||
                    (Subsp_Misc(Sym_Subsp(n->index)).shlib_version ==
                     Subsp_Misc(Sym_Subsp(index)).shlib_version))) {

		return(n->index);
            }

    	    /* 
	    ** Also look for name conflicts between unqualified and 
    	    ** optionally-qualified definitions; set must_qualify bit 
    	    ** for such symbols. 
	    */
	    if (!mq && !n->mq && symnode_match(n, name, 0, NULL, type)) {
		/* 
		** Pretend the candidate symbol (univ) is unqualified and see
		** if it would match with current univ sym.  If it does,
		** we would have an ambiguious situation, so set "mq"
		** (must-qualify) bit on both syms to force their references
		** to be fully qualified. 
		*/
		if (Sym_Qual_Name(n->index) != NULL)
                    n->mq = TRUE;
		if (qname != NULL)
                    newmq = TRUE;
	    }
        }

	n = n->next;
    }
    n = get_node(name,newmq,qname,hashval,index,type,0);
    Sym_Back_Ptr(index) = n;
    n->next = sec_hash_table[hashkey];
    sec_hash_table[hashkey] = n;
    return(n->index);
} /* end secondary_add */

/* unsatisfied symbol handling */

void unsat_add (name,mq,qname,hashval,index,type,value, sdef)
char *name, *qname;
Boolean mq;
register unsigned int hashval;
int index, type, value, sdef;
{
    unsigned int hashkey = hashval % UNSATHASHSIZE;
    register struct symnode *n, *new;
    register struct symbol_dictionary_record *sym, *oldsym;
    int org_objfile_index;
    int x; 

    new = get_node (name, mq, qname, hashval, index, type, value);
    new->secondary_def = sdef;
    n = unsat_hash_table[hashkey];
    while (n != NULL) {
	if (n->hashval == hashval && symnode_same (n, 
						   name, 
						   qname, 
						   type, 
						   index, 
						   TRUE)) {

	    /* 
	    ** found; try to remap one to the other 
	    ** NO_DATA_COPY 
            **
	    **   Now remap unsat symbols in an a.out built w/o
	    ** data copying.  Carefully guarded to not disturb FRU 
	    **   Only remap Data/Stor symbols. 
            **      Remap if doing shared global data 
            */
	    if ((relocatable || (building_incomp_exec && !do_data_copy && 
#ifdef TSD /* TSD */
				 (type == ST_DATA || type == ST_STORAGE ||
				  type == ST_TSTORAGE))) &&
#else
			         (type == ST_DATA || type == ST_STORAGE))) &&
#endif /* TSD */
		index != BAD_SYM && n->index != BAD_SYM) {
		sym = &Sym_Dict(index);
		oldsym = &Sym_Dict(n->index);

                /*
		** can't remap if new unsat has type checking info 
		** Can't remap if new unsat is from a shlib, since we need
		** to check the subsp field down stream in has_shlib_refs()! 
                ** 
                **  Don't remap if either old or new has 
                ** check_level > 0.  We had a bug where we kept old extension 
                ** records in the output file.  We need to nuke these later on.
                **
                */

                if (sym->check_level == 0 && oldsym->check_level == 0 && 
                    (Sym_Subsp (index) != BAD_SUBSP)) {

		    /* doom support */
		    org_objfile_index = Sym_Misc(index).objfile_index;

		    Remap_Sym_Records (index, n->index);
#ifdef TSD /* TSD */
		    if (type == ST_TSTORAGE) {
                       n->type = ST_TSTORAGE;
                       if (value > n->len) {
                          n->len = value;
			  if (index != BAD_SYM && n->index != BAD_SYM)

			     /* doom support */
			     Sym_Misc(n->index).objfile_index = org_objfile_index;
		        }
		       oldsym->symbol_type = ST_TSTORAGE;
		       oldsym->symbol_value = n->len;
		    } else 
#endif /* TSD */
		    if (type == ST_STORAGE) {
#ifdef ESOM
			int match_err;

			if ( index != -1 && n->index != -1 ) {
			    match_err = check_spp_subspaces(
					Sym_Common(index),
					Sym_Common(n->index),
					Sym_Subsp(index), Sym_Subsp(n->index));
			    if ( match_err ) {
			        bad_common_subspaces(Sym_Name(index),
						     0, index, n->index);
			    }
			}
#endif /* ESOM */
			/* check for larger storage request */
			n->type = ST_STORAGE;
			if (value > n->len) {
			    n->len = value;
			    if (index != BAD_SYM && n->index != BAD_SYM)

			       /* doom support */
			       Sym_Misc(n->index).objfile_index = org_objfile_index;
			}
			oldsym->symbol_type = ST_STORAGE;
			oldsym->symbol_value = n->len;
		    }
		}
   	    } else if (n->type == ST_NULL && n->index == BAD_SYM) {
		    /* overwrite user unsats */
		    new->next = n->next;
		    new->same = n->same;
		    *n = *new;
                    if (index != -1) 
                        Sym_Back_Ptr(index) = n;
		    free_node (new);
		    return;
	    }
#ifdef ESOM
	    if (type == ST_STORAGE) {
		int match_err;
		
		if ( index != -1 && n->index != -1 ) {
		    match_err = check_spp_subspaces(Sym_Common(index),
						    Sym_Common(n->index),
						    Sym_Subsp(index), 
						    Sym_Subsp(n->index));
		    if ( match_err ) {
			bad_common_subspaces(Sym_Name(index),
					     0, index, n->index);
		    }
		}
	    }
#endif /* ESOM */
	    /* add new symbol node to same list */
	    new->same = n->same;
            n->same = new;
	    return;
	} /* found a match */

	n = n->next;
    } /* while */

    /* not found; add to front of hashlist */
    new->next = unsat_hash_table[hashkey];
    unsat_hash_table[hashkey] = new;
    if (index != BAD_SYM) {
	/* "sym_initialize" uses -1 for symbols pre-undefined by user */
        Sym_Back_Ptr(index) = new;
        n = new->next; /* n = previous unsat_hash_table[hashkey] */
        if(n != NULL && n->index != BAD_SYM && !Sym_no_relocation(n->index)) {
	   /* OGL support,                       */
           /* If front of the list DOESNOT has no_relocation bit set then   */
           /* reset the has_no_relocation of this one even it's set.        */
           Sym_no_relocation(new->index) = 0;
        }
    }
} /* end unsat_add */

void shlib_unsat_add(name,hashval,index,type,len,is_exported)
char *name;
register unsigned int hashval;
int index, type, len;
int is_exported;  /* set if this symbol is an import that is also exported */ 
/* 
** enter "soft" unsat for symbol imported by a shared library read while
** building an incomplete a.out, so objects from subsequent archive files 
** can be brought in to resolve them. 
*/
{
    unsigned int hashkey = hashval % UNSATHASHSIZE;
    register struct symnode *n, *new;

    assert( building_incomp_exec );

    assert(name != NULL);

    new = get_node(name,FALSE,NULL,hashval,index,type,len);
    new->secondary_def = FALSE;
    new->exported_by_shlib = is_exported;

#ifdef TSD /* TSD */
    if (type == ST_STORAGE || type == ST_TSTORAGE)
#else
    if (type == ST_STORAGE)
#endif /* TSD */
        new->shlib_storage = TRUE;  
    /* mark to separate from DATA UNSATS promoted in "lib_match" */

    n = shlib_unsat_hash_table[hashkey];
    while (n != NULL) {
	if (n->hashval == hashval && symnode_same(n,
						  name,
						  NULL,
						  type,
						  index,
						  TRUE)) {

	    /* found; add new symbol node to "same" list */
	    new->same = n->same;
            n->same = new;
	    return;
	}

	n = n->next;
    }
    /* not found; add to front of hashlist */
    new->next = shlib_unsat_hash_table[hashkey];
    shlib_unsat_hash_table[hashkey] = new;
    /* use n as tmp symnode. */
    Sym_Back_Ptr(index) = new;
    n = new->next; /* n = previous unsat_hash_table[hashkey] */
    if( n != NULL && n->index != BAD_SYM && !Sym_no_relocation(n->index)) {
       /* OGL support,                                     */
       /* If front of the list DOESNOT has no_relocation bit set then   */
       /* reset the has_no_relocation of this one even it's set.        */
       Sym_no_relocation(new->index) = 0;
    }
} /* end shlib_unsat_add */

void cleanup_shlib_unsat_tbl()
{
    /* 
    ** null out all unresolved symbols in "soft" unsat table so they won't
    ** be output. 
    */

    register int i;  /* loop counter */
    register struct symnode *n, *m, *nsame;  /* working ptrs in table search */

    char buf[80];
    char *c;
    int unsats = 0;
    int univ_index;
    int tmp_sym_type;
    int size;
#ifdef TSD /* TSD */
    unsigned int tls;
#endif /* TSD */
    FILE *fp;       /* For -Fu use */

    for (i = 0; i < UNSATHASHSIZE; i++) {
	for (n = shlib_unsat_hash_table[i]; n != NULL; n = m ) {
	    m = n->next;

	    univ_index = univ_find (n->name, 
				    n->mq, 
				    Sym_Qual_Name(n->index),
                                    n->hashval,
				    n->type);

	    if (building_incomp_exec && univ_index != BAD_SYM ) {
		/* place unsat on minimum export list */
		if (Sym_ShlHideExp(univ_index) && n->type == ST_DATA) {
 		    /* 
		    ** if a data symbol is needed by a shlib and it
                    ** is not exported from the a.out, the a.out
                    ** will use one copy and the shared libs will use
                    ** another. 
		    ** This may be intended but a warning is given. 
		    */
                    warning (SHOULD_EXPORT_SYM, n->name, 0);
		}
		if (Sym_Dict(n->index).symbol_scope == SS_UNSAT)
 		    Sym_Dict(n->index).symbol_type = ST_NULL;
                *n = *Sym_Back_Ptr (univ_index);
 		if (!search_alldefs && !Sym_ShlHideExp(univ_index)) {
                    n->next = minimum_export_list;
                    minimum_export_list = n;
		}
		continue;
  	    }

	    if (!n->shlib_storage && 
                 (n->type == ST_STORAGE ||
#ifdef TSD /* TSD */
                  n->type == ST_TSTORAGE ||
#endif /* TSD */
		  (n->type == ST_DATA &&
		   unsat_find (n->name, 
			       Sym_Qual_Name(n->index), 
                               n->hashval, 
			       ST_DATA) != BAD_SYM))) {

      		unsat_add (n->name, 
			   n->mq, 
			   Sym_Qual_Name(n->index), 
                           n->hashval, 
			   n->index, 
			   n->type, 
			   n->len, 
                           n->secondary_def);
			  /* 
			  ** build storage requests for .o's not brought in,
			  ** but seen in an archive library to upgrade ST_UNSAT
			  ** to ST_STORAGE.  Checking the "shlib_unsat" field
			  ** keeps us from exporting all stor_reqs from shlib 
			  ** import lists, since they are marked in 
			  ** "shlib_unsat_add" and DATA UNSATS (which can be 
			  ** upgraded by "lib_match") aren't.  Checking the
			  ** unsat hash table catches storage requests that
			  ** need to be exported to satisfy unsats in the 
			  ** shlib. 
			  */
            } else if (building_incomp_exec 
		       && !n->exported_by_shlib
#ifdef TSD /* TSD */
		       && !saved_export_match(n, &tmp_sym_type, &size, &tls, &c)
#else
		       && !saved_export_match(n, &tmp_sym_type, &size, &c)
#endif /* TSD */
		       && (list_unsats_only || (verbose & V_SOFT_UNSATS))) {
 	        if (Sym_Qual_Name(n->index) != NULL) {
                    sprintf (buf, "%.39s.%.39s", Sym_Qual_Name(n->index), 
                             n->name);
                    c = buf;
                } else
                    c = n->name;

  		if (n->type != ST_STUB && !unsats) {
                    if (!allow_shlib_unsats)
                       bad_obj = TRUE;
                    unsats++;
		    if (verbose & V_SOFT_UNSATS)
                        warning (UNSATS_SHLIB , 0);
                }
                
                if (n->type == ST_CODE) { 
		    if (verbose & V_SOFT_UNSATS)
                        warning_continue (UNSAT_CODE, c, 0);
			/* 
			**  Print soft text unsats.
			** Now print soft data
			** unsats too, to all necessary files.  Also revamped
			** the implementation of this stuff.
			*/
                    if (list_unsats_only) {
                        if (fp = unsat_files [FU_TEXT_UNSAT]) 
                            fprintf (fp, FORMAT_STRING_UNDEF, c);

                        if (fp = unsat_files [FU_ALL_UNSAT]) 
                            fprintf (fp, FORMAT_STRING_TEXT, c);
		    }
                } else if (n->type == ST_DATA) {
		    if (verbose & V_SOFT_UNSATS)
                        warning_continue (UNSAT_DATA, c, 0);

                    if (list_unsats_only) {
                        if (fp = unsat_files [FU_DATA_UNSAT]) 
                            fprintf (fp, FORMAT_STRING_UNDEF, c);

                        if (fp = unsat_files [FU_ALL_UNSAT]) 
                            fprintf (fp, FORMAT_STRING_DATA, c);
		    }
		} else if (n->type != ST_STUB && (verbose & V_SOFT_UNSATS))
                    warning_continue (UNSAT_OTHER, c, 0);
	    }

	    do {  /* run down "same" list ,too */
	    	nsame = n->same;
		Sym_Dict(n->index).symbol_type = ST_NULL;
            	free_node(n);
	    	n = nsame;
	    } while(n != NULL);

	}  /* end loop down hash chain */

	shlib_unsat_hash_table[i] = NULL;  /* zero dangling ptrs */

    }  /* end loop over hash buckets */
}  /* end "cleanup_shlib_unsat_tbl" */

int shlib_unsat_find(name,hashval,type)
char *name;
register unsigned int hashval;
register int type;
{
    unsigned int hashkey;
    register struct symnode *n;
    register int j;

    hashkey = hashval % UNSATHASHSIZE;

    n = shlib_unsat_hash_table[hashkey];
    while (n != NULL) {
	if (n->hashval == hashval && symnode_same(n,name,NULL,type,0,FALSE))
	    return(n->index);
	n = n->next;
    }
    return(BAD_SYM);
} /* end shlib_unsat_find */

int unsat_find(name,qname,hashval,type)
char *name, *qname;
register unsigned int hashval;
register int type;
{
    unsigned int hashkey;
    register struct symnode *n;
    register int j;

    hashkey = hashval % UNSATHASHSIZE;

    n = unsat_hash_table[hashkey];
    while (n != NULL) {
	if (n->hashval == hashval && symnode_same(n,name,qname,type,0,FALSE))
	    return(n->index);
	n = n->next;
    }
    return(BAD_SYM);
} /* unsat_find */

#ifdef RESOLVE_QUALIFIED_UNSATS
/* COMMENTED OUT UNTIL/UNLESS NEEDED BY COBOL */
/* This routine is supposed to bind optionally qualified unsats 	*/
/* with unqualified universals. This functionality was originally 	*/
/* meant to support COBOL since they were the only language meant	*/
/* to emit optionally qualified unsats. The problem is that the 	*/
/* pascal compiler emits optionally qualified unsats for 		*/
/* calls made to procedures located in imported modules when 		*/
/* it SHOULD be emitting fully qualified unsats. Because of this 	*/
/* it is questionable whether the optionally qualified behavior 	*/
/* can ever be supported correctly.  	*/
void resolve_qualified_unsats()
    {
    int i, ind;
    register struct symnode *n, *m;
    struct symnode *prevn, *nextn, *nextm;

    for (i = 0; i < UNSATHASHSIZE; i++) {
        prevn = NULL;
        for (n = unsat_hash_table[i]; n != NULL; n = nextn) {
	    nextn = n->next;
	    if (n->index == BAD_SYM)
	        continue;
	    if (n->mq || Sym_Qual_Name(n->index) == NULL)
	        continue;
	    ind = local_find(n->name, -1, Sym_Qual_Name(n->index), n->hashval, n->type);
	    if (ind == BAD_SYM)
	        ind = univ_find(n->name, 
				-1, 
				Sym_Qual_Name(n->index), 
				n->hashval, 
				n->type);

	    if (ind != BAD_SYM) {
	        for (m = n; m != NULL; m = nextm) {
		    nextm = m->same;
		    if (m->index != BAD_SYM) {
		        symbol_resolve(m->index, ind);
			}
		    free_node(m);
    		    }
	        if (prevn == NULL)
		    unsat_hash_table[i] = nextn;
	        else
		    prevn->next = nextn;
		}
            else
	        prevn = n;
	    }
	}
    }
#endif /* RESOLVE_QUALIFIED_UNSATS */

void unsat_resolve(name,mq,qname,hashval,remap_index,type,maxsize)
char *name, *qname;
Boolean mq;
unsigned int hashval;
int remap_index, type;
int *maxsize; /* used only for ST_STORAGE type */
{
    register unsigned int hashkey;
    register struct symnode *n, *m;
    struct symnode *prevn, *nextn, *nextm;
    struct symnode **table_to_search; /* pointer to the table being searched */
    int j; /* loop counter */

    /*
    ** remove name from hash table and resolve it and all of the 
    ** "same" list to the passed remap symbol index 
    */
    hashkey = hashval % UNSATHASHSIZE;

    if (building_incomp_exec) {
        j=0; 
        table_to_search = shlib_unsat_hash_table;
    } else {
        j=1; 
        table_to_search = unsat_hash_table;
    }
    for (; j < 2; j++, table_to_search = unsat_hash_table)
	 /* search both the regular and "soft" shlib hash tables */

    for (prevn = NULL, n = table_to_search[hashkey]; n != NULL; n = nextn) {
        nextn = n->next;
        if (n->hashval == hashval &&
                   /* 
		   ** don't match optionally qualified unsats with unqualified
                   ** universals/locals; that will be taken care of later on
                   */
                   (Sym_Qual_Name(n->index) == NULL || qname != NULL) &&
                   symnode_match(n,name,mq,qname,type)) {
	    for (m = n; m != NULL; m = nextm) {
	        nextm = m->same;
	        /* careful of user and library-created symbols */
	        if (m->index != BAD_SYM) {
		    /* 
		    ** If this is already resolved, don't resolve again!
		    ** When calling from storage_create(), we have already
		    ** pointed all the symbol indices to one sym_record,
		    ** so all we want to do is return the size of the
		    ** largest storage request 
		    ** The call to symbol_resolve is needed for type checking!
		    ** Since calling from storage_create(), the symbol scope
		    ** has just been set to SS_UNIVERSAL, therefore routine
		    ** symbol_resolve may never been called and we will never
		    ** detect any kind of mismatch. 
		    */
#if 0 /*  */

		       if (Sym_Scope(m->index) == SS_UNSAT)
#endif /* old */

		    /* Set the objfile_index before symbol_resolve() because
		     * Sym_Misc(m->index) will be replaced by 
		     * Sym_Misc(remap_index).
		     */
		    if ((m->type == ST_TSTORAGE || m->type == ST_STORAGE) &&
		           maxsize != NULL && m->len > *maxsize) {

		       /* doom support */
		       Sym_Misc(remap_index).objfile_index = Sym_Misc(m->index).objfile_index;
		    }
	            symbol_resolve(m->index,remap_index);

	            /* propogate the reference bit if it was set */
	            Sym_Misc(remap_index).referenced = 
			   (Sym_Misc(m->index).referenced ? 1 
					   : Sym_Misc(remap_index).referenced); 
		}
#ifdef TSD /* TSD */
		if (Sym_TLS(remap_index) && Sym_Type(remap_index) == ST_DATA
		    && m->type == ST_STORAGE) {
		    bad_obj = TRUE;
		    warning(TSD_SYM_MISMATCH, name);
		    bad_tls = TRUE;
		}
		if ((m->type == ST_TSTORAGE || m->type == ST_STORAGE) &&
		    maxsize != NULL)
#else
	        if (m->type == ST_STORAGE && maxsize != NULL)
#endif /* TSD */
		    *maxsize = max(*maxsize,m->len);
#ifdef ESOM
		if ( m->type == ST_STORAGE && 
		    table_to_search == unsat_hash_table ) {
		    int match_err;

		    if ( remap_index != -1 && m->index != -1 ) {
		        match_err = 
			    check_spp_subspaces(Sym_Common(remap_index),
						Sym_Common(m->index),
						Sym_Subsp(remap_index), 
						Sym_Subsp(m->index));
		        if ( match_err ) {
		            bad_common_subspaces(Sym_Name(remap_index),
						 0, remap_index, m->index);
			}
		    }
		}
#endif /* ESOM */
                /* HP-UX shared library support */
    		if (table_to_search == shlib_unsat_hash_table) { 
		    if (building_incomp_exec && m->index != BAD_SYM) {  
		        /* 
			** mark as resolved so won't bring in archive modules. 
		        ** Don't remove from unsat list, that will be done in
		        ** cleanup_shlib_unsat_tbl(). If remove now, we will
		        ** add again the next time we see this unsat and will 
			** get dup exports from the a.out for every soft unsat
			*/

		        m->exported_by_shlib = TRUE; 

			/* 
			** If we resolved this symbol to a non storage request
			** symbol, i.e., a data universal, then clear the
			** shlib_storage flag so we don't try to pull in
			** another data universal in search_linear() or 
			** search_non_linear() 
			*/
#ifdef TSD /* TSD */
			if (Sym_Type(remap_index) != ST_TSTORAGE ||
			    Sym_Type(remap_index) != ST_STORAGE)
#else
			if (Sym_Type(remap_index) != ST_STORAGE)
#endif /* TSD */
			    m->shlib_storage = FALSE;
		    }
		} else
 	            free_node(m);
	    } /* end traversal of same list */

            /* HP-UX shared library support */
	    if (table_to_search != shlib_unsat_hash_table)
	        if (prevn == NULL)
	            table_to_search[hashkey] = nextn;
	        else
	            prevn->next = nextn;
	} else  /* !symnode_match */
	    prevn = n;
    } /* end for loop down hash chain */
} /* end unsat_resolve */

void unsat_resolve_special(sym_name, subsp_index)
char *sym_name;
int subsp_index;
{
    struct symnode *n;
    struct symbol_dictionary_record *sym;
    unsigned int hash;
    extern void dup_sym_add();

    hash = hash_string(sym_name);

    /* 
    ** look in the universal symbol table for a duplicate defn               
    ** Only if preceeded with underscore (_end); others (etext, edata, end)  
    ** must be treated as secondary_defs for ANSI C.                         
    */
    if (sym_name[0] == '_') {
        for (n = univ_hash_table[hash % UNIVHASHSIZE]; n != NULL; 
	     n = n->next) {
            if (n->hashval == hash && !n->mq &&
		strcmp(n->name, sym_name) == 0) {
    	        /* duplicate found:  complain */
	        if (base_file_name != NULL) {
	            sym = &Sym_Dict(n->index);
		    sym->symbol_value = 
		      Subsp_Dict(subsp_index).subspace_start +
		      Subsp_Dict(subsp_index).subspace_length;
                } else
    	            dup_sym_add(sym_name, NULL, BAD_SYM, n->index);
	        return;
	    }
	}
    }

    /* now look in the unsat symbol table for a reference */
    for (n = unsat_hash_table[hash % UNSATHASHSIZE]; n != NULL; n = n->next) {
        if (n->hashval == hash && !n->mq &&
	    strcmp(n->name, sym_name) == 0) {
	    /* reference found:  resolve it */
	    if (subsp_index == BAD_SUBSP)
	        external_error(CANT_FIND_SUBSP, sym_name, 0);
	    sym = &Sym_Dict(n->index);
	    sym->symbol_scope = SS_UNIVERSAL;
	    sym->symbol_info = subsp_index;
	    Sym_Subsp(n->index) = subsp_index;
	    Subsp_Misc(subsp_index).symbol_count++;
	    sym->symbol_value = Subsp_Dict(subsp_index).subspace_start +
                                Subsp_Dict(subsp_index).subspace_length;
	    univ_add(sym_name, 
		     0, 
		     NULL, 
		     hash, 
		     n->index, 
		     ST_DATA);
	    unsat_resolve(sym_name, 
			  0, 
			  NULL, 
			  hash, 
			  n->index, 
			  ST_NULL, 
			  NULL);
            /* 
	    ** Set the appropriate flag in special_syms_added based upon
            ** the name of the symbol we resolved
	    */
            if (! strcmp("etext",sym_name)) {
                special_syms_added |= S_S_ETEXT;
            } else if (! strcmp("edata",sym_name)) {
                special_syms_added |= S_S_EDATA;
            } else if (! strcmp("end",sym_name)) {
                special_syms_added |= S_S_END;
            }
	    return;
	}
    }
} /* end unsat_resolve_special */

void resolve_secondary_syms()
{
    int i, j;  /* loop counters */
    struct symnode *sym, *prevn, *n, *nextn, *nextm, *m;
    unsigned int hashval, hashkey;
    Boolean ok_to_resolve = TRUE;

/* HP-UX shared library support */
#undef table_to_search 
    struct symnode **table_to_search; /* pointer to the table being searched */
	
    for (i=0 ; i < SECHASHSIZE ; i++) {
        for (sym = sec_hash_table[i]; sym != NULL; sym = sym->next) {
            hashval = sym->hashval; 
            hashkey = hashval % UNSATHASHSIZE;

            /* HP-UX shared library support */

  	    /* 
	    ** for universal secondary code symbols change the type
            ** from CODE to ENTRY, so export stubs can be built.
            ** only if we are alloc'ing ux stubs 
	    */
       	    if (alloc_stubs_ux && Sym_Type(sym->index) == ST_CODE) 
                Sym_Type(sym->index) = ST_ENTRY;

	    if (building_incomp_exec) {
	    	j=0; 
	    	table_to_search = shlib_unsat_hash_table;
	    } else {
	    	j=1; 
	    	table_to_search = unsat_hash_table;
       	    }
            for (;j < 2; j++, table_to_search = unsat_hash_table)
            for (prevn = NULL, n = table_to_search[hashkey]; 
		 				n != NULL; n = nextn) {
                nextn = n->next;
                if (n->hashval == hashval
  		    && (Sym_Qual_Name(n->index) == NULL || 
			Sym_Qual_Name(sym->index) != NULL)
                    && symnode_match(n,sym->name,sym->mq,
				     Sym_Qual_Name(sym->index),sym->type)){

                    /* 
		    ** first check to make sure that there is not a secondary
                    ** storage request in the list -- if there is don't resolve
                    ** to a secondary def
                    */
	            for (m = n; m != NULL; m = nextm) {
	                nextm = m->same;
#ifdef TSD /* TSD */
			if ((m->type == ST_TSTORAGE && 
			     m->secondary_def == TRUE) ||
			    (m->type == ST_STORAGE && 
			     m->secondary_def == TRUE))
#else
                        if (m->type == ST_STORAGE && m->secondary_def == TRUE)
#endif /* TSD */
                            ok_to_resolve = FALSE;
                    }
	 	    /*  DO NOT resolve soft unsats
		    ** with a data sdef if there's a data copied Univ
		    ** available; let it be resolved by the Univ later in
		    ** cleanup_shlib_unsat_tbl(). 
		    */

		    if (ok_to_resolve && ST_DATA == sym->type &&
			table_to_search == shlib_unsat_hash_table) {
			    int index;

			if ((index = univ_find (sym->name, 
						FALSE, 
						NULL,
						hashval, 
						ST_DATA)) != BAD_SYM) {

			    if (Sym_Subsp (index) == SHLIB_DATA_subsp_index)
				ok_to_resolve = FALSE;
			}
		    }

                    if (ok_to_resolve) {
	                for (m = n; m != NULL; m = nextm) {
	                    nextm = m->same;
	                    /* careful of user and library-created symbols */
	                    if (m->index != BAD_SYM) {
		                symbol_resolve(m->index,sym->index);
                                sym->resolved = TRUE;
                            }
                            /* HP-UX shared library support */
    			    if (building_incomp_exec && 
		    		!search_alldefs &&
		    	    	(table_to_search == shlib_unsat_hash_table) &&
		    	    	(m->index != BAD_SYM) &&
		    	    	(m == n) ) {  /* add (once) to list of exports
						satisfying shlib imports */
				/*
				** We used to set the symbol type to ST_NULL,
				** but this is a bad idea under the new
				** symbol table format because it causes
				** nulls out the REAL symbol! 
				*/
		    	    	*m = *sym;
		    	    	m->next = minimum_export_list;
		    	    	minimum_export_list = m;
			    } else
	                        free_node(m);
		        }
	                if (prevn == NULL)
	                    table_to_search[hashkey] = nextn;
	                else
	                    prevn->next = nextn;
	            } else {  /* !ok_to_resolve */
                        /* reset ok_to_resolve flag */
                        ok_to_resolve = TRUE;
                    }
                } else      
	            prevn = n;
	    }
        }
    } /* for secondary has */
} /* end resolve_secondary_syms */

Boolean unsat_print_list()
{
    int unsats, missing_ob, i;
    Boolean non_code_unsats = FALSE;  /* code unsats are OK for HP-UX shlibs 
					and (with -FC on) incomplete a.outs */
    char buf[80];
    struct symnode *n, *nn;
    char *c;
    int tmp_sym_type;
    int size;
    FILE *fp;
#ifdef TSD /* TSD */
    unsigned int tls;
#endif /* TSD */

    unsats = 0;
    missing_ob = 0;

    /* 
    **  Removed #ifdef PBO for find_unsat_only and
    ** resolve_sym_only since we can use these in non PBO environments.
    ** if isom_exist, we do not want to print the warnings twice. The
    ** pre-link (stop after symbol resolution when isom_exist) phase will
    ** suppress the warning. 
    */
    if (isom_exist &&
        !list_unsats_only && !trace_syms_only)
        return 0;

    for (i = 0; i < UNSATHASHSIZE; i++) {
				/* hp-ux complete a.out : error */
        if (!(alloc_stubs_xl || alloc_stubs_ux)) {
	    for (n = unsat_hash_table[i]; n != NULL; n = n->next) {
		if (Sym_Qual_Name(n->index) != NULL) {
		    sprintf (buf, "%.39s.%.39s", Sym_Qual_Name(n->index), 
                             n->name);
                    c = buf;
                } else 
		    c = n->name;
		{
		    if (n->type != ST_STUB && !unsats) {
                        unsats++; 
		        warning (UNSATS, 0);
                    }
                }

		if (n->index != BAD_SYM && 
		    Sym_Type(n->index) == ST_MILLICODE)	
		    warning_continue (UNSAT_MILLICODE, c, 0);
		else if (n->type == ST_CODE)
		    warning_continue (UNSAT_CODE, c, 0);
		else if (n->type == ST_DATA)
		    warning_continue (UNSAT_DATA, c, 0);
		else if (n->type != ST_STUB)
		    warning_continue (UNSAT_OTHER, c, 0);

                /* 
                **  MF COBOL wants -Fut to print soft
                ** unsats as well as regular unsats.
                */
                if (list_unsats_only) {
                    if (n->type == ST_CODE) {

                        if (fp = unsat_files [FU_TEXT_UNSAT])
                            fprintf (fp, FORMAT_STRING_UNDEF, c);
                        if (fp = unsat_files [FU_ALL_UNSAT])
                            fprintf (fp, FORMAT_STRING_TEXT, c);
                     } else if (n->type == ST_DATA) {

                        if (fp = unsat_files [FU_DATA_UNSAT])
                            fprintf (fp, FORMAT_STRING_UNDEF, c);
                        if (fp = unsat_files [FU_ALL_UNSAT])
                            fprintf (fp, FORMAT_STRING_DATA, c);
                     }
	       }
	    }
        } else { /* XL or HP-UX shlibs: on XL we will make an external import 
		  stub for each code unsat, on HP-UX we just print messages */
	    for (n = unsat_hash_table[i]; n != NULL; n = n->next) {
		if ((int)n->index != BAD_SYM &&
		    (Sym_Dict(n->index).symbol_type == ST_CODE || 
		     Sym_Dict(n->index).symbol_type == ST_STUB_IMPORT)) {
		    if (strcmp(n->name, "_start") == 0)
			missing_ob++;
		    else if (alloc_stubs_xl) {
			/* add import stubs */
			/* HP-UX stubs are added in shlib_build_tables */
			add_import_stub (n->index);
			Sym_Subsp(n->index) = BAD_SUBSP;
			Sym_Back_Ptr(n->index) = n;
			for (nn = n->same; nn != NULL; nn = nn->same) {
			    /* share import stubs in each subspace */
			    add_import_stub (nn->index);
			    Sym_Subsp(nn->index) = BAD_SUBSP;
			    Sym_Back_Ptr(nn->index) = n;
			    } /* END for */
		        } /* END alloc_stubs_xl */

                    /* HP-UX shared library processing */
		    else if (building_incomp_exec ||
			    (building_shlib && (verbose & V_SOFT_UNSATS))) {
    			    if (building_incomp_exec && allow_code_unsats)  
			    	/* don't even give warning if -FC on */
				continue;

			    if (saved_export_match(n,
						   &tmp_sym_type,
						   &size,
#ifdef TSD /* TSD */
						   &tls,
#endif /* TSD */
						   &c)) {
				/* 
				** Don't report if there is a matching 
				** shlib export.  Note that if unsats is
				** never incremented the program is treated
				** as if it has no unsats, even if there
				** are entries in the unsat table.
				*/
				continue;
			    }

                            if ((BAD_SYM != univ_find(n->name,
                                                      0,
                                                      NULL,
                                                      n->hashval,
                                                      ST_CODE)))
                                continue;


			    /* normal case: code unsats OK, but give warning */
		    	    if (!unsats) {
		        	unsats++;
                                if (!allow_shlib_unsats)
                                  bad_obj = TRUE;
				warning (UNSATS , 0);
                            }
  			    if (Sym_Qual_Name(n->index) != NULL) {
                                sprintf (buf, "%.39s.%.39s", 
                                         Sym_Qual_Name (n->index), n->name);
                                c = buf;
                            } else
                                c = n->name;
			    warning_continue (UNSAT_CODE, c, 0);

			    if (list_unsats_only) {

                        	if (fp = unsat_files [FU_TEXT_UNSAT])
                            	    fprintf (fp, FORMAT_STRING_UNDEF, c);
                        	if (fp = unsat_files [FU_ALL_UNSAT])
                            	    fprintf (fp, FORMAT_STRING_TEXT, c);
			    }
		    }
		} /* END if ST_CODE symbol */
		else {     /* not CODE symbol */
		    if (n->type == ST_STUB)
			continue;

                        /* HP-UX shared library processing */
#ifdef TSD /* TSD */
			if (saved_export_match(n,&tmp_sym_type,&size,&tls,&c)) {
#else
			if (saved_export_match(n, &tmp_sym_type, &size, &c)) {
#endif /* TSD */
			    /* 
			    ** Don't report if there is a matching 
			    ** shlib export.  Note that if unsats is
			    ** never incremented the program is treated
			    ** as if it has no unsats, even if there
			    ** are entries in the unsat table.
			    */
			    continue;
			}
                    /* suppress warning on unsats for shlibs */
                    /***************************************************/
                    if (!(building_shlib &&
                               !(verbose & (V_WHY | V_SOFT_UNSATS)))) {
		        if (!unsats) {
		            unsats++;
			    warning (UNSATS, 0);
                         }
  		         if (Sym_Qual_Name (n->index) != NULL) {
                             sprintf (buf, 
				      "%.39s.%.39s", 
				      Sym_Qual_Name (n->index), 
				      n->name);
                             c = buf;
                         } else
                             c = n->name;

		         non_code_unsats = TRUE;
		         if (n->type == ST_DATA) {
 		             warning_continue (UNSAT_DATA, c, 0);
			    if (list_unsats_only) {
                                if (fp = unsat_files [FU_DATA_UNSAT])
                            	    fprintf (fp, FORMAT_STRING_UNDEF, c);
                                if (fp = unsat_files [FU_ALL_UNSAT])
                            	    fprintf (fp, FORMAT_STRING_DATA, c);
			    }
		         } else
			     warning_continue (UNSAT_OTHER, c, 0);
		    } /* !building_shlib */
 	        } /* END else not ST_CODE symbol */
	    }
	}  
    }  
    /* HP-UX shared library processing */
    if (building_shlib)  /* unsats ok in shlib, no outer block expected */
	return(0);

    if (missing_ob) {
	/* Can't use ld_gets in call to warning because it calls ld_gets. */
	char	*tmp_msg;
	char	*msg_buf1;

	tmp_msg = ld_gets(1, 1222, "_start (OUTER BLOCK)");
	msg_buf1 = emalloc(strlen(tmp_msg) + 1);
	strcpy(msg_buf1, tmp_msg);
        warning (ENTRY_SYM_NOT_FND, msg_buf1, 0);
	efree(msg_buf1);
    }

    /* HP-UX shared library processing */
    if (building_incomp_exec && !non_code_unsats && allow_code_unsats)  
	/* code unsats ok (leave a.out executable) in incomp a.out if -FC on */
	return(missing_ob);

    return (unsats+missing_ob);
} /* end unsat_print_list */

/* assign_xrt_offsets() runs through the unsat list, assigning new */
/* xrt offsets to import stubs, and nullifying unsat symbols that  */
/* were never referenced.  It returns a flag indicating whether    */
/* any symbols were nullified, so that another pass through the    */
/* assign_virtual_address()/assign_file_offset() loop can be done. */

Boolean assign_xrt_offsets()
{
    /*
    ** Changed new_xrt from a Boolean to a symbol_dictionary_record.  This
    ** was done to fix a problem that showed up as a result of the fix
     The symbol table rewrite caused the sharing of
    ** symbol_dictionary_records. Unfortunately, when traversing the same
    ** list it was assumed that a symbol_dictionary_record would only
    ** be visited once. WRONG!  The fix is to keep track of the first
    ** symbol on the same list with new_xrt instead of a flag which
    ** indicates the first one has been seen.  Also added used_xrt to
    */
    Boolean flag;
    int i,j, t;
    int used_xrt;
    struct symnode *n, *nn;
    struct symbol_dictionary_record *sym, *new_xrt;

    flag = FALSE;

    for (i = 0; i < UNSATHASHSIZE; i++) {
        for (n = unsat_hash_table[i]; n != NULL; n = n->next) {
            new_xrt = &Sym_Dict(n->index);
            used_xrt = 0;

	    for (nn = n; nn != NULL; nn = nn->same) {
	        if (nn->index == BAD_SYM)
		    continue;

                /*
		** Only nullify sym if it doesn't have any stubs AND it 
		** is was not used on a data plabel fixup 
		** If used on a data plabel, the xrt entry is needed! 
		*/
	        if ((Sym_Subsp(nn->index) == BAD_SUBSP) &&
		        !(Sym_Misc(nn->index).import_data_plabel)) {
		    /* Nullify unused symbol */

		    Sym_Dict(nn->index).symbol_type = ST_NULL;
                    flag = TRUE;  /* force recount of symbols */

	            /* nullify any and all extension records too! */
	            for (j = nn->index+1; j < sym_dict_size; j++) {
		        t = Sym_Dict(j).symbol_type;
		        if (t != ST_SYM_EXT && t != ST_ARG_EXT)
		            break;
			else     /* Nullify sym and arg ext for unused sym */
		            Sym_Dict(j).symbol_type = ST_NULL;

		    }
	       } else {
    		    /* Assign an xrt entry */
		    /* Set scope to LOCAL for all but first */
		    /* stub in each same list.		    */
		    /* Set the XRT offset 		    */
		    sym = &Sym_Dict(nn->index);
                    if (new_xrt != sym)   
		        sym->symbol_scope = SS_LOCAL;
		    sym->symbol_info = next_xrt * XRT_ENTRY_SIZE;
                    used_xrt = 1;
		}  /* else assign xrt slot */
	     } /* for same list */

	    /* bump the next_xrt counter if an xrt entry was assigned */
            next_xrt = next_xrt + used_xrt;
	} /* for n = unsat_hash... */
    } /* outer for */
    return (flag);
} /* assign_xrt_offsets */

static struct namenode *get_namenode(sym_name, hashval)
char *sym_name;
unsigned int hashval;
{
    struct namenode *tmp;

    if (!free_names) {
	int i;
	free_names = (struct namenode *)ecalloc(NODE_MAX, sizeof(struct namenode));
	for (i = 0 ; i < NODE_MAX-1; i++)
	    free_names[i].next = free_names+i+1;

	free_names[NODE_MAX-1].next = NULL;
    }

    tmp = free_names;
    free_names = tmp->next;
    tmp->name = sym_name;
    tmp->hashval = hashval;
    tmp->next = NULL;
    return (tmp);
}

shlib_export_list_add(sym_name)
char *sym_name;
{
    unsigned int hashval = hash_string(sym_name);
    unsigned int hashkey = hashval % EXPORT_LIST_HASH_SIZE;
    register struct namenode *n, *new;

    if (!sym_name || !*sym_name) return;
    for (n = export_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(sym_name,n->name)) break;
    }

    if (!n) {
	export_hash_count++;
	new = get_namenode(sym_name, hashval);
	new->next = export_hash_table[hashkey];
	export_hash_table[hashkey] = new;
    }
}

on_shlib_export_list(sym_name)
char *sym_name;
{
    unsigned int hashval, hashkey;
    struct namenode *n;

    if (!export_hash_count)
	return TRUE; /* if no minimal list, then sym is on the export list */
    if (!sym_name || !*sym_name) return FALSE;
    hashval = hash_string(sym_name);
    hashkey = hashval % EXPORT_LIST_HASH_SIZE;
    for (n = export_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(n->name, sym_name)) return TRUE;
    }
    return(FALSE);
} /* end on_shlib_export_list */

void excl_export_list_add(char *sym_name)
{
    unsigned int hashval = hash_string(sym_name);
    unsigned int hashkey = hashval % EXPORT_LIST_HASH_SIZE;
    struct namenode *n, *new;

    if (!sym_name || !*sym_name) return;
    for (n = excl_exp_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(sym_name,n->name)) break;
    }

    if (!n) {
	excl_exp_hash_count++;
	new = get_namenode(sym_name, hashval);
	new->next = excl_exp_hash_table[hashkey];
	excl_exp_hash_table[hashkey] = new;
    }
}

Boolean on_excl_export_list(char *sym_name)
{
    unsigned int hashval, hashkey;
    struct namenode *n;

    if (!excl_exp_hash_count) return FALSE;

    if (!sym_name || !*sym_name) return FALSE;
    hashval = hash_string(sym_name);
    hashkey = hashval % EXPORT_LIST_HASH_SIZE;
    for (n = excl_exp_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(n->name, sym_name)) return TRUE;
    }
    return(FALSE);
} /* end on_excl_export_list */

#define DOING_UNIVS	0
#define DOING_SECS	1

void select_shlib_exports()
{
    /* 
    ** for all univ syms, determine whether they should be hidden based on 
    ** the shlib_export_list which was input by the user. 
    */

    int i,j;
    struct symnode *n, *m;
    int sym_ind;
    char *name;

	/* 
	**  Need to resolve these before we decide if
	** a stor. req. will be exported or not. 
	*/
    if (building_incomp_exec && !do_data_copy)
        resolve_shlib_storage_requests();

    hidden_shlib_exports = 0;    

    if (!export_hash_count && !hide_hash_count)
	return;

    for (i = DOING_UNIVS, j = 0; i <= DOING_SECS ;) {
	switch(i) {
	    case DOING_UNIVS:
		if (j == UNIVHASHSIZE) {
		    i++;
		    j=0;
		    continue;
		} else {
		    n = univ_hash_table[j++];
		    break;
		}
	    case DOING_SECS:
		if (j == SECHASHSIZE) {
		    i++;
		    j=0;
		    continue;
		} else {
		    n = sec_hash_table[j++];
		    break;
		}
	} /* switch */

	for (; n != NULL; n = n->next) {	
	    sym_ind = Sym_Remap(n->index);
	    name = Sym_Name(sym_ind);
	    Sym_ShlHideExp(sym_ind) = 
	        ( (!on_shlib_export_list(name) &&
		   !on_excl_export_list(name)) || on_hide_list(name) );
	    if (Sym_ShlHideExp(sym_ind)) {
		++hidden_shlib_exports;

		/* 
		** See if there are multiple versions of the symbol being  
		** hidden. If this is the case, we will have dead code     
		** or dead data and the user will not be able to determine 
		** which version was used for internal resolution          
		*/
		if (building_shlib) {
		    for (m = n->next; m != NULL; m = m->next) {
		        if (Sym_Type(Sym_Remap(m->index)) == Sym_Type(sym_ind) 
			    && strcmp(m->name, name) == 0)
			    warning(HIDDEN_MULTIVER, name, 0);
		    }
		} 
	    } /* hidden export */
	} /* for */
    } /* for univ */
} /* end select_shlib_exports */

on_hide_list(sym_name)
char *sym_name;
{
    unsigned int hashval, hashkey;
    struct namenode *n;

    if (!sym_name || !*sym_name || !hide_hash_count) return FALSE;
    hashval = hash_string(sym_name);
    hashkey = hashval % HIDE_LIST_HASH_SIZE;
    for (n = hide_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(n->name, sym_name)) return TRUE;
    }
    return(FALSE);
} /* end on_hide_list */

hide_list_add(sym_name)
char *sym_name;
{
    unsigned int hashval = hash_string(sym_name);
    unsigned int hashkey = hashval % HIDE_LIST_HASH_SIZE;
    register struct namenode *n, *new;

    if (!sym_name || !*sym_name) return;
    for (n = hide_hash_table[hashkey]; n != NULL; n = n->next) {
	if (n->hashval == hashval && !strcmp(sym_name,n->name)) break;
    }

    if (!n) {
	hide_hash_count++;
	new = get_namenode(sym_name, hashval);
	new->next = hide_hash_table[hashkey];
	hide_hash_table[hashkey] = new;
    }
}

remove_from_hide_list(sym_name)
char *sym_name;
{
    /* 
    ** This routine "removes" a symbol from the hide list by overwriting it
    ** with the last symbol on the list 
    */
    unsigned int hashval = hash_string(sym_name);
    unsigned int hashkey = hashval % HIDE_LIST_HASH_SIZE;
    struct namenode *n,*p;

    if (!sym_name || !*sym_name || !hide_hash_table[hashkey]) return;

    if (hide_hash_table[hashkey]->hashval == hashval &&
	!strcmp(hide_hash_table[hashkey]->name,sym_name)) {
	n = hide_hash_table[hashkey];
	hide_hash_table[hashkey] = hide_hash_table[hashkey]->next;
	free_name(n);
	hide_hash_count--;
	return;
    }
    else {
	for (p=hide_hash_table[hashkey], n=p->next; n; p=n, n=n->next) {
	    if (n->hashval == hashval && !strcmp(n->name,sym_name)) {
		p->next = n->next;
		free_name(n);
		hide_hash_count--;
		/* Since we have no duplicates, we can just return */
		return;
	    }
	}
    }
    return;
} /* remove_from_hide_list */

void hide_symbols()
{
    int ind,i;
    char *name;
    struct namenode *n;

    if (!hide_hash_count) return;

    for (i = 0; i < HIDE_LIST_HASH_SIZE; i++) {
	for (n = hide_hash_table[i]; n != NULL; n = n->next) {
	    /* 
	     ** There is no way to tell if we want to hide a TLS symbol or not
	     ** based on symbol name alone.  If we have name space collisions,
	     ** it's an error anyway so we'll just hide the one we find first.
	     */
	    ind = univ_find(n->name, 0, NULL, n->hashval, ST_NULL);

	    if (ind == BAD_SYM) {
		/* 
		 ** Allow hiding of sec_def symbols. We first promote them
		 ** to primary symbols and then make them local 
		 */
		ind = sec_find(n->name, 0, NULL, n->hashval, ST_NULL);
		if (ind == BAD_SYM) {
		    warning(CANT_HIDE_SYM, n->name, 0);
		} else {
		    Sym_Dict(ind).secondary_def = FALSE;
		    Sym_Scope(ind) = SS_LOCAL;
		}
	    } else {
		Sym_Scope(ind) = SS_LOCAL;
	    }
	}
    }
} /* hide_symbols */

/*
For each symbol for which -Fx was specified, look it up in the
unsatisfied symbol list.  If it is present, make its type ST_NULL and
resolve it so it disappears both from the symbol table (so it isn't in
the .o or a.out) and from the unsatisfied hash table (so undefined
external is not reported).

This "feature" is used by Ada in combination with -FX (which removes
uncalled Ada subprograms).  The Ada binder "knows" that having removed
uncalled Ada subprograms, that some "interfaced" non-Ada code is no
longer called by any Ada code.  However, the linker entered all
references to "interfaced" non-Ada code as unsatisfied code references
when it processed the SOMs containing Ada subprograms that were later
eliminated with -FX.  The linker does not (and for efficiency reasons
probably should not) know what code "introduced" the unsatisfied code
references that it still has, so we can't expect the linker to handle
these no-longer-needed-but-still-unsatisfied-code-references
automatically.

Currently -Fx is only effective if -r is also specified and when Ada
uses -Fx with -r it provides only Ada produced .o files to the linker.
There are two reasons for this:

   1. Without -r, Ada could want a symbol "forgotten", but non-Ada code
      could need that symbol (something the Ada binder could not know).
      If the SOM which defined the symbol was not provided, the linker
      would not complain that the "forgotten" symbol was undefined
      (which it is, but -Fx says to pretend it isn't) and the linker
      will build an executable program.  The program will fail in an
      unpredictable manner when the non-Ada code tries to use the
      "forgotten" symbol.

      Using -r and providing only Ada produced .o files to the linker,
      -Fx cannot produce this "error".

   2. Without -r, the user could be trying to build an executable with
      shared library references.  It is harder to "forget" unsatisfied
      code symbols under such circumstances (AND THIS CODE DOES NOT
      ATTEMPT TO DO SO) because import stubs will have already been
      generated and would presumably have to be removed.  At this time,
      Ada code is not supported within shared libraries, if it ever is,
      then this concern will have to be addressed.

      Note that this limitation does not, itself, preclude building an
      Ada program that uses shared libraries of non-Ada code.  The
      binder produces a single .o from the Ada .o files using -r (and
      perhaps -Fx) and then the binder uses the linker a second time
      without -Fx, linking the single .o which could link in shared
      library code (assuming the Ada runtime operates correctly in the
      presence of shared library code).

If a symbol to be "forgotten" is not an unsatisfied code reference, we
do nothing.  Such a case with -r probably means that the user pragma
EXPORTed Ada code and gave it that symbol as a name; probably not the
best thing to do, but Ada isn't going to call it anyway if -Fx exists
for it.  If -Fx is ever supported without -r, it probably means that
non-Ada code "needed" the symbol, and hence it got satisfied, and that
is fine too.

*/

void forget_unsats()
{
   int ind, hashval;
   char **list, *name;

   list = forget_list;
   if (list == NULL) 
       return;

   /*
   This mechanism is only currently supported if -r was also specified.
   If -r was specified, neither building_incomp_exec nor building_shlib
   should be true, but we'll check them anyway because this mechanism is
   definitely not supported if either are true.
   */
   if (!relocatable || building_incomp_exec || building_shlib) 
      return;

   while ((name = *list++) != NULL) {
      hashval = hash_string (name);
      ind = unsat_find (name, NULL, hashval, ST_CODE);

      if (ind != BAD_SYM) {
         unsat_resolve (name, 0, NULL, hashval, ind, ST_CODE);
         Sym_Type(ind) = ST_NULL;
      }
  }
} /* forget_unsats */

/* miscellaneous routines */

/* getnode()
   Unfree one symnode for each getnode request.
*/
struct symnode *get_node(name,mq,qname,hashval,sym_ind,type,len)
char *name;
Boolean mq;
char *qname;
unsigned int hashval;
int sym_ind;
int type;
int len;
{
    register struct symnode *n;
    extern void init_free_list();

    /* if first get_node call, allocate block for list */
    if (!nodes) {
	nodes = (struct symnode **)
			emalloc(node_segs_max * sizeof(struct symnode *));
    }

    /* if free list is empty, allocate another segment */
    if (free_nodes == NULL) {
	if (node_segs >= node_segs_max) {
	    node_segs_max += MAX_SEGS;
	    nodes = (struct symnode **) erealloc((char *) nodes,
				node_segs_max * sizeof(struct symnode *));
	}
	nodes[node_segs] = (struct symnode *)
			emalloc(node_max * sizeof(struct symnode));
	node_segs++;
	init_free_list(node_segs-1);
    }

    /* pull a node off the free list */
    n = free_nodes;
    free_nodes = free_nodes->next;

    /* clear the record, new fields will be automatically cleared */
    memset((char *)n, '\0', sizeof(struct symnode));

    /* initialize the new node */
    n->name = name;
    n->mq = mq;
    n->type = type;
    n->hashval = hashval;
    n->index = sym_ind;
    n->len = len;

    return(n);
} /* end get_node */

void init_free_list(first_seg)
int first_seg;
{
    int i, j;
    struct symnode *n;

    free_nodes = nodes[first_seg];
    for (i = first_seg; i < node_segs; i++) {
	n = nodes[i];
	for (j = 0; j < node_max - 1; j++) {
	    n->next = n + 1;
	    n++;
	}
	if (i < node_segs - 1)
    	    n->next = nodes[i+1];
	else
	    n->next = NULL;
    }
} /* init_free_list */

Boolean symnode_match(n,name,mq,qname,type)
register struct symnode *n;
char *name, *qname;
Boolean mq;
int type;
{
    /* Check for type match */
    if (!compat && !symbol_type_match(n->type, type))
	return (FALSE);

    /* Check the symbol names */
    if (strcmp(n->name, name) != 0)
	return (FALSE);

    /* 
    ** If either must_qualify (mq) bit is on, the other symbol must be
    ** qualified
    */
    if (mq && Sym_Qual_Name(n->index) == NULL)
	return (FALSE);
    if (n->mq && qname == NULL)
	return (FALSE);

    /* Check the qualifiers */
    if (qname != NULL && Sym_Qual_Name(n->index) != NULL && 
	strcmp(Sym_Qual_Name(n->index), qname) != 0)
	return (FALSE);

    return(TRUE);
} /* end symnode_match */

/* symnode_same() is the same as symnode_match(), except that 	      */
/* the must_qualify bit is not used -- if either symbol is qualified, */
/* the other must also be qualified, and the qualifiers must match    */

Boolean symnode_same(n, name, qname, type, index, verbose_incompat_sym)
register struct symnode *n;
char *name, *qname;
int type, index;
Boolean verbose_incompat_sym;
{
    /* Check the symbol names */
    if (strcmp(n->name, name) != 0)
        return(FALSE);

    /* If either symbol is qualified, the other must be also */
    else if (qname != NULL && Sym_Qual_Name(n->index) == NULL)
        return(FALSE);

    else if (Sym_Qual_Name(n->index) != NULL && qname == NULL)
        return(FALSE);

    /* Check the qualifiers */
    else if (qname != NULL && strcmp(Sym_Qual_Name(n->index), qname) != 0)
        return(FALSE);

    /* Check for type match */
    else if (!compat && !symbol_type_match(n->type, type)) {

#ifdef OBS_FEATURES_WARN
#ifdef TSD
        /* we already flag this as an *ERROR*; don't emit warning */
        if (! Sym_TLS(index) && ! Sym_TLS(n->index)) {
#endif /* TSD */
        /* Everything matched but the types. */
        if (verbose & V_CHANGE_WARN) {

           char *sym_file;

           if (Sym_Scope(n->index) == SS_LOCAL) 
               return(FALSE);

           /* If verbose_incompat_sym set, emit warning if types don't match */
	   if (verbose_incompat_sym) {

              found_change_warn = TRUE;


              if (verbose & V_DETAIL_CHANGE_WARN)
                 warning(MULT_INCOMPAT_SYM_NUKED,
                         name,
                         (index == BAD_SYM)
                            ? ((sym_file = progname)
                                 ? sym_file
                                 : "(unknown)")
                            : ((sym_file = get_symbol_filename(index))
                                 ? sym_file
                                 : "(unknown)"),
                         (n->index == BAD_SYM)
                            ? ((sym_file = progname)
                                 ? sym_file
                                 : "(unknown)")
                            : ((sym_file = get_symbol_filename(n->index))
                                 ? sym_file
                                 : "(unknown)"), 0);
	   }
        }
#ifdef TSD /* TSD */
      }
#endif /* TSD */

#endif

        return(FALSE);
    }

    return(TRUE);
} /* end symnode_same */

static void init_type_match_table()
{
    int i,j;

    /* 
     * Initialize the diagonal - each type matches itself. Also, ST_NULL
     * matches everything.
    */
    for (i=0; i<NUM_TYPES; i++)
	for (j=0; j<NUM_TYPES; j++)
	    type_match_table[i][j] = ((i==j) || (i==ST_NULL) || (j==ST_NULL));

    /*
     * ST_COMDAT symbols should be ignored unless we're explicitly looking
     * for them.
     */

    type_match_table[ST_NULL][ST_COMDAT] = FALSE;
    type_match_table[ST_COMDAT][ST_NULL] = FALSE;

    /* 
    ** check for STUB-CODE combinations (for Ada optional procs).      
    ** type1 is the type of the unsat; type2 is the type of the univ   
    ** so only match a STUB UNSAT to a CODE -- not te other way around.
    */
    type_match_table[ST_STUB][ST_CODE] = TRUE;

    /* look for STORAGE-DATA combination */
    type_match_table[ST_DATA][ST_STORAGE] = TRUE;
    type_match_table[ST_STORAGE][ST_DATA] = TRUE;

#ifdef TSD /* TSD */
    type_match_table[ST_DATA][ST_TSTORAGE] = TRUE;
    type_match_table[ST_TSTORAGE][ST_DATA] = TRUE;
#endif /* TSD */

} /* end symbol_type_match */

void symbol_resolve (old_index, new_index)
int old_index, new_index;
{
    int i;
    int type, t;
    struct symbol_dictionary_record *old, *new;
    extern void sym_check_match();

    if (old_index == new_index)
        return;
    old = &Sym_Dict (old_index);
    new = &Sym_Dict (new_index);
    type = new->symbol_type;

    if (type == ST_ENTRY ||
	    type == ST_PRI_PROG ||
	    type == ST_SEC_PROG ||
	    type == ST_DATA ||
	    type == ST_CODE) {

	if (old->check_level >= 1 && new->check_level >= 1)
	    sym_check_match (old_index, new_index);
    	/* mark all extension records as NULL too! */
	for (i = old_index+1; i < sym_dict_size; i++) {
	    t = Sym_Dict(i).symbol_type;
	    if (t != ST_SYM_EXT && t != ST_ARG_EXT)
		break;
	    Free_Sym_Record(_sym_record[i]);
	    _sym_record[i] = &null_symbol_record;
	}
    }

    Remap_Sym_Records(old_index, new_index);
} /* end symbol_resolve */

void symbol_mismatch(level, ref, def, err, arg)
int level, ref, def;
int err, arg;
{
    struct subsp_misc_record *rmisc, *dmisc;

    rmisc = &Subsp_Misc(Sym_Subsp(ref));
    dmisc = &Subsp_Misc(Sym_Subsp(def));
    if (level > 4)
	external_error(err, 
		       Sym_Dict(def).name.n_name,
		       rmisc->file_name, 
		       dmisc->file_name, 
		       0);
    /* never returns */
    /* 
    ** The linker prints a warning only if the parmcheck option 
    ** is higher than the level of the current error; otherwise 
    ** it prints nothing.                                       
    */

    if (level <= parmcheck) {
	warning(err, 
		Sym_Dict(def).name.n_name,
		rmisc->file_name, 
		dmisc->file_name, 
		0);
	if (arg > 0)
	    warning_continue_n(MISMATCH_ARG, arg);
    }
} /* symbol_mismatch */

void sym_check_match(ref,def)
int ref, def;
{
    int refx, defx;
    struct symbol_dictionary_record *rsym, *dsym;
    struct symbol_extension_record *rsxr, *dsxr;
    struct argument_desc_array *rsar, *dsar;
    int i, nargs;
    int err, level;
    union arg_descriptor *rarg, *darg;
    extern void symbol_mismatch();

    rsym = &Sym_Dict(ref);
    dsym = &Sym_Dict(def);
    refx = ref + 1;
    defx = def + 1;
    rsxr = (struct symbol_extension_record *)&Sym_Dict(refx);
    dsxr = (struct symbol_extension_record *)&Sym_Dict(defx);

    level = min(rsym->check_level, dsym->check_level);

    if (rsxr->type != ST_SYM_EXT) {
	symbol_mismatch(4, ref, ref, MISMATCH_MISSING, 0);
	return;
    }
    if (dsxr->type != ST_SYM_EXT) {
	symbol_mismatch(4, def, def, MISMATCH_MISSING, 0);
	return;
    }

    err = type_compatible(&dsxr->symbol_desc, &rsxr->symbol_desc);
    if (err) {
	symbol_mismatch(1, ref, def, err, 0);
    }

    if (level <= 1 || dsym->symbol_type == ST_DATA)
	return;

    if (dsxr->min_num_args > rsxr->num_args ||
	    dsxr->max_num_args < rsxr->num_args) {
	symbol_mismatch(2, ref, def, MISMATCH_COUNT, 0);
    }

    if (level <= 2)
	return;

    nargs = min(dsxr->num_args,rsxr->num_args);
    rarg = &rsxr->argument_desc[0];
    darg = &dsxr->argument_desc[0];
    for (i = 0; i < nargs; i++) {
        if (err = type_compatible(rarg, darg))
	    symbol_mismatch(3, ref, def, err, i+1);
	++rarg;
        ++darg;
	if ((i % 4) == 2) {
	    refx++;
	    defx++;
	    rsar = (struct argument_desc_array *)&Sym_Dict(refx);
	    dsar = (struct argument_desc_array *)&Sym_Dict(defx);
	    rarg = &rsar->argument_desc[0];
	    darg = &dsar->argument_desc[0];
	}
    }
} /* end sym_check_match */

int type_compatible(actual, formal)
union arg_descriptor *actual, *formal;
{
    /* quick check for exact match or wildcards */
    if (formal->word == actual->word ||
        formal->word == 0 ||
	actual->word == 0)
	return (0);

    /* check for compatible type */
    if ((formal->arg_desc.hash == 0 && formal->arg_desc.arg_type == 0) ||
	(actual->arg_desc.hash == 0 && actual->arg_desc.arg_type == 0))
	/* continue -- one or the other is a wild card */ ;
    else if (formal->arg_desc.hash != actual->arg_desc.hash ||
	     formal->arg_desc.arg_type != actual->arg_desc.arg_type)
	return (MISMATCH_TYPE);

    /* check for compatible mode */
    if (formal->arg_desc.mode != 0 &&
	actual->arg_desc.mode != 0 &&
	formal->arg_desc.mode != actual->arg_desc.mode)
	return (MISMATCH_MODE);

    /* check for compatible structure */
    if (formal->arg_desc.structure != 0 &&
	actual->arg_desc.structure != 0 &&
	formal->arg_desc.structure != actual->arg_desc.structure)
	return (MISMATCH_STRUCT);

    /* check for incompatible packing */
    if (formal->arg_desc.packing != actual->arg_desc.packing)
	return (MISMATCH_PACKING);

    /* check for incompatible alignment */
    if (formal->arg_desc.alignment > actual->arg_desc.alignment)
	return (MISMATCH_ALIGN);

    /* all tests passed */
    return (0);
} /* end type_compatible */

int symbol_value(old_index)
int old_index;
{
    register int index, subsp;
    struct symbol_dictionary_record *sym;

    /* yet another uninitialized variable bug here */
    register int temp_subspace_start = 0, temp_subsp_stubs_size = 0;
    register int temp_clear_sym_xl = 0, temp_elim_delta = 0;
	/* temps to consolidate "generic" processing into one code series
	   instead of the original three replicated sets */

    index = Sym_Remap(old_index);
    sym = &Sym_Dict(index);
    subsp = Sym_Subsp(index);


    /* adjust for HP-UX shlib case of having both import and export stubs. */
    if ((subsp == BAD_SUBSP) && building_shlib) {
	int stub_index = Sym_Remap(Sym_Related_Stub(index));  
				/* index of related export stub symbol */
	if ((stub_index != BAD_SYM) && 
	    (Sym_Dict(index).symbol_type == ST_STUB_IMPORT)) {
	    index = stub_index;  /* find export stub sym */
	    sym = &Sym_Dict(index);
	    subsp = Sym_Subsp(index);
	}
    }

    switch(sym->symbol_type) {
	case ST_SYM_EXT:
	case ST_ARG_EXT:
	    /* can't compute symbol value for extension record */
	    /* return whatever in there                       */
	    internal_error(SYM_IS_EXT_REC , 0);
	    return 0;
	case ST_STUB:
	case ST_STUB_RELOC:
	case ST_STUB_IMPORT:
	case ST_STUB_ENTRY:
	case ST_STUB_PRI_PROG:
	case ST_STUB_SEC_PROG:
	case ST_PLABEL:
	case ST_FDP_COUNT:

	    /* 
	     * 
	     * Some stub symbols now represent "null" export stubs, 
	     * which look like export stubs but are really just pointers
	     * to the base routine, which is compiled long return and
	     * no relocation. 
	     * 
	     * In this case, we have to twiddle the value in the same
	     * way we do for the CODE symbol the stub is paired with
	     * in order to be sure that we have the correct address.
	     *
	     */

	    if ((sym->symbol_type == ST_STUB_ENTRY || 
		 sym->symbol_type == ST_STUB_PRI_PROG ||
		 sym->symbol_type == ST_STUB_SEC_PROG) &&
		sym->no_relocation && 
		sym->has_long_return) {
	       
	       temp_subspace_start = Subsp_Dict(subsp).subspace_start;
	       temp_subsp_stubs_size = Subsp_Stubs_Size(subsp);
	       temp_clear_sym_xl = ~CLEAR_SYM_XL;
	       temp_elim_delta = use_opt_sym_values ? 
		                 Sym_Misc(index).new_sym_value_delta :
				 0;
	    } else {
	       temp_subspace_start = 0;
	       temp_subsp_stubs_size = 0;
	       temp_clear_sym_xl = ~CLEAR_SYM_XL;
	       temp_elim_delta = 0;
	    }

	    break;  /* break out to generic processing below */
	case ST_STORAGE:
#ifdef TSD /* TSD */
        case ST_TSTORAGE:
#endif /* TSD */
	    if (relocatable)
	        return(sym->symbol_value);  /* sizes stay the same for -r */
	    /* otherwise fall through to process as regular subspace symbol 
	       (e.g., for a.outs and shared libraries. */
	case ST_PRI_PROG:
	case ST_SEC_PROG:
	case ST_ENTRY:
	case ST_CODE:
	case ST_MILLICODE:
	case ST_DATA:

#ifdef TSD /* TSD */
	    if (Sym_TLS(index)) {
	        if (sym->symbol_type == ST_TSTORAGE || 
		    (!(sym->symbol_type == ST_DATA && building_shlib &&
		       sym->symbol_scope == SS_UNSAT))) {
	           return sym->symbol_value;
	        }
	    }
#endif /* TSD */
	    temp_subspace_start = Subsp_Dict(subsp).subspace_start;
	    temp_subsp_stubs_size = Subsp_Stubs_Size(subsp);
	    temp_clear_sym_xl = 
		((sym->symbol_type==ST_DATA)||
		 (sym->symbol_type==ST_STORAGE)) ?
					      -1 :  ~CLEAR_SYM_XL;
	        /* if ST_STORAGE or ST_DATA then is -1 so & is a no-op */

	    /* use optimized symbol values if flag is on (after optimizing) */
            temp_elim_delta = ((use_opt_sym_values) ?
				    Sym_Misc(index).new_sym_value_delta 
				    : 0);

	    break;  /* fall through to generic processing below */
	case ST_MILLI_EXT:
            /* Just like an abs symbol except strip the privilege level */
            return(sym->symbol_value & ~CLEAR_SYM_XL);
	case ST_ABSOLUTE:
        default:
	    return(sym->symbol_value);
    }

    /* "generic" processing for the non-trivial cases */
    if (subsp == BAD_SUBSP)
	internal_error(BAD_SUBSP_SYM_VAL , 0);
    return(Subspace_Virtual_Offset(subsp) -
                   temp_subspace_start +
                   temp_subsp_stubs_size -
                   temp_elim_delta +
                   (sym->symbol_value & temp_clear_sym_xl));
} /* END symbol_value */

#ifdef DEBUG

/* Present in the DEBUG version of the linker to allow setting of   */
/* breakpoints. In the optimized version, these routines appear as  */
/* macros. 				                            */

int Sym_Remap_Type(old_index)
int old_index;
{
    int index;

    index = Sym_Remap(old_index);
    return (Sym_Dict(index).symbol_type);
} /* end Sym_Remap_Type */

int Sym_Remap_Info(old_index)
int old_index;
{
    int index;

    index = Sym_Remap(old_index);
    return (Sym_Dict(index).symbol_info);
} /* end Sym_Remap_Info */
#endif /* DEBUG */

/*************************************************************
** FUNCTION:	align_pad
**
** DESCRIPTION: find a pad length to insert before the next storage request
**		to keep it from colliding with the previously-seen large
**		storage requests in a direct-mapped cache of any multiple of
**		CACHE_MODEL_SIZE 
**
** NOTES:	
*************************************************************/

#define CACHE_MODEL_SIZE	(64*1024)	/* current smallest d-cache */
#define CACHE_LINE_SIZE		32		/* size in bytes */
#define PAD_SLOT_SIZE	(2*CACHE_LINE_SIZE)	/* pad slot size in bytes */
#define LOG2_PAD_SLOT_SIZE	6	/* log base two of PAD_SLOT_SIZE */

/* Define the address bits to compare when detecting a potential collision to
   the low-order bits of modelled cache hash function not XORed with space reg.
   Derived by examining the d-cache hash functions from the PCX-L, PCX-S, and
   PCX-T ERSes and choosing the smallest common subset of non-XORed bits. */
#define CACHE_HASH_BITS		0xfc0

/* set up check on number of padding values allowed, limiting BSS expansion.
   adversary case is when every slot gets used, forcing every storage request
   to be padded by an average of half the last slot size.  The last slot would
   represent MAX_BSS_EXPANSION_PERCENT of the smallest storage request
   considered (e.g., CACHE_MODEL_SIZE) */
#define SMALLEST_BIG_STOR_REQ	CACHE_MODEL_SIZE /* smallest considered "big" */
#define MAX_BSS_EXPANSION_PERCENT	10
#define MAX_PAD_SLOTS	((CACHE_HASH_BITS >> LOG2_PAD_SLOT_SIZE)+1)

/* number of storage requests smaller than CACHE_MODEL_SIZE to check in case
   they add up to enough to clash */
#define N_BIGGEST	10

static int align_pad (candidate_addr,
	    	      sr_size_table,
		      cur_size_table_entry,
		      first_big_stor_req)
int candidate_addr;		/* address to be used if zero pad returned */
struct symbol_dictionary_record **sr_size_table; /*sorted stor-req size tbl*/
int cur_size_table_entry;	/* index of the entry for "candidate_addr" */
int first_big_stor_req;		/* index of first entry > CACHE_MODEL_SIZE */
{
   Boolean slot_taken[MAX_PAD_SLOTS]; /* flags array representing clashes */
   int i;
   int clash_slot;
   int check_addr_limit; /* current number of plausible pad values */

   /* check that manually-computed log is correct */
   assert((PAD_SLOT_SIZE >> LOG2_PAD_SLOT_SIZE) == 1);
   /* check that bit-select cache model doesn't cause too much BSS expansion */
   assert(MAX_PAD_SLOTS	< ((MAX_BSS_EXPANSION_PERCENT*SMALLEST_BIG_STOR_REQ /
							100)/PAD_SLOT_SIZE));

   /* compute the number of plausible pad values */
   check_addr_limit = (first_big_stor_req-cur_size_table_entry+1);
   if ( check_addr_limit > MAX_PAD_SLOTS )
      check_addr_limit = MAX_PAD_SLOTS;  /* limit pad size */

   /* set all flags to FALSE */
   for (i=0; i < check_addr_limit; i++)
      slot_taken[i] = FALSE;

   /* check alignment of all previous large storage requests against current */
   for (i= first_big_stor_req; i > cur_size_table_entry; i--) {
      int addr_diff = candidate_addr - sr_size_table[i]->symbol_value;
      clash_slot = ((addr_diff & CACHE_HASH_BITS ) >> LOG2_PAD_SLOT_SIZE);
      if (clash_slot < check_addr_limit)
         slot_taken[clash_slot] = TRUE;
   }

   /* find the first pad slot that didn't collide with the candidate */
   for (i=0; i < check_addr_limit; i++)
      if(!slot_taken[i])
	 return (i * PAD_SLOT_SIZE);  /* found value that didn't clash */
   /* if no clashless pad value found, return zero to just use original addr */
   return(0);
} /* end align_pad */

#ifdef ESOM
/**********************************************************************
 * NAME: slamBss
 * PURPOSE: This is a kludge that slams bss into the bss segment.
 * INPUT:
 *   bssSubsp - bss subspace
 *   symIndex - symbol index
 * RETURNS: Nothing.
 *********************************************************************/

static int slamBss(bssSubspTmp, symIndex)
int bssSubspTmp;
int symIndex;
{
   struct subspace_dictionary_record *subsp = NULL;
   char *name;

   if ( isSPPspace(symIndex) )
	return symIndex;

   /*
    * Need to check subspace name to make sure its a spp subspace
    */
   subsp = &Subsp_Dict(symIndex);

   name = subsp->name.n_name;
   if (*name != '$' || (*(name+1) != 'F' && *(name+1) != 'N')) 
     return bssSubspTmp;

   if ( strcmp(name, "$FSBSS$") == 0 && fsBssIndex != BAD_SUBSP)
	return fsBssIndex;
   if ( strcmp(name, "$FSDATA$") == 0 && fsBssIndex != BAD_SUBSP)
	return fsBssIndex;
   if ( strcmp(name, "$FSDATA2$") == 0 && fsBssIndex != BAD_SUBSP)
	return fsBssIndex;
   if ( strcmp(name, "$NSBSS$") == 0 && nsBssIndex != BAD_SUBSP)
	return nsBssIndex;
   if ( strcmp(name, "$NSDATA$") == 0 && nsBssIndex != BAD_SUBSP)
	return nsBssIndex;
   if ( strcmp(name, "$NSDATA2$") == 0 && nsBssIndex != BAD_SUBSP)
	return nsBssIndex;
   if ( strcmp(name, "$NPBSS$") == 0 && npBssIndex != BAD_SUBSP)
	return npBssIndex;
   if ( strcmp(name, "$NPDATA$") == 0 && npBssIndex != BAD_SUBSP)
	return npBssIndex;
   if ( strcmp(name, "$NPDATA2$") == 0 && npBssIndex != BAD_SUBSP)
	return npBssIndex;
   return bssSubspTmp;
}

int
is_esom_index(index)
int index;
{
   struct subspace_dictionary_record *subsp = NULL;
   char *name;

   if ( isSPPspace(index) )
	return 1;

   /*
    * Need to check subspace name to make sure its a spp subspace
    */
   subsp = &Subsp_Dict(index);
   name = subsp->name.n_name;

   if (*name != '$' || (*(name+1) != 'F' && *(name+1) != 'N')) return 0;

   if ( strcmp(name, "$FSBSS$") == 0 )
	return 1;
   if ( strcmp(name, "$FSDATA$") == 0 )
	return 1;
   if ( strcmp(name, "$NSBSS$") == 0 )
	return 1;
   if ( strcmp(name, "$NSDATA$") == 0 )
	return 1;
   if ( strcmp(name, "$NPBSS$") == 0 )
	return 1;
   if ( strcmp(name, "$NPDATA$") == 0 )
	return 1;
   return 0;
}
#endif /* ESOM */

#ifdef ESOM
void storage_create(BSS_subsp, tbss_subsp)
int BSS_subsp; /* subspace to put storage requests into */
int tbss_subsp;
#else
#ifdef TSD /* TSD */
void storage_create(bss_subsp, tbss_subsp)
int bss_subsp;
int tbss_subsp;
#else
void storage_create (bss_subsp)
int bss_subsp; /* subspace to put storage requests into */
#endif /* TSD */
#endif /* ESOM */
{
    int i;
    struct symnode *n, *m;
    struct symnode *prevn;
    int size = 0, remap_ind, new_len;
    struct subspace_dictionary_record *subsp = NULL;
    struct symbol_dictionary_record *sym;
    Boolean has_storage = FALSE;
#ifdef ESOM
    /* 
     * Here we rename the argument so that bss_subsp can become a local 
     * variable. When we encounter symbols in non-default memory classes,
     * bss_subsp is changed to point to the BSS of that memory class for the
     * duration of processing that symbol. The value is reverted to the default
     * BSS subspace after each symbol
     */
    struct subspace_dictionary_record *BSS_ptr = NULL;
    int bss_subsp = BSS_subsp;
#endif /* ESOM */

#ifdef TSD /* TSD */
    int temp_size;
#endif /* TSD */
    struct symbol_dictionary_record **sr_size_table = NULL;/*str req size tbl*/
    int cur_size_table_entry;    
    int first_big_stor_req = 0;

    /* used by qsort for elim addil's */
    int sr_size_table_compare();    

#ifdef ESOM
    initMemIndexes();
#endif /* ESOM */

    if (sort_stor_reqs) {
	/* Initialize storage request size table */
	/* We need at MOST num_storage_requests entries (set it symbol_add) */
	sr_size_table = (struct symbol_dictionary_record **) 
			   emalloc(num_storage_requests * 
				    sizeof(struct symbol_dictionary_record *));
	cur_size_table_entry = 0;
    }

    for (i = 0; i < UNSATHASHSIZE; i++) {
        /* NO_DATA_COPY */
	prevn = NULL;
	for (n = unsat_hash_table[i]; n != NULL; ) {

	    if ((n->type != ST_STORAGE) &&
#ifdef TSD /* TSD */
		(n->type != ST_TSTORAGE) &&
#endif /* TSD */
		    (n->type != ST_DATA)) {
                /* NO_DATA_COPY */
                /*
		**  We removed code symbols from the
		** hash bucket when we unlinked a SGD node; consequently,
		** in unsat_print_list(), there are no code unsat warning
		** messages printed for those code symbols.  For this bug,
		** __iob hashed to the same bucket as some code symbols.
		** We never set the previous node in this bucket for non 
		** data/storage symbols.  In the check for unlinking an
		** entire hash bucket versus just the SGD node, we check
		** for a previous node--if there is none, we unlink the
		** bucket because we think there is only the one node in 
		** it; otherwise, we only unlink the SGD node.       
		** The fix is to save off the previous node for
		** non data/storage symbols to ensure that we only unlink
		** the SGD node.
		**
		** Note: We already save off the previous node in the
		** data/storage case so this fix only needs to be applied
		** for non data/storage symbols.
		*/
		prevn = n; 
                n = n->next;
                continue;
            }

	    assert ( (!building_shlib) || 
		     ((n->type == ST_DATA) && 
		      (Sym_Scope(n->index) ==SS_UNSAT) ) );
		     /* if building a shlib, only Data Unsats allowed, no
			storage requests */

            /* NO_DATA_COPY */
	    if (Sym_SharedGlobal (n->index)) {
		/* First, set shared_global bit on all same list nodes: */
		for (m = n->same; m != NULL; m = m->same)
		    Sym_SharedGlobal (m->index) = 1;
		/* Next, unlink from hash chain */
		if (NULL == prevn)
		    unsat_hash_table[i] = n->next;
		else
		    prevn->next = n->next;
		n = n->next;
		continue;
	    }
	    prevn = n;

	    /* run down "same" list looking for storage requests */
	    for (m = n; m != NULL; m = m->same) {
#ifdef TSD /* TSD */
	        if (m->type == ST_TSTORAGE ||
		    m->type == ST_STORAGE) {
#else
	        if (m->type == ST_STORAGE) {
#endif /* TSD */
	            has_storage = TRUE;
		    assert (m->index != BAD_SYM);
 		    remap_ind = m->index;
		    break;  /* remap to first found */
    		} /* end if m->type == ST_STORAGE */
	    } /* end for m = m->same */

	    if (!has_storage) {
 	        n = n->next;
 	        continue;			
	    }
	    has_storage = FALSE;
	    sym = &Sym_Dict(remap_ind);

#ifdef TSD /* TSD */
	    if (m->type == ST_TSTORAGE) {
	       Sym_TLS(remap_ind) = TRUE;
	    }
#endif /* TSD */

	    /* get pointer to the $BSS$ subspace */
#ifndef ESOM
	    if (subsp == NULL) {
#ifdef TSD /* TSD */
	        if (m->type == ST_STORAGE) {
#endif /* TSD */
		if (bss_subsp == BAD_SUBSP)
		    external_error(CANT_FIND_BSS , 0);
		subsp = &Subsp_Dict(bss_subsp);
#ifdef TSD /* TSD */
	        }
#endif /* TSD */
	    }
#else /* ESOM */
	    if (BSS_ptr == NULL) {
		if (BSS_subsp == BAD_SUBSP)
		    external_error(CANT_FIND_BSS , 0);
		subsp = BSS_ptr = &Subsp_Dict(BSS_subsp);
	    }
#endif /* ESOM */

	    /* change the type to DATA */
 	    sym->symbol_type = ST_DATA;

  	    /* change the UNSAT to UNIV */
	    sym->symbol_scope = SS_UNIVERSAL;
	     
	    /* resolve storage requests and get the size */
	    /* The assumption made here is that these routines do not */
	    /* rely on the sym info field being a valid subspace */
	    /* (see sorting storage requests below). */
	    size = 0;
	    univ_add(n->name,
		     n->mq,
		     Sym_Qual_Name(n->index),
		     n->hashval,
		     remap_ind,
		     ST_DATA);

#ifdef TSD /* TSD */
            if (Sym_TLS(remap_ind)) {
               unsat_resolve(n->name,
			     n->mq,
			     Sym_Qual_Name(n->index),
			     n->hashval,
			     remap_ind,
			     ST_TSTORAGE,
			     &size);
	       Sym_Subsp(remap_ind) = tbss_subsp;
	    } else {
#endif /* TSD */

	    unsat_resolve(n->name,
			  n->mq,
			  Sym_Qual_Name(n->index),
			  n->hashval,
			  remap_ind,
			  ST_STORAGE,
			  &size);

	    /* Associate the symbol with the BSS subspace (updates sym misc) */
#ifndef ESOM
	    Sym_Subsp(remap_ind) = bss_subsp;
#else
	    subsp = &Subsp_Dict(Sym_Subsp(remap_ind));
	    bss_subsp = Sym_Subsp(remap_ind) = slamBss(bss_subsp,
						       Sym_Subsp(remap_ind));
	    subsp = &Subsp_Dict(bss_subsp);
#endif /* ESOM */
#ifdef TSD /* TSD */
	    }

	    /* doom support */
	    lm_bss_symbol_add(remap_ind, size);
	   

            if (sort_stor_reqs && (! Sym_TLS(remap_ind))) {
#else
            if (sort_stor_reqs) {
#endif /* TSD */
		/* put sym and size needed in table and then sort below */
                sr_size_table[cur_size_table_entry++] = sym;

		/* NOTE: temporarily we use the sym_info field to hold the */
		/* size we want; Sym_info is set below to the BSS subspace. */
		sym->symbol_value = size;
  	    } else {
#ifdef TSD /* TSD */
	        if (Sym_TLS(remap_ind)) {
#ifdef DEBUG /* DEBUG */
		   if (verbose & V_TSD) {
		      printf("sym should be common %s\n", 
			     Sym_Name(remap_ind));
		   }
#endif /* DEBUG */
		   temp_size = m->len;
#ifdef DEBUG /* DEBUG */
		   if (verbose & V_TSD) {
                      printf("TLS Common %s size %d\n", Sym_Name(remap_ind), 
                             temp_size); 
		   }
#endif /* DEBUG */

                   sym->symbol_info = tbss_subsp;

#if 0 /* OLD CODE */
		   new_len = temp_size + tbss_size;

		   if (temp_size >= 2) {
		      if (temp_size == 2) 
			 tbss_size = round(tbss_size, 2);
		      else if (temp_size <= 4)
			 tbss_size = round(tbss_size, 4);
                      else if (temp_size >= page_size) {
                         Subsp_Dict(tbss_subsp).alignment = 32;
			 tbss_size = round(tbss_size, 32);
                      } else 	    
			 tbss_size = round(tbss_size, 8);
		   }
		   
		   new_len = temp_size + tbss_size;
		   sym->symbol_value = tbss_size;
		   tbss_size = new_len;
#endif /* OLD CODE */

		   if (temp_size >= 2) {
		      if (temp_size == 2) 
			 tbss_size = round(tbss_size, 2);
		      else if (temp_size <= 4)
			 tbss_size = round(tbss_size, 4);
                      else if (temp_size >= page_size) {
                         Subsp_Dict(tbss_subsp).alignment = 32;
			 tbss_size = round(tbss_size, 32);
                      } else 	    
			 tbss_size = round(tbss_size, 8);
		   }
		   
		   new_len = temp_size + tbss_size;
		   sym->symbol_value = tbss_size;
		   tbss_size = new_len;
#ifdef DEBUG /* DEBUG */
		   if (verbose & V_TSD) {
                      printf("TLS Common %s allocated at %d\n", 
			     Sym_Name(remap_ind), sym->symbol_value); 
		      printf("new TLS size %d\n", tbss_size); 
		   }
#endif /* DEBUG */
                } else {
#endif /* TSD */
	        sym->symbol_info = bss_subsp;

#ifdef ESOM
		if ( bss_subsp != BSS_subsp ) {
		    if ( Subsp_Dict(bss_subsp).alignment != 4096 )
			Subsp_Dict(bss_subsp).alignment == 4096;
		}
#endif /* ESOM */

	        /* set offset to end of subspace and update */
	        /*  the subspace length */
	        new_len = subsp->subspace_length;
	        if (size >= 2) {
		    if (size == 2)
                        new_len = round(new_len, 2);
		    else if (size <= 4)
                        new_len = round(new_len, 4);
#ifdef ESOM
		    else if (size <= 8 )
                        new_len = round(new_len, 8);
		    else if (size <= 32 )
                        new_len = round(new_len, 32);
	            else if (size >= page_size) {
		    	/* cache-line align large items to help adjacent items
		       	   accessed near-randomly  */
			if ( Subsp_Dict(bss_subsp).alignment != 4096 )
		    	    Subsp_Dict(bss_subsp).alignment = 64;
		    	new_len = round(new_len, 64);
		    }
		    else
			new_len = round(new_len, 64);
#else
	            else if (size >= page_size) {
		    	Subsp_Dict(bss_subsp).alignment = 32;
		    	new_len = round(new_len, 32);
                    } else 	    
			new_len = round(new_len, 8);
#endif /* ESOM */
		}
	        sym->symbol_value = new_len + 
				    Subspace_Virtual_Offset(bss_subsp);
	        subsp->subspace_length = new_len + size;
#ifdef DEBUG
		if (verbose & V_COMMONS) {
		  printf ("Common %s allocated at %08x in $BSS$(%08x)\n",
			  sym->name.n_name, sym->symbol_value,
			  Subspace_Virtual_Offset(bss_subsp));
		}		     
#endif /* DEBUG */
#ifdef TSD /* TSD */
	       }
#endif /* TSD */
	    }
    
	    /*
	    ** since unsat_resolve tampers with the hash chain
	    **  we need to start all over on it 
	    */

	    n = unsat_hash_table[i];

            /* NO_DATA_COPY 
	    ** We also need to reset 'prevn', since it otherwise points
	    ** to an unlinked node. 
	    */
	    prevn = NULL;
#ifdef ESOM
	    bss_subsp = BSS_subsp;
	    subsp = BSS_ptr;
#endif /* ESOM */
	}
    }

#ifdef TSD /* TSD */
    if (sort_stor_reqs && cur_size_table_entry > 0) {
#else
    if (sort_stor_reqs) {
#endif /* TSD */
	/* Sort storage request size array by size and then build bss subsp*/
	qsort(sr_size_table, 
	      cur_size_table_entry, 
	      sizeof(struct symbol_dictionary_record *), 
	      sr_size_table_compare);

	/* Now build BSS in order of size */
	for (--cur_size_table_entry; cur_size_table_entry >= 0 ; 
	      --cur_size_table_entry) {

	    sym = sr_size_table[cur_size_table_entry];  /*get next stor req */
	    size = sym->symbol_value;  
            if (verbose & V_OPT1) {
		printf(ld_gets(1, 
			       1223, 
			       "storage request - symbol %s, size %d,"
				   " subsp %d\n"), 
		       sym->name.n_name, size,
		       sym->symbol_info);
	    }

	    /* Associate the symbol with the BSS subspace */
	    sym->symbol_info = bss_subsp;

	    /* set offset to end of subspace and update
	     *  the subspace length */
	    new_len = subsp->subspace_length;
	    if (size >= 2) {
	        if (size == 2)
		    new_len = round(new_len, 2);
	        else if (size <= 4)
		    new_len = round(new_len, 4);
	        else if (size >= page_size) {
		    /* cache-line align large items to help adjacent items
		       accessed near-randomly  */
#ifdef ESOM
		    if (Subsp_Dict(bss_subsp).alignment != 4096)
#endif /* ESOM */
			Subsp_Dict(bss_subsp).alignment = 32;
		    new_len = round(new_len, 32);
		} else
		    new_len = round(new_len, 8);
	    }

	    /* 
	    ** if big enough to wrap around the cache by itself, or for the
	    ** biggest N storage requests that are big enough to not fit in
	    ** the same pad slot (e.g., two cache lines), check for direct-map
	    ** cache collisions and pad to break the collision. 
	    */
	    if ((size > SMALLEST_BIG_STOR_REQ) ||
		((cur_size_table_entry < N_BIGGEST) &&
		 (size > PAD_SLOT_SIZE))) {
	       if (first_big_stor_req == 0)
		  first_big_stor_req = cur_size_table_entry;
	       else
	          new_len += align_pad(
				new_len+Subspace_Virtual_Offset(bss_subsp),
	    			sr_size_table,
				cur_size_table_entry,
		  		first_big_stor_req);
	    }

	    sym->symbol_value = new_len + Subspace_Virtual_Offset(bss_subsp);
	    subsp->subspace_length = new_len + size;
#ifdef DEBUG
	    if (verbose & V_COMMONS) {
	      printf ("Common %s allocated at %08x in $BSS$(%08x)\n",
		      sym->name.n_name, sym->symbol_value,
		      Subspace_Virtual_Offset(bss_subsp));
	    }		     
#endif /* DEBUG */
	}
	
	/* cleanup space used for sorting syms */
	efree(sr_size_table);
    }

    if (subsp != NULL)
	subsp->subspace_length = round(subsp->subspace_length,4);

} /* end storage_create() */

int sr_size_table_compare(sym1, sym2)
struct symbol_dictionary_record **sym1, **sym2;
{
    /* 
    ** The info field holds the size of the storage request (see above) 
    ** The list will be decreasing by size 
    */

    int diff = ( (*sym2)->symbol_value - (*sym1)->symbol_value );   
    if (diff != 0)
	return(diff);

    /* 
    ** if same size, use original subspace as secondary key 
    ** will tend to make stor reqs from a .o end up on the same cache line. 
    */
    return((*sym2)->symbol_info - (*sym1)->symbol_info);   
} /* end sr_size_table_compare */
