/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Definitions for Utility Routines
 *
 */

/* FILE --pschwan@thepuffingroup.com */
#define __need_FILE
#include <stdio.h>
#undef __need_FILE

#ifndef DEBUG
  /* if not debug then call free directly, if DEBUG then call stub routine
     in util.c */
#define efree           free
#endif /* !DEBUG */

#include "sgs.h"

# if 0
/* optimization pragmas to enhance optimization */
/* error routines that don't return - callers can be compiled safely assuming 
   values promoted to registers won't be changed */
#pragma NO_SIDE_EFFECTS system_error, user_error, internal_error, external_error
#pragma NO_SIDE_EFFECTS external_error_hex, external_error_n, external_error_sn
# endif

#pragma ALLOCS_NEW_MEMORY malloc, emalloc, calloc, ecalloc
extern char		*emalloc(int size);
extern char		*ecalloc(int cnt, int size);
extern char		*erealloc(char *ptr, int newsize);
extern void		free(void *ptr);
extern FILE 		*efopen(char *filename, 
				char *permissions, 
				int error_num);

extern FILE 		*stdoutfopen (char *filename, 
				      char *permissions, 
				      int error_num);

#ifdef INSTRUMENT_MALLOC
#define emalloc(x)    iemalloc(x,__FILE__,__LINE__); \
                      { static int instrument_mal_tot_size, \
				   instrument_mal_count; \
			static Boolean first=1; \
			if (first) { \
			  record_site(&instrument_mal_tot_size, \
			       &instrument_mal_count,__FILE__,__LINE__,'M'); \
			  first=FALSE; \
                        } \
			instrument_mal_count++; \
			instrument_mal_tot_size+=x; \
		      }
#define ecalloc(x,y)  iecalloc(x,y,__FILE__,__LINE__); \
                      { static int instrument_mal_tot_size, \
			       instrument_mal_count; \
			static Boolean first=1; \
			if (first) { \
			  record_site(&instrument_mal_tot_size, \
			      &instrument_mal_count,__FILE__,__LINE__,'C'); \
			  first=FALSE; \
                        } \
			instrument_mal_count++; \
			instrument_mal_tot_size+=((x)*(y)); \
		      }
#define erealloc(x,y) ierealloc(x,y,__FILE__,__LINE__); \
                      { static int instrument_mal_tot_size, \
				   instrument_mal_count; \
			static Boolean first=1; \
			if (first) { \
			  record_site(&instrument_mal_tot_size, \
			       &instrument_mal_count,__FILE__,__LINE__,'R'); \
			  first=FALSE; \
                        } \
			instrument_mal_count++; \
			instrument_mal_tot_size=y; \
		      }
#define efree(x)      iefree(x,__FILE__,__LINE__); \
                      { static int instrument_mal_tot_size, \
				   instrument_mal_count; \
			static Boolean first=1; \
			if (first) { \
			  record_site(&instrument_mal_tot_size, \
				&instrument_mal_count,__FILE__,__LINE__,'F'); \
			  first=FALSE; \
                        } \
			instrument_mal_count++; \
		      }
#endif /* INSTRUMENT_MALLOC */

extern unsigned int	checksum();

/* This macro will round a number up to an even multiple of the base.
   If the number is already a multiple of the base, it will not be changed.  

   Note: The base must be an even power of 2 for this macro to work.  
*/

#ifdef DEBUG
extern unsigned int	round_Check();
#define Base_Chk(number,base,result)    round_Check(number,base,result) 
#else
#define Base_Chk(number,base,result)    (result)
#endif  /* DEBUG */
#define round(number, base)	Base_Chk(number, \
					 base,   \
					 (((number) + (base-1)) & ~(base-1)))

extern int		ffetch();
extern void		fdump();
extern void             flush_fdump_buffer();

extern void		print_total_sizes();

extern void		user_error();
extern void		system_error();
extern void		internal_error();
extern void		external_error();
extern void		external_error_n();
extern void		external_error_sn();
extern void		warning();
extern void		warning_continue();
extern void		warning_continue_n();

extern Boolean		prefix();

#define TIME_START(rstart,pstart) \
	if (verbose & V_TIMES) {rstart=times(&pstart);}
#define TIME_STOP(rstart,rstop,pstart,pstop,id_string,clk_tck) \
	if (verbose & V_TIMES) { \
	  rstop=times(&pstop); \
	  printf(id_string);	\
	  printf(" %d s. real, %d s. user %d s. sys\n", \
		 (rstop-rstart)/clk_tck, \
		 (pstop.tms_utime - pstart.tms_utime)/clk_tck, \
		 (pstop.tms_stime - pstart.tms_stime)/clk_tck); \
        }

#define ANALYZE_LARGE_FILE_ERROR(FILE_NAME_P) \
    { \
       if (errno == EOVERFLOW) { \
          system_error(CANT_OPEN, FILE_NAME_P, 0); \
       } \
    }

/* Function prototypes */

extern char *ld_gets(int set_num, int msg_num, const char *default_msg);
extern void iefree(void *ptr, char *filenm,int lineno);
extern void efree(void *ptr);

extern int fdump_autoalign;
#define set_fdump_autoalign()    { fdump_autoalign = TRUE; }
#define clear_fdump_autoalign()  { fdump_autoalign = FALSE; }
