/**************************************************************/
/* pg_defs.c                                                  */
/*                                                            */
/*                                                            */
/* This file contains functions to replace the defines in the */
/* file called pgtable.h.  In this way we get around the GNU  */
/* compiler extentions.                                       */
/**************************************************************/

#include <asm/ptrace.h>
#include <asm/processor.h>

pte_t mk_pte(unsigned long page, pgprot_t pgprot)
{
        pte_t j;
#ifdef STRICT_MM_TYPECHECKS
        j.pte = __pa(page) + pgprot_val(pgprot);
#endif /* STRICT_MM_TYPECHECKS */
#ifdef OUT
        j = __pa(page) + pgprot_val(pgprot);
#endif /* OUT */
        return( j );
}
