;-------------------------------------------------------------------
; atomic.s
;
; Author: J. Curry
;
; The routines below form the core counting semaphores.
;
;-------------------------------------------------------------------

	
		.SPACE  $TEXT$
		.subspa $CODE$

		.align 32


;-------------------------------------------------
; atomic_read(lock)
;
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT atomic_read,ENTRY
atomic_read
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem6	ldcw   	8(%sr0,%arg0),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem6
		nop
		sync
		nop
		nop

		;2nd grab counter value
		ldw	4(%sr0,%arg0),%r28 

		;3rd reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		.LEAVE
		.PROCEND

;-------------------------------------------------
; atomic_set(lock,i) Assume semahpre being initialized.
;
; i = value (int)
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT atomic_set,ENTRY
atomic_set
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st set counter value
		stw     %arg1,4(%sr0,%arg0)
		fdc     (%sr0,%arg0)
		sync
		nop
		nop

		;2nd init semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		.LEAVE
		.PROCEND


;-------------------------------------------------
; atomic_add(i,lock)
;
; i = value to add to count
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_add,ENTRY
atomic_add
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem
		nop
		sync
		nop
		nop

		;2nd grab counter value
		ldw	4(%sr0,%arg1),%r28 

		;3rd add value to count
		add	%arg0,%r28,%r28	;add value 

		;4th store value back
		stw	%r28,4(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		;5th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg1)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		.LEAVE
		.PROCEND


;-------------------------------------------------
; atomic_sub(i,lock)
;
; i = value to add to count
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_sub,ENTRY
atomic_sub
		.PROC
		.CALLINFO NO_CALLS
		.ENTER


		;1st grab semaphore
		ldi	0,%r28
grab_csem2	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem2
		nop
		sync
		nop
		nop

		;2nd grab counter value
		ldw	4(%sr0,%arg1),%r28 

		;3rd subtract value to count
		sub	%arg0,%r28,%r28	;subtract value 

		;4th store value back
		stw	%r28,4(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		;5th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		.LEAVE
		.PROCEND


;-------------------------------------------------
; atomic_inc_return(lock)
;
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_inc_return,ENTRY
atomic_inc_return
;-------------------------------------------------
; atomic_inc(lock)
;
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_inc,ENTRY
atomic_inc
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem3	ldcw   	8(%sr0,%arg0),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem3
		nop
		sync
		nop
		nop

		;2nd grab counter value, increment
		ldw	4(%sr0,%arg0),%r28 
		addi	1,%r28,%r28	;increment counting semaphore

		;3rd store value back
		stw	%r28,4(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		;4th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		.LEAVE
		.PROCEND


;-------------------------------------------------
; atomic_dec_return(lock)
;
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_dec_return,ENTRY
atomic_dec_return
;-------------------------------------------------
; atomic_dec(lock)
;
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_dec,ENTRY
atomic_dec
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem4	ldcw   	8(%sr0,%arg0),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem4
		nop
		sync
		nop
		nop

		;2nd grab counter value, decrement
		ldw	4(%sr0,%arg0),%r28 
		addi	-1,%r28,%r28	;decrement counting semaphore

		;3rd store value back
		stw	%r28,4(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		;4th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg0)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop


		.LEAVE
		.PROCEND

;-------------------------------------------------
; atomic_clear_mask(i,lock)
;
; i = mask value 
; lock = addr of semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_clear_mask,ENTRY
atomic_clear_mask
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		ldi	0,%r28
grab_csem5	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem5
		nop
		sync
		nop
		nop
		and	%arg0,%r28,%r28	;AND the mask with the contents
		stw	%r28,8(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		.LEAVE
		.PROCEND

;-------------------------------------------------
; atomic_set_mask(i,lock)
;
; i = mask value 
; lock = addr of semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_set_mask,ENTRY
atomic_set_mask
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		ldi	0,%r28
grab_csem7	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem7
		nop
		sync
		nop
		nop
		or	%arg0,%r28,%r28	;OR the mask with the contents
		stw	%r28,8(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		.LEAVE
		.PROCEND


;-------------------------------------------------
; atomic_add_return(i,lock)
;
; i = value to add to count
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_add_return,ENTRY
atomic_add_return
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem10	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem10
		nop
		sync
		nop
		nop

		;2nd grab counter value
		ldw	4(%sr0,%arg1),%r28 

		;3rd add value to count
		add	%arg0,%r28,%r28	;add value 

		;4th store value back
		stw	%r28,4(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		;5th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg1)
		fdc	(%sr0,%arg0)
		sync
		nop
		nop

		.LEAVE
		.PROCEND

;-------------------------------------------------
; atomic_sub_return(i,lock)
;
; i = value to add to count
; lock = addr of counting semaphore (uint)
;-------------------------------------------------
		.EXPORT atomic_sub_return,ENTRY
atomic_sub_return
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		;1st grab semaphore
		ldi	0,%r28
grab_csem11	ldcw   	8(%sr0,%arg1),%r28
		nop
		cmpib,*=,n	0,%r28,grab_csem11
		nop
		sync
		nop
		nop

		;2nd grab counter value
		ldw	4(%sr0,%arg1),%r28 

		;3rd subtract value to count
		sub	%arg0,%r28,%r28	;subtract value 

		;4th store value back
		stw	%r28,4(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop

		;5th reset semaphore
		ldi	-1,%r29
		stw	%r29,8(%sr0,%arg1)
		fdc	(%sr0,%arg1)
		sync
		nop
		nop


		.LEAVE
		.PROCEND

