	.space $TEXT$
	.subspa $CODE$
	
	.import	intr_save,entry
	.import	intr_extint,entry 
	.import intr_break,entry 

	.align 2048
	.export fault_vector, entry
	
fault_vector
	;draft this null vector for use with HPMC handler
	mtctl		%r1,%cr28
	ldo		1(0), %r1
	b		intr_save
	mtctl		 %r1,%cr29
	nop
	nop
	nop
	nop
	.align 32

	;* High priority machine check (HPMC) (1) */
	b,n             .-32                    ;goto hpmc handler above
        .word           0x17e0e049              ;comp of b .-32 for 0 cksum
        .word           0
        .word           0
        .word           0
        .word           0
        .word           0                       ;0 address
        .word           0                       ;0 length

	;* Power failure (2) */
	b		intr_save
	ldo		 2(0), %r1
	.align 32
	
	;* Recovery counter trap (3) */
	b		intr_save
	ldo		 3(0), %r1
	.align 32

	;* External interrupt (4) */
	mfctl		%cr23, %r1	;read eirr
	mtctl		 %r1,%cr23	;clear pending ext intr
	b		intr_extint	
	mtctl		 %r1,%cr29
	.align 32

	;* Low-priority machine check (5) */
	b		intr_save
	ldo		 5(0), %r1
	.align 32

	;* Instruction TLB miss fault (6) */
	b		intr_save
	ldo		 6(0), %r1
	.align 32

	;* Instruction memory protection trap (7) */
	b		intr_save
	ldo		 7(0), %r1
	.align 32

	;* Illegal instruction trap (8) */
	b		intr_save
	ldo		 8(0), %r1
	.align 32

	;* Break instruction trap (9) */
	b		intr_break ;temp. comment out
	mfctl		%cr19, %r1
	.align 32

	;* Privileged operation trap (10) */
	b		intr_save
	ldo		10(0), %r1
	.align 32

	;* Privileged register trap (11) */
	b		intr_save
	ldo		11(0), %r1
	.align 32

	;* Overflow trap (12) */
	b		intr_save
	ldo		12(0), %r1
	.align 32

	;* Conditional trap (13) */
	b		intr_save
	ldo		13(0), %r1
	.align 32

	;* Assist exception trap (14) */
	b		intr_save
	ldo		14(0), %r1
	.align 32

	;* Data TLB miss fault (15) */
	b		intr_save
	ldo		15(0), %r1
	.align 32

	;* Instruction TLB non-access miss fault (16) */
	b		intr_save
	ldo		16(0), %r1
	.align 32

	;* Data TLB non-access miss fault (17) */
	b		intr_save
	ldo		17(0), %r1
	.align 32

	;* Data memory protection trap/unaligned data reference trap (18) */
	b		intr_save
	ldo		18(0), %r1
	.align 32

	;* Data memory break trap (19) */
	b		intr_save
	ldo		19(0), %r1
	.align 32

	;* TLB dirty bit trap (20) */
	b		intr_save
	ldo		20(0), %r1
	.align 32

	;* Page reference trap (21) */
	b		intr_save
	ldo		21(0), %r1
	.align 32

	;* Assist emulation trap (22) */
	b		intr_save
	ldo		22(0), %r1
	.align 32

	;* Higher-privilege transfer trap (23) */
	b		intr_save
	ldo		23(0), %r1
	.align 32

	;* Lower-privilege transfer trap (24) */
	b		intr_save
	ldo		24(0), %r1
	.align 32

	;* Taken branch trap (25) */
	b		intr_save
	ldo		25(0), %r1
	.align 32

	;* Data memory acess rights trap (26) 
	b		intr_save
	ldo		26(0), %r1
	.align 32

	;* Data memory protection ID trap (27) 
	b		intr_save
	ldo		27(0), %r1
	.align 32

	;* Unaligned data reference trap (28) 
	b		intr_save
	ldo		28(0), %r1
	.align 32

	; Performance monitor trap
	b		intr_save
	ldo		29(0), %r1
	.align 32
