/*------------------------------------------------------------------------------
 * Native PARISC/Linux Project (http://www.puffingroup.com/parisc)
 *
 * interruption handling code
 *  (C) 1999 Philipp Rumpf 
 *  (C) 1999 SuSE GmbH Nuernberg 
 *    author: Philipp Rumpf, prumpf@suse.de */

#include <asm/offset.h>

;the following is the setup i think we should follow:
;* whenever the CPU is interruptible, the following has to be true:
;*  CR30 is the kernel sp or 0 if we currently use the kernel stack
;*  CR31 is the kernel gp 

;Maybe this is more accurate:
;
;CR30 = ptr to current task structure for the currently running task 
; OR
;if CR30 = 0, then current sp points to the kernel stack.
;also:
;cr24 holds the ptr to the register structure on the kernel stack.

;* we have the following possibilities to act on an interruption:
;*  - handle in assembly and use shadowed registers only
;*  - save registers to kernel stack and handle in assembly or C 

        .space		$TEXT$
	.subspa		$CODE$

	.import		handle_interruption,entry
	.import		swapper_pg_dir,data
	.import		do_irq_mask,entry
	.import         cpu_irq_region,data
	.IMPORT 	init_task_union,DATA
	.import		handle_break,entry
	.IMPORT 	__gp, DATA
#ifdef OUT_ORG_LINUX
	.import		parisc_stopkernel,code

#define tophys(x,y)	copy	(x),(y)
#define tovirt(x,y)	copy	(x),(y)	


	sp	=	30
	gp	=	27
	ipsw	=	22

#endif /* OUT_ORG_LINUX */

callee_save	.macro
	ldo	192(%r30),%r30
	std	%r3,-192(%r30)	;
	std	%r4,-184(%r30)	;
	std	%r5,-176(%r30)	;
	std	%r6,-168(%r30)	;
	std	%r7,-160(%r30)	;
	std	%r8,-152(%r30)	;
	std	%r9,-144(%r30)	;
	std	%r10,-136(%r30)	;
	std	%r11,-128(%r30)	;
	std	%r12,-120(%r30)	;
	std	%r13,-112(%r30)	;
	std	%r14,-104(%r30)	;
	std	%r15,-96(%r30)	;
	std	%r16,-88(%r30)	;
	std	%r17,-80(%r30)	;
	std	%r18,-72(%r30)	;
		.endm

callee_rest	.macro
	ldd	-72(%r30),%r18	;
	ldd	-80(%r30),%r17	;
	ldd	-88(%r30),%r16	;
	ldd	-96(%r30),%r15	;
	ldd	-104(%r30),%r14	;
	ldd	-112(%r30),%r13	;
	ldd	-120(%r30),%r12	;
	ldd	-128(%r30),%r11	;
	ldd	-136(%r30),%r10	;
	ldd	-144(%r30),%r9	;
	ldd	-152(%r30),%r8	;
	ldd	-160(%r30),%r7	;
	ldd	-168(%r30),%r6	;
	ldd	-176(%r30),%r5	;
	ldd	-184(%r30),%r4	;
	ldd	-192(%r30),%r3	;
		.endm

; save current contents of regs that are shadowed onto the stack temporarily
; and copy ptr to gr3
save_shdw	.macro 	ptrreg
	ldo	64(%r30),%r30	;bump stack enough to hold struct shdw_regs
	std	%r1,(%r30)	;save gr 1
	std	%r8,-8(%r30)	;save gr 8
	std	%r9,-16(%r30)	;save gr 9
	std	%r16,-24(%r30)	;save gr 16
	std	%r17,-32(%r30)	;save gr 17
	std	%r24,-40(%r30)	;save gr 24
	std	%r25,-48(%r30)	;save gr 25
	std	%r3,-56(%r30)	;save temp
	copy	ptrreg,%r3
		.endm

;save the shadowed registers using gr3 as ptr value
shdw_reg_save	.macro
	std	 %r1, PT_GR1(%r3)
	std	 %r8, PT_GR8(%r3)
	std	 %r9, PT_GR9(%r3)
	std	 %r16, PT_GR16(%r3)
	std	 %r17, PT_GR17(%r3)
	std	 %r24, PT_GR24(%r3)
	std	 %r25, PT_GR25(%r3)
		.endm

;restore the post interrupt shadow register environment
rest_shdw_post	.macro
	ldd	(%r30),%r1	;restore gr 1
	ldd	-8(%r30),%r8	;restore gr 8
	ldd	-16(%r30),%r9	;restore gr 9
	ldd	-24(%r30),%r16	;restore gr 16
	ldd	-32(%r30),%r17	;restore gr 17
	ldd	-40(%r30),%r24	;restore gr 24
	ldd	-48(%r30),%r25	;restore gr 25
	ldd	-56(%r30),%r3	;restore temp
	ldo	-64(%r30),%r30  ;bump stack back
		.endm

;setup the handle interrupt argument registers
get_intr_args	.macro 	ptrreg
	mfctl	%cr29,%r26		;arg0 Trap code value
	copy	ptrreg,%r25		;arg1 ptr to regs
	ldd	PT_IOR(ptrreg),%r24	;arg2 ior value
		.endm

;only switch to virtual mapping if trap occurred in virt mode 
virt_map_unsafe	.macro	
	mtsm	 0
	;depi	3,1,2,%r30
	mfctl	%cr22,%r1
	depdi	0,42,1,%r1		;make sure N bit off
	depdi	0,39,1,%r1		;make sure T bit off
	depdi	0,59,1,%r1		;make sure R bit off
	depdi	0,37,1,%r1		;make sure E bit off
	depdi	0,63,1,%r1		;make sure I bit off
	depdi	1,36,1,%r1		;make sure W bit on
	mtctl	%r1,%cr22
	mtctl	%r0,%cr17
	mtctl	%r0,%cr17

	;ldil	L%.+28,1
	;ldo	R%.+24(1),1
	mfia	%r1
	addi	28,%r1,%r1

	mtctl	%r1,%cr18
	ldo	4(%r1),%r1
	mtctl	%r1,%cr18
	rfi,r	;restore registers that were shadowed
	nop
	.endm

/* switch to virtual mapping clobbering only gr1 */
virt_map	.macro	
	depdi,Z	1,36,1,%r1	;just W bit on
	mtsm	 %r1
	mfctl	%cr29,%r1	;grab trap code
	cmpib,*=,n 6,%r1,.+20	;if Itlb miss go real
	cmpib,*=,n 0xf,%r1,.+16 ;if Dtlb miss go real

	;load ipsw with Q,W,C,P, and D on
	ldil       l%0x804000E,%r1
	ldo        r%0x804000E(%r1),%r1
	b,n	   .+28

	;load ipsw with Q, and W on Do realmode if D/I TLB miss
	ldil       l%0x8000008,%r1
	ldo        r%0x8000008(%r1),%r1
	mtctl      %r1,%cr22
	mtctl	%r1,%cr22
	mtctl	%r0,%cr17
	mtctl	%r0,%cr17

	;ldil	L%.+28,1
	;ldo	R%.+24(1),1
	mfia	%r1
	addi	28,%r1,%r1

	mtctl	%r1,%cr18
	ldo	4(%r1),%r1
	mtctl	%r1,%cr18
	rfi,r	;restore registers that were shadowed
	nop
	.endm

get_stack	.macro	unique
	mtctl		%r1,%cr29	;save the trap code
	mfctl		%cr30, %r1	;see if we are in kernel or not
	cmpib,*=,n	 0, %r1, .+36	;if we're in the kernel skip following

	;at this point, r1 has the pointer to the current non-kernel task structure
	;since gr8 is shadowed, we can overwrite it at this point
	ldo             TASK_REGS(%r1),%r8	;get ptr to curr task reg state
	;;depi		0,1,2,%r8		;make sure ptr is real mode addr
	depdi		0,23,24,%r8		;make sure ptr is real mode addr
	std		%r30,PT_GR30(%r8)	;save org curr stack to curr task reg
	std		%r1,PT_CR30( %r8)	;save org cr30 to curr task reg
	std		%r27,PT_GR27(%r8)	;save org dp
	ldo		TASK_SZ_ALGN(%r1),%r30	;create a new task struc on the stack
	b		.+40		/* unconditional so predicted taken */	
	mtctl		 %r0,%cr30		;indicate we're in kernel mode

	;at this point, we put a pt_reg struc on the stack to save reg state
	copy		%r30,%r8
	copy		%r30,%r1
	ldo             PT_SZ_ALGN(%r30),%r30	;create a pt_reg struc on stack
	;;depi		0,1,2,%r8 		;make sure stack is real mode
	depdi		0,23,24,%r8		;make sure ptr is real mode addr
	depdi		0,23,24,%r30		;make sure ptr is real mode addr
	std             %r1,PT_GR30(%r8)	;save org stack
	std		%r27,PT_GR27(%r8)	;save org dp
	std		%r0,PT_CR30(%r8)	;indicate we're in kernel mode

	bl         .+8,%r27
        addil      L%__gp-unique,%r27     ;Note: __gp == $global$
unique  ldo        R%__gp-unique(%r1),%dp

	.endm

rest_stack	.macro	
	ldd		PT_CR30(%r8), %r1	;grab orig mode indicator
	cmpib,*=,n	 0, %r1, .+20	;see if we kernel or process mode

	;process mode:
	;remove temp task struc from kernel stack
	ldo		-TASK_SZ_ALGN(sp),sp 
	mtctl		sp,%cr30	;store kernel stack in cr30
	b		.+12		;skip kernel mode stuff
	ldd		PT_GR30(%r8),sp	;restore process stack

	;kernel mode:
	;remove pt_regs structure from the kernel stack	
	ldo		-PT_SZ_ALGN(sp),sp

	;all:
	;restore gr1 & gr8 to orig values
	ldd             PT_GR1(%r8), %r1
	ldd             PT_GR30(%r8), %r30
	ldd             PT_GR8(%r8), %r8
	
	.endm
	
	
;Don't save the shadowed registers, already saved elsewhere
save_general_nonshdw	.macro 	ptrreg	
	ldi	 0,%r1
	mfsp	 %sr0, %r1
	stw	 %r1, PT_SR0(ptrreg)
	mfsp	 %sr1, %r1
	stw	 %r1, PT_SR1(ptrreg)
	mfsp	 %sr2, %r1
	stw	 %r1, PT_SR2(ptrreg)
	mfsp	 %sr3, %r1
	stw	 %r1, PT_SR3(ptrreg)
	mfsp	 %sr4, %r1
	stw	 %r1, PT_SR4(ptrreg)
	mfsp	 %sr5, %r1
	stw	 %r1, PT_SR5(ptrreg)
	mfsp	 %sr6, %r1
	stw	 %r1, PT_SR6(ptrreg)
	mfsp	 %sr7, %r1
	stw	 %r1, PT_SR7(ptrreg)

	std	 %r2, PT_GR2(ptrreg)
	std	 %r3, PT_GR3(ptrreg)
	std	 %r4, PT_GR4(ptrreg)
	std	 %r5, PT_GR5(ptrreg)
	std	 %r6, PT_GR6(ptrreg)
	std	 %r7, PT_GR7(ptrreg)
	std	 %r10, PT_GR10(ptrreg)
	std	 %r11, PT_GR11(ptrreg)
	std	 %r12, PT_GR12(ptrreg)
	std	 %r13, PT_GR13(ptrreg)
	std	 %r14, PT_GR14(ptrreg)
	std	 %r15, PT_GR15(ptrreg)
	std	 %r18, PT_GR18(ptrreg)
	std	 %r19, PT_GR19(ptrreg)
	std	 %r20, PT_GR20(ptrreg)
	std	 %r21, PT_GR21(ptrreg)
	std	 %r22, PT_GR22(ptrreg)
	std	 %r23, PT_GR23(ptrreg)
	std	 %r26, PT_GR26(ptrreg)
	;;;std	 %r27, PT_GR27(ptrreg)
	std	 %r28, PT_GR28(ptrreg)
	std	 %r29, PT_GR29(ptrreg)
	/* stack pointer saved in get_stack */	
	std	 %r31, PT_GR31(ptrreg)
	.endm
	

save_general	.macro	ptrreg	
	ldi	 0,%r1
	mfsp	 %sr0, %r1
	stw	 %r1, PT_SR0(ptrreg)
	mfsp	 %sr1, %r1
	stw	 %r1, PT_SR1(ptrreg)
	mfsp	 %sr2, %r1
	stw	 %r1, PT_SR2(ptrreg)
	mfsp	 %sr3, %r1
	stw	 %r1, PT_SR3(ptrreg)
	mfsp	 %sr4, %r1
	stw	 %r1, PT_SR4(ptrreg)
	mfsp	 %sr5, %r1
	stw	 %r1, PT_SR5(ptrreg)
	mfsp	 %sr6, %r1
	stw	 %r1, PT_SR6(ptrreg)
	mfsp	 %sr7, %r1
	stw	 %r1, PT_SR7(ptrreg)

	std	 %r2, PT_GR2(ptrreg)
	std	 %r3, PT_GR3(ptrreg)
	std	 %r4, PT_GR4(ptrreg)
	std	 %r5, PT_GR5(ptrreg)
	std	 %r6, PT_GR6(ptrreg)
	std	 %r7, PT_GR7(ptrreg)
	std	 %r9, PT_GR9(ptrreg)
	std	 %r10, PT_GR10(ptrreg)
	std	 %r11, PT_GR11(ptrreg)
	std	 %r12, PT_GR12(ptrreg)
	std	 %r13, PT_GR13(ptrreg)
	std	 %r14, PT_GR14(ptrreg)
	std	 %r15, PT_GR15(ptrreg)
	std	 %r16, PT_GR16(ptrreg)
	std	 %r17, PT_GR17(ptrreg)
	std	 %r18, PT_GR18(ptrreg)
	std	 %r19, PT_GR19(ptrreg)
	std	 %r20, PT_GR20(ptrreg)
	std	 %r21, PT_GR21(ptrreg)
	std	 %r22, PT_GR22(ptrreg)
	std	 %r23, PT_GR23(ptrreg)
	std	 %r24, PT_GR24(ptrreg)
	std	 %r25, PT_GR25(ptrreg)
	;;;std	 %r27, PT_GR27(ptrreg)
	std	 %r28, PT_GR28(ptrreg)
	std	 %r29, PT_GR29(ptrreg)
	/* stack pointer saved in get_stack */	
	std	 %r31, PT_GR31(ptrreg)
	.endm

rest_general	.macro	ptrreg
	ldi	0,%r1
	ldw	PT_SR0(ptrreg), %r1
	mtsp	 %r1, %sr0
	ldw	PT_SR1(ptrreg), %r1
	mtsp	 %r1, %sr1
	ldw	PT_SR2(ptrreg), %r1
	mtsp	 %r1, %sr2
	ldw	PT_SR3(ptrreg), %r1
	mtsp	 %r1, %sr3
	ldw	PT_SR4(ptrreg), %r1
	mtsp	 %r1, %sr4
	ldw	PT_SR5(ptrreg), %r1
	mtsp	 %r1, %sr5
	ldw	PT_SR6(ptrreg), %r1
	mtsp	 %r1, %sr6
	ldw	PT_SR7(ptrreg), %r1
	mtsp	 %r1, %sr7

	ldd	PT_GR2(ptrreg), %r2
	ldd	PT_GR3(ptrreg), %r3
	ldd	PT_GR4(ptrreg), %r4
	ldd	PT_GR5(ptrreg), %r5
	ldd	PT_GR6(ptrreg), %r6
	ldd	PT_GR7(ptrreg), %r7
	ldd	PT_GR9(ptrreg), %r9
	ldd	PT_GR10(ptrreg), %r10
	ldd	PT_GR11(ptrreg), %r11
	ldd	PT_GR12(ptrreg), %r12
	ldd	PT_GR13(ptrreg), %r13
	ldd	PT_GR14(ptrreg), %r14
	ldd	PT_GR15(ptrreg), %r15
	ldd	PT_GR16(ptrreg), %r16
	ldd	PT_GR17(ptrreg), %r17
	ldd	PT_GR18(ptrreg), %r18
	ldd	PT_GR19(ptrreg), %r19
	ldd	PT_GR20(ptrreg), %r20
	ldd	PT_GR21(ptrreg), %r21
	ldd	PT_GR22(ptrreg), %r22
	ldd	PT_GR23(ptrreg), %r23
	ldd	PT_GR24(ptrreg), %r24
	ldd	PT_GR25(ptrreg), %r25
	ldd	PT_GR26(ptrreg), %r26
	ldd	PT_GR27(ptrreg), %r27
	ldd	PT_GR28(ptrreg), %r28
	ldd	PT_GR29(ptrreg), %r29
	/* stack pointer restored in rest_stack */
	ldd	PT_GR31(ptrreg), %r31
	.endm

save_specials	.macro	ptrreg	
	mfctl	%cr18, %r1
	std	 %r1, PT_IAOQ0(ptrreg)
	mtctl	 %r0,%cr18
	mfctl	%cr18, %r1
	std	 %r1, PT_IAOQ1(ptrreg)

	;don't forget the Space queues
	ldi	0,%r1	;in case space register only 32 bits
	mfctl	%cr17, %r1
	std	 %r1, PT_IASQ0(ptrreg)
	mtctl	 %r0,%cr17
	mfctl	%cr17, %r1
	std	 %r1, PT_IASQ1(ptrreg)
	mtctl	 %r0,%cr17	;make sure current IASQ's are all 0 now

	mfctl	%cr11, %r1
	std	 %r1, PT_SAR(ptrreg)

	mfctl	%cr19, %r1
	std	 %r1, PT_IIR(ptrreg)

	mfctl	%cr26, %r1
	std	 %r1, PT_CR26(ptrreg)

	mfctl	%cr27, %r1
	std	 %r1, PT_CR27(ptrreg)

	mfctl	%cr24, %r1
	std	 %r1, PT_CR24(ptrreg)

	mfctl	%cr28, %r1
	std	 %r1, PT_CR28(ptrreg)

	mfctl	%cr29, %r1
	std	 %r1, PT_CR29(ptrreg)

	;;;mfctl	%cr30, %r1
	;;;std	 %r1, PT_CR30(ptrreg)

	mfctl	%cr31, %r1
	std	 %r1, PT_CR31(ptrreg)

	mfctl	%cr22, %r1
	std	 %r1, PT_PSW(ptrreg)

	mfctl	%cr28, %r1
	std	 %r1, PT_GR1(ptrreg)

	std	%r26, PT_GR26(ptrreg)
	;mfctl	%cr29,%r26	;no longer needed

	mfctl	%cr21, %r1
	std	 %r1, PT_IOR(ptrreg)

	mfctl	%cr20, %r1
	std	 %r1, PT_ISR(ptrreg)

	mfctl	%cr20, %r1
	std	 %r1, PT_ISR(ptrreg)

	mfctl	%cr8, %r1
	std	 %r1, PT_CR_PID0(ptrreg)

	mfctl	%cr9, %r1
	std	 %r1, PT_CR_PID1(ptrreg)

	mfctl	%cr12, %r1
	std	 %r1, PT_CR_PID2(ptrreg)

	mfctl	%cr13, %r1
	std	 %r1, PT_CR_PID3(ptrreg)
	.endm

rest_specials	.macro	ptrreg
	ldd	PT_IAOQ0(ptrreg), %r1
	mtctl	 %r1,%cr18
	ldd	PT_IAOQ1(ptrreg), %r1
	mtctl	 %r1,%cr18

	;don't forget the space queues
	ldd	PT_IASQ0(ptrreg), %r1
	mtctl	 %r1,%cr17
	ldd	PT_IASQ1(ptrreg), %r1
	mtctl	 %r1,%cr17

	ldd	PT_SAR(ptrreg), %r1
	mtctl	 %r1,%cr11

	ldd	PT_CR26(ptrreg), %r1
	mtctl	 %r1,%cr26

	ldd	PT_CR27(ptrreg), %r1
	mtctl	 %r1,%cr27

	ldd	PT_CR28(ptrreg), %r1
	mtctl	 %r1,%cr28

	ldd	PT_CR29(ptrreg), %r1
	mtctl	 %r1,%cr29

	;;;ldd	PT_CR30(ptrreg), %r1
	;;;mtctl	 %r1,%cr30

	ldd	PT_CR31(ptrreg), %r1
	mtctl	 %r1,%cr31

	ldd	PT_CR25(ptrreg), %r1
	mtctl	 %r1,%cr25

	ldd	PT_CR24(ptrreg), %r1
	mtctl	 %r1,%cr24

	ldd	PT_PSW(ptrreg), %r1
	mtctl	 %r1,%cr22

	ldd	PT_CR_PID0(ptrreg), %r1
	mtctl	 %r1,%cr8

	ldd	PT_CR_PID1(ptrreg), %r1
	mtctl	 %r1,%cr9

	ldd	PT_CR_PID2(ptrreg), %r1
	mtctl	 %r1,%cr12

	ldd	PT_CR_PID3(ptrreg), %r1
	mtctl	 %r1,%cr13

	.endm

#define INT_PSW		0x0


;------------------------------------
; function: __kernel_thread
;
;this function forces a break trap &
;causes the break handler to launch a
;new thread.
;------------------------------------
	.export __kernel_thread, entry
__kernel_thread
	.word   0x00000001	;break 1, indicate a do fork
	nop
	nop
	nop
	nop

	bv      0(%r2)		;return
	nop
;----------------------------------------------------------
;----------------------------------------------------------
; struct task_struct *_switch_to(struct task_struct *prev,
;		struct task_struct *next)
;----------------------------------------------------------
	.export _switch_to, entry
_switch_to
	.PROC
	.CALLINFO FRAME=128,CALLS,SAVE_RP,ENTRY_GR=18
	.ENTER

	std	%r2,-24(%r30)

	callee_save

swto1	mfia	%r2
	addil	L'_switch_to_ret-swto1,%r2
	ldo	R'_switch_to_ret-swto1(%r1),%r2

	std	%r2,TASK_PT_KPC(%r26)
	ldd	TASK_PT_KPC(%r25),%r2
	ldd	16(%r2),%r2

	std	%r30, TASK_PT_KSP(%r26)
	ldd	TASK_PT_KSP(%r25),%r30
	depdi	0,33,2,%r30 ;convert stack to real addr

	bv	(%r2)
	nop

_switch_to_ret
	callee_rest

	ldd	-24(%r30),%r2
	copy	%r26, %r28

	.LEAVE
	.PROCEND
;----------------------------------------------------------

;----------------------------------------------------------
;----------------------------------------------------------
	.export ret_from_kernel_thread, entry
ret_from_kernel_thread
	ldo	TASK_REGS-TASK_SZ_ALGN(%r30),%r8

	;skip over break,1 instruction 
	;on return to __kernel_thread
	ldd	PT_IAOQ1(%r8), %r1
	std	%r1, PT_IAOQ0(%r8)

	rest_general %r8

	rsm	 9, 0

	rest_specials %r8

	;;;;;;;;;!!!!mtctl    0,%cr30	

	rfi
	nop
;----------------------------------------------------------

;----------------------------------------------------------
;----------------------------------------------------------
	.export ret_from_fork, entry
ret_from_fork
	ldo	TASK_REGS-TASK_SZ_ALGN(%r30),%r8

	;setup so this thread returns to the ret ptr addr
	ldd	PT_GR2(%r8), %r1	;grab return addr
	std	%r1,PT_IAOQ0(%r8)	;set it in offset queue F
	std	%r1,PT_IAOQ1(%r8)	;set it in offset queue B

	;nullify next instruction (set N bit)
	ldd	PT_PSW(%r8), %r1
	;depi	1,10,1,1
	depdi	1,42,1,%r1	;set N bit
	std	%r1,PT_PSW(%r8)

	rest_general %r8

	rsm	 9, 0

	rest_specials %r8

	rest_stack

	rfi
	nop
;----------------------------------------------------------

	.export pdc_call_x, entry
pdc_call_x
	copy	 %r2, %r3
	;;depi	0,1,2,%r30
	depdi		0,23,24,%r8		;make sure ptr is real mode addr


;***********************************
; Kludge: equivalent code helps compiler
;***********************************
	ldil    L%pdc_call_x_int, %r1
	ldo	R%pdc_call_x_int(%r1),%r1
	;;;ldil	L%0xc0000000,%r28
	;;;ldo	R%0xc0000000(%r28),%r28
	;;;sub	%r1,%r28,%r1
	ldil	L%pdc_call_x_ret, %r2
	ldo	R%pdc_call_x_ret(%r2),%r2
	;;;sub	%r2,%r28,%r2
	ldi     0,%r28

	mtsm	0
	mtctl	0,%cr17
	mtctl	0,%cr17
	mtctl	%r1,%cr18
	ldo	4(%r1),%r1
	mtctl	%r1,%cr18
	ldo	8(0),%r1
	mtctl	%r1,%cr22
	rfi
	nop
pdc_call_x_int	
	ldw	0x3c8(0), %r1
	bv,n	0(%r1)

pdc_call_x_ret
	;;;depi	3,1,2,%r30
	copy	 %r3, %r2
	mtsm	0
	mtctl	0,%cr17
	mtctl	0,%cr17
	mtctl	%r2,%cr18
	ldo	4(%r2),%r2
	mtctl	%r2,%cr18
	ldil	L%0x4000b, %r1
	ldo	R%0x4000b(%r1),%r1
	mtctl	%r1,%cr22
	rfi
	nop
	
	/* CR28 - saved GR1
	 * CR29 - argument for do_irq_mask */

	.export intr_break,entry
intr_break
	get_stack break1

	save_specials %r8

	save_shdw %r8

	virt_map
intr_br_handle
	nop	; FIXME: we _should_ return with our own PSW instead of the IPSW. if
		; IPSW{N} is set, this nop will not be executed
	nop	; uh, this one is just paranoia

	shdw_reg_save

	rest_shdw_post

	save_general_nonshdw %r8

	;save reg ptr
	mtctl	%r8,%cr24

	ldd	PT_IIR(%r8), %r26	;arg0 = IIR
	bl	handle_break,%r2
	copy	%r8,%r25		;arg1 = ptr to pt_regs
	nop

	;restore pt_reg ptr
	mfctl	%cr24,%r8

	rest_general %r8

	rsm	 9, 0

	rest_specials %r8

	rest_stack

	rfi
	nop


	/* CR28 - saved GR1
	 * CR29 - argument for do_irq_mask */

	.export intr_extint,entry
intr_extint
	get_stack extint1

	save_specials %r8

	save_shdw %r8

ext1	mfia    %r1
	ldo     intr_ei_handle-ext1(%r1),%r1

	;ldil	L%intr_ei_handle,1
	;ldo	R%intr_ei_handle(1),1

	mtctl	%r1,%cr18
	ldo	4(%r1),%r1
	mtctl	%r1,%cr18

	mfctl	%cr22,%r1	;read ipsw
	depdi	0,63,1,%r1	;clear I bit
	mtctl	%r1,%cr22

	rfi,r
	nop

intr_ei_handle
	nop  ;FIXME: we _should_ return with our own PSW instead of the IPSW.
	     ;If IPSW{N} is set, this nop will not be executed
	nop  ;uh, this one is just paranoia

	shdw_reg_save

	rest_shdw_post

	;we dont need to do this since kernel stack is 1-to-1 with real addr
	;depi	3,1,2,%r30

	save_general %r8

	copy     %r8,%r24	;grab pointer to regs

	;save reg ptr
	mtctl	%r8,%cr24

	mfctl           %cr29,%r26	;grab the saved value of eirr

	ldil    L%cpu_irq_region, %r25
        bl      do_irq_mask,%r2
        ldo     R%cpu_irq_region(%r25),%r25

	mfctl	%cr24,%r8

	rest_general %r8

	rsm	 9, 0

	rest_specials %r8	

	rest_stack


	rfi
	nop



#define INTR_PSW	0x0

	/* CR28 - pointer to stack based temp. task structure
	 * CR29 - trap code
	 * CR30 - ksp or 0 if sp is ksp */

	.export intr_save, entry
intr_save

	;create reg storage on stack pointed to by gr8
	get_stack save1

	;save the special regs (cr's) using gr8 as ptr
	save_specials %r8

	;temp save shadowed regs & gr3 on the stack
	save_shdw %r8

	;jump to virt mode & restore orig shadow reg values
	virt_map

	;save orig shadow reg values
	shdw_reg_save

	;restore the non-interupt shawdow reg. values
	rest_shdw_post

intr_handle
	nop	; FIXME: we _should_ return with our own PSW instead of the IPSW. if
		; IPSW{N} is set, this nop will not be executed
	nop	; uh, this one is just paranoia
	

	;save all non-shadowed regs & space using gr8 as ptr
	save_general_nonshdw %r8

	;get args from the reg struc pointed to by gr8
	get_intr_args  %r8

	;save reg ptr
	;;mtctl	%r8,%cr24
	ldo	8(%r30),%r30
	std	%r8, -8(%r30)

	bl	handle_interruption,%r2
	nop	

	;;mfctl	%cr24,%r8
	ldd	-8(%r30),%r8
	ldo	-8(%r30),%r30


	rest_general %r8

	rsm	25, 0

	rest_specials %r8

	rest_stack

	rfi
	nop

;-----------------------------------------------
; kernel_execve_ret: return for kernel call to execve
;-----------------------------------------------
	.export kernel_execve_ret, entry
kernel_execve_ret
	mfctl	%cr28,%r8 ;get current
	ldo     TASK_REGS(%r8),%r8 ;get regs ptr of current

	rest_general %r8

	rsm	25, 0

	rest_specials %r8


	;setup cr30
	ldd     PT_CR30(%r8), %r1
	mtctl	%r1,%cr30		
	ldd     PT_GR1(%r8), %r1

	;setup stack
	ldd     PT_GR30(%r8), %r30
	;rest gr8
	ldd             PT_GR8(%r8), %r8

	rfi
	nop
