/* $Id: irq.c,v 1.26 1999/08/24 19:07:22 deller Exp $
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Code to handle x86 style IRQs plus some generic interrupt stuff.
 *
 * Copyright (C) 1992 Linus Torvalds
 * Copyright (C) 1994, 1995, 1996, 1997, 1998 Ralf Baechle
 * Copyright (C) 1999 SuSE GmbH (Author: Philipp Rumpf, prumpf@suse.de)
 */

#include <linux/bitops.h>
#include <asm/bitops.h>
#include <linux/errno.h>
#include <linux/init.h>

#include <linux/kernel_stat.h>

#include <linux/signal.h>


#include <linux/sched.h>
#include <linux/types.h>


#include <linux/interrupt.h>


#include <linux/ioport.h>
#include <linux/timex.h>
#include <linux/malloc.h>
#include <linux/random.h>

void schedule(void);

unsigned char cache_21 = 0xff;
unsigned char cache_A1 = 0xff;

unsigned int local_bh_count[NR_CPUS];
unsigned int local_irq_count[NR_CPUS];
unsigned long spurious_count = 0;

/* Timer interrupt routine is now included */
extern void timer_interrupt(int, void *, struct pt_regs *);
struct irqaction cpu_irq_actions[] = {
	  { timer_interrupt, 0, 0, "timer", NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL },
	  { NULL, 0, 0, NULL, NULL, NULL }
};

struct irq_region cpu_irq_region = {
        { NULL, NULL, NULL, NULL },
        { NULL, "direct", IRQ_REG_MASK, 0},
        cpu_irq_actions
};


/*
 * FIXME: not SMP-clean
 */

struct irq_region *irq_region[NR_IRQ_REGS] = {
        &cpu_irq_region, NULL,
};


/* we special-case the real IRQs here, which feels right given the relatively
 * high cost of indirect calls.  If anyone is bored enough to benchmark this
 * and find out whether I am right, feel free to.   prumpf */

static inline void mask_irq(int irq)
{
        struct irq_region *region;

        if(IRQ_REGION(irq)) {
                region = irq_region[IRQ_REGION(irq)];
                if(region->data.flags & IRQ_REG_MASK)
                        region->ops.mask_irq(region->data.dev, IRQ_OFFSET(irq));
        } else {
                unsigned long irq_mask;
                asm volatile("mfctl 15,%0" : "=r" (irq_mask));
                irq_mask &= ~((unsigned long)1<<(63-IRQ_OFFSET(irq)));
                asm volatile("mtctl %0,15" : : "r" (irq_mask));
        }
}

static inline void unmask_irq(int irq)
{
        struct irq_region *region;

        if(IRQ_REGION(irq)) {
                region = irq_region[IRQ_REGION(irq)];
                if(region->data.flags & IRQ_REG_MASK)
                        region->ops.unmask_irq(region->data.dev, IRQ_OFFSET(irq));
        } else {
                unsigned long irq_mask;
                asm volatile("mfctl 15,%0" : "=r" (irq_mask));
                irq_mask |= ((unsigned long)1<<(63-IRQ_OFFSET(irq)));
                asm volatile("mtctl %0,15" : : "r" (irq_mask));
        }
}

void disable_irq(int irq)
{
        struct irq_region *region;

        region = irq_region[IRQ_REGION(irq)];

        if(region->data.flags & IRQ_REG_DIS)
                region->ops.disable_irq(region->data.dev, IRQ_OFFSET(irq));
}

void enable_irq(int irq)
{
        struct irq_region *region;

        region = irq_region[IRQ_REGION(irq)];

        if(region->data.flags & IRQ_REG_DIS)
                region->ops.enable_irq(region->data.dev, IRQ_OFFSET(irq));
}

/*
 * Pointers to the low-level handlers: first the general ones, then the
 * fast ones, then the bad ones.
 */
extern void interrupt(void);

int get_irq_list(char *buf)
{
  return 0;
}

atomic_t __parisc_bh_counter;

/*
** The following form a "set": Virtual IRQ, Transaction Address, Trans Data.
** Respectively, these map to IRQ region+EIRR, Processor HPA, EIRR bit.
**
** To use txn_XXX() interfaces, get a Virtual IRQ first.
** Then use that to get the Transaction address and data.
*/

int
txn_alloc_irq(void)
{
        int irq;

        /* never return irq 0 cause that's the interval timer */
        for(irq=1; irq<=31; irq++) {
                if(irq_region[0]->action[irq].handler == NULL)
                        return irq;
        }

        /* unlikely, but be prepared */
        return -1;
}


unsigned long
txn_alloc_addr(int virt_irq)
{
        /* REVISIT: SMP will suck using the broadcast EIRR.
        ** Stop using this when SMP gets interesting. - ggg
        */
        return (0xfffe0000);    /* broadcast EIRR - !SMP */
}

int
txn_alloc_data(int virt_irq)
{
        return(virt_irq&0xff);
}

/* FIXME: SMP, flags, bottom halves, rest */
/* careful! Unlike other architectures, do_irq can be called out of drivers on
 * parisc (notably the dino driver) */ 

void do_irq(struct irqaction *action, int irq, struct pt_regs * regs)
{
        for(; action && action->handler; action = action->next) {
                action->handler(irq, action->dev_id, regs);
        }

        /* don't need to care about unmasking and stuff */
        if(bh_active & bh_mask)
                do_bottom_half();

        if(0 && user_mode(regs))
                schedule();
}

void do_irq_mask(unsigned long mask, struct irq_region *region, struct pt_regs *regs)
{
        unsigned long bit;
        int irq;
/*
        printk("do_irq_mask %08lx %p %p\n", mask, region, regs);
*/
        for(bit=((unsigned long)1<<(BITS_PER_LONG-1)), irq = 0; mask && bit; bit>>=1, irq++) {
                if(!(bit&mask))
                        continue;

                if(irq) {
         printk("Interrupt %2d(%2d+%2d)\n", 
		irq+region->data.irqbase, irq, region->data.irqbase);
                }
                mask_irq(irq);
                do_irq(&region->action[irq], region->data.irqbase + irq, regs);
                unmask_irq(irq);
        }
}

/* XXX: we use break instructions right now to do kernel_thread. */

void handle_break(unsigned iir, struct pt_regs *regs)
{
	switch(iir) {
		case 0x01:
			do_fork(regs->gr[24], regs->ipsw, regs);
			break;
		default:
			mtctl(0, 15);
			printk("break %08x\n", iir);
			show_regs(regs);
			printk("halt\n");
			for(;;);
	}

	regs->iaoq[0] += 4;
	regs->iaoq[1] += 4;
	cli();

}

void handle_interruption(int code, struct pt_regs *regs, unsigned long ior)
{
	unsigned long address;
#if 0
	printk("interrupted with code %d, regs %p\n", code, regs);
	printk("IAOQ: %08x %08x\n", regs->iaoq[0], regs->iaoq[1]);
	printk("ISR: %08x IOR: %08x IIR: %08x\n", mfctl(20), mfctl(21), mfctl(19));
#endif
	switch(code) {
	case  6:
	case  7:
	case 16:
		printk("\niaoq %16lx\n", regs->iaoq[0]); 
		do_page_fault(regs, code, regs->iaoq[0]);
		break;
	case 15:
	case 17:
	case 26:
	case 27:
		address = (regs->isr << 32) | ior;
		printk("\nisr/ior %16lx\n", address); 
		do_page_fault(regs, code, address);
		break;
	default:
#ifdef OUT
		printk("ior %08lx(%d) [%08x] [%08x]\n", ior, code, (unsigned)regs, *(unsigned *)0x3c8);
		printk("unexpected interruption code %d\n", code);
		show_regs(regs);
#endif /* OUT */
		break;
	}
}

static inline int alloc_irqregion(void)
{
        int irqreg;

        for(irqreg=1; irqreg<=(NR_IRQ_REGS); irqreg++) {
                if(irq_region[irqreg] == NULL)
                        return irqreg;
        }

        return 0;
}

struct irq_region *alloc_irq_region(
        int count, struct irq_region_ops *ops, unsigned long flags,
        const char *name, void *dev)
{
        struct irq_region *region;
        int index;

        index = alloc_irqregion();

        if((IRQ_REGION(count-1)))
                return NULL;

        if(flags & IRQ_REG_MASK)
                if(!(ops->mask_irq && ops->unmask_irq))
                        return NULL;
        if(flags & IRQ_REG_DIS)
                if(!(ops->disable_irq && ops->enable_irq))
                        return NULL;

        if((irq_region[index]))
                return NULL;

#ifdef OUT
        region = kmalloc(sizeof *region, GFP_ATOMIC);
#endif /* OUT */
        if(!region)
                return NULL;

#ifdef OUT
        region->action = kmalloc(sizeof *region->action * count, GFP_ATOMIC);
#endif /* OUT */
        if(!region->action) {
#ifdef OUT
                kfree(region);
#endif /* OUT */
                return NULL;
        }
        memset(region->action, 0, sizeof *region->action * count);

        region->ops = *ops;
        region->data.irqbase = IRQ_FROM_REGION(index);
        region->data.flags = flags;
        region->data.name = name;
        region->data.dev = dev;

	irq_region[index] = region;

        return irq_region[index];
}


/* FIXME: SMP, flags, bottom halves, rest */

int request_irq(unsigned int irq,
                void (*handler)(int, void *, struct pt_regs *),
                unsigned long irqflags,
                const char * devname,
                void *dev_id)
{
        struct irqaction * action;

        if(!handler)
                return -EINVAL;

        action = &irq_region[IRQ_REGION(irq)]->action[IRQ_OFFSET(irq)];

        if(!action)
                return -ENOMEM;

        action->handler = handler;
        action->flags = irqflags;
        action->mask = 0;
        action->name = devname;
        action->next = NULL;
        action->dev_id = dev_id;

        return 0;
}

void free_irq(unsigned int irq, void *dev_id)
{
        printk("Trying to free free IRQ%d\n",irq);
}

unsigned long probe_irq_on (void)
{
        return 0;
}

int probe_irq_off (unsigned long irqs)
{
        return 0;
}

void init_IRQ(void)
{
	register long eiem;
	volatile long l, *lp;
        register long gReg;

	/* printk("secret message is \"%s\"\n", (char *)fault_vector); */

	cli();


	mtctl(0xffffffffffffffff, 15);
	mtctl(0xffffffffffffffff, 23);
	asm volatile ("rsm 0,%0" : "=r" (eiem));
	sti();
	printk("PSW: %08lX\n", eiem);
	printk("Heya\n");
	sti();
	cli();

		
	printk("Finished init_IRQ !!!\n");
}
