#include <asm/pdc.h>
#include "main_externs.h"

#define FALSE 0
#define TRUE 1
#define MAX_PDC_ARGS 16
#define MAX_MADDR_BUFFER        0x380
#define IDLE_SEL     0X00000F00
#define FAILURE_MODE_SIZE	5
#define MAX_PDC_CALL_ARGS 8
#define DL_ALWAYS           6
#define MAX_NUM_CELLS 64
#define PDC_PAT_CPU                 67
#define MAX_NUM_RETURN_VALUES 64
#define EXPECTED_STATUS_INDEX   0
#define ACTUAL_STATUS_INDEX     1
#define OPTION_INDEX            2
#define PDC_INDEX               3
#define STEP_INDEX              4
#define MEM_RENDEZ 16
#define MEM_10MSEC 0x38c
#define IGNORE_STATUS   -12345

int NUM_CELLS;
typedef  long           int64_t;
typedef unsigned long  uint64_t;
unsigned int *Slave_stack_ptr;
uint64_t slave_entry;
int64_t  ret[MAX_NUM_RETURN_VALUES];
int64_t  pdcCall;   /* arg0 */
int64_t  pdcOption; /* arg1 */
int64_t  arg2,  arg3,  arg4,  arg5,  arg6,  arg7;
int *arg0p, *arg1p, *arg2p, *arg3p, *arg4p, *arg5p, *arg6p, *arg7p;
int pdc_debug = 0;
int wideMode = 0;

extern int run_slave_proc();
extern int slave_ret_idle();
extern int wake_up_slave(int *);


struct seib {	/* Slave Execution Information Block */
	uint64_t	s_iva;	/* cr14 */
	uint64_t  	s_pc;	/* program counter == gr2 */
	uint64_t	s_eiem;	/* cr15 */
	uint64_t	s_sp;	/* gr30 */
	uint64_t	dp;		/* gr27 */
	unsigned int	system_mask;	/* used for setting PSW */	
	unsigned int	reserved_1;
	unsigned int	reserved_2;

	unsigned int	reserved_3;	/*slots used to fill up cache block*/
	unsigned int	reserved_4;
	unsigned int	reserved_5;
	unsigned int	reserved_6;
	unsigned int	reserved_7;
	unsigned int	reserved_8;
	unsigned int	reserved_9;
	unsigned int	reserved_10;
};


struct f_mode
{
   int	fm[FAILURE_MODE_SIZE];
   int  arg_list[MAX_PDC_CALL_ARGS];
};

typedef union
{
   int64_t data;
   struct
   {
       unsigned long long addr: 52;   
       unsigned int misc        :12;
   } field;
}hpa_info;

typedef union
{
   int64_t data;
   struct
   {
       unsigned int type: 8;   
       unsigned long long misc:56;
   } field;
}entity_info;

typedef struct {
   hpa_info hpa;
   int mod_index;
   entity_info entity_type;   
}module_info;

typedef struct{
   int number;
   int64_t location;
   int num_modules;
   int num_cpus;
   module_info cpu_info[64]; 
}cell_type;

cell_type cell_info[MAX_NUM_CELLS];
struct seib Slave_info;
