#include <linux/kdev_t.h>

#include <asm/types.h>

#include <asm/pdc.h>

#include <asm/delay.h>

#ifdef OUT_ORG_LINUX
#include <linux/kernel.h>
#endif

#include <linux/console.h>

#include <linux/string.h>

#include <asm/iodc.h>

/* PDC return parameter buffer (32-words + alignment). */
static char pdc_retbuf_space[32*4+7];
int *pdc_retbuf;

/* IODC return parameter buffer (32-words + alignment). */
static char iodc_retbuf_space[32*4+7];
int *iodc_retbuf;

/* IODC I/O data buffer (4Kbytes + alignment). */
static char iodc_dbuf_space[4096+63];
char *iodc_dbuf;

/*
 * pdc_putc:
 * Console character print using IODC.
 *
 * Note that only these special chars are architected for console IODC io:
 * BEL, BS, CR, and LF. Others are passed through.
 * Since the HP console requires CR+LF to perform a 'newline', we translate
 * "\n" to "\r\n".
 */

volatile static int posx = 0;	/* for simple TAB-Simulation... */

#define PA(x) (void *)((unsigned long)(x)&~0xc0000000)

extern int pdc_call_x(struct iomod*, ...);

void pdc_putc(char c)
{
    unsigned int n;
    /* rage added : */
    extern unsigned int (*iodc_entry)();
    extern unsigned int HPA;
    extern unsigned int SPA;
    extern unsigned int *layers;
    unsigned long aret[32];
    unsigned long crs[8];
    int ret, rret;

    /* Bail if no console output device. */
    if (!PAGE0->mem_cons.iodc_io)
	return;

    /* IODC requires output data in aligned buffer (0 MOD 64). */
    switch (c) {
	case '\n':  iodc_dbuf[0] = '\r'; 
		    iodc_dbuf[1] = '\n';
                    n = 2;
                    posx = 0;
		    /* __delay(8000000); */
		    break;
	case '\t':  pdc_putc(' ');
		    while (posx & 7) 	/* expand TAB */
		      pdc_putc(' ');
		    return;		/* return since IODC can't handle this */
	case '\b':  posx--;		/* BS */
		    /* fall through */
	case 7:	    posx--;		/* BELL */
		    /* fall through */
	default:    iodc_dbuf[0] = c;
                    n = 1;
                    posx++;
		    break;
    }

/*
    pdc_call_x(
	PAGE0->mem_cons.hpa, ENTRY_IO_COUT,
	PAGE0->mem_cons.spa, PAGE0->mem_cons.dp.layers,
        PA(iodc_retbuf), 0, PA(iodc_dbuf), n, 0 );
*/

    rret = enter_real();
    SAVE_CRS(crs)

    ret = (*iodc_entry)(HPA,ENTRY_IO_COUT,SPA,layers,aret,0,PA(iodc_dbuf),n,0);

    RESTORE_CRS(crs)
    leave_real(rret);

    
}

void pdc_console_write(struct console *co, const char *s, unsigned count) {
	while(count--)
		pdc_putc(*s++);
}

int  pdc_console_wait_key(struct console *co){
    int status;
    int ch;

    /* Bail if no console input device. */
    if (!PAGE0->mem_kbd.iodc_io)
	return 0;
	
    /* wait for a keyboard (rs232)-input */
    /* rage changed */
    do {
        enter_real();
	status = ((unsigned int (*)())(PAGE0->mem_kbd.iodc_io))(
	    PAGE0->mem_kbd.hpa, ENTRY_IO_CIN,
	    PAGE0->mem_kbd.spa, PAGE0->mem_kbd.dp.layers,
	    iodc_retbuf, 0, PA(iodc_dbuf), sizeof(char), 0 );
        leave_real();
	ch = *iodc_dbuf;	/* save the character directly to ch */
    } while (*iodc_retbuf == 0);	/* wait for a key */
    return ch;
}

int pdc_getc(void) {
    return pdc_console_wait_key(NULL);
}

int pdc_console_setup(struct console *co, char *options) {
	return 0;
}

struct console pdc_cons = {
	"ttyB",
	pdc_console_write,
	NULL,
	NULL,
	pdc_console_wait_key,
	NULL,
	pdc_console_setup,
	0,
	-1,
	0,
	NULL
};

void pdc_console_init(void)
{
    /*
     * PDC and IODC calls return parameters in a 32-word, 0 MOD 8 aligned
     * buffer.
     * IODC I/O calls require a 0 MOD 64 aligned data buffer.
     */
    pdc_retbuf = (int *)(((unsigned)&pdc_retbuf_space[0] + 7) & ~7);
    iodc_retbuf = (int *)(((unsigned)&iodc_retbuf_space[0] + 7) & ~7);
    iodc_dbuf = (char *)(((unsigned)&iodc_dbuf_space[0] + 63) & ~63);

    /* If the console is duplex then copy the COUT parameters to CIN. */
    if (PAGE0->mem_cons.cl_class == CL_DUPLEX)
	memcpy(&PAGE0->mem_kbd, &PAGE0->mem_cons, sizeof(PAGE0->mem_cons));

    /* register the pdc console */
    register_console(&pdc_cons);

}

