/************************************************************************/
/* pdc_iodc_utils.c                                                     */
/*                                                                      */
/* Useful  PDC & IODC routines.                                         */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include <asm/hack.h>
funcDescrPtr pdc_entry_dPtr, iodc_entry_dPtr;

#include "constants.h"
#include "main_externs.h"


/*--------------------------------------------------------------------------*/
/* CONSOLE_SETUP:                                                           */
/* This routine gathers the values needed to print to the console.          */
/*--------------------------------------------------------------------------*/
void
console_setup(void)
{
        unsigned int *ptr;      /*generic 32 bit ptr */

        /* find & grab iodc entry */
        /* Hack to test GNU compiler */
        ptr = (unsigned *)(PG0_CONSOLE_DISPLAY + PG0_OFF_IODC_IO);

        iodc_entry_dPtr.funcAddr = (unsigned long)*ptr;
	asm("copy 27,%0" : "=r" (iodc_entry_dPtr.gpVal));
 
        iodc_entry = (unsigned int (*)())&iodc_entry_dPtr;

        /* find & grab console HPA */
        ptr = (unsigned *)(PG0_CONSOLE_DISPLAY + PG0_OFF_HPA);
        HPA = *ptr;

        /* find & grab console SPA */
        ptr = (unsigned *)(PG0_CONSOLE_DISPLAY + PG0_OFF_SPA);
        SPA = *ptr;

        /* find & grab layers */
        layers = (unsigned *)(PG0_CONSOLE_DISPLAY + PG0_OFF_LAYERS);
}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void
bootdev_setup(void)
{
        unsigned int *ptr;      /*generic 32 bit ptr */

        /* find & grab iodc entry */
        ptr = (unsigned *)(PG0_BOOT_DEVICE + PG0_OFF_IODC_IO);
        bdev_iodc_entry = (unsigned int (*)())*ptr;

        /* find & grab boot device HPA */
        ptr = (unsigned *)(PG0_BOOT_DEVICE + PG0_OFF_HPA);
        bdev_HPA = *ptr;

        /* find & grab boot device SPA */
        ptr = (unsigned *)(PG0_BOOT_DEVICE + PG0_OFF_SPA);
        bdev_SPA = *ptr;

        /* find & grab layers */
        bdev_layers = (unsigned *)(PG0_BOOT_DEVICE + PG0_OFF_LAYERS);
}

/*--------------------------------------------------------------------------*/
/* pdc_setup:                                                               */
/* This routine gathers the values needed to call pdc.                      */
/*--------------------------------------------------------------------------*/
void
pdc_setup(void)
{
        unsigned int *ptr;      /*generic 32 bit ptr */
        unsigned long junk = 0, junk2 = 0;

        /* save PDC entry */

        /* point to lower half of PDC addr in pg 0*/
        ptr = (unsigned int *)PG0_MEM_PDC_LOW;
        junk2 = *ptr;       /* set lower half of entry */
        ptr = (unsigned int *)PG0_MEM_PDC_HI;    /* point to upper half of PDC in pg 0 */
        junk = *ptr;
        junk = junk << 32;              /* shift upper bits into proper position */
        /* junk2 = junk | junk2 */;   /* form full entry point addr */
        /* Temporary hack for GCC Compiler */
        junk2 = ( junk | junk2 ) ;   /* form full entry point addr */


        pdc_entry_dPtr.funcAddr = (unsigned long)junk2;
	asm("copy 27,%0" : "=r" (pdc_entry_dPtr.gpVal));
 
        pdc_entry = (unsigned int (*)())&pdc_entry_dPtr;

}

/*--------------------------------------------------------------------------*/
/* smp_processor_id()                                                       */
/*                                                                          */
/* This routine will return the cpu number of the calling processor.        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
long
smp_processor_id()
{

	unsigned long hpa, aret[32];
	int ret;

	/* get CPU HPA */
	ret = CALL_PDC(PDC_PAT_CPU, 4, aret, (long)-1, 0, 0, 0, 0, 0);

	hpa = aret[0];

	/* get cpu number */
	ret = CALL_PDC(PDC_PAT_CPU, 3, aret, hpa, 0, 0, 0, 0, 0);

	return(aret[0]);

}

/*--------------------------------------------------------------------------*/
/* CALL_PDC								    */
/* This function is a genric way to call pdc.			   	    */
/*--------------------------------------------------------------------------*/
int
CALL_PDC(long Func, unsigned long arg0, unsigned long arg1,
	 unsigned long arg2, unsigned long arg3, unsigned long arg4,
	 unsigned long arg5, unsigned long arg6, unsigned long arg7)
{
	unsigned long crs[8];
	int ret,rret;

	/* enter real mode */
	rret = enter_real();

	/* save temp control regs */
	asm("mfctl 24,%0" : "=r" (crs[0]));
	asm("mfctl 25,%0" : "=r" (crs[1]));
	asm("mfctl 26,%0" : "=r" (crs[2]));
	asm("mfctl 27,%0" : "=r" (crs[3]));
	asm("mfctl 28,%0" : "=r" (crs[4]));
	asm("mfctl 29,%0" : "=r" (crs[5]));
	asm("mfctl 30,%0" : "=r" (crs[6]));
	asm("mfctl 31,%0" : "=r" (crs[7]));

	/* call pdc */
	ret = (*pdc_entry)
		(Func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);

	/* restore temp control regs */
	asm("mtctl %0,24" : : "r" (crs[0]));
	asm("mtctl %0,25" : : "r" (crs[1]));
	asm("mtctl %0,26" : : "r" (crs[2]));
	asm("mtctl %0,27" : : "r" (crs[3]));
	asm("mtctl %0,28" : : "r" (crs[4]));
	asm("mtctl %0,29" : : "r" (crs[5]));
	asm("mtctl %0,30" : : "r" (crs[6]));
	asm("mtctl %0,31" : : "r" (crs[7]));

	/* go back to virtual mode */
	leave_real(rret);

	return(ret);
}




/*--------------------------------------------------------------------------*/
/* Init_FP                                                                  */
/*                                                                          */
/* This function will initialize the floating point of the calling processor.*/
/*                                                                          */
/*--------------------------------------------------------------------------*/
int
Init_FP(void)
{

	unsigned long aret[32];
	int ret;

	ret = CALL_PDC(PDC_COPROC, 0, aret, 0, 0, 0, 0, 0, 0);

	if(ret >= 0)
	{
	  set_ccr(aret[0]);
	  init_fp_status();
	}


	return(ret);
}

/*--------------------------------------------------------------------------*/
/* ArchDFlush                                                               */
/*--------------------------------------------------------------------------*/
void
ArchDFlush(void)
{
        arch_dflush((unsigned int)pdc_parms[8],     /* base   */
                    (unsigned int)pdc_parms[9],     /* stride */
                    (unsigned int)pdc_parms[10],    /* count  */
                    (unsigned int)pdc_parms[11]);   /* assoc  */
}

/*--------------------------------------------------------------------------*/
/* ArchIFlush                                                               */
/*--------------------------------------------------------------------------*/
void
ArchIFlush(void)
{
        arch_iflush((unsigned int)pdc_parms[2],  /* base */
                    (unsigned int)pdc_parms[3],  /* stride */
                    (unsigned int)pdc_parms[4],  /* count */
                    (unsigned int)pdc_parms[5]); /* assoc */
}

/*--------------------------------------------------------------------------*/
/* ArchITLBPurge	      						    */
/*--------------------------------------------------------------------------*/
void
ArchITLBPurge(void)
{
	unsigned long space, sp_count, offset, off_count, loop;

	space = pdc_parms[14]; /* base */
	for (sp_count = 0; sp_count < pdc_parms[16]; sp_count++) {
	    offset = pdc_parms[17];    /* offset base */
	    for (off_count = 0; off_count < pdc_parms[19]; off_count++){
                        for (loop = 0; loop < pdc_parms[20]; loop++) {
                            PITLBE(space,offset);
                        }
                        offset += pdc_parms[18]; /*offset stride*/
            }
            space += pdc_parms[15];   /* offset space */
	}
}

/*--------------------------------------------------------------------------*/
/* ArchDTLBPurge	      						    */
/*--------------------------------------------------------------------------*/
void
ArchDTLBPurge(void)
{
	unsigned long space, sp_count, offset, off_count, loop;

	space = pdc_parms[23];         /* base */
        for (sp_count = 0; sp_count < pdc_parms[25]; sp_count++) {
            offset = pdc_parms[26];    /* offset base */
            for (off_count = 0; off_count < pdc_parms[28]; off_count++){
                for (loop = 0; loop < pdc_parms[29]; loop++) {
                            PDTLBE(space,offset);
                        }
                offset += pdc_parms[27];/*offset stride*/
            }
            space += pdc_parms[24];   /* offset space */
        }
}


/*------------------------------------------------------------------------*/
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/
int
console_print(char *text, int size)
{
        unsigned long aret[32];
        int ret;

        ret = (*iodc_entry)(HPA, 3, SPA, layers, aret, 0, text, size, 0);
        return(ret);
}

