/***********************************************************************************/
/* main.c  (WIDE-MODE)                                                             */
/*                                                                                 */
/* This file contains the main start code for the RAGE kernel. The machine is in   */
/* wide mode for this kernel.                                                      */
/*                                                                                 */
/*                                                                                 */
/*                                                                                 */
/***********************************************************************************/

#include <linux/kernel.h>

#include "constants.h"
#include "globals.h"
#include "declares.h"
#include "/source/RAGE/Current/src/linux/include/asm-parisc/pdc.h"

extern void start_kernel(void);

#define COMMAND_LINE_SIZE 1024
char    saved_command_line[COMMAND_LINE_SIZE];
static unsigned long parisc_memstart;

/*-------------------------------------------------------------------------------*/
/* start_parisc                                                                  */
/*                                                                               */
/*                                                                               */
/*                                                                               */
/*-------------------------------------------------------------------------------*/
void
start_parisc(unsigned int free_mem_start)
{
	int ret;

	/* setup pdc *****************************/
        pdc_setup();

	/* setup floating point *****************************/
	Init_FP();

	/* setup console *****************************/
        console_setup(); /* JC's real mode org setup */
	pdc_console_init();
        printk("\n\nThe Kernel has started....\n");

	/* save start of free contiguous memory *****************/
	parisc_memstart = free_mem_start;
	printk("\nFree real memory starts at %16x\n",parisc_memstart);

#ifdef JOHNS
	enter_real();
	ret = console_print(kernel_name, sizeof(kernel_name)); 
	leave_real();
	if(ret < 0) {};	/* handle error */
#endif

	bootdev_setup();

	start_kernel();

	/* return to real mode before leaving */
	enter_real();
}

void setup_arch(char **cmdline_p,unsigned long *memory_start_p, 
			unsigned long *memory_end_p)
{
	unsigned int *ptr; 
	unsigned long end_addr;
	
	/* save the command line */
	*cmdline_p = &saved_command_line[0];

	/* set start memory virtually */
	*memory_start_p = parisc_memstart + 0x00000000;

	/* gather real end memory addr */
	ptr = (unsigned int *)PG0_MEM_CONT_HI; /* get # of cont. pages */
	end_addr = *ptr;
	end_addr = end_addr * 4096;  /* multiply by page size */

#ifdef OUT
	if(end_addr > 0x2000000)
          *memory_end_p = 0x2000000;
	else
#endif
	/* set end memory virtually */
        *memory_end_p = end_addr + 0x00000000;
}
