;-------------------------------------------------------------------
; spin_lock.s
;
; Author: J. Curry
;
; The routines below form the core spin_lock semaphores.
;
;-------------------------------------------------------------------


		.SPACE  $TEXT$
		.subspa $CODE$

		.align 32

#ifdef OUT
;-------------------------------------------------
; spin_lock_irqsave(lock, flags)
;
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT spin_lock_irqsave,ENTRY
spin_lock_irqsave
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		ssm	0,%r28
		stw	%r28,(%r25)
		rsm	1,%r0
grab_cspin1	ldi	0,%r28
		ldcws 	8(0,%r26), %r28 
		nop 
		nop
		cmpib,*=,n      0,%r28,grab_cspin1
		nop

		.LEAVE
		.PROCEND

;-------------------------------------------------
; spin_unlock_irqrestore(lock, flags)
;
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT spin_unlock_irqrestore,ENTRY
spin_unlock_irqrestore
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		ldi	-1,%r28
		stw 	%r28,8(0,%r26)
		nop
		sync
		mtsm 	%r25

		.LEAVE
		.PROCEND
#endif

;-------------------------------------------------
; spin_lock(lock)
;
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT spin_lock,ENTRY
spin_lock
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

grab_cspin2	ldi	0,%r28
		ldcws 	8(0,%r26), %r28 
		nop 
		nop
		cmpib,*=,n      0,%r28,grab_cspin2
		nop

		.LEAVE
		.PROCEND

;-------------------------------------------------
; spin_unlock(lock)
;
; lock = addr of semaphore (*uint)
;-------------------------------------------------
		.EXPORT spin_unlock,ENTRY
spin_unlock
		.PROC
		.CALLINFO NO_CALLS
		.ENTER

		ldi	-1,%r28
		stw 	%r28,8(0,%r26)
		nop
		sync

		.LEAVE
		.PROCEND
