;***************************************************************
; This file contains assembly utilities for the RAGE kernel. 
;***************************************************************

        .SPACE  $TEXT$
        .subspa $CODE$

	.align 32

	.import layers,DATA
        .import HPA,DATA
        .import SPA,DATA
        .import iodc_entry,DATA
        .import bdev_layers,DATA
        .import bdev_HPA,DATA
        .import bdev_SPA,DATA
        .import bdev_iodc_entry,DATA
        .import pdc_entry,DATA
	.IMPORT __gp, DATA


	.align 32

	;---------------------------------------
	;---------------------------------------
		.EXPORT cause_eir_0,ENTRY
cause_eir_0
	.PROC
	.CALLINFO NO_CALLS
	.ENTER

	bl         .+8,%r28
	addil      L%CE02-CE01,%r28   ;set rtn addr
CE01    ldo        R%CE02-CE01(%r1),%r28

	rsm        8,%r0                ; turn off q bit

	mtctl      %r28,%cr18            ;front IIAOQ
	addi       4,%r28,%r28
	mtctl      %r28,%cr18            ;back IIAOQ

	;load ipsw with Q,W,C,P,D and I on
	ldi        0,%r28
	ldil       l%0x804000F,%r28
	ldo        r%0x804000F(%r28),%r28
	mtctl      %r28,%cr22

	rfi
	nop

CE02    .align 32
	ldi        1,%r28       ;set bit 0 EIEM
	depd,Z     %r28,0,1,%r28
	mtctl      %r28,%cr15

	mfctl      %cr16,%r28           ;read timer value
	addi       10,%r28,%r28         ;form compare value
	mtctl      %r28,%cr16

	nop
	nop
	sync
	nop
	nop

	ldi        0x1000,%r28
loop_it_baby
	addi       -1,%r28,%r28
	cmpib,*<>,n   0,%r28,loop_it_baby
	nop

	bl         .+8,%r28
	addil      L%CE04-CE03,%r28   ;set rtn addr
CE03    ldo        R%CE04-CE03(%r1),%r28

	rsm        8,%r0                ; turn off q bit

	mtctl      %r28,%cr18            ;front IIAOQ
	addi       4,%r28,%r28
	mtctl      %r28,%cr18            ;back IIAOQ


	mtctl      %r0,%cr15		;clear mask

	;load ipsw with Q,W,C,P and D on, NO I
	ldi        0,%r28
	ldil       l%0x804000E,%r28
	ldo        r%0x804000E(%r28),%r28
	mtctl      %r28,%cr22

	rfi
	nop

CE04
	.LEAVE
	.PROCEND

;---------------------------------------------------------------
; set_ccr
;
; Sets the CCR reg with arg0
;---------------------------------------------------------------
	.EXPORT set_ccr,ENTRY
set_ccr
        .PROC
        .CALLINFO NO_CALLS
        .ENTER
	
	MTCTL	%arg0,%ccr

        .LEAVE
        .PROCEND

;---------------------------------------------------------------
; enter_real
;
; This routine will return to the caller in real mode (W & Q).
;
; return bits 36,37, 56-63 are orig psw bit values
;---------------------------------------------------------------
	.EXPORT enter_real,ENTRY
enter_real
	.PROC
        .CALLINFO NO_CALLS
        .ENTER
	
	ldi	0,%r29		;clear return reg.
        rsm	8,%r29          ; turn off q bit
	
	;rfi back to caller in real mode:
	mtctl	%r2,%cr18		;set front of IIAOQ
	addi	4,%r2,%r2
	mtctl	%r2,%cr18		;set back of IIAOQ

	;load ipsw with W and Q on
        ldil       l%0x8000008,%r28
        ldo        r%0x8000008(%r28),%r28
        mtctl      %r28,%cr22

	copy	   %r29,%r28		;return org psw bits

	rfi
        nop

        .LEAVE
        .PROCEND

;---------------------------------------------------------------
; leave_real
;
; This routine will return to the caller in virtual mode.
; It assumes that the kernel virtual offset is x0.x00000000.
;
;---------------------------------------------------------------
	.EXPORT leave_real,ENTRY
leave_real
	.PROC
        .CALLINFO NO_CALLS
        .ENTER
	
        rsm	8,%r0           ; turn off q bit

	;rfi back to caller in real mode:
	mtctl	%r0,%cr17		;set front of IIASQ
	mtctl	%r0,%cr17		;set back of IIASQ

	mtctl	%r2,%cr18		;set front of IIAOQ
	addi	4,%r2,%r2
	mtctl	%r2,%cr18		;set back of IIAOQ

	;check P & D bits
	extrd,u	%r26,62,2,%r29		

	;grab orig. psw bits
	ldi	   0,%r28	
	depd	   %r26,63,8,%r28	;deposit orig mask bits
	extrd	   %r26,37,2,%r26	;extract psw bits 36 & 37
	depd	   %r26,37,2,%r28	;deposits psw bits 36 & 37

	cmpib,*<>,n 0x3,%r29,.+8	;skip next if P & D are off
	depdi	   1,45,1,%r28		;Set code translation on
        mtctl      %r28,%cr22

	rfi
        nop

        .LEAVE
        .PROCEND

;---------------------------------------------------------------
; init_fp_status
;
; Initialises the floating point status register
;---------------------------------------------------------------
	.EXPORT init_fp_status,ENTRY
init_fp_status
        .PROC
        .CALLINFO NO_CALLS
        .ENTER

	;store status register to stack (hopefully aligned)
	;and clear the T-bit.
	fstd	%fr0,(%sp)	

        .LEAVE
        .PROCEND

;---------------------------------------------------------------
;arch_dflush                    (leveraged from ODE)
;       This procedure is an architected flush routine.
;       It flushes the main processor data cache to memory per the
;       instructions found in the Precision I/O Architecture, p. 12-19.
;       (description of PDC_CACHE)
;
;**************************************************************
;       1               19              20              21
;                                       assoc           count
;       22              23              24              25
;       address         max_assoc       max_count       stride
;       26              28              29              31
;       base
;****************************************************************
        .EXPORT arch_dflush,ENTRY

arch_dflush
        .PROC
        .CALLINFO NO_CALLS
        .ENTER
        add     r26,r0,r22              ;Address = base.
        and     r0,r0,r21               ;count = 0.

L$arch_d0
        comb,>= r21,r24, L$arch_end     ;count >= max count
        and     r0,r0,r20               ;assoc = 0

L$arch_d1
        addi    1,r20,r20               ;assoc++
        comb, < r20,r23, L$arch_d1      ;assoc < max assoc
        fdce    r0(0,r22)

        addib,tr 1,r21, L$arch_d0       ;count++
        add     r22,r25,r22             ;Addr = addr + stride

L$arch_end
        .LEAVE
        .PROCEND

;---------------------------------------------------------------
;arch_iflush                    (leveraged from ODE)
;       This procedure is an architected flush routine.
;       It flushes the main processor instruction cache to memory per the
;       instructions found in the Precision I/O Architecture, p. 12-19.
;       (description of PDC_CACHE)
;
;**************************************************************
;       1               19              20              21
;                                       assoc           count
;       22              23              24              25
;       address         max_assoc       max_count       stride
;       26              28              29              31
;       base
;**************************************************************
        .EXPORT arch_iflush,ENTRY
arch_iflush
        .PROC
        .CALLINFO       NO_CALLS
        .ENTER
        add     r26,r0,r22              ;Address = base.
        and     r0,r0,r21               ;count = 0.

L$arch_i0
        comb,>= r21,r24, L$arch_iend    ;count >= max count
        and     r0,r0,r20               ;assoc = 0

L$arch_i1
        addi    1,r20,r20               ;assoc++
        fice    r0(0,r22)               ;*jac* P19 patch
        fice    r0(0,r22)               ;*jac* P19 patch
        b       L$p24                   ;*jac* P24 patch
L$p24   nop                             ;*jac* P24 patch
        comb, < r20,r23, L$arch_i1      ;assoc < max assoc
;       fice    r0(0,r22)               ;*jac* original fice instr
        nop                             ;*jac* fill empty delay slot
        addib,tr 1,r21, L$arch_i0       ;count++
        add     r22,r25,r22             ;Addr = addr + stride

L$arch_iend
        .LEAVE
        .PROCEND

;*************************************************************
; PITLBE: purge i-tlb entry
;*************************************************************
;*************************************************************
        .EXPORT PITLBE,ENTRY
PITLBE
        .PROC
        .CALLINFO       NO_CALLS
        .ENTER

	mfsp	%sr1,%r28
	mtsp    %r26,%sr1                 ;setup sid
        pitlbe  (%sr1,%r25)
	sync
	nop
	mtsp	%r28,%sr1

        .LEAVE
        .PROCEND

;*************************************************************
; PDTLBE: purge d-tlb entry
;*************************************************************
;*************************************************************
        .EXPORT PDTLBE,ENTRY
PDTLBE
        .PROC
        .CALLINFO       NO_CALLS
        .ENTER

	mfsp	%sr1,%r28
	mtsp    %r26,%sr1                 ;setup sid
        pdtlbe  (%sr1,%r25)
	sync
	nop
	mtsp	%r28,%sr1

        .LEAVE
        .PROCEND
