/*------------------------------------------------------------------------------
 * Native PARISC/Linux Project (http://www.puffingroup.com/parisc)
 *
 * System Call Wrapper routines and Syscall Return Path
 *
 * Copyright (C) 2000 Hewlett-Packard (John Marvin)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <asm/offset.h>

	.SPACE  $TEXT$
        .subspa $CODE$

        .align 32

;#include <asm/assembly.h>

	/* These should probably go in a header file somewhere.
	 * They are duplicated in kernel/wrappers.S
	 * Possibly we should consider consolidating these
	 * register save/restore macros.
	 */
reg_save 	.macro	regs
	std	%r3, PT_GR3(regs)
	std	%r4, PT_GR4(regs)
	std	%r5, PT_GR5(regs)
	std	%r6, PT_GR6(regs)
	std	%r7, PT_GR7(regs)
	std	%r8, PT_GR8(regs)
	std	%r9, PT_GR9(regs)
	std    %r10,PT_GR10(regs)
	std    %r11,PT_GR11(regs)
	std    %r12,PT_GR12(regs)
	std    %r13,PT_GR13(regs)
	std    %r14,PT_GR14(regs)
	std    %r15,PT_GR15(regs)
	std    %r16,PT_GR16(regs)
	std    %r17,PT_GR17(regs)
	std    %r18,PT_GR18(regs)
	.endm

reg_restore	.macro	regs
	ldd	PT_GR3(regs), %r3
	ldd	PT_GR4(regs), %r4
	ldd	PT_GR5(regs), %r5
	ldd	PT_GR6(regs), %r6
	ldd	PT_GR7(regs), %r7
	ldd	PT_GR8(regs), %r8
	ldd	PT_GR9(regs), %r9
	ldd    PT_GR10(regs),%r10
	ldd    PT_GR11(regs),%r11
	ldd    PT_GR12(regs),%r12
	ldd    PT_GR13(regs),%r13
	ldd    PT_GR14(regs),%r14
	ldd    PT_GR15(regs),%r15
	ldd    PT_GR16(regs),%r16
	ldd    PT_GR17(regs),%r17
	ldd    PT_GR18(regs),%r18
	.endm


#ifdef OUT_ORG_LINUX
	.export sys_fork_wrapper
	.import sys_fork

sys_fork_wrapper
	ldo	TASK_REGS-TASK_SZ_ALGN-64(%r30),%r1	    ; get pt regs
							    ; pointer in task
	reg_save %r1

	stw %r2,-20(%r30)
	ldo 64(%r30),%r30
	stw %r2,PT_GR19(%r1)	; save for child
	stw %r30,PT_GR20(%r1)	; save for child
	ldil L%child_return,%r3
	ldo  R%child_return(%r3),%r3
	stw %r3,PT_GR21(%r1)	; save for child
	bl sys_fork,%r2
	copy %r1,%arg0

	ldw -84(%r30),%r2
wrapper_exit
	ldo -64(%r30),%r30
	ldo	TASK_REGS-TASK_SZ_ALGN-64(%r30),%r1	    ; get pt regs

	reg_restore %r1

	bv %r0(%r2)
	nop

	/* Set the return value for the child */

child_return
	ldw TASK_PT_GR19-TASK_SZ_ALGN-128(%r30),%r2
	b wrapper_exit
	copy %r0,%r28

	.export sys_execve_wrapper
	.import sys_execve

sys_execve_wrapper

	mfctl	%cr24,%r1
	;ldo	TASK_REGS-TASK_SZ_ALGN-64(%r30),%r1	    ; get pt regs

	/*
	 * Do we need to save/restore r3-r18 here?
	 * I don't think so. why would new thread need old
	 * threads registers?
	 */

	/* Store arg0, arg1, & arg2 so that sys_execv will find them */

	stw %r26,PT_GR26(%r1);
	stw %r25,PT_GR25(%r1);
	stw %r24,PT_GR24(%r1);

	stw %r2,-20(%r30)
	ldo 64(%r30),%r30
	bl sys_execve,%r2
	copy %r1,%arg0

	ldo -64(%r30),%r30
	ldw -20(%r30),%r2

	/* If exec succeeded we need to load the args */

	ldo -1024(%r0),%r1
	comb,>>= %r28,%r1,exec_error
	copy %r2,%r19
	ldo	-TASK_SZ_ALGN-64(%r30),%r1	   ; get task ptr
	ldw TASK_PT_GR26(%r1),%r26
	ldw TASK_PT_GR25(%r1),%r25
	ldw TASK_PT_GR24(%r1),%r24
	ldw TASK_PT_GR23(%r1),%r23
	copy %r0,%r2	/* Flag to syscall_exit not to clear args */

exec_error
	bv %r0(%r19)
	nop

	.export syscall_exit, entry

syscall_exit
	; The execve system call uses r2 as a flag
	; to determine whether or not to clear arg0-arg3
	; (r26-r23).

	comib,=,n 0,%r2,no_clear
	copy	%r0, %r23
	copy	%r0, %r24
	copy	%r0, %r25
	copy	%r0, %r26

no_clear
	; NOTE: HP-UX syscalls also come through here
	;	after hpux_syscall_exit fixes up return
	;	values.
	;
	; check for bottom halves
	; check for reschedule
	; check for pending signals

	ldo	-TASK_SZ_ALGN-64(%r30),%r1	   ; get task ptr
	ldd	TASK_PT_GR30(%r1),%r30		   ; restore user sp
	ldd	TASK_PT_GR2(%r1),%r2		   ; restore user rp
	ldd	TASK_PT_GR27(%r1),%r27		   ; restore user dp
	ldd	TASK_PT_GR31(%r1),%r31		   ; restore syscall rp
	copy	%r0, %r19
	copy	%r0, %r20
	copy	%r0, %r21
	mtctl	%r1,%cr30			   ; intrhandler okay.


	be	0(%sr3,%r31)			   ; return to user space
	nop
#endif /* OUT_ORG_LINUX */

