/* 
 * User address space access functions.
 * The non inlined parts of asm-parisc/uaccess.h are here.
 *
 * Copyright 1997 Linus Torvalds
 *
 */
#include <asm/uaccess.h>

#include <asm/cache.h>
/* All should be reimplemented in assembler !!! (deller) */

#define __copy_user(to,from,n) ({ flush_all_caches(); memcpy(to,from,n); flush_all_caches();})
#define __copy_user_zeroing(to,from,n) ({ flush_all_caches(); memset(to,0,n); memcpy(to,from,n); flush_all_caches();})

unsigned long
__generic_copy_to_user(void *to, const void *from, unsigned long n)
{
	if (access_ok(VERIFY_WRITE, to, n))
		__copy_user(to,from,n);
	return 0;
}

unsigned long
__generic_copy_from_user(void *to, const void *from, unsigned long n)
{
	if (access_ok(VERIFY_READ, from, n))
		__copy_user_zeroing(to,from,n);
	return 0;
}


/*
 * Copy a null terminated string from userspace.
 */

#define __do_strncpy_from_user(dst,src,count,res) { \
	flush_all_caches(); \
	strncpy((dst),(src),(unsigned long)(count)); \
	flush_all_caches(); \
	res = 1; \
 }

long
__strncpy_from_user(char *dst, const char *src, long count)
{
	long res;
	__do_strncpy_from_user(dst, src, count, res);
	return res;
}

long
strncpy_from_user(char *dst, const char *src, long count)
{
	long res = -EFAULT;
	if (access_ok(VERIFY_READ, src, 1))
		__do_strncpy_from_user(dst, src, count, res);
	return res;
}


/*
 * Zero Userspace
 */

#define __do_clear_user(addr,size)					\
	({ flush_all_caches(); memset(addr,0,size);flush_all_caches();  })

unsigned long
clear_user(void *to, unsigned long n)
{
	if (access_ok(VERIFY_WRITE, to, n))
		__do_clear_user(to, n);
	return n;
}

unsigned long
__clear_user(void *to, unsigned long n)
{
	__do_clear_user(to, n);
	return n;
}

/*
 * Return the size of a string (including the ending 0)
 *
 * Return 0 for error
 */

long strlen_user(const char *s)
{
	flush_all_caches();
	return strlen(s) + 1;
}
