/*
 *  linux/arch/parisc/mm/init.c
 *
 *  Copyright (C) 1995  Linus Torvalds
 *  Copyright 1999 SuSE GmbH
 *    changed by Philipp Rumpf, prumpf@suse.de
 *
 */

#include <linux/config.h> 
#include <linux/init.h>     
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/errno.h>  
#include <linux/string.h>   
#include <linux/types.h>
#include <linux/pagemap.h>
#include <linux/mman.h>  
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/smp.h>
#ifdef CONFIG_BLK_DEV_INITRD
#include <linux/blk.h>
#endif

#include <asm/system.h>
#include <asm/uaccess.h>

#include <asm/pgtable.h>

#include <asm/dma.h>
#include <asm/fixmap.h>


extern long _stext; 	 /* start of kernel startup-code in head.S */
extern long _data_start; /* kernel start of Data/BSS/Stack-segment in head.S */

void free_initmem(void)  {
}

extern void show_net_buffers(void);
extern unsigned long init_smp_mappings(unsigned long);


__initfunc(void mem_init(unsigned long start_mem, unsigned long end_mem))
{
	unsigned long addr;
	int codepages = 0;
	int datapages = 0;
	int initpages = 0;

	printk("Entered mem_init 0x%08lX 0x%08lX\n", start_mem, end_mem);

	printk("mem_init 0x%08lX 0x%08lX\n", start_mem, end_mem);

	end_mem &= PAGE_MASK;
	high_memory = (void *) end_mem;
	max_mapnr = MAP_NR(high_memory);

	/* mark usable pages in the mem_map[] */
	start_mem = PAGE_ALIGN(start_mem);

	num_physpages = max_mapnr;	/* RAM is assumed contiguous */

	for (addr = PAGE_OFFSET; addr < start_mem; addr += PAGE_SIZE)
		set_bit(PG_reserved, &mem_map[MAP_NR(addr)].flags);

	for(/* addr already set */; addr<end_mem; addr += PAGE_SIZE) {
		clear_bit(PG_reserved, &mem_map[MAP_NR(addr)].flags);
#if 0
		if(PageReserved(mem_map + MAP_NR(addr)))
#endif
		if(test_bit(PG_reserved, &mem_map[MAP_NR(addr)].flags))
			printk("%d\n", PG_reserved);
	}

#ifdef CONFIG_BLK_DEV_INITRD
	/* if we are booted from IPL bootloader with an initial ramdisk,
	   make sure the ramdisk pages aren't reserved. */
	if (initrd_start) {
		unsigned long a;
		for (a = initrd_start; a < initrd_end; a += PAGE_SIZE)
			clear_bit(PG_reserved, &mem_map[MAP_NR(a)].flags);
	}
#endif /* CONFIG_BLK_DEV_INITRD */
	
	printk("_stext %08x\n", (ulong) &_stext);
	printk("_data_start %08x\n",(ulong) &_data_start);
	printk("start_mem %08x\n", start_mem);

	for (addr = PAGE_OFFSET; addr < end_mem; addr += PAGE_SIZE) {
		if (PageReserved(mem_map + MAP_NR(addr))) {
			if (addr < (ulong) &_stext)
				initpages++;
			else if (addr < (ulong) &_data_start)
				codepages++;
                        else if (addr < (ulong) start_mem)
				datapages++;
			else
				printk("Hmm...\n");
			continue;
		}
		atomic_set(&mem_map[MAP_NR(addr)].count, 1);
#ifdef CONFIG_BLK_DEV_INITRD
		if (!initrd_start ||
		    addr < (initrd_start & PAGE_MASK) || addr >= initrd_end)
#endif /* CONFIG_BLK_DEV_INITRD */
			free_page(addr);
	}

        printk("Memory: %luk available (%dk kernel code, %dk data, %dk init) [%08x,%08lx]\n",
	       (unsigned long) nr_free_pages << (PAGE_SHIFT-10),
	       codepages << (PAGE_SHIFT-10),
	       datapages << (PAGE_SHIFT-10), 
	       initpages << (PAGE_SHIFT-10),
	       (unsigned)PAGE_OFFSET, end_mem);

}

void __bad_pte_kernel(pmd_t *pmd)
{
	printk("Bad pmd in pte_alloc: %08lx\n", pmd_val(*pmd));
	pmd_val(*pmd) = _KERNPG_TABLE + __pa(BAD_PAGETABLE);
}

void __bad_pte(pmd_t *pmd)
{
	printk("Bad pmd in pte_alloc: %08lx\n", pmd_val(*pmd));
	pmd_val(*pmd) = _PAGE_TABLE + __pa(BAD_PAGETABLE);
}


pte_t *get_pte_kernel_slow(pmd_t *pmd, unsigned long offset)
{
	pte_t *pte;

	pte = (pte_t *) __get_free_page(GFP_KERNEL);
	if (pmd_none(*pmd)) {
		if (pte) {
			clear_page((unsigned long)pte);
			pmd_val(*pmd) = _KERNPG_TABLE + __pa(pte);
			return pte + offset;
		}
		pmd_val(*pmd) = _KERNPG_TABLE + __pa(BAD_PAGETABLE);
		return NULL;
	}
	free_page((unsigned long)pte);
	if (pmd_bad(*pmd)) {
		__bad_pte_kernel(pmd);
		return NULL;
	}
	return (pte_t *) pmd_page(*pmd) + offset;
}


pte_t *get_pte_slow(pmd_t *pmd, unsigned long offset)
{
	unsigned long pte;

	pte = (unsigned long) __get_free_page(GFP_KERNEL);
	if (pmd_none(*pmd)) {
		if (pte) {
			clear_page(pte);
			pmd_val(*pmd) = _PAGE_TABLE + __pa(pte);
			return (pte_t *)(pte + offset);
		}
		pmd_val(*pmd) = _PAGE_TABLE + __pa(BAD_PAGETABLE);
		return NULL;
	}
	free_page(pte);
	if (pmd_bad(*pmd)) {
		__bad_pte(pmd);
		return NULL;
	}
	return (pte_t *) (pmd_page(*pmd) + offset);
}


int do_check_pgt_cache(int low, int high)
{
	return 0;
}


/*
 * BAD_PAGE is the page that is used for page faults when linux
 * is out-of-memory. Older versions of linux just did a
 * do_exit(), but using this instead means there is less risk
 * for a process dying in kernel mode, possibly leaving an inode
 * unused etc..
 *
 * BAD_PAGETABLE is the accompanying page-table: it is initialized
 * to point to BAD_PAGE entries.
 *
 * ZERO_PAGE is a special page that is used for zero-initialized
 * data and COW.
 */
pte_t * __bad_pagetable(void)
{
	return (pte_t *) NULL;
}

unsigned long *empty_zero_page;
unsigned long *empty_bad_page;

pte_t __bad_page(void)
{
	return *(pte_t *)NULL;	
}


void show_mem(void)
{
#if 0
	int i,free = 0,total = 0,reserved = 0;
	int shared = 0, cached = 0;

	printk("Mem-info:\n");
	show_free_areas();
	printk("Free swap:       %6dkB\n",nr_swap_pages<<(PAGE_SHIFT-10));
	i = max_mapnr;
	while (i-- > 0) {
		total++;
		if (PageReserved(mem_map+i))
			reserved++;
		else if (PageSwapCache(mem_map+i))
			cached++;
		else if (!atomic_read(&mem_map[i].count))
			free++;
		else
			shared += atomic_read(&mem_map[i].count) - 1;
	}
	printk("%d pages of RAM\n",total);
	printk("%d reserved pages\n",reserved);
	printk("%d pages shared\n",shared);
	printk("%d pages swap cached\n",cached);
	printk("%ld pages in page table cache\n",pgtable_cache_size);
	show_buffers();
#ifdef CONFIG_NET
	show_net_buffers();
#endif
#endif
}
#ifdef OUT_ORG_LINUX
#endif /*OUT_ORG_LINUX*/

extern unsigned long free_area_init(unsigned long, unsigned long);

/*
 * allocate page table(s) for compile-time fixed mappings
 */
static unsigned long fixmap_init(unsigned long start_mem)
{
	return start_mem;
}

static void set_pte_phys (unsigned long vaddr, unsigned long phys)
{
}

/*unsigned long empty_bad_page;*/
unsigned long empty_bad_page_table;

void set_fixmap (enum fixed_addresses idx, unsigned long phys)
{
}

/*#endif*/

/*
 * paging_init() sets up the page tables
 *
 * This routines also unmaps the page at virtual kernel address 0, so
 * that we can trap those pesky NULL-reference errors in the kernel.
 */
unsigned long paging_init(unsigned long start_mem, unsigned long end_mem)
{
	pgd_t *pg_dir;
	pmd_t *pg_mid, *mid_end;	/* added a middle table */
	pte_t *pg_table;
	unsigned long tmp;
	unsigned long address;
	pte_t pte; /*new for rage */

	printk("start_mem[p_i]: %08x\n", start_mem);
	printk("end_mem[p_i]: %08x\n", end_mem);

	start_mem = PAGE_ALIGN(start_mem);
	address = PAGE_OFFSET;
	pg_dir = swapper_pg_dir;

	/* unmap the original low memory mappings */
	pgd_val(pg_dir[0]) = 0;

	/*** Must have at least 1 pgd entry & 1 pmd entry ********/
	/*
	 * pg_mid is physical at this point
	 */
	pg_mid = (pmd_t *) __pa(start_mem);
	/* alloc: 1024 long entries */
	start_mem += (2 * PAGE_SIZE); /*since each entry is dbl word*/
	mid_end = (pmd_t *) __pa(start_mem);

	printk("pg_mid is -> %08x\n",pg_mid);
	pgd_val(*pg_dir) = _PAGE_TABLE | (unsigned long) pg_mid;
	printk("now     : %08x\n", pgd_val(*pg_dir)); 
	/**********************************************************/

	/* Map whole memory from PAGE_OFFSET */
	printk("pg_dir  : %08x\n", pg_dir);
	while (address < end_mem) {

		/* fill in page mid diretory with page table addr entry */
		pg_table = (pte_t *) __pa(start_mem);
		/* alloc: 1024 long entries */
		start_mem += (2 * PAGE_SIZE); /*since each entry is dbl word*/
		pmd_val(*pg_mid) = _PAGE_TABLE | (unsigned long) pg_table; 
		pg_mid++;

		/* now change pg_table to kernel virtual addresses */
		pg_table = (pte_t *) __va(pg_table);
		printk("pg_table: %08x\n", pg_table);
		for (tmp = 0 ; tmp < PTRS_PER_PTE ; tmp++,pg_table++) {
			pte =
			     mk_pte(address, PAGE_KERNEL); 
			if (address >= end_mem)
				pte_val(pte) = 0;
			set_pte(pg_table, pte);
			address += PAGE_SIZE;
		}

		/* create next pmd ptr for next pgd if needed */
		if(pg_mid == mid_end) {
		  pg_dir++;
		  /*
		   * pg_mid is physical at this point
		   */
		  pg_mid = (pmd_t *) __pa(start_mem);
		  /* alloc: 1024 long entries */
		  start_mem += (2 * PAGE_SIZE); /*since each entry is dbl word*/

		  printk("pg_mid is -> %08x\n",pg_mid);
		  pgd_val(*pg_dir) = _PAGE_TABLE | (unsigned long) pg_mid;
		  printk("now     : %08x\n", pgd_val(*pg_dir)); 
		  mid_end = (pmd_t *) __pa(start_mem);
		}
	}
	start_mem = fixmap_init(start_mem);
#ifdef __SMP__
	start_mem = init_smp_mappings(start_mem);
#endif
	/* local_flush_tlb(); */ /* temp. take this out for now */

	return free_area_init(start_mem, end_mem);
}

void si_meminfo(struct sysinfo *val)
{
	int i;

	i = max_mapnr;
	val->totalram = 0;
	val->sharedram = 0;
	val->freeram = nr_free_pages << PAGE_SHIFT;
	val->bufferram = buffermem;
	while (i-- > 0)  {
		if (PageReserved(mem_map+i))
			continue;
		val->totalram++;
		if (!atomic_read(&mem_map[i].count))
			continue;
		val->sharedram += atomic_read(&mem_map[i].count) - 1;
	}
	val->totalram <<= PAGE_SHIFT;
	val->sharedram <<= PAGE_SHIFT;
	return;
}
