;-----------------------------------------
; FILE tlb.s
;
; This file contains routines that will allow
; either Instruction or Data tlb translations
; to be inseretd.
;-----------------------------------------
#include <asm/offset.h>

	.SPACE  $TEXT$
        .subspa $CODE$

        .align 32

;-----------------------------------------
; get_current()
;
; return the stack
;-----------------------------------------
;	.EXPORT get_current, ENTRY
;get_current
;	.PROC
;        .CALLINFO NO_CALLS
;        .ENTER
;
;	mfctl %cr28,%r28
;
;	.LEAVE
;        .PROCEND

;-----------------------------------------
; set_itlb_page(va, prot, addr, prot_flag)
;
; Insert 1 4kb instruc. page
;
; r26 = va (real address) ;  r25 = prot
; r24 = addr of reg structure for the page fault trap
; r23 = prot_flag flag, if not0 don't alter gr25, else alter gr25
; Assumption: the C bit is NOT on when this routine is called!
;-----------------------------------------
	.EXPORT set_itlb_page, ENTRY
set_itlb_page
	.PROC
        .CALLINFO   FRAME=96, CALLER, ENTRY_GR=10, SAVE_SP, SAVE_RP
        .ENTER

	;save our entrance virt addr.
itlb_en	mfia    %r6			;get iaoq_front

	;turn off Q bit
        rsm        8,%r4                ; turn off q bit

	ldi	   0,%r3		;specify 4kB size
	
	;handle va part:
	ldd	   PT_IAOQ0(%r24),%r28 ;grab faulting offset
	mtctl      %r28,%cr18           ;set virt offset (front)
	copy	   %r28,%r7		;get copy of offset
	ldd	   PT_IAOQ1(%r24),%r28 ;grab faulting offset
	mtctl      %r28,%cr18           ;set virt offset (back)
	ldd	   PT_IASQ0(%r24),%r28 ;grab faulting space
	mtctl      %r28,%cr17           ;set virt space (front)
	ldd	   PT_IASQ1(%r24),%r28 ;grab faulting space
	mtctl      %r28,%cr17           ;set virt space (back)

	extrd,u    %r26,51,52,%r26	;RPN into correct position
	depd,z     %r26,58,52,%r26
	depd       %r3,63,4,%r26        ;set page size to (r3+1) * 4k

	;handle prot part:
	cmpib,*<>,n 0,%r23,skip_protalt
	depd,z     %r25,31,32,%r25	;put prot in correct position  
	depdi      1,62,1,%r25          ;set access id = 1, wd = 0
skip_protalt
	depdi      1,3,1,%r25           ;set d-bit to turn off dirty trap

	;insert entry
	iitlbt     %r26,%r25            ;insert entry

	;prepare for return
	ldo set_itlb_dne-itlb_en(%r6),%r6  ;get target address
	mtctl   %r6,%cr18		;set font queue
	addi	4,%r6,%r6
	mtctl   %r6,%cr18		;set back queue
	mtctl	%r0,%cr17		;set frnt & bck space queues
	mtctl	%r0,%cr17
	mtctl	%r4,%cr22		;restore psw mask (except C bit)

	rfi                             ;jump to exiting preperation code
        nop

set_itlb_dne				;exiting prep code starts here
	.LEAVE
        .PROCEND
;-----------------------------------------

;-----------------------------------------
; set_dtlb_page(va, prot, addr, size, prot_flag)
;
; Insert 1 4kb data page
;
; r26 = ra (real address);  r25 = prot
; r24 = addr of reg structure for the page fault trap
; r23 = size to insert
; r22 = prot_flag flag, if not0 don't alter gr25, else alter gr25
; Assumption: the C bit is NOT on when this routine is called!
;	      Kernel pages will have zero of bit40 offset
;	      kernel pages will always have pl of 0
;-----------------------------------------
	.EXPORT set_dtlb_page, ENTRY
set_dtlb_page
	.PROC
        .CALLINFO   FRAME=96, CALLER, ENTRY_GR=10, SAVE_SP, SAVE_RP
        .ENTER

	;save our entrance virt addr.
dtlb_en	mfia    %r6			;get iaoq_front

	;turn off Q bit
        rsm        8,%r4                ; turn off q bit

	copy	   %r23,%r3
	;ldi	   0,%r3		;specify 4kB size
	
	;handle va part:
	ldd	   PT_IOR(%r24),%r28 ;grab faulting space
	mtctl      %r28,%cr21           ;set virt offset 
	copy	   %r28,%r7		;get copy of offset
	ldd	   PT_ISR(%r24),%r28 ;grab faulting space
	mtctl      %r28,%cr20           ;set virt space 

	extrd,u    %r26,51,52,%r26	;RPN into correct position
	depd,z     %r26,58,52,%r26
	depd       %r3,63,4,%r26        ;set page size to (r3+1) * 4k

	;handle prot part:
	cmpib,*<>,n 0,%r22,skip_protalt2
	depd,z     %r25,31,32,%r25	;put prot in correct position  
	depdi      1,62,1,%r25          ;set access id = 1, wd = 0
skip_protalt2
	depdi      1,3,1,%r25           ;set d-bit to turn off dirty trap

	;insert entry
	idtlbt     %r26,%r25            ;insert entry

	;prepare for return
	ldo set_dtlb_dne-dtlb_en(%r6),%r6  ;get target address
	mtctl   %r6,%cr18		;set font queue
	addi	4,%r6,%r6
	mtctl   %r6,%cr18		;set back queue
	mtctl	%r0,%cr17		;set frnt & bck space queues
	mtctl	%r0,%cr17
	mtctl	%r4,%cr22		;restore psw mask (except C bit)

	rfi                             ;jump to exiting preperation code
        nop

set_dtlb_dne				;exiting prep code starts here
	.LEAVE
        .PROCEND
;-----------------------------------------


;-----------------------------------------
;set_kernel_pages
;
;Insert kernel page range into TLB
;-----------------------------------------
	.EXPORT set_kernel_pages, ENTRY
set_kernel_pages
	.PROC
        .CALLINFO   FRAME=96, CALLER, ENTRY_GR=10, SAVE_SP, SAVE_RP
        .ENTER


	;save our entrance virt addr.
skpg2	mfia    %r6			;get iaoq_front

	;turn off Q bit
        rsm        8,%r4                ; turn off q bit

	ldi	   7,%r3		;specify 64MB size
	
	;handle va part:
	mtctl      %r0,%cr18           ;set virt offset (front)
	mtctl      %r0,%cr18           ;set virt offset (back)
	mtctl      %r0,%cr17           ;set virt space (front)
	mtctl      %r0,%cr17           ;set virt space (back)

	ldi	   0,%r26
	extrd,u    %r26,51,52,%r26	;RPN into correct position
	depd,z     %r26,58,52,%r26
	depd       %r3,63,4,%r26        ;set page size to (r3+1) * 4k

	;handle prot part:
	ldil       L'0x03000000,%r25    ; set up protection
	depd,z     %r25,31,32,%r25	;put prot in correct position  
	depdi      1,3,1,%r25           ;set d-bit to turn off dirty trap
	depdi      1,62,1,%r25          ;set access id = 1, wd = 0

	;insert entry
	iitlbt     %r26,%r25            ;insert entry

	;prepare for return
	ldo     skpg_dne-skpg2(%r6),%r6  ;get target address
	mtctl   %r6,%cr18		;set font queue
	addi	4,%r6,%r6
	mtctl   %r6,%cr18		;set back queue
	mtctl	%r0,%cr17		;set frnt & bck space queues
	mtctl	%r0,%cr17
	mtctl	%r4,%cr22		;restore psw mask (except C bit)

	rfi                             ;jump to exiting preperation code
        nop

skpg_dne				;exiting prep code starts here
	.LEAVE
        .PROCEND
;-----------------------------------------
