/*******************************************************/
/* iodc.h: include files for iodc driver.              */
/*                                                     */
/*******************************************************/

#define IODC_MAJOR 1       /* Will be the principle major */
#define IODC_DEVS 1        /* one device */
#define IODC_RAHEAD 0      /* */
#define IODC_SIZE 2048     /* */
#define IODC_BLKSIZE 2048  /* 1k blocks */
#define IODC_HARDSECT 2048  /**/

/* any driver specific data structures go below: */

/* Page ZERO constants */
#define         PG0_CONSOLE_DISPLAY             0x3A0
#define         PG0_OFF_IODC_IO                 0x28
#define         PG0_OFF_CLASS                   0x2C
#define         PG0_OFF_HPA                     0x20
#define         PG0_OFF_SPA                     0x24
#define         PG0_OFF_LAYERS                  0x08
#define         PG0_BOOT_DEVICE                 0x3D0

#define         PG0_MEM_PDC_HI                  0x35C
#define         PG0_MEM_PDC_LOW                 0x388

#define         PG0_MEM_CONT_LOW                0x350
#define         PG0_MEM_CONT_HI                 0x340

#define         CL_RANDOM                       1
#define         CL_SEQU                         2

#define     	CONST_2K                        0x800

typedef struct IODC_INFO {
	char bdev_type;		/* boot device type: seq. or Random acc. */
	unsigned int (*bdev_iodc_entry)(); /* entry to iodc routine */
	unsigned int bdev_HPA;
	unsigned int bdev_SPA;
	unsigned int *bdev_layers;   /* pointer to the layer structure */
	int seq_addr;		    /* seq address on the boot dev device */
}	IODC_INFO;
