/*
 *  linux/fs/filesystems.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  table of configured filesystems
 */

#include <linux/config.h>
#include <linux/fs.h>

#include <linux/minix_fs.h>
#include <linux/ext2_fs.h>
#include <linux/msdos_fs.h>
#include <linux/umsdos_fs.h>
#include <linux/proc_fs.h>
#include <linux/nfs_fs.h>
#include <linux/iso_fs.h>
#include <linux/sysv_fs.h>
#include <linux/hpfs_fs.h>
#include <linux/smb_fs.h>
#include <linux/ncp_fs.h>
#include <linux/affs_fs.h>
#include <linux/ufs_fs.h>
#include <linux/efs_fs.h>
#include <linux/romfs_fs.h>
#include <linux/auto_fs.h>
#include <linux/qnx4_fs.h>
#include <linux/ntfs_fs.h>
#include <linux/hfs_fs.h>
#include <linux/devpts_fs.h>
#include <linux/major.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#ifdef CONFIG_KMOD
#include <linux/kmod.h>
#endif
#include <linux/lockd/bind.h>
#include <linux/lockd/xdr.h>
#include <linux/init.h>
#include <linux/nls.h>


void __init filesystem_setup(void)
{
   
	init_lif_fs();
}

#ifndef CONFIG_NFSD
#ifdef CONFIG_NFSD_MODULE
int (*do_nfsservctl)(int, void *, void *) = NULL;
#endif
int
asmlinkage sys_nfsservctl(int cmd, void *argp, void *resp)
{
#ifndef CONFIG_NFSD_MODULE
	return -ENOSYS;
#else
	int ret = -ENOSYS;
	
	lock_kernel();
	if (do_nfsservctl) {
		ret = do_nfsservctl(cmd, argp, resp);
		goto out;
	}
#ifdef CONFIG_KMOD
	if (request_module ("nfsd") == 0) {
		if (do_nfsservctl)
			ret = do_nfsservctl(cmd, argp, resp);
	}
#endif /* CONFIG_KMOD */
out:
	unlock_kernel();
	return ret;
#endif /* CONFIG_NFSD_MODULE */
}
#endif /* CONFIG_NFSD */
