/*******************************************************************/
/* lif.h                                                           */
/*                                                                 */
/* Definitions of LIF (logical information format) entities        */
/*                                                                 */
/*  Author: J. Curry (leveraged from ISL)                          */
/*                                                                 */
/*  Copyright (C) 1999 by Hewlett-Packard Company                  */
/*******************************************************************/

#define		MAXFILENAME		10
#define		MAXVOLNAME		6
/* Lif addressing unit size in bytes  */
#define 	LIFAU           	256             
/*  Convert lif values from volume label and directory to bytes  */
#define  ATOBY(a)       ( (a) * LIFAU )
/*  Rounds up to the specified boundary - no truncation  */
#define  ROUNDUP(x,y)   ((((x) + ((y) - 1)) / (y)) * (y))

/* LIF Volume Label Format */

struct lvol {
        unsigned short discid;  /* 0..65535 */ /* LIF Identifier */
        char volname[MAXVOLNAME];     /* Volume Label (0-6 ASCII characters) */
        unsigned int dstart;                   /* Directory Start Address */
        unsigned short dummy1;
        unsigned short dummy2;        /* Set to 0 */
        int dsize;                    /* Length of Directory */
        unsigned short version;       /* Version number */
        unsigned short dummy3;        /* Set to 0 */
        int tps;   /* tracks / surface */
        int spm;   /* surface / medium */
        int spt;   /* sector / track */
        unsigned short reserved1[102];   /* 18..119 */
        int iplstart;  /* IPL code location on media */
                       /* Pointer to first byte of SOM header of IPL */
        int iplsize;   /* size of IPL code  */
        int iplentry;   /* entrypoint offset in IPL  */
        unsigned short reserved2[2];
};


/* LIF Directory Entry Format */

struct direntry {
        char fname[MAXFILENAME];   /* File Name (1-10 ASCII characters) */
        unsigned short ftype;      /* File Type */
        int start;                 /* Starting Address */
        int size;                  /* Length of File */
        char date[6];              /* Time of Creation */
        unsigned short lastvolnumber;
        int extension;
};

/* LIF Buffer Information structure */

struct lif_buf_info {
	int max_bytes_offset; 
	int buffer_size;
	int logical_start_addr;
	char *buffer_start;
};
