#ifndef _PARISC_DELAY_H
#define _PARISC_DELAY_H

/*
 * Copyright (C) 1993 Linus Torvalds
 *
 * Delay routines
 */

extern unsigned long loops_per_sec;

extern __inline__ void __delay(unsigned long loops) {
	asm volatile(
	"	.balignl	64,0x34000034
		addib,UV,n      -1,%0,.
		addib,NUV,n     -1,%0,.+8
		nop"
		: "=r" (loops) : "0" (loops));
}

extern __inline__ void __udelay(unsigned long usecs) {
	__delay(usecs * (loops_per_sec / 1000000));
}

extern __inline__ void __const_udelay(unsigned long usecs) {
	__udelay(usecs);
}

#if 0
#define udelay(n) (__builtin_constant_p(n) ? \
	__const_udelay((n) * 0x10c6ul) : \
	__udelay(n))
#else
#define udelay(n) __udelay(n)
#endif

#endif /* defined(_PARISC_DELAY_H) */
