#ifndef ASM_PARISC_GSC_H
#define ASM_PARISC_GSC_H
#ifdef __KERNEL__

#include <linux/types.h>
#include <linux/config.h>

extern   u8 gsc_readb(void *);
extern  u16 gsc_readw(void *);
extern  u32 gsc_readl(void *);
extern void gsc_writeb(u8, void *);
extern void gsc_writew(u16,void *);
extern void gsc_writel(u32,void *);

struct gsc_dev {
	struct gsc_bus	*bus;		/* bus this device is on */
	struct gsc_dev	*next;		/* chain of all devices */
	struct gsc_dev	*next_bus;	/* chain of all devices on a bus */
	struct gsc_dev	*next_submod;	/* chain of all devices on a module */

	unsigned	irq;		/* irq generated by this device */
	void		*hpa;		/* hard physical address */

	u16		hversion;
	u8		spa;		/* SPA requirements */
	u8		type;
	u32		sversion;
};

struct gsc_irq {
	unsigned long txn_addr;	/* IRQ "target" */
	int txn_data;		/* HW "IRQ" */
	int irq;		/* virtual IRQ */
};

extern int gsc_alloc_irq(struct gsc_irq *dev);	/* dev needs an irq */

struct gsc_bus {
	void		*hpa;		/* HPA of device 0, function 0 of this bus */
};

/*
 * There is one pci_dev structure for each slot-number/function-number
 * combination:
 */


struct gsc_dev *gsc_find_device(u16 hversion, struct gsc_dev *from);

#endif /* __KERNEL__ */
#endif /* LINUX_GSC_H */
