#ifndef _ASM_IO_H
#define _ASM_IO_H

#include <linux/types.h>

#define bus_to_virt(a) __va(a)
#define virt_to_bus(a) (unsigned long)__pa(a)
#define virt_to_phys(a) (unsigned long)__pa(a)

#define inb_p inb
#define inw_p inw
#define inl_p inl
#define outb_p outb
#define outw_p outw
#define outl_p outl

extern __inline__ unsigned long readb(unsigned long addr) {
	return *(volatile unsigned char*)addr;
}

extern __inline__ unsigned long readw(unsigned long addr) {
	return *(volatile unsigned short*)addr;
}

extern __inline__ unsigned long readl(unsigned long addr) {
	return *(volatile u32 *)addr;
}

extern __inline__ void writeb(unsigned short b, unsigned long addr) {
	*(volatile unsigned char*)addr = b;
}

extern __inline__ void writew(unsigned short b, unsigned long addr) {
	*(volatile unsigned short*)addr = b;
}

extern __inline__ void writel(u32 b, unsigned long addr) {
	*(volatile u32 *)addr = b;
}



extern u8 inb(unsigned long addr);
extern u16 inw(unsigned long addr);
extern u32 inl(unsigned long addr);

extern void outb(unsigned char b, unsigned long addr);
extern void outw(unsigned short b, unsigned long addr);
extern void outl(u32 b, unsigned long addr);

#endif
