/*******************************************************/
/* iodc.h: include files for iodc driver.              */
/*                                                     */
/*******************************************************/

#define IODC_MAJOR 1       /* Will be the principle major */
#define IODC_DEVS 1        /* one device */
#define IODC_RAHEAD 0      /* */
#define IODC_SIZE 2048     /* */
#define IODC_BLKSIZE 2048  /* 1k blocks */
#define IODC_HARDSECT 2048  /**/

/* any driver specific data structures go below: */

/* Page ZERO constants */
#define         PG0_CONSOLE_DISPLAY             0x3A0
#define         PG0_OFF_IODC_IO                 0x28
#define         PG0_OFF_CLASS                   0x2C
#define         PG0_OFF_HPA                     0x20
#define         PG0_OFF_SPA                     0x24
#define         PG0_OFF_LAYERS                  0x08
#define         PG0_BOOT_DEVICE                 0x3D0

#define         PG0_MEM_PDC_HI                  0x35C
#define         PG0_MEM_PDC_LOW                 0x388

#define         PG0_MEM_CONT_LOW                0x350
#define         PG0_MEM_CONT_HI                 0x340

#define         CL_RANDOM                       1
#define         CL_SEQU                         2

#define     	CONST_2K                        0x800

typedef struct IODC_INFO {
	char bdev_type;		/* boot device type: seq. or Random acc. */
	unsigned int (*bdev_iodc_entry)(); /* entry to iodc routine */
	unsigned int bdev_HPA;
	unsigned int bdev_SPA;
	unsigned int *bdev_layers;   /* pointer to the layer structure */
	int seq_addr;		    /* seq address on the boot dev device */
}	IODC_INFO;


/* defines for the IODC driver specific IOCTL call */

#define IODC_IOC_MAGIC		'I'	/* Not sure if this has to
					 * be unique across all drivers */

/* Only one IOCTL defined. A better way maybe to use _IOR but do no need
 * this currently. */
#define IODC_READ_FILE		_IO(IODC_IOC_MAGIC,0)


/* Not sure if this is the best place for this macros, but this is needed
 * before an IODC call is made
 */

#define SAVE_CRS(crs)	\
	asm("mfctl 24,%0" : "=r" (crs[0])); \
	asm("mfctl 25,%0" : "=r" (crs[1])); \
	asm("mfctl 26,%0" : "=r" (crs[2])); \
	asm("mfctl 27,%0" : "=r" (crs[3])); \
	asm("mfctl 28,%0" : "=r" (crs[4])); \
	asm("mfctl 29,%0" : "=r" (crs[5])); \
	asm("mfctl 30,%0" : "=r" (crs[6])); \
	asm("mfctl 31,%0" : "=r" (crs[7]));

#define RESTORE_CRS(crs) \
	asm("mtctl %0,25" : : "r" (crs[1])); \
	asm("mtctl %0,26" : : "r" (crs[2])); \
	asm("mtctl %0,27" : : "r" (crs[3])); \
	asm("mtctl %0,28" : : "r" (crs[4])); \
	asm("mtctl %0,29" : : "r" (crs[5])); \
	asm("mtctl %0,30" : : "r" (crs[6])); \
	asm("mtctl %0,31" : : "r" (crs[7]));
