#ifndef _PARISC_PDC_H
#define _PARISC_PDC_H


typedef int (*PDC_CALL)(unsigned,...);	/* generic PDC call type */
extern PDC_CALL pdc;			/* pdc-call-variable in setup.c */

/*
    PDC entry points...
*/

#define PDC_POW_FAIL	1		/* perform a power-fail		*/
#define PDC_POW_FAIL_PREPARE	0	/* prepare for powerfail	*/

#define PDC_CHASSIS	2		/* PDC-chassis functions	*/
#define PDC_CHASSIS_DISP	0	/* update chassis display	*/
#define PDC_CHASSIS_WARN	1	/* return chassis warnings	*/
#define PDC_CHASSIS_DISPWARN	2	/* update&return chassis status */

#define PDC_MODEL	4		/* PDC model information call	*/
#define PDC_MODEL_INFO		0	/* returns information 		*/
#define PDC_MODEL_BOOTID	1	/* set the BOOT_ID		*/
#define PDC_MODEL_VERSIONS	2	/* returns cpu-internal versions*/
#define PDC_MODEL_SYSMODEL	3	/* return system model info	*/
#define PDC_MODEL_ENSPEC	4	/* ??? */
#define PDC_MODEL_DISPEC	5	/* ??? */
#define PDC_MODEL_CPU_ID	6	/* returns cpu-id (only newer machines!) */
#define PDC_MODEL_CAPATIB	7	/* returns OS32/OS64-flags	*/
#define PDC_MODEL_GET_BOOT__OP	8	/* returns boot test options	*/
#define PDC_MODEL_SET_BOOT__OP	9	/* set boot test options	*/

#define PDC_CACHE	5		/* return/set cache (& TLB) info*/
#define PDC_CACHE_INFO		0	/* returns information 		*/
#define PDC_CACHE_SET_COH	1	/* set coherence state		*/
#define PDC_CACHE_RET_SPID	2	/* returns space-ID bits	*/

#define PDC_HPA         6       	/* return HPA of processor */
#define PDC_HPA_PROCESSOR       0
#define PDC_HPA_MODULES         1

#define PDC_IODC        8       /* talk to IODC */
#define PDC_IODC_READ           0       /* read IODC entry point */
#define PDC_IODC_NINIT          2       /* non-destructive init */
#define PDC_IODC_DINIT          3       /* destructive init */
#define PDC_IODC_MEMERR         4       /* check for memory errors */
#define PDC_IODC_INDEX_DATA     0       /* get first 16 bytes from mod IODC */
#define PDC_IODC_BUS_ERROR      -4      /* bus error return value */
#define PDC_IODC_INVALID_INDEX  -5      /* invalid index return value */
#define PDC_IODC_COUNT          -6      /* count is too small */

#define	PDC_TOD		9		/* time-of-day clock (TOD) */
#define	PDC_TOD_READ		0	/* read TOD  */
#define	PDC_TOD_WRITE		1	/* write TOD */
#define	PDC_TOD_ITIMER		2	/* calibrate Interval Timer (CR16) */

#define PDC_ADD_VALID	12    		/* Memory validation PDC call */
#define PDC_ADD_VALID_VERIFY  0    	/* Make PDC_ADD_VALID verify region */

#define PDC_BLOCK_TLB	18		/* manage hardware block-TLB	*/
#define PDC_BTLB_INFO		0	/* returns parameter 		*/
#define PDC_BTLB_INSERT		1	/* insert BTLB entry		*/
#define PDC_BTLB_PURGE		2	/* purge BTLB entries 		*/
#define PDC_BTLB_PURGE_ALL	3	/* purge all BTLB entries 	*/

#define PDC_TLB		19		/* manage hardware TLB miss handling */
#define PDC_TLB_INFO		0	/* returns parameter 		*/
#define PDC_TLB_SETUP		1	/* set up miss handling 	*/
			/* PDC_TLB_xxx -> entries: 3,5,7 are also defined !!! */
#define PDC_PAT_CELL             64   /* Interface for gaining and */ 
                                 /* manipulating cell state within PD */
#define PDC_PAT_CELL_RETURN_NUMBER 0   /* Return Cell Number*/
#define PDC_PAT_CELL_RETURN_INFO    1  /* Returns info about Cell */
#define PDC_PAT_CELL_RETURN_MODULE  2    /* Return info about Module */
#define PDC_PAT_CELL_OL_ADD         3    /* On Line addition of a Cell */
#define PDC_PAT_CELL_OL_DELETE      4    /* On Line Deletion of a Cell */
#define PDC_PAT_CELL_OL_POW_ON      5    /* To turn POWER ON for Cell */
#define PDC_PAT_CELL_OL_POW_OFF     6    /* To turn POWER OFF for Cell */
#define PDC_PAT_CELL_OL_CONFIG      7    /* On Line Config Cell */
#define PDC_PAT_CELL_RET_CELL_FROM_LOC    8  /* On Line DeConfig Cell */
#define PDC_PAT_CELL_SET_ATTENTION  9    /* Set Cell Attention indicator */
#define PDC_PAT_CELL_RET_LOC_FROM_CELL  10    /* Get Cell Location */
#define PDC_PAT_CELL_WALK_FABRIC   11    /* Walk the Fabric */
#define PDC_PAT_CELL_GET_RDT_SIZE  12   /* Return Route Distance Table Sizes */
#define PDC_PAT_CELL_GET_RDT       13    /* Return Route Distance Tables */
#define PDC_PAT_CELL_GET_LOCAL_PDH_SZ  14  /* Read Local PDH Buffer Size */
#define PDC_PAT_CELL_SET_LOCAL_PDH  15   /* Write Local PDH Buffer */
#define PDC_PAT_CELL_GET_REMOTE_PDH_SZ  16  /* Return Remote PDH Buffer Size */
#define PDC_PAT_CELL_GET_REMOTE_PDH  17  /* Read Remote PDH Buffer */
#define PDC_PAT_CELL_GET_DBG_INFO  128   /* Return DBG Buffer Info */
#define PDC_PAT_CELL_CHANGE_ALIAS  129  /* Change Non-Equivalent Alias Chacking */
#define PDC_PAT_CELL_SET_FABRIC_REG  140  /* Set Fabric Registration */
#define PDC_PAT_CELL_CLEAR_FABRIC_REG  141  /* Clear Fabric Registration */

#define PDC_PAT_CPU                 67  /* Interface to CPU configuration
                                        * within the protection domain */
#define PDC_PAT_CPU_INFO             0  /* Return CPU config info */
#define PDC_PAT_CPU_DELETE           1  /* Delete CPU */
#define PDC_PAT_CPU_ADD              2  /* Add    CPU */
#define PDC_PAT_CPU_GET_NUMBER       3  /* Return CPU Number */
#define PDC_PAT_CPU_GET_HPA          4  /* Return CPU HPA */
#define PDC_PAT_CPU_STOP             5  /* Stop   CPU */
#define PDC_PAT_CPU_RENDEZVOUS       6  /* Rendezvous CPU */
#define PDC_PAT_CPU_GET_CLOCK_INFO   7  /* Return CPU Clock info */
#define PDC_PAT_CPU_GET_RENDEZVOUS_STATE  8  /* Return Rendezvous State */
#define PDC_PAT_CPU_PLUNGE_FABRIC        9      /* Plunge Fabric */
#define PDC_PAT_CPU_MAN_CACHE_CLEAN   128  /*Manipulate Cache Cleansing Mode */
#define PDC_PAT_CPU_UPDATE_CACHE_CLEANSING  129  /* Manipulate Cache 
#define PDC_SYSTEM_MAP	22		/* find system modules */
#define PDC_FIND_MODULE 	0



/* PDC dependant */
#define PDC_LAN_STATION_ID      138     /* Hversion dependent mechanism for */
#define PDC_LAN_STATION_ID_READ 0       /* getting the lan station address  */

#define	PDC_LAN_STATION_ID_SIZE	6
struct pdc_lan_station_id {	/* PDC_LAN_STATION_ID */
    unsigned char addr[PDC_LAN_STATION_ID_SIZE];
    unsigned char pad0[2];
    int		pad1[30];
};


/* generic error codes returned by all PDC-functions */

#define PDC_WARN            3  /* Call completed with a warning */
#define PDC_REQ_ERR_1       2  /* See above */
#define PDC_REQ_ERR_0       1  /* Call would generate a requestor error */
#define PDC_OK              0  /* Call completed successfully */
#define PDC_BAD_PROC	   -1  /* Called non-existant procedure */
#define PDC_BAD_OPTION     -2  /* Called with non-existant option */
#define PDC_ERROR          -3  /* Call could not complete without an error */
#define PDC_INVALID_ARG   -10  /* Called with an invalid argument */
#define PDC_BUS_POW_WARN  -12  /* Call could not complete in allowed power budget */


/* The following are from the HPUX .h files, and are just for
compatibility */

#define PDC_RET_OK              0  /* Call completed successfully */
#define PDC_RET_NE_PROC -1         /* Non-existent procedure */
#define PDC_RET_NE_OPT  -2
#define PDC_RET_NE_MOD  -5         /* Module not found */

/* Error codes for PDC_ADD_VALID */

#define PDC_ADD_VALID_WARN            3  /* Call completed with a warning */
#define PDC_ADD_VALID_REQ_ERR_1       2  /* See above */
#define PDC_ADD_VALID_REQ_ERR_0       1  /* Call would generate a requestor error */
#define PDC_ADD_VALID_OK              0  /* Call completed successfully */
#define PDC_ADD_VALID_BAD_OPTION     -2  /* Called with non-existant option */
#define PDC_ADD_VALID_ERROR          -3  /* Call could not complete without an error */
#define PDC_ADD_VALID_INVALID_ARG   -10  /* Called with an invalid argument */
#define PDC_ADD_VALID_BUS_POW_WARN  -12  /* Call could not complete in allowed power budget */

/* The PDC_MEM_MAP calls */

#define PDC_MEM_MAP            128
#define PDC_MEM_MAP_HPA                0

/* constants for OS (NVM...) */
#define OS_ID_NONE	0
#define OS_ID_HPUX	1
#define OS_ID_MPEXL	2
#define OS_ID_OSF	3
#define OS_ID_LINUX	OS_ID_HPUX

/* constants for PDC_CHASSIS */
#define OSTAT_OFF                      0
#define OSTAT_FLT                      1 
#define OSTAT_TEST                     2
#define OSTAT_INIT                     3
#define OSTAT_SHUT                     4
#define OSTAT_WARN                     5
#define OSTAT_RUN                      6
#define OSTAT_ON                       7

struct pdc_model {		/* for PDC_MODEL */
	unsigned int hversion;
	unsigned int sversion;
	unsigned int hw_id;
	unsigned int boot_id;
	unsigned int sw_id;
	unsigned int sw_cap;
	unsigned int arch_rev;
	unsigned int pot_key;
	unsigned int curr_key;
	unsigned int pad[32-9];
} __attribute__((aligned(8))) ;


struct pdc_chassis {		/* for PDC_CHASSIS */
	unsigned int warn;
	unsigned int pad[32-1];
} __attribute__((aligned(8))) ;

struct pdc_model_sysmodel {	/* for PDC_MODEL_SYSMODEL */
    unsigned int mod_len;
    unsigned int pad[32-1];
} __attribute__((aligned(8))) ;

struct pdc_model_cpuid	 {	/* for PDC_MODEL_CPU_ID */
    unsigned int cpuid;
    unsigned int pad[32-1];
} __attribute__((aligned(8))) ;

struct pdc_cache_cf {		/* for PDC_CACHE  (I/D-caches) */
    unsigned int cc_alias:4,	/* alias boundaries for virtual adresses   */
		cc_block: 4,	/* to determine most efficient stride */
		cc_line	: 3,	/* maximum amount written back as a result of store (multiple of 16 bytes) */
		cc_pad0 : 2,	/* reserved */
		cc_wt	: 1,	/* 0 = WT-Dcache, 1 = WB-Dcache */
		cc_sh	: 2,	/* 0 = separate I/D-cache, else shared I/D-cache */
		cc_cst  : 3,	/* 0 = incoherent D-cache, 1=coherent D-cache */
		cc_pad1 : 5,	/* reserved */
		cc_assoc: 8;	/* associativity of I/D-cache */
};

struct pdc_tlb_cf {		/* for PDC_CACHE (I/D-TLB's) */
    unsigned int tc_pad0:12,	/* reserved */
		tc_sh	: 2,	/* 0 = separate I/D-TLB, else shared I/D-TLB */
		tc_hv   : 1,	/* HV */
		tc_page : 1,	/* 0 = 2K page-size-machine, 1 = 4k page size */
		tc_cst  : 3,	/* 0 = incoherent operations, else coherent operations */
		tc_aid  : 5,	/* ITLB: width of access ids of processor (encoded!) */
		tc_pad1 : 8;	/* ITLB: width of space-registers (encoded) */
};

struct pdc_cache_info {		/* main-PDC_CACHE-structure (caches & TLB's) */
	/* I-cache */
	unsigned int	ic_size;	/* size in bytes */
	struct pdc_cache_cf ic_conf;	/* configuration */
	unsigned int	ic_base;	/* base-addr */
	unsigned int	ic_stride;
	unsigned int	ic_count;
	unsigned int	ic_loop;
	/* D-cache */
	unsigned int	dc_size;	/* size in bytes */
	struct pdc_cache_cf dc_conf;	/* configuration */
	unsigned int	dc_base;	/* base-addr */
	unsigned int	dc_stride;
	unsigned int	dc_count;
	unsigned int	dc_loop;
	/* Instruction-TLB */
	unsigned int	it_size;	/* number of entries in I-TLB */
	struct pdc_tlb_cf it_conf;	/* I-TLB-configuration */
	unsigned int	it_sp_base;
	unsigned int	it_sp_stride;
	unsigned int	it_sp_count;
	unsigned int	it_off_base;
	unsigned int	it_off_stride;
	unsigned int	it_off_count;
	unsigned int	it_loop;
	/* data-TLB */
	unsigned int	dt_size;	/* number of entries in D-TLB */
	struct pdc_tlb_cf dt_conf;	/* D-TLB-configuration */
	unsigned int	dt_sp_base;
	unsigned int	dt_sp_stride;
	unsigned int	dt_sp_count;
	unsigned int	dt_off_base;
	unsigned int	dt_off_stride;
	unsigned int	dt_off_count;
	unsigned int	dt_loop;
	/* padded to 32 entries... */
	unsigned int 	pad[32-30];
} __attribute__((aligned(8))) ;

struct pdc_hpa {      /* PDC_HPA */
        void *		hpa;
        unsigned int	filler[31];
} __attribute__((aligned(8))) ;

struct pdc_iodc_rtn_block {     /* PDC_IODC */
        unsigned char   hversion_model;
        unsigned char 	hversion;
        unsigned char 	spa;
        unsigned char 	type;
        unsigned int	sversion_rev:4;
        unsigned int	sversion_model:19;
        unsigned int	sversion_opt:8;
        unsigned char	rev;
        unsigned char	dep;
        unsigned char	features;
        unsigned char	filler1;
        unsigned int	checksum:16;
        unsigned int	length:16;
        unsigned int    filler[15];
} __attribute__((aligned(8))) ;


struct pdc_btlb_info {		/* for PDC_BLOCK_TLB (for fixed & variable!) */
    unsigned int pad0: 8,	/* reserved */
		num_i: 8,	/* number of instruction slots */
		num_d: 8,	/* number of data slots */
		num_c: 8;	/* number of combined slots */
} __attribute__((aligned(8))) ;

struct pdc_btlb {	/* PDC_BLOCK_TLB, return of PDC_BTLB_INFO */
	unsigned int min_size;	/* minimum size of BTLB in pages */
	unsigned int max_size;	/* maximum size of BTLB in pages */
	struct pdc_btlb_info finfo;	/* fixed_range_info */
	struct pdc_btlb_info vinfo; /* variable_range_info */
	unsigned int pad[32-4];
} __attribute__((aligned(8))) ;


struct pdc_tlb {		/* for PDC_TLB */
	unsigned int min_size;
	unsigned int max_size;
	unsigned int pad[32-2];
} __attribute__((aligned(8))) ;

struct pdc_system_map { /* PDC_SYTEM_MAP/FIND_MODULE */
        void * mod_addr;
        unsigned int mod_pgs;
        unsigned int add_addrs;
        unsigned int filler[29];
} __attribute__((aligned(8))) ;

/*
 * Device path specifications used by PDC.
 */
struct pdc_module_path {
        char  flags;      /* see bit definitions below */
        char  bc[6];         /* Bus Converter routing info to a specific */
                             /* I/O adaptor (< 0 means none, > 63 resvd) */
        char  mod;           /* fixed field of specified module */
        unsigned int     layers[6];   /* device-specific info (ctlr #, unit # ...) */
} __attribute__((aligned(8))) ;

struct pdc_memory_map_rtn_block {       /* PDC_MEMORY_MAP */
        unsigned int   hpa;                    /* mod's register set address */
        unsigned int   more_pgs;               /* number of additional I/O pgs */
} __attribute__((aligned(8))) ;


/* flags of the device_path (see below) */
#define	PF_AUTOBOOT	0x80
#define	PF_AUTOSEARCH	0x40
#define	PF_TIMER	0x0F
struct device_path {		/* page 1-69 */
	unsigned char flags;	/* flags see above! */
	unsigned char bc[6];	/* bus converter routing info */
	unsigned char mod;
	unsigned int  layers[6];/* device-specific layer-info */
} __attribute__((aligned(8))) ;


struct pz_device {
	struct	device_path dp;	/* see above */
/* struct	iomod *hpa;	 */
	unsigned int hpa;	/* HPA base address */
/* char	*spa;		 */
	unsigned int spa;	/* SPA base address */
/* int	(*iodc_io)(struct iomod*, ...);  */
	unsigned int iodc_io;	/* device entry point */
	short	pad;		/* reserved */
	unsigned short cl_class;/* see below */
}; 

/* cl_class */			/* page 3-33 of IO-Firmware... */
#define	CL_NULL		0	/* invalid */
#define	CL_RANDOM	1	/* random access (as disk) */
#define	CL_SEQU		2	/* sequential access (as tape) */
#define	CL_DUPLEX	7	/* full-duplex point-to-point (RS-232, Net) */
#define	CL_KEYBD	8	/* half-duplex console (HIL Keyboard) */
#define	CL_DISPL	9	/* half-duplex console (display) */
#define	CL_FC		10	/* FiberChannel access media */

#define ENTRY_IO_BOOTIN		0
#define ENTRY_IO_CIN		2
#define ENTRY_IO_COUT		3
#define ENTRY_IO_CLOSE		4
#define ENTRY_IO_GETMSG		9

#define DEVCLASS_RANDOM		1
#define DEVCLASS_SEQU		2
#define DEVCLASS_DUPLEX		7
#define DEVCLASS_KEYBD		8
#define DEVCLASS_DISP		9



/* DEFINITION OF THE ZERO-PAGE (PAG0) */
/* based on work by Jason Eckhardt (jason@equator.com) */

/* #define	PAGE0	((struct zeropage *)0xc0000000) */
#define	PAGE0	((struct zeropage *)0x0) 

#ifdef OUT_ORG_LINUX

struct zeropage {
	/* [0x000] initialize vectors (VEC) */
	int	vec_special;		/* must be zero */
	int	(*vec_pow_fail)(void);	/* power failure handler */
	int	(*vec_toc)(void);
	int	vec_toclen;
	int	(*vec_rendz)(void);
	int	vec_pow_fail_flen;
	int	vec_pad[10];		
	
	/* [0x040] reserved processor dependent */
	int	pad0[112];

	/* [0x200] reserved */
	int	pad1[84];

	/* [0x350] memory configuration (MC) */
	int	memc_cont;		/* contiguous mem size (bytes) */
	int	memc_phsize;		/* physical memory size */
	int	memc_adsize;		/* additional mem size, bytes of SPA space used by PDC */
	int	memc_pad;		/* reserved */

	/* [0x360] various parameters for the boot-CPU */
	unsigned int *mem_booterr[8];	/* ptr to boot errors */
	unsigned int mem_free;		/* first location, where OS can be loaded */
	struct iomod *mem_hpa;		/* HPA of the boot-CPU */
/**/	PDC_CALL mem_pdc;		/* PDC entry point */
	unsigned int mem_10msec;	/* number of clock ticks in 10msec */

	/* [0x390] initial memory module (IMM) */
	struct iomod *imm_hpa;		/* HPA of the IMM */
	int	imm_soft_boot;		/* 0 = was hard boot, 1 = was soft boot */
	int	imm_spa_size;		/* SPA size of the IMM in bytes */
	int	imm_max_mem;		/* bytes of mem in IMM */

	/* [0x3A0] boot console, display device and keyboard */
	struct pz_device mem_cons;	/* description of console device */
	struct pz_device mem_boot;	/* description of boot device */
	struct pz_device mem_kbd;	/* description of keyboard device */

	/* [0x430] reserved */
	int	pad430[116];

	/* [0x600] processor dependent */
	int	pad600[128];
};

#endif /* OUT_ORG_LINUX */

struct zeropage {
	/* [0x000] initialize vectors (VEC) */
	int	vec_special;		/* must be zero */
/* int	(*vec_pow_fail)(void);	 */
	unsigned int vec_pow_fail;        /* powerfail recovery software */
/* int	(*vec_toc)(void); */
	unsigned int vec_toc;
	int	vec_toclen;
/* int	(*vec_rendz)(void); */
	unsigned int vec_rendz;        /* exec'd after Rendezvous Signal */
	int	vec_pow_fail_flen;
	int	vec_pad[10];		
	
	/* [0x040] reserved processor dependent */
	int	pad0[112];

	/* [0x200] reserved */
/* int	pad1[84]; */
	unsigned int iodc_cons_base;
        int iodc_cons_size;
        unsigned int iodc_kbrd_base;
        int iodc_kbrd_size;
        unsigned int iodc_boot_base;
        int iodc_boot_size;
	int  pad1[65];

	/* [0x31C] */
	unsigned int cap_flags;
	unsigned int keybd_exsten[2];
	unsigned int bootd_exsten[2];
	unsigned int consl_exsten[2];
	unsigned int imm_exsten[2];

/** [0x350] memory configuration (MC) **/
	/* [0x340] */
/* int	memc_cont;		* contiguous mem size (bytes) * */
	unsigned int mem_cont0;	/* [0...31] part of bytes of contiguous valid memory */
/* int	memc_phsize;		* physical memory size * */
	unsigned int memc_phsize0;      /* [0...31] part of bytes of valid physical memory */
/* int	memc_adsize;		* additional mem size, bytes of SPA space used by PDC * */
	unsigned int memc_adsize0;      /* [0...31] part of bytes of SPA space used by PDC */
 	int	memc_pad;		/* reserved */ 
	unsigned int memc_cont1;        /* [32...64] part of bytes of contiguous valid memory */
        unsigned int memc_phsize1;      /* [32...64] part of bytes of valid physical memory */
        unsigned int memc_adsize1;      /* [32...64] part of bytes of SPA space used by PDC */
        unsigned int mem_pdc0;  /* [0...31] of pdc entry point */

	/* [0x360] various parameters for the boot-CPU */
/* unsigned int *mem_booterr[8];	ptr to boot errors */ 
	unsigned int mem_booterr[8];	/* ptr to boot errors */
	unsigned int mem_free;		/* first location, where OS can be loaded */
/* struct iomod *mem_hpa;		* HPA of the boot-CPU * */
	unsigned int mem_hpa;   	/* HPA of CPU */
/* 	PDC_CALL mem_pdc;		* PDC entry point * */
	unsigned int mem_pdc1;  /* [32...63] of pdc entry point */
	unsigned int mem_10msec;	/* number of clock ticks in 10msec */

	/* [0x390] initial memory module (IMM) */
/* struct iomod *imm_hpa;		* HPA of the IMM * */
	unsigned int imm_hpa;		/* HPA of the IMM */
	int	imm_soft_boot;		/* 0 = was hard boot, 1 = was soft boot */
	int	imm_spa_size;		/* SPA size of the IMM in bytes */
	int	imm_max_mem;		/* bytes of mem in IMM */

	/* [0x3A0] boot console, display device and keyboard */
	struct pz_device mem_cons;	/* description of console device */
	struct pz_device mem_boot;	/* description of boot device */
	struct pz_device mem_kbd;	/* description of keyboard device */

	/* [0x430] reserved */
	int	pad430[116];

	/* [0x600] processor dependent */
	int	pad600[128];
};




extern void pdc_console_init(void);
extern int  pdc_getc(void);	/* wait for char */
extern void pdc_putc(char);	/* print char */




/* wrapper-functions from pdc.c */

int pdc_add_valid(void *address);
int pdc_hpa_processor(void *address);
int pdc_hpa_modules(void *address);
int pdc_iodc_read(void *address, void *hpa, unsigned int index,
		  void *iodc_data, unsigned int iodc_data_size);
int pdc_system_map_find_mods(void *pdc_mod_info, void *mod_path, int index);
int pdc_model_info(struct pdc_model *model);
int pdc_model_sysmodel(	struct pdc_model_sysmodel *sys_model,
			char  *sys_model_name);
int pdc_model_cpuid( struct pdc_model_cpuid *cpu_id );
int pdc_model_versions( struct pdc_model_cpuid *cpu_id, int id );
int pdc_cache_info( struct pdc_cache_info *cache );
int pdc_btlb_info( struct pdc_btlb *btlb );
int pdc_mem_map_hpa(void *r_addr, void *mod_path);
int pdc_lan_station_id( char *lan_addr, void *net_hpa);

#endif


