/*
 * include/asm-parisc/processor.h
 *
 * Copyright (C) 1994 Linus Torvalds
 */

#ifndef __ASM_PARISC_PROCESSOR_H
#define __ASM_PARISC_PROCESSOR_H

#include <asm/page.h>
#include <asm/pdc.h>

/* Defines for CPU capabilities */

#define TASK_SIZE           (PAGE_OFFSET)
#define TASK_UNMAPPED_BASE  (TASK_SIZE / 3)


/* Routines to detect various CPU and model architectures */

/*  since even on a PARISC-SMP machine every CPU has the same type and speed
    we only save one copy of this information-record.
    In cpu_count the total number of CPUs can be found.  */ 
struct cpuinfo_parisc {   // Information gathered from PDC-calls....
	unsigned	cpu_count;		// number of CPUs in this system
	unsigned	cpu;	// decimal value like 7000, 7100, 7200, 7300, 8000...
	unsigned	cpu_hz;
	unsigned	hversion,sversion;
	unsigned	sw_id;			// the unique S/N every machine has !
	unsigned	model_arch_rev;
	unsigned	cpuid;
	char		sys_model_name[84]; 	// model name from PDC (as: 9000/715)
	char		*model_name;		// model name from hardware.c
	char		*cpu_name,		// PA7xxx or PA8xxx
			*family_name;		// "1.0", "1.1", "2.0"
	unsigned	cpu_revision,	// cpu revision from "return versions"
			boot_rom_version;	// boot-rom revision !!
	unsigned	cpu_shadowregs,		// 1=yes, 0=no
			cpu_category,		// 1=B,   0=A
			cpu_numlevel;		// 0=0, 1=1, 2=1.5, 3=2
	struct pdc_cache_info  cache;		// storage for cache
	struct pdc_btlb   btlb;			// storage for BTLB-info
  // bogomips missing ???
};

extern struct cpuinfo_parisc boot_cpu_data;

#define current_cpu_data boot_cpu_data

/*
 * Start user thread in another space.
 *
 * Note that we set both the iaoq and r31 to the new pc. When
 * the kernel initially calls execve it will return through an
 * rfi path that will use the values in the iaoq. The execve
 * syscall path will return through the gateway page, and
 * that uses r31 to branch to.
 *
 */

#define start_thread(regs, new_pc, new_argenv, ppid, bbprm) do {     \
	extern	unsigned long *linux_gateway_page;	\
                                                        \
        /* set_fs(USER_DS); */                                \
	set_fs(KERNEL_DS); /* done to make sys_open work, we dont really use this feature */ \
        regs->iasq[0] = 0;     	 			\
        regs->iasq[1] = 0;	                        \
        regs->iaoq[0] = new_pc;                         \
        regs->iaoq[1] = new_pc+4;                       \
        regs->ipsw = PSW_W|PSW_C|PSW_I|PSW_Q|PSW_P|PSW_D;     \
        /* regs->gr[30] = ((new_sp)+63)&~63; */              \
	regs->gr[30] = ppid | (((unsigned long)(current)) + TASK_SZ_ALGN); \
        regs->gr[31] = new_pc;                          \
                                                        \
        regs->gr[26] = (ppid | (unsigned long)&linux_gateway_page);    \
        regs->gr[25] = bbprm->argc;                 	\
        regs->gr[24] = new_argenv;                 	\
                                                        \
        regs->cr28 = (unsigned long) current;           \
} while(0)

/*
 * Size of io_bitmap in longwords: 32 is ports 0-0x3ff.
 */
#define IO_BITMAP_SIZE	32

/*
 * Bus types (default is ISA, but people can check others with these..)
 */
extern int EISA_bus;
extern int MCA_bus;

void irq_setup(void);

/* this is integer only, you might want to add floating-point state here.
 *  - prumpf 990430 */

struct thread_struct {
	struct pt_regs	regs;
	unsigned long	*pg_tables;
}; 

#define INIT_MMAP { &init_mm, 0, 0, NULL, PAGE_SHARED, \
                    VM_READ | VM_WRITE | VM_EXEC, 1, NULL, NULL }


extern unsigned long swapper_pg_dir[];

#define INIT_TSS { {			\
	{ 0, 0, 0, 0, 0, 0, 0, 0,	\
	  0, 0, 0, 0, 0, 0, 0, 0,	\
	  0, 0, 0, 0, 0, 0, 0, 0,	\
	  0, 0, 0, 0, 0, 0, 0, 0 },	\
	{ 0, 0, 0, 0, 0, 0, 0, 0 },	\
	{ 0, 0}, { 0, 0}, 0, 0, 0, 0 	\
	}, (unsigned long *)swapper_pg_dir }

typedef struct {
    int seg;  
} mm_segment_t;

#define init_task (init_task_union.task) 
#define init_stack (init_task_union.stack)


/*
 * NOTE! The task struct and the stack go together
 */
#define alloc_task_struct() \
	((struct task_struct *) __get_free_pages(GFP_KERNEL,2))
#define free_task_struct(p)	free_pages((unsigned long)(p),1)

/*
 * Return saved PC of a blocked thread.
 */
extern inline unsigned long thread_saved_pc(struct thread_struct *t)
{
	return 0;
}

#define copy_segments(nr, tsk, mm)	do { } while (0)
#define release_segments(mm)		do { } while (0)
#define forget_segments()		do { } while (0)

/* Forward declaration, a strange C thing */
struct mm_struct;

/* Free all resources held by a thread. */
extern void release_thread(struct task_struct *);
extern int kernel_thread(int (*fn)(void *), void * arg, unsigned long flags);

#endif /* __ASM_PARISC_PROCESSOR_H */
