#ifndef ASMPARISC_SEMAPHORE_HELPER_H
#define ASMPARISC_SEMAPHORE_HELPER_H

#include <linux/linkage.h>

static inline void wake_one_more(struct semaphore * sem)
{
	unsigned long flags;

	spin_lock_irqsave(&semaphore_wake_lock, flags);
	sem->waking++;
	spin_unlock_irqrestore(&semaphore_wake_lock, flags);
}

static inline int waking_non_zero(struct semaphore *sem)
{
        unsigned long flags;
        int ret = 0;
        
        spin_lock_irqsave(&semaphore_wake_lock, flags);
        if (sem->waking > 0) {
                sem->waking--;
                ret = 1;
	}
	spin_unlock_irqrestore(&semaphore_wake_lock, flags);
        return ret;
}

/* JC changed this function to resemble the 2.3 version */
static inline int waking_non_zero_interruptible(struct semaphore *sem, struct task_struct *tsk) 
{
	unsigned long flags;
	int ret = 0;

	spin_lock_irqsave(&semaphore_wake_lock, flags);
	if (sem->waking > 0) {
		sem->waking--;
		ret = 1;
	} else if (signal_pending(tsk)) {
		atomic_inc(&sem->count);
		ret = -EINTR;
	}
	spin_unlock_irqrestore(&semaphore_wake_lock, flags);
	return ret;
}

static inline int waking_non_zero_trylock(struct semaphore *sem)
{ 
        unsigned long flags;
        int ret = 1;

        spin_lock_irqsave(&semaphore_wake_lock, flags);
        if (sem->waking <= 0)
                atomic_inc(&sem->count);
        else {
                sem->waking--;
                ret = 0;
        }
        spin_unlock_irqrestore(&semaphore_wake_lock, flags);
        return ret; 
}

#endif
