#ifndef __ASM_PARISC_SEMAPHORE_H
#define __ASM_PARISC_SEMAPHORE_H

#include <linux/linkage.h>

/*
 * SMP- and interrupt-safe semaphores..
 *
 * (C) Copyright 1996 Linus Torvalds
 */

struct semaphore {
	atomic_t count;
	unsigned long owner, owner_depth;
	int waking;
	struct wait_queue * wait;
};

#define semaphore_owner(sem) \
	((struct task_struct *)((2*PAGE_MASK) & (sem)->owner))

#define MUTEX ((struct semaphore) { ATOMIC_INIT(1), 0, 0, 0, NULL })
#define MUTEX_LOCKED ((struct semaphore) { ATOMIC_INIT(0), 0, 1, 0, NULL })

asmlinkage void __down_failed(void /* special register calling convention */);
asmlinkage int  __down_failed_interruptible(void  /* params in registers */);
asmlinkage void __up_wakeup(void /* special register calling convention */);

extern int  __down_trylock(struct semaphore * sem);


asmlinkage void __down(struct semaphore * sem);
asmlinkage int  __down_interruptible(struct semaphore * sem);
asmlinkage void __up(struct semaphore * sem);

extern spinlock_t semaphore_wake_lock;

extern __inline__ void down(struct semaphore * sem)
{
	if (atomic_dec_return(&sem->count) < 0)
		__down(sem);
}

extern __inline__ int down_interruptible(struct semaphore * sem)
{ 
	int ret = 0;

	if (atomic_dec_return(&sem->count) < 0)
	   ret = __down_interruptible(sem);
	return ret;
}

extern __inline__ void up(struct semaphore * sem)
{
	if (atomic_inc_return(&sem->count) <= 0)
			__up(sem);
}

extern inline int down_trylock(struct semaphore * sem)
{
	int ret = 0;

	if (atomic_dec_return(&sem->count) < 0)
		ret = __down_trylock(sem);
	return ret;
}


#define sema_init(sem, val)	atomic_set(&((sem)->count), (val))

#endif
