#ifndef __PARISC_SYSTEM_H
#define __PARISC_SYSTEM_H

#include <linux/kernel.h>
#include <asm/segment.h>
/* Note: moving the include below down, so that the inline spinlock
   routines can use some of the defines of this file (e.g. __cli).
   Remember that the spinlock functions are now all inline functions
   and NOT defines anymore. This should not affect any files that
   include this file. */
/*#include <asm/spinlock.h> */
#include <asm/psw.h>

struct task_struct;

extern struct task_struct *_switch_to(struct task_struct *, struct task_struct *);

#define switch_to(prev, next, last) do {			\
	(last) = _switch_to(prev, next);			\
} while(0)

#define cli() __asm__ __volatile__("rsm %0,%%r0\n" : : "i" (PSW_I) : "memory" )
#define __cli() cli()
#define sti() __asm__ __volatile__("ssm %0,%%r0\n" : : "i" (PSW_I) : "memory" )
#define __sti() sti()

extern void __inline__ 
__restore_flags(int flags) 
{
    register int _flags = flags;

    __asm__ __volatile__( "mtsm %0" : : "r" (_flags) );
}

#define mfctl(reg)	({		\
	unsigned long cr;		\
	__asm__ __volatile__(		\
		"mfctl " #reg ",%0" :	\
		 "=r" (cr)		\
	);				\
	cr;				\
})

#define mtctl(gr, cr) \
	__asm__ __volatile__("mtctl %0,%1" \
		: /* no outputs */ \
		: "r" (gr), "i" (cr))

#define mfsp(reg)	({		\
	unsigned long cr;		\
	__asm__ __volatile__(		\
		"mfsp " #reg ",%0" :	\
		 "=r" (cr)		\
	);				\
	cr;				\
})

#define mtsp(gr, cr) \
	__asm__ __volatile__("mtsp %0,%1" \
		: /* no outputs */ \
		: "r" (gr), "i" (cr))


#define save_flags(x) \
    __asm__ __volatile__("ssm 0,%0" : "=r" (x) );

#define __save_flags(x) \
    __asm__ __volatile__("ssm 0,%0" : "=r" (x) );

#define restore_flags(flags) __restore_flags(flags)

#define mb()  __asm__ __volatile__ ("sync"  : : :"memory")
#define wmb() mb()

/* Moved this to here so can use __save_flags above, see explanation above */
#include <asm/spinlock.h>
/*
 * struct __xchg_dummy { unsigned long a[100]; };
 * #define __xg(x) ((struct __xchg_dummy *)(x))
 */
#define xchg(ptr,x) \
((__builtin_constant_p((x)) && ((x) == 0)) ? \
 (__typeof__(*(ptr)))__get_and_zero((ptr),sizeof(*(ptr))): \
 (__typeof__(*(ptr)))__xchg((unsigned long)(x),(unsigned long*)(ptr),sizeof(*(ptr))))

/* extern void __xchg_called_with_bad_pointer(void); */

/* The original puffin code has this function in arch/parisc/kernel/setup.c
 * Not sure if it is needed at all, currently here for compilation
 */
static void __xchg_called_with_bad_pointer(void)
{
#ifndef HPCREATEOFFSET
    printk(KERN_EMERG "xchg() called with bad pointer !\n");
#else
#endif HPCREATEOFFSET
}


static __inline__ unsigned long __xchg(unsigned long x, unsigned long *ptr, int size)
{
	unsigned long temp, flags;
	static spinlock_t lock = SPIN_LOCK_UNLOCKED;
	(void) lock;   /* shut gcc up */
	if (size != 4) {
		__xchg_called_with_bad_pointer();
	}
	spin_lock_irqsave(lock, flags);
	temp = *ptr;
	*ptr = x;
	spin_unlock_irqrestore(lock, flags);
	return temp;
}

static __inline__ unsigned long __get_and_zero(void *ptr, int size)
{
	unsigned long x;
	if (size == 8) { /* for 2.0 Wide all ptrs are 8 bytes */
		__asm__("ldcws 0(0,%1), %0"
			: "=r" (x)
			: "r" (ptr));
	} else {
		__xchg_called_with_bad_pointer();
	}
	return x;
}

#endif
