#ifndef __PARISC_UACCESS_H
#define __PARISC_UACCESS_H

/*
 * User space memory access functions
 */
#include <linux/config.h>
#include <linux/sched.h>
#include <asm/page.h>
#include <asm/system.h>

#define VERIFY_READ 0
#define VERIFY_WRITE 1

/*
 * When in doubt, copy shamelessly from i386.
 */
#define MAKE_MM_SEG(s)	((mm_segment_t) { (s) })
#define KERNEL_DS	MAKE_MM_SEG(0xFFFFFFFF)
#define USER_DS		MAKE_MM_SEG(PAGE_OFFSET)

#define segment_eq(a,b)	((a).seg == (b).seg)

#define get_ds()	(KERNEL_DS)
#define get_fs()	(current->addr_limit)
#define set_fs(x)	(current->addr_limit = (x))


unsigned long __generic_copy_to_user(void *, const void *, unsigned long);
unsigned long __generic_copy_from_user(void *, const void *, unsigned long);

long strncpy_from_user(char *dst, const char *src, long count);
long __strncpy_from_user(char *dst, const char *src, long count);
long strlen_user(const char *str);
unsigned long clear_user(void *mem, unsigned long len);
unsigned long __clear_user(void *mem, unsigned long len);

/* these are obviously not sophisticated enough */

#define access_ok(type,addr,size)   (1)		  /*FIXME!*/
#define copy_from_user(to,from,n)   __generic_copy_from_user((void *)(to), (const void *)(from),(unsigned long)(n))
#define __copy_from_user(to,from,n) copy_from_user(to,from,n)
#define copy_to_user(to,from,n)     __generic_copy_to_user((void *)(to), (const void *)(from),(unsigned long)(n))
#define __copy_to_user(to,from,n)   copy_to_user(to,from,n)

extern inline int verify_area(int type, const void * addr,
			      unsigned long size)
{
	/* until we start executing user-space code, it's always OK! =) */
	return 1;
}

/*
 * Exception handling stuff. The following is from i386/uaccess.h, the
 * source of all truth and beauty:
 *
 * The exception table consists of pairs of addresses: the first is the
 * address of an instruction that is allowed to fault, and the second is
 * the address at which the program should continue.  No registers are
 * modified, so it is entirely up to the continuation code to figure out
 * what to do.
 *
 * All the routines below use bits of fixup code that are out of line
 * with the main instruction path.  This means when everything is well,
 * we don't even have to jump over them.  Further, they do not intrude
 * on our cache or tlb entries.
 */

struct exception_table_entry
{
	unsigned long insn, fixup;
};

/* Returns 0 if exception not found and fixup otherwise.  */
extern unsigned long search_exception_table(unsigned long);


#define put_user(x,ptr) ({ *(ptr) = (x); 0;})
#define get_user(x,ptr) ({ (x) = *(ptr); 0;})
#define __put_user(x,ptr) put_user(x,ptr)
#define __get_user(x,ptr) get_user(x,ptr)


unsigned long __generic_copy_to_user(void *, const void *, unsigned long);
unsigned long __generic_copy_from_user(void *, const void *, unsigned long);

long strncpy_from_user(char *dst, const char *src, long count);
long __strncpy_from_user(char *dst, const char *src, long count);
long strlen_user(const char *str);
unsigned long clear_user(void *mem, unsigned long len);
unsigned long __clear_user(void *mem, unsigned long len);


#endif /* __PARISC_UACCESS_H */


