#include <stdio.h>
#include <sys/time.h>
#include <assert.h>
#include "copy-of-som.h"

/*
 * Copyright (C) 1999 Hewlett-Packard Co., see end of file for terms.
 *
 *	What it does
 * Run this on your parisc SOM kernel (vmlinux) and then you can use
 * the hpux boot loader to load it.
 *
 *	Building som_relocate
 * You'll need "copy-of-som.h" to compile this.  If you don't have it,
 * grab a copy from include/linux/som.h and remove the #include directive.
 *
 * Compile with 'gcc -o som_relocate som_relocate.c'.  If you  have GCC
 * preferentially in your $PATH as 'cc', 'make som_relocate' should work
 * too.  You can probably use HP's compilers too but I haven't checked.
 *
 * ******* WARNING ***************
 * This will only work on a big-endian machine.  It's intended for use
 * on HP-UX for now, and Linux/parisc when that's available.
 * *******************************
 *
 *	Using som_relocate
 * Run this on your SOM vmlinux like this: 'som_relocate vmlinux' using
 * the path to your parisc Linux kernel.  'vmlinux' is modified in place,
 * so you need to have write permissions.  The modified file can be booted
 * by the standard HP-UX boot loader.  Here's what it looks like
 * when interacting with the boot ROM:
 *
 * ISL>					# the normal HP-UX boot prompt
 *
 * ISL> hpux /boot/vmlinux		# Use your path to vmlinux here
 *
 *
 * You can run this over and over without ill effect on the same
 * kernel image.
 *
 * Enjoy,
 *
 *				-Paul Bame <bame@fc.hp.com>
 */

/* relocate address to where it'll live physically */
#define RELOCATE(x)		x &= ~0xC0000000

int
main(int argc, char *argv[])
{
    FILE *f;
    struct som_hdr sh;
    struct som_exec_auxhdr aux;

    printf("$Id: som_relocate.c,v 0.1 1999/10/26 16:46:03 bame Exp $\nCopyright (C) 1999 Hewlett-Packard Co.\n");

    if (argc != 2)
    {
	fprintf(stderr, "Usage: %s <SOM-vmlinux>\n", argv[0]);
	return 2;
    }

    if ((f = fopen(argv[1], "rb+")) == NULL)
    {
	perror(argv[1]);
	return 3;
    }

    /* read the SOM header */
    if (fread(&sh, sizeof sh, 1, f) != 1)
    {
	perror("fread()");
	return 3;
    }

    /* hack it */
    printf("entry_space 0x%08x\n", sh.entry_space);
    printf("entry_subspace 0x%08x\n", sh.entry_subspace);
    printf("RELOCATE entry_offset 0x%08x\n", sh.entry_offset);	/********/
    RELOCATE(sh.entry_offset);
    printf("aux_header_location 0x%08x\n", sh.aux_header_location);
    printf("aux_header_size %d\n", sh.aux_header_size);

    /* write it */
    rewind(f);
    fwrite(&sh, sizeof sh, 1, f);

    /* read the aux header */
    fseek(f, sh.aux_header_location, SEEK_SET);
    fread(&aux, sizeof aux, 1, f);
    printf("RELOCATE aux.exec_tmem 0x%08x\n", aux.exec_tmem);
    RELOCATE(aux.exec_tmem);
    printf("aux.exec_tsize %d\n", aux.exec_tsize);
    printf("RELOCATE aux.exec_dmem 0x%08x\n", aux.exec_dmem);
    RELOCATE(aux.exec_dmem);
    printf("aux.exec_dsize %d\n", aux.exec_dsize);
    printf("RELOCATE aux.exec_entry 0x%08x\n", aux.exec_entry);
    RELOCATE(aux.exec_entry);

    /* write it */
    fseek(f, sh.aux_header_location, SEEK_SET);
    fwrite(&aux, sizeof aux, 1, f);

    fclose(f);
    return 0;
}
/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    For more information about this program, contact the Puffin group
 *    at parisc-linux@thepuffingroup.com or Paul Bame, <bame@fc.hp.com>
 */
