#include "headers.h"
#include "syscall.h"

long open(const char *filename, int flags, int mode)
{
	return SYSCALL3(5, filename, flags, mode);
}


long close(unsigned int fd)
{
	return SYSCALL1(6, fd);
}

long write(unsigned int fd, const char *buf, unsigned int len)
{
	return SYSCALL3(4, fd, buf, len);
}

long read(unsigned int fd, char *buf, unsigned int len)
{
	return SYSCALL3(3, fd, buf, len);
}

long ftruncate(unsigned int fd, unsigned long len)
{
	return SYSCALL2(93, fd, len);
}
